# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetDiscovererResult',
    'AwaitableGetDiscovererResult',
    'get_discoverer',
    'get_discoverer_output',
]

@pulumi.output_type
class GetDiscovererResult:
    def __init__(__self__, cross_account=None, description=None, discoverer_arn=None, discoverer_id=None, state=None, tags=None):
        if cross_account and not isinstance(cross_account, bool):
            raise TypeError("Expected argument 'cross_account' to be a bool")
        pulumi.set(__self__, "cross_account", cross_account)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if discoverer_arn and not isinstance(discoverer_arn, str):
            raise TypeError("Expected argument 'discoverer_arn' to be a str")
        pulumi.set(__self__, "discoverer_arn", discoverer_arn)
        if discoverer_id and not isinstance(discoverer_id, str):
            raise TypeError("Expected argument 'discoverer_id' to be a str")
        pulumi.set(__self__, "discoverer_id", discoverer_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="crossAccount")
    def cross_account(self) -> Optional[bool]:
        """
        Defines whether event schemas from other accounts are discovered. Default is True.
        """
        return pulumi.get(self, "cross_account")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        A description for the discoverer.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="discovererArn")
    def discoverer_arn(self) -> Optional[str]:
        """
        The ARN of the discoverer.
        """
        return pulumi.get(self, "discoverer_arn")

    @property
    @pulumi.getter(name="discovererId")
    def discoverer_id(self) -> Optional[str]:
        """
        The Id of the discoverer.
        """
        return pulumi.get(self, "discoverer_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Defines the current state of the discoverer.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Tags associated with the resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDiscovererResult(GetDiscovererResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDiscovererResult(
            cross_account=self.cross_account,
            description=self.description,
            discoverer_arn=self.discoverer_arn,
            discoverer_id=self.discoverer_id,
            state=self.state,
            tags=self.tags)


def get_discoverer(discoverer_arn: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDiscovererResult:
    """
    Resource Type definition for AWS::EventSchemas::Discoverer


    :param str discoverer_arn: The ARN of the discoverer.
    """
    __args__ = dict()
    __args__['discovererArn'] = discoverer_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:eventschemas:getDiscoverer', __args__, opts=opts, typ=GetDiscovererResult).value

    return AwaitableGetDiscovererResult(
        cross_account=pulumi.get(__ret__, 'cross_account'),
        description=pulumi.get(__ret__, 'description'),
        discoverer_arn=pulumi.get(__ret__, 'discoverer_arn'),
        discoverer_id=pulumi.get(__ret__, 'discoverer_id'),
        state=pulumi.get(__ret__, 'state'),
        tags=pulumi.get(__ret__, 'tags'))
def get_discoverer_output(discoverer_arn: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDiscovererResult]:
    """
    Resource Type definition for AWS::EventSchemas::Discoverer


    :param str discoverer_arn: The ARN of the discoverer.
    """
    __args__ = dict()
    __args__['discovererArn'] = discoverer_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:eventschemas:getDiscoverer', __args__, opts=opts, typ=GetDiscovererResult)
    return __ret__.apply(lambda __response__: GetDiscovererResult(
        cross_account=pulumi.get(__response__, 'cross_account'),
        description=pulumi.get(__response__, 'description'),
        discoverer_arn=pulumi.get(__response__, 'discoverer_arn'),
        discoverer_id=pulumi.get(__response__, 'discoverer_id'),
        state=pulumi.get(__response__, 'state'),
        tags=pulumi.get(__response__, 'tags')))
