# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ConnectionApiKeyAuthParametersArgs',
    'ConnectionApiKeyAuthParametersArgsDict',
    'ConnectionAuthParametersArgs',
    'ConnectionAuthParametersArgsDict',
    'ConnectionBasicAuthParametersArgs',
    'ConnectionBasicAuthParametersArgsDict',
    'ConnectionClientParametersArgs',
    'ConnectionClientParametersArgsDict',
    'ConnectionHttpParametersArgs',
    'ConnectionHttpParametersArgsDict',
    'ConnectionOAuthParametersArgs',
    'ConnectionOAuthParametersArgsDict',
    'ConnectionParameterArgs',
    'ConnectionParameterArgsDict',
    'DeadLetterConfigPropertiesArgs',
    'DeadLetterConfigPropertiesArgsDict',
    'EndpointEventBusArgs',
    'EndpointEventBusArgsDict',
    'EndpointFailoverConfigArgs',
    'EndpointFailoverConfigArgsDict',
    'EndpointPrimaryArgs',
    'EndpointPrimaryArgsDict',
    'EndpointReplicationConfigArgs',
    'EndpointReplicationConfigArgsDict',
    'EndpointRoutingConfigArgs',
    'EndpointRoutingConfigArgsDict',
    'EndpointSecondaryArgs',
    'EndpointSecondaryArgsDict',
    'RuleAppSyncParametersArgs',
    'RuleAppSyncParametersArgsDict',
    'RuleAwsVpcConfigurationArgs',
    'RuleAwsVpcConfigurationArgsDict',
    'RuleBatchArrayPropertiesArgs',
    'RuleBatchArrayPropertiesArgsDict',
    'RuleBatchParametersArgs',
    'RuleBatchParametersArgsDict',
    'RuleBatchRetryStrategyArgs',
    'RuleBatchRetryStrategyArgsDict',
    'RuleCapacityProviderStrategyItemArgs',
    'RuleCapacityProviderStrategyItemArgsDict',
    'RuleDeadLetterConfigArgs',
    'RuleDeadLetterConfigArgsDict',
    'RuleEcsParametersArgs',
    'RuleEcsParametersArgsDict',
    'RuleHttpParametersArgs',
    'RuleHttpParametersArgsDict',
    'RuleInputTransformerArgs',
    'RuleInputTransformerArgsDict',
    'RuleKinesisParametersArgs',
    'RuleKinesisParametersArgsDict',
    'RuleNetworkConfigurationArgs',
    'RuleNetworkConfigurationArgsDict',
    'RulePlacementConstraintArgs',
    'RulePlacementConstraintArgsDict',
    'RulePlacementStrategyArgs',
    'RulePlacementStrategyArgsDict',
    'RuleRedshiftDataParametersArgs',
    'RuleRedshiftDataParametersArgsDict',
    'RuleRetryPolicyArgs',
    'RuleRetryPolicyArgsDict',
    'RuleRunCommandParametersArgs',
    'RuleRunCommandParametersArgsDict',
    'RuleRunCommandTargetArgs',
    'RuleRunCommandTargetArgsDict',
    'RuleSageMakerPipelineParametersArgs',
    'RuleSageMakerPipelineParametersArgsDict',
    'RuleSageMakerPipelineParameterArgs',
    'RuleSageMakerPipelineParameterArgsDict',
    'RuleSqsParametersArgs',
    'RuleSqsParametersArgsDict',
    'RuleTagArgs',
    'RuleTagArgsDict',
    'RuleTargetArgs',
    'RuleTargetArgsDict',
]

MYPY = False

if not MYPY:
    class ConnectionApiKeyAuthParametersArgsDict(TypedDict):
        api_key_name: pulumi.Input[str]
        """
        The name of the API key to use for authorization.
        """
        api_key_value: pulumi.Input[str]
        """
        The value for the API key to use for authorization.
        """
elif False:
    ConnectionApiKeyAuthParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionApiKeyAuthParametersArgs:
    def __init__(__self__, *,
                 api_key_name: pulumi.Input[str],
                 api_key_value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] api_key_name: The name of the API key to use for authorization.
        :param pulumi.Input[str] api_key_value: The value for the API key to use for authorization.
        """
        pulumi.set(__self__, "api_key_name", api_key_name)
        pulumi.set(__self__, "api_key_value", api_key_value)

    @property
    @pulumi.getter(name="apiKeyName")
    def api_key_name(self) -> pulumi.Input[str]:
        """
        The name of the API key to use for authorization.
        """
        return pulumi.get(self, "api_key_name")

    @api_key_name.setter
    def api_key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_key_name", value)

    @property
    @pulumi.getter(name="apiKeyValue")
    def api_key_value(self) -> pulumi.Input[str]:
        """
        The value for the API key to use for authorization.
        """
        return pulumi.get(self, "api_key_value")

    @api_key_value.setter
    def api_key_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_key_value", value)


if not MYPY:
    class ConnectionAuthParametersArgsDict(TypedDict):
        api_key_auth_parameters: NotRequired[pulumi.Input['ConnectionApiKeyAuthParametersArgsDict']]
        """
        The API Key parameters to use for authorization.
        """
        basic_auth_parameters: NotRequired[pulumi.Input['ConnectionBasicAuthParametersArgsDict']]
        """
        The authorization parameters for Basic authorization.
        """
        invocation_http_parameters: NotRequired[pulumi.Input['ConnectionHttpParametersArgsDict']]
        """
        Additional parameters for the connection that are passed through with every invocation to the HTTP endpoint.
        """
        o_auth_parameters: NotRequired[pulumi.Input['ConnectionOAuthParametersArgsDict']]
        """
        The OAuth parameters to use for authorization.
        """
elif False:
    ConnectionAuthParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionAuthParametersArgs:
    def __init__(__self__, *,
                 api_key_auth_parameters: Optional[pulumi.Input['ConnectionApiKeyAuthParametersArgs']] = None,
                 basic_auth_parameters: Optional[pulumi.Input['ConnectionBasicAuthParametersArgs']] = None,
                 invocation_http_parameters: Optional[pulumi.Input['ConnectionHttpParametersArgs']] = None,
                 o_auth_parameters: Optional[pulumi.Input['ConnectionOAuthParametersArgs']] = None):
        """
        :param pulumi.Input['ConnectionApiKeyAuthParametersArgs'] api_key_auth_parameters: The API Key parameters to use for authorization.
        :param pulumi.Input['ConnectionBasicAuthParametersArgs'] basic_auth_parameters: The authorization parameters for Basic authorization.
        :param pulumi.Input['ConnectionHttpParametersArgs'] invocation_http_parameters: Additional parameters for the connection that are passed through with every invocation to the HTTP endpoint.
        :param pulumi.Input['ConnectionOAuthParametersArgs'] o_auth_parameters: The OAuth parameters to use for authorization.
        """
        if api_key_auth_parameters is not None:
            pulumi.set(__self__, "api_key_auth_parameters", api_key_auth_parameters)
        if basic_auth_parameters is not None:
            pulumi.set(__self__, "basic_auth_parameters", basic_auth_parameters)
        if invocation_http_parameters is not None:
            pulumi.set(__self__, "invocation_http_parameters", invocation_http_parameters)
        if o_auth_parameters is not None:
            pulumi.set(__self__, "o_auth_parameters", o_auth_parameters)

    @property
    @pulumi.getter(name="apiKeyAuthParameters")
    def api_key_auth_parameters(self) -> Optional[pulumi.Input['ConnectionApiKeyAuthParametersArgs']]:
        """
        The API Key parameters to use for authorization.
        """
        return pulumi.get(self, "api_key_auth_parameters")

    @api_key_auth_parameters.setter
    def api_key_auth_parameters(self, value: Optional[pulumi.Input['ConnectionApiKeyAuthParametersArgs']]):
        pulumi.set(self, "api_key_auth_parameters", value)

    @property
    @pulumi.getter(name="basicAuthParameters")
    def basic_auth_parameters(self) -> Optional[pulumi.Input['ConnectionBasicAuthParametersArgs']]:
        """
        The authorization parameters for Basic authorization.
        """
        return pulumi.get(self, "basic_auth_parameters")

    @basic_auth_parameters.setter
    def basic_auth_parameters(self, value: Optional[pulumi.Input['ConnectionBasicAuthParametersArgs']]):
        pulumi.set(self, "basic_auth_parameters", value)

    @property
    @pulumi.getter(name="invocationHttpParameters")
    def invocation_http_parameters(self) -> Optional[pulumi.Input['ConnectionHttpParametersArgs']]:
        """
        Additional parameters for the connection that are passed through with every invocation to the HTTP endpoint.
        """
        return pulumi.get(self, "invocation_http_parameters")

    @invocation_http_parameters.setter
    def invocation_http_parameters(self, value: Optional[pulumi.Input['ConnectionHttpParametersArgs']]):
        pulumi.set(self, "invocation_http_parameters", value)

    @property
    @pulumi.getter(name="oAuthParameters")
    def o_auth_parameters(self) -> Optional[pulumi.Input['ConnectionOAuthParametersArgs']]:
        """
        The OAuth parameters to use for authorization.
        """
        return pulumi.get(self, "o_auth_parameters")

    @o_auth_parameters.setter
    def o_auth_parameters(self, value: Optional[pulumi.Input['ConnectionOAuthParametersArgs']]):
        pulumi.set(self, "o_auth_parameters", value)


if not MYPY:
    class ConnectionBasicAuthParametersArgsDict(TypedDict):
        password: pulumi.Input[str]
        """
        The password associated with the user name to use for Basic authorization.
        """
        username: pulumi.Input[str]
        """
        The user name to use for Basic authorization.
        """
elif False:
    ConnectionBasicAuthParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionBasicAuthParametersArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        :param pulumi.Input[str] password: The password associated with the user name to use for Basic authorization.
        :param pulumi.Input[str] username: The user name to use for Basic authorization.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The password associated with the user name to use for Basic authorization.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        The user name to use for Basic authorization.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


if not MYPY:
    class ConnectionClientParametersArgsDict(TypedDict):
        client_id: pulumi.Input[str]
        """
        The client ID to use for OAuth authorization.
        """
        client_secret: pulumi.Input[str]
        """
        The client secret assciated with the client ID to use for OAuth authorization.
        """
elif False:
    ConnectionClientParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionClientParametersArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[str],
                 client_secret: pulumi.Input[str]):
        """
        :param pulumi.Input[str] client_id: The client ID to use for OAuth authorization.
        :param pulumi.Input[str] client_secret: The client secret assciated with the client ID to use for OAuth authorization.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        The client ID to use for OAuth authorization.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Input[str]:
        """
        The client secret assciated with the client ID to use for OAuth authorization.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_secret", value)


if not MYPY:
    class ConnectionHttpParametersArgsDict(TypedDict):
        body_parameters: NotRequired[pulumi.Input[Sequence[pulumi.Input['ConnectionParameterArgsDict']]]]
        """
        Contains additional body string parameters for the connection.
        """
        header_parameters: NotRequired[pulumi.Input[Sequence[pulumi.Input['ConnectionParameterArgsDict']]]]
        """
        Contains additional header parameters for the connection.
        """
        query_string_parameters: NotRequired[pulumi.Input[Sequence[pulumi.Input['ConnectionParameterArgsDict']]]]
        """
        Contains additional query string parameters for the connection.
        """
elif False:
    ConnectionHttpParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionHttpParametersArgs:
    def __init__(__self__, *,
                 body_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionParameterArgs']]]] = None,
                 header_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionParameterArgs']]]] = None,
                 query_string_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionParameterArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionParameterArgs']]] body_parameters: Contains additional body string parameters for the connection.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionParameterArgs']]] header_parameters: Contains additional header parameters for the connection.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionParameterArgs']]] query_string_parameters: Contains additional query string parameters for the connection.
        """
        if body_parameters is not None:
            pulumi.set(__self__, "body_parameters", body_parameters)
        if header_parameters is not None:
            pulumi.set(__self__, "header_parameters", header_parameters)
        if query_string_parameters is not None:
            pulumi.set(__self__, "query_string_parameters", query_string_parameters)

    @property
    @pulumi.getter(name="bodyParameters")
    def body_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionParameterArgs']]]]:
        """
        Contains additional body string parameters for the connection.
        """
        return pulumi.get(self, "body_parameters")

    @body_parameters.setter
    def body_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionParameterArgs']]]]):
        pulumi.set(self, "body_parameters", value)

    @property
    @pulumi.getter(name="headerParameters")
    def header_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionParameterArgs']]]]:
        """
        Contains additional header parameters for the connection.
        """
        return pulumi.get(self, "header_parameters")

    @header_parameters.setter
    def header_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionParameterArgs']]]]):
        pulumi.set(self, "header_parameters", value)

    @property
    @pulumi.getter(name="queryStringParameters")
    def query_string_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionParameterArgs']]]]:
        """
        Contains additional query string parameters for the connection.
        """
        return pulumi.get(self, "query_string_parameters")

    @query_string_parameters.setter
    def query_string_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionParameterArgs']]]]):
        pulumi.set(self, "query_string_parameters", value)


if not MYPY:
    class ConnectionOAuthParametersArgsDict(TypedDict):
        authorization_endpoint: pulumi.Input[str]
        """
        The URL to the authorization endpoint when OAuth is specified as the authorization type.
        """
        client_parameters: pulumi.Input['ConnectionClientParametersArgsDict']
        """
        A `CreateConnectionOAuthClientRequestParameters` object that contains the client parameters for OAuth authorization.
        """
        http_method: pulumi.Input['ConnectionOAuthParametersHttpMethod']
        """
        The method to use for the authorization request.
        """
        o_auth_http_parameters: NotRequired[pulumi.Input['ConnectionHttpParametersArgsDict']]
        """
        A `ConnectionHttpParameters` object that contains details about the additional parameters to use for the connection.
        """
elif False:
    ConnectionOAuthParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionOAuthParametersArgs:
    def __init__(__self__, *,
                 authorization_endpoint: pulumi.Input[str],
                 client_parameters: pulumi.Input['ConnectionClientParametersArgs'],
                 http_method: pulumi.Input['ConnectionOAuthParametersHttpMethod'],
                 o_auth_http_parameters: Optional[pulumi.Input['ConnectionHttpParametersArgs']] = None):
        """
        :param pulumi.Input[str] authorization_endpoint: The URL to the authorization endpoint when OAuth is specified as the authorization type.
        :param pulumi.Input['ConnectionClientParametersArgs'] client_parameters: A `CreateConnectionOAuthClientRequestParameters` object that contains the client parameters for OAuth authorization.
        :param pulumi.Input['ConnectionOAuthParametersHttpMethod'] http_method: The method to use for the authorization request.
        :param pulumi.Input['ConnectionHttpParametersArgs'] o_auth_http_parameters: A `ConnectionHttpParameters` object that contains details about the additional parameters to use for the connection.
        """
        pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        pulumi.set(__self__, "client_parameters", client_parameters)
        pulumi.set(__self__, "http_method", http_method)
        if o_auth_http_parameters is not None:
            pulumi.set(__self__, "o_auth_http_parameters", o_auth_http_parameters)

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> pulumi.Input[str]:
        """
        The URL to the authorization endpoint when OAuth is specified as the authorization type.
        """
        return pulumi.get(self, "authorization_endpoint")

    @authorization_endpoint.setter
    def authorization_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "authorization_endpoint", value)

    @property
    @pulumi.getter(name="clientParameters")
    def client_parameters(self) -> pulumi.Input['ConnectionClientParametersArgs']:
        """
        A `CreateConnectionOAuthClientRequestParameters` object that contains the client parameters for OAuth authorization.
        """
        return pulumi.get(self, "client_parameters")

    @client_parameters.setter
    def client_parameters(self, value: pulumi.Input['ConnectionClientParametersArgs']):
        pulumi.set(self, "client_parameters", value)

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> pulumi.Input['ConnectionOAuthParametersHttpMethod']:
        """
        The method to use for the authorization request.
        """
        return pulumi.get(self, "http_method")

    @http_method.setter
    def http_method(self, value: pulumi.Input['ConnectionOAuthParametersHttpMethod']):
        pulumi.set(self, "http_method", value)

    @property
    @pulumi.getter(name="oAuthHttpParameters")
    def o_auth_http_parameters(self) -> Optional[pulumi.Input['ConnectionHttpParametersArgs']]:
        """
        A `ConnectionHttpParameters` object that contains details about the additional parameters to use for the connection.
        """
        return pulumi.get(self, "o_auth_http_parameters")

    @o_auth_http_parameters.setter
    def o_auth_http_parameters(self, value: Optional[pulumi.Input['ConnectionHttpParametersArgs']]):
        pulumi.set(self, "o_auth_http_parameters", value)


if not MYPY:
    class ConnectionParameterArgsDict(TypedDict):
        key: pulumi.Input[str]
        """
        The key for a query string parameter.
        """
        value: pulumi.Input[str]
        """
        The value associated with the key for the query string parameter.
        """
        is_value_secret: NotRequired[pulumi.Input[bool]]
        """
        Specifies whether the value is secret.
        """
elif False:
    ConnectionParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionParameterArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str],
                 is_value_secret: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] key: The key for a query string parameter.
        :param pulumi.Input[str] value: The value associated with the key for the query string parameter.
        :param pulumi.Input[bool] is_value_secret: Specifies whether the value is secret.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)
        if is_value_secret is not None:
            pulumi.set(__self__, "is_value_secret", is_value_secret)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key for a query string parameter.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value associated with the key for the query string parameter.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="isValueSecret")
    def is_value_secret(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the value is secret.
        """
        return pulumi.get(self, "is_value_secret")

    @is_value_secret.setter
    def is_value_secret(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_value_secret", value)


if not MYPY:
    class DeadLetterConfigPropertiesArgsDict(TypedDict):
        """
        Dead Letter Queue for the event bus.
        """
        arn: NotRequired[pulumi.Input[str]]
        """
        The ARN of the SQS queue specified as the target for the dead-letter queue.
        """
elif False:
    DeadLetterConfigPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeadLetterConfigPropertiesArgs:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None):
        """
        Dead Letter Queue for the event bus.
        :param pulumi.Input[str] arn: The ARN of the SQS queue specified as the target for the dead-letter queue.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the SQS queue specified as the target for the dead-letter queue.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)


if not MYPY:
    class EndpointEventBusArgsDict(TypedDict):
        event_bus_arn: pulumi.Input[str]
elif False:
    EndpointEventBusArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointEventBusArgs:
    def __init__(__self__, *,
                 event_bus_arn: pulumi.Input[str]):
        pulumi.set(__self__, "event_bus_arn", event_bus_arn)

    @property
    @pulumi.getter(name="eventBusArn")
    def event_bus_arn(self) -> pulumi.Input[str]:
        return pulumi.get(self, "event_bus_arn")

    @event_bus_arn.setter
    def event_bus_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "event_bus_arn", value)


if not MYPY:
    class EndpointFailoverConfigArgsDict(TypedDict):
        primary: pulumi.Input['EndpointPrimaryArgsDict']
        """
        The main Region of the endpoint.
        """
        secondary: pulumi.Input['EndpointSecondaryArgsDict']
        """
        The Region that events are routed to when failover is triggered or event replication is enabled.
        """
elif False:
    EndpointFailoverConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointFailoverConfigArgs:
    def __init__(__self__, *,
                 primary: pulumi.Input['EndpointPrimaryArgs'],
                 secondary: pulumi.Input['EndpointSecondaryArgs']):
        """
        :param pulumi.Input['EndpointPrimaryArgs'] primary: The main Region of the endpoint.
        :param pulumi.Input['EndpointSecondaryArgs'] secondary: The Region that events are routed to when failover is triggered or event replication is enabled.
        """
        pulumi.set(__self__, "primary", primary)
        pulumi.set(__self__, "secondary", secondary)

    @property
    @pulumi.getter
    def primary(self) -> pulumi.Input['EndpointPrimaryArgs']:
        """
        The main Region of the endpoint.
        """
        return pulumi.get(self, "primary")

    @primary.setter
    def primary(self, value: pulumi.Input['EndpointPrimaryArgs']):
        pulumi.set(self, "primary", value)

    @property
    @pulumi.getter
    def secondary(self) -> pulumi.Input['EndpointSecondaryArgs']:
        """
        The Region that events are routed to when failover is triggered or event replication is enabled.
        """
        return pulumi.get(self, "secondary")

    @secondary.setter
    def secondary(self, value: pulumi.Input['EndpointSecondaryArgs']):
        pulumi.set(self, "secondary", value)


if not MYPY:
    class EndpointPrimaryArgsDict(TypedDict):
        health_check: pulumi.Input[str]
        """
        The ARN of the health check used by the endpoint to determine whether failover is triggered.
        """
elif False:
    EndpointPrimaryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointPrimaryArgs:
    def __init__(__self__, *,
                 health_check: pulumi.Input[str]):
        """
        :param pulumi.Input[str] health_check: The ARN of the health check used by the endpoint to determine whether failover is triggered.
        """
        pulumi.set(__self__, "health_check", health_check)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> pulumi.Input[str]:
        """
        The ARN of the health check used by the endpoint to determine whether failover is triggered.
        """
        return pulumi.get(self, "health_check")

    @health_check.setter
    def health_check(self, value: pulumi.Input[str]):
        pulumi.set(self, "health_check", value)


if not MYPY:
    class EndpointReplicationConfigArgsDict(TypedDict):
        state: pulumi.Input['EndpointReplicationState']
        """
        The state of event replication.
        """
elif False:
    EndpointReplicationConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointReplicationConfigArgs:
    def __init__(__self__, *,
                 state: pulumi.Input['EndpointReplicationState']):
        """
        :param pulumi.Input['EndpointReplicationState'] state: The state of event replication.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> pulumi.Input['EndpointReplicationState']:
        """
        The state of event replication.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: pulumi.Input['EndpointReplicationState']):
        pulumi.set(self, "state", value)


if not MYPY:
    class EndpointRoutingConfigArgsDict(TypedDict):
        failover_config: pulumi.Input['EndpointFailoverConfigArgsDict']
        """
        The failover configuration for an endpoint. This includes what triggers failover and what happens when it's triggered.
        """
elif False:
    EndpointRoutingConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointRoutingConfigArgs:
    def __init__(__self__, *,
                 failover_config: pulumi.Input['EndpointFailoverConfigArgs']):
        """
        :param pulumi.Input['EndpointFailoverConfigArgs'] failover_config: The failover configuration for an endpoint. This includes what triggers failover and what happens when it's triggered.
        """
        pulumi.set(__self__, "failover_config", failover_config)

    @property
    @pulumi.getter(name="failoverConfig")
    def failover_config(self) -> pulumi.Input['EndpointFailoverConfigArgs']:
        """
        The failover configuration for an endpoint. This includes what triggers failover and what happens when it's triggered.
        """
        return pulumi.get(self, "failover_config")

    @failover_config.setter
    def failover_config(self, value: pulumi.Input['EndpointFailoverConfigArgs']):
        pulumi.set(self, "failover_config", value)


if not MYPY:
    class EndpointSecondaryArgsDict(TypedDict):
        route: pulumi.Input[str]
        """
        Defines the secondary Region.
        """
elif False:
    EndpointSecondaryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class EndpointSecondaryArgs:
    def __init__(__self__, *,
                 route: pulumi.Input[str]):
        """
        :param pulumi.Input[str] route: Defines the secondary Region.
        """
        pulumi.set(__self__, "route", route)

    @property
    @pulumi.getter
    def route(self) -> pulumi.Input[str]:
        """
        Defines the secondary Region.
        """
        return pulumi.get(self, "route")

    @route.setter
    def route(self, value: pulumi.Input[str]):
        pulumi.set(self, "route", value)


if not MYPY:
    class RuleAppSyncParametersArgsDict(TypedDict):
        graph_ql_operation: pulumi.Input[str]
        """
        The GraphQL operation; that is, the query, mutation, or subscription to be parsed and executed by the GraphQL service.

        For more information, see [Operations](https://docs.aws.amazon.com/appsync/latest/devguide/graphql-architecture.html#graphql-operations) in the *AWS AppSync User Guide* .
        """
elif False:
    RuleAppSyncParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleAppSyncParametersArgs:
    def __init__(__self__, *,
                 graph_ql_operation: pulumi.Input[str]):
        """
        :param pulumi.Input[str] graph_ql_operation: The GraphQL operation; that is, the query, mutation, or subscription to be parsed and executed by the GraphQL service.
               
               For more information, see [Operations](https://docs.aws.amazon.com/appsync/latest/devguide/graphql-architecture.html#graphql-operations) in the *AWS AppSync User Guide* .
        """
        pulumi.set(__self__, "graph_ql_operation", graph_ql_operation)

    @property
    @pulumi.getter(name="graphQlOperation")
    def graph_ql_operation(self) -> pulumi.Input[str]:
        """
        The GraphQL operation; that is, the query, mutation, or subscription to be parsed and executed by the GraphQL service.

        For more information, see [Operations](https://docs.aws.amazon.com/appsync/latest/devguide/graphql-architecture.html#graphql-operations) in the *AWS AppSync User Guide* .
        """
        return pulumi.get(self, "graph_ql_operation")

    @graph_ql_operation.setter
    def graph_ql_operation(self, value: pulumi.Input[str]):
        pulumi.set(self, "graph_ql_operation", value)


if not MYPY:
    class RuleAwsVpcConfigurationArgsDict(TypedDict):
        subnets: pulumi.Input[Sequence[pulumi.Input[str]]]
        """
        Specifies the subnets associated with the task. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
        """
        assign_public_ip: NotRequired[pulumi.Input[str]]
        """
        Specifies whether the task's elastic network interface receives a public IP address. You can specify `ENABLED` only when `LaunchType` in `EcsParameters` is set to `FARGATE` .
        """
        security_groups: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Specifies the security groups associated with the task. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
        """
elif False:
    RuleAwsVpcConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleAwsVpcConfigurationArgs:
    def __init__(__self__, *,
                 subnets: pulumi.Input[Sequence[pulumi.Input[str]]],
                 assign_public_ip: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: Specifies the subnets associated with the task. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
        :param pulumi.Input[str] assign_public_ip: Specifies whether the task's elastic network interface receives a public IP address. You can specify `ENABLED` only when `LaunchType` in `EcsParameters` is set to `FARGATE` .
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: Specifies the security groups associated with the task. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
        """
        pulumi.set(__self__, "subnets", subnets)
        if assign_public_ip is not None:
            pulumi.set(__self__, "assign_public_ip", assign_public_ip)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies the subnets associated with the task. These subnets must all be in the same VPC. You can specify as many as 16 subnets.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnets", value)

    @property
    @pulumi.getter(name="assignPublicIp")
    def assign_public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the task's elastic network interface receives a public IP address. You can specify `ENABLED` only when `LaunchType` in `EcsParameters` is set to `FARGATE` .
        """
        return pulumi.get(self, "assign_public_ip")

    @assign_public_ip.setter
    def assign_public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assign_public_ip", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the security groups associated with the task. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_groups", value)


if not MYPY:
    class RuleBatchArrayPropertiesArgsDict(TypedDict):
        size: NotRequired[pulumi.Input[int]]
        """
        The size of the array, if this is an array batch job. Valid values are integers between 2 and 10,000.
        """
elif False:
    RuleBatchArrayPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleBatchArrayPropertiesArgs:
    def __init__(__self__, *,
                 size: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] size: The size of the array, if this is an array batch job. Valid values are integers between 2 and 10,000.
        """
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the array, if this is an array batch job. Valid values are integers between 2 and 10,000.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)


if not MYPY:
    class RuleBatchParametersArgsDict(TypedDict):
        job_definition: pulumi.Input[str]
        """
        The ARN or name of the job definition to use if the event target is an AWS Batch job. This job definition must already exist.
        """
        job_name: pulumi.Input[str]
        """
        The name to use for this execution of the job, if the target is an AWS Batch job.
        """
        array_properties: NotRequired[pulumi.Input['RuleBatchArrayPropertiesArgsDict']]
        """
        The array properties for the submitted job, such as the size of the array. The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an AWS Batch job.
        """
        retry_strategy: NotRequired[pulumi.Input['RuleBatchRetryStrategyArgsDict']]
        """
        The retry strategy to use for failed jobs, if the target is an AWS Batch job. The retry strategy is the number of times to retry the failed job execution. Valid values are 1–10. When you specify a retry strategy here, it overrides the retry strategy defined in the job definition.
        """
elif False:
    RuleBatchParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleBatchParametersArgs:
    def __init__(__self__, *,
                 job_definition: pulumi.Input[str],
                 job_name: pulumi.Input[str],
                 array_properties: Optional[pulumi.Input['RuleBatchArrayPropertiesArgs']] = None,
                 retry_strategy: Optional[pulumi.Input['RuleBatchRetryStrategyArgs']] = None):
        """
        :param pulumi.Input[str] job_definition: The ARN or name of the job definition to use if the event target is an AWS Batch job. This job definition must already exist.
        :param pulumi.Input[str] job_name: The name to use for this execution of the job, if the target is an AWS Batch job.
        :param pulumi.Input['RuleBatchArrayPropertiesArgs'] array_properties: The array properties for the submitted job, such as the size of the array. The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an AWS Batch job.
        :param pulumi.Input['RuleBatchRetryStrategyArgs'] retry_strategy: The retry strategy to use for failed jobs, if the target is an AWS Batch job. The retry strategy is the number of times to retry the failed job execution. Valid values are 1–10. When you specify a retry strategy here, it overrides the retry strategy defined in the job definition.
        """
        pulumi.set(__self__, "job_definition", job_definition)
        pulumi.set(__self__, "job_name", job_name)
        if array_properties is not None:
            pulumi.set(__self__, "array_properties", array_properties)
        if retry_strategy is not None:
            pulumi.set(__self__, "retry_strategy", retry_strategy)

    @property
    @pulumi.getter(name="jobDefinition")
    def job_definition(self) -> pulumi.Input[str]:
        """
        The ARN or name of the job definition to use if the event target is an AWS Batch job. This job definition must already exist.
        """
        return pulumi.get(self, "job_definition")

    @job_definition.setter
    def job_definition(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_definition", value)

    @property
    @pulumi.getter(name="jobName")
    def job_name(self) -> pulumi.Input[str]:
        """
        The name to use for this execution of the job, if the target is an AWS Batch job.
        """
        return pulumi.get(self, "job_name")

    @job_name.setter
    def job_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "job_name", value)

    @property
    @pulumi.getter(name="arrayProperties")
    def array_properties(self) -> Optional[pulumi.Input['RuleBatchArrayPropertiesArgs']]:
        """
        The array properties for the submitted job, such as the size of the array. The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an AWS Batch job.
        """
        return pulumi.get(self, "array_properties")

    @array_properties.setter
    def array_properties(self, value: Optional[pulumi.Input['RuleBatchArrayPropertiesArgs']]):
        pulumi.set(self, "array_properties", value)

    @property
    @pulumi.getter(name="retryStrategy")
    def retry_strategy(self) -> Optional[pulumi.Input['RuleBatchRetryStrategyArgs']]:
        """
        The retry strategy to use for failed jobs, if the target is an AWS Batch job. The retry strategy is the number of times to retry the failed job execution. Valid values are 1–10. When you specify a retry strategy here, it overrides the retry strategy defined in the job definition.
        """
        return pulumi.get(self, "retry_strategy")

    @retry_strategy.setter
    def retry_strategy(self, value: Optional[pulumi.Input['RuleBatchRetryStrategyArgs']]):
        pulumi.set(self, "retry_strategy", value)


if not MYPY:
    class RuleBatchRetryStrategyArgsDict(TypedDict):
        attempts: NotRequired[pulumi.Input[int]]
        """
        The number of times to attempt to retry, if the job fails. Valid values are 1–10.
        """
elif False:
    RuleBatchRetryStrategyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleBatchRetryStrategyArgs:
    def __init__(__self__, *,
                 attempts: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] attempts: The number of times to attempt to retry, if the job fails. Valid values are 1–10.
        """
        if attempts is not None:
            pulumi.set(__self__, "attempts", attempts)

    @property
    @pulumi.getter
    def attempts(self) -> Optional[pulumi.Input[int]]:
        """
        The number of times to attempt to retry, if the job fails. Valid values are 1–10.
        """
        return pulumi.get(self, "attempts")

    @attempts.setter
    def attempts(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "attempts", value)


if not MYPY:
    class RuleCapacityProviderStrategyItemArgsDict(TypedDict):
        capacity_provider: pulumi.Input[str]
        """
        The short name of the capacity provider.
        """
        base: NotRequired[pulumi.Input[int]]
        """
        The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used.
        """
        weight: NotRequired[pulumi.Input[int]]
        """
        The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.
        """
elif False:
    RuleCapacityProviderStrategyItemArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleCapacityProviderStrategyItemArgs:
    def __init__(__self__, *,
                 capacity_provider: pulumi.Input[str],
                 base: Optional[pulumi.Input[int]] = None,
                 weight: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] capacity_provider: The short name of the capacity provider.
        :param pulumi.Input[int] base: The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used.
        :param pulumi.Input[int] weight: The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.
        """
        pulumi.set(__self__, "capacity_provider", capacity_provider)
        if base is not None:
            pulumi.set(__self__, "base", base)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="capacityProvider")
    def capacity_provider(self) -> pulumi.Input[str]:
        """
        The short name of the capacity provider.
        """
        return pulumi.get(self, "capacity_provider")

    @capacity_provider.setter
    def capacity_provider(self, value: pulumi.Input[str]):
        pulumi.set(self, "capacity_provider", value)

    @property
    @pulumi.getter
    def base(self) -> Optional[pulumi.Input[int]]:
        """
        The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used.
        """
        return pulumi.get(self, "base")

    @base.setter
    def base(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "base", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


if not MYPY:
    class RuleDeadLetterConfigArgsDict(TypedDict):
        arn: NotRequired[pulumi.Input[str]]
        """
        The ARN of the SQS queue specified as the target for the dead-letter queue.
        """
elif False:
    RuleDeadLetterConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleDeadLetterConfigArgs:
    def __init__(__self__, *,
                 arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] arn: The ARN of the SQS queue specified as the target for the dead-letter queue.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the SQS queue specified as the target for the dead-letter queue.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arn", value)


if not MYPY:
    class RuleEcsParametersArgsDict(TypedDict):
        task_definition_arn: pulumi.Input[str]
        """
        The ARN of the task definition to use if the event target is an Amazon ECS task.
        """
        capacity_provider_strategy: NotRequired[pulumi.Input[Sequence[pulumi.Input['RuleCapacityProviderStrategyItemArgsDict']]]]
        """
        The capacity provider strategy to use for the task.

        If a `capacityProviderStrategy` is specified, the `launchType` parameter must be omitted. If no `capacityProviderStrategy` or launchType is specified, the `defaultCapacityProviderStrategy` for the cluster is used.
        """
        enable_ecs_managed_tags: NotRequired[pulumi.Input[bool]]
        """
        Specifies whether to enable Amazon ECS managed tags for the task. For more information, see [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the Amazon Elastic Container Service Developer Guide.
        """
        enable_execute_command: NotRequired[pulumi.Input[bool]]
        """
        Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.
        """
        group: NotRequired[pulumi.Input[str]]
        """
        Specifies an ECS task group for the task. The maximum length is 255 characters.
        """
        launch_type: NotRequired[pulumi.Input[str]]
        """
        Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The `FARGATE` value is supported only in the Regions where AWS Fargate with Amazon ECS is supported. For more information, see [AWS Fargate on Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS-Fargate.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        network_configuration: NotRequired[pulumi.Input['RuleNetworkConfigurationArgsDict']]
        """
        Use this structure if the Amazon ECS task uses the `awsvpc` network mode. This structure specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. This structure is required if `LaunchType` is `FARGATE` because the `awsvpc` mode is required for Fargate tasks.

        If you specify `NetworkConfiguration` when the target ECS task does not use the `awsvpc` network mode, the task fails.
        """
        placement_constraints: NotRequired[pulumi.Input[Sequence[pulumi.Input['RulePlacementConstraintArgsDict']]]]
        """
        An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime).
        """
        placement_strategies: NotRequired[pulumi.Input[Sequence[pulumi.Input['RulePlacementStrategyArgsDict']]]]
        """
        The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
        """
        platform_version: NotRequired[pulumi.Input[str]]
        """
        Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as `1.1.0` .

        This structure is used only if `LaunchType` is `FARGATE` . For more information about valid platform versions, see [AWS Fargate Platform Versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        propagate_tags: NotRequired[pulumi.Input[str]]
        """
        Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the TagResource API action.
        """
        reference_id: NotRequired[pulumi.Input[str]]
        """
        The reference ID to use for the task.
        """
        tag_list: NotRequired[pulumi.Input[Sequence[pulumi.Input['RuleTagArgsDict']]]]
        """
        The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. To learn more, see [RunTask](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html#ECS-RunTask-request-tags) in the Amazon ECS API Reference.
        """
        task_count: NotRequired[pulumi.Input[int]]
        """
        The number of tasks to create based on `TaskDefinition` . The default is 1.
        """
elif False:
    RuleEcsParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleEcsParametersArgs:
    def __init__(__self__, *,
                 task_definition_arn: pulumi.Input[str],
                 capacity_provider_strategy: Optional[pulumi.Input[Sequence[pulumi.Input['RuleCapacityProviderStrategyItemArgs']]]] = None,
                 enable_ecs_managed_tags: Optional[pulumi.Input[bool]] = None,
                 enable_execute_command: Optional[pulumi.Input[bool]] = None,
                 group: Optional[pulumi.Input[str]] = None,
                 launch_type: Optional[pulumi.Input[str]] = None,
                 network_configuration: Optional[pulumi.Input['RuleNetworkConfigurationArgs']] = None,
                 placement_constraints: Optional[pulumi.Input[Sequence[pulumi.Input['RulePlacementConstraintArgs']]]] = None,
                 placement_strategies: Optional[pulumi.Input[Sequence[pulumi.Input['RulePlacementStrategyArgs']]]] = None,
                 platform_version: Optional[pulumi.Input[str]] = None,
                 propagate_tags: Optional[pulumi.Input[str]] = None,
                 reference_id: Optional[pulumi.Input[str]] = None,
                 tag_list: Optional[pulumi.Input[Sequence[pulumi.Input['RuleTagArgs']]]] = None,
                 task_count: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] task_definition_arn: The ARN of the task definition to use if the event target is an Amazon ECS task.
        :param pulumi.Input[Sequence[pulumi.Input['RuleCapacityProviderStrategyItemArgs']]] capacity_provider_strategy: The capacity provider strategy to use for the task.
               
               If a `capacityProviderStrategy` is specified, the `launchType` parameter must be omitted. If no `capacityProviderStrategy` or launchType is specified, the `defaultCapacityProviderStrategy` for the cluster is used.
        :param pulumi.Input[bool] enable_ecs_managed_tags: Specifies whether to enable Amazon ECS managed tags for the task. For more information, see [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the Amazon Elastic Container Service Developer Guide.
        :param pulumi.Input[bool] enable_execute_command: Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.
        :param pulumi.Input[str] group: Specifies an ECS task group for the task. The maximum length is 255 characters.
        :param pulumi.Input[str] launch_type: Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The `FARGATE` value is supported only in the Regions where AWS Fargate with Amazon ECS is supported. For more information, see [AWS Fargate on Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS-Fargate.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param pulumi.Input['RuleNetworkConfigurationArgs'] network_configuration: Use this structure if the Amazon ECS task uses the `awsvpc` network mode. This structure specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. This structure is required if `LaunchType` is `FARGATE` because the `awsvpc` mode is required for Fargate tasks.
               
               If you specify `NetworkConfiguration` when the target ECS task does not use the `awsvpc` network mode, the task fails.
        :param pulumi.Input[Sequence[pulumi.Input['RulePlacementConstraintArgs']]] placement_constraints: An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime).
        :param pulumi.Input[Sequence[pulumi.Input['RulePlacementStrategyArgs']]] placement_strategies: The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
        :param pulumi.Input[str] platform_version: Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as `1.1.0` .
               
               This structure is used only if `LaunchType` is `FARGATE` . For more information about valid platform versions, see [AWS Fargate Platform Versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide* .
        :param pulumi.Input[str] propagate_tags: Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the TagResource API action.
        :param pulumi.Input[str] reference_id: The reference ID to use for the task.
        :param pulumi.Input[Sequence[pulumi.Input['RuleTagArgs']]] tag_list: The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. To learn more, see [RunTask](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html#ECS-RunTask-request-tags) in the Amazon ECS API Reference.
        :param pulumi.Input[int] task_count: The number of tasks to create based on `TaskDefinition` . The default is 1.
        """
        pulumi.set(__self__, "task_definition_arn", task_definition_arn)
        if capacity_provider_strategy is not None:
            pulumi.set(__self__, "capacity_provider_strategy", capacity_provider_strategy)
        if enable_ecs_managed_tags is not None:
            pulumi.set(__self__, "enable_ecs_managed_tags", enable_ecs_managed_tags)
        if enable_execute_command is not None:
            pulumi.set(__self__, "enable_execute_command", enable_execute_command)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if launch_type is not None:
            pulumi.set(__self__, "launch_type", launch_type)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if placement_constraints is not None:
            pulumi.set(__self__, "placement_constraints", placement_constraints)
        if placement_strategies is not None:
            pulumi.set(__self__, "placement_strategies", placement_strategies)
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)
        if propagate_tags is not None:
            pulumi.set(__self__, "propagate_tags", propagate_tags)
        if reference_id is not None:
            pulumi.set(__self__, "reference_id", reference_id)
        if tag_list is not None:
            pulumi.set(__self__, "tag_list", tag_list)
        if task_count is not None:
            pulumi.set(__self__, "task_count", task_count)

    @property
    @pulumi.getter(name="taskDefinitionArn")
    def task_definition_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the task definition to use if the event target is an Amazon ECS task.
        """
        return pulumi.get(self, "task_definition_arn")

    @task_definition_arn.setter
    def task_definition_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "task_definition_arn", value)

    @property
    @pulumi.getter(name="capacityProviderStrategy")
    def capacity_provider_strategy(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleCapacityProviderStrategyItemArgs']]]]:
        """
        The capacity provider strategy to use for the task.

        If a `capacityProviderStrategy` is specified, the `launchType` parameter must be omitted. If no `capacityProviderStrategy` or launchType is specified, the `defaultCapacityProviderStrategy` for the cluster is used.
        """
        return pulumi.get(self, "capacity_provider_strategy")

    @capacity_provider_strategy.setter
    def capacity_provider_strategy(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleCapacityProviderStrategyItemArgs']]]]):
        pulumi.set(self, "capacity_provider_strategy", value)

    @property
    @pulumi.getter(name="enableEcsManagedTags")
    def enable_ecs_managed_tags(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable Amazon ECS managed tags for the task. For more information, see [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the Amazon Elastic Container Service Developer Guide.
        """
        return pulumi.get(self, "enable_ecs_managed_tags")

    @enable_ecs_managed_tags.setter
    def enable_ecs_managed_tags(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ecs_managed_tags", value)

    @property
    @pulumi.getter(name="enableExecuteCommand")
    def enable_execute_command(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.
        """
        return pulumi.get(self, "enable_execute_command")

    @enable_execute_command.setter
    def enable_execute_command(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_execute_command", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an ECS task group for the task. The maximum length is 255 characters.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter(name="launchType")
    def launch_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The `FARGATE` value is supported only in the Regions where AWS Fargate with Amazon ECS is supported. For more information, see [AWS Fargate on Amazon ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS-Fargate.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "launch_type")

    @launch_type.setter
    def launch_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_type", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['RuleNetworkConfigurationArgs']]:
        """
        Use this structure if the Amazon ECS task uses the `awsvpc` network mode. This structure specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. This structure is required if `LaunchType` is `FARGATE` because the `awsvpc` mode is required for Fargate tasks.

        If you specify `NetworkConfiguration` when the target ECS task does not use the `awsvpc` network mode, the task fails.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['RuleNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter(name="placementConstraints")
    def placement_constraints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RulePlacementConstraintArgs']]]]:
        """
        An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime).
        """
        return pulumi.get(self, "placement_constraints")

    @placement_constraints.setter
    def placement_constraints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RulePlacementConstraintArgs']]]]):
        pulumi.set(self, "placement_constraints", value)

    @property
    @pulumi.getter(name="placementStrategies")
    def placement_strategies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RulePlacementStrategyArgs']]]]:
        """
        The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
        """
        return pulumi.get(self, "placement_strategies")

    @placement_strategies.setter
    def placement_strategies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RulePlacementStrategyArgs']]]]):
        pulumi.set(self, "placement_strategies", value)

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as `1.1.0` .

        This structure is used only if `LaunchType` is `FARGATE` . For more information about valid platform versions, see [AWS Fargate Platform Versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide* .
        """
        return pulumi.get(self, "platform_version")

    @platform_version.setter
    def platform_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform_version", value)

    @property
    @pulumi.getter(name="propagateTags")
    def propagate_tags(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the TagResource API action.
        """
        return pulumi.get(self, "propagate_tags")

    @propagate_tags.setter
    def propagate_tags(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "propagate_tags", value)

    @property
    @pulumi.getter(name="referenceId")
    def reference_id(self) -> Optional[pulumi.Input[str]]:
        """
        The reference ID to use for the task.
        """
        return pulumi.get(self, "reference_id")

    @reference_id.setter
    def reference_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reference_id", value)

    @property
    @pulumi.getter(name="tagList")
    def tag_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleTagArgs']]]]:
        """
        The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. To learn more, see [RunTask](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html#ECS-RunTask-request-tags) in the Amazon ECS API Reference.
        """
        return pulumi.get(self, "tag_list")

    @tag_list.setter
    def tag_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleTagArgs']]]]):
        pulumi.set(self, "tag_list", value)

    @property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of tasks to create based on `TaskDefinition` . The default is 1.
        """
        return pulumi.get(self, "task_count")

    @task_count.setter
    def task_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "task_count", value)


if not MYPY:
    class RuleHttpParametersArgsDict(TypedDict):
        header_parameters: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        The headers that need to be sent as part of request invoking the API Gateway API or EventBridge ApiDestination.
        """
        path_parameter_values: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The path parameter values to be used to populate API Gateway API or EventBridge ApiDestination path wildcards ("*").
        """
        query_string_parameters: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        The query string keys/values that need to be sent as part of request invoking the API Gateway API or EventBridge ApiDestination.
        """
elif False:
    RuleHttpParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleHttpParametersArgs:
    def __init__(__self__, *,
                 header_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 path_parameter_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 query_string_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] header_parameters: The headers that need to be sent as part of request invoking the API Gateway API or EventBridge ApiDestination.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] path_parameter_values: The path parameter values to be used to populate API Gateway API or EventBridge ApiDestination path wildcards ("*").
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] query_string_parameters: The query string keys/values that need to be sent as part of request invoking the API Gateway API or EventBridge ApiDestination.
        """
        if header_parameters is not None:
            pulumi.set(__self__, "header_parameters", header_parameters)
        if path_parameter_values is not None:
            pulumi.set(__self__, "path_parameter_values", path_parameter_values)
        if query_string_parameters is not None:
            pulumi.set(__self__, "query_string_parameters", query_string_parameters)

    @property
    @pulumi.getter(name="headerParameters")
    def header_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The headers that need to be sent as part of request invoking the API Gateway API or EventBridge ApiDestination.
        """
        return pulumi.get(self, "header_parameters")

    @header_parameters.setter
    def header_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "header_parameters", value)

    @property
    @pulumi.getter(name="pathParameterValues")
    def path_parameter_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The path parameter values to be used to populate API Gateway API or EventBridge ApiDestination path wildcards ("*").
        """
        return pulumi.get(self, "path_parameter_values")

    @path_parameter_values.setter
    def path_parameter_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "path_parameter_values", value)

    @property
    @pulumi.getter(name="queryStringParameters")
    def query_string_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The query string keys/values that need to be sent as part of request invoking the API Gateway API or EventBridge ApiDestination.
        """
        return pulumi.get(self, "query_string_parameters")

    @query_string_parameters.setter
    def query_string_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "query_string_parameters", value)


if not MYPY:
    class RuleInputTransformerArgsDict(TypedDict):
        input_template: pulumi.Input[str]
        """
        Input template where you specify placeholders that will be filled with the values of the keys from `InputPathsMap` to customize the data sent to the target. Enclose each `InputPathsMaps` value in brackets: < *value* >

        If `InputTemplate` is a JSON object (surrounded by curly braces), the following restrictions apply:

        - The placeholder cannot be used as an object key.

        The following example shows the syntax for using `InputPathsMap` and `InputTemplate` .

        `"InputTransformer":`

        `{`

        `"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},`

        `"InputTemplate": "<instance> is in state <status>"`

        `}`

        To have the `InputTemplate` include quote marks within a JSON string, escape each quote marks with a slash, as in the following example:

        `"InputTransformer":`

        `{`

        `"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},`

        `"InputTemplate": "<instance> is in state \\"<status>\\""`

        `}`

        The `InputTemplate` can also be valid JSON with varibles in quotes or out, as in the following example:

        `"InputTransformer":`

        `{`

        `"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},`

        `"InputTemplate": '{"myInstance": <instance>,"myStatus": "<instance> is in state \\"<status>\\""}'`

        `}`
        """
        input_paths_map: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[str]]]]
        """
        Map of JSON paths to be extracted from the event. You can then insert these in the template in `InputTemplate` to produce the output you want to be sent to the target.

        `InputPathsMap` is an array key-value pairs, where each value is a valid JSON path. You can have as many as 100 key-value pairs. You must use JSON dot notation, not bracket notation.

        The keys cannot start with " AWS ."
        """
elif False:
    RuleInputTransformerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleInputTransformerArgs:
    def __init__(__self__, *,
                 input_template: pulumi.Input[str],
                 input_paths_map: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] input_template: Input template where you specify placeholders that will be filled with the values of the keys from `InputPathsMap` to customize the data sent to the target. Enclose each `InputPathsMaps` value in brackets: < *value* >
               
               If `InputTemplate` is a JSON object (surrounded by curly braces), the following restrictions apply:
               
               - The placeholder cannot be used as an object key.
               
               The following example shows the syntax for using `InputPathsMap` and `InputTemplate` .
               
               `"InputTransformer":`
               
               `{`
               
               `"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},`
               
               `"InputTemplate": "<instance> is in state <status>"`
               
               `}`
               
               To have the `InputTemplate` include quote marks within a JSON string, escape each quote marks with a slash, as in the following example:
               
               `"InputTransformer":`
               
               `{`
               
               `"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},`
               
               `"InputTemplate": "<instance> is in state \\"<status>\\""`
               
               `}`
               
               The `InputTemplate` can also be valid JSON with varibles in quotes or out, as in the following example:
               
               `"InputTransformer":`
               
               `{`
               
               `"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},`
               
               `"InputTemplate": '{"myInstance": <instance>,"myStatus": "<instance> is in state \\"<status>\\""}'`
               
               `}`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] input_paths_map: Map of JSON paths to be extracted from the event. You can then insert these in the template in `InputTemplate` to produce the output you want to be sent to the target.
               
               `InputPathsMap` is an array key-value pairs, where each value is a valid JSON path. You can have as many as 100 key-value pairs. You must use JSON dot notation, not bracket notation.
               
               The keys cannot start with " AWS ."
        """
        pulumi.set(__self__, "input_template", input_template)
        if input_paths_map is not None:
            pulumi.set(__self__, "input_paths_map", input_paths_map)

    @property
    @pulumi.getter(name="inputTemplate")
    def input_template(self) -> pulumi.Input[str]:
        """
        Input template where you specify placeholders that will be filled with the values of the keys from `InputPathsMap` to customize the data sent to the target. Enclose each `InputPathsMaps` value in brackets: < *value* >

        If `InputTemplate` is a JSON object (surrounded by curly braces), the following restrictions apply:

        - The placeholder cannot be used as an object key.

        The following example shows the syntax for using `InputPathsMap` and `InputTemplate` .

        `"InputTransformer":`

        `{`

        `"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},`

        `"InputTemplate": "<instance> is in state <status>"`

        `}`

        To have the `InputTemplate` include quote marks within a JSON string, escape each quote marks with a slash, as in the following example:

        `"InputTransformer":`

        `{`

        `"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},`

        `"InputTemplate": "<instance> is in state \\"<status>\\""`

        `}`

        The `InputTemplate` can also be valid JSON with varibles in quotes or out, as in the following example:

        `"InputTransformer":`

        `{`

        `"InputPathsMap": {"instance": "$.detail.instance","status": "$.detail.status"},`

        `"InputTemplate": '{"myInstance": <instance>,"myStatus": "<instance> is in state \\"<status>\\""}'`

        `}`
        """
        return pulumi.get(self, "input_template")

    @input_template.setter
    def input_template(self, value: pulumi.Input[str]):
        pulumi.set(self, "input_template", value)

    @property
    @pulumi.getter(name="inputPathsMap")
    def input_paths_map(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of JSON paths to be extracted from the event. You can then insert these in the template in `InputTemplate` to produce the output you want to be sent to the target.

        `InputPathsMap` is an array key-value pairs, where each value is a valid JSON path. You can have as many as 100 key-value pairs. You must use JSON dot notation, not bracket notation.

        The keys cannot start with " AWS ."
        """
        return pulumi.get(self, "input_paths_map")

    @input_paths_map.setter
    def input_paths_map(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "input_paths_map", value)


if not MYPY:
    class RuleKinesisParametersArgsDict(TypedDict):
        partition_key_path: pulumi.Input[str]
        """
        The JSON path to be extracted from the event and used as the partition key. For more information, see [Amazon Kinesis Streams Key Concepts](https://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key) in the *Amazon Kinesis Streams Developer Guide* .
        """
elif False:
    RuleKinesisParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleKinesisParametersArgs:
    def __init__(__self__, *,
                 partition_key_path: pulumi.Input[str]):
        """
        :param pulumi.Input[str] partition_key_path: The JSON path to be extracted from the event and used as the partition key. For more information, see [Amazon Kinesis Streams Key Concepts](https://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key) in the *Amazon Kinesis Streams Developer Guide* .
        """
        pulumi.set(__self__, "partition_key_path", partition_key_path)

    @property
    @pulumi.getter(name="partitionKeyPath")
    def partition_key_path(self) -> pulumi.Input[str]:
        """
        The JSON path to be extracted from the event and used as the partition key. For more information, see [Amazon Kinesis Streams Key Concepts](https://docs.aws.amazon.com/streams/latest/dev/key-concepts.html#partition-key) in the *Amazon Kinesis Streams Developer Guide* .
        """
        return pulumi.get(self, "partition_key_path")

    @partition_key_path.setter
    def partition_key_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "partition_key_path", value)


if not MYPY:
    class RuleNetworkConfigurationArgsDict(TypedDict):
        aws_vpc_configuration: NotRequired[pulumi.Input['RuleAwsVpcConfigurationArgsDict']]
        """
        Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the `awsvpc` network mode.
        """
elif False:
    RuleNetworkConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleNetworkConfigurationArgs:
    def __init__(__self__, *,
                 aws_vpc_configuration: Optional[pulumi.Input['RuleAwsVpcConfigurationArgs']] = None):
        """
        :param pulumi.Input['RuleAwsVpcConfigurationArgs'] aws_vpc_configuration: Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the `awsvpc` network mode.
        """
        if aws_vpc_configuration is not None:
            pulumi.set(__self__, "aws_vpc_configuration", aws_vpc_configuration)

    @property
    @pulumi.getter(name="awsVpcConfiguration")
    def aws_vpc_configuration(self) -> Optional[pulumi.Input['RuleAwsVpcConfigurationArgs']]:
        """
        Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the `awsvpc` network mode.
        """
        return pulumi.get(self, "aws_vpc_configuration")

    @aws_vpc_configuration.setter
    def aws_vpc_configuration(self, value: Optional[pulumi.Input['RuleAwsVpcConfigurationArgs']]):
        pulumi.set(self, "aws_vpc_configuration", value)


if not MYPY:
    class RulePlacementConstraintArgsDict(TypedDict):
        expression: NotRequired[pulumi.Input[str]]
        """
        A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is `distinctInstance` . To learn more, see [Cluster Query Language](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html) in the Amazon Elastic Container Service Developer Guide.
        """
        type: NotRequired[pulumi.Input[str]]
        """
        The type of constraint. Use distinctInstance to ensure that each task in a particular group is running on a different container instance. Use memberOf to restrict the selection to a group of valid candidates.
        """
elif False:
    RulePlacementConstraintArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RulePlacementConstraintArgs:
    def __init__(__self__, *,
                 expression: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] expression: A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is `distinctInstance` . To learn more, see [Cluster Query Language](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html) in the Amazon Elastic Container Service Developer Guide.
        :param pulumi.Input[str] type: The type of constraint. Use distinctInstance to ensure that each task in a particular group is running on a different container instance. Use memberOf to restrict the selection to a group of valid candidates.
        """
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is `distinctInstance` . To learn more, see [Cluster Query Language](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html) in the Amazon Elastic Container Service Developer Guide.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of constraint. Use distinctInstance to ensure that each task in a particular group is running on a different container instance. Use memberOf to restrict the selection to a group of valid candidates.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class RulePlacementStrategyArgsDict(TypedDict):
        field: NotRequired[pulumi.Input[str]]
        """
        The field to apply the placement strategy against. For the spread placement strategy, valid values are instanceId (or host, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as attribute:ecs.availability-zone. For the binpack placement strategy, valid values are cpu and memory. For the random placement strategy, this field is not used.
        """
        type: NotRequired[pulumi.Input[str]]
        """
        The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task).
        """
elif False:
    RulePlacementStrategyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RulePlacementStrategyArgs:
    def __init__(__self__, *,
                 field: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] field: The field to apply the placement strategy against. For the spread placement strategy, valid values are instanceId (or host, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as attribute:ecs.availability-zone. For the binpack placement strategy, valid values are cpu and memory. For the random placement strategy, this field is not used.
        :param pulumi.Input[str] type: The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task).
        """
        if field is not None:
            pulumi.set(__self__, "field", field)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[str]]:
        """
        The field to apply the placement strategy against. For the spread placement strategy, valid values are instanceId (or host, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as attribute:ecs.availability-zone. For the binpack placement strategy, valid values are cpu and memory. For the random placement strategy, this field is not used.
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class RuleRedshiftDataParametersArgsDict(TypedDict):
        database: pulumi.Input[str]
        """
        The name of the database. Required when authenticating using temporary credentials.
        """
        db_user: NotRequired[pulumi.Input[str]]
        """
        The database user name. Required when authenticating using temporary credentials.
        """
        secret_manager_arn: NotRequired[pulumi.Input[str]]
        """
        The name or ARN of the secret that enables access to the database. Required when authenticating using AWS Secrets Manager.
        """
        sql: NotRequired[pulumi.Input[str]]
        """
        The SQL statement text to run.
        """
        sqls: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        One or more SQL statements to run. The SQL statements are run as a single transaction. They run serially in the order of the array. Subsequent SQL statements don't start until the previous statement in the array completes. If any SQL statement fails, then because they are run as one transaction, all work is rolled back.
        """
        statement_name: NotRequired[pulumi.Input[str]]
        """
        The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
        """
        with_event: NotRequired[pulumi.Input[bool]]
        """
        Indicates whether to send an event back to EventBridge after the SQL statement runs.
        """
elif False:
    RuleRedshiftDataParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleRedshiftDataParametersArgs:
    def __init__(__self__, *,
                 database: pulumi.Input[str],
                 db_user: Optional[pulumi.Input[str]] = None,
                 secret_manager_arn: Optional[pulumi.Input[str]] = None,
                 sql: Optional[pulumi.Input[str]] = None,
                 sqls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 statement_name: Optional[pulumi.Input[str]] = None,
                 with_event: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] database: The name of the database. Required when authenticating using temporary credentials.
        :param pulumi.Input[str] db_user: The database user name. Required when authenticating using temporary credentials.
        :param pulumi.Input[str] secret_manager_arn: The name or ARN of the secret that enables access to the database. Required when authenticating using AWS Secrets Manager.
        :param pulumi.Input[str] sql: The SQL statement text to run.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sqls: One or more SQL statements to run. The SQL statements are run as a single transaction. They run serially in the order of the array. Subsequent SQL statements don't start until the previous statement in the array completes. If any SQL statement fails, then because they are run as one transaction, all work is rolled back.
        :param pulumi.Input[str] statement_name: The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
        :param pulumi.Input[bool] with_event: Indicates whether to send an event back to EventBridge after the SQL statement runs.
        """
        pulumi.set(__self__, "database", database)
        if db_user is not None:
            pulumi.set(__self__, "db_user", db_user)
        if secret_manager_arn is not None:
            pulumi.set(__self__, "secret_manager_arn", secret_manager_arn)
        if sql is not None:
            pulumi.set(__self__, "sql", sql)
        if sqls is not None:
            pulumi.set(__self__, "sqls", sqls)
        if statement_name is not None:
            pulumi.set(__self__, "statement_name", statement_name)
        if with_event is not None:
            pulumi.set(__self__, "with_event", with_event)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[str]:
        """
        The name of the database. Required when authenticating using temporary credentials.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="dbUser")
    def db_user(self) -> Optional[pulumi.Input[str]]:
        """
        The database user name. Required when authenticating using temporary credentials.
        """
        return pulumi.get(self, "db_user")

    @db_user.setter
    def db_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_user", value)

    @property
    @pulumi.getter(name="secretManagerArn")
    def secret_manager_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The name or ARN of the secret that enables access to the database. Required when authenticating using AWS Secrets Manager.
        """
        return pulumi.get(self, "secret_manager_arn")

    @secret_manager_arn.setter
    def secret_manager_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_manager_arn", value)

    @property
    @pulumi.getter
    def sql(self) -> Optional[pulumi.Input[str]]:
        """
        The SQL statement text to run.
        """
        return pulumi.get(self, "sql")

    @sql.setter
    def sql(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql", value)

    @property
    @pulumi.getter
    def sqls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        One or more SQL statements to run. The SQL statements are run as a single transaction. They run serially in the order of the array. Subsequent SQL statements don't start until the previous statement in the array completes. If any SQL statement fails, then because they are run as one transaction, all work is rolled back.
        """
        return pulumi.get(self, "sqls")

    @sqls.setter
    def sqls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sqls", value)

    @property
    @pulumi.getter(name="statementName")
    def statement_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
        """
        return pulumi.get(self, "statement_name")

    @statement_name.setter
    def statement_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "statement_name", value)

    @property
    @pulumi.getter(name="withEvent")
    def with_event(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to send an event back to EventBridge after the SQL statement runs.
        """
        return pulumi.get(self, "with_event")

    @with_event.setter
    def with_event(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "with_event", value)


if not MYPY:
    class RuleRetryPolicyArgsDict(TypedDict):
        maximum_event_age_in_seconds: NotRequired[pulumi.Input[int]]
        """
        The maximum amount of time, in seconds, to continue to make retry attempts.
        """
        maximum_retry_attempts: NotRequired[pulumi.Input[int]]
        """
        The maximum number of retry attempts to make before the request fails. Retry attempts continue until either the maximum number of attempts is made or until the duration of the `MaximumEventAgeInSeconds` is met.
        """
elif False:
    RuleRetryPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleRetryPolicyArgs:
    def __init__(__self__, *,
                 maximum_event_age_in_seconds: Optional[pulumi.Input[int]] = None,
                 maximum_retry_attempts: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] maximum_event_age_in_seconds: The maximum amount of time, in seconds, to continue to make retry attempts.
        :param pulumi.Input[int] maximum_retry_attempts: The maximum number of retry attempts to make before the request fails. Retry attempts continue until either the maximum number of attempts is made or until the duration of the `MaximumEventAgeInSeconds` is met.
        """
        if maximum_event_age_in_seconds is not None:
            pulumi.set(__self__, "maximum_event_age_in_seconds", maximum_event_age_in_seconds)
        if maximum_retry_attempts is not None:
            pulumi.set(__self__, "maximum_retry_attempts", maximum_retry_attempts)

    @property
    @pulumi.getter(name="maximumEventAgeInSeconds")
    def maximum_event_age_in_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum amount of time, in seconds, to continue to make retry attempts.
        """
        return pulumi.get(self, "maximum_event_age_in_seconds")

    @maximum_event_age_in_seconds.setter
    def maximum_event_age_in_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_event_age_in_seconds", value)

    @property
    @pulumi.getter(name="maximumRetryAttempts")
    def maximum_retry_attempts(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of retry attempts to make before the request fails. Retry attempts continue until either the maximum number of attempts is made or until the duration of the `MaximumEventAgeInSeconds` is met.
        """
        return pulumi.get(self, "maximum_retry_attempts")

    @maximum_retry_attempts.setter
    def maximum_retry_attempts(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "maximum_retry_attempts", value)


if not MYPY:
    class RuleRunCommandParametersArgsDict(TypedDict):
        run_command_targets: pulumi.Input[Sequence[pulumi.Input['RuleRunCommandTargetArgsDict']]]
        """
        Currently, we support including only one RunCommandTarget block, which specifies either an array of InstanceIds or a tag.
        """
elif False:
    RuleRunCommandParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleRunCommandParametersArgs:
    def __init__(__self__, *,
                 run_command_targets: pulumi.Input[Sequence[pulumi.Input['RuleRunCommandTargetArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['RuleRunCommandTargetArgs']]] run_command_targets: Currently, we support including only one RunCommandTarget block, which specifies either an array of InstanceIds or a tag.
        """
        pulumi.set(__self__, "run_command_targets", run_command_targets)

    @property
    @pulumi.getter(name="runCommandTargets")
    def run_command_targets(self) -> pulumi.Input[Sequence[pulumi.Input['RuleRunCommandTargetArgs']]]:
        """
        Currently, we support including only one RunCommandTarget block, which specifies either an array of InstanceIds or a tag.
        """
        return pulumi.get(self, "run_command_targets")

    @run_command_targets.setter
    def run_command_targets(self, value: pulumi.Input[Sequence[pulumi.Input['RuleRunCommandTargetArgs']]]):
        pulumi.set(self, "run_command_targets", value)


if not MYPY:
    class RuleRunCommandTargetArgsDict(TypedDict):
        key: pulumi.Input[str]
        """
        Can be either `tag:` *tag-key* or `InstanceIds` .
        """
        values: pulumi.Input[Sequence[pulumi.Input[str]]]
        """
        If `Key` is `tag:` *tag-key* , `Values` is a list of tag values. If `Key` is `InstanceIds` , `Values` is a list of Amazon EC2 instance IDs.
        """
elif False:
    RuleRunCommandTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleRunCommandTargetArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 values: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[str] key: Can be either `tag:` *tag-key* or `InstanceIds` .
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: If `Key` is `tag:` *tag-key* , `Values` is a list of tag values. If `Key` is `InstanceIds` , `Values` is a list of Amazon EC2 instance IDs.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        Can be either `tag:` *tag-key* or `InstanceIds` .
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        If `Key` is `tag:` *tag-key* , `Values` is a list of tag values. If `Key` is `InstanceIds` , `Values` is a list of Amazon EC2 instance IDs.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class RuleSageMakerPipelineParametersArgsDict(TypedDict):
        pipeline_parameter_list: NotRequired[pulumi.Input[Sequence[pulumi.Input['RuleSageMakerPipelineParameterArgsDict']]]]
        """
        List of Parameter names and values for SageMaker Model Building Pipeline execution.
        """
elif False:
    RuleSageMakerPipelineParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleSageMakerPipelineParametersArgs:
    def __init__(__self__, *,
                 pipeline_parameter_list: Optional[pulumi.Input[Sequence[pulumi.Input['RuleSageMakerPipelineParameterArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['RuleSageMakerPipelineParameterArgs']]] pipeline_parameter_list: List of Parameter names and values for SageMaker Model Building Pipeline execution.
        """
        if pipeline_parameter_list is not None:
            pulumi.set(__self__, "pipeline_parameter_list", pipeline_parameter_list)

    @property
    @pulumi.getter(name="pipelineParameterList")
    def pipeline_parameter_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleSageMakerPipelineParameterArgs']]]]:
        """
        List of Parameter names and values for SageMaker Model Building Pipeline execution.
        """
        return pulumi.get(self, "pipeline_parameter_list")

    @pipeline_parameter_list.setter
    def pipeline_parameter_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleSageMakerPipelineParameterArgs']]]]):
        pulumi.set(self, "pipeline_parameter_list", value)


if not MYPY:
    class RuleSageMakerPipelineParameterArgsDict(TypedDict):
        name: pulumi.Input[str]
        """
        Name of parameter to start execution of a SageMaker Model Building Pipeline.
        """
        value: pulumi.Input[str]
        """
        Value of parameter to start execution of a SageMaker Model Building Pipeline.
        """
elif False:
    RuleSageMakerPipelineParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleSageMakerPipelineParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: Name of parameter to start execution of a SageMaker Model Building Pipeline.
        :param pulumi.Input[str] value: Value of parameter to start execution of a SageMaker Model Building Pipeline.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of parameter to start execution of a SageMaker Model Building Pipeline.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Value of parameter to start execution of a SageMaker Model Building Pipeline.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class RuleSqsParametersArgsDict(TypedDict):
        message_group_id: pulumi.Input[str]
        """
        The FIFO message group ID to use as the target.
        """
elif False:
    RuleSqsParametersArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleSqsParametersArgs:
    def __init__(__self__, *,
                 message_group_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] message_group_id: The FIFO message group ID to use as the target.
        """
        pulumi.set(__self__, "message_group_id", message_group_id)

    @property
    @pulumi.getter(name="messageGroupId")
    def message_group_id(self) -> pulumi.Input[str]:
        """
        The FIFO message group ID to use as the target.
        """
        return pulumi.get(self, "message_group_id")

    @message_group_id.setter
    def message_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "message_group_id", value)


if not MYPY:
    class RuleTagArgsDict(TypedDict):
        key: NotRequired[pulumi.Input[str]]
        """
        A string you can use to assign a value. The combination of tag keys and values can help you organize and categorize your resources.
        """
        value: NotRequired[pulumi.Input[str]]
        """
        The value for the specified tag key.
        """
elif False:
    RuleTagArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleTagArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: A string you can use to assign a value. The combination of tag keys and values can help you organize and categorize your resources.
        :param pulumi.Input[str] value: The value for the specified tag key.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        A string you can use to assign a value. The combination of tag keys and values can help you organize and categorize your resources.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value for the specified tag key.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class RuleTargetArgsDict(TypedDict):
        arn: pulumi.Input[str]
        """
        The Amazon Resource Name (ARN) of the target.
        """
        id: pulumi.Input[str]
        """
        The ID of the target within the specified rule. Use this ID to reference the target when updating the rule. We recommend using a memorable and unique string.
        """
        app_sync_parameters: NotRequired[pulumi.Input['RuleAppSyncParametersArgsDict']]
        """
        Contains the GraphQL operation to be parsed and executed, if the event target is an AWS AppSync API.
        """
        batch_parameters: NotRequired[pulumi.Input['RuleBatchParametersArgsDict']]
        """
        If the event target is an AWS Batch job, this contains the job definition, job name, and other parameters. For more information, see [Jobs](https://docs.aws.amazon.com/batch/latest/userguide/jobs.html) in the *AWS Batch User Guide* .
        """
        dead_letter_config: NotRequired[pulumi.Input['RuleDeadLetterConfigArgsDict']]
        """
        The `DeadLetterConfig` that defines the target queue to send dead-letter queue events to.
        """
        ecs_parameters: NotRequired[pulumi.Input['RuleEcsParametersArgsDict']]
        """
        Contains the Amazon ECS task definition and task count to be used, if the event target is an Amazon ECS task. For more information about Amazon ECS tasks, see [Task Definitions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html) in the *Amazon EC2 Container Service Developer Guide* .
        """
        http_parameters: NotRequired[pulumi.Input['RuleHttpParametersArgsDict']]
        """
        Contains the HTTP parameters to use when the target is a API Gateway endpoint or EventBridge ApiDestination.

        If you specify an API Gateway API or EventBridge ApiDestination as a target, you can use this parameter to specify headers, path parameters, and query string keys/values as part of your target invoking request. If you're using ApiDestinations, the corresponding Connection can also have these values configured. In case of any conflicting keys, values from the Connection take precedence.
        """
        input: NotRequired[pulumi.Input[str]]
        """
        Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. For more information, see [The JavaScript Object Notation (JSON) Data Interchange Format](https://docs.aws.amazon.com/http://www.rfc-editor.org/rfc/rfc7159.txt) .
        """
        input_path: NotRequired[pulumi.Input[str]]
        """
        The value of the JSONPath that is used for extracting part of the matched event when passing it to the target. You may use JSON dot notation or bracket notation. For more information about JSON paths, see [JSONPath](https://docs.aws.amazon.com/http://goessner.net/articles/JsonPath/) .
        """
        input_transformer: NotRequired[pulumi.Input['RuleInputTransformerArgsDict']]
        """
        Settings to enable you to provide custom input to a target based on certain event data. You can extract one or more key-value pairs from the event and then use that data to send customized input to the target.
        """
        kinesis_parameters: NotRequired[pulumi.Input['RuleKinesisParametersArgsDict']]
        """
        The custom parameter you can use to control the shard assignment, when the target is a Kinesis data stream. If you do not include this parameter, the default is to use the `eventId` as the partition key.
        """
        redshift_data_parameters: NotRequired[pulumi.Input['RuleRedshiftDataParametersArgsDict']]
        """
        Contains the Amazon Redshift Data API parameters to use when the target is a Amazon Redshift cluster.

        If you specify a Amazon Redshift Cluster as a Target, you can use this to specify parameters to invoke the Amazon Redshift Data API ExecuteStatement based on EventBridge events.
        """
        retry_policy: NotRequired[pulumi.Input['RuleRetryPolicyArgsDict']]
        """
        The `RetryPolicy` object that contains the retry policy configuration to use for the dead-letter queue.
        """
        role_arn: NotRequired[pulumi.Input[str]]
        """
        The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. If one rule triggers multiple targets, you can use a different IAM role for each target.
        """
        run_command_parameters: NotRequired[pulumi.Input['RuleRunCommandParametersArgsDict']]
        """
        Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
        """
        sage_maker_pipeline_parameters: NotRequired[pulumi.Input['RuleSageMakerPipelineParametersArgsDict']]
        """
        Contains the SageMaker Model Building Pipeline parameters to start execution of a SageMaker Model Building Pipeline.

        If you specify a SageMaker Model Building Pipeline as a target, you can use this to specify parameters to start a pipeline execution based on EventBridge events.
        """
        sqs_parameters: NotRequired[pulumi.Input['RuleSqsParametersArgsDict']]
        """
        Contains the message group ID to use when the target is a FIFO queue.

        If you specify an SQS FIFO queue as a target, the queue must have content-based deduplication enabled.
        """
elif False:
    RuleTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RuleTargetArgs:
    def __init__(__self__, *,
                 arn: pulumi.Input[str],
                 id: pulumi.Input[str],
                 app_sync_parameters: Optional[pulumi.Input['RuleAppSyncParametersArgs']] = None,
                 batch_parameters: Optional[pulumi.Input['RuleBatchParametersArgs']] = None,
                 dead_letter_config: Optional[pulumi.Input['RuleDeadLetterConfigArgs']] = None,
                 ecs_parameters: Optional[pulumi.Input['RuleEcsParametersArgs']] = None,
                 http_parameters: Optional[pulumi.Input['RuleHttpParametersArgs']] = None,
                 input: Optional[pulumi.Input[str]] = None,
                 input_path: Optional[pulumi.Input[str]] = None,
                 input_transformer: Optional[pulumi.Input['RuleInputTransformerArgs']] = None,
                 kinesis_parameters: Optional[pulumi.Input['RuleKinesisParametersArgs']] = None,
                 redshift_data_parameters: Optional[pulumi.Input['RuleRedshiftDataParametersArgs']] = None,
                 retry_policy: Optional[pulumi.Input['RuleRetryPolicyArgs']] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 run_command_parameters: Optional[pulumi.Input['RuleRunCommandParametersArgs']] = None,
                 sage_maker_pipeline_parameters: Optional[pulumi.Input['RuleSageMakerPipelineParametersArgs']] = None,
                 sqs_parameters: Optional[pulumi.Input['RuleSqsParametersArgs']] = None):
        """
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) of the target.
        :param pulumi.Input[str] id: The ID of the target within the specified rule. Use this ID to reference the target when updating the rule. We recommend using a memorable and unique string.
        :param pulumi.Input['RuleAppSyncParametersArgs'] app_sync_parameters: Contains the GraphQL operation to be parsed and executed, if the event target is an AWS AppSync API.
        :param pulumi.Input['RuleBatchParametersArgs'] batch_parameters: If the event target is an AWS Batch job, this contains the job definition, job name, and other parameters. For more information, see [Jobs](https://docs.aws.amazon.com/batch/latest/userguide/jobs.html) in the *AWS Batch User Guide* .
        :param pulumi.Input['RuleDeadLetterConfigArgs'] dead_letter_config: The `DeadLetterConfig` that defines the target queue to send dead-letter queue events to.
        :param pulumi.Input['RuleEcsParametersArgs'] ecs_parameters: Contains the Amazon ECS task definition and task count to be used, if the event target is an Amazon ECS task. For more information about Amazon ECS tasks, see [Task Definitions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html) in the *Amazon EC2 Container Service Developer Guide* .
        :param pulumi.Input['RuleHttpParametersArgs'] http_parameters: Contains the HTTP parameters to use when the target is a API Gateway endpoint or EventBridge ApiDestination.
               
               If you specify an API Gateway API or EventBridge ApiDestination as a target, you can use this parameter to specify headers, path parameters, and query string keys/values as part of your target invoking request. If you're using ApiDestinations, the corresponding Connection can also have these values configured. In case of any conflicting keys, values from the Connection take precedence.
        :param pulumi.Input[str] input: Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. For more information, see [The JavaScript Object Notation (JSON) Data Interchange Format](https://docs.aws.amazon.com/http://www.rfc-editor.org/rfc/rfc7159.txt) .
        :param pulumi.Input[str] input_path: The value of the JSONPath that is used for extracting part of the matched event when passing it to the target. You may use JSON dot notation or bracket notation. For more information about JSON paths, see [JSONPath](https://docs.aws.amazon.com/http://goessner.net/articles/JsonPath/) .
        :param pulumi.Input['RuleInputTransformerArgs'] input_transformer: Settings to enable you to provide custom input to a target based on certain event data. You can extract one or more key-value pairs from the event and then use that data to send customized input to the target.
        :param pulumi.Input['RuleKinesisParametersArgs'] kinesis_parameters: The custom parameter you can use to control the shard assignment, when the target is a Kinesis data stream. If you do not include this parameter, the default is to use the `eventId` as the partition key.
        :param pulumi.Input['RuleRedshiftDataParametersArgs'] redshift_data_parameters: Contains the Amazon Redshift Data API parameters to use when the target is a Amazon Redshift cluster.
               
               If you specify a Amazon Redshift Cluster as a Target, you can use this to specify parameters to invoke the Amazon Redshift Data API ExecuteStatement based on EventBridge events.
        :param pulumi.Input['RuleRetryPolicyArgs'] retry_policy: The `RetryPolicy` object that contains the retry policy configuration to use for the dead-letter queue.
        :param pulumi.Input[str] role_arn: The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. If one rule triggers multiple targets, you can use a different IAM role for each target.
        :param pulumi.Input['RuleRunCommandParametersArgs'] run_command_parameters: Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
        :param pulumi.Input['RuleSageMakerPipelineParametersArgs'] sage_maker_pipeline_parameters: Contains the SageMaker Model Building Pipeline parameters to start execution of a SageMaker Model Building Pipeline.
               
               If you specify a SageMaker Model Building Pipeline as a target, you can use this to specify parameters to start a pipeline execution based on EventBridge events.
        :param pulumi.Input['RuleSqsParametersArgs'] sqs_parameters: Contains the message group ID to use when the target is a FIFO queue.
               
               If you specify an SQS FIFO queue as a target, the queue must have content-based deduplication enabled.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "id", id)
        if app_sync_parameters is not None:
            pulumi.set(__self__, "app_sync_parameters", app_sync_parameters)
        if batch_parameters is not None:
            pulumi.set(__self__, "batch_parameters", batch_parameters)
        if dead_letter_config is not None:
            pulumi.set(__self__, "dead_letter_config", dead_letter_config)
        if ecs_parameters is not None:
            pulumi.set(__self__, "ecs_parameters", ecs_parameters)
        if http_parameters is not None:
            pulumi.set(__self__, "http_parameters", http_parameters)
        if input is not None:
            pulumi.set(__self__, "input", input)
        if input_path is not None:
            pulumi.set(__self__, "input_path", input_path)
        if input_transformer is not None:
            pulumi.set(__self__, "input_transformer", input_transformer)
        if kinesis_parameters is not None:
            pulumi.set(__self__, "kinesis_parameters", kinesis_parameters)
        if redshift_data_parameters is not None:
            pulumi.set(__self__, "redshift_data_parameters", redshift_data_parameters)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if run_command_parameters is not None:
            pulumi.set(__self__, "run_command_parameters", run_command_parameters)
        if sage_maker_pipeline_parameters is not None:
            pulumi.set(__self__, "sage_maker_pipeline_parameters", sage_maker_pipeline_parameters)
        if sqs_parameters is not None:
            pulumi.set(__self__, "sqs_parameters", sqs_parameters)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the target.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The ID of the target within the specified rule. Use this ID to reference the target when updating the rule. We recommend using a memorable and unique string.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="appSyncParameters")
    def app_sync_parameters(self) -> Optional[pulumi.Input['RuleAppSyncParametersArgs']]:
        """
        Contains the GraphQL operation to be parsed and executed, if the event target is an AWS AppSync API.
        """
        return pulumi.get(self, "app_sync_parameters")

    @app_sync_parameters.setter
    def app_sync_parameters(self, value: Optional[pulumi.Input['RuleAppSyncParametersArgs']]):
        pulumi.set(self, "app_sync_parameters", value)

    @property
    @pulumi.getter(name="batchParameters")
    def batch_parameters(self) -> Optional[pulumi.Input['RuleBatchParametersArgs']]:
        """
        If the event target is an AWS Batch job, this contains the job definition, job name, and other parameters. For more information, see [Jobs](https://docs.aws.amazon.com/batch/latest/userguide/jobs.html) in the *AWS Batch User Guide* .
        """
        return pulumi.get(self, "batch_parameters")

    @batch_parameters.setter
    def batch_parameters(self, value: Optional[pulumi.Input['RuleBatchParametersArgs']]):
        pulumi.set(self, "batch_parameters", value)

    @property
    @pulumi.getter(name="deadLetterConfig")
    def dead_letter_config(self) -> Optional[pulumi.Input['RuleDeadLetterConfigArgs']]:
        """
        The `DeadLetterConfig` that defines the target queue to send dead-letter queue events to.
        """
        return pulumi.get(self, "dead_letter_config")

    @dead_letter_config.setter
    def dead_letter_config(self, value: Optional[pulumi.Input['RuleDeadLetterConfigArgs']]):
        pulumi.set(self, "dead_letter_config", value)

    @property
    @pulumi.getter(name="ecsParameters")
    def ecs_parameters(self) -> Optional[pulumi.Input['RuleEcsParametersArgs']]:
        """
        Contains the Amazon ECS task definition and task count to be used, if the event target is an Amazon ECS task. For more information about Amazon ECS tasks, see [Task Definitions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html) in the *Amazon EC2 Container Service Developer Guide* .
        """
        return pulumi.get(self, "ecs_parameters")

    @ecs_parameters.setter
    def ecs_parameters(self, value: Optional[pulumi.Input['RuleEcsParametersArgs']]):
        pulumi.set(self, "ecs_parameters", value)

    @property
    @pulumi.getter(name="httpParameters")
    def http_parameters(self) -> Optional[pulumi.Input['RuleHttpParametersArgs']]:
        """
        Contains the HTTP parameters to use when the target is a API Gateway endpoint or EventBridge ApiDestination.

        If you specify an API Gateway API or EventBridge ApiDestination as a target, you can use this parameter to specify headers, path parameters, and query string keys/values as part of your target invoking request. If you're using ApiDestinations, the corresponding Connection can also have these values configured. In case of any conflicting keys, values from the Connection take precedence.
        """
        return pulumi.get(self, "http_parameters")

    @http_parameters.setter
    def http_parameters(self, value: Optional[pulumi.Input['RuleHttpParametersArgs']]):
        pulumi.set(self, "http_parameters", value)

    @property
    @pulumi.getter
    def input(self) -> Optional[pulumi.Input[str]]:
        """
        Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. For more information, see [The JavaScript Object Notation (JSON) Data Interchange Format](https://docs.aws.amazon.com/http://www.rfc-editor.org/rfc/rfc7159.txt) .
        """
        return pulumi.get(self, "input")

    @input.setter
    def input(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input", value)

    @property
    @pulumi.getter(name="inputPath")
    def input_path(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the JSONPath that is used for extracting part of the matched event when passing it to the target. You may use JSON dot notation or bracket notation. For more information about JSON paths, see [JSONPath](https://docs.aws.amazon.com/http://goessner.net/articles/JsonPath/) .
        """
        return pulumi.get(self, "input_path")

    @input_path.setter
    def input_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input_path", value)

    @property
    @pulumi.getter(name="inputTransformer")
    def input_transformer(self) -> Optional[pulumi.Input['RuleInputTransformerArgs']]:
        """
        Settings to enable you to provide custom input to a target based on certain event data. You can extract one or more key-value pairs from the event and then use that data to send customized input to the target.
        """
        return pulumi.get(self, "input_transformer")

    @input_transformer.setter
    def input_transformer(self, value: Optional[pulumi.Input['RuleInputTransformerArgs']]):
        pulumi.set(self, "input_transformer", value)

    @property
    @pulumi.getter(name="kinesisParameters")
    def kinesis_parameters(self) -> Optional[pulumi.Input['RuleKinesisParametersArgs']]:
        """
        The custom parameter you can use to control the shard assignment, when the target is a Kinesis data stream. If you do not include this parameter, the default is to use the `eventId` as the partition key.
        """
        return pulumi.get(self, "kinesis_parameters")

    @kinesis_parameters.setter
    def kinesis_parameters(self, value: Optional[pulumi.Input['RuleKinesisParametersArgs']]):
        pulumi.set(self, "kinesis_parameters", value)

    @property
    @pulumi.getter(name="redshiftDataParameters")
    def redshift_data_parameters(self) -> Optional[pulumi.Input['RuleRedshiftDataParametersArgs']]:
        """
        Contains the Amazon Redshift Data API parameters to use when the target is a Amazon Redshift cluster.

        If you specify a Amazon Redshift Cluster as a Target, you can use this to specify parameters to invoke the Amazon Redshift Data API ExecuteStatement based on EventBridge events.
        """
        return pulumi.get(self, "redshift_data_parameters")

    @redshift_data_parameters.setter
    def redshift_data_parameters(self, value: Optional[pulumi.Input['RuleRedshiftDataParametersArgs']]):
        pulumi.set(self, "redshift_data_parameters", value)

    @property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional[pulumi.Input['RuleRetryPolicyArgs']]:
        """
        The `RetryPolicy` object that contains the retry policy configuration to use for the dead-letter queue.
        """
        return pulumi.get(self, "retry_policy")

    @retry_policy.setter
    def retry_policy(self, value: Optional[pulumi.Input['RuleRetryPolicyArgs']]):
        pulumi.set(self, "retry_policy", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the IAM role to be used for this target when the rule is triggered. If one rule triggers multiple targets, you can use a different IAM role for each target.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="runCommandParameters")
    def run_command_parameters(self) -> Optional[pulumi.Input['RuleRunCommandParametersArgs']]:
        """
        Parameters used when you are using the rule to invoke Amazon EC2 Run Command.
        """
        return pulumi.get(self, "run_command_parameters")

    @run_command_parameters.setter
    def run_command_parameters(self, value: Optional[pulumi.Input['RuleRunCommandParametersArgs']]):
        pulumi.set(self, "run_command_parameters", value)

    @property
    @pulumi.getter(name="sageMakerPipelineParameters")
    def sage_maker_pipeline_parameters(self) -> Optional[pulumi.Input['RuleSageMakerPipelineParametersArgs']]:
        """
        Contains the SageMaker Model Building Pipeline parameters to start execution of a SageMaker Model Building Pipeline.

        If you specify a SageMaker Model Building Pipeline as a target, you can use this to specify parameters to start a pipeline execution based on EventBridge events.
        """
        return pulumi.get(self, "sage_maker_pipeline_parameters")

    @sage_maker_pipeline_parameters.setter
    def sage_maker_pipeline_parameters(self, value: Optional[pulumi.Input['RuleSageMakerPipelineParametersArgs']]):
        pulumi.set(self, "sage_maker_pipeline_parameters", value)

    @property
    @pulumi.getter(name="sqsParameters")
    def sqs_parameters(self) -> Optional[pulumi.Input['RuleSqsParametersArgs']]:
        """
        Contains the message group ID to use when the target is a FIFO queue.

        If you specify an SQS FIFO queue as a target, the queue must have content-based deduplication enabled.
        """
        return pulumi.get(self, "sqs_parameters")

    @sqs_parameters.setter
    def sqs_parameters(self, value: Optional[pulumi.Input['RuleSqsParametersArgs']]):
        pulumi.set(self, "sqs_parameters", value)


