# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = ['PolicyStatementArgs', 'PolicyStatement']

@pulumi.input_type
class PolicyStatementArgs:
    def __init__(__self__, *,
                 arn: pulumi.Input[str],
                 statement_id: pulumi.Input[str],
                 action: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 condition: Optional[pulumi.Input[str]] = None,
                 effect: Optional[pulumi.Input['PolicyStatementStatementEffect']] = None,
                 principal: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a PolicyStatement resource.
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) of the resource that will be accessed by the principal.
        :param pulumi.Input[str] statement_id: A statement identifier that differentiates the statement from others in the same policy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] action: The action that the principal can use on the resource.
               
               For example, `entityresolution:GetIdMappingJob` , `entityresolution:GetMatchingJob` .
        :param pulumi.Input[str] condition: A set of condition keys that you can use in key policies.
        :param pulumi.Input['PolicyStatementStatementEffect'] effect: Determines whether the permissions specified in the policy are to be allowed ( `Allow` ) or denied ( `Deny` ).
               
               > If you set the value of the `effect` parameter to `Deny` for the `AddPolicyStatement` operation, you must also set the value of the `effect` parameter in the `policy` to `Deny` for the `PutPolicy` operation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] principal: The AWS service or AWS account that can access the resource defined as ARN.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "statement_id", statement_id)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the resource that will be accessed by the principal.
        """
        return pulumi.get(self, "arn")

    @arn.setter
    def arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "arn", value)

    @property
    @pulumi.getter(name="statementId")
    def statement_id(self) -> pulumi.Input[str]:
        """
        A statement identifier that differentiates the statement from others in the same policy.
        """
        return pulumi.get(self, "statement_id")

    @statement_id.setter
    def statement_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "statement_id", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The action that the principal can use on the resource.

        For example, `entityresolution:GetIdMappingJob` , `entityresolution:GetMatchingJob` .
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[str]]:
        """
        A set of condition keys that you can use in key policies.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[pulumi.Input['PolicyStatementStatementEffect']]:
        """
        Determines whether the permissions specified in the policy are to be allowed ( `Allow` ) or denied ( `Deny` ).

        > If you set the value of the `effect` parameter to `Deny` for the `AddPolicyStatement` operation, you must also set the value of the `effect` parameter in the `policy` to `Deny` for the `PutPolicy` operation.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: Optional[pulumi.Input['PolicyStatementStatementEffect']]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def principal(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The AWS service or AWS account that can access the resource defined as ARN.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "principal", value)


class PolicyStatement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 condition: Optional[pulumi.Input[str]] = None,
                 effect: Optional[pulumi.Input['PolicyStatementStatementEffect']] = None,
                 principal: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 statement_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Policy Statement defined in AWS Entity Resolution Service

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] action: The action that the principal can use on the resource.
               
               For example, `entityresolution:GetIdMappingJob` , `entityresolution:GetMatchingJob` .
        :param pulumi.Input[str] arn: The Amazon Resource Name (ARN) of the resource that will be accessed by the principal.
        :param pulumi.Input[str] condition: A set of condition keys that you can use in key policies.
        :param pulumi.Input['PolicyStatementStatementEffect'] effect: Determines whether the permissions specified in the policy are to be allowed ( `Allow` ) or denied ( `Deny` ).
               
               > If you set the value of the `effect` parameter to `Deny` for the `AddPolicyStatement` operation, you must also set the value of the `effect` parameter in the `policy` to `Deny` for the `PutPolicy` operation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] principal: The AWS service or AWS account that can access the resource defined as ARN.
        :param pulumi.Input[str] statement_id: A statement identifier that differentiates the statement from others in the same policy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyStatementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Policy Statement defined in AWS Entity Resolution Service

        :param str resource_name: The name of the resource.
        :param PolicyStatementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyStatementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 arn: Optional[pulumi.Input[str]] = None,
                 condition: Optional[pulumi.Input[str]] = None,
                 effect: Optional[pulumi.Input['PolicyStatementStatementEffect']] = None,
                 principal: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 statement_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyStatementArgs.__new__(PolicyStatementArgs)

            __props__.__dict__["action"] = action
            if arn is None and not opts.urn:
                raise TypeError("Missing required property 'arn'")
            __props__.__dict__["arn"] = arn
            __props__.__dict__["condition"] = condition
            __props__.__dict__["effect"] = effect
            __props__.__dict__["principal"] = principal
            if statement_id is None and not opts.urn:
                raise TypeError("Missing required property 'statement_id'")
            __props__.__dict__["statement_id"] = statement_id
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["arn", "statementId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(PolicyStatement, __self__).__init__(
            'aws-native:entityresolution:PolicyStatement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'PolicyStatement':
        """
        Get an existing PolicyStatement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PolicyStatementArgs.__new__(PolicyStatementArgs)

        __props__.__dict__["action"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["condition"] = None
        __props__.__dict__["effect"] = None
        __props__.__dict__["principal"] = None
        __props__.__dict__["statement_id"] = None
        return PolicyStatement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The action that the principal can use on the resource.

        For example, `entityresolution:GetIdMappingJob` , `entityresolution:GetMatchingJob` .
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the resource that will be accessed by the principal.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Output[Optional[str]]:
        """
        A set of condition keys that you can use in key policies.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def effect(self) -> pulumi.Output[Optional['PolicyStatementStatementEffect']]:
        """
        Determines whether the permissions specified in the policy are to be allowed ( `Allow` ) or denied ( `Deny` ).

        > If you set the value of the `effect` parameter to `Deny` for the `AddPolicyStatement` operation, you must also set the value of the `effect` parameter in the `policy` to `Deny` for the `PutPolicy` operation.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def principal(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The AWS service or AWS account that can access the resource defined as ARN.
        """
        return pulumi.get(self, "principal")

    @property
    @pulumi.getter(name="statementId")
    def statement_id(self) -> pulumi.Output[str]:
        """
        A statement identifier that differentiates the statement from others in the same policy.
        """
        return pulumi.get(self, "statement_id")

