# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'IdMappingWorkflowIdMappingRuleBasedProperties',
    'IdMappingWorkflowIdMappingTechniques',
    'IdMappingWorkflowInputSource',
    'IdMappingWorkflowIntermediateSourceConfiguration',
    'IdMappingWorkflowOutputSource',
    'IdMappingWorkflowProviderProperties',
    'IdMappingWorkflowRule',
    'IdNamespaceIdMappingWorkflowProperties',
    'IdNamespaceInputSource',
    'IdNamespaceNamespaceProviderProperties',
    'IdNamespaceNamespaceRuleBasedProperties',
    'IdNamespaceRule',
    'MatchingWorkflowIncrementalRunConfig',
    'MatchingWorkflowInputSource',
    'MatchingWorkflowIntermediateSourceConfiguration',
    'MatchingWorkflowOutputAttribute',
    'MatchingWorkflowOutputSource',
    'MatchingWorkflowProviderProperties',
    'MatchingWorkflowResolutionTechniques',
    'MatchingWorkflowRule',
    'MatchingWorkflowRuleBasedProperties',
    'SchemaMappingSchemaInputAttribute',
]

@pulumi.output_type
class IdMappingWorkflowIdMappingRuleBasedProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeMatchingModel":
            suggest = "attribute_matching_model"
        elif key == "recordMatchingModel":
            suggest = "record_matching_model"
        elif key == "ruleDefinitionType":
            suggest = "rule_definition_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdMappingWorkflowIdMappingRuleBasedProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdMappingWorkflowIdMappingRuleBasedProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdMappingWorkflowIdMappingRuleBasedProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute_matching_model: 'IdMappingWorkflowIdMappingRuleBasedPropertiesAttributeMatchingModel',
                 record_matching_model: 'IdMappingWorkflowIdMappingRuleBasedPropertiesRecordMatchingModel',
                 rule_definition_type: Optional['IdMappingWorkflowIdMappingRuleBasedPropertiesRuleDefinitionType'] = None,
                 rules: Optional[Sequence['outputs.IdMappingWorkflowRule']] = None):
        """
        :param 'IdMappingWorkflowIdMappingRuleBasedPropertiesAttributeMatchingModel' attribute_matching_model: The comparison type. You can either choose `ONE_TO_ONE` or `MANY_TO_MANY` as the `attributeMatchingModel` .
               
               If you choose `MANY_TO_MANY` , the system can match attributes across the sub-types of an attribute type. For example, if the value of the `Email` field of Profile A matches the value of the `BusinessEmail` field of Profile B, the two profiles are matched on the `Email` attribute type.
               
               If you choose `ONE_TO_ONE` , the system can only match attributes if the sub-types are an exact match. For example, for the `Email` attribute type, the system will only consider it a match if the value of the `Email` field of Profile A matches the value of the `Email` field of Profile B.
        :param 'IdMappingWorkflowIdMappingRuleBasedPropertiesRecordMatchingModel' record_matching_model: The type of matching record that is allowed to be used in an ID mapping workflow.
               
               If the value is set to `ONE_SOURCE_TO_ONE_TARGET` , only one record in the source can be matched to the same record in the target.
               
               If the value is set to `MANY_SOURCE_TO_ONE_TARGET` , multiple records in the source can be matched to one record in the target.
        :param 'IdMappingWorkflowIdMappingRuleBasedPropertiesRuleDefinitionType' rule_definition_type: The set of rules you can use in an ID mapping workflow. The limitations specified for the source or target to define the match rules must be compatible.
        :param Sequence['IdMappingWorkflowRule'] rules: The rules that can be used for ID mapping.
        """
        pulumi.set(__self__, "attribute_matching_model", attribute_matching_model)
        pulumi.set(__self__, "record_matching_model", record_matching_model)
        if rule_definition_type is not None:
            pulumi.set(__self__, "rule_definition_type", rule_definition_type)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="attributeMatchingModel")
    def attribute_matching_model(self) -> 'IdMappingWorkflowIdMappingRuleBasedPropertiesAttributeMatchingModel':
        """
        The comparison type. You can either choose `ONE_TO_ONE` or `MANY_TO_MANY` as the `attributeMatchingModel` .

        If you choose `MANY_TO_MANY` , the system can match attributes across the sub-types of an attribute type. For example, if the value of the `Email` field of Profile A matches the value of the `BusinessEmail` field of Profile B, the two profiles are matched on the `Email` attribute type.

        If you choose `ONE_TO_ONE` , the system can only match attributes if the sub-types are an exact match. For example, for the `Email` attribute type, the system will only consider it a match if the value of the `Email` field of Profile A matches the value of the `Email` field of Profile B.
        """
        return pulumi.get(self, "attribute_matching_model")

    @property
    @pulumi.getter(name="recordMatchingModel")
    def record_matching_model(self) -> 'IdMappingWorkflowIdMappingRuleBasedPropertiesRecordMatchingModel':
        """
        The type of matching record that is allowed to be used in an ID mapping workflow.

        If the value is set to `ONE_SOURCE_TO_ONE_TARGET` , only one record in the source can be matched to the same record in the target.

        If the value is set to `MANY_SOURCE_TO_ONE_TARGET` , multiple records in the source can be matched to one record in the target.
        """
        return pulumi.get(self, "record_matching_model")

    @property
    @pulumi.getter(name="ruleDefinitionType")
    def rule_definition_type(self) -> Optional['IdMappingWorkflowIdMappingRuleBasedPropertiesRuleDefinitionType']:
        """
        The set of rules you can use in an ID mapping workflow. The limitations specified for the source or target to define the match rules must be compatible.
        """
        return pulumi.get(self, "rule_definition_type")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.IdMappingWorkflowRule']]:
        """
        The rules that can be used for ID mapping.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class IdMappingWorkflowIdMappingTechniques(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idMappingType":
            suggest = "id_mapping_type"
        elif key == "providerProperties":
            suggest = "provider_properties"
        elif key == "ruleBasedProperties":
            suggest = "rule_based_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdMappingWorkflowIdMappingTechniques. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdMappingWorkflowIdMappingTechniques.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdMappingWorkflowIdMappingTechniques.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id_mapping_type: Optional['IdMappingWorkflowIdMappingTechniquesIdMappingType'] = None,
                 provider_properties: Optional['outputs.IdMappingWorkflowProviderProperties'] = None,
                 rule_based_properties: Optional['outputs.IdMappingWorkflowIdMappingRuleBasedProperties'] = None):
        """
        :param 'IdMappingWorkflowIdMappingTechniquesIdMappingType' id_mapping_type: The type of ID mapping.
        :param 'IdMappingWorkflowProviderProperties' provider_properties: An object which defines any additional configurations required by the provider service.
        :param 'IdMappingWorkflowIdMappingRuleBasedProperties' rule_based_properties: An object which defines any additional configurations required by rule-based matching.
        """
        if id_mapping_type is not None:
            pulumi.set(__self__, "id_mapping_type", id_mapping_type)
        if provider_properties is not None:
            pulumi.set(__self__, "provider_properties", provider_properties)
        if rule_based_properties is not None:
            pulumi.set(__self__, "rule_based_properties", rule_based_properties)

    @property
    @pulumi.getter(name="idMappingType")
    def id_mapping_type(self) -> Optional['IdMappingWorkflowIdMappingTechniquesIdMappingType']:
        """
        The type of ID mapping.
        """
        return pulumi.get(self, "id_mapping_type")

    @property
    @pulumi.getter(name="providerProperties")
    def provider_properties(self) -> Optional['outputs.IdMappingWorkflowProviderProperties']:
        """
        An object which defines any additional configurations required by the provider service.
        """
        return pulumi.get(self, "provider_properties")

    @property
    @pulumi.getter(name="ruleBasedProperties")
    def rule_based_properties(self) -> Optional['outputs.IdMappingWorkflowIdMappingRuleBasedProperties']:
        """
        An object which defines any additional configurations required by rule-based matching.
        """
        return pulumi.get(self, "rule_based_properties")


@pulumi.output_type
class IdMappingWorkflowInputSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputSourceArn":
            suggest = "input_source_arn"
        elif key == "schemaArn":
            suggest = "schema_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdMappingWorkflowInputSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdMappingWorkflowInputSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdMappingWorkflowInputSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_source_arn: str,
                 schema_arn: Optional[str] = None,
                 type: Optional['IdMappingWorkflowInputSourceType'] = None):
        """
        :param str input_source_arn: An Glue table ARN for the input source table, MatchingWorkflow arn or IdNamespace ARN
        :param str schema_arn: The ARN (Amazon Resource Name) that AWS Entity Resolution generated for the `SchemaMapping` .
        :param 'IdMappingWorkflowInputSourceType' type: The type of ID namespace. There are two types: `SOURCE` and `TARGET` .
               
               The `SOURCE` contains configurations for `sourceId` data that will be processed in an ID mapping workflow.
               
               The `TARGET` contains a configuration of `targetId` which all `sourceIds` will resolve to.
        """
        pulumi.set(__self__, "input_source_arn", input_source_arn)
        if schema_arn is not None:
            pulumi.set(__self__, "schema_arn", schema_arn)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="inputSourceArn")
    def input_source_arn(self) -> str:
        """
        An Glue table ARN for the input source table, MatchingWorkflow arn or IdNamespace ARN
        """
        return pulumi.get(self, "input_source_arn")

    @property
    @pulumi.getter(name="schemaArn")
    def schema_arn(self) -> Optional[str]:
        """
        The ARN (Amazon Resource Name) that AWS Entity Resolution generated for the `SchemaMapping` .
        """
        return pulumi.get(self, "schema_arn")

    @property
    @pulumi.getter
    def type(self) -> Optional['IdMappingWorkflowInputSourceType']:
        """
        The type of ID namespace. There are two types: `SOURCE` and `TARGET` .

        The `SOURCE` contains configurations for `sourceId` data that will be processed in an ID mapping workflow.

        The `TARGET` contains a configuration of `targetId` which all `sourceIds` will resolve to.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class IdMappingWorkflowIntermediateSourceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intermediateS3Path":
            suggest = "intermediate_s3_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdMappingWorkflowIntermediateSourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdMappingWorkflowIntermediateSourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdMappingWorkflowIntermediateSourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 intermediate_s3_path: str):
        """
        :param str intermediate_s3_path: The s3 path that would be used to stage the intermediate data being generated during workflow execution.
        """
        pulumi.set(__self__, "intermediate_s3_path", intermediate_s3_path)

    @property
    @pulumi.getter(name="intermediateS3Path")
    def intermediate_s3_path(self) -> str:
        """
        The s3 path that would be used to stage the intermediate data being generated during workflow execution.
        """
        return pulumi.get(self, "intermediate_s3_path")


@pulumi.output_type
class IdMappingWorkflowOutputSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputS3Path":
            suggest = "output_s3_path"
        elif key == "kmsArn":
            suggest = "kms_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdMappingWorkflowOutputSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdMappingWorkflowOutputSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdMappingWorkflowOutputSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 output_s3_path: str,
                 kms_arn: Optional[str] = None):
        """
        :param str output_s3_path: The S3 path to which Entity Resolution will write the output table
        :param str kms_arn: Customer AWS KMS ARN for encryption at rest. If not provided, system will use an AWS Entity Resolution managed KMS key.
        """
        pulumi.set(__self__, "output_s3_path", output_s3_path)
        if kms_arn is not None:
            pulumi.set(__self__, "kms_arn", kms_arn)

    @property
    @pulumi.getter(name="outputS3Path")
    def output_s3_path(self) -> str:
        """
        The S3 path to which Entity Resolution will write the output table
        """
        return pulumi.get(self, "output_s3_path")

    @property
    @pulumi.getter(name="kmsArn")
    def kms_arn(self) -> Optional[str]:
        """
        Customer AWS KMS ARN for encryption at rest. If not provided, system will use an AWS Entity Resolution managed KMS key.
        """
        return pulumi.get(self, "kms_arn")


@pulumi.output_type
class IdMappingWorkflowProviderProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "providerServiceArn":
            suggest = "provider_service_arn"
        elif key == "intermediateSourceConfiguration":
            suggest = "intermediate_source_configuration"
        elif key == "providerConfiguration":
            suggest = "provider_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdMappingWorkflowProviderProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdMappingWorkflowProviderProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdMappingWorkflowProviderProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provider_service_arn: str,
                 intermediate_source_configuration: Optional['outputs.IdMappingWorkflowIntermediateSourceConfiguration'] = None,
                 provider_configuration: Optional[Mapping[str, str]] = None):
        """
        :param str provider_service_arn: Arn of the Provider Service being used.
        :param 'IdMappingWorkflowIntermediateSourceConfiguration' intermediate_source_configuration: The Amazon S3 location that temporarily stores your data while it processes. Your information won't be saved permanently.
        :param Mapping[str, str] provider_configuration: Additional Provider configuration that would be required for the provider service. The Configuration must be in JSON string format
        """
        pulumi.set(__self__, "provider_service_arn", provider_service_arn)
        if intermediate_source_configuration is not None:
            pulumi.set(__self__, "intermediate_source_configuration", intermediate_source_configuration)
        if provider_configuration is not None:
            pulumi.set(__self__, "provider_configuration", provider_configuration)

    @property
    @pulumi.getter(name="providerServiceArn")
    def provider_service_arn(self) -> str:
        """
        Arn of the Provider Service being used.
        """
        return pulumi.get(self, "provider_service_arn")

    @property
    @pulumi.getter(name="intermediateSourceConfiguration")
    def intermediate_source_configuration(self) -> Optional['outputs.IdMappingWorkflowIntermediateSourceConfiguration']:
        """
        The Amazon S3 location that temporarily stores your data while it processes. Your information won't be saved permanently.
        """
        return pulumi.get(self, "intermediate_source_configuration")

    @property
    @pulumi.getter(name="providerConfiguration")
    def provider_configuration(self) -> Optional[Mapping[str, str]]:
        """
        Additional Provider configuration that would be required for the provider service. The Configuration must be in JSON string format
        """
        return pulumi.get(self, "provider_configuration")


@pulumi.output_type
class IdMappingWorkflowRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchingKeys":
            suggest = "matching_keys"
        elif key == "ruleName":
            suggest = "rule_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdMappingWorkflowRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdMappingWorkflowRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdMappingWorkflowRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 matching_keys: Sequence[str],
                 rule_name: str):
        """
        :param Sequence[str] matching_keys: A list of `MatchingKeys` . The `MatchingKeys` must have been defined in the `SchemaMapping` . Two records are considered to match according to this rule if all of the `MatchingKeys` match.
        :param str rule_name: A name for the matching rule.
        """
        pulumi.set(__self__, "matching_keys", matching_keys)
        pulumi.set(__self__, "rule_name", rule_name)

    @property
    @pulumi.getter(name="matchingKeys")
    def matching_keys(self) -> Sequence[str]:
        """
        A list of `MatchingKeys` . The `MatchingKeys` must have been defined in the `SchemaMapping` . Two records are considered to match according to this rule if all of the `MatchingKeys` match.
        """
        return pulumi.get(self, "matching_keys")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> str:
        """
        A name for the matching rule.
        """
        return pulumi.get(self, "rule_name")


@pulumi.output_type
class IdNamespaceIdMappingWorkflowProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idMappingType":
            suggest = "id_mapping_type"
        elif key == "providerProperties":
            suggest = "provider_properties"
        elif key == "ruleBasedProperties":
            suggest = "rule_based_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdNamespaceIdMappingWorkflowProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdNamespaceIdMappingWorkflowProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdNamespaceIdMappingWorkflowProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id_mapping_type: 'IdNamespaceIdMappingWorkflowPropertiesIdMappingType',
                 provider_properties: Optional['outputs.IdNamespaceNamespaceProviderProperties'] = None,
                 rule_based_properties: Optional['outputs.IdNamespaceNamespaceRuleBasedProperties'] = None):
        """
        :param 'IdNamespaceIdMappingWorkflowPropertiesIdMappingType' id_mapping_type: The type of ID mapping.
        :param 'IdNamespaceNamespaceProviderProperties' provider_properties: An object which defines any additional configurations required by the provider service.
        :param 'IdNamespaceNamespaceRuleBasedProperties' rule_based_properties: An object which defines any additional configurations required by rule-based matching.
        """
        pulumi.set(__self__, "id_mapping_type", id_mapping_type)
        if provider_properties is not None:
            pulumi.set(__self__, "provider_properties", provider_properties)
        if rule_based_properties is not None:
            pulumi.set(__self__, "rule_based_properties", rule_based_properties)

    @property
    @pulumi.getter(name="idMappingType")
    def id_mapping_type(self) -> 'IdNamespaceIdMappingWorkflowPropertiesIdMappingType':
        """
        The type of ID mapping.
        """
        return pulumi.get(self, "id_mapping_type")

    @property
    @pulumi.getter(name="providerProperties")
    def provider_properties(self) -> Optional['outputs.IdNamespaceNamespaceProviderProperties']:
        """
        An object which defines any additional configurations required by the provider service.
        """
        return pulumi.get(self, "provider_properties")

    @property
    @pulumi.getter(name="ruleBasedProperties")
    def rule_based_properties(self) -> Optional['outputs.IdNamespaceNamespaceRuleBasedProperties']:
        """
        An object which defines any additional configurations required by rule-based matching.
        """
        return pulumi.get(self, "rule_based_properties")


@pulumi.output_type
class IdNamespaceInputSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputSourceArn":
            suggest = "input_source_arn"
        elif key == "schemaName":
            suggest = "schema_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdNamespaceInputSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdNamespaceInputSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdNamespaceInputSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_source_arn: str,
                 schema_name: Optional[str] = None):
        """
        :param str input_source_arn: An AWS Glue table Amazon Resource Name (ARN) or a matching workflow ARN for the input source table.
        :param str schema_name: The name of the schema.
        """
        pulumi.set(__self__, "input_source_arn", input_source_arn)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)

    @property
    @pulumi.getter(name="inputSourceArn")
    def input_source_arn(self) -> str:
        """
        An AWS Glue table Amazon Resource Name (ARN) or a matching workflow ARN for the input source table.
        """
        return pulumi.get(self, "input_source_arn")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[str]:
        """
        The name of the schema.
        """
        return pulumi.get(self, "schema_name")


@pulumi.output_type
class IdNamespaceNamespaceProviderProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "providerServiceArn":
            suggest = "provider_service_arn"
        elif key == "providerConfiguration":
            suggest = "provider_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdNamespaceNamespaceProviderProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdNamespaceNamespaceProviderProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdNamespaceNamespaceProviderProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provider_service_arn: str,
                 provider_configuration: Optional[Mapping[str, str]] = None):
        """
        :param str provider_service_arn: The Amazon Resource Name (ARN) of the provider service.
        :param Mapping[str, str] provider_configuration: Additional Provider configuration that would be required for the provider service. The Configuration must be in JSON string format.
        """
        pulumi.set(__self__, "provider_service_arn", provider_service_arn)
        if provider_configuration is not None:
            pulumi.set(__self__, "provider_configuration", provider_configuration)

    @property
    @pulumi.getter(name="providerServiceArn")
    def provider_service_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) of the provider service.
        """
        return pulumi.get(self, "provider_service_arn")

    @property
    @pulumi.getter(name="providerConfiguration")
    def provider_configuration(self) -> Optional[Mapping[str, str]]:
        """
        Additional Provider configuration that would be required for the provider service. The Configuration must be in JSON string format.
        """
        return pulumi.get(self, "provider_configuration")


@pulumi.output_type
class IdNamespaceNamespaceRuleBasedProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeMatchingModel":
            suggest = "attribute_matching_model"
        elif key == "recordMatchingModels":
            suggest = "record_matching_models"
        elif key == "ruleDefinitionTypes":
            suggest = "rule_definition_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdNamespaceNamespaceRuleBasedProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdNamespaceNamespaceRuleBasedProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdNamespaceNamespaceRuleBasedProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute_matching_model: Optional['IdNamespaceNamespaceRuleBasedPropertiesAttributeMatchingModel'] = None,
                 record_matching_models: Optional[Sequence['IdNamespaceRecordMatchingModel']] = None,
                 rule_definition_types: Optional[Sequence['IdNamespaceRuleDefinitionType']] = None,
                 rules: Optional[Sequence['outputs.IdNamespaceRule']] = None):
        """
        :param 'IdNamespaceNamespaceRuleBasedPropertiesAttributeMatchingModel' attribute_matching_model: The comparison type. You can either choose `ONE_TO_ONE` or `MANY_TO_MANY` as the `attributeMatchingModel` .
               
               If you choose `MANY_TO_MANY` , the system can match attributes across the sub-types of an attribute type. For example, if the value of the `Email` field of Profile A matches the value of `BusinessEmail` field of Profile B, the two profiles are matched on the `Email` attribute type.
               
               If you choose `ONE_TO_ONE` , the system can only match attributes if the sub-types are an exact match. For example, for the `Email` attribute type, the system will only consider it a match if the value of the `Email` field of Profile A matches the value of the `Email` field of Profile B.
        :param Sequence['IdNamespaceRecordMatchingModel'] record_matching_models: The type of matching record that is allowed to be used in an ID mapping workflow.
               
               If the value is set to `ONE_SOURCE_TO_ONE_TARGET` , only one record in the source is matched to one record in the target.
               
               If the value is set to `MANY_SOURCE_TO_ONE_TARGET` , all matching records in the source are matched to one record in the target.
        :param Sequence['IdNamespaceRuleDefinitionType'] rule_definition_types: The sets of rules you can use in an ID mapping workflow. The limitations specified for the source and target must be compatible.
        :param Sequence['IdNamespaceRule'] rules: The rules for the ID namespace.
        """
        if attribute_matching_model is not None:
            pulumi.set(__self__, "attribute_matching_model", attribute_matching_model)
        if record_matching_models is not None:
            pulumi.set(__self__, "record_matching_models", record_matching_models)
        if rule_definition_types is not None:
            pulumi.set(__self__, "rule_definition_types", rule_definition_types)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="attributeMatchingModel")
    def attribute_matching_model(self) -> Optional['IdNamespaceNamespaceRuleBasedPropertiesAttributeMatchingModel']:
        """
        The comparison type. You can either choose `ONE_TO_ONE` or `MANY_TO_MANY` as the `attributeMatchingModel` .

        If you choose `MANY_TO_MANY` , the system can match attributes across the sub-types of an attribute type. For example, if the value of the `Email` field of Profile A matches the value of `BusinessEmail` field of Profile B, the two profiles are matched on the `Email` attribute type.

        If you choose `ONE_TO_ONE` , the system can only match attributes if the sub-types are an exact match. For example, for the `Email` attribute type, the system will only consider it a match if the value of the `Email` field of Profile A matches the value of the `Email` field of Profile B.
        """
        return pulumi.get(self, "attribute_matching_model")

    @property
    @pulumi.getter(name="recordMatchingModels")
    def record_matching_models(self) -> Optional[Sequence['IdNamespaceRecordMatchingModel']]:
        """
        The type of matching record that is allowed to be used in an ID mapping workflow.

        If the value is set to `ONE_SOURCE_TO_ONE_TARGET` , only one record in the source is matched to one record in the target.

        If the value is set to `MANY_SOURCE_TO_ONE_TARGET` , all matching records in the source are matched to one record in the target.
        """
        return pulumi.get(self, "record_matching_models")

    @property
    @pulumi.getter(name="ruleDefinitionTypes")
    def rule_definition_types(self) -> Optional[Sequence['IdNamespaceRuleDefinitionType']]:
        """
        The sets of rules you can use in an ID mapping workflow. The limitations specified for the source and target must be compatible.
        """
        return pulumi.get(self, "rule_definition_types")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.IdNamespaceRule']]:
        """
        The rules for the ID namespace.
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class IdNamespaceRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchingKeys":
            suggest = "matching_keys"
        elif key == "ruleName":
            suggest = "rule_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdNamespaceRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdNamespaceRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdNamespaceRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 matching_keys: Sequence[str],
                 rule_name: str):
        """
        :param Sequence[str] matching_keys: A list of `MatchingKeys` . The `MatchingKeys` must have been defined in the `SchemaMapping` . Two records are considered to match according to this rule if all of the `MatchingKeys` match.
        :param str rule_name: A name for the matching rule.
        """
        pulumi.set(__self__, "matching_keys", matching_keys)
        pulumi.set(__self__, "rule_name", rule_name)

    @property
    @pulumi.getter(name="matchingKeys")
    def matching_keys(self) -> Sequence[str]:
        """
        A list of `MatchingKeys` . The `MatchingKeys` must have been defined in the `SchemaMapping` . Two records are considered to match according to this rule if all of the `MatchingKeys` match.
        """
        return pulumi.get(self, "matching_keys")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> str:
        """
        A name for the matching rule.
        """
        return pulumi.get(self, "rule_name")


@pulumi.output_type
class MatchingWorkflowIncrementalRunConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "incrementalRunType":
            suggest = "incremental_run_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MatchingWorkflowIncrementalRunConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MatchingWorkflowIncrementalRunConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MatchingWorkflowIncrementalRunConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 incremental_run_type: 'MatchingWorkflowIncrementalRunConfigIncrementalRunType'):
        """
        :param 'MatchingWorkflowIncrementalRunConfigIncrementalRunType' incremental_run_type: The type of incremental run. It takes only one value: `IMMEDIATE` .
        """
        pulumi.set(__self__, "incremental_run_type", incremental_run_type)

    @property
    @pulumi.getter(name="incrementalRunType")
    def incremental_run_type(self) -> 'MatchingWorkflowIncrementalRunConfigIncrementalRunType':
        """
        The type of incremental run. It takes only one value: `IMMEDIATE` .
        """
        return pulumi.get(self, "incremental_run_type")


@pulumi.output_type
class MatchingWorkflowInputSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputSourceArn":
            suggest = "input_source_arn"
        elif key == "schemaArn":
            suggest = "schema_arn"
        elif key == "applyNormalization":
            suggest = "apply_normalization"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MatchingWorkflowInputSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MatchingWorkflowInputSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MatchingWorkflowInputSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_source_arn: str,
                 schema_arn: str,
                 apply_normalization: Optional[bool] = None):
        """
        :param str input_source_arn: An Glue table ARN for the input source table
        :param str schema_arn: The name of the schema.
        :param bool apply_normalization: Normalizes the attributes defined in the schema in the input data. For example, if an attribute has an `AttributeType` of `PHONE_NUMBER` , and the data in the input table is in a format of 1234567890, AWS Entity Resolution will normalize this field in the output to (123)-456-7890.
        """
        pulumi.set(__self__, "input_source_arn", input_source_arn)
        pulumi.set(__self__, "schema_arn", schema_arn)
        if apply_normalization is not None:
            pulumi.set(__self__, "apply_normalization", apply_normalization)

    @property
    @pulumi.getter(name="inputSourceArn")
    def input_source_arn(self) -> str:
        """
        An Glue table ARN for the input source table
        """
        return pulumi.get(self, "input_source_arn")

    @property
    @pulumi.getter(name="schemaArn")
    def schema_arn(self) -> str:
        """
        The name of the schema.
        """
        return pulumi.get(self, "schema_arn")

    @property
    @pulumi.getter(name="applyNormalization")
    def apply_normalization(self) -> Optional[bool]:
        """
        Normalizes the attributes defined in the schema in the input data. For example, if an attribute has an `AttributeType` of `PHONE_NUMBER` , and the data in the input table is in a format of 1234567890, AWS Entity Resolution will normalize this field in the output to (123)-456-7890.
        """
        return pulumi.get(self, "apply_normalization")


@pulumi.output_type
class MatchingWorkflowIntermediateSourceConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intermediateS3Path":
            suggest = "intermediate_s3_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MatchingWorkflowIntermediateSourceConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MatchingWorkflowIntermediateSourceConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MatchingWorkflowIntermediateSourceConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 intermediate_s3_path: str):
        """
        :param str intermediate_s3_path: The s3 path that would be used to stage the intermediate data being generated during workflow execution.
        """
        pulumi.set(__self__, "intermediate_s3_path", intermediate_s3_path)

    @property
    @pulumi.getter(name="intermediateS3Path")
    def intermediate_s3_path(self) -> str:
        """
        The s3 path that would be used to stage the intermediate data being generated during workflow execution.
        """
        return pulumi.get(self, "intermediate_s3_path")


@pulumi.output_type
class MatchingWorkflowOutputAttribute(dict):
    def __init__(__self__, *,
                 name: str,
                 hashed: Optional[bool] = None):
        """
        :param str name: A name of a column to be written to the output. This must be an `InputField` name in the schema mapping.
        :param bool hashed: Enables the ability to hash the column values in the output.
        """
        pulumi.set(__self__, "name", name)
        if hashed is not None:
            pulumi.set(__self__, "hashed", hashed)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A name of a column to be written to the output. This must be an `InputField` name in the schema mapping.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def hashed(self) -> Optional[bool]:
        """
        Enables the ability to hash the column values in the output.
        """
        return pulumi.get(self, "hashed")


@pulumi.output_type
class MatchingWorkflowOutputSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputS3Path":
            suggest = "output_s3_path"
        elif key == "applyNormalization":
            suggest = "apply_normalization"
        elif key == "kmsArn":
            suggest = "kms_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MatchingWorkflowOutputSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MatchingWorkflowOutputSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MatchingWorkflowOutputSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 output: Sequence['outputs.MatchingWorkflowOutputAttribute'],
                 output_s3_path: str,
                 apply_normalization: Optional[bool] = None,
                 kms_arn: Optional[str] = None):
        """
        :param Sequence['MatchingWorkflowOutputAttribute'] output: A list of `OutputAttribute` objects, each of which have the fields `Name` and `Hashed` . Each of these objects selects a column to be included in the output table, and whether the values of the column should be hashed.
        :param str output_s3_path: The S3 path to which Entity Resolution will write the output table
        :param bool apply_normalization: Normalizes the attributes defined in the schema in the input data. For example, if an attribute has an `AttributeType` of `PHONE_NUMBER` , and the data in the input table is in a format of 1234567890, AWS Entity Resolution will normalize this field in the output to (123)-456-7890.
        :param str kms_arn: Customer KMS ARN for encryption at rest. If not provided, system will use an AWS Entity Resolution managed KMS key.
        """
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "output_s3_path", output_s3_path)
        if apply_normalization is not None:
            pulumi.set(__self__, "apply_normalization", apply_normalization)
        if kms_arn is not None:
            pulumi.set(__self__, "kms_arn", kms_arn)

    @property
    @pulumi.getter
    def output(self) -> Sequence['outputs.MatchingWorkflowOutputAttribute']:
        """
        A list of `OutputAttribute` objects, each of which have the fields `Name` and `Hashed` . Each of these objects selects a column to be included in the output table, and whether the values of the column should be hashed.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter(name="outputS3Path")
    def output_s3_path(self) -> str:
        """
        The S3 path to which Entity Resolution will write the output table
        """
        return pulumi.get(self, "output_s3_path")

    @property
    @pulumi.getter(name="applyNormalization")
    def apply_normalization(self) -> Optional[bool]:
        """
        Normalizes the attributes defined in the schema in the input data. For example, if an attribute has an `AttributeType` of `PHONE_NUMBER` , and the data in the input table is in a format of 1234567890, AWS Entity Resolution will normalize this field in the output to (123)-456-7890.
        """
        return pulumi.get(self, "apply_normalization")

    @property
    @pulumi.getter(name="kmsArn")
    def kms_arn(self) -> Optional[str]:
        """
        Customer KMS ARN for encryption at rest. If not provided, system will use an AWS Entity Resolution managed KMS key.
        """
        return pulumi.get(self, "kms_arn")


@pulumi.output_type
class MatchingWorkflowProviderProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "providerServiceArn":
            suggest = "provider_service_arn"
        elif key == "intermediateSourceConfiguration":
            suggest = "intermediate_source_configuration"
        elif key == "providerConfiguration":
            suggest = "provider_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MatchingWorkflowProviderProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MatchingWorkflowProviderProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MatchingWorkflowProviderProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provider_service_arn: str,
                 intermediate_source_configuration: Optional['outputs.MatchingWorkflowIntermediateSourceConfiguration'] = None,
                 provider_configuration: Optional[Mapping[str, str]] = None):
        """
        :param str provider_service_arn: Arn of the Provider service being used.
        :param 'MatchingWorkflowIntermediateSourceConfiguration' intermediate_source_configuration: The Amazon S3 location that temporarily stores your data while it processes. Your information won't be saved permanently.
        :param Mapping[str, str] provider_configuration: Additional Provider configuration that would be required for the provider service. The Configuration must be in JSON string format
        """
        pulumi.set(__self__, "provider_service_arn", provider_service_arn)
        if intermediate_source_configuration is not None:
            pulumi.set(__self__, "intermediate_source_configuration", intermediate_source_configuration)
        if provider_configuration is not None:
            pulumi.set(__self__, "provider_configuration", provider_configuration)

    @property
    @pulumi.getter(name="providerServiceArn")
    def provider_service_arn(self) -> str:
        """
        Arn of the Provider service being used.
        """
        return pulumi.get(self, "provider_service_arn")

    @property
    @pulumi.getter(name="intermediateSourceConfiguration")
    def intermediate_source_configuration(self) -> Optional['outputs.MatchingWorkflowIntermediateSourceConfiguration']:
        """
        The Amazon S3 location that temporarily stores your data while it processes. Your information won't be saved permanently.
        """
        return pulumi.get(self, "intermediate_source_configuration")

    @property
    @pulumi.getter(name="providerConfiguration")
    def provider_configuration(self) -> Optional[Mapping[str, str]]:
        """
        Additional Provider configuration that would be required for the provider service. The Configuration must be in JSON string format
        """
        return pulumi.get(self, "provider_configuration")


@pulumi.output_type
class MatchingWorkflowResolutionTechniques(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "providerProperties":
            suggest = "provider_properties"
        elif key == "resolutionType":
            suggest = "resolution_type"
        elif key == "ruleBasedProperties":
            suggest = "rule_based_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MatchingWorkflowResolutionTechniques. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MatchingWorkflowResolutionTechniques.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MatchingWorkflowResolutionTechniques.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 provider_properties: Optional['outputs.MatchingWorkflowProviderProperties'] = None,
                 resolution_type: Optional['MatchingWorkflowResolutionType'] = None,
                 rule_based_properties: Optional['outputs.MatchingWorkflowRuleBasedProperties'] = None):
        """
        :param 'MatchingWorkflowProviderProperties' provider_properties: The properties of the provider service.
        :param 'MatchingWorkflowResolutionType' resolution_type: The type of matching. There are three types of matching: `RULE_MATCHING` , `ML_MATCHING` , and `PROVIDER` .
        :param 'MatchingWorkflowRuleBasedProperties' rule_based_properties: An object which defines the list of matching rules to run and has a field `Rules` , which is a list of rule objects.
        """
        if provider_properties is not None:
            pulumi.set(__self__, "provider_properties", provider_properties)
        if resolution_type is not None:
            pulumi.set(__self__, "resolution_type", resolution_type)
        if rule_based_properties is not None:
            pulumi.set(__self__, "rule_based_properties", rule_based_properties)

    @property
    @pulumi.getter(name="providerProperties")
    def provider_properties(self) -> Optional['outputs.MatchingWorkflowProviderProperties']:
        """
        The properties of the provider service.
        """
        return pulumi.get(self, "provider_properties")

    @property
    @pulumi.getter(name="resolutionType")
    def resolution_type(self) -> Optional['MatchingWorkflowResolutionType']:
        """
        The type of matching. There are three types of matching: `RULE_MATCHING` , `ML_MATCHING` , and `PROVIDER` .
        """
        return pulumi.get(self, "resolution_type")

    @property
    @pulumi.getter(name="ruleBasedProperties")
    def rule_based_properties(self) -> Optional['outputs.MatchingWorkflowRuleBasedProperties']:
        """
        An object which defines the list of matching rules to run and has a field `Rules` , which is a list of rule objects.
        """
        return pulumi.get(self, "rule_based_properties")


@pulumi.output_type
class MatchingWorkflowRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchingKeys":
            suggest = "matching_keys"
        elif key == "ruleName":
            suggest = "rule_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MatchingWorkflowRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MatchingWorkflowRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MatchingWorkflowRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 matching_keys: Sequence[str],
                 rule_name: str):
        """
        :param Sequence[str] matching_keys: A list of `MatchingKeys` . The `MatchingKeys` must have been defined in the `SchemaMapping` . Two records are considered to match according to this rule if all of the `MatchingKeys` match.
        :param str rule_name: A name for the matching rule.
        """
        pulumi.set(__self__, "matching_keys", matching_keys)
        pulumi.set(__self__, "rule_name", rule_name)

    @property
    @pulumi.getter(name="matchingKeys")
    def matching_keys(self) -> Sequence[str]:
        """
        A list of `MatchingKeys` . The `MatchingKeys` must have been defined in the `SchemaMapping` . Two records are considered to match according to this rule if all of the `MatchingKeys` match.
        """
        return pulumi.get(self, "matching_keys")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> str:
        """
        A name for the matching rule.
        """
        return pulumi.get(self, "rule_name")


@pulumi.output_type
class MatchingWorkflowRuleBasedProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeMatchingModel":
            suggest = "attribute_matching_model"
        elif key == "matchPurpose":
            suggest = "match_purpose"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MatchingWorkflowRuleBasedProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MatchingWorkflowRuleBasedProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MatchingWorkflowRuleBasedProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute_matching_model: 'MatchingWorkflowRuleBasedPropertiesAttributeMatchingModel',
                 rules: Sequence['outputs.MatchingWorkflowRule'],
                 match_purpose: Optional['MatchingWorkflowRuleBasedPropertiesMatchPurpose'] = None):
        """
        :param 'MatchingWorkflowRuleBasedPropertiesAttributeMatchingModel' attribute_matching_model: The comparison type. You can either choose `ONE_TO_ONE` or `MANY_TO_MANY` as the `attributeMatchingModel` .
               
               If you choose `MANY_TO_MANY` , the system can match attributes across the sub-types of an attribute type. For example, if the value of the `Email` field of Profile A and the value of `BusinessEmail` field of Profile B matches, the two profiles are matched on the `Email` attribute type.
               
               If you choose `ONE_TO_ONE` , the system can only match attributes if the sub-types are an exact match. For example, for the `Email` attribute type, the system will only consider it a match if the value of the `Email` field of Profile A matches the value of the `Email` field of Profile B.
        :param Sequence['MatchingWorkflowRule'] rules: A list of `Rule` objects, each of which have fields `RuleName` and `MatchingKeys` .
        :param 'MatchingWorkflowRuleBasedPropertiesMatchPurpose' match_purpose: An indicator of whether to generate IDs and index the data or not.
               
               If you choose `IDENTIFIER_GENERATION` , the process generates IDs and indexes the data.
               
               If you choose `INDEXING` , the process indexes the data without generating IDs.
        """
        pulumi.set(__self__, "attribute_matching_model", attribute_matching_model)
        pulumi.set(__self__, "rules", rules)
        if match_purpose is not None:
            pulumi.set(__self__, "match_purpose", match_purpose)

    @property
    @pulumi.getter(name="attributeMatchingModel")
    def attribute_matching_model(self) -> 'MatchingWorkflowRuleBasedPropertiesAttributeMatchingModel':
        """
        The comparison type. You can either choose `ONE_TO_ONE` or `MANY_TO_MANY` as the `attributeMatchingModel` .

        If you choose `MANY_TO_MANY` , the system can match attributes across the sub-types of an attribute type. For example, if the value of the `Email` field of Profile A and the value of `BusinessEmail` field of Profile B matches, the two profiles are matched on the `Email` attribute type.

        If you choose `ONE_TO_ONE` , the system can only match attributes if the sub-types are an exact match. For example, for the `Email` attribute type, the system will only consider it a match if the value of the `Email` field of Profile A matches the value of the `Email` field of Profile B.
        """
        return pulumi.get(self, "attribute_matching_model")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.MatchingWorkflowRule']:
        """
        A list of `Rule` objects, each of which have fields `RuleName` and `MatchingKeys` .
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="matchPurpose")
    def match_purpose(self) -> Optional['MatchingWorkflowRuleBasedPropertiesMatchPurpose']:
        """
        An indicator of whether to generate IDs and index the data or not.

        If you choose `IDENTIFIER_GENERATION` , the process generates IDs and indexes the data.

        If you choose `INDEXING` , the process indexes the data without generating IDs.
        """
        return pulumi.get(self, "match_purpose")


@pulumi.output_type
class SchemaMappingSchemaInputAttribute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldName":
            suggest = "field_name"
        elif key == "groupName":
            suggest = "group_name"
        elif key == "matchKey":
            suggest = "match_key"
        elif key == "subType":
            suggest = "sub_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchemaMappingSchemaInputAttribute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchemaMappingSchemaInputAttribute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchemaMappingSchemaInputAttribute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_name: str,
                 type: 'SchemaMappingSchemaAttributeType',
                 group_name: Optional[str] = None,
                 hashed: Optional[bool] = None,
                 match_key: Optional[str] = None,
                 sub_type: Optional[str] = None):
        """
        :param str sub_type: The subtype of the Attribute. Would be required only when type is PROVIDER_ID
        """
        pulumi.set(__self__, "field_name", field_name)
        pulumi.set(__self__, "type", type)
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if hashed is not None:
            pulumi.set(__self__, "hashed", hashed)
        if match_key is not None:
            pulumi.set(__self__, "match_key", match_key)
        if sub_type is not None:
            pulumi.set(__self__, "sub_type", sub_type)

    @property
    @pulumi.getter(name="fieldName")
    def field_name(self) -> str:
        return pulumi.get(self, "field_name")

    @property
    @pulumi.getter
    def type(self) -> 'SchemaMappingSchemaAttributeType':
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[str]:
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter
    def hashed(self) -> Optional[bool]:
        return pulumi.get(self, "hashed")

    @property
    @pulumi.getter(name="matchKey")
    def match_key(self) -> Optional[str]:
        return pulumi.get(self, "match_key")

    @property
    @pulumi.getter(name="subType")
    def sub_type(self) -> Optional[str]:
        """
        The subtype of the Attribute. Would be required only when type is PROVIDER_ID
        """
        return pulumi.get(self, "sub_type")


