# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetApplicationResult',
    'AwaitableGetApplicationResult',
    'get_application',
    'get_application_output',
]

@pulumi.output_type
class GetApplicationResult:
    def __init__(__self__, application_id=None, architecture=None, arn=None, auto_start_configuration=None, auto_stop_configuration=None, image_configuration=None, initial_capacity=None, interactive_configuration=None, maximum_capacity=None, monitoring_configuration=None, network_configuration=None, release_label=None, runtime_configuration=None, tags=None, worker_type_specifications=None):
        if application_id and not isinstance(application_id, str):
            raise TypeError("Expected argument 'application_id' to be a str")
        pulumi.set(__self__, "application_id", application_id)
        if architecture and not isinstance(architecture, str):
            raise TypeError("Expected argument 'architecture' to be a str")
        pulumi.set(__self__, "architecture", architecture)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if auto_start_configuration and not isinstance(auto_start_configuration, dict):
            raise TypeError("Expected argument 'auto_start_configuration' to be a dict")
        pulumi.set(__self__, "auto_start_configuration", auto_start_configuration)
        if auto_stop_configuration and not isinstance(auto_stop_configuration, dict):
            raise TypeError("Expected argument 'auto_stop_configuration' to be a dict")
        pulumi.set(__self__, "auto_stop_configuration", auto_stop_configuration)
        if image_configuration and not isinstance(image_configuration, dict):
            raise TypeError("Expected argument 'image_configuration' to be a dict")
        pulumi.set(__self__, "image_configuration", image_configuration)
        if initial_capacity and not isinstance(initial_capacity, list):
            raise TypeError("Expected argument 'initial_capacity' to be a list")
        pulumi.set(__self__, "initial_capacity", initial_capacity)
        if interactive_configuration and not isinstance(interactive_configuration, dict):
            raise TypeError("Expected argument 'interactive_configuration' to be a dict")
        pulumi.set(__self__, "interactive_configuration", interactive_configuration)
        if maximum_capacity and not isinstance(maximum_capacity, dict):
            raise TypeError("Expected argument 'maximum_capacity' to be a dict")
        pulumi.set(__self__, "maximum_capacity", maximum_capacity)
        if monitoring_configuration and not isinstance(monitoring_configuration, dict):
            raise TypeError("Expected argument 'monitoring_configuration' to be a dict")
        pulumi.set(__self__, "monitoring_configuration", monitoring_configuration)
        if network_configuration and not isinstance(network_configuration, dict):
            raise TypeError("Expected argument 'network_configuration' to be a dict")
        pulumi.set(__self__, "network_configuration", network_configuration)
        if release_label and not isinstance(release_label, str):
            raise TypeError("Expected argument 'release_label' to be a str")
        pulumi.set(__self__, "release_label", release_label)
        if runtime_configuration and not isinstance(runtime_configuration, list):
            raise TypeError("Expected argument 'runtime_configuration' to be a list")
        pulumi.set(__self__, "runtime_configuration", runtime_configuration)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if worker_type_specifications and not isinstance(worker_type_specifications, dict):
            raise TypeError("Expected argument 'worker_type_specifications' to be a dict")
        pulumi.set(__self__, "worker_type_specifications", worker_type_specifications)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[str]:
        """
        The ID of the EMR Serverless Application.
        """
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter
    def architecture(self) -> Optional['ApplicationArchitecture']:
        """
        The CPU architecture of an application.
        """
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the EMR Serverless Application.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoStartConfiguration")
    def auto_start_configuration(self) -> Optional['outputs.ApplicationAutoStartConfiguration']:
        """
        Configuration for Auto Start of Application.
        """
        return pulumi.get(self, "auto_start_configuration")

    @property
    @pulumi.getter(name="autoStopConfiguration")
    def auto_stop_configuration(self) -> Optional['outputs.ApplicationAutoStopConfiguration']:
        """
        Configuration for Auto Stop of Application.
        """
        return pulumi.get(self, "auto_stop_configuration")

    @property
    @pulumi.getter(name="imageConfiguration")
    def image_configuration(self) -> Optional['outputs.ApplicationImageConfigurationInput']:
        """
        The image configuration applied to all worker types.
        """
        return pulumi.get(self, "image_configuration")

    @property
    @pulumi.getter(name="initialCapacity")
    def initial_capacity(self) -> Optional[Sequence['outputs.ApplicationInitialCapacityConfigKeyValuePair']]:
        """
        Initial capacity initialized when an Application is started.
        """
        return pulumi.get(self, "initial_capacity")

    @property
    @pulumi.getter(name="interactiveConfiguration")
    def interactive_configuration(self) -> Optional['outputs.ApplicationInteractiveConfiguration']:
        """
        The interactive configuration object that enables the interactive use cases for an application.
        """
        return pulumi.get(self, "interactive_configuration")

    @property
    @pulumi.getter(name="maximumCapacity")
    def maximum_capacity(self) -> Optional['outputs.ApplicationMaximumAllowedResources']:
        """
        Maximum allowed cumulative resources for an Application. No new resources will be created once the limit is hit.
        """
        return pulumi.get(self, "maximum_capacity")

    @property
    @pulumi.getter(name="monitoringConfiguration")
    def monitoring_configuration(self) -> Optional['outputs.ApplicationMonitoringConfiguration']:
        """
        A configuration specification to be used when provisioning an application. A configuration consists of a classification, properties, and optional nested configurations. A classification refers to an application-specific configuration file. Properties are the settings you want to change in that file.
        """
        return pulumi.get(self, "monitoring_configuration")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional['outputs.ApplicationNetworkConfiguration']:
        """
        Network Configuration for customer VPC connectivity.
        """
        return pulumi.get(self, "network_configuration")

    @property
    @pulumi.getter(name="releaseLabel")
    def release_label(self) -> Optional[str]:
        """
        EMR release label.
        """
        return pulumi.get(self, "release_label")

    @property
    @pulumi.getter(name="runtimeConfiguration")
    def runtime_configuration(self) -> Optional[Sequence['outputs.ApplicationConfigurationObject']]:
        """
        The [Configuration](https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_Configuration.html) specifications of an application. Each configuration consists of a classification and properties. You use this parameter when creating or updating an application. To see the runtimeConfiguration object of an application, run the [GetApplication](https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_GetApplication.html) API operation.
        """
        return pulumi.get(self, "runtime_configuration")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Tag map with key and value
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="workerTypeSpecifications")
    def worker_type_specifications(self) -> Optional[Mapping[str, 'outputs.ApplicationWorkerTypeSpecificationInput']]:
        """
        The key-value pairs that specify worker type to WorkerTypeSpecificationInput. This parameter must contain all valid worker types for a Spark or Hive application. Valid worker types include Driver and Executor for Spark applications and HiveDriver and TezTask for Hive applications. You can either set image details in this parameter for each worker type, or in imageConfiguration for all worker types.
        """
        return pulumi.get(self, "worker_type_specifications")


class AwaitableGetApplicationResult(GetApplicationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationResult(
            application_id=self.application_id,
            architecture=self.architecture,
            arn=self.arn,
            auto_start_configuration=self.auto_start_configuration,
            auto_stop_configuration=self.auto_stop_configuration,
            image_configuration=self.image_configuration,
            initial_capacity=self.initial_capacity,
            interactive_configuration=self.interactive_configuration,
            maximum_capacity=self.maximum_capacity,
            monitoring_configuration=self.monitoring_configuration,
            network_configuration=self.network_configuration,
            release_label=self.release_label,
            runtime_configuration=self.runtime_configuration,
            tags=self.tags,
            worker_type_specifications=self.worker_type_specifications)


def get_application(application_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationResult:
    """
    Resource schema for AWS::EMRServerless::Application Type


    :param str application_id: The ID of the EMR Serverless Application.
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:emrserverless:getApplication', __args__, opts=opts, typ=GetApplicationResult).value

    return AwaitableGetApplicationResult(
        application_id=pulumi.get(__ret__, 'application_id'),
        architecture=pulumi.get(__ret__, 'architecture'),
        arn=pulumi.get(__ret__, 'arn'),
        auto_start_configuration=pulumi.get(__ret__, 'auto_start_configuration'),
        auto_stop_configuration=pulumi.get(__ret__, 'auto_stop_configuration'),
        image_configuration=pulumi.get(__ret__, 'image_configuration'),
        initial_capacity=pulumi.get(__ret__, 'initial_capacity'),
        interactive_configuration=pulumi.get(__ret__, 'interactive_configuration'),
        maximum_capacity=pulumi.get(__ret__, 'maximum_capacity'),
        monitoring_configuration=pulumi.get(__ret__, 'monitoring_configuration'),
        network_configuration=pulumi.get(__ret__, 'network_configuration'),
        release_label=pulumi.get(__ret__, 'release_label'),
        runtime_configuration=pulumi.get(__ret__, 'runtime_configuration'),
        tags=pulumi.get(__ret__, 'tags'),
        worker_type_specifications=pulumi.get(__ret__, 'worker_type_specifications'))
def get_application_output(application_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetApplicationResult]:
    """
    Resource schema for AWS::EMRServerless::Application Type


    :param str application_id: The ID of the EMR Serverless Application.
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:emrserverless:getApplication', __args__, opts=opts, typ=GetApplicationResult)
    return __ret__.apply(lambda __response__: GetApplicationResult(
        application_id=pulumi.get(__response__, 'application_id'),
        architecture=pulumi.get(__response__, 'architecture'),
        arn=pulumi.get(__response__, 'arn'),
        auto_start_configuration=pulumi.get(__response__, 'auto_start_configuration'),
        auto_stop_configuration=pulumi.get(__response__, 'auto_stop_configuration'),
        image_configuration=pulumi.get(__response__, 'image_configuration'),
        initial_capacity=pulumi.get(__response__, 'initial_capacity'),
        interactive_configuration=pulumi.get(__response__, 'interactive_configuration'),
        maximum_capacity=pulumi.get(__response__, 'maximum_capacity'),
        monitoring_configuration=pulumi.get(__response__, 'monitoring_configuration'),
        network_configuration=pulumi.get(__response__, 'network_configuration'),
        release_label=pulumi.get(__response__, 'release_label'),
        runtime_configuration=pulumi.get(__response__, 'runtime_configuration'),
        tags=pulumi.get(__response__, 'tags'),
        worker_type_specifications=pulumi.get(__response__, 'worker_type_specifications')))
