# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetTrustStoreResult',
    'AwaitableGetTrustStoreResult',
    'get_trust_store',
    'get_trust_store_output',
]

@pulumi.output_type
class GetTrustStoreResult:
    def __init__(__self__, number_of_ca_certificates=None, status=None, tags=None, trust_store_arn=None):
        if number_of_ca_certificates and not isinstance(number_of_ca_certificates, int):
            raise TypeError("Expected argument 'number_of_ca_certificates' to be a int")
        pulumi.set(__self__, "number_of_ca_certificates", number_of_ca_certificates)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if trust_store_arn and not isinstance(trust_store_arn, str):
            raise TypeError("Expected argument 'trust_store_arn' to be a str")
        pulumi.set(__self__, "trust_store_arn", trust_store_arn)

    @property
    @pulumi.getter(name="numberOfCaCertificates")
    def number_of_ca_certificates(self) -> Optional[int]:
        """
        The number of certificates associated with the trust store.
        """
        return pulumi.get(self, "number_of_ca_certificates")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the trust store, could be either of ACTIVE or CREATING.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags to assign to the trust store.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="trustStoreArn")
    def trust_store_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the trust store.
        """
        return pulumi.get(self, "trust_store_arn")


class AwaitableGetTrustStoreResult(GetTrustStoreResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTrustStoreResult(
            number_of_ca_certificates=self.number_of_ca_certificates,
            status=self.status,
            tags=self.tags,
            trust_store_arn=self.trust_store_arn)


def get_trust_store(trust_store_arn: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTrustStoreResult:
    """
    Resource Type definition for AWS::ElasticLoadBalancingV2::TrustStore


    :param str trust_store_arn: The Amazon Resource Name (ARN) of the trust store.
    """
    __args__ = dict()
    __args__['trustStoreArn'] = trust_store_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:elasticloadbalancingv2:getTrustStore', __args__, opts=opts, typ=GetTrustStoreResult).value

    return AwaitableGetTrustStoreResult(
        number_of_ca_certificates=pulumi.get(__ret__, 'number_of_ca_certificates'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        trust_store_arn=pulumi.get(__ret__, 'trust_store_arn'))
def get_trust_store_output(trust_store_arn: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTrustStoreResult]:
    """
    Resource Type definition for AWS::ElasticLoadBalancingV2::TrustStore


    :param str trust_store_arn: The Amazon Resource Name (ARN) of the trust store.
    """
    __args__ = dict()
    __args__['trustStoreArn'] = trust_store_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:elasticloadbalancingv2:getTrustStore', __args__, opts=opts, typ=GetTrustStoreResult)
    return __ret__.apply(lambda __response__: GetTrustStoreResult(
        number_of_ca_certificates=pulumi.get(__response__, 'number_of_ca_certificates'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        trust_store_arn=pulumi.get(__response__, 'trust_store_arn')))
