# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetLoadBalancerResult',
    'AwaitableGetLoadBalancerResult',
    'get_load_balancer',
    'get_load_balancer_output',
]

@pulumi.output_type
class GetLoadBalancerResult:
    def __init__(__self__, canonical_hosted_zone_id=None, dns_name=None, enforce_security_group_inbound_rules_on_private_link_traffic=None, ip_address_type=None, load_balancer_arn=None, load_balancer_attributes=None, load_balancer_full_name=None, load_balancer_name=None, security_groups=None, subnet_mappings=None, subnets=None, tags=None):
        if canonical_hosted_zone_id and not isinstance(canonical_hosted_zone_id, str):
            raise TypeError("Expected argument 'canonical_hosted_zone_id' to be a str")
        pulumi.set(__self__, "canonical_hosted_zone_id", canonical_hosted_zone_id)
        if dns_name and not isinstance(dns_name, str):
            raise TypeError("Expected argument 'dns_name' to be a str")
        pulumi.set(__self__, "dns_name", dns_name)
        if enforce_security_group_inbound_rules_on_private_link_traffic and not isinstance(enforce_security_group_inbound_rules_on_private_link_traffic, str):
            raise TypeError("Expected argument 'enforce_security_group_inbound_rules_on_private_link_traffic' to be a str")
        pulumi.set(__self__, "enforce_security_group_inbound_rules_on_private_link_traffic", enforce_security_group_inbound_rules_on_private_link_traffic)
        if ip_address_type and not isinstance(ip_address_type, str):
            raise TypeError("Expected argument 'ip_address_type' to be a str")
        pulumi.set(__self__, "ip_address_type", ip_address_type)
        if load_balancer_arn and not isinstance(load_balancer_arn, str):
            raise TypeError("Expected argument 'load_balancer_arn' to be a str")
        pulumi.set(__self__, "load_balancer_arn", load_balancer_arn)
        if load_balancer_attributes and not isinstance(load_balancer_attributes, list):
            raise TypeError("Expected argument 'load_balancer_attributes' to be a list")
        pulumi.set(__self__, "load_balancer_attributes", load_balancer_attributes)
        if load_balancer_full_name and not isinstance(load_balancer_full_name, str):
            raise TypeError("Expected argument 'load_balancer_full_name' to be a str")
        pulumi.set(__self__, "load_balancer_full_name", load_balancer_full_name)
        if load_balancer_name and not isinstance(load_balancer_name, str):
            raise TypeError("Expected argument 'load_balancer_name' to be a str")
        pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if security_groups and not isinstance(security_groups, list):
            raise TypeError("Expected argument 'security_groups' to be a list")
        pulumi.set(__self__, "security_groups", security_groups)
        if subnet_mappings and not isinstance(subnet_mappings, list):
            raise TypeError("Expected argument 'subnet_mappings' to be a list")
        pulumi.set(__self__, "subnet_mappings", subnet_mappings)
        if subnets and not isinstance(subnets, list):
            raise TypeError("Expected argument 'subnets' to be a list")
        pulumi.set(__self__, "subnets", subnets)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="canonicalHostedZoneId")
    def canonical_hosted_zone_id(self) -> Optional[str]:
        """
        The ID of the Amazon Route 53 hosted zone associated with the load balancer. For example, `Z2P70J7EXAMPLE` .
        """
        return pulumi.get(self, "canonical_hosted_zone_id")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[str]:
        """
        The DNS name for the load balancer. For example, `my-load-balancer-424835706.us-west-2.elb.amazonaws.com` .
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="enforceSecurityGroupInboundRulesOnPrivateLinkTraffic")
    def enforce_security_group_inbound_rules_on_private_link_traffic(self) -> Optional[str]:
        """
        Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer through privatelink.
        """
        return pulumi.get(self, "enforce_security_group_inbound_rules_on_private_link_traffic")

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[str]:
        """
        Note: Internal load balancers must use the ``ipv4`` IP address type.
         [Application Load Balancers] The IP address type. The possible values are ``ipv4`` (for only IPv4 addresses), ``dualstack`` (for IPv4 and IPv6 addresses), and ``dualstack-without-public-ipv4`` (for IPv6 only public addresses, with private IPv4 and IPv6 addresses).
         Note: Application Load Balancer authentication only supports IPv4 addresses when connecting to an Identity Provider (IdP) or Amazon Cognito endpoint. Without a public IPv4 address the load balancer cannot complete the authentication process, resulting in HTTP 500 errors.
         [Network Load Balancers] The IP address type. The possible values are ``ipv4`` (for only IPv4 addresses) and ``dualstack`` (for IPv4 and IPv6 addresses). You can’t specify ``dualstack`` for a load balancer with a UDP or TCP_UDP listener.
         [Gateway Load Balancers] The IP address type. The possible values are ``ipv4`` (for only IPv4 addresses) and ``dualstack`` (for IPv4 and IPv6 addresses).
        """
        return pulumi.get(self, "ip_address_type")

    @property
    @pulumi.getter(name="loadBalancerArn")
    def load_balancer_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the load balancer.
        """
        return pulumi.get(self, "load_balancer_arn")

    @property
    @pulumi.getter(name="loadBalancerAttributes")
    def load_balancer_attributes(self) -> Optional[Sequence['outputs.LoadBalancerAttribute']]:
        """
        The load balancer attributes.
        """
        return pulumi.get(self, "load_balancer_attributes")

    @property
    @pulumi.getter(name="loadBalancerFullName")
    def load_balancer_full_name(self) -> Optional[str]:
        """
        The full name of the load balancer. For example, `app/my-load-balancer/50dc6c495c0c9188` .
        """
        return pulumi.get(self, "load_balancer_full_name")

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[str]:
        """
        The name of the load balancer. For example, `my-load-balancer` .
        """
        return pulumi.get(self, "load_balancer_name")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[Sequence[str]]:
        """
        [Application Load Balancers and Network Load Balancers] The IDs of the security groups for the load balancer.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="subnetMappings")
    def subnet_mappings(self) -> Optional[Sequence['outputs.LoadBalancerSubnetMapping']]:
        """
        The IDs of the subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings, but not both.
         [Application Load Balancers] You must specify subnets from at least two Availability Zones. You cannot specify Elastic IP addresses for your subnets.
         [Application Load Balancers on Outposts] You must specify one Outpost subnet.
         [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
         [Network Load Balancers] You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.
         [Gateway Load Balancers] You can specify subnets from one or more Availability Zones. You cannot specify Elastic IP addresses for your subnets.
        """
        return pulumi.get(self, "subnet_mappings")

    @property
    @pulumi.getter
    def subnets(self) -> Optional[Sequence[str]]:
        """
        The IDs of the subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings, but not both. To specify an Elastic IP address, specify subnet mappings instead of subnets.
         [Application Load Balancers] You must specify subnets from at least two Availability Zones.
         [Application Load Balancers on Outposts] You must specify one Outpost subnet.
         [Application Load Balancers on Local Zones] You can specify subnets from one or more Local Zones.
         [Network Load Balancers] You can specify subnets from one or more Availability Zones.
         [Gateway Load Balancers] You can specify subnets from one or more Availability Zones.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags to assign to the load balancer.
        """
        return pulumi.get(self, "tags")


class AwaitableGetLoadBalancerResult(GetLoadBalancerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLoadBalancerResult(
            canonical_hosted_zone_id=self.canonical_hosted_zone_id,
            dns_name=self.dns_name,
            enforce_security_group_inbound_rules_on_private_link_traffic=self.enforce_security_group_inbound_rules_on_private_link_traffic,
            ip_address_type=self.ip_address_type,
            load_balancer_arn=self.load_balancer_arn,
            load_balancer_attributes=self.load_balancer_attributes,
            load_balancer_full_name=self.load_balancer_full_name,
            load_balancer_name=self.load_balancer_name,
            security_groups=self.security_groups,
            subnet_mappings=self.subnet_mappings,
            subnets=self.subnets,
            tags=self.tags)


def get_load_balancer(load_balancer_arn: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLoadBalancerResult:
    """
    Specifies an Application Load Balancer, a Network Load Balancer, or a Gateway Load Balancer.


    :param str load_balancer_arn: The Amazon Resource Name (ARN) of the load balancer.
    """
    __args__ = dict()
    __args__['loadBalancerArn'] = load_balancer_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:elasticloadbalancingv2:getLoadBalancer', __args__, opts=opts, typ=GetLoadBalancerResult).value

    return AwaitableGetLoadBalancerResult(
        canonical_hosted_zone_id=pulumi.get(__ret__, 'canonical_hosted_zone_id'),
        dns_name=pulumi.get(__ret__, 'dns_name'),
        enforce_security_group_inbound_rules_on_private_link_traffic=pulumi.get(__ret__, 'enforce_security_group_inbound_rules_on_private_link_traffic'),
        ip_address_type=pulumi.get(__ret__, 'ip_address_type'),
        load_balancer_arn=pulumi.get(__ret__, 'load_balancer_arn'),
        load_balancer_attributes=pulumi.get(__ret__, 'load_balancer_attributes'),
        load_balancer_full_name=pulumi.get(__ret__, 'load_balancer_full_name'),
        load_balancer_name=pulumi.get(__ret__, 'load_balancer_name'),
        security_groups=pulumi.get(__ret__, 'security_groups'),
        subnet_mappings=pulumi.get(__ret__, 'subnet_mappings'),
        subnets=pulumi.get(__ret__, 'subnets'),
        tags=pulumi.get(__ret__, 'tags'))
def get_load_balancer_output(load_balancer_arn: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLoadBalancerResult]:
    """
    Specifies an Application Load Balancer, a Network Load Balancer, or a Gateway Load Balancer.


    :param str load_balancer_arn: The Amazon Resource Name (ARN) of the load balancer.
    """
    __args__ = dict()
    __args__['loadBalancerArn'] = load_balancer_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:elasticloadbalancingv2:getLoadBalancer', __args__, opts=opts, typ=GetLoadBalancerResult)
    return __ret__.apply(lambda __response__: GetLoadBalancerResult(
        canonical_hosted_zone_id=pulumi.get(__response__, 'canonical_hosted_zone_id'),
        dns_name=pulumi.get(__response__, 'dns_name'),
        enforce_security_group_inbound_rules_on_private_link_traffic=pulumi.get(__response__, 'enforce_security_group_inbound_rules_on_private_link_traffic'),
        ip_address_type=pulumi.get(__response__, 'ip_address_type'),
        load_balancer_arn=pulumi.get(__response__, 'load_balancer_arn'),
        load_balancer_attributes=pulumi.get(__response__, 'load_balancer_attributes'),
        load_balancer_full_name=pulumi.get(__response__, 'load_balancer_full_name'),
        load_balancer_name=pulumi.get(__response__, 'load_balancer_name'),
        security_groups=pulumi.get(__response__, 'security_groups'),
        subnet_mappings=pulumi.get(__response__, 'subnet_mappings'),
        subnets=pulumi.get(__response__, 'subnets'),
        tags=pulumi.get(__response__, 'tags')))
