# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AuthenticationModeProperties',
    'GlobalReplicationGroupMember',
    'GlobalReplicationGroupRegionalConfiguration',
    'GlobalReplicationGroupReshardingConfiguration',
    'ServerlessCacheCacheUsageLimits',
    'ServerlessCacheDataStorage',
    'ServerlessCacheEcpuPerSecond',
    'ServerlessCacheEndpoint',
]

@pulumi.output_type
class AuthenticationModeProperties(dict):
    """
    Specifies the authentication mode to use. Below is an example of the possible JSON values:

    ```
    { Passwords: ["*****", "******"] // If Type is password.
    }
    ```
    """
    def __init__(__self__, *,
                 type: 'UserAuthenticationModePropertiesType',
                 passwords: Optional[Sequence[str]] = None):
        """
        Specifies the authentication mode to use. Below is an example of the possible JSON values:

        ```
        { Passwords: ["*****", "******"] // If Type is password.
        }
        ```
        :param 'UserAuthenticationModePropertiesType' type: Authentication Type
        :param Sequence[str] passwords: Passwords used for this user account. You can create up to two passwords for each user.
        """
        pulumi.set(__self__, "type", type)
        if passwords is not None:
            pulumi.set(__self__, "passwords", passwords)

    @property
    @pulumi.getter
    def type(self) -> 'UserAuthenticationModePropertiesType':
        """
        Authentication Type
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def passwords(self) -> Optional[Sequence[str]]:
        """
        Passwords used for this user account. You can create up to two passwords for each user.
        """
        return pulumi.get(self, "passwords")


@pulumi.output_type
class GlobalReplicationGroupMember(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicationGroupId":
            suggest = "replication_group_id"
        elif key == "replicationGroupRegion":
            suggest = "replication_group_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalReplicationGroupMember. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalReplicationGroupMember.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalReplicationGroupMember.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replication_group_id: Optional[str] = None,
                 replication_group_region: Optional[str] = None,
                 role: Optional['GlobalReplicationGroupMemberRole'] = None):
        """
        :param str replication_group_id: Regionally unique identifier for the member i.e. ReplicationGroupId.
        :param str replication_group_region: The AWS region of the Global Datastore member.
        :param 'GlobalReplicationGroupMemberRole' role: Indicates the role of the member, primary or secondary.
        """
        if replication_group_id is not None:
            pulumi.set(__self__, "replication_group_id", replication_group_id)
        if replication_group_region is not None:
            pulumi.set(__self__, "replication_group_region", replication_group_region)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="replicationGroupId")
    def replication_group_id(self) -> Optional[str]:
        """
        Regionally unique identifier for the member i.e. ReplicationGroupId.
        """
        return pulumi.get(self, "replication_group_id")

    @property
    @pulumi.getter(name="replicationGroupRegion")
    def replication_group_region(self) -> Optional[str]:
        """
        The AWS region of the Global Datastore member.
        """
        return pulumi.get(self, "replication_group_region")

    @property
    @pulumi.getter
    def role(self) -> Optional['GlobalReplicationGroupMemberRole']:
        """
        Indicates the role of the member, primary or secondary.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class GlobalReplicationGroupRegionalConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "replicationGroupId":
            suggest = "replication_group_id"
        elif key == "replicationGroupRegion":
            suggest = "replication_group_region"
        elif key == "reshardingConfigurations":
            suggest = "resharding_configurations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalReplicationGroupRegionalConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalReplicationGroupRegionalConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalReplicationGroupRegionalConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 replication_group_id: Optional[str] = None,
                 replication_group_region: Optional[str] = None,
                 resharding_configurations: Optional[Sequence['outputs.GlobalReplicationGroupReshardingConfiguration']] = None):
        """
        :param str replication_group_id: The replication group id of the Global Datastore member.
        :param str replication_group_region: The AWS region of the Global Datastore member.
        :param Sequence['GlobalReplicationGroupReshardingConfiguration'] resharding_configurations: A list of PreferredAvailabilityZones objects that specifies the configuration of a node group in the resharded cluster. 
        """
        if replication_group_id is not None:
            pulumi.set(__self__, "replication_group_id", replication_group_id)
        if replication_group_region is not None:
            pulumi.set(__self__, "replication_group_region", replication_group_region)
        if resharding_configurations is not None:
            pulumi.set(__self__, "resharding_configurations", resharding_configurations)

    @property
    @pulumi.getter(name="replicationGroupId")
    def replication_group_id(self) -> Optional[str]:
        """
        The replication group id of the Global Datastore member.
        """
        return pulumi.get(self, "replication_group_id")

    @property
    @pulumi.getter(name="replicationGroupRegion")
    def replication_group_region(self) -> Optional[str]:
        """
        The AWS region of the Global Datastore member.
        """
        return pulumi.get(self, "replication_group_region")

    @property
    @pulumi.getter(name="reshardingConfigurations")
    def resharding_configurations(self) -> Optional[Sequence['outputs.GlobalReplicationGroupReshardingConfiguration']]:
        """
        A list of PreferredAvailabilityZones objects that specifies the configuration of a node group in the resharded cluster. 
        """
        return pulumi.get(self, "resharding_configurations")


@pulumi.output_type
class GlobalReplicationGroupReshardingConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeGroupId":
            suggest = "node_group_id"
        elif key == "preferredAvailabilityZones":
            suggest = "preferred_availability_zones"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalReplicationGroupReshardingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalReplicationGroupReshardingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalReplicationGroupReshardingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_group_id: Optional[str] = None,
                 preferred_availability_zones: Optional[Sequence[str]] = None):
        """
        :param str node_group_id: Unique identifier for the Node Group. This is either auto-generated by ElastiCache (4-digit id) or a user supplied id.
        :param Sequence[str] preferred_availability_zones: A list of preferred availability zones for the nodes of new node groups.
        """
        if node_group_id is not None:
            pulumi.set(__self__, "node_group_id", node_group_id)
        if preferred_availability_zones is not None:
            pulumi.set(__self__, "preferred_availability_zones", preferred_availability_zones)

    @property
    @pulumi.getter(name="nodeGroupId")
    def node_group_id(self) -> Optional[str]:
        """
        Unique identifier for the Node Group. This is either auto-generated by ElastiCache (4-digit id) or a user supplied id.
        """
        return pulumi.get(self, "node_group_id")

    @property
    @pulumi.getter(name="preferredAvailabilityZones")
    def preferred_availability_zones(self) -> Optional[Sequence[str]]:
        """
        A list of preferred availability zones for the nodes of new node groups.
        """
        return pulumi.get(self, "preferred_availability_zones")


@pulumi.output_type
class ServerlessCacheCacheUsageLimits(dict):
    """
    The cache capacity limit of the Serverless Cache.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataStorage":
            suggest = "data_storage"
        elif key == "ecpuPerSecond":
            suggest = "ecpu_per_second"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerlessCacheCacheUsageLimits. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerlessCacheCacheUsageLimits.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerlessCacheCacheUsageLimits.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_storage: Optional['outputs.ServerlessCacheDataStorage'] = None,
                 ecpu_per_second: Optional['outputs.ServerlessCacheEcpuPerSecond'] = None):
        """
        The cache capacity limit of the Serverless Cache.
        :param 'ServerlessCacheDataStorage' data_storage: The maximum data storage limit in the cache, expressed in Gigabytes.
        :param 'ServerlessCacheEcpuPerSecond' ecpu_per_second: The number of ElastiCache Processing Units (ECPU) the cache can consume per second.
        """
        if data_storage is not None:
            pulumi.set(__self__, "data_storage", data_storage)
        if ecpu_per_second is not None:
            pulumi.set(__self__, "ecpu_per_second", ecpu_per_second)

    @property
    @pulumi.getter(name="dataStorage")
    def data_storage(self) -> Optional['outputs.ServerlessCacheDataStorage']:
        """
        The maximum data storage limit in the cache, expressed in Gigabytes.
        """
        return pulumi.get(self, "data_storage")

    @property
    @pulumi.getter(name="ecpuPerSecond")
    def ecpu_per_second(self) -> Optional['outputs.ServerlessCacheEcpuPerSecond']:
        """
        The number of ElastiCache Processing Units (ECPU) the cache can consume per second.
        """
        return pulumi.get(self, "ecpu_per_second")


@pulumi.output_type
class ServerlessCacheDataStorage(dict):
    """
    The cached data capacity of the Serverless Cache.
    """
    def __init__(__self__, *,
                 unit: 'ServerlessCacheDataStorageUnit',
                 maximum: Optional[int] = None,
                 minimum: Optional[int] = None):
        """
        The cached data capacity of the Serverless Cache.
        :param 'ServerlessCacheDataStorageUnit' unit: The unit of cached data capacity of the Serverless Cache.
        :param int maximum: The maximum cached data capacity of the Serverless Cache.
        :param int minimum: The minimum cached data capacity of the Serverless Cache.
        """
        pulumi.set(__self__, "unit", unit)
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)

    @property
    @pulumi.getter
    def unit(self) -> 'ServerlessCacheDataStorageUnit':
        """
        The unit of cached data capacity of the Serverless Cache.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def maximum(self) -> Optional[int]:
        """
        The maximum cached data capacity of the Serverless Cache.
        """
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter
    def minimum(self) -> Optional[int]:
        """
        The minimum cached data capacity of the Serverless Cache.
        """
        return pulumi.get(self, "minimum")


@pulumi.output_type
class ServerlessCacheEcpuPerSecond(dict):
    """
    The ECPU per second of the Serverless Cache.
    """
    def __init__(__self__, *,
                 maximum: Optional[int] = None,
                 minimum: Optional[int] = None):
        """
        The ECPU per second of the Serverless Cache.
        :param int maximum: The maximum ECPU per second of the Serverless Cache.
        :param int minimum: The minimum ECPU per second of the Serverless Cache.
        """
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)

    @property
    @pulumi.getter
    def maximum(self) -> Optional[int]:
        """
        The maximum ECPU per second of the Serverless Cache.
        """
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter
    def minimum(self) -> Optional[int]:
        """
        The minimum ECPU per second of the Serverless Cache.
        """
        return pulumi.get(self, "minimum")


@pulumi.output_type
class ServerlessCacheEndpoint(dict):
    """
    The address and the port.
    """
    def __init__(__self__, *,
                 address: Optional[str] = None,
                 port: Optional[str] = None):
        """
        The address and the port.
        :param str address: Endpoint address.
        :param str port: Endpoint port.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> Optional[str]:
        """
        Endpoint address.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        Endpoint port.
        """
        return pulumi.get(self, "port")


