# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetPodIdentityAssociationResult',
    'AwaitableGetPodIdentityAssociationResult',
    'get_pod_identity_association',
    'get_pod_identity_association_output',
]

@pulumi.output_type
class GetPodIdentityAssociationResult:
    def __init__(__self__, association_arn=None, association_id=None, role_arn=None, tags=None):
        if association_arn and not isinstance(association_arn, str):
            raise TypeError("Expected argument 'association_arn' to be a str")
        pulumi.set(__self__, "association_arn", association_arn)
        if association_id and not isinstance(association_id, str):
            raise TypeError("Expected argument 'association_id' to be a str")
        pulumi.set(__self__, "association_id", association_id)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="associationArn")
    def association_arn(self) -> Optional[str]:
        """
        The ARN of the pod identity association.
        """
        return pulumi.get(self, "association_arn")

    @property
    @pulumi.getter(name="associationId")
    def association_id(self) -> Optional[str]:
        """
        The ID of the pod identity association.
        """
        return pulumi.get(self, "association_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[str]:
        """
        The IAM role ARN that the pod identity association is created for.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetPodIdentityAssociationResult(GetPodIdentityAssociationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPodIdentityAssociationResult(
            association_arn=self.association_arn,
            association_id=self.association_id,
            role_arn=self.role_arn,
            tags=self.tags)


def get_pod_identity_association(association_arn: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPodIdentityAssociationResult:
    """
    An object representing an Amazon EKS PodIdentityAssociation.


    :param str association_arn: The ARN of the pod identity association.
    """
    __args__ = dict()
    __args__['associationArn'] = association_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:eks:getPodIdentityAssociation', __args__, opts=opts, typ=GetPodIdentityAssociationResult).value

    return AwaitableGetPodIdentityAssociationResult(
        association_arn=pulumi.get(__ret__, 'association_arn'),
        association_id=pulumi.get(__ret__, 'association_id'),
        role_arn=pulumi.get(__ret__, 'role_arn'),
        tags=pulumi.get(__ret__, 'tags'))
def get_pod_identity_association_output(association_arn: Optional[pulumi.Input[str]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPodIdentityAssociationResult]:
    """
    An object representing an Amazon EKS PodIdentityAssociation.


    :param str association_arn: The ARN of the pod identity association.
    """
    __args__ = dict()
    __args__['associationArn'] = association_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:eks:getPodIdentityAssociation', __args__, opts=opts, typ=GetPodIdentityAssociationResult)
    return __ret__.apply(lambda __response__: GetPodIdentityAssociationResult(
        association_arn=pulumi.get(__response__, 'association_arn'),
        association_id=pulumi.get(__response__, 'association_id'),
        role_arn=pulumi.get(__response__, 'role_arn'),
        tags=pulumi.get(__response__, 'tags')))
