# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'AccessEntryAccessPolicyArgs',
    'AccessEntryAccessPolicyArgsDict',
    'AccessEntryAccessScopeArgs',
    'AccessEntryAccessScopeArgsDict',
    'AddonPodIdentityAssociationArgs',
    'AddonPodIdentityAssociationArgsDict',
    'ClusterAccessConfigArgs',
    'ClusterAccessConfigArgsDict',
    'ClusterControlPlanePlacementArgs',
    'ClusterControlPlanePlacementArgsDict',
    'ClusterEncryptionConfigArgs',
    'ClusterEncryptionConfigArgsDict',
    'ClusterKubernetesNetworkConfigArgs',
    'ClusterKubernetesNetworkConfigArgsDict',
    'ClusterLoggingEnabledTypesArgs',
    'ClusterLoggingEnabledTypesArgsDict',
    'ClusterLoggingTypeConfigArgs',
    'ClusterLoggingTypeConfigArgsDict',
    'ClusterOutpostConfigArgs',
    'ClusterOutpostConfigArgsDict',
    'ClusterProviderArgs',
    'ClusterProviderArgsDict',
    'ClusterResourcesVpcConfigArgs',
    'ClusterResourcesVpcConfigArgsDict',
    'ClusterUpgradePolicyArgs',
    'ClusterUpgradePolicyArgsDict',
    'ClusterZonalShiftConfigArgs',
    'ClusterZonalShiftConfigArgsDict',
    'FargateProfileLabelArgs',
    'FargateProfileLabelArgsDict',
    'FargateProfileSelectorArgs',
    'FargateProfileSelectorArgsDict',
    'IdentityProviderConfigOidcIdentityProviderConfigArgs',
    'IdentityProviderConfigOidcIdentityProviderConfigArgsDict',
    'IdentityProviderConfigRequiredClaimArgs',
    'IdentityProviderConfigRequiredClaimArgsDict',
    'LoggingArgs',
    'LoggingArgsDict',
    'NodegroupLaunchTemplateSpecificationArgs',
    'NodegroupLaunchTemplateSpecificationArgsDict',
    'NodegroupRemoteAccessArgs',
    'NodegroupRemoteAccessArgsDict',
    'NodegroupScalingConfigArgs',
    'NodegroupScalingConfigArgsDict',
    'NodegroupTaintArgs',
    'NodegroupTaintArgsDict',
    'NodegroupUpdateConfigArgs',
    'NodegroupUpdateConfigArgsDict',
]

MYPY = False

if not MYPY:
    class AccessEntryAccessPolicyArgsDict(TypedDict):
        """
        An access policy to associate with the current access entry.
        """
        access_scope: pulumi.Input['AccessEntryAccessScopeArgsDict']
        """
        The scope of an `AccessPolicy` that's associated to an `AccessEntry` .
        """
        policy_arn: pulumi.Input[str]
        """
        The ARN of the access policy to add to the access entry.
        """
elif False:
    AccessEntryAccessPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccessEntryAccessPolicyArgs:
    def __init__(__self__, *,
                 access_scope: pulumi.Input['AccessEntryAccessScopeArgs'],
                 policy_arn: pulumi.Input[str]):
        """
        An access policy to associate with the current access entry.
        :param pulumi.Input['AccessEntryAccessScopeArgs'] access_scope: The scope of an `AccessPolicy` that's associated to an `AccessEntry` .
        :param pulumi.Input[str] policy_arn: The ARN of the access policy to add to the access entry.
        """
        pulumi.set(__self__, "access_scope", access_scope)
        pulumi.set(__self__, "policy_arn", policy_arn)

    @property
    @pulumi.getter(name="accessScope")
    def access_scope(self) -> pulumi.Input['AccessEntryAccessScopeArgs']:
        """
        The scope of an `AccessPolicy` that's associated to an `AccessEntry` .
        """
        return pulumi.get(self, "access_scope")

    @access_scope.setter
    def access_scope(self, value: pulumi.Input['AccessEntryAccessScopeArgs']):
        pulumi.set(self, "access_scope", value)

    @property
    @pulumi.getter(name="policyArn")
    def policy_arn(self) -> pulumi.Input[str]:
        """
        The ARN of the access policy to add to the access entry.
        """
        return pulumi.get(self, "policy_arn")

    @policy_arn.setter
    def policy_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_arn", value)


if not MYPY:
    class AccessEntryAccessScopeArgsDict(TypedDict):
        """
        The access scope of the access policy.
        """
        type: pulumi.Input['AccessEntryAccessScopeType']
        """
        The type of the access scope.
        """
        namespaces: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The namespaces to associate with the access scope. Only specify if Type is set to 'namespace'.
        """
elif False:
    AccessEntryAccessScopeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccessEntryAccessScopeArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['AccessEntryAccessScopeType'],
                 namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The access scope of the access policy.
        :param pulumi.Input['AccessEntryAccessScopeType'] type: The type of the access scope.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] namespaces: The namespaces to associate with the access scope. Only specify if Type is set to 'namespace'.
        """
        pulumi.set(__self__, "type", type)
        if namespaces is not None:
            pulumi.set(__self__, "namespaces", namespaces)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['AccessEntryAccessScopeType']:
        """
        The type of the access scope.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['AccessEntryAccessScopeType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def namespaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The namespaces to associate with the access scope. Only specify if Type is set to 'namespace'.
        """
        return pulumi.get(self, "namespaces")

    @namespaces.setter
    def namespaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "namespaces", value)


if not MYPY:
    class AddonPodIdentityAssociationArgsDict(TypedDict):
        """
        A pod identity to associate with an add-on.
        """
        role_arn: pulumi.Input[str]
        """
        The IAM role ARN that the pod identity association is created for.
        """
        service_account: pulumi.Input[str]
        """
        The Kubernetes service account that the pod identity association is created for.
        """
elif False:
    AddonPodIdentityAssociationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AddonPodIdentityAssociationArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[str],
                 service_account: pulumi.Input[str]):
        """
        A pod identity to associate with an add-on.
        :param pulumi.Input[str] role_arn: The IAM role ARN that the pod identity association is created for.
        :param pulumi.Input[str] service_account: The Kubernetes service account that the pod identity association is created for.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "service_account", service_account)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        The IAM role ARN that the pod identity association is created for.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Input[str]:
        """
        The Kubernetes service account that the pod identity association is created for.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_account", value)


if not MYPY:
    class ClusterAccessConfigArgsDict(TypedDict):
        """
        An object representing the Access Config to use for the cluster.
        """
        authentication_mode: NotRequired[pulumi.Input['ClusterAccessConfigAuthenticationMode']]
        """
        Specify the authentication mode that should be used to create your cluster.
        """
        bootstrap_cluster_creator_admin_permissions: NotRequired[pulumi.Input[bool]]
        """
        Set this value to false to avoid creating a default cluster admin Access Entry using the IAM principal used to create the cluster.
        """
elif False:
    ClusterAccessConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterAccessConfigArgs:
    def __init__(__self__, *,
                 authentication_mode: Optional[pulumi.Input['ClusterAccessConfigAuthenticationMode']] = None,
                 bootstrap_cluster_creator_admin_permissions: Optional[pulumi.Input[bool]] = None):
        """
        An object representing the Access Config to use for the cluster.
        :param pulumi.Input['ClusterAccessConfigAuthenticationMode'] authentication_mode: Specify the authentication mode that should be used to create your cluster.
        :param pulumi.Input[bool] bootstrap_cluster_creator_admin_permissions: Set this value to false to avoid creating a default cluster admin Access Entry using the IAM principal used to create the cluster.
        """
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if bootstrap_cluster_creator_admin_permissions is not None:
            pulumi.set(__self__, "bootstrap_cluster_creator_admin_permissions", bootstrap_cluster_creator_admin_permissions)

    @property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[pulumi.Input['ClusterAccessConfigAuthenticationMode']]:
        """
        Specify the authentication mode that should be used to create your cluster.
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: Optional[pulumi.Input['ClusterAccessConfigAuthenticationMode']]):
        pulumi.set(self, "authentication_mode", value)

    @property
    @pulumi.getter(name="bootstrapClusterCreatorAdminPermissions")
    def bootstrap_cluster_creator_admin_permissions(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this value to false to avoid creating a default cluster admin Access Entry using the IAM principal used to create the cluster.
        """
        return pulumi.get(self, "bootstrap_cluster_creator_admin_permissions")

    @bootstrap_cluster_creator_admin_permissions.setter
    def bootstrap_cluster_creator_admin_permissions(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "bootstrap_cluster_creator_admin_permissions", value)


if not MYPY:
    class ClusterControlPlanePlacementArgsDict(TypedDict):
        """
        Specify the placement group of the control plane machines for your cluster.
        """
        group_name: NotRequired[pulumi.Input[str]]
        """
        Specify the placement group name of the control place machines for your cluster.
        """
elif False:
    ClusterControlPlanePlacementArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterControlPlanePlacementArgs:
    def __init__(__self__, *,
                 group_name: Optional[pulumi.Input[str]] = None):
        """
        Specify the placement group of the control plane machines for your cluster.
        :param pulumi.Input[str] group_name: Specify the placement group name of the control place machines for your cluster.
        """
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the placement group name of the control place machines for your cluster.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_name", value)


if not MYPY:
    class ClusterEncryptionConfigArgsDict(TypedDict):
        """
        The encryption configuration for the cluster
        """
        provider: NotRequired[pulumi.Input['ClusterProviderArgsDict']]
        """
        The encryption provider for the cluster.
        """
        resources: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Specifies the resources to be encrypted. The only supported value is "secrets".
        """
elif False:
    ClusterEncryptionConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterEncryptionConfigArgs:
    def __init__(__self__, *,
                 provider: Optional[pulumi.Input['ClusterProviderArgs']] = None,
                 resources: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The encryption configuration for the cluster
        :param pulumi.Input['ClusterProviderArgs'] provider: The encryption provider for the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resources: Specifies the resources to be encrypted. The only supported value is "secrets".
        """
        if provider is not None:
            pulumi.set(__self__, "provider", provider)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)

    @property
    @pulumi.getter
    def provider(self) -> Optional[pulumi.Input['ClusterProviderArgs']]:
        """
        The encryption provider for the cluster.
        """
        return pulumi.get(self, "provider")

    @provider.setter
    def provider(self, value: Optional[pulumi.Input['ClusterProviderArgs']]):
        pulumi.set(self, "provider", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the resources to be encrypted. The only supported value is "secrets".
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resources", value)


if not MYPY:
    class ClusterKubernetesNetworkConfigArgsDict(TypedDict):
        """
        The Kubernetes network configuration for the cluster.
        """
        ip_family: NotRequired[pulumi.Input['ClusterKubernetesNetworkConfigIpFamily']]
        """
        Ipv4 or Ipv6. You can only specify ipv6 for 1.21 and later clusters that use version 1.10.1 or later of the Amazon VPC CNI add-on
        """
        service_ipv4_cidr: NotRequired[pulumi.Input[str]]
        """
        The CIDR block to assign Kubernetes service IP addresses from. If you don't specify a block, Kubernetes assigns addresses from either the 10.100.0.0/16 or 172.20.0.0/16 CIDR blocks. We recommend that you specify a block that does not overlap with resources in other networks that are peered or connected to your VPC. 
        """
        service_ipv6_cidr: NotRequired[pulumi.Input[str]]
        """
        The CIDR block to assign Kubernetes service IP addresses from.
        """
elif False:
    ClusterKubernetesNetworkConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterKubernetesNetworkConfigArgs:
    def __init__(__self__, *,
                 ip_family: Optional[pulumi.Input['ClusterKubernetesNetworkConfigIpFamily']] = None,
                 service_ipv4_cidr: Optional[pulumi.Input[str]] = None,
                 service_ipv6_cidr: Optional[pulumi.Input[str]] = None):
        """
        The Kubernetes network configuration for the cluster.
        :param pulumi.Input['ClusterKubernetesNetworkConfigIpFamily'] ip_family: Ipv4 or Ipv6. You can only specify ipv6 for 1.21 and later clusters that use version 1.10.1 or later of the Amazon VPC CNI add-on
        :param pulumi.Input[str] service_ipv4_cidr: The CIDR block to assign Kubernetes service IP addresses from. If you don't specify a block, Kubernetes assigns addresses from either the 10.100.0.0/16 or 172.20.0.0/16 CIDR blocks. We recommend that you specify a block that does not overlap with resources in other networks that are peered or connected to your VPC. 
        :param pulumi.Input[str] service_ipv6_cidr: The CIDR block to assign Kubernetes service IP addresses from.
        """
        if ip_family is not None:
            pulumi.set(__self__, "ip_family", ip_family)
        if service_ipv4_cidr is not None:
            pulumi.set(__self__, "service_ipv4_cidr", service_ipv4_cidr)
        if service_ipv6_cidr is not None:
            pulumi.set(__self__, "service_ipv6_cidr", service_ipv6_cidr)

    @property
    @pulumi.getter(name="ipFamily")
    def ip_family(self) -> Optional[pulumi.Input['ClusterKubernetesNetworkConfigIpFamily']]:
        """
        Ipv4 or Ipv6. You can only specify ipv6 for 1.21 and later clusters that use version 1.10.1 or later of the Amazon VPC CNI add-on
        """
        return pulumi.get(self, "ip_family")

    @ip_family.setter
    def ip_family(self, value: Optional[pulumi.Input['ClusterKubernetesNetworkConfigIpFamily']]):
        pulumi.set(self, "ip_family", value)

    @property
    @pulumi.getter(name="serviceIpv4Cidr")
    def service_ipv4_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block to assign Kubernetes service IP addresses from. If you don't specify a block, Kubernetes assigns addresses from either the 10.100.0.0/16 or 172.20.0.0/16 CIDR blocks. We recommend that you specify a block that does not overlap with resources in other networks that are peered or connected to your VPC. 
        """
        return pulumi.get(self, "service_ipv4_cidr")

    @service_ipv4_cidr.setter
    def service_ipv4_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_ipv4_cidr", value)

    @property
    @pulumi.getter(name="serviceIpv6Cidr")
    def service_ipv6_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block to assign Kubernetes service IP addresses from.
        """
        return pulumi.get(self, "service_ipv6_cidr")

    @service_ipv6_cidr.setter
    def service_ipv6_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_ipv6_cidr", value)


if not MYPY:
    class ClusterLoggingEnabledTypesArgsDict(TypedDict):
        """
        The cluster control plane logging configuration for your cluster. 
        """
        enabled_types: NotRequired[pulumi.Input[Sequence[pulumi.Input['ClusterLoggingTypeConfigArgsDict']]]]
        """
        The enabled control plane logs for your cluster. All log types are disabled if the array is empty.

        > When updating a resource, you must include this `EnabledTypes` property if the previous CloudFormation template of the resource had it.
        """
elif False:
    ClusterLoggingEnabledTypesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterLoggingEnabledTypesArgs:
    def __init__(__self__, *,
                 enabled_types: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLoggingTypeConfigArgs']]]] = None):
        """
        The cluster control plane logging configuration for your cluster. 
        :param pulumi.Input[Sequence[pulumi.Input['ClusterLoggingTypeConfigArgs']]] enabled_types: The enabled control plane logs for your cluster. All log types are disabled if the array is empty.
               
               > When updating a resource, you must include this `EnabledTypes` property if the previous CloudFormation template of the resource had it.
        """
        if enabled_types is not None:
            pulumi.set(__self__, "enabled_types", enabled_types)

    @property
    @pulumi.getter(name="enabledTypes")
    def enabled_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLoggingTypeConfigArgs']]]]:
        """
        The enabled control plane logs for your cluster. All log types are disabled if the array is empty.

        > When updating a resource, you must include this `EnabledTypes` property if the previous CloudFormation template of the resource had it.
        """
        return pulumi.get(self, "enabled_types")

    @enabled_types.setter
    def enabled_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLoggingTypeConfigArgs']]]]):
        pulumi.set(self, "enabled_types", value)


if not MYPY:
    class ClusterLoggingTypeConfigArgsDict(TypedDict):
        """
        Enabled Logging Type
        """
        type: NotRequired[pulumi.Input['ClusterLoggingTypeConfigType']]
        """
        name of the log type
        """
elif False:
    ClusterLoggingTypeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterLoggingTypeConfigArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input['ClusterLoggingTypeConfigType']] = None):
        """
        Enabled Logging Type
        :param pulumi.Input['ClusterLoggingTypeConfigType'] type: name of the log type
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['ClusterLoggingTypeConfigType']]:
        """
        name of the log type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['ClusterLoggingTypeConfigType']]):
        pulumi.set(self, "type", value)


if not MYPY:
    class ClusterOutpostConfigArgsDict(TypedDict):
        """
        An object representing the Outpost configuration to use for AWS EKS outpost cluster.
        """
        control_plane_instance_type: pulumi.Input[str]
        """
        Specify the Instance type of the machines that should be used to create your cluster.
        """
        outpost_arns: pulumi.Input[Sequence[pulumi.Input[str]]]
        """
        Specify one or more Arn(s) of Outpost(s) on which you would like to create your cluster.
        """
        control_plane_placement: NotRequired[pulumi.Input['ClusterControlPlanePlacementArgsDict']]
        """
        Specify the placement group of the control plane machines for your cluster.
        """
elif False:
    ClusterOutpostConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterOutpostConfigArgs:
    def __init__(__self__, *,
                 control_plane_instance_type: pulumi.Input[str],
                 outpost_arns: pulumi.Input[Sequence[pulumi.Input[str]]],
                 control_plane_placement: Optional[pulumi.Input['ClusterControlPlanePlacementArgs']] = None):
        """
        An object representing the Outpost configuration to use for AWS EKS outpost cluster.
        :param pulumi.Input[str] control_plane_instance_type: Specify the Instance type of the machines that should be used to create your cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] outpost_arns: Specify one or more Arn(s) of Outpost(s) on which you would like to create your cluster.
        :param pulumi.Input['ClusterControlPlanePlacementArgs'] control_plane_placement: Specify the placement group of the control plane machines for your cluster.
        """
        pulumi.set(__self__, "control_plane_instance_type", control_plane_instance_type)
        pulumi.set(__self__, "outpost_arns", outpost_arns)
        if control_plane_placement is not None:
            pulumi.set(__self__, "control_plane_placement", control_plane_placement)

    @property
    @pulumi.getter(name="controlPlaneInstanceType")
    def control_plane_instance_type(self) -> pulumi.Input[str]:
        """
        Specify the Instance type of the machines that should be used to create your cluster.
        """
        return pulumi.get(self, "control_plane_instance_type")

    @control_plane_instance_type.setter
    def control_plane_instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "control_plane_instance_type", value)

    @property
    @pulumi.getter(name="outpostArns")
    def outpost_arns(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specify one or more Arn(s) of Outpost(s) on which you would like to create your cluster.
        """
        return pulumi.get(self, "outpost_arns")

    @outpost_arns.setter
    def outpost_arns(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "outpost_arns", value)

    @property
    @pulumi.getter(name="controlPlanePlacement")
    def control_plane_placement(self) -> Optional[pulumi.Input['ClusterControlPlanePlacementArgs']]:
        """
        Specify the placement group of the control plane machines for your cluster.
        """
        return pulumi.get(self, "control_plane_placement")

    @control_plane_placement.setter
    def control_plane_placement(self, value: Optional[pulumi.Input['ClusterControlPlanePlacementArgs']]):
        pulumi.set(self, "control_plane_placement", value)


if not MYPY:
    class ClusterProviderArgsDict(TypedDict):
        key_arn: NotRequired[pulumi.Input[str]]
        """
        Amazon Resource Name (ARN) or alias of the KMS key. The KMS key must be symmetric, created in the same region as the cluster, and if the KMS key was created in a different account, the user must have access to the KMS key.
        """
elif False:
    ClusterProviderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterProviderArgs:
    def __init__(__self__, *,
                 key_arn: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key_arn: Amazon Resource Name (ARN) or alias of the KMS key. The KMS key must be symmetric, created in the same region as the cluster, and if the KMS key was created in a different account, the user must have access to the KMS key.
        """
        if key_arn is not None:
            pulumi.set(__self__, "key_arn", key_arn)

    @property
    @pulumi.getter(name="keyArn")
    def key_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Amazon Resource Name (ARN) or alias of the KMS key. The KMS key must be symmetric, created in the same region as the cluster, and if the KMS key was created in a different account, the user must have access to the KMS key.
        """
        return pulumi.get(self, "key_arn")

    @key_arn.setter
    def key_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_arn", value)


if not MYPY:
    class ClusterResourcesVpcConfigArgsDict(TypedDict):
        """
        An object representing the VPC configuration to use for an Amazon EKS cluster.
        """
        subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]]
        """
        Specify subnets for your Amazon EKS nodes. Amazon EKS creates cross-account elastic network interfaces in these subnets to allow communication between your nodes and the Kubernetes control plane.
        """
        endpoint_private_access: NotRequired[pulumi.Input[bool]]
        """
        Set this value to true to enable private access for your cluster's Kubernetes API server endpoint. If you enable private access, Kubernetes API requests from within your cluster's VPC use the private VPC endpoint. The default value for this parameter is false, which disables private access for your Kubernetes API server. If you disable private access and you have nodes or AWS Fargate pods in the cluster, then ensure that publicAccessCidrs includes the necessary CIDR blocks for communication with the nodes or Fargate pods.
        """
        endpoint_public_access: NotRequired[pulumi.Input[bool]]
        """
        Set this value to false to disable public access to your cluster's Kubernetes API server endpoint. If you disable public access, your cluster's Kubernetes API server can only receive requests from within the cluster VPC. The default value for this parameter is true, which enables public access for your Kubernetes API server.
        """
        public_access_cidrs: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint. Communication to the endpoint from addresses outside of the CIDR blocks that you specify is denied. The default value is 0.0.0.0/0. If you've disabled private endpoint access and you have nodes or AWS Fargate pods in the cluster, then ensure that you specify the necessary CIDR blocks.
        """
        security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Specify one or more security groups for the cross-account elastic network interfaces that Amazon EKS creates to use to allow communication between your worker nodes and the Kubernetes control plane. If you don't specify a security group, the default security group for your VPC is used.
        """
elif False:
    ClusterResourcesVpcConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterResourcesVpcConfigArgs:
    def __init__(__self__, *,
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 endpoint_private_access: Optional[pulumi.Input[bool]] = None,
                 endpoint_public_access: Optional[pulumi.Input[bool]] = None,
                 public_access_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        An object representing the VPC configuration to use for an Amazon EKS cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: Specify subnets for your Amazon EKS nodes. Amazon EKS creates cross-account elastic network interfaces in these subnets to allow communication between your nodes and the Kubernetes control plane.
        :param pulumi.Input[bool] endpoint_private_access: Set this value to true to enable private access for your cluster's Kubernetes API server endpoint. If you enable private access, Kubernetes API requests from within your cluster's VPC use the private VPC endpoint. The default value for this parameter is false, which disables private access for your Kubernetes API server. If you disable private access and you have nodes or AWS Fargate pods in the cluster, then ensure that publicAccessCidrs includes the necessary CIDR blocks for communication with the nodes or Fargate pods.
        :param pulumi.Input[bool] endpoint_public_access: Set this value to false to disable public access to your cluster's Kubernetes API server endpoint. If you disable public access, your cluster's Kubernetes API server can only receive requests from within the cluster VPC. The default value for this parameter is true, which enables public access for your Kubernetes API server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_access_cidrs: The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint. Communication to the endpoint from addresses outside of the CIDR blocks that you specify is denied. The default value is 0.0.0.0/0. If you've disabled private endpoint access and you have nodes or AWS Fargate pods in the cluster, then ensure that you specify the necessary CIDR blocks.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: Specify one or more security groups for the cross-account elastic network interfaces that Amazon EKS creates to use to allow communication between your worker nodes and the Kubernetes control plane. If you don't specify a security group, the default security group for your VPC is used.
        """
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if endpoint_private_access is not None:
            pulumi.set(__self__, "endpoint_private_access", endpoint_private_access)
        if endpoint_public_access is not None:
            pulumi.set(__self__, "endpoint_public_access", endpoint_public_access)
        if public_access_cidrs is not None:
            pulumi.set(__self__, "public_access_cidrs", public_access_cidrs)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specify subnets for your Amazon EKS nodes. Amazon EKS creates cross-account elastic network interfaces in these subnets to allow communication between your nodes and the Kubernetes control plane.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="endpointPrivateAccess")
    def endpoint_private_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this value to true to enable private access for your cluster's Kubernetes API server endpoint. If you enable private access, Kubernetes API requests from within your cluster's VPC use the private VPC endpoint. The default value for this parameter is false, which disables private access for your Kubernetes API server. If you disable private access and you have nodes or AWS Fargate pods in the cluster, then ensure that publicAccessCidrs includes the necessary CIDR blocks for communication with the nodes or Fargate pods.
        """
        return pulumi.get(self, "endpoint_private_access")

    @endpoint_private_access.setter
    def endpoint_private_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "endpoint_private_access", value)

    @property
    @pulumi.getter(name="endpointPublicAccess")
    def endpoint_public_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this value to false to disable public access to your cluster's Kubernetes API server endpoint. If you disable public access, your cluster's Kubernetes API server can only receive requests from within the cluster VPC. The default value for this parameter is true, which enables public access for your Kubernetes API server.
        """
        return pulumi.get(self, "endpoint_public_access")

    @endpoint_public_access.setter
    def endpoint_public_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "endpoint_public_access", value)

    @property
    @pulumi.getter(name="publicAccessCidrs")
    def public_access_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The CIDR blocks that are allowed access to your cluster's public Kubernetes API server endpoint. Communication to the endpoint from addresses outside of the CIDR blocks that you specify is denied. The default value is 0.0.0.0/0. If you've disabled private endpoint access and you have nodes or AWS Fargate pods in the cluster, then ensure that you specify the necessary CIDR blocks.
        """
        return pulumi.get(self, "public_access_cidrs")

    @public_access_cidrs.setter
    def public_access_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "public_access_cidrs", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specify one or more security groups for the cross-account elastic network interfaces that Amazon EKS creates to use to allow communication between your worker nodes and the Kubernetes control plane. If you don't specify a security group, the default security group for your VPC is used.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)


if not MYPY:
    class ClusterUpgradePolicyArgsDict(TypedDict):
        """
        An object representing the Upgrade Policy to use for the cluster.
        """
        support_type: NotRequired[pulumi.Input['ClusterUpgradePolicySupportType']]
        """
        Specify the support type for your cluster.
        """
elif False:
    ClusterUpgradePolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterUpgradePolicyArgs:
    def __init__(__self__, *,
                 support_type: Optional[pulumi.Input['ClusterUpgradePolicySupportType']] = None):
        """
        An object representing the Upgrade Policy to use for the cluster.
        :param pulumi.Input['ClusterUpgradePolicySupportType'] support_type: Specify the support type for your cluster.
        """
        if support_type is not None:
            pulumi.set(__self__, "support_type", support_type)

    @property
    @pulumi.getter(name="supportType")
    def support_type(self) -> Optional[pulumi.Input['ClusterUpgradePolicySupportType']]:
        """
        Specify the support type for your cluster.
        """
        return pulumi.get(self, "support_type")

    @support_type.setter
    def support_type(self, value: Optional[pulumi.Input['ClusterUpgradePolicySupportType']]):
        pulumi.set(self, "support_type", value)


if not MYPY:
    class ClusterZonalShiftConfigArgsDict(TypedDict):
        """
        The current zonal shift configuration to use for the cluster.
        """
        enabled: NotRequired[pulumi.Input[bool]]
        """
        Set this value to true to enable zonal shift for the cluster.
        """
elif False:
    ClusterZonalShiftConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterZonalShiftConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        The current zonal shift configuration to use for the cluster.
        :param pulumi.Input[bool] enabled: Set this value to true to enable zonal shift for the cluster.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this value to true to enable zonal shift for the cluster.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class FargateProfileLabelArgsDict(TypedDict):
        """
        A key-value pair to associate with a pod.
        """
        key: pulumi.Input[str]
        """
        The key name of the label.
        """
        value: pulumi.Input[str]
        """
        The value for the label. 
        """
elif False:
    FargateProfileLabelArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FargateProfileLabelArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        A key-value pair to associate with a pod.
        :param pulumi.Input[str] key: The key name of the label.
        :param pulumi.Input[str] value: The value for the label. 
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key name of the label.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for the label. 
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class FargateProfileSelectorArgsDict(TypedDict):
        namespace: pulumi.Input[str]
        """
        The Kubernetes `namespace` that the selector should match.
        """
        labels: NotRequired[pulumi.Input[Sequence[pulumi.Input['FargateProfileLabelArgsDict']]]]
        """
        The Kubernetes labels that the selector should match. A pod must contain all of the labels that are specified in the selector for it to be considered a match.
        """
elif False:
    FargateProfileSelectorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FargateProfileSelectorArgs:
    def __init__(__self__, *,
                 namespace: pulumi.Input[str],
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['FargateProfileLabelArgs']]]] = None):
        """
        :param pulumi.Input[str] namespace: The Kubernetes `namespace` that the selector should match.
        :param pulumi.Input[Sequence[pulumi.Input['FargateProfileLabelArgs']]] labels: The Kubernetes labels that the selector should match. A pod must contain all of the labels that are specified in the selector for it to be considered a match.
        """
        pulumi.set(__self__, "namespace", namespace)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        The Kubernetes `namespace` that the selector should match.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FargateProfileLabelArgs']]]]:
        """
        The Kubernetes labels that the selector should match. A pod must contain all of the labels that are specified in the selector for it to be considered a match.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FargateProfileLabelArgs']]]]):
        pulumi.set(self, "labels", value)


if not MYPY:
    class IdentityProviderConfigOidcIdentityProviderConfigArgsDict(TypedDict):
        """
        An object representing an OpenID Connect (OIDC) configuration.
        """
        client_id: pulumi.Input[str]
        """
        This is also known as audience. The ID for the client application that makes authentication requests to the OpenID identity provider.
        """
        issuer_url: pulumi.Input[str]
        """
        The URL of the OpenID identity provider that allows the API server to discover public signing keys for verifying tokens.
        """
        groups_claim: NotRequired[pulumi.Input[str]]
        """
        The JWT claim that the provider uses to return your groups.
        """
        groups_prefix: NotRequired[pulumi.Input[str]]
        """
        The prefix that is prepended to group claims to prevent clashes with existing names (such as system: groups).
        """
        required_claims: NotRequired[pulumi.Input[Sequence[pulumi.Input['IdentityProviderConfigRequiredClaimArgsDict']]]]
        """
        The key-value pairs that describe required claims in the identity token. If set, each claim is verified to be present in the token with a matching value.
        """
        username_claim: NotRequired[pulumi.Input[str]]
        """
        The JSON Web Token (JWT) claim to use as the username. The default is sub, which is expected to be a unique identifier of the end user. You can choose other claims, such as email or name, depending on the OpenID identity provider. Claims other than email are prefixed with the issuer URL to prevent naming clashes with other plug-ins.
        """
        username_prefix: NotRequired[pulumi.Input[str]]
        """
        The prefix that is prepended to username claims to prevent clashes with existing names. If you do not provide this field, and username is a value other than email, the prefix defaults to issuerurl#. You can use the value - to disable all prefixing.
        """
elif False:
    IdentityProviderConfigOidcIdentityProviderConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IdentityProviderConfigOidcIdentityProviderConfigArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[str],
                 issuer_url: pulumi.Input[str],
                 groups_claim: Optional[pulumi.Input[str]] = None,
                 groups_prefix: Optional[pulumi.Input[str]] = None,
                 required_claims: Optional[pulumi.Input[Sequence[pulumi.Input['IdentityProviderConfigRequiredClaimArgs']]]] = None,
                 username_claim: Optional[pulumi.Input[str]] = None,
                 username_prefix: Optional[pulumi.Input[str]] = None):
        """
        An object representing an OpenID Connect (OIDC) configuration.
        :param pulumi.Input[str] client_id: This is also known as audience. The ID for the client application that makes authentication requests to the OpenID identity provider.
        :param pulumi.Input[str] issuer_url: The URL of the OpenID identity provider that allows the API server to discover public signing keys for verifying tokens.
        :param pulumi.Input[str] groups_claim: The JWT claim that the provider uses to return your groups.
        :param pulumi.Input[str] groups_prefix: The prefix that is prepended to group claims to prevent clashes with existing names (such as system: groups).
        :param pulumi.Input[Sequence[pulumi.Input['IdentityProviderConfigRequiredClaimArgs']]] required_claims: The key-value pairs that describe required claims in the identity token. If set, each claim is verified to be present in the token with a matching value.
        :param pulumi.Input[str] username_claim: The JSON Web Token (JWT) claim to use as the username. The default is sub, which is expected to be a unique identifier of the end user. You can choose other claims, such as email or name, depending on the OpenID identity provider. Claims other than email are prefixed with the issuer URL to prevent naming clashes with other plug-ins.
        :param pulumi.Input[str] username_prefix: The prefix that is prepended to username claims to prevent clashes with existing names. If you do not provide this field, and username is a value other than email, the prefix defaults to issuerurl#. You can use the value - to disable all prefixing.
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "issuer_url", issuer_url)
        if groups_claim is not None:
            pulumi.set(__self__, "groups_claim", groups_claim)
        if groups_prefix is not None:
            pulumi.set(__self__, "groups_prefix", groups_prefix)
        if required_claims is not None:
            pulumi.set(__self__, "required_claims", required_claims)
        if username_claim is not None:
            pulumi.set(__self__, "username_claim", username_claim)
        if username_prefix is not None:
            pulumi.set(__self__, "username_prefix", username_prefix)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        This is also known as audience. The ID for the client application that makes authentication requests to the OpenID identity provider.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="issuerUrl")
    def issuer_url(self) -> pulumi.Input[str]:
        """
        The URL of the OpenID identity provider that allows the API server to discover public signing keys for verifying tokens.
        """
        return pulumi.get(self, "issuer_url")

    @issuer_url.setter
    def issuer_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "issuer_url", value)

    @property
    @pulumi.getter(name="groupsClaim")
    def groups_claim(self) -> Optional[pulumi.Input[str]]:
        """
        The JWT claim that the provider uses to return your groups.
        """
        return pulumi.get(self, "groups_claim")

    @groups_claim.setter
    def groups_claim(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "groups_claim", value)

    @property
    @pulumi.getter(name="groupsPrefix")
    def groups_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The prefix that is prepended to group claims to prevent clashes with existing names (such as system: groups).
        """
        return pulumi.get(self, "groups_prefix")

    @groups_prefix.setter
    def groups_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "groups_prefix", value)

    @property
    @pulumi.getter(name="requiredClaims")
    def required_claims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IdentityProviderConfigRequiredClaimArgs']]]]:
        """
        The key-value pairs that describe required claims in the identity token. If set, each claim is verified to be present in the token with a matching value.
        """
        return pulumi.get(self, "required_claims")

    @required_claims.setter
    def required_claims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IdentityProviderConfigRequiredClaimArgs']]]]):
        pulumi.set(self, "required_claims", value)

    @property
    @pulumi.getter(name="usernameClaim")
    def username_claim(self) -> Optional[pulumi.Input[str]]:
        """
        The JSON Web Token (JWT) claim to use as the username. The default is sub, which is expected to be a unique identifier of the end user. You can choose other claims, such as email or name, depending on the OpenID identity provider. Claims other than email are prefixed with the issuer URL to prevent naming clashes with other plug-ins.
        """
        return pulumi.get(self, "username_claim")

    @username_claim.setter
    def username_claim(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username_claim", value)

    @property
    @pulumi.getter(name="usernamePrefix")
    def username_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The prefix that is prepended to username claims to prevent clashes with existing names. If you do not provide this field, and username is a value other than email, the prefix defaults to issuerurl#. You can use the value - to disable all prefixing.
        """
        return pulumi.get(self, "username_prefix")

    @username_prefix.setter
    def username_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username_prefix", value)


if not MYPY:
    class IdentityProviderConfigRequiredClaimArgsDict(TypedDict):
        """
        The key value pairs that describe required claims in the identity token. If set, each claim is verified to be present in the token with a matching value.
        """
        key: pulumi.Input[str]
        """
        The key of the requiredClaims.
        """
        value: pulumi.Input[str]
        """
        The value for the requiredClaims.
        """
elif False:
    IdentityProviderConfigRequiredClaimArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IdentityProviderConfigRequiredClaimArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        The key value pairs that describe required claims in the identity token. If set, each claim is verified to be present in the token with a matching value.
        :param pulumi.Input[str] key: The key of the requiredClaims.
        :param pulumi.Input[str] value: The value for the requiredClaims.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key of the requiredClaims.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for the requiredClaims.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class LoggingArgsDict(TypedDict):
        """
        Enable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs based on log types. By default, cluster control plane logs aren't exported to CloudWatch Logs.
        """
        cluster_logging: NotRequired[pulumi.Input['ClusterLoggingEnabledTypesArgsDict']]
        """
        The cluster control plane logging configuration for your cluster. 
        """
elif False:
    LoggingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class LoggingArgs:
    def __init__(__self__, *,
                 cluster_logging: Optional[pulumi.Input['ClusterLoggingEnabledTypesArgs']] = None):
        """
        Enable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs based on log types. By default, cluster control plane logs aren't exported to CloudWatch Logs.
        :param pulumi.Input['ClusterLoggingEnabledTypesArgs'] cluster_logging: The cluster control plane logging configuration for your cluster. 
        """
        if cluster_logging is not None:
            pulumi.set(__self__, "cluster_logging", cluster_logging)

    @property
    @pulumi.getter(name="clusterLogging")
    def cluster_logging(self) -> Optional[pulumi.Input['ClusterLoggingEnabledTypesArgs']]:
        """
        The cluster control plane logging configuration for your cluster. 
        """
        return pulumi.get(self, "cluster_logging")

    @cluster_logging.setter
    def cluster_logging(self, value: Optional[pulumi.Input['ClusterLoggingEnabledTypesArgs']]):
        pulumi.set(self, "cluster_logging", value)


if not MYPY:
    class NodegroupLaunchTemplateSpecificationArgsDict(TypedDict):
        """
        An object representing a launch template specification for AWS EKS Nodegroup.
        """
        id: NotRequired[pulumi.Input[str]]
        """
        The ID of the launch template.

        You must specify either the launch template ID or the launch template name in the request, but not both.
        """
        name: NotRequired[pulumi.Input[str]]
        """
        The name of the launch template.

        You must specify either the launch template name or the launch template ID in the request, but not both.
        """
        version: NotRequired[pulumi.Input[str]]
        """
        The version number of the launch template to use. If no version is specified, then the template's default version is used.
        """
elif False:
    NodegroupLaunchTemplateSpecificationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NodegroupLaunchTemplateSpecificationArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        An object representing a launch template specification for AWS EKS Nodegroup.
        :param pulumi.Input[str] id: The ID of the launch template.
               
               You must specify either the launch template ID or the launch template name in the request, but not both.
        :param pulumi.Input[str] name: The name of the launch template.
               
               You must specify either the launch template name or the launch template ID in the request, but not both.
        :param pulumi.Input[str] version: The version number of the launch template to use. If no version is specified, then the template's default version is used.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the launch template.

        You must specify either the launch template ID or the launch template name in the request, but not both.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the launch template.

        You must specify either the launch template name or the launch template ID in the request, but not both.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version number of the launch template to use. If no version is specified, then the template's default version is used.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class NodegroupRemoteAccessArgsDict(TypedDict):
        """
        An object representing a remote access configuration specification for AWS EKS Nodegroup.
        """
        ec2_ssh_key: pulumi.Input[str]
        """
        The Amazon EC2 SSH key name that provides access for SSH communication with the nodes in the managed node group. For more information, see [Amazon EC2 key pairs and Linux instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html) in the *Amazon Elastic Compute Cloud User Guide for Linux Instances* . For Windows, an Amazon EC2 SSH key is used to obtain the RDP password. For more information, see [Amazon EC2 key pairs and Windows instances](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-key-pairs.html) in the *Amazon Elastic Compute Cloud User Guide for Windows Instances* .
        """
        source_security_groups: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The security group IDs that are allowed SSH access (port 22) to the nodes. For Windows, the port is 3389. If you specify an Amazon EC2 SSH key but don't specify a source security group when you create a managed node group, then the port on the nodes is opened to the internet ( `0.0.0.0/0` ). For more information, see [Security Groups for Your VPC](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html) in the *Amazon Virtual Private Cloud User Guide* .
        """
elif False:
    NodegroupRemoteAccessArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NodegroupRemoteAccessArgs:
    def __init__(__self__, *,
                 ec2_ssh_key: pulumi.Input[str],
                 source_security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        An object representing a remote access configuration specification for AWS EKS Nodegroup.
        :param pulumi.Input[str] ec2_ssh_key: The Amazon EC2 SSH key name that provides access for SSH communication with the nodes in the managed node group. For more information, see [Amazon EC2 key pairs and Linux instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html) in the *Amazon Elastic Compute Cloud User Guide for Linux Instances* . For Windows, an Amazon EC2 SSH key is used to obtain the RDP password. For more information, see [Amazon EC2 key pairs and Windows instances](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-key-pairs.html) in the *Amazon Elastic Compute Cloud User Guide for Windows Instances* .
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_security_groups: The security group IDs that are allowed SSH access (port 22) to the nodes. For Windows, the port is 3389. If you specify an Amazon EC2 SSH key but don't specify a source security group when you create a managed node group, then the port on the nodes is opened to the internet ( `0.0.0.0/0` ). For more information, see [Security Groups for Your VPC](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html) in the *Amazon Virtual Private Cloud User Guide* .
        """
        pulumi.set(__self__, "ec2_ssh_key", ec2_ssh_key)
        if source_security_groups is not None:
            pulumi.set(__self__, "source_security_groups", source_security_groups)

    @property
    @pulumi.getter(name="ec2SshKey")
    def ec2_ssh_key(self) -> pulumi.Input[str]:
        """
        The Amazon EC2 SSH key name that provides access for SSH communication with the nodes in the managed node group. For more information, see [Amazon EC2 key pairs and Linux instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html) in the *Amazon Elastic Compute Cloud User Guide for Linux Instances* . For Windows, an Amazon EC2 SSH key is used to obtain the RDP password. For more information, see [Amazon EC2 key pairs and Windows instances](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-key-pairs.html) in the *Amazon Elastic Compute Cloud User Guide for Windows Instances* .
        """
        return pulumi.get(self, "ec2_ssh_key")

    @ec2_ssh_key.setter
    def ec2_ssh_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "ec2_ssh_key", value)

    @property
    @pulumi.getter(name="sourceSecurityGroups")
    def source_security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The security group IDs that are allowed SSH access (port 22) to the nodes. For Windows, the port is 3389. If you specify an Amazon EC2 SSH key but don't specify a source security group when you create a managed node group, then the port on the nodes is opened to the internet ( `0.0.0.0/0` ). For more information, see [Security Groups for Your VPC](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html) in the *Amazon Virtual Private Cloud User Guide* .
        """
        return pulumi.get(self, "source_security_groups")

    @source_security_groups.setter
    def source_security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_security_groups", value)


if not MYPY:
    class NodegroupScalingConfigArgsDict(TypedDict):
        """
        An object representing a auto scaling group specification for AWS EKS Nodegroup.
        """
        desired_size: NotRequired[pulumi.Input[int]]
        """
        The current number of nodes that the managed node group should maintain.

        > If you use the Kubernetes [Cluster Autoscaler](https://docs.aws.amazon.com/https://github.com/kubernetes/autoscaler#kubernetes-autoscaler) , you shouldn't change the `desiredSize` value directly, as this can cause the Cluster Autoscaler to suddenly scale up or scale down. 

        Whenever this parameter changes, the number of worker nodes in the node group is updated to the specified size. If this parameter is given a value that is smaller than the current number of running worker nodes, the necessary number of worker nodes are terminated to match the given value. When using CloudFormation, no action occurs if you remove this parameter from your CFN template.

        This parameter can be different from `minSize` in some cases, such as when starting with extra hosts for testing. This parameter can also be different when you want to start with an estimated number of needed hosts, but let the Cluster Autoscaler reduce the number if there are too many. When the Cluster Autoscaler is used, the `desiredSize` parameter is altered by the Cluster Autoscaler (but can be out-of-date for short periods of time). the Cluster Autoscaler doesn't scale a managed node group lower than `minSize` or higher than `maxSize` .
        """
        max_size: NotRequired[pulumi.Input[int]]
        """
        The maximum number of nodes that the managed node group can scale out to. For information about the maximum number that you can specify, see [Amazon EKS service quotas](https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html) in the *Amazon EKS User Guide* .
        """
        min_size: NotRequired[pulumi.Input[int]]
        """
        The minimum number of nodes that the managed node group can scale in to.
        """
elif False:
    NodegroupScalingConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NodegroupScalingConfigArgs:
    def __init__(__self__, *,
                 desired_size: Optional[pulumi.Input[int]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None):
        """
        An object representing a auto scaling group specification for AWS EKS Nodegroup.
        :param pulumi.Input[int] desired_size: The current number of nodes that the managed node group should maintain.
               
               > If you use the Kubernetes [Cluster Autoscaler](https://docs.aws.amazon.com/https://github.com/kubernetes/autoscaler#kubernetes-autoscaler) , you shouldn't change the `desiredSize` value directly, as this can cause the Cluster Autoscaler to suddenly scale up or scale down. 
               
               Whenever this parameter changes, the number of worker nodes in the node group is updated to the specified size. If this parameter is given a value that is smaller than the current number of running worker nodes, the necessary number of worker nodes are terminated to match the given value. When using CloudFormation, no action occurs if you remove this parameter from your CFN template.
               
               This parameter can be different from `minSize` in some cases, such as when starting with extra hosts for testing. This parameter can also be different when you want to start with an estimated number of needed hosts, but let the Cluster Autoscaler reduce the number if there are too many. When the Cluster Autoscaler is used, the `desiredSize` parameter is altered by the Cluster Autoscaler (but can be out-of-date for short periods of time). the Cluster Autoscaler doesn't scale a managed node group lower than `minSize` or higher than `maxSize` .
        :param pulumi.Input[int] max_size: The maximum number of nodes that the managed node group can scale out to. For information about the maximum number that you can specify, see [Amazon EKS service quotas](https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html) in the *Amazon EKS User Guide* .
        :param pulumi.Input[int] min_size: The minimum number of nodes that the managed node group can scale in to.
        """
        if desired_size is not None:
            pulumi.set(__self__, "desired_size", desired_size)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)

    @property
    @pulumi.getter(name="desiredSize")
    def desired_size(self) -> Optional[pulumi.Input[int]]:
        """
        The current number of nodes that the managed node group should maintain.

        > If you use the Kubernetes [Cluster Autoscaler](https://docs.aws.amazon.com/https://github.com/kubernetes/autoscaler#kubernetes-autoscaler) , you shouldn't change the `desiredSize` value directly, as this can cause the Cluster Autoscaler to suddenly scale up or scale down. 

        Whenever this parameter changes, the number of worker nodes in the node group is updated to the specified size. If this parameter is given a value that is smaller than the current number of running worker nodes, the necessary number of worker nodes are terminated to match the given value. When using CloudFormation, no action occurs if you remove this parameter from your CFN template.

        This parameter can be different from `minSize` in some cases, such as when starting with extra hosts for testing. This parameter can also be different when you want to start with an estimated number of needed hosts, but let the Cluster Autoscaler reduce the number if there are too many. When the Cluster Autoscaler is used, the `desiredSize` parameter is altered by the Cluster Autoscaler (but can be out-of-date for short periods of time). the Cluster Autoscaler doesn't scale a managed node group lower than `minSize` or higher than `maxSize` .
        """
        return pulumi.get(self, "desired_size")

    @desired_size.setter
    def desired_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desired_size", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of nodes that the managed node group can scale out to. For information about the maximum number that you can specify, see [Amazon EKS service quotas](https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html) in the *Amazon EKS User Guide* .
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of nodes that the managed node group can scale in to.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_size", value)


if not MYPY:
    class NodegroupTaintArgsDict(TypedDict):
        """
        An object representing a Taint specification for AWS EKS Nodegroup.
        """
        effect: NotRequired[pulumi.Input[str]]
        """
        The effect of the taint.
        """
        key: NotRequired[pulumi.Input[str]]
        """
        The key of the taint.
        """
        value: NotRequired[pulumi.Input[str]]
        """
        The value of the taint.
        """
elif False:
    NodegroupTaintArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NodegroupTaintArgs:
    def __init__(__self__, *,
                 effect: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        An object representing a Taint specification for AWS EKS Nodegroup.
        :param pulumi.Input[str] effect: The effect of the taint.
        :param pulumi.Input[str] key: The key of the taint.
        :param pulumi.Input[str] value: The value of the taint.
        """
        if effect is not None:
            pulumi.set(__self__, "effect", effect)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[pulumi.Input[str]]:
        """
        The effect of the taint.
        """
        return pulumi.get(self, "effect")

    @effect.setter
    def effect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "effect", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The key of the taint.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the taint.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class NodegroupUpdateConfigArgsDict(TypedDict):
        """
        The node group update configuration.
        """
        max_unavailable: NotRequired[pulumi.Input[float]]
        """
        The maximum number of nodes unavailable at once during a version update. Nodes will be updated in parallel. This value or maxUnavailablePercentage is required to have a value.The maximum number is 100. 
        """
        max_unavailable_percentage: NotRequired[pulumi.Input[float]]
        """
        The maximum percentage of nodes unavailable during a version update. This percentage of nodes will be updated in parallel, up to 100 nodes at once. This value or maxUnavailable is required to have a value.
        """
elif False:
    NodegroupUpdateConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NodegroupUpdateConfigArgs:
    def __init__(__self__, *,
                 max_unavailable: Optional[pulumi.Input[float]] = None,
                 max_unavailable_percentage: Optional[pulumi.Input[float]] = None):
        """
        The node group update configuration.
        :param pulumi.Input[float] max_unavailable: The maximum number of nodes unavailable at once during a version update. Nodes will be updated in parallel. This value or maxUnavailablePercentage is required to have a value.The maximum number is 100. 
        :param pulumi.Input[float] max_unavailable_percentage: The maximum percentage of nodes unavailable during a version update. This percentage of nodes will be updated in parallel, up to 100 nodes at once. This value or maxUnavailable is required to have a value.
        """
        if max_unavailable is not None:
            pulumi.set(__self__, "max_unavailable", max_unavailable)
        if max_unavailable_percentage is not None:
            pulumi.set(__self__, "max_unavailable_percentage", max_unavailable_percentage)

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum number of nodes unavailable at once during a version update. Nodes will be updated in parallel. This value or maxUnavailablePercentage is required to have a value.The maximum number is 100. 
        """
        return pulumi.get(self, "max_unavailable")

    @max_unavailable.setter
    def max_unavailable(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_unavailable", value)

    @property
    @pulumi.getter(name="maxUnavailablePercentage")
    def max_unavailable_percentage(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum percentage of nodes unavailable during a version update. This percentage of nodes will be updated in parallel, up to 100 nodes at once. This value or maxUnavailable is required to have a value.
        """
        return pulumi.get(self, "max_unavailable_percentage")

    @max_unavailable_percentage.setter
    def max_unavailable_percentage(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_unavailable_percentage", value)


