# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetFileSystemResult',
    'AwaitableGetFileSystemResult',
    'get_file_system',
    'get_file_system_output',
]

@pulumi.output_type
class GetFileSystemResult:
    def __init__(__self__, arn=None, backup_policy=None, file_system_id=None, file_system_policy=None, file_system_protection=None, file_system_tags=None, lifecycle_policies=None, provisioned_throughput_in_mibps=None, replication_configuration=None, throughput_mode=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if backup_policy and not isinstance(backup_policy, dict):
            raise TypeError("Expected argument 'backup_policy' to be a dict")
        pulumi.set(__self__, "backup_policy", backup_policy)
        if file_system_id and not isinstance(file_system_id, str):
            raise TypeError("Expected argument 'file_system_id' to be a str")
        pulumi.set(__self__, "file_system_id", file_system_id)
        if file_system_policy and not isinstance(file_system_policy, dict):
            raise TypeError("Expected argument 'file_system_policy' to be a dict")
        pulumi.set(__self__, "file_system_policy", file_system_policy)
        if file_system_protection and not isinstance(file_system_protection, dict):
            raise TypeError("Expected argument 'file_system_protection' to be a dict")
        pulumi.set(__self__, "file_system_protection", file_system_protection)
        if file_system_tags and not isinstance(file_system_tags, list):
            raise TypeError("Expected argument 'file_system_tags' to be a list")
        pulumi.set(__self__, "file_system_tags", file_system_tags)
        if lifecycle_policies and not isinstance(lifecycle_policies, list):
            raise TypeError("Expected argument 'lifecycle_policies' to be a list")
        pulumi.set(__self__, "lifecycle_policies", lifecycle_policies)
        if provisioned_throughput_in_mibps and not isinstance(provisioned_throughput_in_mibps, float):
            raise TypeError("Expected argument 'provisioned_throughput_in_mibps' to be a float")
        pulumi.set(__self__, "provisioned_throughput_in_mibps", provisioned_throughput_in_mibps)
        if replication_configuration and not isinstance(replication_configuration, dict):
            raise TypeError("Expected argument 'replication_configuration' to be a dict")
        pulumi.set(__self__, "replication_configuration", replication_configuration)
        if throughput_mode and not isinstance(throughput_mode, str):
            raise TypeError("Expected argument 'throughput_mode' to be a str")
        pulumi.set(__self__, "throughput_mode", throughput_mode)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the EFS file system.

        Example: `arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-0123456789abcdef8`
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="backupPolicy")
    def backup_policy(self) -> Optional['outputs.FileSystemBackupPolicy']:
        """
        Use the ``BackupPolicy`` to turn automatic backups on or off for the file system.
        """
        return pulumi.get(self, "backup_policy")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[str]:
        """
        The ID of the EFS file system. For example: `fs-abcdef0123456789a`
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="fileSystemPolicy")
    def file_system_policy(self) -> Optional[Any]:
        """
        The ``FileSystemPolicy`` for the EFS file system. A file system policy is an IAM resource policy used to control NFS access to an EFS file system. For more information, see [Using to control NFS access to Amazon EFS](https://docs.aws.amazon.com/efs/latest/ug/iam-access-control-nfs-efs.html) in the *Amazon EFS User Guide*.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::EFS::FileSystem` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "file_system_policy")

    @property
    @pulumi.getter(name="fileSystemProtection")
    def file_system_protection(self) -> Optional['outputs.FileSystemProtection']:
        """
        Describes the protection on the file system.
        """
        return pulumi.get(self, "file_system_protection")

    @property
    @pulumi.getter(name="fileSystemTags")
    def file_system_tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Use to create one or more tags associated with the file system. Each tag is a user-defined key-value pair. Name your file system on creation by including a ``"Key":"Name","Value":"{value}"`` key-value pair. Each key must be unique. For more information, see [Tagging resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *General Reference Guide*.
        """
        return pulumi.get(self, "file_system_tags")

    @property
    @pulumi.getter(name="lifecyclePolicies")
    def lifecycle_policies(self) -> Optional[Sequence['outputs.FileSystemLifecyclePolicy']]:
        """
        An array of ``LifecyclePolicy`` objects that define the file system's ``LifecycleConfiguration`` object. A ``LifecycleConfiguration`` object informs Lifecycle management of the following:
          +  When to move files in the file system from primary storage to IA storage.
          +  When to move files in the file system from primary storage or IA storage to Archive storage.
          +  When to move files that are in IA or Archive storage to primary storage.
          
           EFS requires that each ``LifecyclePolicy`` object have only a single transition. This means that in a request body, ``LifecyclePolicies`` needs to be structured as an array of ``LifecyclePolicy`` objects, one object for each transition, ``TransitionToIA``, ``TransitionToArchive`` ``TransitionToPrimaryStorageClass``. See the example requests in the following section for more information.
        """
        return pulumi.get(self, "lifecycle_policies")

    @property
    @pulumi.getter(name="provisionedThroughputInMibps")
    def provisioned_throughput_in_mibps(self) -> Optional[float]:
        """
        The throughput, measured in mebibytes per second (MiBps), that you want to provision for a file system that you're creating. Required if ``ThroughputMode`` is set to ``provisioned``. Valid values are 1-3414 MiBps, with the upper limit depending on Region. To increase this limit, contact SUP. For more information, see [Amazon EFS quotas that you can increase](https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits) in the *Amazon EFS User Guide*.
        """
        return pulumi.get(self, "provisioned_throughput_in_mibps")

    @property
    @pulumi.getter(name="replicationConfiguration")
    def replication_configuration(self) -> Optional['outputs.FileSystemReplicationConfiguration']:
        """
        Describes the replication configuration for a specific file system.
        """
        return pulumi.get(self, "replication_configuration")

    @property
    @pulumi.getter(name="throughputMode")
    def throughput_mode(self) -> Optional[str]:
        """
        Specifies the throughput mode for the file system. The mode can be ``bursting``, ``provisioned``, or ``elastic``. If you set ``ThroughputMode`` to ``provisioned``, you must also set a value for ``ProvisionedThroughputInMibps``. After you create the file system, you can decrease your file system's Provisioned throughput or change between the throughput modes, with certain time restrictions. For more information, see [Specifying throughput with provisioned mode](https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput) in the *Amazon EFS User Guide*. 
         Default is ``bursting``.
        """
        return pulumi.get(self, "throughput_mode")


class AwaitableGetFileSystemResult(GetFileSystemResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFileSystemResult(
            arn=self.arn,
            backup_policy=self.backup_policy,
            file_system_id=self.file_system_id,
            file_system_policy=self.file_system_policy,
            file_system_protection=self.file_system_protection,
            file_system_tags=self.file_system_tags,
            lifecycle_policies=self.lifecycle_policies,
            provisioned_throughput_in_mibps=self.provisioned_throughput_in_mibps,
            replication_configuration=self.replication_configuration,
            throughput_mode=self.throughput_mode)


def get_file_system(file_system_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFileSystemResult:
    """
    The ``AWS::EFS::FileSystem`` resource creates a new, empty file system in EFSlong (EFS). You must create a mount target ([AWS::EFS::MountTarget](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html)) to mount your EFS file system on an EC2 or other AWS cloud compute resource.


    :param str file_system_id: The ID of the EFS file system. For example: `fs-abcdef0123456789a`
    """
    __args__ = dict()
    __args__['fileSystemId'] = file_system_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:efs:getFileSystem', __args__, opts=opts, typ=GetFileSystemResult).value

    return AwaitableGetFileSystemResult(
        arn=pulumi.get(__ret__, 'arn'),
        backup_policy=pulumi.get(__ret__, 'backup_policy'),
        file_system_id=pulumi.get(__ret__, 'file_system_id'),
        file_system_policy=pulumi.get(__ret__, 'file_system_policy'),
        file_system_protection=pulumi.get(__ret__, 'file_system_protection'),
        file_system_tags=pulumi.get(__ret__, 'file_system_tags'),
        lifecycle_policies=pulumi.get(__ret__, 'lifecycle_policies'),
        provisioned_throughput_in_mibps=pulumi.get(__ret__, 'provisioned_throughput_in_mibps'),
        replication_configuration=pulumi.get(__ret__, 'replication_configuration'),
        throughput_mode=pulumi.get(__ret__, 'throughput_mode'))
def get_file_system_output(file_system_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFileSystemResult]:
    """
    The ``AWS::EFS::FileSystem`` resource creates a new, empty file system in EFSlong (EFS). You must create a mount target ([AWS::EFS::MountTarget](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html)) to mount your EFS file system on an EC2 or other AWS cloud compute resource.


    :param str file_system_id: The ID of the EFS file system. For example: `fs-abcdef0123456789a`
    """
    __args__ = dict()
    __args__['fileSystemId'] = file_system_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:efs:getFileSystem', __args__, opts=opts, typ=GetFileSystemResult)
    return __ret__.apply(lambda __response__: GetFileSystemResult(
        arn=pulumi.get(__response__, 'arn'),
        backup_policy=pulumi.get(__response__, 'backup_policy'),
        file_system_id=pulumi.get(__response__, 'file_system_id'),
        file_system_policy=pulumi.get(__response__, 'file_system_policy'),
        file_system_protection=pulumi.get(__response__, 'file_system_protection'),
        file_system_tags=pulumi.get(__response__, 'file_system_tags'),
        lifecycle_policies=pulumi.get(__response__, 'lifecycle_policies'),
        provisioned_throughput_in_mibps=pulumi.get(__response__, 'provisioned_throughput_in_mibps'),
        replication_configuration=pulumi.get(__response__, 'replication_configuration'),
        throughput_mode=pulumi.get(__response__, 'throughput_mode')))
