# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetCapacityProviderResult',
    'AwaitableGetCapacityProviderResult',
    'get_capacity_provider',
    'get_capacity_provider_output',
]

@pulumi.output_type
class GetCapacityProviderResult:
    def __init__(__self__, auto_scaling_group_provider=None, tags=None):
        if auto_scaling_group_provider and not isinstance(auto_scaling_group_provider, dict):
            raise TypeError("Expected argument 'auto_scaling_group_provider' to be a dict")
        pulumi.set(__self__, "auto_scaling_group_provider", auto_scaling_group_provider)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="autoScalingGroupProvider")
    def auto_scaling_group_provider(self) -> Optional['outputs.CapacityProviderAutoScalingGroupProvider']:
        """
        The Auto Scaling group settings for the capacity provider.
        """
        return pulumi.get(self, "auto_scaling_group_provider")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The metadata that you apply to the capacity provider to help you categorize and organize it. Each tag consists of a key and an optional value. You define both.

        The following basic restrictions apply to tags:

        - Maximum number of tags per resource - 50
        - For each resource, each tag key must be unique, and each tag key can have only one value.
        - Maximum key length - 128 Unicode characters in UTF-8
        - Maximum value length - 256 Unicode characters in UTF-8
        - If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
        - Tag keys and values are case-sensitive.
        - Do not use `aws:` , `AWS:` , or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
        """
        return pulumi.get(self, "tags")


class AwaitableGetCapacityProviderResult(GetCapacityProviderResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCapacityProviderResult(
            auto_scaling_group_provider=self.auto_scaling_group_provider,
            tags=self.tags)


def get_capacity_provider(name: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCapacityProviderResult:
    """
    Resource Type definition for AWS::ECS::CapacityProvider.


    :param str name: The name of the capacity provider. If a name is specified, it cannot start with `aws` , `ecs` , or `fargate` . If no name is specified, a default name in the `CFNStackName-CFNResourceName-RandomString` format is used.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ecs:getCapacityProvider', __args__, opts=opts, typ=GetCapacityProviderResult).value

    return AwaitableGetCapacityProviderResult(
        auto_scaling_group_provider=pulumi.get(__ret__, 'auto_scaling_group_provider'),
        tags=pulumi.get(__ret__, 'tags'))
def get_capacity_provider_output(name: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCapacityProviderResult]:
    """
    Resource Type definition for AWS::ECS::CapacityProvider.


    :param str name: The name of the capacity provider. If a name is specified, it cannot start with `aws` , `ecs` , or `fargate` . If no name is specified, a default name in the `CFNStackName-CFNResourceName-RandomString` format is used.
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ecs:getCapacityProvider', __args__, opts=opts, typ=GetCapacityProviderResult)
    return __ret__.apply(lambda __response__: GetCapacityProviderResult(
        auto_scaling_group_provider=pulumi.get(__response__, 'auto_scaling_group_provider'),
        tags=pulumi.get(__response__, 'tags')))
