# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ReplicationConfigurationReplicationDestinationArgs',
    'ReplicationConfigurationReplicationDestinationArgsDict',
    'ReplicationConfigurationReplicationRuleArgs',
    'ReplicationConfigurationReplicationRuleArgsDict',
    'ReplicationConfigurationRepositoryFilterArgs',
    'ReplicationConfigurationRepositoryFilterArgsDict',
    'ReplicationConfigurationArgs',
    'ReplicationConfigurationArgsDict',
    'RepositoryCreationTemplateEncryptionConfigurationArgs',
    'RepositoryCreationTemplateEncryptionConfigurationArgsDict',
    'RepositoryCreationTemplateTagArgs',
    'RepositoryCreationTemplateTagArgsDict',
    'RepositoryEncryptionConfigurationArgs',
    'RepositoryEncryptionConfigurationArgsDict',
    'RepositoryImageScanningConfigurationArgs',
    'RepositoryImageScanningConfigurationArgsDict',
    'RepositoryLifecyclePolicyArgs',
    'RepositoryLifecyclePolicyArgsDict',
]

MYPY = False

if not MYPY:
    class ReplicationConfigurationReplicationDestinationArgsDict(TypedDict):
        """
        An array of objects representing the details of a replication destination.
        """
        region: pulumi.Input[str]
        """
        The Region to replicate to.
        """
        registry_id: pulumi.Input[str]
        """
        The AWS account ID of the Amazon ECR private registry to replicate to. When configuring cross-Region replication within your own registry, specify your own account ID.
        """
elif False:
    ReplicationConfigurationReplicationDestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationConfigurationReplicationDestinationArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[str],
                 registry_id: pulumi.Input[str]):
        """
        An array of objects representing the details of a replication destination.
        :param pulumi.Input[str] region: The Region to replicate to.
        :param pulumi.Input[str] registry_id: The AWS account ID of the Amazon ECR private registry to replicate to. When configuring cross-Region replication within your own registry, specify your own account ID.
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "registry_id", registry_id)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        The Region to replicate to.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> pulumi.Input[str]:
        """
        The AWS account ID of the Amazon ECR private registry to replicate to. When configuring cross-Region replication within your own registry, specify your own account ID.
        """
        return pulumi.get(self, "registry_id")

    @registry_id.setter
    def registry_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "registry_id", value)


if not MYPY:
    class ReplicationConfigurationReplicationRuleArgsDict(TypedDict):
        """
        An array of objects representing the details of a replication destination.
        """
        destinations: pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationDestinationArgsDict']]]
        """
        An array of objects representing the details of a replication destination.
        """
        repository_filters: NotRequired[pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationRepositoryFilterArgsDict']]]]
        """
        An array of objects representing the details of a repository filter.
        """
elif False:
    ReplicationConfigurationReplicationRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationConfigurationReplicationRuleArgs:
    def __init__(__self__, *,
                 destinations: pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationDestinationArgs']]],
                 repository_filters: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationRepositoryFilterArgs']]]] = None):
        """
        An array of objects representing the details of a replication destination.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationDestinationArgs']]] destinations: An array of objects representing the details of a replication destination.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationRepositoryFilterArgs']]] repository_filters: An array of objects representing the details of a repository filter.
        """
        pulumi.set(__self__, "destinations", destinations)
        if repository_filters is not None:
            pulumi.set(__self__, "repository_filters", repository_filters)

    @property
    @pulumi.getter
    def destinations(self) -> pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationDestinationArgs']]]:
        """
        An array of objects representing the details of a replication destination.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationDestinationArgs']]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter(name="repositoryFilters")
    def repository_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationRepositoryFilterArgs']]]]:
        """
        An array of objects representing the details of a repository filter.
        """
        return pulumi.get(self, "repository_filters")

    @repository_filters.setter
    def repository_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationRepositoryFilterArgs']]]]):
        pulumi.set(self, "repository_filters", value)


if not MYPY:
    class ReplicationConfigurationRepositoryFilterArgsDict(TypedDict):
        """
        An array of objects representing the details of a repository filter.
        """
        filter: pulumi.Input[str]
        """
        The repository filter details. When the `PREFIX_MATCH` filter type is specified, this value is required and should be the repository name prefix to configure replication for.
        """
        filter_type: pulumi.Input['ReplicationConfigurationFilterType']
        """
        The repository filter type. The only supported value is `PREFIX_MATCH` , which is a repository name prefix specified with the `filter` parameter.
        """
elif False:
    ReplicationConfigurationRepositoryFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationConfigurationRepositoryFilterArgs:
    def __init__(__self__, *,
                 filter: pulumi.Input[str],
                 filter_type: pulumi.Input['ReplicationConfigurationFilterType']):
        """
        An array of objects representing the details of a repository filter.
        :param pulumi.Input[str] filter: The repository filter details. When the `PREFIX_MATCH` filter type is specified, this value is required and should be the repository name prefix to configure replication for.
        :param pulumi.Input['ReplicationConfigurationFilterType'] filter_type: The repository filter type. The only supported value is `PREFIX_MATCH` , which is a repository name prefix specified with the `filter` parameter.
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "filter_type", filter_type)

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Input[str]:
        """
        The repository filter details. When the `PREFIX_MATCH` filter type is specified, this value is required and should be the repository name prefix to configure replication for.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[str]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> pulumi.Input['ReplicationConfigurationFilterType']:
        """
        The repository filter type. The only supported value is `PREFIX_MATCH` , which is a repository name prefix specified with the `filter` parameter.
        """
        return pulumi.get(self, "filter_type")

    @filter_type.setter
    def filter_type(self, value: pulumi.Input['ReplicationConfigurationFilterType']):
        pulumi.set(self, "filter_type", value)


if not MYPY:
    class ReplicationConfigurationArgsDict(TypedDict):
        """
        An object representing the replication configuration for a registry.
        """
        rules: pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationRuleArgsDict']]]
        """
        An array of objects representing the replication rules for a replication configuration. A replication configuration may contain a maximum of 10 rules.
        """
elif False:
    ReplicationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationConfigurationArgs:
    def __init__(__self__, *,
                 rules: pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationRuleArgs']]]):
        """
        An object representing the replication configuration for a registry.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationRuleArgs']]] rules: An array of objects representing the replication rules for a replication configuration. A replication configuration may contain a maximum of 10 rules.
        """
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationRuleArgs']]]:
        """
        An array of objects representing the replication rules for a replication configuration. A replication configuration may contain a maximum of 10 rules.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['ReplicationConfigurationReplicationRuleArgs']]]):
        pulumi.set(self, "rules", value)


if not MYPY:
    class RepositoryCreationTemplateEncryptionConfigurationArgsDict(TypedDict):
        """
        The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest. By default, when no encryption configuration is set or the AES256 encryption type is used, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts your data at rest using an AES-256 encryption algorithm. This does not require any action on your part.

        For more information, see https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html
        """
        encryption_type: pulumi.Input['RepositoryCreationTemplateEncryptionType']
        """
        The encryption type to use.

        If you use the `KMS` encryption type, the contents of the repository will be encrypted using server-side encryption with AWS Key Management Service key stored in AWS KMS . When you use AWS KMS to encrypt your data, you can either use the default AWS managed AWS KMS key for Amazon ECR, or specify your own AWS KMS key, which you already created.

        If you use the `KMS_DSSE` encryption type, the contents of the repository will be encrypted with two layers of encryption using server-side encryption with the AWS KMS Management Service key stored in AWS KMS . Similar to the `KMS` encryption type, you can either use the default AWS managed AWS KMS key for Amazon ECR, or specify your own AWS KMS key, which you've already created.

        If you use the `AES256` encryption type, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts the images in the repository using an AES256 encryption algorithm.

        For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide* .
        """
        kms_key: NotRequired[pulumi.Input[str]]
        """
        If you use the `KMS` encryption type, specify the AWS KMS key to use for encryption. The alias, key ID, or full ARN of the AWS KMS key can be specified. The key must exist in the same Region as the repository. If no key is specified, the default AWS managed AWS KMS key for Amazon ECR will be used.
        """
elif False:
    RepositoryCreationTemplateEncryptionConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryCreationTemplateEncryptionConfigurationArgs:
    def __init__(__self__, *,
                 encryption_type: pulumi.Input['RepositoryCreationTemplateEncryptionType'],
                 kms_key: Optional[pulumi.Input[str]] = None):
        """
        The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest. By default, when no encryption configuration is set or the AES256 encryption type is used, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts your data at rest using an AES-256 encryption algorithm. This does not require any action on your part.

        For more information, see https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html
        :param pulumi.Input['RepositoryCreationTemplateEncryptionType'] encryption_type: The encryption type to use.
               
               If you use the `KMS` encryption type, the contents of the repository will be encrypted using server-side encryption with AWS Key Management Service key stored in AWS KMS . When you use AWS KMS to encrypt your data, you can either use the default AWS managed AWS KMS key for Amazon ECR, or specify your own AWS KMS key, which you already created.
               
               If you use the `KMS_DSSE` encryption type, the contents of the repository will be encrypted with two layers of encryption using server-side encryption with the AWS KMS Management Service key stored in AWS KMS . Similar to the `KMS` encryption type, you can either use the default AWS managed AWS KMS key for Amazon ECR, or specify your own AWS KMS key, which you've already created.
               
               If you use the `AES256` encryption type, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts the images in the repository using an AES256 encryption algorithm.
               
               For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide* .
        :param pulumi.Input[str] kms_key: If you use the `KMS` encryption type, specify the AWS KMS key to use for encryption. The alias, key ID, or full ARN of the AWS KMS key can be specified. The key must exist in the same Region as the repository. If no key is specified, the default AWS managed AWS KMS key for Amazon ECR will be used.
        """
        pulumi.set(__self__, "encryption_type", encryption_type)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> pulumi.Input['RepositoryCreationTemplateEncryptionType']:
        """
        The encryption type to use.

        If you use the `KMS` encryption type, the contents of the repository will be encrypted using server-side encryption with AWS Key Management Service key stored in AWS KMS . When you use AWS KMS to encrypt your data, you can either use the default AWS managed AWS KMS key for Amazon ECR, or specify your own AWS KMS key, which you already created.

        If you use the `KMS_DSSE` encryption type, the contents of the repository will be encrypted with two layers of encryption using server-side encryption with the AWS KMS Management Service key stored in AWS KMS . Similar to the `KMS` encryption type, you can either use the default AWS managed AWS KMS key for Amazon ECR, or specify your own AWS KMS key, which you've already created.

        If you use the `AES256` encryption type, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts the images in the repository using an AES256 encryption algorithm.

        For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide* .
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: pulumi.Input['RepositoryCreationTemplateEncryptionType']):
        pulumi.set(self, "encryption_type", value)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[str]]:
        """
        If you use the `KMS` encryption type, specify the AWS KMS key to use for encryption. The alias, key ID, or full ARN of the AWS KMS key can be specified. The key must exist in the same Region as the repository. If no key is specified, the default AWS managed AWS KMS key for Amazon ECR will be used.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key", value)


if not MYPY:
    class RepositoryCreationTemplateTagArgsDict(TypedDict):
        """
        An array of key-value pairs to apply to this resource.
        """
        key: pulumi.Input[str]
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        value: pulumi.Input[str]
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
elif False:
    RepositoryCreationTemplateTagArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryCreationTemplateTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        An array of key-value pairs to apply to this resource.
        :param pulumi.Input[str] key: The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        :param pulumi.Input[str] value: The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key name of the tag. You can specify a value that is 1 to 128 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The value for the tag. You can specify a value that is 0 to 256 Unicode characters in length and cannot be prefixed with aws:. You can use any of the following characters: the set of Unicode letters, digits, whitespace, _, ., /, =, +, and -.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class RepositoryEncryptionConfigurationArgsDict(TypedDict):
        """
        The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest.
         By default, when no encryption configuration is set or the ``AES256`` encryption type is used, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts your data at rest using an AES-256 encryption algorithm. This does not require any action on your part.
         For more control over the encryption of the contents of your repository, you can use server-side encryption with KMSlong key stored in KMSlong (KMS) to encrypt your images. For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide*.
        """
        encryption_type: pulumi.Input['RepositoryEncryptionType']
        """
        The encryption type to use.

        If you use the `KMS` encryption type, the contents of the repository will be encrypted using server-side encryption with AWS Key Management Service key stored in AWS KMS . When you use AWS KMS to encrypt your data, you can either use the default AWS managed AWS KMS key for Amazon ECR, or specify your own AWS KMS key, which you already created.

        If you use the `KMS_DSSE` encryption type, the contents of the repository will be encrypted with two layers of encryption using server-side encryption with the AWS KMS Management Service key stored in AWS KMS . Similar to the `KMS` encryption type, you can either use the default AWS managed AWS KMS key for Amazon ECR, or specify your own AWS KMS key, which you've already created.

        If you use the `AES256` encryption type, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts the images in the repository using an AES256 encryption algorithm.

        For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide* .
        """
        kms_key: NotRequired[pulumi.Input[str]]
        """
        If you use the ``KMS`` encryption type, specify the KMS key to use for encryption. The alias, key ID, or full ARN of the KMS key can be specified. The key must exist in the same Region as the repository. If no key is specified, the default AWS managed KMS key for Amazon ECR will be used.
        """
elif False:
    RepositoryEncryptionConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryEncryptionConfigurationArgs:
    def __init__(__self__, *,
                 encryption_type: pulumi.Input['RepositoryEncryptionType'],
                 kms_key: Optional[pulumi.Input[str]] = None):
        """
        The encryption configuration for the repository. This determines how the contents of your repository are encrypted at rest.
         By default, when no encryption configuration is set or the ``AES256`` encryption type is used, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts your data at rest using an AES-256 encryption algorithm. This does not require any action on your part.
         For more control over the encryption of the contents of your repository, you can use server-side encryption with KMSlong key stored in KMSlong (KMS) to encrypt your images. For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide*.
        :param pulumi.Input['RepositoryEncryptionType'] encryption_type: The encryption type to use.
               
               If you use the `KMS` encryption type, the contents of the repository will be encrypted using server-side encryption with AWS Key Management Service key stored in AWS KMS . When you use AWS KMS to encrypt your data, you can either use the default AWS managed AWS KMS key for Amazon ECR, or specify your own AWS KMS key, which you already created.
               
               If you use the `KMS_DSSE` encryption type, the contents of the repository will be encrypted with two layers of encryption using server-side encryption with the AWS KMS Management Service key stored in AWS KMS . Similar to the `KMS` encryption type, you can either use the default AWS managed AWS KMS key for Amazon ECR, or specify your own AWS KMS key, which you've already created.
               
               If you use the `AES256` encryption type, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts the images in the repository using an AES256 encryption algorithm.
               
               For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide* .
        :param pulumi.Input[str] kms_key: If you use the ``KMS`` encryption type, specify the KMS key to use for encryption. The alias, key ID, or full ARN of the KMS key can be specified. The key must exist in the same Region as the repository. If no key is specified, the default AWS managed KMS key for Amazon ECR will be used.
        """
        pulumi.set(__self__, "encryption_type", encryption_type)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> pulumi.Input['RepositoryEncryptionType']:
        """
        The encryption type to use.

        If you use the `KMS` encryption type, the contents of the repository will be encrypted using server-side encryption with AWS Key Management Service key stored in AWS KMS . When you use AWS KMS to encrypt your data, you can either use the default AWS managed AWS KMS key for Amazon ECR, or specify your own AWS KMS key, which you already created.

        If you use the `KMS_DSSE` encryption type, the contents of the repository will be encrypted with two layers of encryption using server-side encryption with the AWS KMS Management Service key stored in AWS KMS . Similar to the `KMS` encryption type, you can either use the default AWS managed AWS KMS key for Amazon ECR, or specify your own AWS KMS key, which you've already created.

        If you use the `AES256` encryption type, Amazon ECR uses server-side encryption with Amazon S3-managed encryption keys which encrypts the images in the repository using an AES256 encryption algorithm.

        For more information, see [Amazon ECR encryption at rest](https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html) in the *Amazon Elastic Container Registry User Guide* .
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: pulumi.Input['RepositoryEncryptionType']):
        pulumi.set(self, "encryption_type", value)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[str]]:
        """
        If you use the ``KMS`` encryption type, specify the KMS key to use for encryption. The alias, key ID, or full ARN of the KMS key can be specified. The key must exist in the same Region as the repository. If no key is specified, the default AWS managed KMS key for Amazon ECR will be used.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key", value)


if not MYPY:
    class RepositoryImageScanningConfigurationArgsDict(TypedDict):
        """
        The image scanning configuration for a repository.
        """
        scan_on_push: NotRequired[pulumi.Input[bool]]
        """
        The setting that determines whether images are scanned after being pushed to a repository. If set to ``true``, images will be scanned after being pushed. If this parameter is not specified, it will default to ``false`` and images will not be scanned unless a scan is manually started.
        """
elif False:
    RepositoryImageScanningConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryImageScanningConfigurationArgs:
    def __init__(__self__, *,
                 scan_on_push: Optional[pulumi.Input[bool]] = None):
        """
        The image scanning configuration for a repository.
        :param pulumi.Input[bool] scan_on_push: The setting that determines whether images are scanned after being pushed to a repository. If set to ``true``, images will be scanned after being pushed. If this parameter is not specified, it will default to ``false`` and images will not be scanned unless a scan is manually started.
        """
        if scan_on_push is not None:
            pulumi.set(__self__, "scan_on_push", scan_on_push)

    @property
    @pulumi.getter(name="scanOnPush")
    def scan_on_push(self) -> Optional[pulumi.Input[bool]]:
        """
        The setting that determines whether images are scanned after being pushed to a repository. If set to ``true``, images will be scanned after being pushed. If this parameter is not specified, it will default to ``false`` and images will not be scanned unless a scan is manually started.
        """
        return pulumi.get(self, "scan_on_push")

    @scan_on_push.setter
    def scan_on_push(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "scan_on_push", value)


if not MYPY:
    class RepositoryLifecyclePolicyArgsDict(TypedDict):
        """
        The ``LifecyclePolicy`` property type specifies a lifecycle policy. For information about lifecycle policy syntax, see [Lifecycle policy template](https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html) in the *Amazon ECR User Guide*.
        """
        lifecycle_policy_text: NotRequired[pulumi.Input[str]]
        """
        The JSON repository policy text to apply to the repository.
        """
        registry_id: NotRequired[pulumi.Input[str]]
        """
        The AWS account ID associated with the registry that contains the repository. If you do
         not specify a registry, the default registry is assumed.
        """
elif False:
    RepositoryLifecyclePolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RepositoryLifecyclePolicyArgs:
    def __init__(__self__, *,
                 lifecycle_policy_text: Optional[pulumi.Input[str]] = None,
                 registry_id: Optional[pulumi.Input[str]] = None):
        """
        The ``LifecyclePolicy`` property type specifies a lifecycle policy. For information about lifecycle policy syntax, see [Lifecycle policy template](https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html) in the *Amazon ECR User Guide*.
        :param pulumi.Input[str] lifecycle_policy_text: The JSON repository policy text to apply to the repository.
        :param pulumi.Input[str] registry_id: The AWS account ID associated with the registry that contains the repository. If you do
                not specify a registry, the default registry is assumed.
        """
        if lifecycle_policy_text is not None:
            pulumi.set(__self__, "lifecycle_policy_text", lifecycle_policy_text)
        if registry_id is not None:
            pulumi.set(__self__, "registry_id", registry_id)

    @property
    @pulumi.getter(name="lifecyclePolicyText")
    def lifecycle_policy_text(self) -> Optional[pulumi.Input[str]]:
        """
        The JSON repository policy text to apply to the repository.
        """
        return pulumi.get(self, "lifecycle_policy_text")

    @lifecycle_policy_text.setter
    def lifecycle_policy_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_policy_text", value)

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AWS account ID associated with the registry that contains the repository. If you do
         not specify a registry, the default registry is assumed.
        """
        return pulumi.get(self, "registry_id")

    @registry_id.setter
    def registry_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry_id", value)


