# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['VpnConnectionArgs', 'VpnConnection']

@pulumi.input_type
class VpnConnectionArgs:
    def __init__(__self__, *,
                 customer_gateway_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 enable_acceleration: Optional[pulumi.Input[bool]] = None,
                 local_ipv4_network_cidr: Optional[pulumi.Input[str]] = None,
                 local_ipv6_network_cidr: Optional[pulumi.Input[str]] = None,
                 outside_ip_address_type: Optional[pulumi.Input[str]] = None,
                 remote_ipv4_network_cidr: Optional[pulumi.Input[str]] = None,
                 remote_ipv6_network_cidr: Optional[pulumi.Input[str]] = None,
                 static_routes_only: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 transit_gateway_id: Optional[pulumi.Input[str]] = None,
                 transport_transit_gateway_attachment_id: Optional[pulumi.Input[str]] = None,
                 tunnel_inside_ip_version: Optional[pulumi.Input[str]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[str]] = None,
                 vpn_tunnel_options_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['VpnConnectionVpnTunnelOptionsSpecificationArgs']]]] = None):
        """
        The set of arguments for constructing a VpnConnection resource.
        :param pulumi.Input[str] customer_gateway_id: The ID of the customer gateway at your end of the VPN connection.
        :param pulumi.Input[str] type: The type of VPN connection.
        :param pulumi.Input[bool] enable_acceleration: Indicate whether to enable acceleration for the VPN connection.
                Default: ``false``
        :param pulumi.Input[str] local_ipv4_network_cidr: The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
               
               Default: `0.0.0.0/0`
        :param pulumi.Input[str] local_ipv6_network_cidr: The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
               
               Default: `::/0`
        :param pulumi.Input[str] outside_ip_address_type: The type of IPv4 address assigned to the outside interface of the customer gateway device.
               
               Valid values: `PrivateIpv4` | `PublicIpv4`
               
               Default: `PublicIpv4`
        :param pulumi.Input[str] remote_ipv4_network_cidr: The IPv4 CIDR on the AWS side of the VPN connection.
               
               Default: `0.0.0.0/0`
        :param pulumi.Input[str] remote_ipv6_network_cidr: The IPv6 CIDR on the AWS side of the VPN connection.
               
               Default: `::/0`
        :param pulumi.Input[bool] static_routes_only: Indicates whether the VPN connection uses static routes only. Static routes must be used for devices that don't support BGP.
                If you are creating a VPN connection for a device that does not support Border Gateway Protocol (BGP), you must specify ``true``.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Any tags assigned to the VPN connection.
        :param pulumi.Input[str] transit_gateway_id: The ID of the transit gateway associated with the VPN connection.
                You must specify either ``TransitGatewayId`` or ``VpnGatewayId``, but not both.
        :param pulumi.Input[str] transport_transit_gateway_attachment_id: The transit gateway attachment ID to use for the VPN tunnel.
               
               Required if `OutsideIpAddressType` is set to `PrivateIpv4` .
        :param pulumi.Input[str] tunnel_inside_ip_version: Indicate whether the VPN tunnels process IPv4 or IPv6 traffic.
               
               Default: `ipv4`
        :param pulumi.Input[str] vpn_gateway_id: The ID of the virtual private gateway at the AWS side of the VPN connection.
                You must specify either ``TransitGatewayId`` or ``VpnGatewayId``, but not both.
        :param pulumi.Input[Sequence[pulumi.Input['VpnConnectionVpnTunnelOptionsSpecificationArgs']]] vpn_tunnel_options_specifications: The tunnel options for the VPN connection.
        """
        pulumi.set(__self__, "customer_gateway_id", customer_gateway_id)
        pulumi.set(__self__, "type", type)
        if enable_acceleration is not None:
            pulumi.set(__self__, "enable_acceleration", enable_acceleration)
        if local_ipv4_network_cidr is not None:
            pulumi.set(__self__, "local_ipv4_network_cidr", local_ipv4_network_cidr)
        if local_ipv6_network_cidr is not None:
            pulumi.set(__self__, "local_ipv6_network_cidr", local_ipv6_network_cidr)
        if outside_ip_address_type is not None:
            pulumi.set(__self__, "outside_ip_address_type", outside_ip_address_type)
        if remote_ipv4_network_cidr is not None:
            pulumi.set(__self__, "remote_ipv4_network_cidr", remote_ipv4_network_cidr)
        if remote_ipv6_network_cidr is not None:
            pulumi.set(__self__, "remote_ipv6_network_cidr", remote_ipv6_network_cidr)
        if static_routes_only is not None:
            pulumi.set(__self__, "static_routes_only", static_routes_only)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transit_gateway_id is not None:
            pulumi.set(__self__, "transit_gateway_id", transit_gateway_id)
        if transport_transit_gateway_attachment_id is not None:
            pulumi.set(__self__, "transport_transit_gateway_attachment_id", transport_transit_gateway_attachment_id)
        if tunnel_inside_ip_version is not None:
            pulumi.set(__self__, "tunnel_inside_ip_version", tunnel_inside_ip_version)
        if vpn_gateway_id is not None:
            pulumi.set(__self__, "vpn_gateway_id", vpn_gateway_id)
        if vpn_tunnel_options_specifications is not None:
            pulumi.set(__self__, "vpn_tunnel_options_specifications", vpn_tunnel_options_specifications)

    @property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> pulumi.Input[str]:
        """
        The ID of the customer gateway at your end of the VPN connection.
        """
        return pulumi.get(self, "customer_gateway_id")

    @customer_gateway_id.setter
    def customer_gateway_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "customer_gateway_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of VPN connection.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="enableAcceleration")
    def enable_acceleration(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicate whether to enable acceleration for the VPN connection.
         Default: ``false``
        """
        return pulumi.get(self, "enable_acceleration")

    @enable_acceleration.setter
    def enable_acceleration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_acceleration", value)

    @property
    @pulumi.getter(name="localIpv4NetworkCidr")
    def local_ipv4_network_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.

        Default: `0.0.0.0/0`
        """
        return pulumi.get(self, "local_ipv4_network_cidr")

    @local_ipv4_network_cidr.setter
    def local_ipv4_network_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_ipv4_network_cidr", value)

    @property
    @pulumi.getter(name="localIpv6NetworkCidr")
    def local_ipv6_network_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.

        Default: `::/0`
        """
        return pulumi.get(self, "local_ipv6_network_cidr")

    @local_ipv6_network_cidr.setter
    def local_ipv6_network_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_ipv6_network_cidr", value)

    @property
    @pulumi.getter(name="outsideIpAddressType")
    def outside_ip_address_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of IPv4 address assigned to the outside interface of the customer gateway device.

        Valid values: `PrivateIpv4` | `PublicIpv4`

        Default: `PublicIpv4`
        """
        return pulumi.get(self, "outside_ip_address_type")

    @outside_ip_address_type.setter
    def outside_ip_address_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "outside_ip_address_type", value)

    @property
    @pulumi.getter(name="remoteIpv4NetworkCidr")
    def remote_ipv4_network_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 CIDR on the AWS side of the VPN connection.

        Default: `0.0.0.0/0`
        """
        return pulumi.get(self, "remote_ipv4_network_cidr")

    @remote_ipv4_network_cidr.setter
    def remote_ipv4_network_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_ipv4_network_cidr", value)

    @property
    @pulumi.getter(name="remoteIpv6NetworkCidr")
    def remote_ipv6_network_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv6 CIDR on the AWS side of the VPN connection.

        Default: `::/0`
        """
        return pulumi.get(self, "remote_ipv6_network_cidr")

    @remote_ipv6_network_cidr.setter
    def remote_ipv6_network_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_ipv6_network_cidr", value)

    @property
    @pulumi.getter(name="staticRoutesOnly")
    def static_routes_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the VPN connection uses static routes only. Static routes must be used for devices that don't support BGP.
         If you are creating a VPN connection for a device that does not support Border Gateway Protocol (BGP), you must specify ``true``.
        """
        return pulumi.get(self, "static_routes_only")

    @static_routes_only.setter
    def static_routes_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "static_routes_only", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Any tags assigned to the VPN connection.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="transitGatewayId")
    def transit_gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the transit gateway associated with the VPN connection.
         You must specify either ``TransitGatewayId`` or ``VpnGatewayId``, but not both.
        """
        return pulumi.get(self, "transit_gateway_id")

    @transit_gateway_id.setter
    def transit_gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_gateway_id", value)

    @property
    @pulumi.getter(name="transportTransitGatewayAttachmentId")
    def transport_transit_gateway_attachment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The transit gateway attachment ID to use for the VPN tunnel.

        Required if `OutsideIpAddressType` is set to `PrivateIpv4` .
        """
        return pulumi.get(self, "transport_transit_gateway_attachment_id")

    @transport_transit_gateway_attachment_id.setter
    def transport_transit_gateway_attachment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transport_transit_gateway_attachment_id", value)

    @property
    @pulumi.getter(name="tunnelInsideIpVersion")
    def tunnel_inside_ip_version(self) -> Optional[pulumi.Input[str]]:
        """
        Indicate whether the VPN tunnels process IPv4 or IPv6 traffic.

        Default: `ipv4`
        """
        return pulumi.get(self, "tunnel_inside_ip_version")

    @tunnel_inside_ip_version.setter
    def tunnel_inside_ip_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_inside_ip_version", value)

    @property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the virtual private gateway at the AWS side of the VPN connection.
         You must specify either ``TransitGatewayId`` or ``VpnGatewayId``, but not both.
        """
        return pulumi.get(self, "vpn_gateway_id")

    @vpn_gateway_id.setter
    def vpn_gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpn_gateway_id", value)

    @property
    @pulumi.getter(name="vpnTunnelOptionsSpecifications")
    def vpn_tunnel_options_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnConnectionVpnTunnelOptionsSpecificationArgs']]]]:
        """
        The tunnel options for the VPN connection.
        """
        return pulumi.get(self, "vpn_tunnel_options_specifications")

    @vpn_tunnel_options_specifications.setter
    def vpn_tunnel_options_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnConnectionVpnTunnelOptionsSpecificationArgs']]]]):
        pulumi.set(self, "vpn_tunnel_options_specifications", value)


class VpnConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer_gateway_id: Optional[pulumi.Input[str]] = None,
                 enable_acceleration: Optional[pulumi.Input[bool]] = None,
                 local_ipv4_network_cidr: Optional[pulumi.Input[str]] = None,
                 local_ipv6_network_cidr: Optional[pulumi.Input[str]] = None,
                 outside_ip_address_type: Optional[pulumi.Input[str]] = None,
                 remote_ipv4_network_cidr: Optional[pulumi.Input[str]] = None,
                 remote_ipv6_network_cidr: Optional[pulumi.Input[str]] = None,
                 static_routes_only: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 transit_gateway_id: Optional[pulumi.Input[str]] = None,
                 transport_transit_gateway_attachment_id: Optional[pulumi.Input[str]] = None,
                 tunnel_inside_ip_version: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[str]] = None,
                 vpn_tunnel_options_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnConnectionVpnTunnelOptionsSpecificationArgs', 'VpnConnectionVpnTunnelOptionsSpecificationArgsDict']]]]] = None,
                 __props__=None):
        """
        Specifies a VPN connection between a virtual private gateway and a VPN customer gateway or a transit gateway and a VPN customer gateway.
         To specify a VPN connection between a transit gateway and customer gateway, use the ``TransitGatewayId`` and ``CustomerGatewayId`` properties.
         To specify a VPN connection between a virtual private gateway and customer gateway, use the ``VpnGatewayId`` and ``CustomerGatewayId`` properties.
         For more information, see [](https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html) in the *User Guide*.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] customer_gateway_id: The ID of the customer gateway at your end of the VPN connection.
        :param pulumi.Input[bool] enable_acceleration: Indicate whether to enable acceleration for the VPN connection.
                Default: ``false``
        :param pulumi.Input[str] local_ipv4_network_cidr: The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
               
               Default: `0.0.0.0/0`
        :param pulumi.Input[str] local_ipv6_network_cidr: The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
               
               Default: `::/0`
        :param pulumi.Input[str] outside_ip_address_type: The type of IPv4 address assigned to the outside interface of the customer gateway device.
               
               Valid values: `PrivateIpv4` | `PublicIpv4`
               
               Default: `PublicIpv4`
        :param pulumi.Input[str] remote_ipv4_network_cidr: The IPv4 CIDR on the AWS side of the VPN connection.
               
               Default: `0.0.0.0/0`
        :param pulumi.Input[str] remote_ipv6_network_cidr: The IPv6 CIDR on the AWS side of the VPN connection.
               
               Default: `::/0`
        :param pulumi.Input[bool] static_routes_only: Indicates whether the VPN connection uses static routes only. Static routes must be used for devices that don't support BGP.
                If you are creating a VPN connection for a device that does not support Border Gateway Protocol (BGP), you must specify ``true``.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: Any tags assigned to the VPN connection.
        :param pulumi.Input[str] transit_gateway_id: The ID of the transit gateway associated with the VPN connection.
                You must specify either ``TransitGatewayId`` or ``VpnGatewayId``, but not both.
        :param pulumi.Input[str] transport_transit_gateway_attachment_id: The transit gateway attachment ID to use for the VPN tunnel.
               
               Required if `OutsideIpAddressType` is set to `PrivateIpv4` .
        :param pulumi.Input[str] tunnel_inside_ip_version: Indicate whether the VPN tunnels process IPv4 or IPv6 traffic.
               
               Default: `ipv4`
        :param pulumi.Input[str] type: The type of VPN connection.
        :param pulumi.Input[str] vpn_gateway_id: The ID of the virtual private gateway at the AWS side of the VPN connection.
                You must specify either ``TransitGatewayId`` or ``VpnGatewayId``, but not both.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnConnectionVpnTunnelOptionsSpecificationArgs', 'VpnConnectionVpnTunnelOptionsSpecificationArgsDict']]]] vpn_tunnel_options_specifications: The tunnel options for the VPN connection.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpnConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Specifies a VPN connection between a virtual private gateway and a VPN customer gateway or a transit gateway and a VPN customer gateway.
         To specify a VPN connection between a transit gateway and customer gateway, use the ``TransitGatewayId`` and ``CustomerGatewayId`` properties.
         To specify a VPN connection between a virtual private gateway and customer gateway, use the ``VpnGatewayId`` and ``CustomerGatewayId`` properties.
         For more information, see [](https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html) in the *User Guide*.

        :param str resource_name: The name of the resource.
        :param VpnConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpnConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer_gateway_id: Optional[pulumi.Input[str]] = None,
                 enable_acceleration: Optional[pulumi.Input[bool]] = None,
                 local_ipv4_network_cidr: Optional[pulumi.Input[str]] = None,
                 local_ipv6_network_cidr: Optional[pulumi.Input[str]] = None,
                 outside_ip_address_type: Optional[pulumi.Input[str]] = None,
                 remote_ipv4_network_cidr: Optional[pulumi.Input[str]] = None,
                 remote_ipv6_network_cidr: Optional[pulumi.Input[str]] = None,
                 static_routes_only: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 transit_gateway_id: Optional[pulumi.Input[str]] = None,
                 transport_transit_gateway_attachment_id: Optional[pulumi.Input[str]] = None,
                 tunnel_inside_ip_version: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vpn_gateway_id: Optional[pulumi.Input[str]] = None,
                 vpn_tunnel_options_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnConnectionVpnTunnelOptionsSpecificationArgs', 'VpnConnectionVpnTunnelOptionsSpecificationArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpnConnectionArgs.__new__(VpnConnectionArgs)

            if customer_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'customer_gateway_id'")
            __props__.__dict__["customer_gateway_id"] = customer_gateway_id
            __props__.__dict__["enable_acceleration"] = enable_acceleration
            __props__.__dict__["local_ipv4_network_cidr"] = local_ipv4_network_cidr
            __props__.__dict__["local_ipv6_network_cidr"] = local_ipv6_network_cidr
            __props__.__dict__["outside_ip_address_type"] = outside_ip_address_type
            __props__.__dict__["remote_ipv4_network_cidr"] = remote_ipv4_network_cidr
            __props__.__dict__["remote_ipv6_network_cidr"] = remote_ipv6_network_cidr
            __props__.__dict__["static_routes_only"] = static_routes_only
            __props__.__dict__["tags"] = tags
            __props__.__dict__["transit_gateway_id"] = transit_gateway_id
            __props__.__dict__["transport_transit_gateway_attachment_id"] = transport_transit_gateway_attachment_id
            __props__.__dict__["tunnel_inside_ip_version"] = tunnel_inside_ip_version
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["vpn_gateway_id"] = vpn_gateway_id
            __props__.__dict__["vpn_tunnel_options_specifications"] = vpn_tunnel_options_specifications
            __props__.__dict__["vpn_connection_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["customerGatewayId", "enableAcceleration", "localIpv4NetworkCidr", "localIpv6NetworkCidr", "outsideIpAddressType", "remoteIpv4NetworkCidr", "remoteIpv6NetworkCidr", "staticRoutesOnly", "transitGatewayId", "transportTransitGatewayAttachmentId", "tunnelInsideIpVersion", "type", "vpnGatewayId", "vpnTunnelOptionsSpecifications[*]"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(VpnConnection, __self__).__init__(
            'aws-native:ec2:VpnConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'VpnConnection':
        """
        Get an existing VpnConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = VpnConnectionArgs.__new__(VpnConnectionArgs)

        __props__.__dict__["customer_gateway_id"] = None
        __props__.__dict__["enable_acceleration"] = None
        __props__.__dict__["local_ipv4_network_cidr"] = None
        __props__.__dict__["local_ipv6_network_cidr"] = None
        __props__.__dict__["outside_ip_address_type"] = None
        __props__.__dict__["remote_ipv4_network_cidr"] = None
        __props__.__dict__["remote_ipv6_network_cidr"] = None
        __props__.__dict__["static_routes_only"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["transit_gateway_id"] = None
        __props__.__dict__["transport_transit_gateway_attachment_id"] = None
        __props__.__dict__["tunnel_inside_ip_version"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["vpn_connection_id"] = None
        __props__.__dict__["vpn_gateway_id"] = None
        __props__.__dict__["vpn_tunnel_options_specifications"] = None
        return VpnConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customerGatewayId")
    def customer_gateway_id(self) -> pulumi.Output[str]:
        """
        The ID of the customer gateway at your end of the VPN connection.
        """
        return pulumi.get(self, "customer_gateway_id")

    @property
    @pulumi.getter(name="enableAcceleration")
    def enable_acceleration(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicate whether to enable acceleration for the VPN connection.
         Default: ``false``
        """
        return pulumi.get(self, "enable_acceleration")

    @property
    @pulumi.getter(name="localIpv4NetworkCidr")
    def local_ipv4_network_cidr(self) -> pulumi.Output[Optional[str]]:
        """
        The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.

        Default: `0.0.0.0/0`
        """
        return pulumi.get(self, "local_ipv4_network_cidr")

    @property
    @pulumi.getter(name="localIpv6NetworkCidr")
    def local_ipv6_network_cidr(self) -> pulumi.Output[Optional[str]]:
        """
        The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.

        Default: `::/0`
        """
        return pulumi.get(self, "local_ipv6_network_cidr")

    @property
    @pulumi.getter(name="outsideIpAddressType")
    def outside_ip_address_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of IPv4 address assigned to the outside interface of the customer gateway device.

        Valid values: `PrivateIpv4` | `PublicIpv4`

        Default: `PublicIpv4`
        """
        return pulumi.get(self, "outside_ip_address_type")

    @property
    @pulumi.getter(name="remoteIpv4NetworkCidr")
    def remote_ipv4_network_cidr(self) -> pulumi.Output[Optional[str]]:
        """
        The IPv4 CIDR on the AWS side of the VPN connection.

        Default: `0.0.0.0/0`
        """
        return pulumi.get(self, "remote_ipv4_network_cidr")

    @property
    @pulumi.getter(name="remoteIpv6NetworkCidr")
    def remote_ipv6_network_cidr(self) -> pulumi.Output[Optional[str]]:
        """
        The IPv6 CIDR on the AWS side of the VPN connection.

        Default: `::/0`
        """
        return pulumi.get(self, "remote_ipv6_network_cidr")

    @property
    @pulumi.getter(name="staticRoutesOnly")
    def static_routes_only(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether the VPN connection uses static routes only. Static routes must be used for devices that don't support BGP.
         If you are creating a VPN connection for a device that does not support Border Gateway Protocol (BGP), you must specify ``true``.
        """
        return pulumi.get(self, "static_routes_only")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Any tags assigned to the VPN connection.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="transitGatewayId")
    def transit_gateway_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the transit gateway associated with the VPN connection.
         You must specify either ``TransitGatewayId`` or ``VpnGatewayId``, but not both.
        """
        return pulumi.get(self, "transit_gateway_id")

    @property
    @pulumi.getter(name="transportTransitGatewayAttachmentId")
    def transport_transit_gateway_attachment_id(self) -> pulumi.Output[Optional[str]]:
        """
        The transit gateway attachment ID to use for the VPN tunnel.

        Required if `OutsideIpAddressType` is set to `PrivateIpv4` .
        """
        return pulumi.get(self, "transport_transit_gateway_attachment_id")

    @property
    @pulumi.getter(name="tunnelInsideIpVersion")
    def tunnel_inside_ip_version(self) -> pulumi.Output[Optional[str]]:
        """
        Indicate whether the VPN tunnels process IPv4 or IPv6 traffic.

        Default: `ipv4`
        """
        return pulumi.get(self, "tunnel_inside_ip_version")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of VPN connection.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vpnConnectionId")
    def vpn_connection_id(self) -> pulumi.Output[str]:
        """
        The ID of the VPN connection.
        """
        return pulumi.get(self, "vpn_connection_id")

    @property
    @pulumi.getter(name="vpnGatewayId")
    def vpn_gateway_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the virtual private gateway at the AWS side of the VPN connection.
         You must specify either ``TransitGatewayId`` or ``VpnGatewayId``, but not both.
        """
        return pulumi.get(self, "vpn_gateway_id")

    @property
    @pulumi.getter(name="vpnTunnelOptionsSpecifications")
    def vpn_tunnel_options_specifications(self) -> pulumi.Output[Optional[Sequence['outputs.VpnConnectionVpnTunnelOptionsSpecification']]]:
        """
        The tunnel options for the VPN connection.
        """
        return pulumi.get(self, "vpn_tunnel_options_specifications")

