# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetworkPerformanceMetricSubscriptionArgs', 'NetworkPerformanceMetricSubscription']

@pulumi.input_type
class NetworkPerformanceMetricSubscriptionArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input[str],
                 metric: pulumi.Input[str],
                 source: pulumi.Input[str],
                 statistic: pulumi.Input[str]):
        """
        The set of arguments for constructing a NetworkPerformanceMetricSubscription resource.
        :param pulumi.Input[str] destination: The target Region or Availability Zone for the metric to subscribe to.
        :param pulumi.Input[str] metric: The metric type to subscribe to.
        :param pulumi.Input[str] source: The starting Region or Availability Zone for metric to subscribe to.
        :param pulumi.Input[str] statistic: The statistic to subscribe to.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "statistic", statistic)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input[str]:
        """
        The target Region or Availability Zone for the metric to subscribe to.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter
    def metric(self) -> pulumi.Input[str]:
        """
        The metric type to subscribe to.
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        The starting Region or Availability Zone for metric to subscribe to.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def statistic(self) -> pulumi.Input[str]:
        """
        The statistic to subscribe to.
        """
        return pulumi.get(self, "statistic")

    @statistic.setter
    def statistic(self, value: pulumi.Input[str]):
        pulumi.set(self, "statistic", value)


class NetworkPerformanceMetricSubscription(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination: Optional[pulumi.Input[str]] = None,
                 metric: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 statistic: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::EC2::NetworkPerformanceMetricSubscription

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] destination: The target Region or Availability Zone for the metric to subscribe to.
        :param pulumi.Input[str] metric: The metric type to subscribe to.
        :param pulumi.Input[str] source: The starting Region or Availability Zone for metric to subscribe to.
        :param pulumi.Input[str] statistic: The statistic to subscribe to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkPerformanceMetricSubscriptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::EC2::NetworkPerformanceMetricSubscription

        :param str resource_name: The name of the resource.
        :param NetworkPerformanceMetricSubscriptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkPerformanceMetricSubscriptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination: Optional[pulumi.Input[str]] = None,
                 metric: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 statistic: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkPerformanceMetricSubscriptionArgs.__new__(NetworkPerformanceMetricSubscriptionArgs)

            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            if metric is None and not opts.urn:
                raise TypeError("Missing required property 'metric'")
            __props__.__dict__["metric"] = metric
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            if statistic is None and not opts.urn:
                raise TypeError("Missing required property 'statistic'")
            __props__.__dict__["statistic"] = statistic
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["destination", "metric", "source", "statistic"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(NetworkPerformanceMetricSubscription, __self__).__init__(
            'aws-native:ec2:NetworkPerformanceMetricSubscription',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'NetworkPerformanceMetricSubscription':
        """
        Get an existing NetworkPerformanceMetricSubscription resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = NetworkPerformanceMetricSubscriptionArgs.__new__(NetworkPerformanceMetricSubscriptionArgs)

        __props__.__dict__["destination"] = None
        __props__.__dict__["metric"] = None
        __props__.__dict__["source"] = None
        __props__.__dict__["statistic"] = None
        return NetworkPerformanceMetricSubscription(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Output[str]:
        """
        The target Region or Availability Zone for the metric to subscribe to.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def metric(self) -> pulumi.Output[str]:
        """
        The metric type to subscribe to.
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[str]:
        """
        The starting Region or Availability Zone for metric to subscribe to.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def statistic(self) -> pulumi.Output[str]:
        """
        The statistic to subscribe to.
        """
        return pulumi.get(self, "statistic")

