# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = ['NetworkInsightsAnalysisArgs', 'NetworkInsightsAnalysis']

@pulumi.input_type
class NetworkInsightsAnalysisArgs:
    def __init__(__self__, *,
                 network_insights_path_id: pulumi.Input[str],
                 additional_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 filter_in_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a NetworkInsightsAnalysis resource.
        :param pulumi.Input[str] network_insights_path_id: The ID of the path.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] additional_accounts: The member accounts that contain resources that the path can traverse.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] filter_in_arns: The Amazon Resource Names (ARN) of the resources that the path must traverse.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags to apply.
        """
        pulumi.set(__self__, "network_insights_path_id", network_insights_path_id)
        if additional_accounts is not None:
            pulumi.set(__self__, "additional_accounts", additional_accounts)
        if filter_in_arns is not None:
            pulumi.set(__self__, "filter_in_arns", filter_in_arns)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="networkInsightsPathId")
    def network_insights_path_id(self) -> pulumi.Input[str]:
        """
        The ID of the path.
        """
        return pulumi.get(self, "network_insights_path_id")

    @network_insights_path_id.setter
    def network_insights_path_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_insights_path_id", value)

    @property
    @pulumi.getter(name="additionalAccounts")
    def additional_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The member accounts that contain resources that the path can traverse.
        """
        return pulumi.get(self, "additional_accounts")

    @additional_accounts.setter
    def additional_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "additional_accounts", value)

    @property
    @pulumi.getter(name="filterInArns")
    def filter_in_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The Amazon Resource Names (ARN) of the resources that the path must traverse.
        """
        return pulumi.get(self, "filter_in_arns")

    @filter_in_arns.setter
    def filter_in_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "filter_in_arns", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags to apply.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class NetworkInsightsAnalysis(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 filter_in_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_insights_path_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource schema for AWS::EC2::NetworkInsightsAnalysis

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] additional_accounts: The member accounts that contain resources that the path can traverse.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] filter_in_arns: The Amazon Resource Names (ARN) of the resources that the path must traverse.
        :param pulumi.Input[str] network_insights_path_id: The ID of the path.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags to apply.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkInsightsAnalysisArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::EC2::NetworkInsightsAnalysis

        :param str resource_name: The name of the resource.
        :param NetworkInsightsAnalysisArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkInsightsAnalysisArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 filter_in_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 network_insights_path_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkInsightsAnalysisArgs.__new__(NetworkInsightsAnalysisArgs)

            __props__.__dict__["additional_accounts"] = additional_accounts
            __props__.__dict__["filter_in_arns"] = filter_in_arns
            if network_insights_path_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_insights_path_id'")
            __props__.__dict__["network_insights_path_id"] = network_insights_path_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["alternate_path_hints"] = None
            __props__.__dict__["explanations"] = None
            __props__.__dict__["forward_path_components"] = None
            __props__.__dict__["network_insights_analysis_arn"] = None
            __props__.__dict__["network_insights_analysis_id"] = None
            __props__.__dict__["network_path_found"] = None
            __props__.__dict__["return_path_components"] = None
            __props__.__dict__["start_date"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["status_message"] = None
            __props__.__dict__["suggested_accounts"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["filterInArns[*]", "networkInsightsPathId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(NetworkInsightsAnalysis, __self__).__init__(
            'aws-native:ec2:NetworkInsightsAnalysis',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'NetworkInsightsAnalysis':
        """
        Get an existing NetworkInsightsAnalysis resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = NetworkInsightsAnalysisArgs.__new__(NetworkInsightsAnalysisArgs)

        __props__.__dict__["additional_accounts"] = None
        __props__.__dict__["alternate_path_hints"] = None
        __props__.__dict__["explanations"] = None
        __props__.__dict__["filter_in_arns"] = None
        __props__.__dict__["forward_path_components"] = None
        __props__.__dict__["network_insights_analysis_arn"] = None
        __props__.__dict__["network_insights_analysis_id"] = None
        __props__.__dict__["network_insights_path_id"] = None
        __props__.__dict__["network_path_found"] = None
        __props__.__dict__["return_path_components"] = None
        __props__.__dict__["start_date"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["status_message"] = None
        __props__.__dict__["suggested_accounts"] = None
        __props__.__dict__["tags"] = None
        return NetworkInsightsAnalysis(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalAccounts")
    def additional_accounts(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The member accounts that contain resources that the path can traverse.
        """
        return pulumi.get(self, "additional_accounts")

    @property
    @pulumi.getter(name="alternatePathHints")
    def alternate_path_hints(self) -> pulumi.Output[Sequence['outputs.NetworkInsightsAnalysisAlternatePathHint']]:
        """
        Potential intermediate components.
        """
        return pulumi.get(self, "alternate_path_hints")

    @property
    @pulumi.getter
    def explanations(self) -> pulumi.Output[Sequence['outputs.NetworkInsightsAnalysisExplanation']]:
        """
        The explanations. For more information, see [Reachability Analyzer explanation codes](https://docs.aws.amazon.com/vpc/latest/reachability/explanation-codes.html) .
        """
        return pulumi.get(self, "explanations")

    @property
    @pulumi.getter(name="filterInArns")
    def filter_in_arns(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The Amazon Resource Names (ARN) of the resources that the path must traverse.
        """
        return pulumi.get(self, "filter_in_arns")

    @property
    @pulumi.getter(name="forwardPathComponents")
    def forward_path_components(self) -> pulumi.Output[Sequence['outputs.NetworkInsightsAnalysisPathComponent']]:
        """
        The components in the path from source to destination.
        """
        return pulumi.get(self, "forward_path_components")

    @property
    @pulumi.getter(name="networkInsightsAnalysisArn")
    def network_insights_analysis_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the network insights analysis.
        """
        return pulumi.get(self, "network_insights_analysis_arn")

    @property
    @pulumi.getter(name="networkInsightsAnalysisId")
    def network_insights_analysis_id(self) -> pulumi.Output[str]:
        """
        The ID of the network insights analysis.
        """
        return pulumi.get(self, "network_insights_analysis_id")

    @property
    @pulumi.getter(name="networkInsightsPathId")
    def network_insights_path_id(self) -> pulumi.Output[str]:
        """
        The ID of the path.
        """
        return pulumi.get(self, "network_insights_path_id")

    @property
    @pulumi.getter(name="networkPathFound")
    def network_path_found(self) -> pulumi.Output[bool]:
        """
        Indicates whether the destination is reachable from the source.
        """
        return pulumi.get(self, "network_path_found")

    @property
    @pulumi.getter(name="returnPathComponents")
    def return_path_components(self) -> pulumi.Output[Sequence['outputs.NetworkInsightsAnalysisPathComponent']]:
        """
        The components in the path from destination to source.
        """
        return pulumi.get(self, "return_path_components")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> pulumi.Output[str]:
        """
        The time the analysis started.
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['NetworkInsightsAnalysisStatus']:
        """
        The status of the network insights analysis.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> pulumi.Output[str]:
        """
        The status message, if the status is `failed` .
        """
        return pulumi.get(self, "status_message")

    @property
    @pulumi.getter(name="suggestedAccounts")
    def suggested_accounts(self) -> pulumi.Output[Sequence[str]]:
        """
        The IDs of potential intermediate accounts.
        """
        return pulumi.get(self, "suggested_accounts")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags to apply.
        """
        return pulumi.get(self, "tags")

