# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['IpamResourceDiscoveryArgs', 'IpamResourceDiscovery']

@pulumi.input_type
class IpamResourceDiscoveryArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 operating_regions: Optional[pulumi.Input[Sequence[pulumi.Input['IpamResourceDiscoveryIpamOperatingRegionArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a IpamResourceDiscovery resource.
        :param pulumi.Input[str] description: The resource discovery description.
        :param pulumi.Input[Sequence[pulumi.Input['IpamResourceDiscoveryIpamOperatingRegionArgs']]] operating_regions: The regions Resource Discovery is enabled for. Allows resource discoveries to be created in these regions, as well as enabling monitoring
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if operating_regions is not None:
            pulumi.set(__self__, "operating_regions", operating_regions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The resource discovery description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="operatingRegions")
    def operating_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpamResourceDiscoveryIpamOperatingRegionArgs']]]]:
        """
        The regions Resource Discovery is enabled for. Allows resource discoveries to be created in these regions, as well as enabling monitoring
        """
        return pulumi.get(self, "operating_regions")

    @operating_regions.setter
    def operating_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpamResourceDiscoveryIpamOperatingRegionArgs']]]]):
        pulumi.set(self, "operating_regions", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class IpamResourceDiscovery(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 operating_regions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpamResourceDiscoveryIpamOperatingRegionArgs', 'IpamResourceDiscoveryIpamOperatingRegionArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Schema of AWS::EC2::IPAMResourceDiscovery Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The resource discovery description.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IpamResourceDiscoveryIpamOperatingRegionArgs', 'IpamResourceDiscoveryIpamOperatingRegionArgsDict']]]] operating_regions: The regions Resource Discovery is enabled for. Allows resource discoveries to be created in these regions, as well as enabling monitoring
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[IpamResourceDiscoveryArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Schema of AWS::EC2::IPAMResourceDiscovery Type

        :param str resource_name: The name of the resource.
        :param IpamResourceDiscoveryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpamResourceDiscoveryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 operating_regions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpamResourceDiscoveryIpamOperatingRegionArgs', 'IpamResourceDiscoveryIpamOperatingRegionArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpamResourceDiscoveryArgs.__new__(IpamResourceDiscoveryArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["operating_regions"] = operating_regions
            __props__.__dict__["tags"] = tags
            __props__.__dict__["ipam_resource_discovery_arn"] = None
            __props__.__dict__["ipam_resource_discovery_id"] = None
            __props__.__dict__["ipam_resource_discovery_region"] = None
            __props__.__dict__["is_default"] = None
            __props__.__dict__["owner_id"] = None
            __props__.__dict__["state"] = None
        super(IpamResourceDiscovery, __self__).__init__(
            'aws-native:ec2:IpamResourceDiscovery',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'IpamResourceDiscovery':
        """
        Get an existing IpamResourceDiscovery resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = IpamResourceDiscoveryArgs.__new__(IpamResourceDiscoveryArgs)

        __props__.__dict__["description"] = None
        __props__.__dict__["ipam_resource_discovery_arn"] = None
        __props__.__dict__["ipam_resource_discovery_id"] = None
        __props__.__dict__["ipam_resource_discovery_region"] = None
        __props__.__dict__["is_default"] = None
        __props__.__dict__["operating_regions"] = None
        __props__.__dict__["owner_id"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["tags"] = None
        return IpamResourceDiscovery(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The resource discovery description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ipamResourceDiscoveryArn")
    def ipam_resource_discovery_arn(self) -> pulumi.Output[str]:
        """
        Amazon Resource Name (Arn) for the Resource Discovery.
        """
        return pulumi.get(self, "ipam_resource_discovery_arn")

    @property
    @pulumi.getter(name="ipamResourceDiscoveryId")
    def ipam_resource_discovery_id(self) -> pulumi.Output[str]:
        """
        Id of the IPAM Pool.
        """
        return pulumi.get(self, "ipam_resource_discovery_id")

    @property
    @pulumi.getter(name="ipamResourceDiscoveryRegion")
    def ipam_resource_discovery_region(self) -> pulumi.Output[str]:
        """
        The region the resource discovery is setup in. 
        """
        return pulumi.get(self, "ipam_resource_discovery_region")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[bool]:
        """
        Determines whether or not address space from this pool is publicly advertised. Must be set if and only if the pool is IPv6.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="operatingRegions")
    def operating_regions(self) -> pulumi.Output[Optional[Sequence['outputs.IpamResourceDiscoveryIpamOperatingRegion']]]:
        """
        The regions Resource Discovery is enabled for. Allows resource discoveries to be created in these regions, as well as enabling monitoring
        """
        return pulumi.get(self, "operating_regions")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> pulumi.Output[str]:
        """
        Owner Account ID of the Resource Discovery
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of this Resource Discovery.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

