# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 additional_info: Optional[pulumi.Input[str]] = None,
                 affinity: Optional[pulumi.Input['InstanceAffinity']] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBlockDeviceMappingArgs']]]] = None,
                 cpu_options: Optional[pulumi.Input['CpuOptionsPropertiesArgs']] = None,
                 credit_specification: Optional[pulumi.Input['CreditSpecificationPropertiesArgs']] = None,
                 disable_api_termination: Optional[pulumi.Input[bool]] = None,
                 ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 elastic_gpu_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceElasticGpuSpecificationArgs']]]] = None,
                 elastic_inference_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceElasticInferenceAcceleratorArgs']]]] = None,
                 enclave_options: Optional[pulumi.Input['EnclaveOptionsPropertiesArgs']] = None,
                 hibernation_options: Optional[pulumi.Input['HibernationOptionsPropertiesArgs']] = None,
                 host_id: Optional[pulumi.Input[str]] = None,
                 host_resource_group_arn: Optional[pulumi.Input[str]] = None,
                 iam_instance_profile: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_initiated_shutdown_behavior: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 ipv6_address_count: Optional[pulumi.Input[int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceIpv6AddressArgs']]]] = None,
                 kernel_id: Optional[pulumi.Input[str]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 launch_template: Optional[pulumi.Input['InstanceLaunchTemplateSpecificationArgs']] = None,
                 license_specifications: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceLicenseSpecificationArgs']]]] = None,
                 monitoring: Optional[pulumi.Input[bool]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]]] = None,
                 placement_group_name: Optional[pulumi.Input[str]] = None,
                 private_dns_name_options: Optional[pulumi.Input['InstancePrivateDnsNameOptionsArgs']] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 propagate_tags_to_volume_on_creation: Optional[pulumi.Input[bool]] = None,
                 ramdisk_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_dest_check: Optional[pulumi.Input[bool]] = None,
                 ssm_associations: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSsmAssociationArgs']]]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 tenancy: Optional[pulumi.Input[str]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceVolumeArgs']]]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[str] additional_info: This property is reserved for internal use. If you use it, the stack fails with this error: Bad property set: [Testing this property] (Service: AmazonEC2; Status Code: 400; Error Code: InvalidParameterCombination; Request ID: 0XXXXXX-49c7-4b40-8bcc-76885dcXXXXX).
        :param pulumi.Input['InstanceAffinity'] affinity: Indicates whether the instance is associated with a dedicated host. If you want the instance to always restart on the same host on which it was launched, specify host. If you want the instance to restart on any available host, but try to launch onto the last host it ran on (on a best-effort basis), specify default.
        :param pulumi.Input[str] availability_zone: The Availability Zone of the instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceBlockDeviceMappingArgs']]] block_device_mappings: The block device mapping entries that defines the block devices to attach to the instance at launch.
        :param pulumi.Input['CpuOptionsPropertiesArgs'] cpu_options: The CPU options for the instance.
        :param pulumi.Input['CreditSpecificationPropertiesArgs'] credit_specification: The credit option for CPU usage of the burstable performance instance. Valid values are standard and unlimited.
        :param pulumi.Input[bool] disable_api_termination: If you set this parameter to true, you can't terminate the instance using the Amazon EC2 console, CLI, or API; otherwise, you can.
        :param pulumi.Input[bool] ebs_optimized: Indicates whether the instance is optimized for Amazon EBS I/O.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceElasticGpuSpecificationArgs']]] elastic_gpu_specifications: An elastic GPU to associate with the instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceElasticInferenceAcceleratorArgs']]] elastic_inference_accelerators: An elastic inference accelerator to associate with the instance.
        :param pulumi.Input['EnclaveOptionsPropertiesArgs'] enclave_options: Indicates whether the instance is enabled for AWS Nitro Enclaves.
        :param pulumi.Input['HibernationOptionsPropertiesArgs'] hibernation_options: Indicates whether an instance is enabled for hibernation.
        :param pulumi.Input[str] host_id: If you specify host for the Affinity property, the ID of a dedicated host that the instance is associated with. If you don't specify an ID, Amazon EC2 launches the instance onto any available, compatible dedicated host in your account.
        :param pulumi.Input[str] host_resource_group_arn: The ARN of the host resource group in which to launch the instances. If you specify a host resource group ARN, omit the Tenancy parameter or set it to host.
        :param pulumi.Input[str] iam_instance_profile: The IAM instance profile.
        :param pulumi.Input[str] image_id: The ID of the AMI. An AMI ID is required to launch an instance and must be specified here or in a launch template.
        :param pulumi.Input[str] instance_initiated_shutdown_behavior: Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
        :param pulumi.Input[str] instance_type: The instance type.
        :param pulumi.Input[int] ipv6_address_count: [EC2-VPC] The number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceIpv6AddressArgs']]] ipv6_addresses: [EC2-VPC] The IPv6 addresses from the range of the subnet to associate with the primary network interface.
        :param pulumi.Input[str] kernel_id: The ID of the kernel.
        :param pulumi.Input[str] key_name: The name of the key pair.
        :param pulumi.Input['InstanceLaunchTemplateSpecificationArgs'] launch_template: The launch template to use to launch the instances.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceLicenseSpecificationArgs']]] license_specifications: The license configurations.
        :param pulumi.Input[bool] monitoring: Specifies whether detailed monitoring is enabled for the instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]] network_interfaces: The network interfaces to associate with the instance.
        :param pulumi.Input[str] placement_group_name: The name of an existing placement group that you want to launch the instance into (cluster | partition | spread).
        :param pulumi.Input['InstancePrivateDnsNameOptionsArgs'] private_dns_name_options: The options for the instance hostname.
        :param pulumi.Input[str] private_ip_address: [EC2-VPC] The primary IPv4 address. You must specify a value from the IPv4 address range of the subnet.
        :param pulumi.Input[bool] propagate_tags_to_volume_on_creation: Indicates whether to assign the tags from the instance to all of the volumes attached to the instance at launch. If you specify true and you assign tags to the instance, those tags are automatically assigned to all of the volumes that you attach to the instance at launch. If you specify false, those tags are not assigned to the attached volumes.
        :param pulumi.Input[str] ramdisk_id: The ID of the RAM disk to select.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: The IDs of the security groups.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: the names of the security groups. For a nondefault VPC, you must use security group IDs instead.
        :param pulumi.Input[bool] source_dest_check: Specifies whether to enable an instance launched in a VPC to perform NAT.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceSsmAssociationArgs']]] ssm_associations: The SSM document and parameter values in AWS Systems Manager to associate with this instance.
        :param pulumi.Input[str] subnet_id: [EC2-VPC] The ID of the subnet to launch the instance into.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags to add to the instance.
        :param pulumi.Input[str] tenancy: The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of dedicated runs on single-tenant hardware.
        :param pulumi.Input[str] user_data: The user data to make available to the instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceVolumeArgs']]] volumes: The volumes to attach to the instance.
        """
        if additional_info is not None:
            pulumi.set(__self__, "additional_info", additional_info)
        if affinity is not None:
            pulumi.set(__self__, "affinity", affinity)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if block_device_mappings is not None:
            pulumi.set(__self__, "block_device_mappings", block_device_mappings)
        if cpu_options is not None:
            pulumi.set(__self__, "cpu_options", cpu_options)
        if credit_specification is not None:
            pulumi.set(__self__, "credit_specification", credit_specification)
        if disable_api_termination is not None:
            pulumi.set(__self__, "disable_api_termination", disable_api_termination)
        if ebs_optimized is not None:
            pulumi.set(__self__, "ebs_optimized", ebs_optimized)
        if elastic_gpu_specifications is not None:
            pulumi.set(__self__, "elastic_gpu_specifications", elastic_gpu_specifications)
        if elastic_inference_accelerators is not None:
            pulumi.set(__self__, "elastic_inference_accelerators", elastic_inference_accelerators)
        if enclave_options is not None:
            pulumi.set(__self__, "enclave_options", enclave_options)
        if hibernation_options is not None:
            pulumi.set(__self__, "hibernation_options", hibernation_options)
        if host_id is not None:
            pulumi.set(__self__, "host_id", host_id)
        if host_resource_group_arn is not None:
            pulumi.set(__self__, "host_resource_group_arn", host_resource_group_arn)
        if iam_instance_profile is not None:
            pulumi.set(__self__, "iam_instance_profile", iam_instance_profile)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_initiated_shutdown_behavior is not None:
            pulumi.set(__self__, "instance_initiated_shutdown_behavior", instance_initiated_shutdown_behavior)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if ipv6_address_count is not None:
            pulumi.set(__self__, "ipv6_address_count", ipv6_address_count)
        if ipv6_addresses is not None:
            pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)
        if kernel_id is not None:
            pulumi.set(__self__, "kernel_id", kernel_id)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if launch_template is not None:
            pulumi.set(__self__, "launch_template", launch_template)
        if license_specifications is not None:
            pulumi.set(__self__, "license_specifications", license_specifications)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if placement_group_name is not None:
            pulumi.set(__self__, "placement_group_name", placement_group_name)
        if private_dns_name_options is not None:
            pulumi.set(__self__, "private_dns_name_options", private_dns_name_options)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if propagate_tags_to_volume_on_creation is not None:
            pulumi.set(__self__, "propagate_tags_to_volume_on_creation", propagate_tags_to_volume_on_creation)
        if ramdisk_id is not None:
            pulumi.set(__self__, "ramdisk_id", ramdisk_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if source_dest_check is not None:
            pulumi.set(__self__, "source_dest_check", source_dest_check)
        if ssm_associations is not None:
            pulumi.set(__self__, "ssm_associations", ssm_associations)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenancy is not None:
            pulumi.set(__self__, "tenancy", tenancy)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="additionalInfo")
    def additional_info(self) -> Optional[pulumi.Input[str]]:
        """
        This property is reserved for internal use. If you use it, the stack fails with this error: Bad property set: [Testing this property] (Service: AmazonEC2; Status Code: 400; Error Code: InvalidParameterCombination; Request ID: 0XXXXXX-49c7-4b40-8bcc-76885dcXXXXX).
        """
        return pulumi.get(self, "additional_info")

    @additional_info.setter
    def additional_info(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "additional_info", value)

    @property
    @pulumi.getter
    def affinity(self) -> Optional[pulumi.Input['InstanceAffinity']]:
        """
        Indicates whether the instance is associated with a dedicated host. If you want the instance to always restart on the same host on which it was launched, specify host. If you want the instance to restart on any available host, but try to launch onto the last host it ran on (on a best-effort basis), specify default.
        """
        return pulumi.get(self, "affinity")

    @affinity.setter
    def affinity(self, value: Optional[pulumi.Input['InstanceAffinity']]):
        pulumi.set(self, "affinity", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The Availability Zone of the instance.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="blockDeviceMappings")
    def block_device_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBlockDeviceMappingArgs']]]]:
        """
        The block device mapping entries that defines the block devices to attach to the instance at launch.
        """
        return pulumi.get(self, "block_device_mappings")

    @block_device_mappings.setter
    def block_device_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceBlockDeviceMappingArgs']]]]):
        pulumi.set(self, "block_device_mappings", value)

    @property
    @pulumi.getter(name="cpuOptions")
    def cpu_options(self) -> Optional[pulumi.Input['CpuOptionsPropertiesArgs']]:
        """
        The CPU options for the instance.
        """
        return pulumi.get(self, "cpu_options")

    @cpu_options.setter
    def cpu_options(self, value: Optional[pulumi.Input['CpuOptionsPropertiesArgs']]):
        pulumi.set(self, "cpu_options", value)

    @property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> Optional[pulumi.Input['CreditSpecificationPropertiesArgs']]:
        """
        The credit option for CPU usage of the burstable performance instance. Valid values are standard and unlimited.
        """
        return pulumi.get(self, "credit_specification")

    @credit_specification.setter
    def credit_specification(self, value: Optional[pulumi.Input['CreditSpecificationPropertiesArgs']]):
        pulumi.set(self, "credit_specification", value)

    @property
    @pulumi.getter(name="disableApiTermination")
    def disable_api_termination(self) -> Optional[pulumi.Input[bool]]:
        """
        If you set this parameter to true, you can't terminate the instance using the Amazon EC2 console, CLI, or API; otherwise, you can.
        """
        return pulumi.get(self, "disable_api_termination")

    @disable_api_termination.setter
    def disable_api_termination(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_api_termination", value)

    @property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the instance is optimized for Amazon EBS I/O.
        """
        return pulumi.get(self, "ebs_optimized")

    @ebs_optimized.setter
    def ebs_optimized(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ebs_optimized", value)

    @property
    @pulumi.getter(name="elasticGpuSpecifications")
    def elastic_gpu_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceElasticGpuSpecificationArgs']]]]:
        """
        An elastic GPU to associate with the instance.
        """
        return pulumi.get(self, "elastic_gpu_specifications")

    @elastic_gpu_specifications.setter
    def elastic_gpu_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceElasticGpuSpecificationArgs']]]]):
        pulumi.set(self, "elastic_gpu_specifications", value)

    @property
    @pulumi.getter(name="elasticInferenceAccelerators")
    def elastic_inference_accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceElasticInferenceAcceleratorArgs']]]]:
        """
        An elastic inference accelerator to associate with the instance.
        """
        return pulumi.get(self, "elastic_inference_accelerators")

    @elastic_inference_accelerators.setter
    def elastic_inference_accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceElasticInferenceAcceleratorArgs']]]]):
        pulumi.set(self, "elastic_inference_accelerators", value)

    @property
    @pulumi.getter(name="enclaveOptions")
    def enclave_options(self) -> Optional[pulumi.Input['EnclaveOptionsPropertiesArgs']]:
        """
        Indicates whether the instance is enabled for AWS Nitro Enclaves.
        """
        return pulumi.get(self, "enclave_options")

    @enclave_options.setter
    def enclave_options(self, value: Optional[pulumi.Input['EnclaveOptionsPropertiesArgs']]):
        pulumi.set(self, "enclave_options", value)

    @property
    @pulumi.getter(name="hibernationOptions")
    def hibernation_options(self) -> Optional[pulumi.Input['HibernationOptionsPropertiesArgs']]:
        """
        Indicates whether an instance is enabled for hibernation.
        """
        return pulumi.get(self, "hibernation_options")

    @hibernation_options.setter
    def hibernation_options(self, value: Optional[pulumi.Input['HibernationOptionsPropertiesArgs']]):
        pulumi.set(self, "hibernation_options", value)

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> Optional[pulumi.Input[str]]:
        """
        If you specify host for the Affinity property, the ID of a dedicated host that the instance is associated with. If you don't specify an ID, Amazon EC2 launches the instance onto any available, compatible dedicated host in your account.
        """
        return pulumi.get(self, "host_id")

    @host_id.setter
    def host_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_id", value)

    @property
    @pulumi.getter(name="hostResourceGroupArn")
    def host_resource_group_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the host resource group in which to launch the instances. If you specify a host resource group ARN, omit the Tenancy parameter or set it to host.
        """
        return pulumi.get(self, "host_resource_group_arn")

    @host_resource_group_arn.setter
    def host_resource_group_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_resource_group_arn", value)

    @property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> Optional[pulumi.Input[str]]:
        """
        The IAM instance profile.
        """
        return pulumi.get(self, "iam_instance_profile")

    @iam_instance_profile.setter
    def iam_instance_profile(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_instance_profile", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the AMI. An AMI ID is required to launch an instance and must be specified here or in a launch template.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="instanceInitiatedShutdownBehavior")
    def instance_initiated_shutdown_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
        """
        return pulumi.get(self, "instance_initiated_shutdown_behavior")

    @instance_initiated_shutdown_behavior.setter
    def instance_initiated_shutdown_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_initiated_shutdown_behavior", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The instance type.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> Optional[pulumi.Input[int]]:
        """
        [EC2-VPC] The number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        """
        return pulumi.get(self, "ipv6_address_count")

    @ipv6_address_count.setter
    def ipv6_address_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_address_count", value)

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceIpv6AddressArgs']]]]:
        """
        [EC2-VPC] The IPv6 addresses from the range of the subnet to associate with the primary network interface.
        """
        return pulumi.get(self, "ipv6_addresses")

    @ipv6_addresses.setter
    def ipv6_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceIpv6AddressArgs']]]]):
        pulumi.set(self, "ipv6_addresses", value)

    @property
    @pulumi.getter(name="kernelId")
    def kernel_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the kernel.
        """
        return pulumi.get(self, "kernel_id")

    @kernel_id.setter
    def kernel_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kernel_id", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the key pair.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> Optional[pulumi.Input['InstanceLaunchTemplateSpecificationArgs']]:
        """
        The launch template to use to launch the instances.
        """
        return pulumi.get(self, "launch_template")

    @launch_template.setter
    def launch_template(self, value: Optional[pulumi.Input['InstanceLaunchTemplateSpecificationArgs']]):
        pulumi.set(self, "launch_template", value)

    @property
    @pulumi.getter(name="licenseSpecifications")
    def license_specifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceLicenseSpecificationArgs']]]]:
        """
        The license configurations.
        """
        return pulumi.get(self, "license_specifications")

    @license_specifications.setter
    def license_specifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceLicenseSpecificationArgs']]]]):
        pulumi.set(self, "license_specifications", value)

    @property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether detailed monitoring is enabled for the instance.
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "monitoring", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]]]:
        """
        The network interfaces to associate with the instance.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="placementGroupName")
    def placement_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an existing placement group that you want to launch the instance into (cluster | partition | spread).
        """
        return pulumi.get(self, "placement_group_name")

    @placement_group_name.setter
    def placement_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement_group_name", value)

    @property
    @pulumi.getter(name="privateDnsNameOptions")
    def private_dns_name_options(self) -> Optional[pulumi.Input['InstancePrivateDnsNameOptionsArgs']]:
        """
        The options for the instance hostname.
        """
        return pulumi.get(self, "private_dns_name_options")

    @private_dns_name_options.setter
    def private_dns_name_options(self, value: Optional[pulumi.Input['InstancePrivateDnsNameOptionsArgs']]):
        pulumi.set(self, "private_dns_name_options", value)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        [EC2-VPC] The primary IPv4 address. You must specify a value from the IPv4 address range of the subnet.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="propagateTagsToVolumeOnCreation")
    def propagate_tags_to_volume_on_creation(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to assign the tags from the instance to all of the volumes attached to the instance at launch. If you specify true and you assign tags to the instance, those tags are automatically assigned to all of the volumes that you attach to the instance at launch. If you specify false, those tags are not assigned to the attached volumes.
        """
        return pulumi.get(self, "propagate_tags_to_volume_on_creation")

    @propagate_tags_to_volume_on_creation.setter
    def propagate_tags_to_volume_on_creation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "propagate_tags_to_volume_on_creation", value)

    @property
    @pulumi.getter(name="ramdiskId")
    def ramdisk_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the RAM disk to select.
        """
        return pulumi.get(self, "ramdisk_id")

    @ramdisk_id.setter
    def ramdisk_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ramdisk_id", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IDs of the security groups.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        the names of the security groups. For a nondefault VPC, you must use security group IDs instead.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable an instance launched in a VPC to perform NAT.
        """
        return pulumi.get(self, "source_dest_check")

    @source_dest_check.setter
    def source_dest_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "source_dest_check", value)

    @property
    @pulumi.getter(name="ssmAssociations")
    def ssm_associations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSsmAssociationArgs']]]]:
        """
        The SSM document and parameter values in AWS Systems Manager to associate with this instance.
        """
        return pulumi.get(self, "ssm_associations")

    @ssm_associations.setter
    def ssm_associations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSsmAssociationArgs']]]]):
        pulumi.set(self, "ssm_associations", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        [EC2-VPC] The ID of the subnet to launch the instance into.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags to add to the instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def tenancy(self) -> Optional[pulumi.Input[str]]:
        """
        The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of dedicated runs on single-tenant hardware.
        """
        return pulumi.get(self, "tenancy")

    @tenancy.setter
    def tenancy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenancy", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        The user data to make available to the instance.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceVolumeArgs']]]]:
        """
        The volumes to attach to the instance.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_info: Optional[pulumi.Input[str]] = None,
                 affinity: Optional[pulumi.Input['InstanceAffinity']] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceBlockDeviceMappingArgs', 'InstanceBlockDeviceMappingArgsDict']]]]] = None,
                 cpu_options: Optional[pulumi.Input[Union['CpuOptionsPropertiesArgs', 'CpuOptionsPropertiesArgsDict']]] = None,
                 credit_specification: Optional[pulumi.Input[Union['CreditSpecificationPropertiesArgs', 'CreditSpecificationPropertiesArgsDict']]] = None,
                 disable_api_termination: Optional[pulumi.Input[bool]] = None,
                 ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 elastic_gpu_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceElasticGpuSpecificationArgs', 'InstanceElasticGpuSpecificationArgsDict']]]]] = None,
                 elastic_inference_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceElasticInferenceAcceleratorArgs', 'InstanceElasticInferenceAcceleratorArgsDict']]]]] = None,
                 enclave_options: Optional[pulumi.Input[Union['EnclaveOptionsPropertiesArgs', 'EnclaveOptionsPropertiesArgsDict']]] = None,
                 hibernation_options: Optional[pulumi.Input[Union['HibernationOptionsPropertiesArgs', 'HibernationOptionsPropertiesArgsDict']]] = None,
                 host_id: Optional[pulumi.Input[str]] = None,
                 host_resource_group_arn: Optional[pulumi.Input[str]] = None,
                 iam_instance_profile: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_initiated_shutdown_behavior: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 ipv6_address_count: Optional[pulumi.Input[int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceIpv6AddressArgs', 'InstanceIpv6AddressArgsDict']]]]] = None,
                 kernel_id: Optional[pulumi.Input[str]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 launch_template: Optional[pulumi.Input[Union['InstanceLaunchTemplateSpecificationArgs', 'InstanceLaunchTemplateSpecificationArgsDict']]] = None,
                 license_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceLicenseSpecificationArgs', 'InstanceLicenseSpecificationArgsDict']]]]] = None,
                 monitoring: Optional[pulumi.Input[bool]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkInterfaceArgs', 'InstanceNetworkInterfaceArgsDict']]]]] = None,
                 placement_group_name: Optional[pulumi.Input[str]] = None,
                 private_dns_name_options: Optional[pulumi.Input[Union['InstancePrivateDnsNameOptionsArgs', 'InstancePrivateDnsNameOptionsArgsDict']]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 propagate_tags_to_volume_on_creation: Optional[pulumi.Input[bool]] = None,
                 ramdisk_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_dest_check: Optional[pulumi.Input[bool]] = None,
                 ssm_associations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceSsmAssociationArgs', 'InstanceSsmAssociationArgsDict']]]]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 tenancy: Optional[pulumi.Input[str]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceVolumeArgs', 'InstanceVolumeArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::EC2::Instance

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] additional_info: This property is reserved for internal use. If you use it, the stack fails with this error: Bad property set: [Testing this property] (Service: AmazonEC2; Status Code: 400; Error Code: InvalidParameterCombination; Request ID: 0XXXXXX-49c7-4b40-8bcc-76885dcXXXXX).
        :param pulumi.Input['InstanceAffinity'] affinity: Indicates whether the instance is associated with a dedicated host. If you want the instance to always restart on the same host on which it was launched, specify host. If you want the instance to restart on any available host, but try to launch onto the last host it ran on (on a best-effort basis), specify default.
        :param pulumi.Input[str] availability_zone: The Availability Zone of the instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceBlockDeviceMappingArgs', 'InstanceBlockDeviceMappingArgsDict']]]] block_device_mappings: The block device mapping entries that defines the block devices to attach to the instance at launch.
        :param pulumi.Input[Union['CpuOptionsPropertiesArgs', 'CpuOptionsPropertiesArgsDict']] cpu_options: The CPU options for the instance.
        :param pulumi.Input[Union['CreditSpecificationPropertiesArgs', 'CreditSpecificationPropertiesArgsDict']] credit_specification: The credit option for CPU usage of the burstable performance instance. Valid values are standard and unlimited.
        :param pulumi.Input[bool] disable_api_termination: If you set this parameter to true, you can't terminate the instance using the Amazon EC2 console, CLI, or API; otherwise, you can.
        :param pulumi.Input[bool] ebs_optimized: Indicates whether the instance is optimized for Amazon EBS I/O.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceElasticGpuSpecificationArgs', 'InstanceElasticGpuSpecificationArgsDict']]]] elastic_gpu_specifications: An elastic GPU to associate with the instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceElasticInferenceAcceleratorArgs', 'InstanceElasticInferenceAcceleratorArgsDict']]]] elastic_inference_accelerators: An elastic inference accelerator to associate with the instance.
        :param pulumi.Input[Union['EnclaveOptionsPropertiesArgs', 'EnclaveOptionsPropertiesArgsDict']] enclave_options: Indicates whether the instance is enabled for AWS Nitro Enclaves.
        :param pulumi.Input[Union['HibernationOptionsPropertiesArgs', 'HibernationOptionsPropertiesArgsDict']] hibernation_options: Indicates whether an instance is enabled for hibernation.
        :param pulumi.Input[str] host_id: If you specify host for the Affinity property, the ID of a dedicated host that the instance is associated with. If you don't specify an ID, Amazon EC2 launches the instance onto any available, compatible dedicated host in your account.
        :param pulumi.Input[str] host_resource_group_arn: The ARN of the host resource group in which to launch the instances. If you specify a host resource group ARN, omit the Tenancy parameter or set it to host.
        :param pulumi.Input[str] iam_instance_profile: The IAM instance profile.
        :param pulumi.Input[str] image_id: The ID of the AMI. An AMI ID is required to launch an instance and must be specified here or in a launch template.
        :param pulumi.Input[str] instance_initiated_shutdown_behavior: Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
        :param pulumi.Input[str] instance_type: The instance type.
        :param pulumi.Input[int] ipv6_address_count: [EC2-VPC] The number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceIpv6AddressArgs', 'InstanceIpv6AddressArgsDict']]]] ipv6_addresses: [EC2-VPC] The IPv6 addresses from the range of the subnet to associate with the primary network interface.
        :param pulumi.Input[str] kernel_id: The ID of the kernel.
        :param pulumi.Input[str] key_name: The name of the key pair.
        :param pulumi.Input[Union['InstanceLaunchTemplateSpecificationArgs', 'InstanceLaunchTemplateSpecificationArgsDict']] launch_template: The launch template to use to launch the instances.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceLicenseSpecificationArgs', 'InstanceLicenseSpecificationArgsDict']]]] license_specifications: The license configurations.
        :param pulumi.Input[bool] monitoring: Specifies whether detailed monitoring is enabled for the instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkInterfaceArgs', 'InstanceNetworkInterfaceArgsDict']]]] network_interfaces: The network interfaces to associate with the instance.
        :param pulumi.Input[str] placement_group_name: The name of an existing placement group that you want to launch the instance into (cluster | partition | spread).
        :param pulumi.Input[Union['InstancePrivateDnsNameOptionsArgs', 'InstancePrivateDnsNameOptionsArgsDict']] private_dns_name_options: The options for the instance hostname.
        :param pulumi.Input[str] private_ip_address: [EC2-VPC] The primary IPv4 address. You must specify a value from the IPv4 address range of the subnet.
        :param pulumi.Input[bool] propagate_tags_to_volume_on_creation: Indicates whether to assign the tags from the instance to all of the volumes attached to the instance at launch. If you specify true and you assign tags to the instance, those tags are automatically assigned to all of the volumes that you attach to the instance at launch. If you specify false, those tags are not assigned to the attached volumes.
        :param pulumi.Input[str] ramdisk_id: The ID of the RAM disk to select.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: The IDs of the security groups.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: the names of the security groups. For a nondefault VPC, you must use security group IDs instead.
        :param pulumi.Input[bool] source_dest_check: Specifies whether to enable an instance launched in a VPC to perform NAT.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceSsmAssociationArgs', 'InstanceSsmAssociationArgsDict']]]] ssm_associations: The SSM document and parameter values in AWS Systems Manager to associate with this instance.
        :param pulumi.Input[str] subnet_id: [EC2-VPC] The ID of the subnet to launch the instance into.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags to add to the instance.
        :param pulumi.Input[str] tenancy: The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of dedicated runs on single-tenant hardware.
        :param pulumi.Input[str] user_data: The user data to make available to the instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceVolumeArgs', 'InstanceVolumeArgsDict']]]] volumes: The volumes to attach to the instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[InstanceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::EC2::Instance

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_info: Optional[pulumi.Input[str]] = None,
                 affinity: Optional[pulumi.Input['InstanceAffinity']] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceBlockDeviceMappingArgs', 'InstanceBlockDeviceMappingArgsDict']]]]] = None,
                 cpu_options: Optional[pulumi.Input[Union['CpuOptionsPropertiesArgs', 'CpuOptionsPropertiesArgsDict']]] = None,
                 credit_specification: Optional[pulumi.Input[Union['CreditSpecificationPropertiesArgs', 'CreditSpecificationPropertiesArgsDict']]] = None,
                 disable_api_termination: Optional[pulumi.Input[bool]] = None,
                 ebs_optimized: Optional[pulumi.Input[bool]] = None,
                 elastic_gpu_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceElasticGpuSpecificationArgs', 'InstanceElasticGpuSpecificationArgsDict']]]]] = None,
                 elastic_inference_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceElasticInferenceAcceleratorArgs', 'InstanceElasticInferenceAcceleratorArgsDict']]]]] = None,
                 enclave_options: Optional[pulumi.Input[Union['EnclaveOptionsPropertiesArgs', 'EnclaveOptionsPropertiesArgsDict']]] = None,
                 hibernation_options: Optional[pulumi.Input[Union['HibernationOptionsPropertiesArgs', 'HibernationOptionsPropertiesArgsDict']]] = None,
                 host_id: Optional[pulumi.Input[str]] = None,
                 host_resource_group_arn: Optional[pulumi.Input[str]] = None,
                 iam_instance_profile: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_initiated_shutdown_behavior: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 ipv6_address_count: Optional[pulumi.Input[int]] = None,
                 ipv6_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceIpv6AddressArgs', 'InstanceIpv6AddressArgsDict']]]]] = None,
                 kernel_id: Optional[pulumi.Input[str]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 launch_template: Optional[pulumi.Input[Union['InstanceLaunchTemplateSpecificationArgs', 'InstanceLaunchTemplateSpecificationArgsDict']]] = None,
                 license_specifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceLicenseSpecificationArgs', 'InstanceLicenseSpecificationArgsDict']]]]] = None,
                 monitoring: Optional[pulumi.Input[bool]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkInterfaceArgs', 'InstanceNetworkInterfaceArgsDict']]]]] = None,
                 placement_group_name: Optional[pulumi.Input[str]] = None,
                 private_dns_name_options: Optional[pulumi.Input[Union['InstancePrivateDnsNameOptionsArgs', 'InstancePrivateDnsNameOptionsArgsDict']]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 propagate_tags_to_volume_on_creation: Optional[pulumi.Input[bool]] = None,
                 ramdisk_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_dest_check: Optional[pulumi.Input[bool]] = None,
                 ssm_associations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceSsmAssociationArgs', 'InstanceSsmAssociationArgsDict']]]]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 tenancy: Optional[pulumi.Input[str]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceVolumeArgs', 'InstanceVolumeArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["additional_info"] = additional_info
            __props__.__dict__["affinity"] = affinity
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["block_device_mappings"] = block_device_mappings
            __props__.__dict__["cpu_options"] = cpu_options
            __props__.__dict__["credit_specification"] = credit_specification
            __props__.__dict__["disable_api_termination"] = disable_api_termination
            __props__.__dict__["ebs_optimized"] = ebs_optimized
            __props__.__dict__["elastic_gpu_specifications"] = elastic_gpu_specifications
            __props__.__dict__["elastic_inference_accelerators"] = elastic_inference_accelerators
            __props__.__dict__["enclave_options"] = enclave_options
            __props__.__dict__["hibernation_options"] = hibernation_options
            __props__.__dict__["host_id"] = host_id
            __props__.__dict__["host_resource_group_arn"] = host_resource_group_arn
            __props__.__dict__["iam_instance_profile"] = iam_instance_profile
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["instance_initiated_shutdown_behavior"] = instance_initiated_shutdown_behavior
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["ipv6_address_count"] = ipv6_address_count
            __props__.__dict__["ipv6_addresses"] = ipv6_addresses
            __props__.__dict__["kernel_id"] = kernel_id
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["launch_template"] = launch_template
            __props__.__dict__["license_specifications"] = license_specifications
            __props__.__dict__["monitoring"] = monitoring
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["placement_group_name"] = placement_group_name
            __props__.__dict__["private_dns_name_options"] = private_dns_name_options
            __props__.__dict__["private_ip_address"] = private_ip_address
            __props__.__dict__["propagate_tags_to_volume_on_creation"] = propagate_tags_to_volume_on_creation
            __props__.__dict__["ramdisk_id"] = ramdisk_id
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["security_groups"] = security_groups
            __props__.__dict__["source_dest_check"] = source_dest_check
            __props__.__dict__["ssm_associations"] = ssm_associations
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tenancy"] = tenancy
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["volumes"] = volumes
            __props__.__dict__["instance_id"] = None
            __props__.__dict__["private_dns_name"] = None
            __props__.__dict__["private_ip"] = None
            __props__.__dict__["public_dns_name"] = None
            __props__.__dict__["public_ip"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["vpc_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["availabilityZone", "cpuOptions", "elasticGpuSpecifications[*]", "elasticInferenceAccelerators[*]", "enclaveOptions", "hibernationOptions", "hostResourceGroupArn", "imageId", "ipv6AddressCount", "ipv6Addresses[*]", "keyName", "launchTemplate", "licenseSpecifications[*]", "networkInterfaces[*]", "placementGroupName", "privateIpAddress", "securityGroups[*]", "subnetId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Instance, __self__).__init__(
            'aws-native:ec2:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = InstanceArgs.__new__(InstanceArgs)

        __props__.__dict__["additional_info"] = None
        __props__.__dict__["affinity"] = None
        __props__.__dict__["availability_zone"] = None
        __props__.__dict__["block_device_mappings"] = None
        __props__.__dict__["cpu_options"] = None
        __props__.__dict__["credit_specification"] = None
        __props__.__dict__["disable_api_termination"] = None
        __props__.__dict__["ebs_optimized"] = None
        __props__.__dict__["elastic_gpu_specifications"] = None
        __props__.__dict__["elastic_inference_accelerators"] = None
        __props__.__dict__["enclave_options"] = None
        __props__.__dict__["hibernation_options"] = None
        __props__.__dict__["host_id"] = None
        __props__.__dict__["host_resource_group_arn"] = None
        __props__.__dict__["iam_instance_profile"] = None
        __props__.__dict__["image_id"] = None
        __props__.__dict__["instance_id"] = None
        __props__.__dict__["instance_initiated_shutdown_behavior"] = None
        __props__.__dict__["instance_type"] = None
        __props__.__dict__["ipv6_address_count"] = None
        __props__.__dict__["ipv6_addresses"] = None
        __props__.__dict__["kernel_id"] = None
        __props__.__dict__["key_name"] = None
        __props__.__dict__["launch_template"] = None
        __props__.__dict__["license_specifications"] = None
        __props__.__dict__["monitoring"] = None
        __props__.__dict__["network_interfaces"] = None
        __props__.__dict__["placement_group_name"] = None
        __props__.__dict__["private_dns_name"] = None
        __props__.__dict__["private_dns_name_options"] = None
        __props__.__dict__["private_ip"] = None
        __props__.__dict__["private_ip_address"] = None
        __props__.__dict__["propagate_tags_to_volume_on_creation"] = None
        __props__.__dict__["public_dns_name"] = None
        __props__.__dict__["public_ip"] = None
        __props__.__dict__["ramdisk_id"] = None
        __props__.__dict__["security_group_ids"] = None
        __props__.__dict__["security_groups"] = None
        __props__.__dict__["source_dest_check"] = None
        __props__.__dict__["ssm_associations"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["subnet_id"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["tenancy"] = None
        __props__.__dict__["user_data"] = None
        __props__.__dict__["volumes"] = None
        __props__.__dict__["vpc_id"] = None
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalInfo")
    def additional_info(self) -> pulumi.Output[Optional[str]]:
        """
        This property is reserved for internal use. If you use it, the stack fails with this error: Bad property set: [Testing this property] (Service: AmazonEC2; Status Code: 400; Error Code: InvalidParameterCombination; Request ID: 0XXXXXX-49c7-4b40-8bcc-76885dcXXXXX).
        """
        return pulumi.get(self, "additional_info")

    @property
    @pulumi.getter
    def affinity(self) -> pulumi.Output[Optional['InstanceAffinity']]:
        """
        Indicates whether the instance is associated with a dedicated host. If you want the instance to always restart on the same host on which it was launched, specify host. If you want the instance to restart on any available host, but try to launch onto the last host it ran on (on a best-effort basis), specify default.
        """
        return pulumi.get(self, "affinity")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[Optional[str]]:
        """
        The Availability Zone of the instance.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="blockDeviceMappings")
    def block_device_mappings(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceBlockDeviceMapping']]]:
        """
        The block device mapping entries that defines the block devices to attach to the instance at launch.
        """
        return pulumi.get(self, "block_device_mappings")

    @property
    @pulumi.getter(name="cpuOptions")
    def cpu_options(self) -> pulumi.Output[Optional['outputs.CpuOptionsProperties']]:
        """
        The CPU options for the instance.
        """
        return pulumi.get(self, "cpu_options")

    @property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> pulumi.Output[Optional['outputs.CreditSpecificationProperties']]:
        """
        The credit option for CPU usage of the burstable performance instance. Valid values are standard and unlimited.
        """
        return pulumi.get(self, "credit_specification")

    @property
    @pulumi.getter(name="disableApiTermination")
    def disable_api_termination(self) -> pulumi.Output[Optional[bool]]:
        """
        If you set this parameter to true, you can't terminate the instance using the Amazon EC2 console, CLI, or API; otherwise, you can.
        """
        return pulumi.get(self, "disable_api_termination")

    @property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether the instance is optimized for Amazon EBS I/O.
        """
        return pulumi.get(self, "ebs_optimized")

    @property
    @pulumi.getter(name="elasticGpuSpecifications")
    def elastic_gpu_specifications(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceElasticGpuSpecification']]]:
        """
        An elastic GPU to associate with the instance.
        """
        return pulumi.get(self, "elastic_gpu_specifications")

    @property
    @pulumi.getter(name="elasticInferenceAccelerators")
    def elastic_inference_accelerators(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceElasticInferenceAccelerator']]]:
        """
        An elastic inference accelerator to associate with the instance.
        """
        return pulumi.get(self, "elastic_inference_accelerators")

    @property
    @pulumi.getter(name="enclaveOptions")
    def enclave_options(self) -> pulumi.Output[Optional['outputs.EnclaveOptionsProperties']]:
        """
        Indicates whether the instance is enabled for AWS Nitro Enclaves.
        """
        return pulumi.get(self, "enclave_options")

    @property
    @pulumi.getter(name="hibernationOptions")
    def hibernation_options(self) -> pulumi.Output[Optional['outputs.HibernationOptionsProperties']]:
        """
        Indicates whether an instance is enabled for hibernation.
        """
        return pulumi.get(self, "hibernation_options")

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> pulumi.Output[Optional[str]]:
        """
        If you specify host for the Affinity property, the ID of a dedicated host that the instance is associated with. If you don't specify an ID, Amazon EC2 launches the instance onto any available, compatible dedicated host in your account.
        """
        return pulumi.get(self, "host_id")

    @property
    @pulumi.getter(name="hostResourceGroupArn")
    def host_resource_group_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The ARN of the host resource group in which to launch the instances. If you specify a host resource group ARN, omit the Tenancy parameter or set it to host.
        """
        return pulumi.get(self, "host_resource_group_arn")

    @property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> pulumi.Output[Optional[str]]:
        """
        The IAM instance profile.
        """
        return pulumi.get(self, "iam_instance_profile")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the AMI. An AMI ID is required to launch an instance and must be specified here or in a launch template.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The EC2 Instance ID.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceInitiatedShutdownBehavior")
    def instance_initiated_shutdown_behavior(self) -> pulumi.Output[Optional[str]]:
        """
        Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
        """
        return pulumi.get(self, "instance_initiated_shutdown_behavior")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[Optional[str]]:
        """
        The instance type.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="ipv6AddressCount")
    def ipv6_address_count(self) -> pulumi.Output[Optional[int]]:
        """
        [EC2-VPC] The number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
        """
        return pulumi.get(self, "ipv6_address_count")

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceIpv6Address']]]:
        """
        [EC2-VPC] The IPv6 addresses from the range of the subnet to associate with the primary network interface.
        """
        return pulumi.get(self, "ipv6_addresses")

    @property
    @pulumi.getter(name="kernelId")
    def kernel_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the kernel.
        """
        return pulumi.get(self, "kernel_id")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the key pair.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> pulumi.Output[Optional['outputs.InstanceLaunchTemplateSpecification']]:
        """
        The launch template to use to launch the instances.
        """
        return pulumi.get(self, "launch_template")

    @property
    @pulumi.getter(name="licenseSpecifications")
    def license_specifications(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceLicenseSpecification']]]:
        """
        The license configurations.
        """
        return pulumi.get(self, "license_specifications")

    @property
    @pulumi.getter
    def monitoring(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether detailed monitoring is enabled for the instance.
        """
        return pulumi.get(self, "monitoring")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceNetworkInterface']]]:
        """
        The network interfaces to associate with the instance.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="placementGroupName")
    def placement_group_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of an existing placement group that you want to launch the instance into (cluster | partition | spread).
        """
        return pulumi.get(self, "placement_group_name")

    @property
    @pulumi.getter(name="privateDnsName")
    def private_dns_name(self) -> pulumi.Output[str]:
        """
        The private DNS name of the specified instance. For example: ip-10-24-34-0.ec2.internal.
        """
        return pulumi.get(self, "private_dns_name")

    @property
    @pulumi.getter(name="privateDnsNameOptions")
    def private_dns_name_options(self) -> pulumi.Output[Optional['outputs.InstancePrivateDnsNameOptions']]:
        """
        The options for the instance hostname.
        """
        return pulumi.get(self, "private_dns_name_options")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[str]:
        """
        The private IP address of the specified instance. For example: 10.24.34.0.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Output[Optional[str]]:
        """
        [EC2-VPC] The primary IPv4 address. You must specify a value from the IPv4 address range of the subnet.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="propagateTagsToVolumeOnCreation")
    def propagate_tags_to_volume_on_creation(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether to assign the tags from the instance to all of the volumes attached to the instance at launch. If you specify true and you assign tags to the instance, those tags are automatically assigned to all of the volumes that you attach to the instance at launch. If you specify false, those tags are not assigned to the attached volumes.
        """
        return pulumi.get(self, "propagate_tags_to_volume_on_creation")

    @property
    @pulumi.getter(name="publicDnsName")
    def public_dns_name(self) -> pulumi.Output[str]:
        """
        The public DNS name of the specified instance. For example: ec2-107-20-50-45.compute-1.amazonaws.com.
        """
        return pulumi.get(self, "public_dns_name")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[str]:
        """
        The public IP address of the specified instance. For example: 192.0.2.0.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="ramdiskId")
    def ramdisk_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the RAM disk to select.
        """
        return pulumi.get(self, "ramdisk_id")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The IDs of the security groups.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        the names of the security groups. For a nondefault VPC, you must use security group IDs instead.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable an instance launched in a VPC to perform NAT.
        """
        return pulumi.get(self, "source_dest_check")

    @property
    @pulumi.getter(name="ssmAssociations")
    def ssm_associations(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceSsmAssociation']]]:
        """
        The SSM document and parameter values in AWS Systems Manager to associate with this instance.
        """
        return pulumi.get(self, "ssm_associations")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output['outputs.InstanceState']:
        """
        The current state of the instance.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[Optional[str]]:
        """
        [EC2-VPC] The ID of the subnet to launch the instance into.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags to add to the instance.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def tenancy(self) -> pulumi.Output[Optional[str]]:
        """
        The tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of dedicated runs on single-tenant hardware.
        """
        return pulumi.get(self, "tenancy")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[str]]:
        """
        The user data to make available to the instance.
        """
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter
    def volumes(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceVolume']]]:
        """
        The volumes to attach to the instance.
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The ID of the VPC that the instance is running in.
        """
        return pulumi.get(self, "vpc_id")

