# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetSecurityGroupResult',
    'AwaitableGetSecurityGroupResult',
    'get_security_group',
    'get_security_group_output',
]

@pulumi.output_type
class GetSecurityGroupResult:
    def __init__(__self__, group_id=None, id=None, security_group_egress=None, security_group_ingress=None, tags=None):
        if group_id and not isinstance(group_id, str):
            raise TypeError("Expected argument 'group_id' to be a str")
        pulumi.set(__self__, "group_id", group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if security_group_egress and not isinstance(security_group_egress, list):
            raise TypeError("Expected argument 'security_group_egress' to be a list")
        pulumi.set(__self__, "security_group_egress", security_group_egress)
        if security_group_ingress and not isinstance(security_group_ingress, list):
            raise TypeError("Expected argument 'security_group_ingress' to be a list")
        pulumi.set(__self__, "security_group_ingress", security_group_ingress)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[str]:
        """
        The group ID of the specified security group.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The group name or group ID depending on whether the SG is created in default or specific VPC
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="securityGroupEgress")
    def security_group_egress(self) -> Optional[Sequence['outputs.SecurityGroupEgress']]:
        """
        [VPC only] The outbound rules associated with the security group. There is a short interruption during which you cannot connect to the security group.
        """
        return pulumi.get(self, "security_group_egress")

    @property
    @pulumi.getter(name="securityGroupIngress")
    def security_group_ingress(self) -> Optional[Sequence['outputs.SecurityGroupIngress']]:
        """
        The inbound rules associated with the security group. There is a short interruption during which you cannot connect to the security group.
        """
        return pulumi.get(self, "security_group_ingress")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Any tags assigned to the security group.
        """
        return pulumi.get(self, "tags")


class AwaitableGetSecurityGroupResult(GetSecurityGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityGroupResult(
            group_id=self.group_id,
            id=self.id,
            security_group_egress=self.security_group_egress,
            security_group_ingress=self.security_group_ingress,
            tags=self.tags)


def get_security_group(id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityGroupResult:
    """
    Resource Type definition for AWS::EC2::SecurityGroup


    :param str id: The group name or group ID depending on whether the SG is created in default or specific VPC
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getSecurityGroup', __args__, opts=opts, typ=GetSecurityGroupResult).value

    return AwaitableGetSecurityGroupResult(
        group_id=pulumi.get(__ret__, 'group_id'),
        id=pulumi.get(__ret__, 'id'),
        security_group_egress=pulumi.get(__ret__, 'security_group_egress'),
        security_group_ingress=pulumi.get(__ret__, 'security_group_ingress'),
        tags=pulumi.get(__ret__, 'tags'))
def get_security_group_output(id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSecurityGroupResult]:
    """
    Resource Type definition for AWS::EC2::SecurityGroup


    :param str id: The group name or group ID depending on whether the SG is created in default or specific VPC
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ec2:getSecurityGroup', __args__, opts=opts, typ=GetSecurityGroupResult)
    return __ret__.apply(lambda __response__: GetSecurityGroupResult(
        group_id=pulumi.get(__response__, 'group_id'),
        id=pulumi.get(__response__, 'id'),
        security_group_egress=pulumi.get(__response__, 'security_group_egress'),
        security_group_ingress=pulumi.get(__response__, 'security_group_ingress'),
        tags=pulumi.get(__response__, 'tags')))
