# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetRouteTableResult',
    'AwaitableGetRouteTableResult',
    'get_route_table',
    'get_route_table_output',
]

@pulumi.output_type
class GetRouteTableResult:
    def __init__(__self__, route_table_id=None, tags=None):
        if route_table_id and not isinstance(route_table_id, str):
            raise TypeError("Expected argument 'route_table_id' to be a str")
        pulumi.set(__self__, "route_table_id", route_table_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[str]:
        """
        The ID of the route table.
        """
        return pulumi.get(self, "route_table_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Any tags assigned to the route table.
        """
        return pulumi.get(self, "tags")


class AwaitableGetRouteTableResult(GetRouteTableResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRouteTableResult(
            route_table_id=self.route_table_id,
            tags=self.tags)


def get_route_table(route_table_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRouteTableResult:
    """
    Specifies a route table for the specified VPC. After you create a route table, you can add routes and associate the table with a subnet.
     For more information, see [Route tables](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html) in the *Amazon VPC User Guide*.


    :param str route_table_id: The ID of the route table.
    """
    __args__ = dict()
    __args__['routeTableId'] = route_table_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getRouteTable', __args__, opts=opts, typ=GetRouteTableResult).value

    return AwaitableGetRouteTableResult(
        route_table_id=pulumi.get(__ret__, 'route_table_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_route_table_output(route_table_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRouteTableResult]:
    """
    Specifies a route table for the specified VPC. After you create a route table, you can add routes and associate the table with a subnet.
     For more information, see [Route tables](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html) in the *Amazon VPC User Guide*.


    :param str route_table_id: The ID of the route table.
    """
    __args__ = dict()
    __args__['routeTableId'] = route_table_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ec2:getRouteTable', __args__, opts=opts, typ=GetRouteTableResult)
    return __ret__.apply(lambda __response__: GetRouteTableResult(
        route_table_id=pulumi.get(__response__, 'route_table_id'),
        tags=pulumi.get(__response__, 'tags')))
