# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetRouteResult',
    'AwaitableGetRouteResult',
    'get_route',
    'get_route_output',
]

@pulumi.output_type
class GetRouteResult:
    def __init__(__self__, carrier_gateway_id=None, cidr_block=None, core_network_arn=None, egress_only_internet_gateway_id=None, gateway_id=None, instance_id=None, local_gateway_id=None, nat_gateway_id=None, network_interface_id=None, transit_gateway_id=None, vpc_endpoint_id=None, vpc_peering_connection_id=None):
        if carrier_gateway_id and not isinstance(carrier_gateway_id, str):
            raise TypeError("Expected argument 'carrier_gateway_id' to be a str")
        pulumi.set(__self__, "carrier_gateway_id", carrier_gateway_id)
        if cidr_block and not isinstance(cidr_block, str):
            raise TypeError("Expected argument 'cidr_block' to be a str")
        pulumi.set(__self__, "cidr_block", cidr_block)
        if core_network_arn and not isinstance(core_network_arn, str):
            raise TypeError("Expected argument 'core_network_arn' to be a str")
        pulumi.set(__self__, "core_network_arn", core_network_arn)
        if egress_only_internet_gateway_id and not isinstance(egress_only_internet_gateway_id, str):
            raise TypeError("Expected argument 'egress_only_internet_gateway_id' to be a str")
        pulumi.set(__self__, "egress_only_internet_gateway_id", egress_only_internet_gateway_id)
        if gateway_id and not isinstance(gateway_id, str):
            raise TypeError("Expected argument 'gateway_id' to be a str")
        pulumi.set(__self__, "gateway_id", gateway_id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if local_gateway_id and not isinstance(local_gateway_id, str):
            raise TypeError("Expected argument 'local_gateway_id' to be a str")
        pulumi.set(__self__, "local_gateway_id", local_gateway_id)
        if nat_gateway_id and not isinstance(nat_gateway_id, str):
            raise TypeError("Expected argument 'nat_gateway_id' to be a str")
        pulumi.set(__self__, "nat_gateway_id", nat_gateway_id)
        if network_interface_id and not isinstance(network_interface_id, str):
            raise TypeError("Expected argument 'network_interface_id' to be a str")
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        if transit_gateway_id and not isinstance(transit_gateway_id, str):
            raise TypeError("Expected argument 'transit_gateway_id' to be a str")
        pulumi.set(__self__, "transit_gateway_id", transit_gateway_id)
        if vpc_endpoint_id and not isinstance(vpc_endpoint_id, str):
            raise TypeError("Expected argument 'vpc_endpoint_id' to be a str")
        pulumi.set(__self__, "vpc_endpoint_id", vpc_endpoint_id)
        if vpc_peering_connection_id and not isinstance(vpc_peering_connection_id, str):
            raise TypeError("Expected argument 'vpc_peering_connection_id' to be a str")
        pulumi.set(__self__, "vpc_peering_connection_id", vpc_peering_connection_id)

    @property
    @pulumi.getter(name="carrierGatewayId")
    def carrier_gateway_id(self) -> Optional[str]:
        """
        The ID of the carrier gateway.
         You can only use this option when the VPC contains a subnet which is associated with a Wavelength Zone.
        """
        return pulumi.get(self, "carrier_gateway_id")

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[str]:
        """
        The IPv4 CIDR block.
        """
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter(name="coreNetworkArn")
    def core_network_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the core network.
        """
        return pulumi.get(self, "core_network_arn")

    @property
    @pulumi.getter(name="egressOnlyInternetGatewayId")
    def egress_only_internet_gateway_id(self) -> Optional[str]:
        """
        [IPv6 traffic only] The ID of an egress-only internet gateway.
        """
        return pulumi.get(self, "egress_only_internet_gateway_id")

    @property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> Optional[str]:
        """
        The ID of an internet gateway or virtual private gateway attached to your VPC.
        """
        return pulumi.get(self, "gateway_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[str]:
        """
        The ID of a NAT instance in your VPC. The operation fails if you specify an instance ID unless exactly one network interface is attached.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="localGatewayId")
    def local_gateway_id(self) -> Optional[str]:
        """
        The ID of the local gateway.
        """
        return pulumi.get(self, "local_gateway_id")

    @property
    @pulumi.getter(name="natGatewayId")
    def nat_gateway_id(self) -> Optional[str]:
        """
        [IPv4 traffic only] The ID of a NAT gateway.
        """
        return pulumi.get(self, "nat_gateway_id")

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[str]:
        """
        The ID of a network interface.
        """
        return pulumi.get(self, "network_interface_id")

    @property
    @pulumi.getter(name="transitGatewayId")
    def transit_gateway_id(self) -> Optional[str]:
        """
        The ID of a transit gateway.
        """
        return pulumi.get(self, "transit_gateway_id")

    @property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> Optional[str]:
        """
        The ID of a VPC endpoint. Supported for Gateway Load Balancer endpoints only.
        """
        return pulumi.get(self, "vpc_endpoint_id")

    @property
    @pulumi.getter(name="vpcPeeringConnectionId")
    def vpc_peering_connection_id(self) -> Optional[str]:
        """
        The ID of a VPC peering connection.
        """
        return pulumi.get(self, "vpc_peering_connection_id")


class AwaitableGetRouteResult(GetRouteResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRouteResult(
            carrier_gateway_id=self.carrier_gateway_id,
            cidr_block=self.cidr_block,
            core_network_arn=self.core_network_arn,
            egress_only_internet_gateway_id=self.egress_only_internet_gateway_id,
            gateway_id=self.gateway_id,
            instance_id=self.instance_id,
            local_gateway_id=self.local_gateway_id,
            nat_gateway_id=self.nat_gateway_id,
            network_interface_id=self.network_interface_id,
            transit_gateway_id=self.transit_gateway_id,
            vpc_endpoint_id=self.vpc_endpoint_id,
            vpc_peering_connection_id=self.vpc_peering_connection_id)


def get_route(cidr_block: Optional[str] = None,
              route_table_id: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRouteResult:
    """
    Specifies a route in a route table. For more information, see [Routes](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html#route-table-routes) in the *Amazon VPC User Guide*.
     You must specify either a destination CIDR block or prefix list ID. You must also specify exactly one of the resources as the target.
     If you create a route that references a transit gateway in the same template where you create the transit gateway, you must declare a dependency on the transit gateway attachment. The route table cannot use the transit gateway until it has successfully attached to the VPC. Add a [DependsOn Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html) in the ``AWS::EC2::Route`` resource to explicitly declare a dependency on the ``AWS::EC2::TransitGatewayAttachment`` resource.


    :param str cidr_block: The IPv4 CIDR block.
    :param str route_table_id: The ID of the route table for the route.
    """
    __args__ = dict()
    __args__['cidrBlock'] = cidr_block
    __args__['routeTableId'] = route_table_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getRoute', __args__, opts=opts, typ=GetRouteResult).value

    return AwaitableGetRouteResult(
        carrier_gateway_id=pulumi.get(__ret__, 'carrier_gateway_id'),
        cidr_block=pulumi.get(__ret__, 'cidr_block'),
        core_network_arn=pulumi.get(__ret__, 'core_network_arn'),
        egress_only_internet_gateway_id=pulumi.get(__ret__, 'egress_only_internet_gateway_id'),
        gateway_id=pulumi.get(__ret__, 'gateway_id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        local_gateway_id=pulumi.get(__ret__, 'local_gateway_id'),
        nat_gateway_id=pulumi.get(__ret__, 'nat_gateway_id'),
        network_interface_id=pulumi.get(__ret__, 'network_interface_id'),
        transit_gateway_id=pulumi.get(__ret__, 'transit_gateway_id'),
        vpc_endpoint_id=pulumi.get(__ret__, 'vpc_endpoint_id'),
        vpc_peering_connection_id=pulumi.get(__ret__, 'vpc_peering_connection_id'))
def get_route_output(cidr_block: Optional[pulumi.Input[str]] = None,
                     route_table_id: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRouteResult]:
    """
    Specifies a route in a route table. For more information, see [Routes](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html#route-table-routes) in the *Amazon VPC User Guide*.
     You must specify either a destination CIDR block or prefix list ID. You must also specify exactly one of the resources as the target.
     If you create a route that references a transit gateway in the same template where you create the transit gateway, you must declare a dependency on the transit gateway attachment. The route table cannot use the transit gateway until it has successfully attached to the VPC. Add a [DependsOn Attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html) in the ``AWS::EC2::Route`` resource to explicitly declare a dependency on the ``AWS::EC2::TransitGatewayAttachment`` resource.


    :param str cidr_block: The IPv4 CIDR block.
    :param str route_table_id: The ID of the route table for the route.
    """
    __args__ = dict()
    __args__['cidrBlock'] = cidr_block
    __args__['routeTableId'] = route_table_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ec2:getRoute', __args__, opts=opts, typ=GetRouteResult)
    return __ret__.apply(lambda __response__: GetRouteResult(
        carrier_gateway_id=pulumi.get(__response__, 'carrier_gateway_id'),
        cidr_block=pulumi.get(__response__, 'cidr_block'),
        core_network_arn=pulumi.get(__response__, 'core_network_arn'),
        egress_only_internet_gateway_id=pulumi.get(__response__, 'egress_only_internet_gateway_id'),
        gateway_id=pulumi.get(__response__, 'gateway_id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        local_gateway_id=pulumi.get(__response__, 'local_gateway_id'),
        nat_gateway_id=pulumi.get(__response__, 'nat_gateway_id'),
        network_interface_id=pulumi.get(__response__, 'network_interface_id'),
        transit_gateway_id=pulumi.get(__response__, 'transit_gateway_id'),
        vpc_endpoint_id=pulumi.get(__response__, 'vpc_endpoint_id'),
        vpc_peering_connection_id=pulumi.get(__response__, 'vpc_peering_connection_id')))
