# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetEipResult',
    'AwaitableGetEipResult',
    'get_eip',
    'get_eip_output',
]

@pulumi.output_type
class GetEipResult:
    def __init__(__self__, allocation_id=None, instance_id=None, public_ip=None, public_ipv4_pool=None, tags=None):
        if allocation_id and not isinstance(allocation_id, str):
            raise TypeError("Expected argument 'allocation_id' to be a str")
        pulumi.set(__self__, "allocation_id", allocation_id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if public_ip and not isinstance(public_ip, str):
            raise TypeError("Expected argument 'public_ip' to be a str")
        pulumi.set(__self__, "public_ip", public_ip)
        if public_ipv4_pool and not isinstance(public_ipv4_pool, str):
            raise TypeError("Expected argument 'public_ipv4_pool' to be a str")
        pulumi.set(__self__, "public_ipv4_pool", public_ipv4_pool)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> Optional[str]:
        """
        The ID that AWS assigns to represent the allocation of the address for use with Amazon VPC. This is returned only for VPC elastic IP addresses. For example, `eipalloc-5723d13e` .
        """
        return pulumi.get(self, "allocation_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[str]:
        """
        The ID of the instance.
          Updates to the ``InstanceId`` property may require *some interruptions*. Updates on an EIP reassociates the address on its associated resource.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[str]:
        """
        The Elastic IP address.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="publicIpv4Pool")
    def public_ipv4_pool(self) -> Optional[str]:
        """
        The ID of an address pool that you own. Use this parameter to let Amazon EC2 select an address from the address pool.
          Updates to the ``PublicIpv4Pool`` property may require *some interruptions*. Updates on an EIP reassociates the address on its associated resource.
        """
        return pulumi.get(self, "public_ipv4_pool")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Any tags assigned to the Elastic IP address.
          Updates to the ``Tags`` property may require *some interruptions*. Updates on an EIP reassociates the address on its associated resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetEipResult(GetEipResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEipResult(
            allocation_id=self.allocation_id,
            instance_id=self.instance_id,
            public_ip=self.public_ip,
            public_ipv4_pool=self.public_ipv4_pool,
            tags=self.tags)


def get_eip(allocation_id: Optional[str] = None,
            public_ip: Optional[str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEipResult:
    """
    Specifies an Elastic IP (EIP) address and can, optionally, associate it with an Amazon EC2 instance.
     You can allocate an Elastic IP address from an address pool owned by AWS or from an address pool created from a public IPv4 address range that you have brought to AWS for use with your AWS resources using bring your own IP addresses (BYOIP). For more information, see [Bring Your Own IP Addresses (BYOIP)](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html) in the *Amazon EC2 User Guide*.
     For more information, see [Elastic IP Addresses](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) in the *Amazon EC2 User Guide*.


    :param str allocation_id: The ID that AWS assigns to represent the allocation of the address for use with Amazon VPC. This is returned only for VPC elastic IP addresses. For example, `eipalloc-5723d13e` .
    :param str public_ip: The Elastic IP address.
    """
    __args__ = dict()
    __args__['allocationId'] = allocation_id
    __args__['publicIp'] = public_ip
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getEip', __args__, opts=opts, typ=GetEipResult).value

    return AwaitableGetEipResult(
        allocation_id=pulumi.get(__ret__, 'allocation_id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        public_ip=pulumi.get(__ret__, 'public_ip'),
        public_ipv4_pool=pulumi.get(__ret__, 'public_ipv4_pool'),
        tags=pulumi.get(__ret__, 'tags'))
def get_eip_output(allocation_id: Optional[pulumi.Input[str]] = None,
                   public_ip: Optional[pulumi.Input[str]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEipResult]:
    """
    Specifies an Elastic IP (EIP) address and can, optionally, associate it with an Amazon EC2 instance.
     You can allocate an Elastic IP address from an address pool owned by AWS or from an address pool created from a public IPv4 address range that you have brought to AWS for use with your AWS resources using bring your own IP addresses (BYOIP). For more information, see [Bring Your Own IP Addresses (BYOIP)](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html) in the *Amazon EC2 User Guide*.
     For more information, see [Elastic IP Addresses](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html) in the *Amazon EC2 User Guide*.


    :param str allocation_id: The ID that AWS assigns to represent the allocation of the address for use with Amazon VPC. This is returned only for VPC elastic IP addresses. For example, `eipalloc-5723d13e` .
    :param str public_ip: The Elastic IP address.
    """
    __args__ = dict()
    __args__['allocationId'] = allocation_id
    __args__['publicIp'] = public_ip
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ec2:getEip', __args__, opts=opts, typ=GetEipResult)
    return __ret__.apply(lambda __response__: GetEipResult(
        allocation_id=pulumi.get(__response__, 'allocation_id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        public_ip=pulumi.get(__response__, 'public_ip'),
        public_ipv4_pool=pulumi.get(__response__, 'public_ipv4_pool'),
        tags=pulumi.get(__response__, 'tags')))
