# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetEc2FleetResult',
    'AwaitableGetEc2FleetResult',
    'get_ec2_fleet',
    'get_ec2_fleet_output',
]

@pulumi.output_type
class GetEc2FleetResult:
    def __init__(__self__, context=None, excess_capacity_termination_policy=None, fleet_id=None, target_capacity_specification=None):
        if context and not isinstance(context, str):
            raise TypeError("Expected argument 'context' to be a str")
        pulumi.set(__self__, "context", context)
        if excess_capacity_termination_policy and not isinstance(excess_capacity_termination_policy, str):
            raise TypeError("Expected argument 'excess_capacity_termination_policy' to be a str")
        pulumi.set(__self__, "excess_capacity_termination_policy", excess_capacity_termination_policy)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if target_capacity_specification and not isinstance(target_capacity_specification, dict):
            raise TypeError("Expected argument 'target_capacity_specification' to be a dict")
        pulumi.set(__self__, "target_capacity_specification", target_capacity_specification)

    @property
    @pulumi.getter
    def context(self) -> Optional[str]:
        """
        Reserved.
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter(name="excessCapacityTerminationPolicy")
    def excess_capacity_termination_policy(self) -> Optional['Ec2FleetExcessCapacityTerminationPolicy']:
        """
        Indicates whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2 Fleet.

        Supported only for fleets of type `maintain` .
        """
        return pulumi.get(self, "excess_capacity_termination_policy")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> Optional[str]:
        """
        The ID of the EC2 Fleet.
        """
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter(name="targetCapacitySpecification")
    def target_capacity_specification(self) -> Optional['outputs.Ec2FleetTargetCapacitySpecificationRequest']:
        """
        The number of units to request.
        """
        return pulumi.get(self, "target_capacity_specification")


class AwaitableGetEc2FleetResult(GetEc2FleetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEc2FleetResult(
            context=self.context,
            excess_capacity_termination_policy=self.excess_capacity_termination_policy,
            fleet_id=self.fleet_id,
            target_capacity_specification=self.target_capacity_specification)


def get_ec2_fleet(fleet_id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEc2FleetResult:
    """
    Resource Type definition for AWS::EC2::EC2Fleet


    :param str fleet_id: The ID of the EC2 Fleet.
    """
    __args__ = dict()
    __args__['fleetId'] = fleet_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getEc2Fleet', __args__, opts=opts, typ=GetEc2FleetResult).value

    return AwaitableGetEc2FleetResult(
        context=pulumi.get(__ret__, 'context'),
        excess_capacity_termination_policy=pulumi.get(__ret__, 'excess_capacity_termination_policy'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        target_capacity_specification=pulumi.get(__ret__, 'target_capacity_specification'))
def get_ec2_fleet_output(fleet_id: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEc2FleetResult]:
    """
    Resource Type definition for AWS::EC2::EC2Fleet


    :param str fleet_id: The ID of the EC2 Fleet.
    """
    __args__ = dict()
    __args__['fleetId'] = fleet_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ec2:getEc2Fleet', __args__, opts=opts, typ=GetEc2FleetResult)
    return __ret__.apply(lambda __response__: GetEc2FleetResult(
        context=pulumi.get(__response__, 'context'),
        excess_capacity_termination_policy=pulumi.get(__response__, 'excess_capacity_termination_policy'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        target_capacity_specification=pulumi.get(__response__, 'target_capacity_specification')))
