# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCapacityReservationResult',
    'AwaitableGetCapacityReservationResult',
    'get_capacity_reservation',
    'get_capacity_reservation_output',
]

@pulumi.output_type
class GetCapacityReservationResult:
    def __init__(__self__, available_instance_count=None, end_date=None, end_date_type=None, id=None, instance_count=None, instance_match_criteria=None, total_instance_count=None):
        if available_instance_count and not isinstance(available_instance_count, int):
            raise TypeError("Expected argument 'available_instance_count' to be a int")
        pulumi.set(__self__, "available_instance_count", available_instance_count)
        if end_date and not isinstance(end_date, str):
            raise TypeError("Expected argument 'end_date' to be a str")
        pulumi.set(__self__, "end_date", end_date)
        if end_date_type and not isinstance(end_date_type, str):
            raise TypeError("Expected argument 'end_date_type' to be a str")
        pulumi.set(__self__, "end_date_type", end_date_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_count and not isinstance(instance_count, int):
            raise TypeError("Expected argument 'instance_count' to be a int")
        pulumi.set(__self__, "instance_count", instance_count)
        if instance_match_criteria and not isinstance(instance_match_criteria, str):
            raise TypeError("Expected argument 'instance_match_criteria' to be a str")
        pulumi.set(__self__, "instance_match_criteria", instance_match_criteria)
        if total_instance_count and not isinstance(total_instance_count, int):
            raise TypeError("Expected argument 'total_instance_count' to be a int")
        pulumi.set(__self__, "total_instance_count", total_instance_count)

    @property
    @pulumi.getter(name="availableInstanceCount")
    def available_instance_count(self) -> Optional[int]:
        """
        Returns the remaining capacity, which indicates the number of instances that can be launched in the Capacity Reservation. For example: `9` .
        """
        return pulumi.get(self, "available_instance_count")

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> Optional[str]:
        """
        The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to `expired` when it reaches its end date and time.

        You must provide an `EndDate` value if `EndDateType` is `limited` . Omit `EndDate` if `EndDateType` is `unlimited` .

        If the `EndDateType` is `limited` , the Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="endDateType")
    def end_date_type(self) -> Optional[str]:
        """
        Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:

        - `unlimited` - The Capacity Reservation remains active until you explicitly cancel it. Do not provide an `EndDate` if the `EndDateType` is `unlimited` .
        - `limited` - The Capacity Reservation expires automatically at a specified date and time. You must provide an `EndDate` value if the `EndDateType` value is `limited` .
        """
        return pulumi.get(self, "end_date_type")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the Capacity Reservation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        The number of instances for which to reserve capacity.

        Valid range: 1 - 1000
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceMatchCriteria")
    def instance_match_criteria(self) -> Optional[str]:
        """
        Indicates the type of instance launches that the Capacity Reservation accepts. The options include:

        - `open` - The Capacity Reservation automatically matches all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes run in the Capacity Reservation automatically without specifying any additional parameters.
        - `targeted` - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.

        Default: `open`
        """
        return pulumi.get(self, "instance_match_criteria")

    @property
    @pulumi.getter(name="totalInstanceCount")
    def total_instance_count(self) -> Optional[int]:
        """
        Returns the total number of instances for which the Capacity Reservation reserves capacity. For example: `15` .
        """
        return pulumi.get(self, "total_instance_count")


class AwaitableGetCapacityReservationResult(GetCapacityReservationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCapacityReservationResult(
            available_instance_count=self.available_instance_count,
            end_date=self.end_date,
            end_date_type=self.end_date_type,
            id=self.id,
            instance_count=self.instance_count,
            instance_match_criteria=self.instance_match_criteria,
            total_instance_count=self.total_instance_count)


def get_capacity_reservation(id: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCapacityReservationResult:
    """
    Resource Type definition for AWS::EC2::CapacityReservation


    :param str id: The ID of the Capacity Reservation.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ec2:getCapacityReservation', __args__, opts=opts, typ=GetCapacityReservationResult).value

    return AwaitableGetCapacityReservationResult(
        available_instance_count=pulumi.get(__ret__, 'available_instance_count'),
        end_date=pulumi.get(__ret__, 'end_date'),
        end_date_type=pulumi.get(__ret__, 'end_date_type'),
        id=pulumi.get(__ret__, 'id'),
        instance_count=pulumi.get(__ret__, 'instance_count'),
        instance_match_criteria=pulumi.get(__ret__, 'instance_match_criteria'),
        total_instance_count=pulumi.get(__ret__, 'total_instance_count'))
def get_capacity_reservation_output(id: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCapacityReservationResult]:
    """
    Resource Type definition for AWS::EC2::CapacityReservation


    :param str id: The ID of the Capacity Reservation.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ec2:getCapacityReservation', __args__, opts=opts, typ=GetCapacityReservationResult)
    return __ret__.apply(lambda __response__: GetCapacityReservationResult(
        available_instance_count=pulumi.get(__response__, 'available_instance_count'),
        end_date=pulumi.get(__response__, 'end_date'),
        end_date_type=pulumi.get(__response__, 'end_date_type'),
        id=pulumi.get(__response__, 'id'),
        instance_count=pulumi.get(__response__, 'instance_count'),
        instance_match_criteria=pulumi.get(__response__, 'instance_match_criteria'),
        total_instance_count=pulumi.get(__response__, 'total_instance_count')))
