# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GlobalTableAttributeDefinition',
    'GlobalTableCapacityAutoScalingSettings',
    'GlobalTableContributorInsightsSpecification',
    'GlobalTableGlobalSecondaryIndex',
    'GlobalTableKeySchema',
    'GlobalTableKinesisStreamSpecification',
    'GlobalTableLocalSecondaryIndex',
    'GlobalTablePointInTimeRecoverySpecification',
    'GlobalTableProjection',
    'GlobalTableReadOnDemandThroughputSettings',
    'GlobalTableReadProvisionedThroughputSettings',
    'GlobalTableReplicaGlobalSecondaryIndexSpecification',
    'GlobalTableReplicaSpecification',
    'GlobalTableReplicaSseSpecification',
    'GlobalTableReplicaStreamSpecification',
    'GlobalTableResourcePolicy',
    'GlobalTableSseSpecification',
    'GlobalTableStreamSpecification',
    'GlobalTableTag',
    'GlobalTableTargetTrackingScalingPolicyConfiguration',
    'GlobalTableTimeToLiveSpecification',
    'GlobalTableWriteOnDemandThroughputSettings',
    'GlobalTableWriteProvisionedThroughputSettings',
    'TableAttributeDefinition',
    'TableContributorInsightsSpecification',
    'TableCsv',
    'TableGlobalSecondaryIndex',
    'TableImportSourceSpecification',
    'TableInputFormatOptions',
    'TableKeySchema',
    'TableKinesisStreamSpecification',
    'TableLocalSecondaryIndex',
    'TableOnDemandThroughput',
    'TablePointInTimeRecoverySpecification',
    'TableProjection',
    'TableProvisionedThroughput',
    'TableResourcePolicy',
    'TableS3BucketSource',
    'TableSseSpecification',
    'TableStreamSpecification',
    'TableTimeToLiveSpecification',
]

@pulumi.output_type
class GlobalTableAttributeDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeName":
            suggest = "attribute_name"
        elif key == "attributeType":
            suggest = "attribute_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalTableAttributeDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalTableAttributeDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalTableAttributeDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute_name: str,
                 attribute_type: str):
        """
        :param str attribute_name: A name for the attribute.
        :param str attribute_type: The data type for the attribute, where:
               
               - `S` - the attribute is of type String
               - `N` - the attribute is of type Number
               - `B` - the attribute is of type Binary
        """
        pulumi.set(__self__, "attribute_name", attribute_name)
        pulumi.set(__self__, "attribute_type", attribute_type)

    @property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> str:
        """
        A name for the attribute.
        """
        return pulumi.get(self, "attribute_name")

    @property
    @pulumi.getter(name="attributeType")
    def attribute_type(self) -> str:
        """
        The data type for the attribute, where:

        - `S` - the attribute is of type String
        - `N` - the attribute is of type Number
        - `B` - the attribute is of type Binary
        """
        return pulumi.get(self, "attribute_type")


@pulumi.output_type
class GlobalTableCapacityAutoScalingSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxCapacity":
            suggest = "max_capacity"
        elif key == "minCapacity":
            suggest = "min_capacity"
        elif key == "targetTrackingScalingPolicyConfiguration":
            suggest = "target_tracking_scaling_policy_configuration"
        elif key == "seedCapacity":
            suggest = "seed_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalTableCapacityAutoScalingSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalTableCapacityAutoScalingSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalTableCapacityAutoScalingSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_capacity: int,
                 min_capacity: int,
                 target_tracking_scaling_policy_configuration: 'outputs.GlobalTableTargetTrackingScalingPolicyConfiguration',
                 seed_capacity: Optional[int] = None):
        """
        :param int max_capacity: The maximum provisioned capacity units for the global table.
        :param int min_capacity: The minimum provisioned capacity units for the global table.
        :param 'GlobalTableTargetTrackingScalingPolicyConfiguration' target_tracking_scaling_policy_configuration: Defines a target tracking scaling policy.
        :param int seed_capacity: When switching billing mode from `PAY_PER_REQUEST` to `PROVISIONED` , DynamoDB requires you to specify read and write capacity unit values for the table and for each global secondary index. These values will be applied to all replicas. The table will use these provisioned values until CloudFormation creates the autoscaling policies you configured in your template. CloudFormation cannot determine what capacity the table and its global secondary indexes will require in this time period, since they are application-dependent.
               
               If you want to switch a table's billing mode from `PAY_PER_REQUEST` to `PROVISIONED` , you must specify a value for this property for each autoscaled resource. If you specify different values for the same resource in different regions, CloudFormation will use the highest value found in either the `SeedCapacity` or `ReadCapacityUnits` properties. For example, if your global secondary index `myGSI` has a `SeedCapacity` of 10 in us-east-1 and a fixed `ReadCapacityUnits` of 20 in eu-west-1, CloudFormation will initially set the read capacity for `myGSI` to 20. Note that if you disable `ScaleIn` for `myGSI` in us-east-1, its read capacity units might not be set back to 10.
               
               You must also specify a value for `SeedCapacity` when you plan to switch a table's billing mode from `PROVISIONED` to `PAY_PER_REQUEST` , because CloudFormation might need to roll back the operation (reverting the billing mode to `PROVISIONED` ) and this cannot succeed without specifying a value for `SeedCapacity` .
        """
        pulumi.set(__self__, "max_capacity", max_capacity)
        pulumi.set(__self__, "min_capacity", min_capacity)
        pulumi.set(__self__, "target_tracking_scaling_policy_configuration", target_tracking_scaling_policy_configuration)
        if seed_capacity is not None:
            pulumi.set(__self__, "seed_capacity", seed_capacity)

    @property
    @pulumi.getter(name="maxCapacity")
    def max_capacity(self) -> int:
        """
        The maximum provisioned capacity units for the global table.
        """
        return pulumi.get(self, "max_capacity")

    @property
    @pulumi.getter(name="minCapacity")
    def min_capacity(self) -> int:
        """
        The minimum provisioned capacity units for the global table.
        """
        return pulumi.get(self, "min_capacity")

    @property
    @pulumi.getter(name="targetTrackingScalingPolicyConfiguration")
    def target_tracking_scaling_policy_configuration(self) -> 'outputs.GlobalTableTargetTrackingScalingPolicyConfiguration':
        """
        Defines a target tracking scaling policy.
        """
        return pulumi.get(self, "target_tracking_scaling_policy_configuration")

    @property
    @pulumi.getter(name="seedCapacity")
    def seed_capacity(self) -> Optional[int]:
        """
        When switching billing mode from `PAY_PER_REQUEST` to `PROVISIONED` , DynamoDB requires you to specify read and write capacity unit values for the table and for each global secondary index. These values will be applied to all replicas. The table will use these provisioned values until CloudFormation creates the autoscaling policies you configured in your template. CloudFormation cannot determine what capacity the table and its global secondary indexes will require in this time period, since they are application-dependent.

        If you want to switch a table's billing mode from `PAY_PER_REQUEST` to `PROVISIONED` , you must specify a value for this property for each autoscaled resource. If you specify different values for the same resource in different regions, CloudFormation will use the highest value found in either the `SeedCapacity` or `ReadCapacityUnits` properties. For example, if your global secondary index `myGSI` has a `SeedCapacity` of 10 in us-east-1 and a fixed `ReadCapacityUnits` of 20 in eu-west-1, CloudFormation will initially set the read capacity for `myGSI` to 20. Note that if you disable `ScaleIn` for `myGSI` in us-east-1, its read capacity units might not be set back to 10.

        You must also specify a value for `SeedCapacity` when you plan to switch a table's billing mode from `PROVISIONED` to `PAY_PER_REQUEST` , because CloudFormation might need to roll back the operation (reverting the billing mode to `PROVISIONED` ) and this cannot succeed without specifying a value for `SeedCapacity` .
        """
        return pulumi.get(self, "seed_capacity")


@pulumi.output_type
class GlobalTableContributorInsightsSpecification(dict):
    def __init__(__self__, *,
                 enabled: bool):
        """
        :param bool enabled: Indicates whether CloudWatch Contributor Insights are to be enabled (true) or disabled (false).
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Indicates whether CloudWatch Contributor Insights are to be enabled (true) or disabled (false).
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GlobalTableGlobalSecondaryIndex(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "indexName":
            suggest = "index_name"
        elif key == "keySchema":
            suggest = "key_schema"
        elif key == "writeOnDemandThroughputSettings":
            suggest = "write_on_demand_throughput_settings"
        elif key == "writeProvisionedThroughputSettings":
            suggest = "write_provisioned_throughput_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalTableGlobalSecondaryIndex. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalTableGlobalSecondaryIndex.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalTableGlobalSecondaryIndex.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index_name: str,
                 key_schema: Sequence['outputs.GlobalTableKeySchema'],
                 projection: 'outputs.GlobalTableProjection',
                 write_on_demand_throughput_settings: Optional['outputs.GlobalTableWriteOnDemandThroughputSettings'] = None,
                 write_provisioned_throughput_settings: Optional['outputs.GlobalTableWriteProvisionedThroughputSettings'] = None):
        """
        :param str index_name: The name of the global secondary index. The name must be unique among all other indexes on this table.
        :param Sequence['GlobalTableKeySchema'] key_schema: The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:
               
               - `HASH` - partition key
               - `RANGE` - sort key
               
               > The partition key of an item is also known as its *hash attribute* . The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
               > 
               > The sort key of an item is also known as its *range attribute* . The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
        :param 'GlobalTableProjection' projection: Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected.
        :param 'GlobalTableWriteOnDemandThroughputSettings' write_on_demand_throughput_settings: Sets the write request settings for a global table or a global secondary index. You must specify this setting if you set the `BillingMode` to `PAY_PER_REQUEST` .
        :param 'GlobalTableWriteProvisionedThroughputSettings' write_provisioned_throughput_settings: Defines write capacity settings for the global secondary index. You must specify a value for this property if the table's `BillingMode` is `PROVISIONED` . All replicas will have the same write capacity settings for this global secondary index.
        """
        pulumi.set(__self__, "index_name", index_name)
        pulumi.set(__self__, "key_schema", key_schema)
        pulumi.set(__self__, "projection", projection)
        if write_on_demand_throughput_settings is not None:
            pulumi.set(__self__, "write_on_demand_throughput_settings", write_on_demand_throughput_settings)
        if write_provisioned_throughput_settings is not None:
            pulumi.set(__self__, "write_provisioned_throughput_settings", write_provisioned_throughput_settings)

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> str:
        """
        The name of the global secondary index. The name must be unique among all other indexes on this table.
        """
        return pulumi.get(self, "index_name")

    @property
    @pulumi.getter(name="keySchema")
    def key_schema(self) -> Sequence['outputs.GlobalTableKeySchema']:
        """
        The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:

        - `HASH` - partition key
        - `RANGE` - sort key

        > The partition key of an item is also known as its *hash attribute* . The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
        > 
        > The sort key of an item is also known as its *range attribute* . The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
        """
        return pulumi.get(self, "key_schema")

    @property
    @pulumi.getter
    def projection(self) -> 'outputs.GlobalTableProjection':
        """
        Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected.
        """
        return pulumi.get(self, "projection")

    @property
    @pulumi.getter(name="writeOnDemandThroughputSettings")
    def write_on_demand_throughput_settings(self) -> Optional['outputs.GlobalTableWriteOnDemandThroughputSettings']:
        """
        Sets the write request settings for a global table or a global secondary index. You must specify this setting if you set the `BillingMode` to `PAY_PER_REQUEST` .
        """
        return pulumi.get(self, "write_on_demand_throughput_settings")

    @property
    @pulumi.getter(name="writeProvisionedThroughputSettings")
    def write_provisioned_throughput_settings(self) -> Optional['outputs.GlobalTableWriteProvisionedThroughputSettings']:
        """
        Defines write capacity settings for the global secondary index. You must specify a value for this property if the table's `BillingMode` is `PROVISIONED` . All replicas will have the same write capacity settings for this global secondary index.
        """
        return pulumi.get(self, "write_provisioned_throughput_settings")


@pulumi.output_type
class GlobalTableKeySchema(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeName":
            suggest = "attribute_name"
        elif key == "keyType":
            suggest = "key_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalTableKeySchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalTableKeySchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalTableKeySchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute_name: str,
                 key_type: str):
        """
        :param str attribute_name: The name of a key attribute.
        :param str key_type: The role that this key attribute will assume:
               
               - `HASH` - partition key
               - `RANGE` - sort key
               
               > The partition key of an item is also known as its *hash attribute* . The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
               > 
               > The sort key of an item is also known as its *range attribute* . The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
        """
        pulumi.set(__self__, "attribute_name", attribute_name)
        pulumi.set(__self__, "key_type", key_type)

    @property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> str:
        """
        The name of a key attribute.
        """
        return pulumi.get(self, "attribute_name")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> str:
        """
        The role that this key attribute will assume:

        - `HASH` - partition key
        - `RANGE` - sort key

        > The partition key of an item is also known as its *hash attribute* . The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
        > 
        > The sort key of an item is also known as its *range attribute* . The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
        """
        return pulumi.get(self, "key_type")


@pulumi.output_type
class GlobalTableKinesisStreamSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "streamArn":
            suggest = "stream_arn"
        elif key == "approximateCreationDateTimePrecision":
            suggest = "approximate_creation_date_time_precision"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalTableKinesisStreamSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalTableKinesisStreamSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalTableKinesisStreamSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 stream_arn: str,
                 approximate_creation_date_time_precision: Optional['GlobalTableKinesisStreamSpecificationApproximateCreationDateTimePrecision'] = None):
        """
        :param str stream_arn: The ARN for a specific Kinesis data stream.
        :param 'GlobalTableKinesisStreamSpecificationApproximateCreationDateTimePrecision' approximate_creation_date_time_precision: The precision for the time and date that the stream was created.
        """
        pulumi.set(__self__, "stream_arn", stream_arn)
        if approximate_creation_date_time_precision is not None:
            pulumi.set(__self__, "approximate_creation_date_time_precision", approximate_creation_date_time_precision)

    @property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> str:
        """
        The ARN for a specific Kinesis data stream.
        """
        return pulumi.get(self, "stream_arn")

    @property
    @pulumi.getter(name="approximateCreationDateTimePrecision")
    def approximate_creation_date_time_precision(self) -> Optional['GlobalTableKinesisStreamSpecificationApproximateCreationDateTimePrecision']:
        """
        The precision for the time and date that the stream was created.
        """
        return pulumi.get(self, "approximate_creation_date_time_precision")


@pulumi.output_type
class GlobalTableLocalSecondaryIndex(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "indexName":
            suggest = "index_name"
        elif key == "keySchema":
            suggest = "key_schema"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalTableLocalSecondaryIndex. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalTableLocalSecondaryIndex.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalTableLocalSecondaryIndex.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index_name: str,
                 key_schema: Sequence['outputs.GlobalTableKeySchema'],
                 projection: 'outputs.GlobalTableProjection'):
        """
        :param str index_name: The name of the local secondary index. The name must be unique among all other indexes on this table.
        :param Sequence['GlobalTableKeySchema'] key_schema: The complete key schema for the local secondary index, consisting of one or more pairs of attribute names and key types:
               
               - `HASH` - partition key
               - `RANGE` - sort key
               
               > The partition key of an item is also known as its *hash attribute* . The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
               > 
               > The sort key of an item is also known as its *range attribute* . The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
        :param 'GlobalTableProjection' projection: Represents attributes that are copied (projected) from the table into the local secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected.
        """
        pulumi.set(__self__, "index_name", index_name)
        pulumi.set(__self__, "key_schema", key_schema)
        pulumi.set(__self__, "projection", projection)

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> str:
        """
        The name of the local secondary index. The name must be unique among all other indexes on this table.
        """
        return pulumi.get(self, "index_name")

    @property
    @pulumi.getter(name="keySchema")
    def key_schema(self) -> Sequence['outputs.GlobalTableKeySchema']:
        """
        The complete key schema for the local secondary index, consisting of one or more pairs of attribute names and key types:

        - `HASH` - partition key
        - `RANGE` - sort key

        > The partition key of an item is also known as its *hash attribute* . The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
        > 
        > The sort key of an item is also known as its *range attribute* . The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
        """
        return pulumi.get(self, "key_schema")

    @property
    @pulumi.getter
    def projection(self) -> 'outputs.GlobalTableProjection':
        """
        Represents attributes that are copied (projected) from the table into the local secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected.
        """
        return pulumi.get(self, "projection")


@pulumi.output_type
class GlobalTablePointInTimeRecoverySpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pointInTimeRecoveryEnabled":
            suggest = "point_in_time_recovery_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalTablePointInTimeRecoverySpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalTablePointInTimeRecoverySpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalTablePointInTimeRecoverySpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 point_in_time_recovery_enabled: Optional[bool] = None):
        """
        :param bool point_in_time_recovery_enabled: Indicates whether point in time recovery is enabled (true) or disabled (false) on the table.
        """
        if point_in_time_recovery_enabled is not None:
            pulumi.set(__self__, "point_in_time_recovery_enabled", point_in_time_recovery_enabled)

    @property
    @pulumi.getter(name="pointInTimeRecoveryEnabled")
    def point_in_time_recovery_enabled(self) -> Optional[bool]:
        """
        Indicates whether point in time recovery is enabled (true) or disabled (false) on the table.
        """
        return pulumi.get(self, "point_in_time_recovery_enabled")


@pulumi.output_type
class GlobalTableProjection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nonKeyAttributes":
            suggest = "non_key_attributes"
        elif key == "projectionType":
            suggest = "projection_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalTableProjection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalTableProjection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalTableProjection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 non_key_attributes: Optional[Sequence[str]] = None,
                 projection_type: Optional[str] = None):
        """
        :param Sequence[str] non_key_attributes: Represents the non-key attribute names which will be projected into the index.
               
               For local secondary indexes, the total count of `NonKeyAttributes` summed across all of the local secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.
        :param str projection_type: The set of attributes that are projected into the index:
               
               - `KEYS_ONLY` - Only the index and primary keys are projected into the index.
               - `INCLUDE` - In addition to the attributes described in `KEYS_ONLY` , the secondary index will include other non-key attributes that you specify.
               - `ALL` - All of the table attributes are projected into the index.
               
               When using the DynamoDB console, `ALL` is selected by default.
        """
        if non_key_attributes is not None:
            pulumi.set(__self__, "non_key_attributes", non_key_attributes)
        if projection_type is not None:
            pulumi.set(__self__, "projection_type", projection_type)

    @property
    @pulumi.getter(name="nonKeyAttributes")
    def non_key_attributes(self) -> Optional[Sequence[str]]:
        """
        Represents the non-key attribute names which will be projected into the index.

        For local secondary indexes, the total count of `NonKeyAttributes` summed across all of the local secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.
        """
        return pulumi.get(self, "non_key_attributes")

    @property
    @pulumi.getter(name="projectionType")
    def projection_type(self) -> Optional[str]:
        """
        The set of attributes that are projected into the index:

        - `KEYS_ONLY` - Only the index and primary keys are projected into the index.
        - `INCLUDE` - In addition to the attributes described in `KEYS_ONLY` , the secondary index will include other non-key attributes that you specify.
        - `ALL` - All of the table attributes are projected into the index.

        When using the DynamoDB console, `ALL` is selected by default.
        """
        return pulumi.get(self, "projection_type")


@pulumi.output_type
class GlobalTableReadOnDemandThroughputSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxReadRequestUnits":
            suggest = "max_read_request_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalTableReadOnDemandThroughputSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalTableReadOnDemandThroughputSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalTableReadOnDemandThroughputSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_read_request_units: Optional[int] = None):
        """
        :param int max_read_request_units: Maximum number of read request units for the specified replica of a global table.
        """
        if max_read_request_units is not None:
            pulumi.set(__self__, "max_read_request_units", max_read_request_units)

    @property
    @pulumi.getter(name="maxReadRequestUnits")
    def max_read_request_units(self) -> Optional[int]:
        """
        Maximum number of read request units for the specified replica of a global table.
        """
        return pulumi.get(self, "max_read_request_units")


@pulumi.output_type
class GlobalTableReadProvisionedThroughputSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readCapacityAutoScalingSettings":
            suggest = "read_capacity_auto_scaling_settings"
        elif key == "readCapacityUnits":
            suggest = "read_capacity_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalTableReadProvisionedThroughputSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalTableReadProvisionedThroughputSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalTableReadProvisionedThroughputSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 read_capacity_auto_scaling_settings: Optional['outputs.GlobalTableCapacityAutoScalingSettings'] = None,
                 read_capacity_units: Optional[int] = None):
        """
        :param 'GlobalTableCapacityAutoScalingSettings' read_capacity_auto_scaling_settings: Specifies auto scaling settings for the replica table or global secondary index.
        :param int read_capacity_units: Specifies a fixed read capacity for the replica table or global secondary index.
        """
        if read_capacity_auto_scaling_settings is not None:
            pulumi.set(__self__, "read_capacity_auto_scaling_settings", read_capacity_auto_scaling_settings)
        if read_capacity_units is not None:
            pulumi.set(__self__, "read_capacity_units", read_capacity_units)

    @property
    @pulumi.getter(name="readCapacityAutoScalingSettings")
    def read_capacity_auto_scaling_settings(self) -> Optional['outputs.GlobalTableCapacityAutoScalingSettings']:
        """
        Specifies auto scaling settings for the replica table or global secondary index.
        """
        return pulumi.get(self, "read_capacity_auto_scaling_settings")

    @property
    @pulumi.getter(name="readCapacityUnits")
    def read_capacity_units(self) -> Optional[int]:
        """
        Specifies a fixed read capacity for the replica table or global secondary index.
        """
        return pulumi.get(self, "read_capacity_units")


@pulumi.output_type
class GlobalTableReplicaGlobalSecondaryIndexSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "indexName":
            suggest = "index_name"
        elif key == "contributorInsightsSpecification":
            suggest = "contributor_insights_specification"
        elif key == "readOnDemandThroughputSettings":
            suggest = "read_on_demand_throughput_settings"
        elif key == "readProvisionedThroughputSettings":
            suggest = "read_provisioned_throughput_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalTableReplicaGlobalSecondaryIndexSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalTableReplicaGlobalSecondaryIndexSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalTableReplicaGlobalSecondaryIndexSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index_name: str,
                 contributor_insights_specification: Optional['outputs.GlobalTableContributorInsightsSpecification'] = None,
                 read_on_demand_throughput_settings: Optional['outputs.GlobalTableReadOnDemandThroughputSettings'] = None,
                 read_provisioned_throughput_settings: Optional['outputs.GlobalTableReadProvisionedThroughputSettings'] = None):
        """
        :param str index_name: The name of the global secondary index. The name must be unique among all other indexes on this table.
        :param 'GlobalTableContributorInsightsSpecification' contributor_insights_specification: Updates the status for contributor insights for a specific table or index. CloudWatch Contributor Insights for DynamoDB graphs display the partition key and (if applicable) sort key of frequently accessed items and frequently throttled items in plaintext. If you require the use of AWS Key Management Service (KMS) to encrypt this table’s partition key and sort key data with an AWS managed key or customer managed key, you should not enable CloudWatch Contributor Insights for DynamoDB for this table.
        :param 'GlobalTableReadOnDemandThroughputSettings' read_on_demand_throughput_settings: Sets the read request settings for a replica global secondary index. You must specify this setting if you set the `BillingMode` to `PAY_PER_REQUEST` .
        :param 'GlobalTableReadProvisionedThroughputSettings' read_provisioned_throughput_settings: Allows you to specify the read capacity settings for a replica global secondary index when the `BillingMode` is set to `PROVISIONED` .
        """
        pulumi.set(__self__, "index_name", index_name)
        if contributor_insights_specification is not None:
            pulumi.set(__self__, "contributor_insights_specification", contributor_insights_specification)
        if read_on_demand_throughput_settings is not None:
            pulumi.set(__self__, "read_on_demand_throughput_settings", read_on_demand_throughput_settings)
        if read_provisioned_throughput_settings is not None:
            pulumi.set(__self__, "read_provisioned_throughput_settings", read_provisioned_throughput_settings)

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> str:
        """
        The name of the global secondary index. The name must be unique among all other indexes on this table.
        """
        return pulumi.get(self, "index_name")

    @property
    @pulumi.getter(name="contributorInsightsSpecification")
    def contributor_insights_specification(self) -> Optional['outputs.GlobalTableContributorInsightsSpecification']:
        """
        Updates the status for contributor insights for a specific table or index. CloudWatch Contributor Insights for DynamoDB graphs display the partition key and (if applicable) sort key of frequently accessed items and frequently throttled items in plaintext. If you require the use of AWS Key Management Service (KMS) to encrypt this table’s partition key and sort key data with an AWS managed key or customer managed key, you should not enable CloudWatch Contributor Insights for DynamoDB for this table.
        """
        return pulumi.get(self, "contributor_insights_specification")

    @property
    @pulumi.getter(name="readOnDemandThroughputSettings")
    def read_on_demand_throughput_settings(self) -> Optional['outputs.GlobalTableReadOnDemandThroughputSettings']:
        """
        Sets the read request settings for a replica global secondary index. You must specify this setting if you set the `BillingMode` to `PAY_PER_REQUEST` .
        """
        return pulumi.get(self, "read_on_demand_throughput_settings")

    @property
    @pulumi.getter(name="readProvisionedThroughputSettings")
    def read_provisioned_throughput_settings(self) -> Optional['outputs.GlobalTableReadProvisionedThroughputSettings']:
        """
        Allows you to specify the read capacity settings for a replica global secondary index when the `BillingMode` is set to `PROVISIONED` .
        """
        return pulumi.get(self, "read_provisioned_throughput_settings")


@pulumi.output_type
class GlobalTableReplicaSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contributorInsightsSpecification":
            suggest = "contributor_insights_specification"
        elif key == "deletionProtectionEnabled":
            suggest = "deletion_protection_enabled"
        elif key == "globalSecondaryIndexes":
            suggest = "global_secondary_indexes"
        elif key == "kinesisStreamSpecification":
            suggest = "kinesis_stream_specification"
        elif key == "pointInTimeRecoverySpecification":
            suggest = "point_in_time_recovery_specification"
        elif key == "readOnDemandThroughputSettings":
            suggest = "read_on_demand_throughput_settings"
        elif key == "readProvisionedThroughputSettings":
            suggest = "read_provisioned_throughput_settings"
        elif key == "replicaStreamSpecification":
            suggest = "replica_stream_specification"
        elif key == "resourcePolicy":
            suggest = "resource_policy"
        elif key == "sseSpecification":
            suggest = "sse_specification"
        elif key == "tableClass":
            suggest = "table_class"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalTableReplicaSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalTableReplicaSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalTableReplicaSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 region: str,
                 contributor_insights_specification: Optional['outputs.GlobalTableContributorInsightsSpecification'] = None,
                 deletion_protection_enabled: Optional[bool] = None,
                 global_secondary_indexes: Optional[Sequence['outputs.GlobalTableReplicaGlobalSecondaryIndexSpecification']] = None,
                 kinesis_stream_specification: Optional['outputs.GlobalTableKinesisStreamSpecification'] = None,
                 point_in_time_recovery_specification: Optional['outputs.GlobalTablePointInTimeRecoverySpecification'] = None,
                 read_on_demand_throughput_settings: Optional['outputs.GlobalTableReadOnDemandThroughputSettings'] = None,
                 read_provisioned_throughput_settings: Optional['outputs.GlobalTableReadProvisionedThroughputSettings'] = None,
                 replica_stream_specification: Optional['outputs.GlobalTableReplicaStreamSpecification'] = None,
                 resource_policy: Optional['outputs.GlobalTableResourcePolicy'] = None,
                 sse_specification: Optional['outputs.GlobalTableReplicaSseSpecification'] = None,
                 table_class: Optional[str] = None,
                 tags: Optional[Sequence['outputs.GlobalTableTag']] = None):
        """
        :param str region: The region in which this replica exists.
        :param 'GlobalTableContributorInsightsSpecification' contributor_insights_specification: The settings used to enable or disable CloudWatch Contributor Insights for the specified replica. When not specified, defaults to contributor insights disabled for the replica.
        :param bool deletion_protection_enabled: Determines if a replica is protected from deletion. When enabled, the table cannot be deleted by any user or process. This setting is disabled by default. For more information, see [Using deletion protection](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.Basics.html#WorkingWithTables.Basics.DeletionProtection) in the *Amazon DynamoDB Developer Guide* .
        :param Sequence['GlobalTableReplicaGlobalSecondaryIndexSpecification'] global_secondary_indexes: Defines additional settings for the global secondary indexes of this replica.
        :param 'GlobalTableKinesisStreamSpecification' kinesis_stream_specification: Defines the Kinesis Data Streams configuration for the specified replica.
        :param 'GlobalTablePointInTimeRecoverySpecification' point_in_time_recovery_specification: The settings used to enable point in time recovery. When not specified, defaults to point in time recovery disabled for the replica.
        :param 'GlobalTableReadOnDemandThroughputSettings' read_on_demand_throughput_settings: Sets read request settings for the replica table.
        :param 'GlobalTableReadProvisionedThroughputSettings' read_provisioned_throughput_settings: Defines read capacity settings for the replica table.
        :param 'GlobalTableReplicaStreamSpecification' replica_stream_specification: Represents the DynamoDB Streams configuration for a global table replica.
        :param 'GlobalTableResourcePolicy' resource_policy: A resource-based policy document that contains permissions to add to the specified replica of a DynamoDB global table. Resource-based policies let you define access permissions by specifying who has access to each resource, and the actions they are allowed to perform on each resource.
               
               In a CloudFormation template, you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to DynamoDB . For more information about resource-based policies, see [Using resource-based policies for DynamoDB](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html) and [Resource-based policy examples](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html) .
        :param 'GlobalTableReplicaSseSpecification' sse_specification: Allows you to specify a customer-managed key for the replica. When using customer-managed keys for server-side encryption, this property must have a value in all replicas.
        :param str table_class: The table class of the specified table. Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS` .
        :param Sequence['GlobalTableTag'] tags: An array of key-value pairs to apply to this replica.
               
               For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
        """
        pulumi.set(__self__, "region", region)
        if contributor_insights_specification is not None:
            pulumi.set(__self__, "contributor_insights_specification", contributor_insights_specification)
        if deletion_protection_enabled is not None:
            pulumi.set(__self__, "deletion_protection_enabled", deletion_protection_enabled)
        if global_secondary_indexes is not None:
            pulumi.set(__self__, "global_secondary_indexes", global_secondary_indexes)
        if kinesis_stream_specification is not None:
            pulumi.set(__self__, "kinesis_stream_specification", kinesis_stream_specification)
        if point_in_time_recovery_specification is not None:
            pulumi.set(__self__, "point_in_time_recovery_specification", point_in_time_recovery_specification)
        if read_on_demand_throughput_settings is not None:
            pulumi.set(__self__, "read_on_demand_throughput_settings", read_on_demand_throughput_settings)
        if read_provisioned_throughput_settings is not None:
            pulumi.set(__self__, "read_provisioned_throughput_settings", read_provisioned_throughput_settings)
        if replica_stream_specification is not None:
            pulumi.set(__self__, "replica_stream_specification", replica_stream_specification)
        if resource_policy is not None:
            pulumi.set(__self__, "resource_policy", resource_policy)
        if sse_specification is not None:
            pulumi.set(__self__, "sse_specification", sse_specification)
        if table_class is not None:
            pulumi.set(__self__, "table_class", table_class)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region in which this replica exists.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="contributorInsightsSpecification")
    def contributor_insights_specification(self) -> Optional['outputs.GlobalTableContributorInsightsSpecification']:
        """
        The settings used to enable or disable CloudWatch Contributor Insights for the specified replica. When not specified, defaults to contributor insights disabled for the replica.
        """
        return pulumi.get(self, "contributor_insights_specification")

    @property
    @pulumi.getter(name="deletionProtectionEnabled")
    def deletion_protection_enabled(self) -> Optional[bool]:
        """
        Determines if a replica is protected from deletion. When enabled, the table cannot be deleted by any user or process. This setting is disabled by default. For more information, see [Using deletion protection](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.Basics.html#WorkingWithTables.Basics.DeletionProtection) in the *Amazon DynamoDB Developer Guide* .
        """
        return pulumi.get(self, "deletion_protection_enabled")

    @property
    @pulumi.getter(name="globalSecondaryIndexes")
    def global_secondary_indexes(self) -> Optional[Sequence['outputs.GlobalTableReplicaGlobalSecondaryIndexSpecification']]:
        """
        Defines additional settings for the global secondary indexes of this replica.
        """
        return pulumi.get(self, "global_secondary_indexes")

    @property
    @pulumi.getter(name="kinesisStreamSpecification")
    def kinesis_stream_specification(self) -> Optional['outputs.GlobalTableKinesisStreamSpecification']:
        """
        Defines the Kinesis Data Streams configuration for the specified replica.
        """
        return pulumi.get(self, "kinesis_stream_specification")

    @property
    @pulumi.getter(name="pointInTimeRecoverySpecification")
    def point_in_time_recovery_specification(self) -> Optional['outputs.GlobalTablePointInTimeRecoverySpecification']:
        """
        The settings used to enable point in time recovery. When not specified, defaults to point in time recovery disabled for the replica.
        """
        return pulumi.get(self, "point_in_time_recovery_specification")

    @property
    @pulumi.getter(name="readOnDemandThroughputSettings")
    def read_on_demand_throughput_settings(self) -> Optional['outputs.GlobalTableReadOnDemandThroughputSettings']:
        """
        Sets read request settings for the replica table.
        """
        return pulumi.get(self, "read_on_demand_throughput_settings")

    @property
    @pulumi.getter(name="readProvisionedThroughputSettings")
    def read_provisioned_throughput_settings(self) -> Optional['outputs.GlobalTableReadProvisionedThroughputSettings']:
        """
        Defines read capacity settings for the replica table.
        """
        return pulumi.get(self, "read_provisioned_throughput_settings")

    @property
    @pulumi.getter(name="replicaStreamSpecification")
    def replica_stream_specification(self) -> Optional['outputs.GlobalTableReplicaStreamSpecification']:
        """
        Represents the DynamoDB Streams configuration for a global table replica.
        """
        return pulumi.get(self, "replica_stream_specification")

    @property
    @pulumi.getter(name="resourcePolicy")
    def resource_policy(self) -> Optional['outputs.GlobalTableResourcePolicy']:
        """
        A resource-based policy document that contains permissions to add to the specified replica of a DynamoDB global table. Resource-based policies let you define access permissions by specifying who has access to each resource, and the actions they are allowed to perform on each resource.

        In a CloudFormation template, you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to DynamoDB . For more information about resource-based policies, see [Using resource-based policies for DynamoDB](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html) and [Resource-based policy examples](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html) .
        """
        return pulumi.get(self, "resource_policy")

    @property
    @pulumi.getter(name="sseSpecification")
    def sse_specification(self) -> Optional['outputs.GlobalTableReplicaSseSpecification']:
        """
        Allows you to specify a customer-managed key for the replica. When using customer-managed keys for server-side encryption, this property must have a value in all replicas.
        """
        return pulumi.get(self, "sse_specification")

    @property
    @pulumi.getter(name="tableClass")
    def table_class(self) -> Optional[str]:
        """
        The table class of the specified table. Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS` .
        """
        return pulumi.get(self, "table_class")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.GlobalTableTag']]:
        """
        An array of key-value pairs to apply to this replica.

        For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GlobalTableReplicaSseSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsMasterKeyId":
            suggest = "kms_master_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalTableReplicaSseSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalTableReplicaSseSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalTableReplicaSseSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_master_key_id: str):
        """
        :param str kms_master_key_id: The AWS KMS key that should be used for the AWS KMS encryption. To specify a key, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is different from the default DynamoDB key `alias/aws/dynamodb` .
        """
        pulumi.set(__self__, "kms_master_key_id", kms_master_key_id)

    @property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> str:
        """
        The AWS KMS key that should be used for the AWS KMS encryption. To specify a key, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is different from the default DynamoDB key `alias/aws/dynamodb` .
        """
        return pulumi.get(self, "kms_master_key_id")


@pulumi.output_type
class GlobalTableReplicaStreamSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourcePolicy":
            suggest = "resource_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalTableReplicaStreamSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalTableReplicaStreamSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalTableReplicaStreamSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_policy: 'outputs.GlobalTableResourcePolicy'):
        """
        :param 'GlobalTableResourcePolicy' resource_policy: A resource-based policy document that contains the permissions for the specified stream of a DynamoDB global table replica. Resource-based policies let you define access permissions by specifying who has access to each resource, and the actions they are allowed to perform on each resource.
               
               In a CloudFormation template, you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to DynamoDB . For more information about resource-based policies, see [Using resource-based policies for DynamoDB](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html) and [Resource-based policy examples](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html) .
               
               You can update the `ResourcePolicy` property if you've specified more than one table using the [AWS ::DynamoDB::GlobalTable](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html) resource.
        """
        pulumi.set(__self__, "resource_policy", resource_policy)

    @property
    @pulumi.getter(name="resourcePolicy")
    def resource_policy(self) -> 'outputs.GlobalTableResourcePolicy':
        """
        A resource-based policy document that contains the permissions for the specified stream of a DynamoDB global table replica. Resource-based policies let you define access permissions by specifying who has access to each resource, and the actions they are allowed to perform on each resource.

        In a CloudFormation template, you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to DynamoDB . For more information about resource-based policies, see [Using resource-based policies for DynamoDB](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html) and [Resource-based policy examples](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html) .

        You can update the `ResourcePolicy` property if you've specified more than one table using the [AWS ::DynamoDB::GlobalTable](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html) resource.
        """
        return pulumi.get(self, "resource_policy")


@pulumi.output_type
class GlobalTableResourcePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyDocument":
            suggest = "policy_document"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalTableResourcePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalTableResourcePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalTableResourcePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_document: Any):
        """
        :param Any policy_document: A resource-based policy document that contains permissions to add to the specified DynamoDB table, its indexes, and stream. In a CloudFormation template, you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to DynamoDB . For more information about resource-based policies, see [Using resource-based policies for DynamoDB](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html) and [Resource-based policy examples](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html) .
        """
        pulumi.set(__self__, "policy_document", policy_document)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Any:
        """
        A resource-based policy document that contains permissions to add to the specified DynamoDB table, its indexes, and stream. In a CloudFormation template, you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to DynamoDB . For more information about resource-based policies, see [Using resource-based policies for DynamoDB](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html) and [Resource-based policy examples](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html) .
        """
        return pulumi.get(self, "policy_document")


@pulumi.output_type
class GlobalTableSseSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sseEnabled":
            suggest = "sse_enabled"
        elif key == "sseType":
            suggest = "sse_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalTableSseSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalTableSseSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalTableSseSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sse_enabled: bool,
                 sse_type: Optional[str] = None):
        """
        :param bool sse_enabled: Indicates whether server-side encryption is performed using an AWS managed key or an AWS owned key. If enabled (true), server-side encryption type is set to KMS and an AWS managed key is used ( AWS KMS charges apply). If disabled (false) or not specified,server-side encryption is set to an AWS owned key. If you choose to use KMS encryption, you can also use customer managed KMS keys by specifying them in the `ReplicaSpecification.SSESpecification` object. You cannot mix AWS managed and customer managed KMS keys.
        :param str sse_type: Server-side encryption type. The only supported value is:
               
               - `KMS` - Server-side encryption that uses AWS Key Management Service . The key is stored in your account and is managed by AWS KMS ( AWS KMS charges apply).
        """
        pulumi.set(__self__, "sse_enabled", sse_enabled)
        if sse_type is not None:
            pulumi.set(__self__, "sse_type", sse_type)

    @property
    @pulumi.getter(name="sseEnabled")
    def sse_enabled(self) -> bool:
        """
        Indicates whether server-side encryption is performed using an AWS managed key or an AWS owned key. If enabled (true), server-side encryption type is set to KMS and an AWS managed key is used ( AWS KMS charges apply). If disabled (false) or not specified,server-side encryption is set to an AWS owned key. If you choose to use KMS encryption, you can also use customer managed KMS keys by specifying them in the `ReplicaSpecification.SSESpecification` object. You cannot mix AWS managed and customer managed KMS keys.
        """
        return pulumi.get(self, "sse_enabled")

    @property
    @pulumi.getter(name="sseType")
    def sse_type(self) -> Optional[str]:
        """
        Server-side encryption type. The only supported value is:

        - `KMS` - Server-side encryption that uses AWS Key Management Service . The key is stored in your account and is managed by AWS KMS ( AWS KMS charges apply).
        """
        return pulumi.get(self, "sse_type")


@pulumi.output_type
class GlobalTableStreamSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "streamViewType":
            suggest = "stream_view_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalTableStreamSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalTableStreamSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalTableStreamSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 stream_view_type: str):
        """
        :param str stream_view_type: When an item in the table is modified, `StreamViewType` determines what information is written to the stream for this table. Valid values for `StreamViewType` are:
               
               - `KEYS_ONLY` - Only the key attributes of the modified item are written to the stream.
               - `NEW_IMAGE` - The entire item, as it appears after it was modified, is written to the stream.
               - `OLD_IMAGE` - The entire item, as it appeared before it was modified, is written to the stream.
               - `NEW_AND_OLD_IMAGES` - Both the new and the old item images of the item are written to the stream.
        """
        pulumi.set(__self__, "stream_view_type", stream_view_type)

    @property
    @pulumi.getter(name="streamViewType")
    def stream_view_type(self) -> str:
        """
        When an item in the table is modified, `StreamViewType` determines what information is written to the stream for this table. Valid values for `StreamViewType` are:

        - `KEYS_ONLY` - Only the key attributes of the modified item are written to the stream.
        - `NEW_IMAGE` - The entire item, as it appears after it was modified, is written to the stream.
        - `OLD_IMAGE` - The entire item, as it appeared before it was modified, is written to the stream.
        - `NEW_AND_OLD_IMAGES` - Both the new and the old item images of the item are written to the stream.
        """
        return pulumi.get(self, "stream_view_type")


@pulumi.output_type
class GlobalTableTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The key of the tag. Tag keys are case sensitive. Each DynamoDB table can only have up to one tag with the same key. If you try to add an existing tag (same key), the existing tag value will be updated to the new value.
        :param str value: The value of the tag. Tag values are case-sensitive and can be null.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key of the tag. Tag keys are case sensitive. Each DynamoDB table can only have up to one tag with the same key. If you try to add an existing tag (same key), the existing tag value will be updated to the new value.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the tag. Tag values are case-sensitive and can be null.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GlobalTableTargetTrackingScalingPolicyConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetValue":
            suggest = "target_value"
        elif key == "disableScaleIn":
            suggest = "disable_scale_in"
        elif key == "scaleInCooldown":
            suggest = "scale_in_cooldown"
        elif key == "scaleOutCooldown":
            suggest = "scale_out_cooldown"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalTableTargetTrackingScalingPolicyConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalTableTargetTrackingScalingPolicyConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalTableTargetTrackingScalingPolicyConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_value: float,
                 disable_scale_in: Optional[bool] = None,
                 scale_in_cooldown: Optional[int] = None,
                 scale_out_cooldown: Optional[int] = None):
        """
        :param float target_value: Defines a target value for the scaling policy.
        :param bool disable_scale_in: Indicates whether scale in by the target tracking scaling policy is disabled. The default value is `false` .
        :param int scale_in_cooldown: The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start.
        :param int scale_out_cooldown: The amount of time, in seconds, after a scale-out activity completes before another scale-out activity can start.
        """
        pulumi.set(__self__, "target_value", target_value)
        if disable_scale_in is not None:
            pulumi.set(__self__, "disable_scale_in", disable_scale_in)
        if scale_in_cooldown is not None:
            pulumi.set(__self__, "scale_in_cooldown", scale_in_cooldown)
        if scale_out_cooldown is not None:
            pulumi.set(__self__, "scale_out_cooldown", scale_out_cooldown)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> float:
        """
        Defines a target value for the scaling policy.
        """
        return pulumi.get(self, "target_value")

    @property
    @pulumi.getter(name="disableScaleIn")
    def disable_scale_in(self) -> Optional[bool]:
        """
        Indicates whether scale in by the target tracking scaling policy is disabled. The default value is `false` .
        """
        return pulumi.get(self, "disable_scale_in")

    @property
    @pulumi.getter(name="scaleInCooldown")
    def scale_in_cooldown(self) -> Optional[int]:
        """
        The amount of time, in seconds, after a scale-in activity completes before another scale-in activity can start.
        """
        return pulumi.get(self, "scale_in_cooldown")

    @property
    @pulumi.getter(name="scaleOutCooldown")
    def scale_out_cooldown(self) -> Optional[int]:
        """
        The amount of time, in seconds, after a scale-out activity completes before another scale-out activity can start.
        """
        return pulumi.get(self, "scale_out_cooldown")


@pulumi.output_type
class GlobalTableTimeToLiveSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeName":
            suggest = "attribute_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalTableTimeToLiveSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalTableTimeToLiveSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalTableTimeToLiveSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 attribute_name: Optional[str] = None):
        """
        :param bool enabled: Indicates whether TTL is to be enabled (true) or disabled (false) on the table.
        :param str attribute_name: The name of the attribute used to store the expiration time for items in the table.
               
               Currently, you cannot directly change the attribute name used to evaluate time to live. In order to do so, you must first disable time to live, and then re-enable it with the new attribute name. It can take up to one hour for changes to time to live to take effect. If you attempt to modify time to live within that time window, your stack operation might be delayed.
        """
        pulumi.set(__self__, "enabled", enabled)
        if attribute_name is not None:
            pulumi.set(__self__, "attribute_name", attribute_name)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Indicates whether TTL is to be enabled (true) or disabled (false) on the table.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> Optional[str]:
        """
        The name of the attribute used to store the expiration time for items in the table.

        Currently, you cannot directly change the attribute name used to evaluate time to live. In order to do so, you must first disable time to live, and then re-enable it with the new attribute name. It can take up to one hour for changes to time to live to take effect. If you attempt to modify time to live within that time window, your stack operation might be delayed.
        """
        return pulumi.get(self, "attribute_name")


@pulumi.output_type
class GlobalTableWriteOnDemandThroughputSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxWriteRequestUnits":
            suggest = "max_write_request_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalTableWriteOnDemandThroughputSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalTableWriteOnDemandThroughputSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalTableWriteOnDemandThroughputSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_write_request_units: Optional[int] = None):
        """
        :param int max_write_request_units: Maximum number of write request settings for the specified replica of a global table.
        """
        if max_write_request_units is not None:
            pulumi.set(__self__, "max_write_request_units", max_write_request_units)

    @property
    @pulumi.getter(name="maxWriteRequestUnits")
    def max_write_request_units(self) -> Optional[int]:
        """
        Maximum number of write request settings for the specified replica of a global table.
        """
        return pulumi.get(self, "max_write_request_units")


@pulumi.output_type
class GlobalTableWriteProvisionedThroughputSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "writeCapacityAutoScalingSettings":
            suggest = "write_capacity_auto_scaling_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlobalTableWriteProvisionedThroughputSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlobalTableWriteProvisionedThroughputSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlobalTableWriteProvisionedThroughputSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 write_capacity_auto_scaling_settings: Optional['outputs.GlobalTableCapacityAutoScalingSettings'] = None):
        """
        :param 'GlobalTableCapacityAutoScalingSettings' write_capacity_auto_scaling_settings: Specifies auto scaling settings for the replica table or global secondary index.
        """
        if write_capacity_auto_scaling_settings is not None:
            pulumi.set(__self__, "write_capacity_auto_scaling_settings", write_capacity_auto_scaling_settings)

    @property
    @pulumi.getter(name="writeCapacityAutoScalingSettings")
    def write_capacity_auto_scaling_settings(self) -> Optional['outputs.GlobalTableCapacityAutoScalingSettings']:
        """
        Specifies auto scaling settings for the replica table or global secondary index.
        """
        return pulumi.get(self, "write_capacity_auto_scaling_settings")


@pulumi.output_type
class TableAttributeDefinition(dict):
    """
    Represents an attribute for describing the schema for the table and indexes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeName":
            suggest = "attribute_name"
        elif key == "attributeType":
            suggest = "attribute_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableAttributeDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableAttributeDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableAttributeDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute_name: str,
                 attribute_type: str):
        """
        Represents an attribute for describing the schema for the table and indexes.
        :param str attribute_name: A name for the attribute.
        :param str attribute_type: The data type for the attribute, where:
                 +   ``S`` - the attribute is of type String
                 +   ``N`` - the attribute is of type Number
                 +   ``B`` - the attribute is of type Binary
        """
        pulumi.set(__self__, "attribute_name", attribute_name)
        pulumi.set(__self__, "attribute_type", attribute_type)

    @property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> str:
        """
        A name for the attribute.
        """
        return pulumi.get(self, "attribute_name")

    @property
    @pulumi.getter(name="attributeType")
    def attribute_type(self) -> str:
        """
        The data type for the attribute, where:
          +   ``S`` - the attribute is of type String
          +   ``N`` - the attribute is of type Number
          +   ``B`` - the attribute is of type Binary
        """
        return pulumi.get(self, "attribute_type")


@pulumi.output_type
class TableContributorInsightsSpecification(dict):
    """
    The settings used to enable or disable CloudWatch Contributor Insights.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        The settings used to enable or disable CloudWatch Contributor Insights.
        :param bool enabled: Indicates whether CloudWatch Contributor Insights are to be enabled (true) or disabled (false).
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Indicates whether CloudWatch Contributor Insights are to be enabled (true) or disabled (false).
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class TableCsv(dict):
    """
    The options for imported source files in CSV format. The values are Delimiter and HeaderList.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerList":
            suggest = "header_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableCsv. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableCsv.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableCsv.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delimiter: Optional[str] = None,
                 header_list: Optional[Sequence[str]] = None):
        """
        The options for imported source files in CSV format. The values are Delimiter and HeaderList.
        :param str delimiter: The delimiter used for separating items in the CSV file being imported.
        :param Sequence[str] header_list: List of the headers used to specify a common header for all source CSV files being imported. If this field is specified then the first line of each CSV file is treated as data instead of the header. If this field is not specified the the first line of each CSV file is treated as the header.
        """
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if header_list is not None:
            pulumi.set(__self__, "header_list", header_list)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[str]:
        """
        The delimiter used for separating items in the CSV file being imported.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter(name="headerList")
    def header_list(self) -> Optional[Sequence[str]]:
        """
        List of the headers used to specify a common header for all source CSV files being imported. If this field is specified then the first line of each CSV file is treated as data instead of the header. If this field is not specified the the first line of each CSV file is treated as the header.
        """
        return pulumi.get(self, "header_list")


@pulumi.output_type
class TableGlobalSecondaryIndex(dict):
    """
    Represents the properties of a global secondary index.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "indexName":
            suggest = "index_name"
        elif key == "keySchema":
            suggest = "key_schema"
        elif key == "contributorInsightsSpecification":
            suggest = "contributor_insights_specification"
        elif key == "onDemandThroughput":
            suggest = "on_demand_throughput"
        elif key == "provisionedThroughput":
            suggest = "provisioned_throughput"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableGlobalSecondaryIndex. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableGlobalSecondaryIndex.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableGlobalSecondaryIndex.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index_name: str,
                 key_schema: Sequence['outputs.TableKeySchema'],
                 projection: 'outputs.TableProjection',
                 contributor_insights_specification: Optional['outputs.TableContributorInsightsSpecification'] = None,
                 on_demand_throughput: Optional['outputs.TableOnDemandThroughput'] = None,
                 provisioned_throughput: Optional['outputs.TableProvisionedThroughput'] = None):
        """
        Represents the properties of a global secondary index.
        :param str index_name: The name of the global secondary index. The name must be unique among all other indexes on this table.
        :param Sequence['TableKeySchema'] key_schema: The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:
                 +   ``HASH`` - partition key
                 +   ``RANGE`` - sort key
                 
                 The partition key of an item is also known as its *hash attribute*. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
                The sort key of an item is also known as its *range attribute*. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
        :param 'TableProjection' projection: Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected.
        :param 'TableContributorInsightsSpecification' contributor_insights_specification: The settings used to enable or disable CloudWatch Contributor Insights for the specified global secondary index.
        :param 'TableOnDemandThroughput' on_demand_throughput: The maximum number of read and write units for the specified global secondary index. If you use this parameter, you must specify ``MaxReadRequestUnits``, ``MaxWriteRequestUnits``, or both.
        :param 'TableProvisionedThroughput' provisioned_throughput: Represents the provisioned throughput settings for the specified global secondary index.
                For current minimum and maximum provisioned throughput values, see [Service, Account, and Table Quotas](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html) in the *Amazon DynamoDB Developer Guide*.
        """
        pulumi.set(__self__, "index_name", index_name)
        pulumi.set(__self__, "key_schema", key_schema)
        pulumi.set(__self__, "projection", projection)
        if contributor_insights_specification is not None:
            pulumi.set(__self__, "contributor_insights_specification", contributor_insights_specification)
        if on_demand_throughput is not None:
            pulumi.set(__self__, "on_demand_throughput", on_demand_throughput)
        if provisioned_throughput is not None:
            pulumi.set(__self__, "provisioned_throughput", provisioned_throughput)

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> str:
        """
        The name of the global secondary index. The name must be unique among all other indexes on this table.
        """
        return pulumi.get(self, "index_name")

    @property
    @pulumi.getter(name="keySchema")
    def key_schema(self) -> Sequence['outputs.TableKeySchema']:
        """
        The complete key schema for a global secondary index, which consists of one or more pairs of attribute names and key types:
          +   ``HASH`` - partition key
          +   ``RANGE`` - sort key
          
          The partition key of an item is also known as its *hash attribute*. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
         The sort key of an item is also known as its *range attribute*. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
        """
        return pulumi.get(self, "key_schema")

    @property
    @pulumi.getter
    def projection(self) -> 'outputs.TableProjection':
        """
        Represents attributes that are copied (projected) from the table into the global secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected.
        """
        return pulumi.get(self, "projection")

    @property
    @pulumi.getter(name="contributorInsightsSpecification")
    def contributor_insights_specification(self) -> Optional['outputs.TableContributorInsightsSpecification']:
        """
        The settings used to enable or disable CloudWatch Contributor Insights for the specified global secondary index.
        """
        return pulumi.get(self, "contributor_insights_specification")

    @property
    @pulumi.getter(name="onDemandThroughput")
    def on_demand_throughput(self) -> Optional['outputs.TableOnDemandThroughput']:
        """
        The maximum number of read and write units for the specified global secondary index. If you use this parameter, you must specify ``MaxReadRequestUnits``, ``MaxWriteRequestUnits``, or both.
        """
        return pulumi.get(self, "on_demand_throughput")

    @property
    @pulumi.getter(name="provisionedThroughput")
    def provisioned_throughput(self) -> Optional['outputs.TableProvisionedThroughput']:
        """
        Represents the provisioned throughput settings for the specified global secondary index.
         For current minimum and maximum provisioned throughput values, see [Service, Account, and Table Quotas](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html) in the *Amazon DynamoDB Developer Guide*.
        """
        return pulumi.get(self, "provisioned_throughput")


@pulumi.output_type
class TableImportSourceSpecification(dict):
    """
    Specifies the properties of data being imported from the S3 bucket source to the table.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputFormat":
            suggest = "input_format"
        elif key == "s3BucketSource":
            suggest = "s3_bucket_source"
        elif key == "inputCompressionType":
            suggest = "input_compression_type"
        elif key == "inputFormatOptions":
            suggest = "input_format_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableImportSourceSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableImportSourceSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableImportSourceSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_format: str,
                 s3_bucket_source: 'outputs.TableS3BucketSource',
                 input_compression_type: Optional[str] = None,
                 input_format_options: Optional['outputs.TableInputFormatOptions'] = None):
        """
        Specifies the properties of data being imported from the S3 bucket source to the table.
        :param str input_format: The format of the source data. Valid values for ``ImportFormat`` are ``CSV``, ``DYNAMODB_JSON`` or ``ION``.
        :param 'TableS3BucketSource' s3_bucket_source: The S3 bucket that provides the source for the import.
        :param str input_compression_type: Type of compression to be used on the input coming from the imported table.
        :param 'TableInputFormatOptions' input_format_options: Additional properties that specify how the input is formatted,
        """
        pulumi.set(__self__, "input_format", input_format)
        pulumi.set(__self__, "s3_bucket_source", s3_bucket_source)
        if input_compression_type is not None:
            pulumi.set(__self__, "input_compression_type", input_compression_type)
        if input_format_options is not None:
            pulumi.set(__self__, "input_format_options", input_format_options)

    @property
    @pulumi.getter(name="inputFormat")
    def input_format(self) -> str:
        """
        The format of the source data. Valid values for ``ImportFormat`` are ``CSV``, ``DYNAMODB_JSON`` or ``ION``.
        """
        return pulumi.get(self, "input_format")

    @property
    @pulumi.getter(name="s3BucketSource")
    def s3_bucket_source(self) -> 'outputs.TableS3BucketSource':
        """
        The S3 bucket that provides the source for the import.
        """
        return pulumi.get(self, "s3_bucket_source")

    @property
    @pulumi.getter(name="inputCompressionType")
    def input_compression_type(self) -> Optional[str]:
        """
        Type of compression to be used on the input coming from the imported table.
        """
        return pulumi.get(self, "input_compression_type")

    @property
    @pulumi.getter(name="inputFormatOptions")
    def input_format_options(self) -> Optional['outputs.TableInputFormatOptions']:
        """
        Additional properties that specify how the input is formatted,
        """
        return pulumi.get(self, "input_format_options")


@pulumi.output_type
class TableInputFormatOptions(dict):
    """
    The format options for the data that was imported into the target table. There is one value, CsvOption.
    """
    def __init__(__self__, *,
                 csv: Optional['outputs.TableCsv'] = None):
        """
        The format options for the data that was imported into the target table. There is one value, CsvOption.
        :param 'TableCsv' csv: The options for imported source files in CSV format. The values are Delimiter and HeaderList.
        """
        if csv is not None:
            pulumi.set(__self__, "csv", csv)

    @property
    @pulumi.getter
    def csv(self) -> Optional['outputs.TableCsv']:
        """
        The options for imported source files in CSV format. The values are Delimiter and HeaderList.
        """
        return pulumi.get(self, "csv")


@pulumi.output_type
class TableKeySchema(dict):
    """
    Represents *a single element* of a key schema. A key schema specifies the attributes that make up the primary key of a table, or the key attributes of an index.
     A ``KeySchemaElement`` represents exactly one attribute of the primary key. For example, a simple primary key would be represented by one ``KeySchemaElement`` (for the partition key). A composite primary key would require one ``KeySchemaElement`` for the partition key, and another ``KeySchemaElement`` for the sort key.
     A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested attribute). The data type must be one of String, Number, or Binary. The attribute cannot be nested within a List or a Map.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeName":
            suggest = "attribute_name"
        elif key == "keyType":
            suggest = "key_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableKeySchema. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableKeySchema.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableKeySchema.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute_name: str,
                 key_type: str):
        """
        Represents *a single element* of a key schema. A key schema specifies the attributes that make up the primary key of a table, or the key attributes of an index.
         A ``KeySchemaElement`` represents exactly one attribute of the primary key. For example, a simple primary key would be represented by one ``KeySchemaElement`` (for the partition key). A composite primary key would require one ``KeySchemaElement`` for the partition key, and another ``KeySchemaElement`` for the sort key.
         A ``KeySchemaElement`` must be a scalar, top-level attribute (not a nested attribute). The data type must be one of String, Number, or Binary. The attribute cannot be nested within a List or a Map.
        :param str attribute_name: The name of a key attribute.
        :param str key_type: The role that this key attribute will assume:
                 +   ``HASH`` - partition key
                 +   ``RANGE`` - sort key
                 
                 The partition key of an item is also known as its *hash attribute*. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
                The sort key of an item is also known as its *range attribute*. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
        """
        pulumi.set(__self__, "attribute_name", attribute_name)
        pulumi.set(__self__, "key_type", key_type)

    @property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> str:
        """
        The name of a key attribute.
        """
        return pulumi.get(self, "attribute_name")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> str:
        """
        The role that this key attribute will assume:
          +   ``HASH`` - partition key
          +   ``RANGE`` - sort key
          
          The partition key of an item is also known as its *hash attribute*. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
         The sort key of an item is also known as its *range attribute*. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
        """
        return pulumi.get(self, "key_type")


@pulumi.output_type
class TableKinesisStreamSpecification(dict):
    """
    The Kinesis Data Streams configuration for the specified table.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "streamArn":
            suggest = "stream_arn"
        elif key == "approximateCreationDateTimePrecision":
            suggest = "approximate_creation_date_time_precision"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableKinesisStreamSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableKinesisStreamSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableKinesisStreamSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 stream_arn: str,
                 approximate_creation_date_time_precision: Optional['TableKinesisStreamSpecificationApproximateCreationDateTimePrecision'] = None):
        """
        The Kinesis Data Streams configuration for the specified table.
        :param str stream_arn: The ARN for a specific Kinesis data stream.
                Length Constraints: Minimum length of 37. Maximum length of 1024.
        :param 'TableKinesisStreamSpecificationApproximateCreationDateTimePrecision' approximate_creation_date_time_precision: The precision for the time and date that the stream was created.
        """
        pulumi.set(__self__, "stream_arn", stream_arn)
        if approximate_creation_date_time_precision is not None:
            pulumi.set(__self__, "approximate_creation_date_time_precision", approximate_creation_date_time_precision)

    @property
    @pulumi.getter(name="streamArn")
    def stream_arn(self) -> str:
        """
        The ARN for a specific Kinesis data stream.
         Length Constraints: Minimum length of 37. Maximum length of 1024.
        """
        return pulumi.get(self, "stream_arn")

    @property
    @pulumi.getter(name="approximateCreationDateTimePrecision")
    def approximate_creation_date_time_precision(self) -> Optional['TableKinesisStreamSpecificationApproximateCreationDateTimePrecision']:
        """
        The precision for the time and date that the stream was created.
        """
        return pulumi.get(self, "approximate_creation_date_time_precision")


@pulumi.output_type
class TableLocalSecondaryIndex(dict):
    """
    Represents the properties of a local secondary index. A local secondary index can only be created when its parent table is created.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "indexName":
            suggest = "index_name"
        elif key == "keySchema":
            suggest = "key_schema"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableLocalSecondaryIndex. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableLocalSecondaryIndex.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableLocalSecondaryIndex.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 index_name: str,
                 key_schema: Sequence['outputs.TableKeySchema'],
                 projection: 'outputs.TableProjection'):
        """
        Represents the properties of a local secondary index. A local secondary index can only be created when its parent table is created.
        :param str index_name: The name of the local secondary index. The name must be unique among all other indexes on this table.
        :param Sequence['TableKeySchema'] key_schema: The complete key schema for the local secondary index, consisting of one or more pairs of attribute names and key types:
                 +   ``HASH`` - partition key
                 +   ``RANGE`` - sort key
                 
                 The partition key of an item is also known as its *hash attribute*. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
                The sort key of an item is also known as its *range attribute*. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
        :param 'TableProjection' projection: Represents attributes that are copied (projected) from the table into the local secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected.
        """
        pulumi.set(__self__, "index_name", index_name)
        pulumi.set(__self__, "key_schema", key_schema)
        pulumi.set(__self__, "projection", projection)

    @property
    @pulumi.getter(name="indexName")
    def index_name(self) -> str:
        """
        The name of the local secondary index. The name must be unique among all other indexes on this table.
        """
        return pulumi.get(self, "index_name")

    @property
    @pulumi.getter(name="keySchema")
    def key_schema(self) -> Sequence['outputs.TableKeySchema']:
        """
        The complete key schema for the local secondary index, consisting of one or more pairs of attribute names and key types:
          +   ``HASH`` - partition key
          +   ``RANGE`` - sort key
          
          The partition key of an item is also known as its *hash attribute*. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
         The sort key of an item is also known as its *range attribute*. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
        """
        return pulumi.get(self, "key_schema")

    @property
    @pulumi.getter
    def projection(self) -> 'outputs.TableProjection':
        """
        Represents attributes that are copied (projected) from the table into the local secondary index. These are in addition to the primary key attributes and index key attributes, which are automatically projected.
        """
        return pulumi.get(self, "projection")


@pulumi.output_type
class TableOnDemandThroughput(dict):
    """
    Sets the maximum number of read and write units for the specified on-demand table. If you use this property, you must specify ``MaxReadRequestUnits``, ``MaxWriteRequestUnits``, or both.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxReadRequestUnits":
            suggest = "max_read_request_units"
        elif key == "maxWriteRequestUnits":
            suggest = "max_write_request_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableOnDemandThroughput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableOnDemandThroughput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableOnDemandThroughput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_read_request_units: Optional[int] = None,
                 max_write_request_units: Optional[int] = None):
        """
        Sets the maximum number of read and write units for the specified on-demand table. If you use this property, you must specify ``MaxReadRequestUnits``, ``MaxWriteRequestUnits``, or both.
        :param int max_read_request_units: Maximum number of read request units for the specified table.
                To specify a maximum ``OnDemandThroughput`` on your table, set the value of ``MaxReadRequestUnits`` as greater than or equal to 1. To remove the maximum ``OnDemandThroughput`` that is currently set on your table, set the value of ``MaxReadRequestUnits`` to -1.
        :param int max_write_request_units: Maximum number of write request units for the specified table.
                To specify a maximum ``OnDemandThroughput`` on your table, set the value of ``MaxWriteRequestUnits`` as greater than or equal to 1. To remove the maximum ``OnDemandThroughput`` that is currently set on your table, set the value of ``MaxWriteRequestUnits`` to -1.
        """
        if max_read_request_units is not None:
            pulumi.set(__self__, "max_read_request_units", max_read_request_units)
        if max_write_request_units is not None:
            pulumi.set(__self__, "max_write_request_units", max_write_request_units)

    @property
    @pulumi.getter(name="maxReadRequestUnits")
    def max_read_request_units(self) -> Optional[int]:
        """
        Maximum number of read request units for the specified table.
         To specify a maximum ``OnDemandThroughput`` on your table, set the value of ``MaxReadRequestUnits`` as greater than or equal to 1. To remove the maximum ``OnDemandThroughput`` that is currently set on your table, set the value of ``MaxReadRequestUnits`` to -1.
        """
        return pulumi.get(self, "max_read_request_units")

    @property
    @pulumi.getter(name="maxWriteRequestUnits")
    def max_write_request_units(self) -> Optional[int]:
        """
        Maximum number of write request units for the specified table.
         To specify a maximum ``OnDemandThroughput`` on your table, set the value of ``MaxWriteRequestUnits`` as greater than or equal to 1. To remove the maximum ``OnDemandThroughput`` that is currently set on your table, set the value of ``MaxWriteRequestUnits`` to -1.
        """
        return pulumi.get(self, "max_write_request_units")


@pulumi.output_type
class TablePointInTimeRecoverySpecification(dict):
    """
    The settings used to enable point in time recovery.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pointInTimeRecoveryEnabled":
            suggest = "point_in_time_recovery_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TablePointInTimeRecoverySpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TablePointInTimeRecoverySpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TablePointInTimeRecoverySpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 point_in_time_recovery_enabled: Optional[bool] = None):
        """
        The settings used to enable point in time recovery.
        :param bool point_in_time_recovery_enabled: Indicates whether point in time recovery is enabled (true) or disabled (false) on the table.
        """
        if point_in_time_recovery_enabled is not None:
            pulumi.set(__self__, "point_in_time_recovery_enabled", point_in_time_recovery_enabled)

    @property
    @pulumi.getter(name="pointInTimeRecoveryEnabled")
    def point_in_time_recovery_enabled(self) -> Optional[bool]:
        """
        Indicates whether point in time recovery is enabled (true) or disabled (false) on the table.
        """
        return pulumi.get(self, "point_in_time_recovery_enabled")


@pulumi.output_type
class TableProjection(dict):
    """
    Represents attributes that are copied (projected) from the table into an index. These are in addition to the primary key attributes and index key attributes, which are automatically projected.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nonKeyAttributes":
            suggest = "non_key_attributes"
        elif key == "projectionType":
            suggest = "projection_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableProjection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableProjection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableProjection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 non_key_attributes: Optional[Sequence[str]] = None,
                 projection_type: Optional[str] = None):
        """
        Represents attributes that are copied (projected) from the table into an index. These are in addition to the primary key attributes and index key attributes, which are automatically projected.
        :param Sequence[str] non_key_attributes: Represents the non-key attribute names which will be projected into the index.
                For local secondary indexes, the total count of ``NonKeyAttributes`` summed across all of the local secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.
        :param str projection_type: The set of attributes that are projected into the index:
                 +   ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.
                 +   ``INCLUDE`` - In addition to the attributes described in ``KEYS_ONLY``, the secondary index will include other non-key attributes that you specify.
                 +   ``ALL`` - All of the table attributes are projected into the index.
                 
                When using the DynamoDB console, ``ALL`` is selected by default.
        """
        if non_key_attributes is not None:
            pulumi.set(__self__, "non_key_attributes", non_key_attributes)
        if projection_type is not None:
            pulumi.set(__self__, "projection_type", projection_type)

    @property
    @pulumi.getter(name="nonKeyAttributes")
    def non_key_attributes(self) -> Optional[Sequence[str]]:
        """
        Represents the non-key attribute names which will be projected into the index.
         For local secondary indexes, the total count of ``NonKeyAttributes`` summed across all of the local secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.
        """
        return pulumi.get(self, "non_key_attributes")

    @property
    @pulumi.getter(name="projectionType")
    def projection_type(self) -> Optional[str]:
        """
        The set of attributes that are projected into the index:
          +   ``KEYS_ONLY`` - Only the index and primary keys are projected into the index.
          +   ``INCLUDE`` - In addition to the attributes described in ``KEYS_ONLY``, the secondary index will include other non-key attributes that you specify.
          +   ``ALL`` - All of the table attributes are projected into the index.
          
         When using the DynamoDB console, ``ALL`` is selected by default.
        """
        return pulumi.get(self, "projection_type")


@pulumi.output_type
class TableProvisionedThroughput(dict):
    """
    Throughput for the specified table, which consists of values for ``ReadCapacityUnits`` and ``WriteCapacityUnits``. For more information about the contents of a provisioned throughput structure, see [Table ProvisionedThroughput](https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ProvisionedThroughput.html).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "readCapacityUnits":
            suggest = "read_capacity_units"
        elif key == "writeCapacityUnits":
            suggest = "write_capacity_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableProvisionedThroughput. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableProvisionedThroughput.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableProvisionedThroughput.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 read_capacity_units: int,
                 write_capacity_units: int):
        """
        Throughput for the specified table, which consists of values for ``ReadCapacityUnits`` and ``WriteCapacityUnits``. For more information about the contents of a provisioned throughput structure, see [Table ProvisionedThroughput](https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_ProvisionedThroughput.html).
        :param int read_capacity_units: The maximum number of strongly consistent reads consumed per second before DynamoDB returns a ``ThrottlingException``. For more information, see [Specifying Read and Write Requirements](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughput.html) in the *Amazon DynamoDB Developer Guide*.
                If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.
        :param int write_capacity_units: The maximum number of writes consumed per second before DynamoDB returns a ``ThrottlingException``. For more information, see [Specifying Read and Write Requirements](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughput.html) in the *Amazon DynamoDB Developer Guide*.
                If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.
        """
        pulumi.set(__self__, "read_capacity_units", read_capacity_units)
        pulumi.set(__self__, "write_capacity_units", write_capacity_units)

    @property
    @pulumi.getter(name="readCapacityUnits")
    def read_capacity_units(self) -> int:
        """
        The maximum number of strongly consistent reads consumed per second before DynamoDB returns a ``ThrottlingException``. For more information, see [Specifying Read and Write Requirements](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughput.html) in the *Amazon DynamoDB Developer Guide*.
         If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.
        """
        return pulumi.get(self, "read_capacity_units")

    @property
    @pulumi.getter(name="writeCapacityUnits")
    def write_capacity_units(self) -> int:
        """
        The maximum number of writes consumed per second before DynamoDB returns a ``ThrottlingException``. For more information, see [Specifying Read and Write Requirements](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughput.html) in the *Amazon DynamoDB Developer Guide*.
         If read/write capacity mode is ``PAY_PER_REQUEST`` the value is set to 0.
        """
        return pulumi.get(self, "write_capacity_units")


@pulumi.output_type
class TableResourcePolicy(dict):
    """
    Creates or updates a resource-based policy document that contains the permissions for DDB resources, such as a table, its indexes, and stream. Resource-based policies let you define access permissions by specifying who has access to each resource, and the actions they are allowed to perform on each resource.
     In a CFNshort template, you can provide the policy in JSON or YAML format because CFNshort converts YAML to JSON before submitting it to DDB. For more information about resource-based policies, see [Using resource-based policies for](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html) and [Resource-based policy examples](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html).
     While defining resource-based policies in your CFNshort templates, the following considerations apply:
      +  The maximum size supported for a resource-based policy document in JSON format is 20 KB. DDB counts whitespaces when calculating the size of a policy against this limit. 
      +  Resource-based policies don't support [drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html#). If you update a policy outside of the CFNshort stack template, you'll need to update the CFNshort stack with the changes.
      +  Resource-based policies don't support out-of-band changes. If you add, update, or delete a policy outside of the CFNshort template, the change won't be overwritten if there are no changes to the policy within the template.
     For example, say that your template contains a resource-based policy, which you later update outside of the template. If you don't make any changes to the policy in the template, the updated policy in DDB won’t be synced with the policy in the template.
     Conversely, say that your template doesn’t contain a resource-based policy, but you add a policy outside of the template. This policy won’t be removed from DDB as long as you don’t add it to the template. When you add a policy to the template and update the stack, the existing policy in DDB will be updated to match the one defined in the template.
      
     For a full list of all considerations, see [Resource-based policy considerations](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-considerations.html).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyDocument":
            suggest = "policy_document"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableResourcePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableResourcePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableResourcePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_document: Any):
        """
        Creates or updates a resource-based policy document that contains the permissions for DDB resources, such as a table, its indexes, and stream. Resource-based policies let you define access permissions by specifying who has access to each resource, and the actions they are allowed to perform on each resource.
         In a CFNshort template, you can provide the policy in JSON or YAML format because CFNshort converts YAML to JSON before submitting it to DDB. For more information about resource-based policies, see [Using resource-based policies for](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html) and [Resource-based policy examples](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html).
         While defining resource-based policies in your CFNshort templates, the following considerations apply:
          +  The maximum size supported for a resource-based policy document in JSON format is 20 KB. DDB counts whitespaces when calculating the size of a policy against this limit. 
          +  Resource-based policies don't support [drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html#). If you update a policy outside of the CFNshort stack template, you'll need to update the CFNshort stack with the changes.
          +  Resource-based policies don't support out-of-band changes. If you add, update, or delete a policy outside of the CFNshort template, the change won't be overwritten if there are no changes to the policy within the template.
         For example, say that your template contains a resource-based policy, which you later update outside of the template. If you don't make any changes to the policy in the template, the updated policy in DDB won’t be synced with the policy in the template.
         Conversely, say that your template doesn’t contain a resource-based policy, but you add a policy outside of the template. This policy won’t be removed from DDB as long as you don’t add it to the template. When you add a policy to the template and update the stack, the existing policy in DDB will be updated to match the one defined in the template.
          
         For a full list of all considerations, see [Resource-based policy considerations](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-considerations.html).
        :param Any policy_document: A resource-based policy document that contains permissions to add to the specified DDB table, index, or both. In a CFNshort template, you can provide the policy in JSON or YAML format because CFNshort converts YAML to JSON before submitting it to DDB. For more information about resource-based policies, see [Using resource-based policies for](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html) and [Resource-based policy examples](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html).
        """
        pulumi.set(__self__, "policy_document", policy_document)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Any:
        """
        A resource-based policy document that contains permissions to add to the specified DDB table, index, or both. In a CFNshort template, you can provide the policy in JSON or YAML format because CFNshort converts YAML to JSON before submitting it to DDB. For more information about resource-based policies, see [Using resource-based policies for](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html) and [Resource-based policy examples](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html).
        """
        return pulumi.get(self, "policy_document")


@pulumi.output_type
class TableS3BucketSource(dict):
    """
    The S3 bucket that is being imported from.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Bucket":
            suggest = "s3_bucket"
        elif key == "s3BucketOwner":
            suggest = "s3_bucket_owner"
        elif key == "s3KeyPrefix":
            suggest = "s3_key_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableS3BucketSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableS3BucketSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableS3BucketSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_bucket: str,
                 s3_bucket_owner: Optional[str] = None,
                 s3_key_prefix: Optional[str] = None):
        """
        The S3 bucket that is being imported from.
        :param str s3_bucket: The S3 bucket that is being imported from.
        :param str s3_bucket_owner: The account number of the S3 bucket that is being imported from. If the bucket is owned by the requester this is optional.
        :param str s3_key_prefix: The key prefix shared by all S3 Objects that are being imported.
        """
        pulumi.set(__self__, "s3_bucket", s3_bucket)
        if s3_bucket_owner is not None:
            pulumi.set(__self__, "s3_bucket_owner", s3_bucket_owner)
        if s3_key_prefix is not None:
            pulumi.set(__self__, "s3_key_prefix", s3_key_prefix)

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> str:
        """
        The S3 bucket that is being imported from.
        """
        return pulumi.get(self, "s3_bucket")

    @property
    @pulumi.getter(name="s3BucketOwner")
    def s3_bucket_owner(self) -> Optional[str]:
        """
        The account number of the S3 bucket that is being imported from. If the bucket is owned by the requester this is optional.
        """
        return pulumi.get(self, "s3_bucket_owner")

    @property
    @pulumi.getter(name="s3KeyPrefix")
    def s3_key_prefix(self) -> Optional[str]:
        """
        The key prefix shared by all S3 Objects that are being imported.
        """
        return pulumi.get(self, "s3_key_prefix")


@pulumi.output_type
class TableSseSpecification(dict):
    """
    Represents the settings used to enable server-side encryption.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sseEnabled":
            suggest = "sse_enabled"
        elif key == "kmsMasterKeyId":
            suggest = "kms_master_key_id"
        elif key == "sseType":
            suggest = "sse_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableSseSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableSseSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableSseSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sse_enabled: bool,
                 kms_master_key_id: Optional[str] = None,
                 sse_type: Optional[str] = None):
        """
        Represents the settings used to enable server-side encryption.
        :param bool sse_enabled: Indicates whether server-side encryption is done using an AWS managed key or an AWS owned key. If enabled (true), server-side encryption type is set to ``KMS`` and an AWS managed key is used (KMS charges apply). If disabled (false) or not specified, server-side encryption is set to AWS owned key.
        :param str kms_master_key_id: The KMS key that should be used for the KMS encryption. To specify a key, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is different from the default DynamoDB key ``alias/aws/dynamodb``.
        :param str sse_type: Server-side encryption type. The only supported value is:
                 +   ``KMS`` - Server-side encryption that uses KMSlong. The key is stored in your account and is managed by KMS (KMS charges apply).
        """
        pulumi.set(__self__, "sse_enabled", sse_enabled)
        if kms_master_key_id is not None:
            pulumi.set(__self__, "kms_master_key_id", kms_master_key_id)
        if sse_type is not None:
            pulumi.set(__self__, "sse_type", sse_type)

    @property
    @pulumi.getter(name="sseEnabled")
    def sse_enabled(self) -> bool:
        """
        Indicates whether server-side encryption is done using an AWS managed key or an AWS owned key. If enabled (true), server-side encryption type is set to ``KMS`` and an AWS managed key is used (KMS charges apply). If disabled (false) or not specified, server-side encryption is set to AWS owned key.
        """
        return pulumi.get(self, "sse_enabled")

    @property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> Optional[str]:
        """
        The KMS key that should be used for the KMS encryption. To specify a key, use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. Note that you should only provide this parameter if the key is different from the default DynamoDB key ``alias/aws/dynamodb``.
        """
        return pulumi.get(self, "kms_master_key_id")

    @property
    @pulumi.getter(name="sseType")
    def sse_type(self) -> Optional[str]:
        """
        Server-side encryption type. The only supported value is:
          +   ``KMS`` - Server-side encryption that uses KMSlong. The key is stored in your account and is managed by KMS (KMS charges apply).
        """
        return pulumi.get(self, "sse_type")


@pulumi.output_type
class TableStreamSpecification(dict):
    """
    Represents the DynamoDB Streams configuration for a table in DynamoDB.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "streamViewType":
            suggest = "stream_view_type"
        elif key == "resourcePolicy":
            suggest = "resource_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableStreamSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableStreamSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableStreamSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 stream_view_type: str,
                 resource_policy: Optional['outputs.TableResourcePolicy'] = None):
        """
        Represents the DynamoDB Streams configuration for a table in DynamoDB.
        :param str stream_view_type: When an item in the table is modified, ``StreamViewType`` determines what information is written to the stream for this table. Valid values for ``StreamViewType`` are:
                 +   ``KEYS_ONLY`` - Only the key attributes of the modified item are written to the stream.
                 +   ``NEW_IMAGE`` - The entire item, as it appears after it was modified, is written to the stream.
                 +   ``OLD_IMAGE`` - The entire item, as it appeared before it was modified, is written to the stream.
                 +   ``NEW_AND_OLD_IMAGES`` - Both the new and the old item images of the item are written to the stream.
        :param 'TableResourcePolicy' resource_policy: Creates or updates a resource-based policy document that contains the permissions for DDB resources, such as a table's streams. Resource-based policies let you define access permissions by specifying who has access to each resource, and the actions they are allowed to perform on each resource.
                In a CFNshort template, you can provide the policy in JSON or YAML format because CFNshort converts YAML to JSON before submitting it to DDB. For more information about resource-based policies, see [Using resource-based policies for](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html) and [Resource-based policy examples](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html).
        """
        pulumi.set(__self__, "stream_view_type", stream_view_type)
        if resource_policy is not None:
            pulumi.set(__self__, "resource_policy", resource_policy)

    @property
    @pulumi.getter(name="streamViewType")
    def stream_view_type(self) -> str:
        """
        When an item in the table is modified, ``StreamViewType`` determines what information is written to the stream for this table. Valid values for ``StreamViewType`` are:
          +   ``KEYS_ONLY`` - Only the key attributes of the modified item are written to the stream.
          +   ``NEW_IMAGE`` - The entire item, as it appears after it was modified, is written to the stream.
          +   ``OLD_IMAGE`` - The entire item, as it appeared before it was modified, is written to the stream.
          +   ``NEW_AND_OLD_IMAGES`` - Both the new and the old item images of the item are written to the stream.
        """
        return pulumi.get(self, "stream_view_type")

    @property
    @pulumi.getter(name="resourcePolicy")
    def resource_policy(self) -> Optional['outputs.TableResourcePolicy']:
        """
        Creates or updates a resource-based policy document that contains the permissions for DDB resources, such as a table's streams. Resource-based policies let you define access permissions by specifying who has access to each resource, and the actions they are allowed to perform on each resource.
         In a CFNshort template, you can provide the policy in JSON or YAML format because CFNshort converts YAML to JSON before submitting it to DDB. For more information about resource-based policies, see [Using resource-based policies for](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/access-control-resource-based.html) and [Resource-based policy examples](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/rbac-examples.html).
        """
        return pulumi.get(self, "resource_policy")


@pulumi.output_type
class TableTimeToLiveSpecification(dict):
    """
    Represents the settings used to enable or disable Time to Live (TTL) for the specified table.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeName":
            suggest = "attribute_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableTimeToLiveSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableTimeToLiveSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableTimeToLiveSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 attribute_name: Optional[str] = None):
        """
        Represents the settings used to enable or disable Time to Live (TTL) for the specified table.
        :param bool enabled: Indicates whether TTL is to be enabled (true) or disabled (false) on the table.
        :param str attribute_name: The name of the TTL attribute used to store the expiration time for items in the table.
                  +  The ``AttributeName`` property is required when enabling the TTL, or when TTL is already enabled.
                 +  To update this property, you must first disable TTL and then enable TTL with the new attribute name.
        """
        pulumi.set(__self__, "enabled", enabled)
        if attribute_name is not None:
            pulumi.set(__self__, "attribute_name", attribute_name)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Indicates whether TTL is to be enabled (true) or disabled (false) on the table.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="attributeName")
    def attribute_name(self) -> Optional[str]:
        """
        The name of the TTL attribute used to store the expiration time for items in the table.
           +  The ``AttributeName`` property is required when enabling the TTL, or when TTL is already enabled.
          +  To update this property, you must first disable TTL and then enable TTL with the new attribute name.
        """
        return pulumi.get(self, "attribute_name")


