# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'MigrationProjectDataProviderDescriptorArgs',
    'MigrationProjectDataProviderDescriptorArgsDict',
    'ReplicationConfigComputeConfigArgs',
    'ReplicationConfigComputeConfigArgsDict',
    'SchemaConversionApplicationAttributesPropertiesArgs',
    'SchemaConversionApplicationAttributesPropertiesArgsDict',
    'SettingsPropertiesMicrosoftSqlServerSettingsPropertiesArgs',
    'SettingsPropertiesMicrosoftSqlServerSettingsPropertiesArgsDict',
    'SettingsPropertiesMySqlSettingsPropertiesArgs',
    'SettingsPropertiesMySqlSettingsPropertiesArgsDict',
    'SettingsPropertiesOracleSettingsPropertiesArgs',
    'SettingsPropertiesOracleSettingsPropertiesArgsDict',
    'SettingsPropertiesPostgreSqlSettingsPropertiesArgs',
    'SettingsPropertiesPostgreSqlSettingsPropertiesArgsDict',
    'SettingsPropertiesArgs',
    'SettingsPropertiesArgsDict',
]

MYPY = False

if not MYPY:
    class MigrationProjectDataProviderDescriptorArgsDict(TypedDict):
        """
        It is an object that describes Source and Target DataProviders and credentials for connecting to databases that are used in MigrationProject
        """
        data_provider_arn: NotRequired[pulumi.Input[str]]
        """
        The Amazon Resource Name (ARN) of the data provider.
        """
        data_provider_identifier: NotRequired[pulumi.Input[str]]
        data_provider_name: NotRequired[pulumi.Input[str]]
        """
        The user-friendly name of the data provider.
        """
        secrets_manager_access_role_arn: NotRequired[pulumi.Input[str]]
        """
        The ARN of the role used to access AWS Secrets Manager.
        """
        secrets_manager_secret_id: NotRequired[pulumi.Input[str]]
        """
        The identifier of the AWS Secrets Manager Secret used to store access credentials for the data provider.
        """
elif False:
    MigrationProjectDataProviderDescriptorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MigrationProjectDataProviderDescriptorArgs:
    def __init__(__self__, *,
                 data_provider_arn: Optional[pulumi.Input[str]] = None,
                 data_provider_identifier: Optional[pulumi.Input[str]] = None,
                 data_provider_name: Optional[pulumi.Input[str]] = None,
                 secrets_manager_access_role_arn: Optional[pulumi.Input[str]] = None,
                 secrets_manager_secret_id: Optional[pulumi.Input[str]] = None):
        """
        It is an object that describes Source and Target DataProviders and credentials for connecting to databases that are used in MigrationProject
        :param pulumi.Input[str] data_provider_arn: The Amazon Resource Name (ARN) of the data provider.
        :param pulumi.Input[str] data_provider_name: The user-friendly name of the data provider.
        :param pulumi.Input[str] secrets_manager_access_role_arn: The ARN of the role used to access AWS Secrets Manager.
        :param pulumi.Input[str] secrets_manager_secret_id: The identifier of the AWS Secrets Manager Secret used to store access credentials for the data provider.
        """
        if data_provider_arn is not None:
            pulumi.set(__self__, "data_provider_arn", data_provider_arn)
        if data_provider_identifier is not None:
            pulumi.set(__self__, "data_provider_identifier", data_provider_identifier)
        if data_provider_name is not None:
            pulumi.set(__self__, "data_provider_name", data_provider_name)
        if secrets_manager_access_role_arn is not None:
            pulumi.set(__self__, "secrets_manager_access_role_arn", secrets_manager_access_role_arn)
        if secrets_manager_secret_id is not None:
            pulumi.set(__self__, "secrets_manager_secret_id", secrets_manager_secret_id)

    @property
    @pulumi.getter(name="dataProviderArn")
    def data_provider_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the data provider.
        """
        return pulumi.get(self, "data_provider_arn")

    @data_provider_arn.setter
    def data_provider_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_provider_arn", value)

    @property
    @pulumi.getter(name="dataProviderIdentifier")
    def data_provider_identifier(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "data_provider_identifier")

    @data_provider_identifier.setter
    def data_provider_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_provider_identifier", value)

    @property
    @pulumi.getter(name="dataProviderName")
    def data_provider_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-friendly name of the data provider.
        """
        return pulumi.get(self, "data_provider_name")

    @data_provider_name.setter
    def data_provider_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_provider_name", value)

    @property
    @pulumi.getter(name="secretsManagerAccessRoleArn")
    def secrets_manager_access_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the role used to access AWS Secrets Manager.
        """
        return pulumi.get(self, "secrets_manager_access_role_arn")

    @secrets_manager_access_role_arn.setter
    def secrets_manager_access_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secrets_manager_access_role_arn", value)

    @property
    @pulumi.getter(name="secretsManagerSecretId")
    def secrets_manager_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the AWS Secrets Manager Secret used to store access credentials for the data provider.
        """
        return pulumi.get(self, "secrets_manager_secret_id")

    @secrets_manager_secret_id.setter
    def secrets_manager_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secrets_manager_secret_id", value)


if not MYPY:
    class ReplicationConfigComputeConfigArgsDict(TypedDict):
        """
        Configuration parameters for provisioning a AWS DMS Serverless replication
        """
        max_capacity_units: pulumi.Input[int]
        """
        Specifies the maximum value of the AWS DMS capacity units (DCUs) for which a given AWS DMS Serverless replication can be provisioned. A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the maximum value that you can specify for AWS DMS Serverless is 384. The `MaxCapacityUnits` parameter is the only DCU parameter you are required to specify.
        """
        availability_zone: NotRequired[pulumi.Input[str]]
        """
        The Availability Zone where the AWS DMS Serverless replication using this configuration will run. The default value is a random, system-chosen Availability Zone in the configuration's AWS Region , for example, `"us-west-2"` . You can't set this parameter if the `MultiAZ` parameter is set to `true` .
        """
        dns_name_servers: NotRequired[pulumi.Input[str]]
        """
        A list of custom DNS name servers supported for the AWS DMS Serverless replication to access your source or target database. This list overrides the default name servers supported by the AWS DMS Serverless replication. You can specify a comma-separated list of internet addresses for up to four DNS name servers. For example: `"1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"`
        """
        kms_key_id: NotRequired[pulumi.Input[str]]
        """
        An AWS Key Management Service ( AWS KMS ) key Amazon Resource Name (ARN) that is used to encrypt the data during AWS DMS Serverless replication.

        If you don't specify a value for the `KmsKeyId` parameter, AWS DMS uses your default encryption key.

        AWS KMS creates the default encryption key for your Amazon Web Services account. Your AWS account has a different default encryption key for each AWS Region .
        """
        min_capacity_units: NotRequired[pulumi.Input[int]]
        """
        Specifies the minimum value of the AWS DMS capacity units (DCUs) for which a given AWS DMS Serverless replication can be provisioned. A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the minimum DCU value that you can specify for AWS DMS Serverless is 1. If you don't set this value, AWS DMS sets this parameter to the minimum DCU value allowed, 1. If there is no current source activity, AWS DMS scales down your replication until it reaches the value specified in `MinCapacityUnits` .
        """
        multi_az: NotRequired[pulumi.Input[bool]]
        """
        Specifies whether the AWS DMS Serverless replication is a Multi-AZ deployment. You can't set the `AvailabilityZone` parameter if the `MultiAZ` parameter is set to `true` .
        """
        preferred_maintenance_window: NotRequired[pulumi.Input[str]]
        """
        The weekly time range during which system maintenance can occur for the AWS DMS Serverless replication, in Universal Coordinated Time (UTC). The format is `ddd:hh24:mi-ddd:hh24:mi` .

        The default is a 30-minute window selected at random from an 8-hour block of time per AWS Region . This maintenance occurs on a random day of the week. Valid values for days of the week include `Mon` , `Tue` , `Wed` , `Thu` , `Fri` , `Sat` , and `Sun` .

        Constraints include a minimum 30-minute window.
        """
        replication_subnet_group_id: NotRequired[pulumi.Input[str]]
        """
        Specifies a subnet group identifier to associate with the AWS DMS Serverless replication.
        """
        vpc_security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Specifies the virtual private cloud (VPC) security group to use with the AWS DMS Serverless replication. The VPC security group must work with the VPC containing the replication.
        """
elif False:
    ReplicationConfigComputeConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationConfigComputeConfigArgs:
    def __init__(__self__, *,
                 max_capacity_units: pulumi.Input[int],
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 dns_name_servers: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 min_capacity_units: Optional[pulumi.Input[int]] = None,
                 multi_az: Optional[pulumi.Input[bool]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 replication_subnet_group_id: Optional[pulumi.Input[str]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Configuration parameters for provisioning a AWS DMS Serverless replication
        :param pulumi.Input[int] max_capacity_units: Specifies the maximum value of the AWS DMS capacity units (DCUs) for which a given AWS DMS Serverless replication can be provisioned. A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the maximum value that you can specify for AWS DMS Serverless is 384. The `MaxCapacityUnits` parameter is the only DCU parameter you are required to specify.
        :param pulumi.Input[str] availability_zone: The Availability Zone where the AWS DMS Serverless replication using this configuration will run. The default value is a random, system-chosen Availability Zone in the configuration's AWS Region , for example, `"us-west-2"` . You can't set this parameter if the `MultiAZ` parameter is set to `true` .
        :param pulumi.Input[str] dns_name_servers: A list of custom DNS name servers supported for the AWS DMS Serverless replication to access your source or target database. This list overrides the default name servers supported by the AWS DMS Serverless replication. You can specify a comma-separated list of internet addresses for up to four DNS name servers. For example: `"1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"`
        :param pulumi.Input[str] kms_key_id: An AWS Key Management Service ( AWS KMS ) key Amazon Resource Name (ARN) that is used to encrypt the data during AWS DMS Serverless replication.
               
               If you don't specify a value for the `KmsKeyId` parameter, AWS DMS uses your default encryption key.
               
               AWS KMS creates the default encryption key for your Amazon Web Services account. Your AWS account has a different default encryption key for each AWS Region .
        :param pulumi.Input[int] min_capacity_units: Specifies the minimum value of the AWS DMS capacity units (DCUs) for which a given AWS DMS Serverless replication can be provisioned. A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the minimum DCU value that you can specify for AWS DMS Serverless is 1. If you don't set this value, AWS DMS sets this parameter to the minimum DCU value allowed, 1. If there is no current source activity, AWS DMS scales down your replication until it reaches the value specified in `MinCapacityUnits` .
        :param pulumi.Input[bool] multi_az: Specifies whether the AWS DMS Serverless replication is a Multi-AZ deployment. You can't set the `AvailabilityZone` parameter if the `MultiAZ` parameter is set to `true` .
        :param pulumi.Input[str] preferred_maintenance_window: The weekly time range during which system maintenance can occur for the AWS DMS Serverless replication, in Universal Coordinated Time (UTC). The format is `ddd:hh24:mi-ddd:hh24:mi` .
               
               The default is a 30-minute window selected at random from an 8-hour block of time per AWS Region . This maintenance occurs on a random day of the week. Valid values for days of the week include `Mon` , `Tue` , `Wed` , `Thu` , `Fri` , `Sat` , and `Sun` .
               
               Constraints include a minimum 30-minute window.
        :param pulumi.Input[str] replication_subnet_group_id: Specifies a subnet group identifier to associate with the AWS DMS Serverless replication.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vpc_security_group_ids: Specifies the virtual private cloud (VPC) security group to use with the AWS DMS Serverless replication. The VPC security group must work with the VPC containing the replication.
        """
        pulumi.set(__self__, "max_capacity_units", max_capacity_units)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if dns_name_servers is not None:
            pulumi.set(__self__, "dns_name_servers", dns_name_servers)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if min_capacity_units is not None:
            pulumi.set(__self__, "min_capacity_units", min_capacity_units)
        if multi_az is not None:
            pulumi.set(__self__, "multi_az", multi_az)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if replication_subnet_group_id is not None:
            pulumi.set(__self__, "replication_subnet_group_id", replication_subnet_group_id)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)

    @property
    @pulumi.getter(name="maxCapacityUnits")
    def max_capacity_units(self) -> pulumi.Input[int]:
        """
        Specifies the maximum value of the AWS DMS capacity units (DCUs) for which a given AWS DMS Serverless replication can be provisioned. A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the maximum value that you can specify for AWS DMS Serverless is 384. The `MaxCapacityUnits` parameter is the only DCU parameter you are required to specify.
        """
        return pulumi.get(self, "max_capacity_units")

    @max_capacity_units.setter
    def max_capacity_units(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_capacity_units", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The Availability Zone where the AWS DMS Serverless replication using this configuration will run. The default value is a random, system-chosen Availability Zone in the configuration's AWS Region , for example, `"us-west-2"` . You can't set this parameter if the `MultiAZ` parameter is set to `true` .
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="dnsNameServers")
    def dns_name_servers(self) -> Optional[pulumi.Input[str]]:
        """
        A list of custom DNS name servers supported for the AWS DMS Serverless replication to access your source or target database. This list overrides the default name servers supported by the AWS DMS Serverless replication. You can specify a comma-separated list of internet addresses for up to four DNS name servers. For example: `"1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"`
        """
        return pulumi.get(self, "dns_name_servers")

    @dns_name_servers.setter
    def dns_name_servers(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name_servers", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        An AWS Key Management Service ( AWS KMS ) key Amazon Resource Name (ARN) that is used to encrypt the data during AWS DMS Serverless replication.

        If you don't specify a value for the `KmsKeyId` parameter, AWS DMS uses your default encryption key.

        AWS KMS creates the default encryption key for your Amazon Web Services account. Your AWS account has a different default encryption key for each AWS Region .
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="minCapacityUnits")
    def min_capacity_units(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the minimum value of the AWS DMS capacity units (DCUs) for which a given AWS DMS Serverless replication can be provisioned. A single DCU is 2GB of RAM, with 1 DCU as the minimum value allowed. The list of valid DCU values includes 1, 2, 4, 8, 16, 32, 64, 128, 192, 256, and 384. So, the minimum DCU value that you can specify for AWS DMS Serverless is 1. If you don't set this value, AWS DMS sets this parameter to the minimum DCU value allowed, 1. If there is no current source activity, AWS DMS scales down your replication until it reaches the value specified in `MinCapacityUnits` .
        """
        return pulumi.get(self, "min_capacity_units")

    @min_capacity_units.setter
    def min_capacity_units(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_capacity_units", value)

    @property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the AWS DMS Serverless replication is a Multi-AZ deployment. You can't set the `AvailabilityZone` parameter if the `MultiAZ` parameter is set to `true` .
        """
        return pulumi.get(self, "multi_az")

    @multi_az.setter
    def multi_az(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multi_az", value)

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[pulumi.Input[str]]:
        """
        The weekly time range during which system maintenance can occur for the AWS DMS Serverless replication, in Universal Coordinated Time (UTC). The format is `ddd:hh24:mi-ddd:hh24:mi` .

        The default is a 30-minute window selected at random from an 8-hour block of time per AWS Region . This maintenance occurs on a random day of the week. Valid values for days of the week include `Mon` , `Tue` , `Wed` , `Thu` , `Fri` , `Sat` , and `Sun` .

        Constraints include a minimum 30-minute window.
        """
        return pulumi.get(self, "preferred_maintenance_window")

    @preferred_maintenance_window.setter
    def preferred_maintenance_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_maintenance_window", value)

    @property
    @pulumi.getter(name="replicationSubnetGroupId")
    def replication_subnet_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a subnet group identifier to associate with the AWS DMS Serverless replication.
        """
        return pulumi.get(self, "replication_subnet_group_id")

    @replication_subnet_group_id.setter
    def replication_subnet_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_subnet_group_id", value)

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the virtual private cloud (VPC) security group to use with the AWS DMS Serverless replication. The VPC security group must work with the VPC containing the replication.
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @vpc_security_group_ids.setter
    def vpc_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vpc_security_group_ids", value)


if not MYPY:
    class SchemaConversionApplicationAttributesPropertiesArgsDict(TypedDict):
        """
        The property describes schema conversion application attributes for the migration project.
        """
        s3_bucket_path: NotRequired[pulumi.Input[str]]
        s3_bucket_role_arn: NotRequired[pulumi.Input[str]]
elif False:
    SchemaConversionApplicationAttributesPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SchemaConversionApplicationAttributesPropertiesArgs:
    def __init__(__self__, *,
                 s3_bucket_path: Optional[pulumi.Input[str]] = None,
                 s3_bucket_role_arn: Optional[pulumi.Input[str]] = None):
        """
        The property describes schema conversion application attributes for the migration project.
        """
        if s3_bucket_path is not None:
            pulumi.set(__self__, "s3_bucket_path", s3_bucket_path)
        if s3_bucket_role_arn is not None:
            pulumi.set(__self__, "s3_bucket_role_arn", s3_bucket_role_arn)

    @property
    @pulumi.getter(name="s3BucketPath")
    def s3_bucket_path(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "s3_bucket_path")

    @s3_bucket_path.setter
    def s3_bucket_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_bucket_path", value)

    @property
    @pulumi.getter(name="s3BucketRoleArn")
    def s3_bucket_role_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "s3_bucket_role_arn")

    @s3_bucket_role_arn.setter
    def s3_bucket_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "s3_bucket_role_arn", value)


if not MYPY:
    class SettingsPropertiesMicrosoftSqlServerSettingsPropertiesArgsDict(TypedDict):
        """
        MicrosoftSqlServerSettings property identifier.
        """
        database_name: pulumi.Input[str]
        port: pulumi.Input[int]
        server_name: pulumi.Input[str]
        ssl_mode: pulumi.Input['DataProviderDmsSslModeValue']
        certificate_arn: NotRequired[pulumi.Input[str]]
elif False:
    SettingsPropertiesMicrosoftSqlServerSettingsPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SettingsPropertiesMicrosoftSqlServerSettingsPropertiesArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[str],
                 port: pulumi.Input[int],
                 server_name: pulumi.Input[str],
                 ssl_mode: pulumi.Input['DataProviderDmsSslModeValue'],
                 certificate_arn: Optional[pulumi.Input[str]] = None):
        """
        MicrosoftSqlServerSettings property identifier.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "ssl_mode", ssl_mode)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> pulumi.Input['DataProviderDmsSslModeValue']:
        return pulumi.get(self, "ssl_mode")

    @ssl_mode.setter
    def ssl_mode(self, value: pulumi.Input['DataProviderDmsSslModeValue']):
        pulumi.set(self, "ssl_mode", value)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "certificate_arn")

    @certificate_arn.setter
    def certificate_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_arn", value)


if not MYPY:
    class SettingsPropertiesMySqlSettingsPropertiesArgsDict(TypedDict):
        """
        MySqlSettings property identifier.
        """
        port: pulumi.Input[int]
        server_name: pulumi.Input[str]
        ssl_mode: pulumi.Input['DataProviderDmsSslModeValue']
        certificate_arn: NotRequired[pulumi.Input[str]]
elif False:
    SettingsPropertiesMySqlSettingsPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SettingsPropertiesMySqlSettingsPropertiesArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 server_name: pulumi.Input[str],
                 ssl_mode: pulumi.Input['DataProviderDmsSslModeValue'],
                 certificate_arn: Optional[pulumi.Input[str]] = None):
        """
        MySqlSettings property identifier.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "ssl_mode", ssl_mode)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> pulumi.Input['DataProviderDmsSslModeValue']:
        return pulumi.get(self, "ssl_mode")

    @ssl_mode.setter
    def ssl_mode(self, value: pulumi.Input['DataProviderDmsSslModeValue']):
        pulumi.set(self, "ssl_mode", value)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "certificate_arn")

    @certificate_arn.setter
    def certificate_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_arn", value)


if not MYPY:
    class SettingsPropertiesOracleSettingsPropertiesArgsDict(TypedDict):
        """
        OracleSettings property identifier.
        """
        database_name: pulumi.Input[str]
        port: pulumi.Input[int]
        server_name: pulumi.Input[str]
        ssl_mode: pulumi.Input['DataProviderDmsSslModeValue']
        asm_server: NotRequired[pulumi.Input[str]]
        certificate_arn: NotRequired[pulumi.Input[str]]
        secrets_manager_oracle_asm_access_role_arn: NotRequired[pulumi.Input[str]]
        secrets_manager_oracle_asm_secret_id: NotRequired[pulumi.Input[str]]
        secrets_manager_security_db_encryption_access_role_arn: NotRequired[pulumi.Input[str]]
        secrets_manager_security_db_encryption_secret_id: NotRequired[pulumi.Input[str]]
elif False:
    SettingsPropertiesOracleSettingsPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SettingsPropertiesOracleSettingsPropertiesArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[str],
                 port: pulumi.Input[int],
                 server_name: pulumi.Input[str],
                 ssl_mode: pulumi.Input['DataProviderDmsSslModeValue'],
                 asm_server: Optional[pulumi.Input[str]] = None,
                 certificate_arn: Optional[pulumi.Input[str]] = None,
                 secrets_manager_oracle_asm_access_role_arn: Optional[pulumi.Input[str]] = None,
                 secrets_manager_oracle_asm_secret_id: Optional[pulumi.Input[str]] = None,
                 secrets_manager_security_db_encryption_access_role_arn: Optional[pulumi.Input[str]] = None,
                 secrets_manager_security_db_encryption_secret_id: Optional[pulumi.Input[str]] = None):
        """
        OracleSettings property identifier.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "ssl_mode", ssl_mode)
        if asm_server is not None:
            pulumi.set(__self__, "asm_server", asm_server)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)
        if secrets_manager_oracle_asm_access_role_arn is not None:
            pulumi.set(__self__, "secrets_manager_oracle_asm_access_role_arn", secrets_manager_oracle_asm_access_role_arn)
        if secrets_manager_oracle_asm_secret_id is not None:
            pulumi.set(__self__, "secrets_manager_oracle_asm_secret_id", secrets_manager_oracle_asm_secret_id)
        if secrets_manager_security_db_encryption_access_role_arn is not None:
            pulumi.set(__self__, "secrets_manager_security_db_encryption_access_role_arn", secrets_manager_security_db_encryption_access_role_arn)
        if secrets_manager_security_db_encryption_secret_id is not None:
            pulumi.set(__self__, "secrets_manager_security_db_encryption_secret_id", secrets_manager_security_db_encryption_secret_id)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> pulumi.Input['DataProviderDmsSslModeValue']:
        return pulumi.get(self, "ssl_mode")

    @ssl_mode.setter
    def ssl_mode(self, value: pulumi.Input['DataProviderDmsSslModeValue']):
        pulumi.set(self, "ssl_mode", value)

    @property
    @pulumi.getter(name="asmServer")
    def asm_server(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "asm_server")

    @asm_server.setter
    def asm_server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "asm_server", value)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "certificate_arn")

    @certificate_arn.setter
    def certificate_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_arn", value)

    @property
    @pulumi.getter(name="secretsManagerOracleAsmAccessRoleArn")
    def secrets_manager_oracle_asm_access_role_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "secrets_manager_oracle_asm_access_role_arn")

    @secrets_manager_oracle_asm_access_role_arn.setter
    def secrets_manager_oracle_asm_access_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secrets_manager_oracle_asm_access_role_arn", value)

    @property
    @pulumi.getter(name="secretsManagerOracleAsmSecretId")
    def secrets_manager_oracle_asm_secret_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "secrets_manager_oracle_asm_secret_id")

    @secrets_manager_oracle_asm_secret_id.setter
    def secrets_manager_oracle_asm_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secrets_manager_oracle_asm_secret_id", value)

    @property
    @pulumi.getter(name="secretsManagerSecurityDbEncryptionAccessRoleArn")
    def secrets_manager_security_db_encryption_access_role_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "secrets_manager_security_db_encryption_access_role_arn")

    @secrets_manager_security_db_encryption_access_role_arn.setter
    def secrets_manager_security_db_encryption_access_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secrets_manager_security_db_encryption_access_role_arn", value)

    @property
    @pulumi.getter(name="secretsManagerSecurityDbEncryptionSecretId")
    def secrets_manager_security_db_encryption_secret_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "secrets_manager_security_db_encryption_secret_id")

    @secrets_manager_security_db_encryption_secret_id.setter
    def secrets_manager_security_db_encryption_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secrets_manager_security_db_encryption_secret_id", value)


if not MYPY:
    class SettingsPropertiesPostgreSqlSettingsPropertiesArgsDict(TypedDict):
        """
        PostgreSqlSettings property identifier.
        """
        database_name: pulumi.Input[str]
        port: pulumi.Input[int]
        server_name: pulumi.Input[str]
        ssl_mode: pulumi.Input['DataProviderDmsSslModeValue']
        certificate_arn: NotRequired[pulumi.Input[str]]
elif False:
    SettingsPropertiesPostgreSqlSettingsPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SettingsPropertiesPostgreSqlSettingsPropertiesArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[str],
                 port: pulumi.Input[int],
                 server_name: pulumi.Input[str],
                 ssl_mode: pulumi.Input['DataProviderDmsSslModeValue'],
                 certificate_arn: Optional[pulumi.Input[str]] = None):
        """
        PostgreSqlSettings property identifier.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_name", server_name)
        pulumi.set(__self__, "ssl_mode", ssl_mode)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> pulumi.Input[str]:
        return pulumi.get(self, "server_name")

    @server_name.setter
    def server_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "server_name", value)

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> pulumi.Input['DataProviderDmsSslModeValue']:
        return pulumi.get(self, "ssl_mode")

    @ssl_mode.setter
    def ssl_mode(self, value: pulumi.Input['DataProviderDmsSslModeValue']):
        pulumi.set(self, "ssl_mode", value)

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "certificate_arn")

    @certificate_arn.setter
    def certificate_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_arn", value)


if not MYPY:
    class SettingsPropertiesArgsDict(TypedDict):
        """
        The property identifies the exact type of settings for the data provider.
        """
        microsoft_sql_server_settings: NotRequired[pulumi.Input['SettingsPropertiesMicrosoftSqlServerSettingsPropertiesArgsDict']]
        """
        MicrosoftSqlServerSettings property identifier.
        """
        my_sql_settings: NotRequired[pulumi.Input['SettingsPropertiesMySqlSettingsPropertiesArgsDict']]
        """
        MySqlSettings property identifier.
        """
        oracle_settings: NotRequired[pulumi.Input['SettingsPropertiesOracleSettingsPropertiesArgsDict']]
        """
        OracleSettings property identifier.
        """
        postgre_sql_settings: NotRequired[pulumi.Input['SettingsPropertiesPostgreSqlSettingsPropertiesArgsDict']]
        """
        PostgreSqlSettings property identifier.
        """
elif False:
    SettingsPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SettingsPropertiesArgs:
    def __init__(__self__, *,
                 microsoft_sql_server_settings: Optional[pulumi.Input['SettingsPropertiesMicrosoftSqlServerSettingsPropertiesArgs']] = None,
                 my_sql_settings: Optional[pulumi.Input['SettingsPropertiesMySqlSettingsPropertiesArgs']] = None,
                 oracle_settings: Optional[pulumi.Input['SettingsPropertiesOracleSettingsPropertiesArgs']] = None,
                 postgre_sql_settings: Optional[pulumi.Input['SettingsPropertiesPostgreSqlSettingsPropertiesArgs']] = None):
        """
        The property identifies the exact type of settings for the data provider.
        :param pulumi.Input['SettingsPropertiesMicrosoftSqlServerSettingsPropertiesArgs'] microsoft_sql_server_settings: MicrosoftSqlServerSettings property identifier.
        :param pulumi.Input['SettingsPropertiesMySqlSettingsPropertiesArgs'] my_sql_settings: MySqlSettings property identifier.
        :param pulumi.Input['SettingsPropertiesOracleSettingsPropertiesArgs'] oracle_settings: OracleSettings property identifier.
        :param pulumi.Input['SettingsPropertiesPostgreSqlSettingsPropertiesArgs'] postgre_sql_settings: PostgreSqlSettings property identifier.
        """
        if microsoft_sql_server_settings is not None:
            pulumi.set(__self__, "microsoft_sql_server_settings", microsoft_sql_server_settings)
        if my_sql_settings is not None:
            pulumi.set(__self__, "my_sql_settings", my_sql_settings)
        if oracle_settings is not None:
            pulumi.set(__self__, "oracle_settings", oracle_settings)
        if postgre_sql_settings is not None:
            pulumi.set(__self__, "postgre_sql_settings", postgre_sql_settings)

    @property
    @pulumi.getter(name="microsoftSqlServerSettings")
    def microsoft_sql_server_settings(self) -> Optional[pulumi.Input['SettingsPropertiesMicrosoftSqlServerSettingsPropertiesArgs']]:
        """
        MicrosoftSqlServerSettings property identifier.
        """
        return pulumi.get(self, "microsoft_sql_server_settings")

    @microsoft_sql_server_settings.setter
    def microsoft_sql_server_settings(self, value: Optional[pulumi.Input['SettingsPropertiesMicrosoftSqlServerSettingsPropertiesArgs']]):
        pulumi.set(self, "microsoft_sql_server_settings", value)

    @property
    @pulumi.getter(name="mySqlSettings")
    def my_sql_settings(self) -> Optional[pulumi.Input['SettingsPropertiesMySqlSettingsPropertiesArgs']]:
        """
        MySqlSettings property identifier.
        """
        return pulumi.get(self, "my_sql_settings")

    @my_sql_settings.setter
    def my_sql_settings(self, value: Optional[pulumi.Input['SettingsPropertiesMySqlSettingsPropertiesArgs']]):
        pulumi.set(self, "my_sql_settings", value)

    @property
    @pulumi.getter(name="oracleSettings")
    def oracle_settings(self) -> Optional[pulumi.Input['SettingsPropertiesOracleSettingsPropertiesArgs']]:
        """
        OracleSettings property identifier.
        """
        return pulumi.get(self, "oracle_settings")

    @oracle_settings.setter
    def oracle_settings(self, value: Optional[pulumi.Input['SettingsPropertiesOracleSettingsPropertiesArgs']]):
        pulumi.set(self, "oracle_settings", value)

    @property
    @pulumi.getter(name="postgreSqlSettings")
    def postgre_sql_settings(self) -> Optional[pulumi.Input['SettingsPropertiesPostgreSqlSettingsPropertiesArgs']]:
        """
        PostgreSqlSettings property identifier.
        """
        return pulumi.get(self, "postgre_sql_settings")

    @postgre_sql_settings.setter
    def postgre_sql_settings(self, value: Optional[pulumi.Input['SettingsPropertiesPostgreSqlSettingsPropertiesArgs']]):
        pulumi.set(self, "postgre_sql_settings", value)


