# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'NotificationChannelConfig',
    'NotificationChannelNotificationFilterConfig',
    'NotificationChannelSnsChannelConfig',
    'ResourceCollectionCloudFormationCollectionFilter',
    'ResourceCollectionFilter',
    'ResourceCollectionTagCollection',
]

@pulumi.output_type
class NotificationChannelConfig(dict):
    """
    Information about notification channels you have configured with DevOps Guru.
    """
    def __init__(__self__, *,
                 filters: Optional['outputs.NotificationChannelNotificationFilterConfig'] = None,
                 sns: Optional['outputs.NotificationChannelSnsChannelConfig'] = None):
        """
        Information about notification channels you have configured with DevOps Guru.
        :param 'NotificationChannelNotificationFilterConfig' filters: The filter configurations for the Amazon SNS notification topic you use with DevOps Guru. If you do not provide filter configurations, the default configurations are to receive notifications for all message types of `High` or `Medium` severity.
        :param 'NotificationChannelSnsChannelConfig' sns: Information about a notification channel configured in DevOps Guru to send notifications when insights are created.
               
               If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to send it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. DevOps Guru only supports standard SNS topics. For more information, see [Permissions for Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html) .
               
               If you use an Amazon SNS topic that is encrypted by an AWS Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see [Permissions for AWS KMS–encrypted Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html) .
        """
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if sns is not None:
            pulumi.set(__self__, "sns", sns)

    @property
    @pulumi.getter
    def filters(self) -> Optional['outputs.NotificationChannelNotificationFilterConfig']:
        """
        The filter configurations for the Amazon SNS notification topic you use with DevOps Guru. If you do not provide filter configurations, the default configurations are to receive notifications for all message types of `High` or `Medium` severity.
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def sns(self) -> Optional['outputs.NotificationChannelSnsChannelConfig']:
        """
        Information about a notification channel configured in DevOps Guru to send notifications when insights are created.

        If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to send it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. DevOps Guru only supports standard SNS topics. For more information, see [Permissions for Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html) .

        If you use an Amazon SNS topic that is encrypted by an AWS Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see [Permissions for AWS KMS–encrypted Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html) .
        """
        return pulumi.get(self, "sns")


@pulumi.output_type
class NotificationChannelNotificationFilterConfig(dict):
    """
    Information about filters of a notification channel configured in DevOpsGuru to filter for insights.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageTypes":
            suggest = "message_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationChannelNotificationFilterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationChannelNotificationFilterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationChannelNotificationFilterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_types: Optional[Sequence['NotificationChannelNotificationMessageType']] = None,
                 severities: Optional[Sequence['NotificationChannelInsightSeverity']] = None):
        """
        Information about filters of a notification channel configured in DevOpsGuru to filter for insights.
        :param Sequence['NotificationChannelNotificationMessageType'] message_types: The events that you want to receive notifications for. For example, you can choose to receive notifications only when the severity level is upgraded or a new insight is created.
        :param Sequence['NotificationChannelInsightSeverity'] severities: The severity levels that you want to receive notifications for. For example, you can choose to receive notifications only for insights with `HIGH` and `MEDIUM` severity levels. For more information, see [Understanding insight severities](https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities) .
        """
        if message_types is not None:
            pulumi.set(__self__, "message_types", message_types)
        if severities is not None:
            pulumi.set(__self__, "severities", severities)

    @property
    @pulumi.getter(name="messageTypes")
    def message_types(self) -> Optional[Sequence['NotificationChannelNotificationMessageType']]:
        """
        The events that you want to receive notifications for. For example, you can choose to receive notifications only when the severity level is upgraded or a new insight is created.
        """
        return pulumi.get(self, "message_types")

    @property
    @pulumi.getter
    def severities(self) -> Optional[Sequence['NotificationChannelInsightSeverity']]:
        """
        The severity levels that you want to receive notifications for. For example, you can choose to receive notifications only for insights with `HIGH` and `MEDIUM` severity levels. For more information, see [Understanding insight severities](https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities) .
        """
        return pulumi.get(self, "severities")


@pulumi.output_type
class NotificationChannelSnsChannelConfig(dict):
    """
    Information about a notification channel configured in DevOps Guru to send notifications when insights are created.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topicArn":
            suggest = "topic_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationChannelSnsChannelConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationChannelSnsChannelConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationChannelSnsChannelConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 topic_arn: Optional[str] = None):
        """
        Information about a notification channel configured in DevOps Guru to send notifications when insights are created.
        :param str topic_arn: The Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic.
        """
        if topic_arn is not None:
            pulumi.set(__self__, "topic_arn", topic_arn)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic.
        """
        return pulumi.get(self, "topic_arn")


@pulumi.output_type
class ResourceCollectionCloudFormationCollectionFilter(dict):
    """
    CloudFormation resource for DevOps Guru to monitor
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stackNames":
            suggest = "stack_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceCollectionCloudFormationCollectionFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceCollectionCloudFormationCollectionFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceCollectionCloudFormationCollectionFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 stack_names: Optional[Sequence[str]] = None):
        """
        CloudFormation resource for DevOps Guru to monitor
        :param Sequence[str] stack_names: An array of CloudFormation stack names.
        """
        if stack_names is not None:
            pulumi.set(__self__, "stack_names", stack_names)

    @property
    @pulumi.getter(name="stackNames")
    def stack_names(self) -> Optional[Sequence[str]]:
        """
        An array of CloudFormation stack names.
        """
        return pulumi.get(self, "stack_names")


@pulumi.output_type
class ResourceCollectionFilter(dict):
    """
    Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudFormation":
            suggest = "cloud_formation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceCollectionFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceCollectionFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceCollectionFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_formation: Optional['outputs.ResourceCollectionCloudFormationCollectionFilter'] = None,
                 tags: Optional[Sequence['outputs.ResourceCollectionTagCollection']] = None):
        """
        Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru.
        :param 'ResourceCollectionCloudFormationCollectionFilter' cloud_formation: Information about AWS CloudFormation stacks. You can use up to 1000 stacks to specify which AWS resources in your account to analyze. For more information, see [Stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html) in the *AWS CloudFormation User Guide* .
        :param Sequence['ResourceCollectionTagCollection'] tags: The AWS tags used to filter the resources in the resource collection.
               
               Tags help you identify and organize your AWS resources. Many AWS services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an AWS Lambda function. For more information about using tags, see the [Tagging best practices](https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html) whitepaper.
               
               Each AWS tag has two parts.
               
               - A tag *key* (for example, `CostCenter` , `Environment` , `Project` , or `Secret` ). Tag *keys* are case-sensitive.
               - A field known as a tag *value* (for example, `111122223333` , `Production` , or a team name). Omitting the tag *value* is the same as using an empty string. Like tag *keys* , tag *values* are case-sensitive. The tag value is a required property when AppBoundaryKey is specified.
               
               Together these are known as *key* - *value* pairs.
               
               > The string used for a *key* in a tag that you use to define your resource coverage must begin with the prefix `Devops-guru-` . The tag *key* might be `DevOps-Guru-deployment-application` or `devops-guru-rds-application` . When you create a *key* , the case of characters in the *key* can be whatever you choose. After you create a *key* , it is case-sensitive. For example, DevOps Guru works with a *key* named `devops-guru-rds` and a *key* named `DevOps-Guru-RDS` , and these act as two different *keys* . Possible *key* / *value* pairs in your application might be `Devops-Guru-production-application/RDS` or `Devops-Guru-production-application/containers` .
        """
        if cloud_formation is not None:
            pulumi.set(__self__, "cloud_formation", cloud_formation)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="cloudFormation")
    def cloud_formation(self) -> Optional['outputs.ResourceCollectionCloudFormationCollectionFilter']:
        """
        Information about AWS CloudFormation stacks. You can use up to 1000 stacks to specify which AWS resources in your account to analyze. For more information, see [Stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html) in the *AWS CloudFormation User Guide* .
        """
        return pulumi.get(self, "cloud_formation")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.ResourceCollectionTagCollection']]:
        """
        The AWS tags used to filter the resources in the resource collection.

        Tags help you identify and organize your AWS resources. Many AWS services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an AWS Lambda function. For more information about using tags, see the [Tagging best practices](https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html) whitepaper.

        Each AWS tag has two parts.

        - A tag *key* (for example, `CostCenter` , `Environment` , `Project` , or `Secret` ). Tag *keys* are case-sensitive.
        - A field known as a tag *value* (for example, `111122223333` , `Production` , or a team name). Omitting the tag *value* is the same as using an empty string. Like tag *keys* , tag *values* are case-sensitive. The tag value is a required property when AppBoundaryKey is specified.

        Together these are known as *key* - *value* pairs.

        > The string used for a *key* in a tag that you use to define your resource coverage must begin with the prefix `Devops-guru-` . The tag *key* might be `DevOps-Guru-deployment-application` or `devops-guru-rds-application` . When you create a *key* , the case of characters in the *key* can be whatever you choose. After you create a *key* , it is case-sensitive. For example, DevOps Guru works with a *key* named `devops-guru-rds` and a *key* named `DevOps-Guru-RDS` , and these act as two different *keys* . Possible *key* / *value* pairs in your application might be `Devops-Guru-production-application/RDS` or `Devops-Guru-production-application/containers` .
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class ResourceCollectionTagCollection(dict):
    """
    Tagged resource for DevOps Guru to monitor
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appBoundaryKey":
            suggest = "app_boundary_key"
        elif key == "tagValues":
            suggest = "tag_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceCollectionTagCollection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceCollectionTagCollection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceCollectionTagCollection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_boundary_key: Optional[str] = None,
                 tag_values: Optional[Sequence[str]] = None):
        """
        Tagged resource for DevOps Guru to monitor
        :param str app_boundary_key: A Tag key for DevOps Guru app boundary.
        :param Sequence[str] tag_values: Tag values of DevOps Guru app boundary.
        """
        if app_boundary_key is not None:
            pulumi.set(__self__, "app_boundary_key", app_boundary_key)
        if tag_values is not None:
            pulumi.set(__self__, "tag_values", tag_values)

    @property
    @pulumi.getter(name="appBoundaryKey")
    def app_boundary_key(self) -> Optional[str]:
        """
        A Tag key for DevOps Guru app boundary.
        """
        return pulumi.get(self, "app_boundary_key")

    @property
    @pulumi.getter(name="tagValues")
    def tag_values(self) -> Optional[Sequence[str]]:
        """
        Tag values of DevOps Guru app boundary.
        """
        return pulumi.get(self, "tag_values")


