# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'NotificationChannelConfigArgs',
    'NotificationChannelConfigArgsDict',
    'NotificationChannelNotificationFilterConfigArgs',
    'NotificationChannelNotificationFilterConfigArgsDict',
    'NotificationChannelSnsChannelConfigArgs',
    'NotificationChannelSnsChannelConfigArgsDict',
    'ResourceCollectionCloudFormationCollectionFilterArgs',
    'ResourceCollectionCloudFormationCollectionFilterArgsDict',
    'ResourceCollectionFilterArgs',
    'ResourceCollectionFilterArgsDict',
    'ResourceCollectionTagCollectionArgs',
    'ResourceCollectionTagCollectionArgsDict',
]

MYPY = False

if not MYPY:
    class NotificationChannelConfigArgsDict(TypedDict):
        """
        Information about notification channels you have configured with DevOps Guru.
        """
        filters: NotRequired[pulumi.Input['NotificationChannelNotificationFilterConfigArgsDict']]
        """
        The filter configurations for the Amazon SNS notification topic you use with DevOps Guru. If you do not provide filter configurations, the default configurations are to receive notifications for all message types of `High` or `Medium` severity.
        """
        sns: NotRequired[pulumi.Input['NotificationChannelSnsChannelConfigArgsDict']]
        """
        Information about a notification channel configured in DevOps Guru to send notifications when insights are created.

        If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to send it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. DevOps Guru only supports standard SNS topics. For more information, see [Permissions for Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html) .

        If you use an Amazon SNS topic that is encrypted by an AWS Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see [Permissions for AWS KMS–encrypted Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html) .
        """
elif False:
    NotificationChannelConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NotificationChannelConfigArgs:
    def __init__(__self__, *,
                 filters: Optional[pulumi.Input['NotificationChannelNotificationFilterConfigArgs']] = None,
                 sns: Optional[pulumi.Input['NotificationChannelSnsChannelConfigArgs']] = None):
        """
        Information about notification channels you have configured with DevOps Guru.
        :param pulumi.Input['NotificationChannelNotificationFilterConfigArgs'] filters: The filter configurations for the Amazon SNS notification topic you use with DevOps Guru. If you do not provide filter configurations, the default configurations are to receive notifications for all message types of `High` or `Medium` severity.
        :param pulumi.Input['NotificationChannelSnsChannelConfigArgs'] sns: Information about a notification channel configured in DevOps Guru to send notifications when insights are created.
               
               If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to send it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. DevOps Guru only supports standard SNS topics. For more information, see [Permissions for Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html) .
               
               If you use an Amazon SNS topic that is encrypted by an AWS Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see [Permissions for AWS KMS–encrypted Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html) .
        """
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if sns is not None:
            pulumi.set(__self__, "sns", sns)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['NotificationChannelNotificationFilterConfigArgs']]:
        """
        The filter configurations for the Amazon SNS notification topic you use with DevOps Guru. If you do not provide filter configurations, the default configurations are to receive notifications for all message types of `High` or `Medium` severity.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['NotificationChannelNotificationFilterConfigArgs']]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter
    def sns(self) -> Optional[pulumi.Input['NotificationChannelSnsChannelConfigArgs']]:
        """
        Information about a notification channel configured in DevOps Guru to send notifications when insights are created.

        If you use an Amazon SNS topic in another account, you must attach a policy to it that grants DevOps Guru permission to send it notifications. DevOps Guru adds the required policy on your behalf to send notifications using Amazon SNS in your account. DevOps Guru only supports standard SNS topics. For more information, see [Permissions for Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-required-permissions.html) .

        If you use an Amazon SNS topic that is encrypted by an AWS Key Management Service customer-managed key (CMK), then you must add permissions to the CMK. For more information, see [Permissions for AWS KMS–encrypted Amazon SNS topics](https://docs.aws.amazon.com/devops-guru/latest/userguide/sns-kms-permissions.html) .
        """
        return pulumi.get(self, "sns")

    @sns.setter
    def sns(self, value: Optional[pulumi.Input['NotificationChannelSnsChannelConfigArgs']]):
        pulumi.set(self, "sns", value)


if not MYPY:
    class NotificationChannelNotificationFilterConfigArgsDict(TypedDict):
        """
        Information about filters of a notification channel configured in DevOpsGuru to filter for insights.
        """
        message_types: NotRequired[pulumi.Input[Sequence[pulumi.Input['NotificationChannelNotificationMessageType']]]]
        """
        The events that you want to receive notifications for. For example, you can choose to receive notifications only when the severity level is upgraded or a new insight is created.
        """
        severities: NotRequired[pulumi.Input[Sequence[pulumi.Input['NotificationChannelInsightSeverity']]]]
        """
        The severity levels that you want to receive notifications for. For example, you can choose to receive notifications only for insights with `HIGH` and `MEDIUM` severity levels. For more information, see [Understanding insight severities](https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities) .
        """
elif False:
    NotificationChannelNotificationFilterConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NotificationChannelNotificationFilterConfigArgs:
    def __init__(__self__, *,
                 message_types: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationChannelNotificationMessageType']]]] = None,
                 severities: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationChannelInsightSeverity']]]] = None):
        """
        Information about filters of a notification channel configured in DevOpsGuru to filter for insights.
        :param pulumi.Input[Sequence[pulumi.Input['NotificationChannelNotificationMessageType']]] message_types: The events that you want to receive notifications for. For example, you can choose to receive notifications only when the severity level is upgraded or a new insight is created.
        :param pulumi.Input[Sequence[pulumi.Input['NotificationChannelInsightSeverity']]] severities: The severity levels that you want to receive notifications for. For example, you can choose to receive notifications only for insights with `HIGH` and `MEDIUM` severity levels. For more information, see [Understanding insight severities](https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities) .
        """
        if message_types is not None:
            pulumi.set(__self__, "message_types", message_types)
        if severities is not None:
            pulumi.set(__self__, "severities", severities)

    @property
    @pulumi.getter(name="messageTypes")
    def message_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotificationChannelNotificationMessageType']]]]:
        """
        The events that you want to receive notifications for. For example, you can choose to receive notifications only when the severity level is upgraded or a new insight is created.
        """
        return pulumi.get(self, "message_types")

    @message_types.setter
    def message_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationChannelNotificationMessageType']]]]):
        pulumi.set(self, "message_types", value)

    @property
    @pulumi.getter
    def severities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotificationChannelInsightSeverity']]]]:
        """
        The severity levels that you want to receive notifications for. For example, you can choose to receive notifications only for insights with `HIGH` and `MEDIUM` severity levels. For more information, see [Understanding insight severities](https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities) .
        """
        return pulumi.get(self, "severities")

    @severities.setter
    def severities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationChannelInsightSeverity']]]]):
        pulumi.set(self, "severities", value)


if not MYPY:
    class NotificationChannelSnsChannelConfigArgsDict(TypedDict):
        """
        Information about a notification channel configured in DevOps Guru to send notifications when insights are created.
        """
        topic_arn: NotRequired[pulumi.Input[str]]
        """
        The Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic.
        """
elif False:
    NotificationChannelSnsChannelConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NotificationChannelSnsChannelConfigArgs:
    def __init__(__self__, *,
                 topic_arn: Optional[pulumi.Input[str]] = None):
        """
        Information about a notification channel configured in DevOps Guru to send notifications when insights are created.
        :param pulumi.Input[str] topic_arn: The Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic.
        """
        if topic_arn is not None:
            pulumi.set(__self__, "topic_arn", topic_arn)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic.
        """
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic_arn", value)


if not MYPY:
    class ResourceCollectionCloudFormationCollectionFilterArgsDict(TypedDict):
        """
        CloudFormation resource for DevOps Guru to monitor
        """
        stack_names: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        An array of CloudFormation stack names.
        """
elif False:
    ResourceCollectionCloudFormationCollectionFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceCollectionCloudFormationCollectionFilterArgs:
    def __init__(__self__, *,
                 stack_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        CloudFormation resource for DevOps Guru to monitor
        :param pulumi.Input[Sequence[pulumi.Input[str]]] stack_names: An array of CloudFormation stack names.
        """
        if stack_names is not None:
            pulumi.set(__self__, "stack_names", stack_names)

    @property
    @pulumi.getter(name="stackNames")
    def stack_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of CloudFormation stack names.
        """
        return pulumi.get(self, "stack_names")

    @stack_names.setter
    def stack_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "stack_names", value)


if not MYPY:
    class ResourceCollectionFilterArgsDict(TypedDict):
        """
        Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru.
        """
        cloud_formation: NotRequired[pulumi.Input['ResourceCollectionCloudFormationCollectionFilterArgsDict']]
        """
        Information about AWS CloudFormation stacks. You can use up to 1000 stacks to specify which AWS resources in your account to analyze. For more information, see [Stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html) in the *AWS CloudFormation User Guide* .
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['ResourceCollectionTagCollectionArgsDict']]]]
        """
        The AWS tags used to filter the resources in the resource collection.

        Tags help you identify and organize your AWS resources. Many AWS services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an AWS Lambda function. For more information about using tags, see the [Tagging best practices](https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html) whitepaper.

        Each AWS tag has two parts.

        - A tag *key* (for example, `CostCenter` , `Environment` , `Project` , or `Secret` ). Tag *keys* are case-sensitive.
        - A field known as a tag *value* (for example, `111122223333` , `Production` , or a team name). Omitting the tag *value* is the same as using an empty string. Like tag *keys* , tag *values* are case-sensitive. The tag value is a required property when AppBoundaryKey is specified.

        Together these are known as *key* - *value* pairs.

        > The string used for a *key* in a tag that you use to define your resource coverage must begin with the prefix `Devops-guru-` . The tag *key* might be `DevOps-Guru-deployment-application` or `devops-guru-rds-application` . When you create a *key* , the case of characters in the *key* can be whatever you choose. After you create a *key* , it is case-sensitive. For example, DevOps Guru works with a *key* named `devops-guru-rds` and a *key* named `DevOps-Guru-RDS` , and these act as two different *keys* . Possible *key* / *value* pairs in your application might be `Devops-Guru-production-application/RDS` or `Devops-Guru-production-application/containers` .
        """
elif False:
    ResourceCollectionFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceCollectionFilterArgs:
    def __init__(__self__, *,
                 cloud_formation: Optional[pulumi.Input['ResourceCollectionCloudFormationCollectionFilterArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceCollectionTagCollectionArgs']]]] = None):
        """
        Information about a filter used to specify which AWS resources are analyzed for anomalous behavior by DevOps Guru.
        :param pulumi.Input['ResourceCollectionCloudFormationCollectionFilterArgs'] cloud_formation: Information about AWS CloudFormation stacks. You can use up to 1000 stacks to specify which AWS resources in your account to analyze. For more information, see [Stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html) in the *AWS CloudFormation User Guide* .
        :param pulumi.Input[Sequence[pulumi.Input['ResourceCollectionTagCollectionArgs']]] tags: The AWS tags used to filter the resources in the resource collection.
               
               Tags help you identify and organize your AWS resources. Many AWS services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an AWS Lambda function. For more information about using tags, see the [Tagging best practices](https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html) whitepaper.
               
               Each AWS tag has two parts.
               
               - A tag *key* (for example, `CostCenter` , `Environment` , `Project` , or `Secret` ). Tag *keys* are case-sensitive.
               - A field known as a tag *value* (for example, `111122223333` , `Production` , or a team name). Omitting the tag *value* is the same as using an empty string. Like tag *keys* , tag *values* are case-sensitive. The tag value is a required property when AppBoundaryKey is specified.
               
               Together these are known as *key* - *value* pairs.
               
               > The string used for a *key* in a tag that you use to define your resource coverage must begin with the prefix `Devops-guru-` . The tag *key* might be `DevOps-Guru-deployment-application` or `devops-guru-rds-application` . When you create a *key* , the case of characters in the *key* can be whatever you choose. After you create a *key* , it is case-sensitive. For example, DevOps Guru works with a *key* named `devops-guru-rds` and a *key* named `DevOps-Guru-RDS` , and these act as two different *keys* . Possible *key* / *value* pairs in your application might be `Devops-Guru-production-application/RDS` or `Devops-Guru-production-application/containers` .
        """
        if cloud_formation is not None:
            pulumi.set(__self__, "cloud_formation", cloud_formation)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="cloudFormation")
    def cloud_formation(self) -> Optional[pulumi.Input['ResourceCollectionCloudFormationCollectionFilterArgs']]:
        """
        Information about AWS CloudFormation stacks. You can use up to 1000 stacks to specify which AWS resources in your account to analyze. For more information, see [Stacks](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacks.html) in the *AWS CloudFormation User Guide* .
        """
        return pulumi.get(self, "cloud_formation")

    @cloud_formation.setter
    def cloud_formation(self, value: Optional[pulumi.Input['ResourceCollectionCloudFormationCollectionFilterArgs']]):
        pulumi.set(self, "cloud_formation", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceCollectionTagCollectionArgs']]]]:
        """
        The AWS tags used to filter the resources in the resource collection.

        Tags help you identify and organize your AWS resources. Many AWS services support tagging, so you can assign the same tag to resources from different services to indicate that the resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an AWS Lambda function. For more information about using tags, see the [Tagging best practices](https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html) whitepaper.

        Each AWS tag has two parts.

        - A tag *key* (for example, `CostCenter` , `Environment` , `Project` , or `Secret` ). Tag *keys* are case-sensitive.
        - A field known as a tag *value* (for example, `111122223333` , `Production` , or a team name). Omitting the tag *value* is the same as using an empty string. Like tag *keys* , tag *values* are case-sensitive. The tag value is a required property when AppBoundaryKey is specified.

        Together these are known as *key* - *value* pairs.

        > The string used for a *key* in a tag that you use to define your resource coverage must begin with the prefix `Devops-guru-` . The tag *key* might be `DevOps-Guru-deployment-application` or `devops-guru-rds-application` . When you create a *key* , the case of characters in the *key* can be whatever you choose. After you create a *key* , it is case-sensitive. For example, DevOps Guru works with a *key* named `devops-guru-rds` and a *key* named `DevOps-Guru-RDS` , and these act as two different *keys* . Possible *key* / *value* pairs in your application might be `Devops-Guru-production-application/RDS` or `Devops-Guru-production-application/containers` .
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceCollectionTagCollectionArgs']]]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class ResourceCollectionTagCollectionArgsDict(TypedDict):
        """
        Tagged resource for DevOps Guru to monitor
        """
        app_boundary_key: NotRequired[pulumi.Input[str]]
        """
        A Tag key for DevOps Guru app boundary.
        """
        tag_values: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        Tag values of DevOps Guru app boundary.
        """
elif False:
    ResourceCollectionTagCollectionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceCollectionTagCollectionArgs:
    def __init__(__self__, *,
                 app_boundary_key: Optional[pulumi.Input[str]] = None,
                 tag_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Tagged resource for DevOps Guru to monitor
        :param pulumi.Input[str] app_boundary_key: A Tag key for DevOps Guru app boundary.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tag_values: Tag values of DevOps Guru app boundary.
        """
        if app_boundary_key is not None:
            pulumi.set(__self__, "app_boundary_key", app_boundary_key)
        if tag_values is not None:
            pulumi.set(__self__, "tag_values", tag_values)

    @property
    @pulumi.getter(name="appBoundaryKey")
    def app_boundary_key(self) -> Optional[pulumi.Input[str]]:
        """
        A Tag key for DevOps Guru app boundary.
        """
        return pulumi.get(self, "app_boundary_key")

    @app_boundary_key.setter
    def app_boundary_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_boundary_key", value)

    @property
    @pulumi.getter(name="tagValues")
    def tag_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tag values of DevOps Guru app boundary.
        """
        return pulumi.get(self, "tag_values")

    @tag_values.setter
    def tag_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tag_values", value)


