# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetVpceConfigurationResult',
    'AwaitableGetVpceConfigurationResult',
    'get_vpce_configuration',
    'get_vpce_configuration_output',
]

@pulumi.output_type
class GetVpceConfigurationResult:
    def __init__(__self__, arn=None, service_dns_name=None, tags=None, vpce_configuration_description=None, vpce_configuration_name=None, vpce_service_name=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if service_dns_name and not isinstance(service_dns_name, str):
            raise TypeError("Expected argument 'service_dns_name' to be a str")
        pulumi.set(__self__, "service_dns_name", service_dns_name)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if vpce_configuration_description and not isinstance(vpce_configuration_description, str):
            raise TypeError("Expected argument 'vpce_configuration_description' to be a str")
        pulumi.set(__self__, "vpce_configuration_description", vpce_configuration_description)
        if vpce_configuration_name and not isinstance(vpce_configuration_name, str):
            raise TypeError("Expected argument 'vpce_configuration_name' to be a str")
        pulumi.set(__self__, "vpce_configuration_name", vpce_configuration_name)
        if vpce_service_name and not isinstance(vpce_service_name, str):
            raise TypeError("Expected argument 'vpce_service_name' to be a str")
        pulumi.set(__self__, "vpce_service_name", vpce_service_name)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the VPC endpoint. See [Amazon resource names](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *General Reference guide* .
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="serviceDnsName")
    def service_dns_name(self) -> Optional[str]:
        """
        The DNS name that Device Farm will use to map to the private service you want to access.
        """
        return pulumi.get(self, "service_dns_name")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.

        For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) in the *guide* .
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpceConfigurationDescription")
    def vpce_configuration_description(self) -> Optional[str]:
        """
        An optional description that provides details about your VPC endpoint configuration.
        """
        return pulumi.get(self, "vpce_configuration_description")

    @property
    @pulumi.getter(name="vpceConfigurationName")
    def vpce_configuration_name(self) -> Optional[str]:
        """
        The friendly name you give to your VPC endpoint configuration to manage your configurations more easily.
        """
        return pulumi.get(self, "vpce_configuration_name")

    @property
    @pulumi.getter(name="vpceServiceName")
    def vpce_service_name(self) -> Optional[str]:
        """
        The name of the VPC endpoint service that you want to access from Device Farm.

        The name follows the format `com.amazonaws.vpce.us-west-2.vpce-svc-id` .
        """
        return pulumi.get(self, "vpce_service_name")


class AwaitableGetVpceConfigurationResult(GetVpceConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpceConfigurationResult(
            arn=self.arn,
            service_dns_name=self.service_dns_name,
            tags=self.tags,
            vpce_configuration_description=self.vpce_configuration_description,
            vpce_configuration_name=self.vpce_configuration_name,
            vpce_service_name=self.vpce_service_name)


def get_vpce_configuration(arn: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpceConfigurationResult:
    """
    AWS::DeviceFarm::VPCEConfiguration creates a new Device Farm VPCE Configuration


    :param str arn: The Amazon Resource Name (ARN) of the VPC endpoint. See [Amazon resource names](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *General Reference guide* .
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:devicefarm:getVpceConfiguration', __args__, opts=opts, typ=GetVpceConfigurationResult).value

    return AwaitableGetVpceConfigurationResult(
        arn=pulumi.get(__ret__, 'arn'),
        service_dns_name=pulumi.get(__ret__, 'service_dns_name'),
        tags=pulumi.get(__ret__, 'tags'),
        vpce_configuration_description=pulumi.get(__ret__, 'vpce_configuration_description'),
        vpce_configuration_name=pulumi.get(__ret__, 'vpce_configuration_name'),
        vpce_service_name=pulumi.get(__ret__, 'vpce_service_name'))
def get_vpce_configuration_output(arn: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVpceConfigurationResult]:
    """
    AWS::DeviceFarm::VPCEConfiguration creates a new Device Farm VPCE Configuration


    :param str arn: The Amazon Resource Name (ARN) of the VPC endpoint. See [Amazon resource names](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *General Reference guide* .
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:devicefarm:getVpceConfiguration', __args__, opts=opts, typ=GetVpceConfigurationResult)
    return __ret__.apply(lambda __response__: GetVpceConfigurationResult(
        arn=pulumi.get(__response__, 'arn'),
        service_dns_name=pulumi.get(__response__, 'service_dns_name'),
        tags=pulumi.get(__response__, 'tags'),
        vpce_configuration_description=pulumi.get(__response__, 'vpce_configuration_description'),
        vpce_configuration_name=pulumi.get(__response__, 'vpce_configuration_name'),
        vpce_service_name=pulumi.get(__response__, 'vpce_service_name')))
