# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetInstanceProfileResult',
    'AwaitableGetInstanceProfileResult',
    'get_instance_profile',
    'get_instance_profile_output',
]

@pulumi.output_type
class GetInstanceProfileResult:
    def __init__(__self__, arn=None, description=None, exclude_app_packages_from_cleanup=None, name=None, package_cleanup=None, reboot_after_use=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if exclude_app_packages_from_cleanup and not isinstance(exclude_app_packages_from_cleanup, list):
            raise TypeError("Expected argument 'exclude_app_packages_from_cleanup' to be a list")
        pulumi.set(__self__, "exclude_app_packages_from_cleanup", exclude_app_packages_from_cleanup)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if package_cleanup and not isinstance(package_cleanup, bool):
            raise TypeError("Expected argument 'package_cleanup' to be a bool")
        pulumi.set(__self__, "package_cleanup", package_cleanup)
        if reboot_after_use and not isinstance(reboot_after_use, bool):
            raise TypeError("Expected argument 'reboot_after_use' to be a bool")
        pulumi.set(__self__, "reboot_after_use", reboot_after_use)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the instance profile. See [Amazon resource names](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *General Reference guide* .
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the instance profile.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="excludeAppPackagesFromCleanup")
    def exclude_app_packages_from_cleanup(self) -> Optional[Sequence[str]]:
        """
        An array of strings containing the list of app packages that should not be cleaned up from the device after a test run completes.

        The list of packages is considered only if you set `packageCleanup` to `true` .
        """
        return pulumi.get(self, "exclude_app_packages_from_cleanup")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the instance profile.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="packageCleanup")
    def package_cleanup(self) -> Optional[bool]:
        """
        When set to `true` , Device Farm removes app packages after a test run. The default value is `false` for private devices.
        """
        return pulumi.get(self, "package_cleanup")

    @property
    @pulumi.getter(name="rebootAfterUse")
    def reboot_after_use(self) -> Optional[bool]:
        """
        When set to `true` , Device Farm reboots the instance after a test run. The default value is `true` .
        """
        return pulumi.get(self, "reboot_after_use")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.

        For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) in the *guide* .
        """
        return pulumi.get(self, "tags")


class AwaitableGetInstanceProfileResult(GetInstanceProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceProfileResult(
            arn=self.arn,
            description=self.description,
            exclude_app_packages_from_cleanup=self.exclude_app_packages_from_cleanup,
            name=self.name,
            package_cleanup=self.package_cleanup,
            reboot_after_use=self.reboot_after_use,
            tags=self.tags)


def get_instance_profile(arn: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceProfileResult:
    """
    AWS::DeviceFarm::InstanceProfile creates a new Device Farm Instance Profile


    :param str arn: The Amazon Resource Name (ARN) of the instance profile. See [Amazon resource names](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *General Reference guide* .
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:devicefarm:getInstanceProfile', __args__, opts=opts, typ=GetInstanceProfileResult).value

    return AwaitableGetInstanceProfileResult(
        arn=pulumi.get(__ret__, 'arn'),
        description=pulumi.get(__ret__, 'description'),
        exclude_app_packages_from_cleanup=pulumi.get(__ret__, 'exclude_app_packages_from_cleanup'),
        name=pulumi.get(__ret__, 'name'),
        package_cleanup=pulumi.get(__ret__, 'package_cleanup'),
        reboot_after_use=pulumi.get(__ret__, 'reboot_after_use'),
        tags=pulumi.get(__ret__, 'tags'))
def get_instance_profile_output(arn: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInstanceProfileResult]:
    """
    AWS::DeviceFarm::InstanceProfile creates a new Device Farm Instance Profile


    :param str arn: The Amazon Resource Name (ARN) of the instance profile. See [Amazon resource names](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *General Reference guide* .
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:devicefarm:getInstanceProfile', __args__, opts=opts, typ=GetInstanceProfileResult)
    return __ret__.apply(lambda __response__: GetInstanceProfileResult(
        arn=pulumi.get(__response__, 'arn'),
        description=pulumi.get(__response__, 'description'),
        exclude_app_packages_from_cleanup=pulumi.get(__response__, 'exclude_app_packages_from_cleanup'),
        name=pulumi.get(__response__, 'name'),
        package_cleanup=pulumi.get(__response__, 'package_cleanup'),
        reboot_after_use=pulumi.get(__response__, 'reboot_after_use'),
        tags=pulumi.get(__response__, 'tags')))
