# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['StorageProfileArgs', 'StorageProfile']

@pulumi.input_type
class StorageProfileArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[str],
                 farm_id: pulumi.Input[str],
                 os_family: pulumi.Input['StorageProfileOperatingSystemFamily'],
                 file_system_locations: Optional[pulumi.Input[Sequence[pulumi.Input['StorageProfileFileSystemLocationArgs']]]] = None):
        """
        The set of arguments for constructing a StorageProfile resource.
        :param pulumi.Input[str] display_name: The display name of the storage profile summary to update.
               
               > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        :param pulumi.Input[str] farm_id: The unique identifier of the farm that contains the storage profile.
        :param pulumi.Input['StorageProfileOperatingSystemFamily'] os_family: The operating system (OS) family.
        :param pulumi.Input[Sequence[pulumi.Input['StorageProfileFileSystemLocationArgs']]] file_system_locations: Operating system specific file system path to the storage location.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "farm_id", farm_id)
        pulumi.set(__self__, "os_family", os_family)
        if file_system_locations is not None:
            pulumi.set(__self__, "file_system_locations", file_system_locations)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        The display name of the storage profile summary to update.

        > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="farmId")
    def farm_id(self) -> pulumi.Input[str]:
        """
        The unique identifier of the farm that contains the storage profile.
        """
        return pulumi.get(self, "farm_id")

    @farm_id.setter
    def farm_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "farm_id", value)

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> pulumi.Input['StorageProfileOperatingSystemFamily']:
        """
        The operating system (OS) family.
        """
        return pulumi.get(self, "os_family")

    @os_family.setter
    def os_family(self, value: pulumi.Input['StorageProfileOperatingSystemFamily']):
        pulumi.set(self, "os_family", value)

    @property
    @pulumi.getter(name="fileSystemLocations")
    def file_system_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageProfileFileSystemLocationArgs']]]]:
        """
        Operating system specific file system path to the storage location.
        """
        return pulumi.get(self, "file_system_locations")

    @file_system_locations.setter
    def file_system_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageProfileFileSystemLocationArgs']]]]):
        pulumi.set(self, "file_system_locations", value)


class StorageProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 farm_id: Optional[pulumi.Input[str]] = None,
                 file_system_locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageProfileFileSystemLocationArgs', 'StorageProfileFileSystemLocationArgsDict']]]]] = None,
                 os_family: Optional[pulumi.Input['StorageProfileOperatingSystemFamily']] = None,
                 __props__=None):
        """
        Definition of AWS::Deadline::StorageProfile Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] display_name: The display name of the storage profile summary to update.
               
               > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        :param pulumi.Input[str] farm_id: The unique identifier of the farm that contains the storage profile.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StorageProfileFileSystemLocationArgs', 'StorageProfileFileSystemLocationArgsDict']]]] file_system_locations: Operating system specific file system path to the storage location.
        :param pulumi.Input['StorageProfileOperatingSystemFamily'] os_family: The operating system (OS) family.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StorageProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Deadline::StorageProfile Resource Type

        :param str resource_name: The name of the resource.
        :param StorageProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StorageProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 farm_id: Optional[pulumi.Input[str]] = None,
                 file_system_locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageProfileFileSystemLocationArgs', 'StorageProfileFileSystemLocationArgsDict']]]]] = None,
                 os_family: Optional[pulumi.Input['StorageProfileOperatingSystemFamily']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StorageProfileArgs.__new__(StorageProfileArgs)

            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if farm_id is None and not opts.urn:
                raise TypeError("Missing required property 'farm_id'")
            __props__.__dict__["farm_id"] = farm_id
            __props__.__dict__["file_system_locations"] = file_system_locations
            if os_family is None and not opts.urn:
                raise TypeError("Missing required property 'os_family'")
            __props__.__dict__["os_family"] = os_family
            __props__.__dict__["storage_profile_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["farmId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(StorageProfile, __self__).__init__(
            'aws-native:deadline:StorageProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'StorageProfile':
        """
        Get an existing StorageProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = StorageProfileArgs.__new__(StorageProfileArgs)

        __props__.__dict__["display_name"] = None
        __props__.__dict__["farm_id"] = None
        __props__.__dict__["file_system_locations"] = None
        __props__.__dict__["os_family"] = None
        __props__.__dict__["storage_profile_id"] = None
        return StorageProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The display name of the storage profile summary to update.

        > This field can store any content. Escape or encode this content before displaying it on a webpage or any other system that might interpret the content of this field.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="farmId")
    def farm_id(self) -> pulumi.Output[str]:
        """
        The unique identifier of the farm that contains the storage profile.
        """
        return pulumi.get(self, "farm_id")

    @property
    @pulumi.getter(name="fileSystemLocations")
    def file_system_locations(self) -> pulumi.Output[Optional[Sequence['outputs.StorageProfileFileSystemLocation']]]:
        """
        Operating system specific file system path to the storage location.
        """
        return pulumi.get(self, "file_system_locations")

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> pulumi.Output['StorageProfileOperatingSystemFamily']:
        """
        The operating system (OS) family.
        """
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter(name="storageProfileId")
    def storage_profile_id(self) -> pulumi.Output[str]:
        """
        The storage profile ID.
        """
        return pulumi.get(self, "storage_profile_id")

