# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SubscriptionTargetArgs', 'SubscriptionTarget']

@pulumi.input_type
class SubscriptionTargetArgs:
    def __init__(__self__, *,
                 applicable_asset_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 authorized_principals: pulumi.Input[Sequence[pulumi.Input[str]]],
                 domain_identifier: pulumi.Input[str],
                 environment_identifier: pulumi.Input[str],
                 manage_access_role: pulumi.Input[str],
                 subscription_target_config: pulumi.Input[Sequence[pulumi.Input['SubscriptionTargetFormArgs']]],
                 type: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 provider: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SubscriptionTarget resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] applicable_asset_types: The asset types that can be included in the subscription target.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] authorized_principals: The authorized principals of the subscription target.
        :param pulumi.Input[str] domain_identifier: The ID of the Amazon DataZone domain in which subscription target would be created.
        :param pulumi.Input[str] environment_identifier: The ID of the environment in which subscription target would be created.
        :param pulumi.Input[str] manage_access_role: The manage access role that is used to create the subscription target.
        :param pulumi.Input[Sequence[pulumi.Input['SubscriptionTargetFormArgs']]] subscription_target_config: The configuration of the subscription target.
        :param pulumi.Input[str] type: The type of the subscription target.
        :param pulumi.Input[str] name: The name of the subscription target.
        :param pulumi.Input[str] provider: The provider of the subscription target.
        """
        pulumi.set(__self__, "applicable_asset_types", applicable_asset_types)
        pulumi.set(__self__, "authorized_principals", authorized_principals)
        pulumi.set(__self__, "domain_identifier", domain_identifier)
        pulumi.set(__self__, "environment_identifier", environment_identifier)
        pulumi.set(__self__, "manage_access_role", manage_access_role)
        pulumi.set(__self__, "subscription_target_config", subscription_target_config)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if provider is not None:
            pulumi.set(__self__, "provider", provider)

    @property
    @pulumi.getter(name="applicableAssetTypes")
    def applicable_asset_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The asset types that can be included in the subscription target.
        """
        return pulumi.get(self, "applicable_asset_types")

    @applicable_asset_types.setter
    def applicable_asset_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "applicable_asset_types", value)

    @property
    @pulumi.getter(name="authorizedPrincipals")
    def authorized_principals(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The authorized principals of the subscription target.
        """
        return pulumi.get(self, "authorized_principals")

    @authorized_principals.setter
    def authorized_principals(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "authorized_principals", value)

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Input[str]:
        """
        The ID of the Amazon DataZone domain in which subscription target would be created.
        """
        return pulumi.get(self, "domain_identifier")

    @domain_identifier.setter
    def domain_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_identifier", value)

    @property
    @pulumi.getter(name="environmentIdentifier")
    def environment_identifier(self) -> pulumi.Input[str]:
        """
        The ID of the environment in which subscription target would be created.
        """
        return pulumi.get(self, "environment_identifier")

    @environment_identifier.setter
    def environment_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "environment_identifier", value)

    @property
    @pulumi.getter(name="manageAccessRole")
    def manage_access_role(self) -> pulumi.Input[str]:
        """
        The manage access role that is used to create the subscription target.
        """
        return pulumi.get(self, "manage_access_role")

    @manage_access_role.setter
    def manage_access_role(self, value: pulumi.Input[str]):
        pulumi.set(self, "manage_access_role", value)

    @property
    @pulumi.getter(name="subscriptionTargetConfig")
    def subscription_target_config(self) -> pulumi.Input[Sequence[pulumi.Input['SubscriptionTargetFormArgs']]]:
        """
        The configuration of the subscription target.
        """
        return pulumi.get(self, "subscription_target_config")

    @subscription_target_config.setter
    def subscription_target_config(self, value: pulumi.Input[Sequence[pulumi.Input['SubscriptionTargetFormArgs']]]):
        pulumi.set(self, "subscription_target_config", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the subscription target.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the subscription target.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def provider(self) -> Optional[pulumi.Input[str]]:
        """
        The provider of the subscription target.
        """
        return pulumi.get(self, "provider")

    @provider.setter
    def provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider", value)


class SubscriptionTarget(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 applicable_asset_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 authorized_principals: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 domain_identifier: Optional[pulumi.Input[str]] = None,
                 environment_identifier: Optional[pulumi.Input[str]] = None,
                 manage_access_role: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 provider: Optional[pulumi.Input[str]] = None,
                 subscription_target_config: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SubscriptionTargetFormArgs', 'SubscriptionTargetFormArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Subscription targets enables one to access the data to which you have subscribed in your projects.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] applicable_asset_types: The asset types that can be included in the subscription target.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] authorized_principals: The authorized principals of the subscription target.
        :param pulumi.Input[str] domain_identifier: The ID of the Amazon DataZone domain in which subscription target would be created.
        :param pulumi.Input[str] environment_identifier: The ID of the environment in which subscription target would be created.
        :param pulumi.Input[str] manage_access_role: The manage access role that is used to create the subscription target.
        :param pulumi.Input[str] name: The name of the subscription target.
        :param pulumi.Input[str] provider: The provider of the subscription target.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SubscriptionTargetFormArgs', 'SubscriptionTargetFormArgsDict']]]] subscription_target_config: The configuration of the subscription target.
        :param pulumi.Input[str] type: The type of the subscription target.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubscriptionTargetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Subscription targets enables one to access the data to which you have subscribed in your projects.

        :param str resource_name: The name of the resource.
        :param SubscriptionTargetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubscriptionTargetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 applicable_asset_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 authorized_principals: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 domain_identifier: Optional[pulumi.Input[str]] = None,
                 environment_identifier: Optional[pulumi.Input[str]] = None,
                 manage_access_role: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 provider: Optional[pulumi.Input[str]] = None,
                 subscription_target_config: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SubscriptionTargetFormArgs', 'SubscriptionTargetFormArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubscriptionTargetArgs.__new__(SubscriptionTargetArgs)

            if applicable_asset_types is None and not opts.urn:
                raise TypeError("Missing required property 'applicable_asset_types'")
            __props__.__dict__["applicable_asset_types"] = applicable_asset_types
            if authorized_principals is None and not opts.urn:
                raise TypeError("Missing required property 'authorized_principals'")
            __props__.__dict__["authorized_principals"] = authorized_principals
            if domain_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'domain_identifier'")
            __props__.__dict__["domain_identifier"] = domain_identifier
            if environment_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'environment_identifier'")
            __props__.__dict__["environment_identifier"] = environment_identifier
            if manage_access_role is None and not opts.urn:
                raise TypeError("Missing required property 'manage_access_role'")
            __props__.__dict__["manage_access_role"] = manage_access_role
            __props__.__dict__["name"] = name
            __props__.__dict__["provider"] = provider
            if subscription_target_config is None and not opts.urn:
                raise TypeError("Missing required property 'subscription_target_config'")
            __props__.__dict__["subscription_target_config"] = subscription_target_config
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["domain_id"] = None
            __props__.__dict__["environment_id"] = None
            __props__.__dict__["project_id"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["updated_by"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["domainIdentifier", "environmentIdentifier", "type"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(SubscriptionTarget, __self__).__init__(
            'aws-native:datazone:SubscriptionTarget',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SubscriptionTarget':
        """
        Get an existing SubscriptionTarget resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SubscriptionTargetArgs.__new__(SubscriptionTargetArgs)

        __props__.__dict__["applicable_asset_types"] = None
        __props__.__dict__["authorized_principals"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["created_by"] = None
        __props__.__dict__["domain_id"] = None
        __props__.__dict__["domain_identifier"] = None
        __props__.__dict__["environment_id"] = None
        __props__.__dict__["environment_identifier"] = None
        __props__.__dict__["manage_access_role"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project_id"] = None
        __props__.__dict__["provider"] = None
        __props__.__dict__["subscription_target_config"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["updated_at"] = None
        __props__.__dict__["updated_by"] = None
        return SubscriptionTarget(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicableAssetTypes")
    def applicable_asset_types(self) -> pulumi.Output[Sequence[str]]:
        """
        The asset types that can be included in the subscription target.
        """
        return pulumi.get(self, "applicable_asset_types")

    @property
    @pulumi.getter(name="authorizedPrincipals")
    def authorized_principals(self) -> pulumi.Output[Sequence[str]]:
        """
        The authorized principals of the subscription target.
        """
        return pulumi.get(self, "authorized_principals")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[str]:
        """
        The ID of the subscription target.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The timestamp of when the subscription target was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[str]:
        """
        The Amazon DataZone user who created the subscription target.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[str]:
        """
        The ID of the Amazon DataZone domain in which subscription target is created.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Output[str]:
        """
        The ID of the Amazon DataZone domain in which subscription target would be created.
        """
        return pulumi.get(self, "domain_identifier")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> pulumi.Output[str]:
        """
        The ID of the environment in which subscription target is created.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="environmentIdentifier")
    def environment_identifier(self) -> pulumi.Output[str]:
        """
        The ID of the environment in which subscription target would be created.
        """
        return pulumi.get(self, "environment_identifier")

    @property
    @pulumi.getter(name="manageAccessRole")
    def manage_access_role(self) -> pulumi.Output[str]:
        """
        The manage access role that is used to create the subscription target.
        """
        return pulumi.get(self, "manage_access_role")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the subscription target.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The identifier of the project specified in the subscription target.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def provider(self) -> pulumi.Output[Optional[str]]:
        """
        The provider of the subscription target.
        """
        return pulumi.get(self, "provider")

    @property
    @pulumi.getter(name="subscriptionTargetConfig")
    def subscription_target_config(self) -> pulumi.Output[Sequence['outputs.SubscriptionTargetForm']]:
        """
        The configuration of the subscription target.
        """
        return pulumi.get(self, "subscription_target_config")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the subscription target.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        The timestamp of when the subscription target was updated.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> pulumi.Output[str]:
        """
        The Amazon DataZone user who updated the subscription target.
        """
        return pulumi.get(self, "updated_by")

