# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetEnvironmentProfileResult',
    'AwaitableGetEnvironmentProfileResult',
    'get_environment_profile',
    'get_environment_profile_output',
]

@pulumi.output_type
class GetEnvironmentProfileResult:
    def __init__(__self__, aws_account_id=None, aws_account_region=None, created_at=None, created_by=None, description=None, domain_id=None, environment_blueprint_id=None, id=None, name=None, project_id=None, updated_at=None, user_parameters=None):
        if aws_account_id and not isinstance(aws_account_id, str):
            raise TypeError("Expected argument 'aws_account_id' to be a str")
        pulumi.set(__self__, "aws_account_id", aws_account_id)
        if aws_account_region and not isinstance(aws_account_region, str):
            raise TypeError("Expected argument 'aws_account_region' to be a str")
        pulumi.set(__self__, "aws_account_region", aws_account_region)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain_id and not isinstance(domain_id, str):
            raise TypeError("Expected argument 'domain_id' to be a str")
        pulumi.set(__self__, "domain_id", domain_id)
        if environment_blueprint_id and not isinstance(environment_blueprint_id, str):
            raise TypeError("Expected argument 'environment_blueprint_id' to be a str")
        pulumi.set(__self__, "environment_blueprint_id", environment_blueprint_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if user_parameters and not isinstance(user_parameters, list):
            raise TypeError("Expected argument 'user_parameters' to be a list")
        pulumi.set(__self__, "user_parameters", user_parameters)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> Optional[str]:
        """
        The AWS account in which the Amazon DataZone environment is created.
        """
        return pulumi.get(self, "aws_account_id")

    @property
    @pulumi.getter(name="awsAccountRegion")
    def aws_account_region(self) -> Optional[str]:
        """
        The AWS region in which this environment profile is created.
        """
        return pulumi.get(self, "aws_account_region")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The timestamp of when this environment profile was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[str]:
        """
        The Amazon DataZone user who created this environment profile.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of this Amazon DataZone environment profile.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[str]:
        """
        The ID of the Amazon DataZone domain in which this environment profile is created.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="environmentBlueprintId")
    def environment_blueprint_id(self) -> Optional[str]:
        """
        The ID of the blueprint with which this environment profile is created.
        """
        return pulumi.get(self, "environment_blueprint_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of this Amazon DataZone environment profile.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of this Amazon DataZone environment profile.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        The identifier of the project in which to create the environment profile.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[str]:
        """
        The timestamp of when this environment profile was updated.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="userParameters")
    def user_parameters(self) -> Optional[Sequence['outputs.EnvironmentProfileEnvironmentParameter']]:
        """
        The user parameters of this Amazon DataZone environment profile.
        """
        return pulumi.get(self, "user_parameters")


class AwaitableGetEnvironmentProfileResult(GetEnvironmentProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnvironmentProfileResult(
            aws_account_id=self.aws_account_id,
            aws_account_region=self.aws_account_region,
            created_at=self.created_at,
            created_by=self.created_by,
            description=self.description,
            domain_id=self.domain_id,
            environment_blueprint_id=self.environment_blueprint_id,
            id=self.id,
            name=self.name,
            project_id=self.project_id,
            updated_at=self.updated_at,
            user_parameters=self.user_parameters)


def get_environment_profile(domain_id: Optional[str] = None,
                            id: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnvironmentProfileResult:
    """
    AWS Datazone Environment Profile is pre-configured set of resources and blueprints that provide reusable templates for creating environments.


    :param str domain_id: The ID of the Amazon DataZone domain in which this environment profile is created.
    :param str id: The ID of this Amazon DataZone environment profile.
    """
    __args__ = dict()
    __args__['domainId'] = domain_id
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:datazone:getEnvironmentProfile', __args__, opts=opts, typ=GetEnvironmentProfileResult).value

    return AwaitableGetEnvironmentProfileResult(
        aws_account_id=pulumi.get(__ret__, 'aws_account_id'),
        aws_account_region=pulumi.get(__ret__, 'aws_account_region'),
        created_at=pulumi.get(__ret__, 'created_at'),
        created_by=pulumi.get(__ret__, 'created_by'),
        description=pulumi.get(__ret__, 'description'),
        domain_id=pulumi.get(__ret__, 'domain_id'),
        environment_blueprint_id=pulumi.get(__ret__, 'environment_blueprint_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        project_id=pulumi.get(__ret__, 'project_id'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        user_parameters=pulumi.get(__ret__, 'user_parameters'))
def get_environment_profile_output(domain_id: Optional[pulumi.Input[str]] = None,
                                   id: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEnvironmentProfileResult]:
    """
    AWS Datazone Environment Profile is pre-configured set of resources and blueprints that provide reusable templates for creating environments.


    :param str domain_id: The ID of the Amazon DataZone domain in which this environment profile is created.
    :param str id: The ID of this Amazon DataZone environment profile.
    """
    __args__ = dict()
    __args__['domainId'] = domain_id
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:datazone:getEnvironmentProfile', __args__, opts=opts, typ=GetEnvironmentProfileResult)
    return __ret__.apply(lambda __response__: GetEnvironmentProfileResult(
        aws_account_id=pulumi.get(__response__, 'aws_account_id'),
        aws_account_region=pulumi.get(__response__, 'aws_account_region'),
        created_at=pulumi.get(__response__, 'created_at'),
        created_by=pulumi.get(__response__, 'created_by'),
        description=pulumi.get(__response__, 'description'),
        domain_id=pulumi.get(__response__, 'domain_id'),
        environment_blueprint_id=pulumi.get(__response__, 'environment_blueprint_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        project_id=pulumi.get(__response__, 'project_id'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        user_parameters=pulumi.get(__response__, 'user_parameters')))
