# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetEnvironmentActionsResult',
    'AwaitableGetEnvironmentActionsResult',
    'get_environment_actions',
    'get_environment_actions_output',
]

@pulumi.output_type
class GetEnvironmentActionsResult:
    def __init__(__self__, description=None, domain_id=None, environment_id=None, id=None, name=None, parameters=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain_id and not isinstance(domain_id, str):
            raise TypeError("Expected argument 'domain_id' to be a str")
        pulumi.set(__self__, "domain_id", domain_id)
        if environment_id and not isinstance(environment_id, str):
            raise TypeError("Expected argument 'environment_id' to be a str")
        pulumi.set(__self__, "environment_id", environment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parameters and not isinstance(parameters, dict):
            raise TypeError("Expected argument 'parameters' to be a dict")
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the Amazon DataZone environment action.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[str]:
        """
        The identifier of the Amazon DataZone domain in which the environment is created.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> Optional[str]:
        """
        The identifier of the Amazon DataZone environment in which the action is taking place
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the Amazon DataZone environment action.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the environment action.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> Optional['outputs.EnvironmentActionsAwsConsoleLinkParameters']:
        """
        The parameters of the environment action.
        """
        return pulumi.get(self, "parameters")


class AwaitableGetEnvironmentActionsResult(GetEnvironmentActionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnvironmentActionsResult(
            description=self.description,
            domain_id=self.domain_id,
            environment_id=self.environment_id,
            id=self.id,
            name=self.name,
            parameters=self.parameters)


def get_environment_actions(domain_id: Optional[str] = None,
                            environment_id: Optional[str] = None,
                            id: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnvironmentActionsResult:
    """
    Definition of AWS::DataZone::EnvironmentActions Resource Type


    :param str domain_id: The identifier of the Amazon DataZone domain in which the environment is created.
    :param str environment_id: The identifier of the Amazon DataZone environment in which the action is taking place
    :param str id: The ID of the Amazon DataZone environment action.
    """
    __args__ = dict()
    __args__['domainId'] = domain_id
    __args__['environmentId'] = environment_id
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:datazone:getEnvironmentActions', __args__, opts=opts, typ=GetEnvironmentActionsResult).value

    return AwaitableGetEnvironmentActionsResult(
        description=pulumi.get(__ret__, 'description'),
        domain_id=pulumi.get(__ret__, 'domain_id'),
        environment_id=pulumi.get(__ret__, 'environment_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        parameters=pulumi.get(__ret__, 'parameters'))
def get_environment_actions_output(domain_id: Optional[pulumi.Input[str]] = None,
                                   environment_id: Optional[pulumi.Input[str]] = None,
                                   id: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEnvironmentActionsResult]:
    """
    Definition of AWS::DataZone::EnvironmentActions Resource Type


    :param str domain_id: The identifier of the Amazon DataZone domain in which the environment is created.
    :param str environment_id: The identifier of the Amazon DataZone environment in which the action is taking place
    :param str id: The ID of the Amazon DataZone environment action.
    """
    __args__ = dict()
    __args__['domainId'] = domain_id
    __args__['environmentId'] = environment_id
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:datazone:getEnvironmentActions', __args__, opts=opts, typ=GetEnvironmentActionsResult)
    return __ret__.apply(lambda __response__: GetEnvironmentActionsResult(
        description=pulumi.get(__response__, 'description'),
        domain_id=pulumi.get(__response__, 'domain_id'),
        environment_id=pulumi.get(__response__, 'environment_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        parameters=pulumi.get(__response__, 'parameters')))
