# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EnvironmentProfileArgs', 'EnvironmentProfile']

@pulumi.input_type
class EnvironmentProfileArgs:
    def __init__(__self__, *,
                 aws_account_id: pulumi.Input[str],
                 aws_account_region: pulumi.Input[str],
                 domain_identifier: pulumi.Input[str],
                 environment_blueprint_identifier: pulumi.Input[str],
                 project_identifier: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 user_parameters: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentProfileEnvironmentParameterArgs']]]] = None):
        """
        The set of arguments for constructing a EnvironmentProfile resource.
        :param pulumi.Input[str] aws_account_id: The AWS account in which the Amazon DataZone environment is created.
        :param pulumi.Input[str] aws_account_region: The AWS region in which this environment profile is created.
        :param pulumi.Input[str] domain_identifier: The ID of the Amazon DataZone domain in which this environment profile is created.
        :param pulumi.Input[str] environment_blueprint_identifier: The ID of the blueprint with which this environment profile is created.
        :param pulumi.Input[str] project_identifier: The identifier of the project in which to create the environment profile.
        :param pulumi.Input[str] description: The description of this Amazon DataZone environment profile.
        :param pulumi.Input[str] name: The name of this Amazon DataZone environment profile.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentProfileEnvironmentParameterArgs']]] user_parameters: The user parameters of this Amazon DataZone environment profile.
        """
        pulumi.set(__self__, "aws_account_id", aws_account_id)
        pulumi.set(__self__, "aws_account_region", aws_account_region)
        pulumi.set(__self__, "domain_identifier", domain_identifier)
        pulumi.set(__self__, "environment_blueprint_identifier", environment_blueprint_identifier)
        pulumi.set(__self__, "project_identifier", project_identifier)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if user_parameters is not None:
            pulumi.set(__self__, "user_parameters", user_parameters)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> pulumi.Input[str]:
        """
        The AWS account in which the Amazon DataZone environment is created.
        """
        return pulumi.get(self, "aws_account_id")

    @aws_account_id.setter
    def aws_account_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "aws_account_id", value)

    @property
    @pulumi.getter(name="awsAccountRegion")
    def aws_account_region(self) -> pulumi.Input[str]:
        """
        The AWS region in which this environment profile is created.
        """
        return pulumi.get(self, "aws_account_region")

    @aws_account_region.setter
    def aws_account_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "aws_account_region", value)

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Input[str]:
        """
        The ID of the Amazon DataZone domain in which this environment profile is created.
        """
        return pulumi.get(self, "domain_identifier")

    @domain_identifier.setter
    def domain_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_identifier", value)

    @property
    @pulumi.getter(name="environmentBlueprintIdentifier")
    def environment_blueprint_identifier(self) -> pulumi.Input[str]:
        """
        The ID of the blueprint with which this environment profile is created.
        """
        return pulumi.get(self, "environment_blueprint_identifier")

    @environment_blueprint_identifier.setter
    def environment_blueprint_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "environment_blueprint_identifier", value)

    @property
    @pulumi.getter(name="projectIdentifier")
    def project_identifier(self) -> pulumi.Input[str]:
        """
        The identifier of the project in which to create the environment profile.
        """
        return pulumi.get(self, "project_identifier")

    @project_identifier.setter
    def project_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_identifier", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of this Amazon DataZone environment profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this Amazon DataZone environment profile.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="userParameters")
    def user_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentProfileEnvironmentParameterArgs']]]]:
        """
        The user parameters of this Amazon DataZone environment profile.
        """
        return pulumi.get(self, "user_parameters")

    @user_parameters.setter
    def user_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentProfileEnvironmentParameterArgs']]]]):
        pulumi.set(self, "user_parameters", value)


class EnvironmentProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_account_id: Optional[pulumi.Input[str]] = None,
                 aws_account_region: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain_identifier: Optional[pulumi.Input[str]] = None,
                 environment_blueprint_identifier: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_identifier: Optional[pulumi.Input[str]] = None,
                 user_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentProfileEnvironmentParameterArgs', 'EnvironmentProfileEnvironmentParameterArgsDict']]]]] = None,
                 __props__=None):
        """
        AWS Datazone Environment Profile is pre-configured set of resources and blueprints that provide reusable templates for creating environments.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] aws_account_id: The AWS account in which the Amazon DataZone environment is created.
        :param pulumi.Input[str] aws_account_region: The AWS region in which this environment profile is created.
        :param pulumi.Input[str] description: The description of this Amazon DataZone environment profile.
        :param pulumi.Input[str] domain_identifier: The ID of the Amazon DataZone domain in which this environment profile is created.
        :param pulumi.Input[str] environment_blueprint_identifier: The ID of the blueprint with which this environment profile is created.
        :param pulumi.Input[str] name: The name of this Amazon DataZone environment profile.
        :param pulumi.Input[str] project_identifier: The identifier of the project in which to create the environment profile.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentProfileEnvironmentParameterArgs', 'EnvironmentProfileEnvironmentParameterArgsDict']]]] user_parameters: The user parameters of this Amazon DataZone environment profile.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        AWS Datazone Environment Profile is pre-configured set of resources and blueprints that provide reusable templates for creating environments.

        :param str resource_name: The name of the resource.
        :param EnvironmentProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_account_id: Optional[pulumi.Input[str]] = None,
                 aws_account_region: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain_identifier: Optional[pulumi.Input[str]] = None,
                 environment_blueprint_identifier: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_identifier: Optional[pulumi.Input[str]] = None,
                 user_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnvironmentProfileEnvironmentParameterArgs', 'EnvironmentProfileEnvironmentParameterArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentProfileArgs.__new__(EnvironmentProfileArgs)

            if aws_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'aws_account_id'")
            __props__.__dict__["aws_account_id"] = aws_account_id
            if aws_account_region is None and not opts.urn:
                raise TypeError("Missing required property 'aws_account_region'")
            __props__.__dict__["aws_account_region"] = aws_account_region
            __props__.__dict__["description"] = description
            if domain_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'domain_identifier'")
            __props__.__dict__["domain_identifier"] = domain_identifier
            if environment_blueprint_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'environment_blueprint_identifier'")
            __props__.__dict__["environment_blueprint_identifier"] = environment_blueprint_identifier
            __props__.__dict__["name"] = name
            if project_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'project_identifier'")
            __props__.__dict__["project_identifier"] = project_identifier
            __props__.__dict__["user_parameters"] = user_parameters
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["domain_id"] = None
            __props__.__dict__["environment_blueprint_id"] = None
            __props__.__dict__["project_id"] = None
            __props__.__dict__["updated_at"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["domainIdentifier", "environmentBlueprintIdentifier", "projectIdentifier"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(EnvironmentProfile, __self__).__init__(
            'aws-native:datazone:EnvironmentProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'EnvironmentProfile':
        """
        Get an existing EnvironmentProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EnvironmentProfileArgs.__new__(EnvironmentProfileArgs)

        __props__.__dict__["aws_account_id"] = None
        __props__.__dict__["aws_account_region"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["created_by"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["domain_id"] = None
        __props__.__dict__["domain_identifier"] = None
        __props__.__dict__["environment_blueprint_id"] = None
        __props__.__dict__["environment_blueprint_identifier"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project_id"] = None
        __props__.__dict__["project_identifier"] = None
        __props__.__dict__["updated_at"] = None
        __props__.__dict__["user_parameters"] = None
        return EnvironmentProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> pulumi.Output[str]:
        """
        The AWS account in which the Amazon DataZone environment is created.
        """
        return pulumi.get(self, "aws_account_id")

    @property
    @pulumi.getter(name="awsAccountRegion")
    def aws_account_region(self) -> pulumi.Output[str]:
        """
        The AWS region in which this environment profile is created.
        """
        return pulumi.get(self, "aws_account_region")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[str]:
        """
        The ID of this Amazon DataZone environment profile.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The timestamp of when this environment profile was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[str]:
        """
        The Amazon DataZone user who created this environment profile.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of this Amazon DataZone environment profile.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[str]:
        """
        The ID of the Amazon DataZone domain in which this environment profile is created.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="domainIdentifier")
    def domain_identifier(self) -> pulumi.Output[str]:
        """
        The ID of the Amazon DataZone domain in which this environment profile is created.
        """
        return pulumi.get(self, "domain_identifier")

    @property
    @pulumi.getter(name="environmentBlueprintId")
    def environment_blueprint_id(self) -> pulumi.Output[str]:
        """
        The ID of the blueprint with which this environment profile is created.
        """
        return pulumi.get(self, "environment_blueprint_id")

    @property
    @pulumi.getter(name="environmentBlueprintIdentifier")
    def environment_blueprint_identifier(self) -> pulumi.Output[str]:
        """
        The ID of the blueprint with which this environment profile is created.
        """
        return pulumi.get(self, "environment_blueprint_identifier")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of this Amazon DataZone environment profile.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The identifier of the project in which to create the environment profile.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="projectIdentifier")
    def project_identifier(self) -> pulumi.Output[str]:
        """
        The identifier of the project in which to create the environment profile.
        """
        return pulumi.get(self, "project_identifier")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        The timestamp of when this environment profile was updated.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="userParameters")
    def user_parameters(self) -> pulumi.Output[Optional[Sequence['outputs.EnvironmentProfileEnvironmentParameter']]]:
        """
        The user parameters of this Amazon DataZone environment profile.
        """
        return pulumi.get(self, "user_parameters")

