# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['StorageSystemArgs', 'StorageSystem']

@pulumi.input_type
class StorageSystemArgs:
    def __init__(__self__, *,
                 agent_arns: pulumi.Input[Sequence[pulumi.Input[str]]],
                 server_configuration: pulumi.Input['StorageSystemServerConfigurationArgs'],
                 system_type: pulumi.Input['StorageSystemSystemType'],
                 cloud_watch_log_group_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 server_credentials: Optional[pulumi.Input['StorageSystemServerCredentialsArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a StorageSystem resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] agent_arns: The ARN of the DataSync agent that connects to and reads from the on-premises storage system's management interface.
        :param pulumi.Input['StorageSystemServerConfigurationArgs'] server_configuration: Specifies the server name and network port required to connect with the management interface of your on-premises storage system.
        :param pulumi.Input['StorageSystemSystemType'] system_type: The type of on-premises storage system that DataSync Discovery will analyze.
        :param pulumi.Input[str] cloud_watch_log_group_arn: The ARN of the Amazon CloudWatch log group used to monitor and log discovery job events.
        :param pulumi.Input[str] name: A familiar name for the on-premises storage system.
        :param pulumi.Input['StorageSystemServerCredentialsArgs'] server_credentials: Specifies the user name and password for accessing your on-premises storage system's management interface.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "agent_arns", agent_arns)
        pulumi.set(__self__, "server_configuration", server_configuration)
        pulumi.set(__self__, "system_type", system_type)
        if cloud_watch_log_group_arn is not None:
            pulumi.set(__self__, "cloud_watch_log_group_arn", cloud_watch_log_group_arn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if server_credentials is not None:
            pulumi.set(__self__, "server_credentials", server_credentials)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="agentArns")
    def agent_arns(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The ARN of the DataSync agent that connects to and reads from the on-premises storage system's management interface.
        """
        return pulumi.get(self, "agent_arns")

    @agent_arns.setter
    def agent_arns(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "agent_arns", value)

    @property
    @pulumi.getter(name="serverConfiguration")
    def server_configuration(self) -> pulumi.Input['StorageSystemServerConfigurationArgs']:
        """
        Specifies the server name and network port required to connect with the management interface of your on-premises storage system.
        """
        return pulumi.get(self, "server_configuration")

    @server_configuration.setter
    def server_configuration(self, value: pulumi.Input['StorageSystemServerConfigurationArgs']):
        pulumi.set(self, "server_configuration", value)

    @property
    @pulumi.getter(name="systemType")
    def system_type(self) -> pulumi.Input['StorageSystemSystemType']:
        """
        The type of on-premises storage system that DataSync Discovery will analyze.
        """
        return pulumi.get(self, "system_type")

    @system_type.setter
    def system_type(self, value: pulumi.Input['StorageSystemSystemType']):
        pulumi.set(self, "system_type", value)

    @property
    @pulumi.getter(name="cloudWatchLogGroupArn")
    def cloud_watch_log_group_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the Amazon CloudWatch log group used to monitor and log discovery job events.
        """
        return pulumi.get(self, "cloud_watch_log_group_arn")

    @cloud_watch_log_group_arn.setter
    def cloud_watch_log_group_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_watch_log_group_arn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A familiar name for the on-premises storage system.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serverCredentials")
    def server_credentials(self) -> Optional[pulumi.Input['StorageSystemServerCredentialsArgs']]:
        """
        Specifies the user name and password for accessing your on-premises storage system's management interface.
        """
        return pulumi.get(self, "server_credentials")

    @server_credentials.setter
    def server_credentials(self, value: Optional[pulumi.Input['StorageSystemServerCredentialsArgs']]):
        pulumi.set(self, "server_credentials", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class StorageSystem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cloud_watch_log_group_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 server_configuration: Optional[pulumi.Input[Union['StorageSystemServerConfigurationArgs', 'StorageSystemServerConfigurationArgsDict']]] = None,
                 server_credentials: Optional[pulumi.Input[Union['StorageSystemServerCredentialsArgs', 'StorageSystemServerCredentialsArgsDict']]] = None,
                 system_type: Optional[pulumi.Input['StorageSystemSystemType']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource schema for AWS::DataSync::StorageSystem.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] agent_arns: The ARN of the DataSync agent that connects to and reads from the on-premises storage system's management interface.
        :param pulumi.Input[str] cloud_watch_log_group_arn: The ARN of the Amazon CloudWatch log group used to monitor and log discovery job events.
        :param pulumi.Input[str] name: A familiar name for the on-premises storage system.
        :param pulumi.Input[Union['StorageSystemServerConfigurationArgs', 'StorageSystemServerConfigurationArgsDict']] server_configuration: Specifies the server name and network port required to connect with the management interface of your on-premises storage system.
        :param pulumi.Input[Union['StorageSystemServerCredentialsArgs', 'StorageSystemServerCredentialsArgsDict']] server_credentials: Specifies the user name and password for accessing your on-premises storage system's management interface.
        :param pulumi.Input['StorageSystemSystemType'] system_type: The type of on-premises storage system that DataSync Discovery will analyze.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StorageSystemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::DataSync::StorageSystem.

        :param str resource_name: The name of the resource.
        :param StorageSystemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StorageSystemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cloud_watch_log_group_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 server_configuration: Optional[pulumi.Input[Union['StorageSystemServerConfigurationArgs', 'StorageSystemServerConfigurationArgsDict']]] = None,
                 server_credentials: Optional[pulumi.Input[Union['StorageSystemServerCredentialsArgs', 'StorageSystemServerCredentialsArgsDict']]] = None,
                 system_type: Optional[pulumi.Input['StorageSystemSystemType']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StorageSystemArgs.__new__(StorageSystemArgs)

            if agent_arns is None and not opts.urn:
                raise TypeError("Missing required property 'agent_arns'")
            __props__.__dict__["agent_arns"] = agent_arns
            __props__.__dict__["cloud_watch_log_group_arn"] = cloud_watch_log_group_arn
            __props__.__dict__["name"] = name
            if server_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'server_configuration'")
            __props__.__dict__["server_configuration"] = server_configuration
            __props__.__dict__["server_credentials"] = server_credentials
            if system_type is None and not opts.urn:
                raise TypeError("Missing required property 'system_type'")
            __props__.__dict__["system_type"] = system_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["connectivity_status"] = None
            __props__.__dict__["secrets_manager_arn"] = None
            __props__.__dict__["storage_system_arn"] = None
        super(StorageSystem, __self__).__init__(
            'aws-native:datasync:StorageSystem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'StorageSystem':
        """
        Get an existing StorageSystem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = StorageSystemArgs.__new__(StorageSystemArgs)

        __props__.__dict__["agent_arns"] = None
        __props__.__dict__["cloud_watch_log_group_arn"] = None
        __props__.__dict__["connectivity_status"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["secrets_manager_arn"] = None
        __props__.__dict__["server_configuration"] = None
        __props__.__dict__["server_credentials"] = None
        __props__.__dict__["storage_system_arn"] = None
        __props__.__dict__["system_type"] = None
        __props__.__dict__["tags"] = None
        return StorageSystem(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentArns")
    def agent_arns(self) -> pulumi.Output[Sequence[str]]:
        """
        The ARN of the DataSync agent that connects to and reads from the on-premises storage system's management interface.
        """
        return pulumi.get(self, "agent_arns")

    @property
    @pulumi.getter(name="cloudWatchLogGroupArn")
    def cloud_watch_log_group_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The ARN of the Amazon CloudWatch log group used to monitor and log discovery job events.
        """
        return pulumi.get(self, "cloud_watch_log_group_arn")

    @property
    @pulumi.getter(name="connectivityStatus")
    def connectivity_status(self) -> pulumi.Output['StorageSystemConnectivityStatus']:
        """
        Indicates whether the DataSync agent can access the on-premises storage system.
        """
        return pulumi.get(self, "connectivity_status")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[str]]:
        """
        A familiar name for the on-premises storage system.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretsManagerArn")
    def secrets_manager_arn(self) -> pulumi.Output[str]:
        """
        The ARN of a secret stored by AWS Secrets Manager.
        """
        return pulumi.get(self, "secrets_manager_arn")

    @property
    @pulumi.getter(name="serverConfiguration")
    def server_configuration(self) -> pulumi.Output['outputs.StorageSystemServerConfiguration']:
        """
        Specifies the server name and network port required to connect with the management interface of your on-premises storage system.
        """
        return pulumi.get(self, "server_configuration")

    @property
    @pulumi.getter(name="serverCredentials")
    def server_credentials(self) -> pulumi.Output[Optional['outputs.StorageSystemServerCredentials']]:
        """
        Specifies the user name and password for accessing your on-premises storage system's management interface.
        """
        return pulumi.get(self, "server_credentials")

    @property
    @pulumi.getter(name="storageSystemArn")
    def storage_system_arn(self) -> pulumi.Output[str]:
        """
        The ARN of the on-premises storage system added to DataSync Discovery.
        """
        return pulumi.get(self, "storage_system_arn")

    @property
    @pulumi.getter(name="systemType")
    def system_type(self) -> pulumi.Output['StorageSystemSystemType']:
        """
        The type of on-premises storage system that DataSync Discovery will analyze.
        """
        return pulumi.get(self, "system_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

