# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'LocationAzureBlobAzureBlobSasConfiguration',
    'LocationEfsEc2Config',
    'LocationFSxOntapNfs',
    'LocationFSxOntapNfsMountOptions',
    'LocationFSxOntapProtocol',
    'LocationFSxOntapSmb',
    'LocationFSxOntapSmbMountOptions',
    'LocationFSxOpenZfsMountOptions',
    'LocationFSxOpenZfsNfs',
    'LocationFSxOpenZfsProtocol',
    'LocationHdfsNameNode',
    'LocationHdfsQopConfiguration',
    'LocationNfsMountOptions',
    'LocationNfsOnPremConfig',
    'LocationS3s3Config',
    'LocationSmbMountOptions',
    'StorageSystemServerConfiguration',
    'StorageSystemServerCredentials',
    'TaskFilterRule',
    'TaskManifestConfig',
    'TaskManifestConfigSourceProperties',
    'TaskManifestConfigSourceS3',
    'TaskOptions',
    'TaskReportConfig',
    'TaskReportConfigDestinationProperties',
    'TaskReportConfigDestinationS3',
    'TaskReportConfigOverridesProperties',
    'TaskReportConfigOverridesPropertiesDeletedProperties',
    'TaskReportConfigOverridesPropertiesSkippedProperties',
    'TaskReportConfigOverridesPropertiesTransferredProperties',
    'TaskReportConfigOverridesPropertiesVerifiedProperties',
    'TaskSchedule',
]

@pulumi.output_type
class LocationAzureBlobAzureBlobSasConfiguration(dict):
    """
    Specifies the shared access signature (SAS) that DataSync uses to access your Azure Blob Storage container.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureBlobSasToken":
            suggest = "azure_blob_sas_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocationAzureBlobAzureBlobSasConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocationAzureBlobAzureBlobSasConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocationAzureBlobAzureBlobSasConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_blob_sas_token: str):
        """
        Specifies the shared access signature (SAS) that DataSync uses to access your Azure Blob Storage container.
        :param str azure_blob_sas_token: Specifies the shared access signature (SAS) token, which indicates the permissions DataSync needs to access your Azure Blob Storage container.
        """
        pulumi.set(__self__, "azure_blob_sas_token", azure_blob_sas_token)

    @property
    @pulumi.getter(name="azureBlobSasToken")
    def azure_blob_sas_token(self) -> str:
        """
        Specifies the shared access signature (SAS) token, which indicates the permissions DataSync needs to access your Azure Blob Storage container.
        """
        return pulumi.get(self, "azure_blob_sas_token")


@pulumi.output_type
class LocationEfsEc2Config(dict):
    """
    The subnet and security group that DataSync uses to access target EFS file system.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupArns":
            suggest = "security_group_arns"
        elif key == "subnetArn":
            suggest = "subnet_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocationEfsEc2Config. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocationEfsEc2Config.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocationEfsEc2Config.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_arns: Sequence[str],
                 subnet_arn: str):
        """
        The subnet and security group that DataSync uses to access target EFS file system.
        :param Sequence[str] security_group_arns: The Amazon Resource Names (ARNs) of the security groups that are configured for the Amazon EC2 resource.
        :param str subnet_arn: The ARN of the subnet that DataSync uses to access the target EFS file system.
        """
        pulumi.set(__self__, "security_group_arns", security_group_arns)
        pulumi.set(__self__, "subnet_arn", subnet_arn)

    @property
    @pulumi.getter(name="securityGroupArns")
    def security_group_arns(self) -> Sequence[str]:
        """
        The Amazon Resource Names (ARNs) of the security groups that are configured for the Amazon EC2 resource.
        """
        return pulumi.get(self, "security_group_arns")

    @property
    @pulumi.getter(name="subnetArn")
    def subnet_arn(self) -> str:
        """
        The ARN of the subnet that DataSync uses to access the target EFS file system.
        """
        return pulumi.get(self, "subnet_arn")


@pulumi.output_type
class LocationFSxOntapNfs(dict):
    """
    NFS protocol configuration for FSx ONTAP file system.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountOptions":
            suggest = "mount_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocationFSxOntapNfs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocationFSxOntapNfs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocationFSxOntapNfs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_options: 'outputs.LocationFSxOntapNfsMountOptions'):
        """
        NFS protocol configuration for FSx ONTAP file system.
        :param 'LocationFSxOntapNfsMountOptions' mount_options: Specifies how DataSync can access a location using the NFS protocol.
        """
        pulumi.set(__self__, "mount_options", mount_options)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> 'outputs.LocationFSxOntapNfsMountOptions':
        """
        Specifies how DataSync can access a location using the NFS protocol.
        """
        return pulumi.get(self, "mount_options")


@pulumi.output_type
class LocationFSxOntapNfsMountOptions(dict):
    """
    The NFS mount options that DataSync can use to mount your NFS share.
    """
    def __init__(__self__, *,
                 version: Optional['LocationFSxOntapNfsMountOptionsVersion'] = None):
        """
        The NFS mount options that DataSync can use to mount your NFS share.
        :param 'LocationFSxOntapNfsMountOptionsVersion' version: The specific NFS version that you want DataSync to use to mount your NFS share.
        """
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> Optional['LocationFSxOntapNfsMountOptionsVersion']:
        """
        The specific NFS version that you want DataSync to use to mount your NFS share.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class LocationFSxOntapProtocol(dict):
    """
    Configuration settings for NFS or SMB protocol.
    """
    def __init__(__self__, *,
                 nfs: Optional['outputs.LocationFSxOntapNfs'] = None,
                 smb: Optional['outputs.LocationFSxOntapSmb'] = None):
        """
        Configuration settings for NFS or SMB protocol.
        :param 'LocationFSxOntapNfs' nfs: Specifies the Network File System (NFS) protocol configuration that DataSync uses to access your FSx for ONTAP file system's storage virtual machine (SVM).
        :param 'LocationFSxOntapSmb' smb: Specifies the Server Message Block (SMB) protocol configuration that DataSync uses to access your FSx for ONTAP file system's SVM.
        """
        if nfs is not None:
            pulumi.set(__self__, "nfs", nfs)
        if smb is not None:
            pulumi.set(__self__, "smb", smb)

    @property
    @pulumi.getter
    def nfs(self) -> Optional['outputs.LocationFSxOntapNfs']:
        """
        Specifies the Network File System (NFS) protocol configuration that DataSync uses to access your FSx for ONTAP file system's storage virtual machine (SVM).
        """
        return pulumi.get(self, "nfs")

    @property
    @pulumi.getter
    def smb(self) -> Optional['outputs.LocationFSxOntapSmb']:
        """
        Specifies the Server Message Block (SMB) protocol configuration that DataSync uses to access your FSx for ONTAP file system's SVM.
        """
        return pulumi.get(self, "smb")


@pulumi.output_type
class LocationFSxOntapSmb(dict):
    """
    SMB protocol configuration for FSx ONTAP file system.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountOptions":
            suggest = "mount_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocationFSxOntapSmb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocationFSxOntapSmb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocationFSxOntapSmb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_options: 'outputs.LocationFSxOntapSmbMountOptions',
                 password: str,
                 user: str,
                 domain: Optional[str] = None):
        """
        SMB protocol configuration for FSx ONTAP file system.
        :param 'LocationFSxOntapSmbMountOptions' mount_options: Specifies how DataSync can access a location using the SMB protocol.
        :param str password: The password of the user who can mount the share and has the permissions to access files and folders in the SMB share.
        :param str user: The user who can mount the share, has the permissions to access files and folders in the SMB share.
        :param str domain: The name of the Windows domain that the SMB server belongs to.
        """
        pulumi.set(__self__, "mount_options", mount_options)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "user", user)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> 'outputs.LocationFSxOntapSmbMountOptions':
        """
        Specifies how DataSync can access a location using the SMB protocol.
        """
        return pulumi.get(self, "mount_options")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password of the user who can mount the share and has the permissions to access files and folders in the SMB share.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The user who can mount the share, has the permissions to access files and folders in the SMB share.
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        The name of the Windows domain that the SMB server belongs to.
        """
        return pulumi.get(self, "domain")


@pulumi.output_type
class LocationFSxOntapSmbMountOptions(dict):
    """
    The mount options used by DataSync to access the SMB server.
    """
    def __init__(__self__, *,
                 version: Optional['LocationFSxOntapSmbMountOptionsVersion'] = None):
        """
        The mount options used by DataSync to access the SMB server.
        :param 'LocationFSxOntapSmbMountOptionsVersion' version: The specific SMB version that you want DataSync to use to mount your SMB share.
        """
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> Optional['LocationFSxOntapSmbMountOptionsVersion']:
        """
        The specific SMB version that you want DataSync to use to mount your SMB share.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class LocationFSxOpenZfsMountOptions(dict):
    """
    The NFS mount options that DataSync can use to mount your NFS share.
    """
    def __init__(__self__, *,
                 version: Optional['LocationFSxOpenZfsMountOptionsVersion'] = None):
        """
        The NFS mount options that DataSync can use to mount your NFS share.
        :param 'LocationFSxOpenZfsMountOptionsVersion' version: The specific NFS version that you want DataSync to use to mount your NFS share.
        """
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> Optional['LocationFSxOpenZfsMountOptionsVersion']:
        """
        The specific NFS version that you want DataSync to use to mount your NFS share.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class LocationFSxOpenZfsNfs(dict):
    """
    FSx OpenZFS file system NFS protocol information
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountOptions":
            suggest = "mount_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocationFSxOpenZfsNfs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocationFSxOpenZfsNfs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocationFSxOpenZfsNfs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_options: 'outputs.LocationFSxOpenZfsMountOptions'):
        """
        FSx OpenZFS file system NFS protocol information
        :param 'LocationFSxOpenZfsMountOptions' mount_options: Represents the mount options that are available for DataSync to access an NFS location.
        """
        pulumi.set(__self__, "mount_options", mount_options)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> 'outputs.LocationFSxOpenZfsMountOptions':
        """
        Represents the mount options that are available for DataSync to access an NFS location.
        """
        return pulumi.get(self, "mount_options")


@pulumi.output_type
class LocationFSxOpenZfsProtocol(dict):
    """
    Configuration settings for an NFS or SMB protocol, currently only support NFS
    """
    def __init__(__self__, *,
                 nfs: Optional['outputs.LocationFSxOpenZfsNfs'] = None):
        """
        Configuration settings for an NFS or SMB protocol, currently only support NFS
        :param 'LocationFSxOpenZfsNfs' nfs: Represents the Network File System (NFS) protocol that DataSync uses to access your FSx for OpenZFS file system.
        """
        if nfs is not None:
            pulumi.set(__self__, "nfs", nfs)

    @property
    @pulumi.getter
    def nfs(self) -> Optional['outputs.LocationFSxOpenZfsNfs']:
        """
        Represents the Network File System (NFS) protocol that DataSync uses to access your FSx for OpenZFS file system.
        """
        return pulumi.get(self, "nfs")


@pulumi.output_type
class LocationHdfsNameNode(dict):
    """
    HDFS Name Node IP and port information.
    """
    def __init__(__self__, *,
                 hostname: str,
                 port: int):
        """
        HDFS Name Node IP and port information.
        :param str hostname: The DNS name or IP address of the Name Node in the customer's on premises HDFS cluster.
        :param int port: The port on which the Name Node is listening on for client requests.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        The DNS name or IP address of the Name Node in the customer's on premises HDFS cluster.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port on which the Name Node is listening on for client requests.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class LocationHdfsQopConfiguration(dict):
    """
    Configuration information for RPC Protection and Data Transfer Protection. These parameters can be set to AUTHENTICATION, INTEGRITY, or PRIVACY. The default value is PRIVACY.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataTransferProtection":
            suggest = "data_transfer_protection"
        elif key == "rpcProtection":
            suggest = "rpc_protection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocationHdfsQopConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocationHdfsQopConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocationHdfsQopConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_transfer_protection: Optional['LocationHdfsQopConfigurationDataTransferProtection'] = None,
                 rpc_protection: Optional['LocationHdfsQopConfigurationRpcProtection'] = None):
        """
        Configuration information for RPC Protection and Data Transfer Protection. These parameters can be set to AUTHENTICATION, INTEGRITY, or PRIVACY. The default value is PRIVACY.
        :param 'LocationHdfsQopConfigurationDataTransferProtection' data_transfer_protection: Configuration for Data Transfer Protection.
        :param 'LocationHdfsQopConfigurationRpcProtection' rpc_protection: Configuration for RPC Protection.
        """
        if data_transfer_protection is not None:
            pulumi.set(__self__, "data_transfer_protection", data_transfer_protection)
        if rpc_protection is not None:
            pulumi.set(__self__, "rpc_protection", rpc_protection)

    @property
    @pulumi.getter(name="dataTransferProtection")
    def data_transfer_protection(self) -> Optional['LocationHdfsQopConfigurationDataTransferProtection']:
        """
        Configuration for Data Transfer Protection.
        """
        return pulumi.get(self, "data_transfer_protection")

    @property
    @pulumi.getter(name="rpcProtection")
    def rpc_protection(self) -> Optional['LocationHdfsQopConfigurationRpcProtection']:
        """
        Configuration for RPC Protection.
        """
        return pulumi.get(self, "rpc_protection")


@pulumi.output_type
class LocationNfsMountOptions(dict):
    """
    The NFS mount options that DataSync can use to mount your NFS share.
    """
    def __init__(__self__, *,
                 version: Optional['LocationNfsMountOptionsVersion'] = None):
        """
        The NFS mount options that DataSync can use to mount your NFS share.
        :param 'LocationNfsMountOptionsVersion' version: The specific NFS version that you want DataSync to use to mount your NFS share.
        """
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> Optional['LocationNfsMountOptionsVersion']:
        """
        The specific NFS version that you want DataSync to use to mount your NFS share.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class LocationNfsOnPremConfig(dict):
    """
    Contains a list of Amazon Resource Names (ARNs) of agents that are used to connect an NFS server.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentArns":
            suggest = "agent_arns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocationNfsOnPremConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocationNfsOnPremConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocationNfsOnPremConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_arns: Sequence[str]):
        """
        Contains a list of Amazon Resource Names (ARNs) of agents that are used to connect an NFS server.
        :param Sequence[str] agent_arns: ARN(s) of the agent(s) to use for an NFS location.
        """
        pulumi.set(__self__, "agent_arns", agent_arns)

    @property
    @pulumi.getter(name="agentArns")
    def agent_arns(self) -> Sequence[str]:
        """
        ARN(s) of the agent(s) to use for an NFS location.
        """
        return pulumi.get(self, "agent_arns")


@pulumi.output_type
class LocationS3s3Config(dict):
    """
    The Amazon Resource Name (ARN) of the AWS IAM role that is used to access an Amazon S3 bucket.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketAccessRoleArn":
            suggest = "bucket_access_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocationS3s3Config. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocationS3s3Config.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocationS3s3Config.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_access_role_arn: str):
        """
        The Amazon Resource Name (ARN) of the AWS IAM role that is used to access an Amazon S3 bucket.
        :param str bucket_access_role_arn: The ARN of the IAM role of the Amazon S3 bucket.
        """
        pulumi.set(__self__, "bucket_access_role_arn", bucket_access_role_arn)

    @property
    @pulumi.getter(name="bucketAccessRoleArn")
    def bucket_access_role_arn(self) -> str:
        """
        The ARN of the IAM role of the Amazon S3 bucket.
        """
        return pulumi.get(self, "bucket_access_role_arn")


@pulumi.output_type
class LocationSmbMountOptions(dict):
    """
    The mount options used by DataSync to access the SMB server.
    """
    def __init__(__self__, *,
                 version: Optional['LocationSmbMountOptionsVersion'] = None):
        """
        The mount options used by DataSync to access the SMB server.
        :param 'LocationSmbMountOptionsVersion' version: The specific SMB version that you want DataSync to use to mount your SMB share.
        """
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> Optional['LocationSmbMountOptionsVersion']:
        """
        The specific SMB version that you want DataSync to use to mount your SMB share.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class StorageSystemServerConfiguration(dict):
    """
    The server name and network port required to connect with the management interface of the on-premises storage system.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverHostname":
            suggest = "server_hostname"
        elif key == "serverPort":
            suggest = "server_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StorageSystemServerConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StorageSystemServerConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StorageSystemServerConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 server_hostname: str,
                 server_port: Optional[int] = None):
        """
        The server name and network port required to connect with the management interface of the on-premises storage system.
        :param str server_hostname: The domain name or IP address of the storage system's management interface.
        :param int server_port: The network port needed to access the system's management interface
        """
        pulumi.set(__self__, "server_hostname", server_hostname)
        if server_port is not None:
            pulumi.set(__self__, "server_port", server_port)

    @property
    @pulumi.getter(name="serverHostname")
    def server_hostname(self) -> str:
        """
        The domain name or IP address of the storage system's management interface.
        """
        return pulumi.get(self, "server_hostname")

    @property
    @pulumi.getter(name="serverPort")
    def server_port(self) -> Optional[int]:
        """
        The network port needed to access the system's management interface
        """
        return pulumi.get(self, "server_port")


@pulumi.output_type
class StorageSystemServerCredentials(dict):
    """
    The username and password for accessing your on-premises storage system's management interface.
    """
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        The username and password for accessing your on-premises storage system's management interface.
        :param str password: The password for your storage system's management interface
        :param str username: The username for your storage system's management interface.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password for your storage system's management interface
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username for your storage system's management interface.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class TaskFilterRule(dict):
    """
    Specifies which files folders and objects to include or exclude when transferring files from source to destination.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterType":
            suggest = "filter_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskFilterRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskFilterRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskFilterRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter_type: Optional['TaskFilterRuleFilterType'] = None,
                 value: Optional[str] = None):
        """
        Specifies which files folders and objects to include or exclude when transferring files from source to destination.
        :param 'TaskFilterRuleFilterType' filter_type: The type of filter rule to apply. AWS DataSync only supports the SIMPLE_PATTERN rule type.
        :param str value: A single filter string that consists of the patterns to include or exclude. The patterns are delimited by "|".
        """
        if filter_type is not None:
            pulumi.set(__self__, "filter_type", filter_type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> Optional['TaskFilterRuleFilterType']:
        """
        The type of filter rule to apply. AWS DataSync only supports the SIMPLE_PATTERN rule type.
        """
        return pulumi.get(self, "filter_type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        A single filter string that consists of the patterns to include or exclude. The patterns are delimited by "|".
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class TaskManifestConfig(dict):
    """
    Configures a manifest, which is a list of files or objects that you want DataSync to transfer.
    """
    def __init__(__self__, *,
                 source: 'outputs.TaskManifestConfigSourceProperties',
                 action: Optional['TaskManifestConfigAction'] = None,
                 format: Optional['TaskManifestConfigFormat'] = None):
        """
        Configures a manifest, which is a list of files or objects that you want DataSync to transfer.
        :param 'TaskManifestConfigSourceProperties' source: Specifies the manifest that you want DataSync to use and where it's hosted.
        :param 'TaskManifestConfigAction' action: Specifies what DataSync uses the manifest for.
        :param 'TaskManifestConfigFormat' format: Specifies the file format of your manifest.
        """
        pulumi.set(__self__, "source", source)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if format is not None:
            pulumi.set(__self__, "format", format)

    @property
    @pulumi.getter
    def source(self) -> 'outputs.TaskManifestConfigSourceProperties':
        """
        Specifies the manifest that you want DataSync to use and where it's hosted.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def action(self) -> Optional['TaskManifestConfigAction']:
        """
        Specifies what DataSync uses the manifest for.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def format(self) -> Optional['TaskManifestConfigFormat']:
        """
        Specifies the file format of your manifest.
        """
        return pulumi.get(self, "format")


@pulumi.output_type
class TaskManifestConfigSourceProperties(dict):
    """
    Specifies the manifest that you want DataSync to use and where it's hosted.
    """
    def __init__(__self__, *,
                 s3: Optional['outputs.TaskManifestConfigSourceS3'] = None):
        """
        Specifies the manifest that you want DataSync to use and where it's hosted.
        """
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter
    def s3(self) -> Optional['outputs.TaskManifestConfigSourceS3']:
        return pulumi.get(self, "s3")


@pulumi.output_type
class TaskManifestConfigSourceS3(dict):
    """
    Specifies the S3 bucket where you're hosting the manifest that you want AWS DataSync to use.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketAccessRoleArn":
            suggest = "bucket_access_role_arn"
        elif key == "manifestObjectPath":
            suggest = "manifest_object_path"
        elif key == "manifestObjectVersionId":
            suggest = "manifest_object_version_id"
        elif key == "s3BucketArn":
            suggest = "s3_bucket_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskManifestConfigSourceS3. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskManifestConfigSourceS3.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskManifestConfigSourceS3.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_access_role_arn: Optional[str] = None,
                 manifest_object_path: Optional[str] = None,
                 manifest_object_version_id: Optional[str] = None,
                 s3_bucket_arn: Optional[str] = None):
        """
        Specifies the S3 bucket where you're hosting the manifest that you want AWS DataSync to use.
        :param str bucket_access_role_arn: Specifies the AWS Identity and Access Management (IAM) role that allows DataSync to access your manifest.
        :param str manifest_object_path: Specifies the Amazon S3 object key of your manifest.
        :param str manifest_object_version_id: Specifies the object version ID of the manifest that you want DataSync to use.
        :param str s3_bucket_arn: Specifies the Amazon Resource Name (ARN) of the S3 bucket where you're hosting your manifest.
        """
        if bucket_access_role_arn is not None:
            pulumi.set(__self__, "bucket_access_role_arn", bucket_access_role_arn)
        if manifest_object_path is not None:
            pulumi.set(__self__, "manifest_object_path", manifest_object_path)
        if manifest_object_version_id is not None:
            pulumi.set(__self__, "manifest_object_version_id", manifest_object_version_id)
        if s3_bucket_arn is not None:
            pulumi.set(__self__, "s3_bucket_arn", s3_bucket_arn)

    @property
    @pulumi.getter(name="bucketAccessRoleArn")
    def bucket_access_role_arn(self) -> Optional[str]:
        """
        Specifies the AWS Identity and Access Management (IAM) role that allows DataSync to access your manifest.
        """
        return pulumi.get(self, "bucket_access_role_arn")

    @property
    @pulumi.getter(name="manifestObjectPath")
    def manifest_object_path(self) -> Optional[str]:
        """
        Specifies the Amazon S3 object key of your manifest.
        """
        return pulumi.get(self, "manifest_object_path")

    @property
    @pulumi.getter(name="manifestObjectVersionId")
    def manifest_object_version_id(self) -> Optional[str]:
        """
        Specifies the object version ID of the manifest that you want DataSync to use.
        """
        return pulumi.get(self, "manifest_object_version_id")

    @property
    @pulumi.getter(name="s3BucketArn")
    def s3_bucket_arn(self) -> Optional[str]:
        """
        Specifies the Amazon Resource Name (ARN) of the S3 bucket where you're hosting your manifest.
        """
        return pulumi.get(self, "s3_bucket_arn")


@pulumi.output_type
class TaskOptions(dict):
    """
    Represents the options that are available to control the behavior of a StartTaskExecution operation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bytesPerSecond":
            suggest = "bytes_per_second"
        elif key == "logLevel":
            suggest = "log_level"
        elif key == "objectTags":
            suggest = "object_tags"
        elif key == "overwriteMode":
            suggest = "overwrite_mode"
        elif key == "posixPermissions":
            suggest = "posix_permissions"
        elif key == "preserveDeletedFiles":
            suggest = "preserve_deleted_files"
        elif key == "preserveDevices":
            suggest = "preserve_devices"
        elif key == "securityDescriptorCopyFlags":
            suggest = "security_descriptor_copy_flags"
        elif key == "taskQueueing":
            suggest = "task_queueing"
        elif key == "transferMode":
            suggest = "transfer_mode"
        elif key == "verifyMode":
            suggest = "verify_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 atime: Optional['TaskOptionsAtime'] = None,
                 bytes_per_second: Optional[int] = None,
                 gid: Optional['TaskOptionsGid'] = None,
                 log_level: Optional['TaskOptionsLogLevel'] = None,
                 mtime: Optional['TaskOptionsMtime'] = None,
                 object_tags: Optional['TaskOptionsObjectTags'] = None,
                 overwrite_mode: Optional['TaskOptionsOverwriteMode'] = None,
                 posix_permissions: Optional['TaskOptionsPosixPermissions'] = None,
                 preserve_deleted_files: Optional['TaskOptionsPreserveDeletedFiles'] = None,
                 preserve_devices: Optional['TaskOptionsPreserveDevices'] = None,
                 security_descriptor_copy_flags: Optional['TaskOptionsSecurityDescriptorCopyFlags'] = None,
                 task_queueing: Optional['TaskOptionsTaskQueueing'] = None,
                 transfer_mode: Optional['TaskOptionsTransferMode'] = None,
                 uid: Optional['TaskOptionsUid'] = None,
                 verify_mode: Optional['TaskOptionsVerifyMode'] = None):
        """
        Represents the options that are available to control the behavior of a StartTaskExecution operation.
        :param 'TaskOptionsAtime' atime: A file metadata value that shows the last time a file was accessed (that is, when the file was read or written to).
        :param int bytes_per_second: A value that limits the bandwidth used by AWS DataSync.
        :param 'TaskOptionsGid' gid: The group ID (GID) of the file's owners.
        :param 'TaskOptionsLogLevel' log_level: A value that determines the types of logs that DataSync publishes to a log stream in the Amazon CloudWatch log group that you provide.
        :param 'TaskOptionsMtime' mtime: A value that indicates the last time that a file was modified (that is, a file was written to) before the PREPARING phase.
        :param 'TaskOptionsObjectTags' object_tags: A value that determines whether object tags should be read from the source object store and written to the destination object store.
        :param 'TaskOptionsOverwriteMode' overwrite_mode: A value that determines whether files at the destination should be overwritten or preserved when copying files.
        :param 'TaskOptionsPosixPermissions' posix_permissions: A value that determines which users or groups can access a file for a specific purpose such as reading, writing, or execution of the file.
        :param 'TaskOptionsPreserveDeletedFiles' preserve_deleted_files: A value that specifies whether files in the destination that don't exist in the source file system should be preserved.
        :param 'TaskOptionsPreserveDevices' preserve_devices: A value that determines whether AWS DataSync should preserve the metadata of block and character devices in the source file system, and recreate the files with that device name and metadata on the destination.
        :param 'TaskOptionsSecurityDescriptorCopyFlags' security_descriptor_copy_flags: A value that determines which components of the SMB security descriptor are copied during transfer.
        :param 'TaskOptionsTaskQueueing' task_queueing: A value that determines whether tasks should be queued before executing the tasks.
        :param 'TaskOptionsTransferMode' transfer_mode: A value that determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing to the destination location.
        :param 'TaskOptionsUid' uid: The user ID (UID) of the file's owner.
        :param 'TaskOptionsVerifyMode' verify_mode: A value that determines whether a data integrity verification should be performed at the end of a task execution after all data and metadata have been transferred.
        """
        if atime is not None:
            pulumi.set(__self__, "atime", atime)
        if bytes_per_second is not None:
            pulumi.set(__self__, "bytes_per_second", bytes_per_second)
        if gid is not None:
            pulumi.set(__self__, "gid", gid)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if mtime is not None:
            pulumi.set(__self__, "mtime", mtime)
        if object_tags is not None:
            pulumi.set(__self__, "object_tags", object_tags)
        if overwrite_mode is not None:
            pulumi.set(__self__, "overwrite_mode", overwrite_mode)
        if posix_permissions is not None:
            pulumi.set(__self__, "posix_permissions", posix_permissions)
        if preserve_deleted_files is not None:
            pulumi.set(__self__, "preserve_deleted_files", preserve_deleted_files)
        if preserve_devices is not None:
            pulumi.set(__self__, "preserve_devices", preserve_devices)
        if security_descriptor_copy_flags is not None:
            pulumi.set(__self__, "security_descriptor_copy_flags", security_descriptor_copy_flags)
        if task_queueing is not None:
            pulumi.set(__self__, "task_queueing", task_queueing)
        if transfer_mode is not None:
            pulumi.set(__self__, "transfer_mode", transfer_mode)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if verify_mode is not None:
            pulumi.set(__self__, "verify_mode", verify_mode)

    @property
    @pulumi.getter
    def atime(self) -> Optional['TaskOptionsAtime']:
        """
        A file metadata value that shows the last time a file was accessed (that is, when the file was read or written to).
        """
        return pulumi.get(self, "atime")

    @property
    @pulumi.getter(name="bytesPerSecond")
    def bytes_per_second(self) -> Optional[int]:
        """
        A value that limits the bandwidth used by AWS DataSync.
        """
        return pulumi.get(self, "bytes_per_second")

    @property
    @pulumi.getter
    def gid(self) -> Optional['TaskOptionsGid']:
        """
        The group ID (GID) of the file's owners.
        """
        return pulumi.get(self, "gid")

    @property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional['TaskOptionsLogLevel']:
        """
        A value that determines the types of logs that DataSync publishes to a log stream in the Amazon CloudWatch log group that you provide.
        """
        return pulumi.get(self, "log_level")

    @property
    @pulumi.getter
    def mtime(self) -> Optional['TaskOptionsMtime']:
        """
        A value that indicates the last time that a file was modified (that is, a file was written to) before the PREPARING phase.
        """
        return pulumi.get(self, "mtime")

    @property
    @pulumi.getter(name="objectTags")
    def object_tags(self) -> Optional['TaskOptionsObjectTags']:
        """
        A value that determines whether object tags should be read from the source object store and written to the destination object store.
        """
        return pulumi.get(self, "object_tags")

    @property
    @pulumi.getter(name="overwriteMode")
    def overwrite_mode(self) -> Optional['TaskOptionsOverwriteMode']:
        """
        A value that determines whether files at the destination should be overwritten or preserved when copying files.
        """
        return pulumi.get(self, "overwrite_mode")

    @property
    @pulumi.getter(name="posixPermissions")
    def posix_permissions(self) -> Optional['TaskOptionsPosixPermissions']:
        """
        A value that determines which users or groups can access a file for a specific purpose such as reading, writing, or execution of the file.
        """
        return pulumi.get(self, "posix_permissions")

    @property
    @pulumi.getter(name="preserveDeletedFiles")
    def preserve_deleted_files(self) -> Optional['TaskOptionsPreserveDeletedFiles']:
        """
        A value that specifies whether files in the destination that don't exist in the source file system should be preserved.
        """
        return pulumi.get(self, "preserve_deleted_files")

    @property
    @pulumi.getter(name="preserveDevices")
    def preserve_devices(self) -> Optional['TaskOptionsPreserveDevices']:
        """
        A value that determines whether AWS DataSync should preserve the metadata of block and character devices in the source file system, and recreate the files with that device name and metadata on the destination.
        """
        return pulumi.get(self, "preserve_devices")

    @property
    @pulumi.getter(name="securityDescriptorCopyFlags")
    def security_descriptor_copy_flags(self) -> Optional['TaskOptionsSecurityDescriptorCopyFlags']:
        """
        A value that determines which components of the SMB security descriptor are copied during transfer.
        """
        return pulumi.get(self, "security_descriptor_copy_flags")

    @property
    @pulumi.getter(name="taskQueueing")
    def task_queueing(self) -> Optional['TaskOptionsTaskQueueing']:
        """
        A value that determines whether tasks should be queued before executing the tasks.
        """
        return pulumi.get(self, "task_queueing")

    @property
    @pulumi.getter(name="transferMode")
    def transfer_mode(self) -> Optional['TaskOptionsTransferMode']:
        """
        A value that determines whether DataSync transfers only the data and metadata that differ between the source and the destination location, or whether DataSync transfers all the content from the source, without comparing to the destination location.
        """
        return pulumi.get(self, "transfer_mode")

    @property
    @pulumi.getter
    def uid(self) -> Optional['TaskOptionsUid']:
        """
        The user ID (UID) of the file's owner.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="verifyMode")
    def verify_mode(self) -> Optional['TaskOptionsVerifyMode']:
        """
        A value that determines whether a data integrity verification should be performed at the end of a task execution after all data and metadata have been transferred.
        """
        return pulumi.get(self, "verify_mode")


@pulumi.output_type
class TaskReportConfig(dict):
    """
    Specifies how you want to configure a task report, which provides detailed information about for your Datasync transfer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputType":
            suggest = "output_type"
        elif key == "objectVersionIds":
            suggest = "object_version_ids"
        elif key == "reportLevel":
            suggest = "report_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskReportConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskReportConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskReportConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: 'outputs.TaskReportConfigDestinationProperties',
                 output_type: 'TaskReportConfigOutputType',
                 object_version_ids: Optional['TaskReportConfigObjectVersionIds'] = None,
                 overrides: Optional['outputs.TaskReportConfigOverridesProperties'] = None,
                 report_level: Optional['TaskReportConfigReportLevel'] = None):
        """
        Specifies how you want to configure a task report, which provides detailed information about for your Datasync transfer.
        :param 'TaskReportConfigDestinationProperties' destination: Specifies where DataSync uploads your task report.
        :param 'TaskReportConfigOutputType' output_type: Specifies the type of task report that you want.
        :param 'TaskReportConfigObjectVersionIds' object_version_ids: Specifies whether your task report includes the new version of each object transferred into an S3 bucket, this only applies if you enable versioning on your bucket.
        :param 'TaskReportConfigOverridesProperties' overrides: Customizes the reporting level for aspects of your task report. For example, your report might generally only include errors, but you could specify that you want a list of successes and errors just for the files that Datasync attempted to delete in your destination location.
        :param 'TaskReportConfigReportLevel' report_level: Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "output_type", output_type)
        if object_version_ids is not None:
            pulumi.set(__self__, "object_version_ids", object_version_ids)
        if overrides is not None:
            pulumi.set(__self__, "overrides", overrides)
        if report_level is not None:
            pulumi.set(__self__, "report_level", report_level)

    @property
    @pulumi.getter
    def destination(self) -> 'outputs.TaskReportConfigDestinationProperties':
        """
        Specifies where DataSync uploads your task report.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="outputType")
    def output_type(self) -> 'TaskReportConfigOutputType':
        """
        Specifies the type of task report that you want.
        """
        return pulumi.get(self, "output_type")

    @property
    @pulumi.getter(name="objectVersionIds")
    def object_version_ids(self) -> Optional['TaskReportConfigObjectVersionIds']:
        """
        Specifies whether your task report includes the new version of each object transferred into an S3 bucket, this only applies if you enable versioning on your bucket.
        """
        return pulumi.get(self, "object_version_ids")

    @property
    @pulumi.getter
    def overrides(self) -> Optional['outputs.TaskReportConfigOverridesProperties']:
        """
        Customizes the reporting level for aspects of your task report. For example, your report might generally only include errors, but you could specify that you want a list of successes and errors just for the files that Datasync attempted to delete in your destination location.
        """
        return pulumi.get(self, "overrides")

    @property
    @pulumi.getter(name="reportLevel")
    def report_level(self) -> Optional['TaskReportConfigReportLevel']:
        """
        Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
        """
        return pulumi.get(self, "report_level")


@pulumi.output_type
class TaskReportConfigDestinationProperties(dict):
    """
    Specifies where DataSync uploads your task report.
    """
    def __init__(__self__, *,
                 s3: Optional['outputs.TaskReportConfigDestinationS3'] = None):
        """
        Specifies where DataSync uploads your task report.
        """
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)

    @property
    @pulumi.getter
    def s3(self) -> Optional['outputs.TaskReportConfigDestinationS3']:
        return pulumi.get(self, "s3")


@pulumi.output_type
class TaskReportConfigDestinationS3(dict):
    """
    Specifies the Amazon S3 bucket where DataSync uploads your task report.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketAccessRoleArn":
            suggest = "bucket_access_role_arn"
        elif key == "s3BucketArn":
            suggest = "s3_bucket_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskReportConfigDestinationS3. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskReportConfigDestinationS3.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskReportConfigDestinationS3.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_access_role_arn: Optional[str] = None,
                 s3_bucket_arn: Optional[str] = None,
                 subdirectory: Optional[str] = None):
        """
        Specifies the Amazon S3 bucket where DataSync uploads your task report.
        :param str bucket_access_role_arn: Specifies the Amazon Resource Name (ARN) of the IAM policy that allows Datasync to upload a task report to your S3 bucket.
        :param str s3_bucket_arn: Specifies the ARN of the S3 bucket where Datasync uploads your report.
        :param str subdirectory: Specifies a bucket prefix for your report.
        """
        if bucket_access_role_arn is not None:
            pulumi.set(__self__, "bucket_access_role_arn", bucket_access_role_arn)
        if s3_bucket_arn is not None:
            pulumi.set(__self__, "s3_bucket_arn", s3_bucket_arn)
        if subdirectory is not None:
            pulumi.set(__self__, "subdirectory", subdirectory)

    @property
    @pulumi.getter(name="bucketAccessRoleArn")
    def bucket_access_role_arn(self) -> Optional[str]:
        """
        Specifies the Amazon Resource Name (ARN) of the IAM policy that allows Datasync to upload a task report to your S3 bucket.
        """
        return pulumi.get(self, "bucket_access_role_arn")

    @property
    @pulumi.getter(name="s3BucketArn")
    def s3_bucket_arn(self) -> Optional[str]:
        """
        Specifies the ARN of the S3 bucket where Datasync uploads your report.
        """
        return pulumi.get(self, "s3_bucket_arn")

    @property
    @pulumi.getter
    def subdirectory(self) -> Optional[str]:
        """
        Specifies a bucket prefix for your report.
        """
        return pulumi.get(self, "subdirectory")


@pulumi.output_type
class TaskReportConfigOverridesProperties(dict):
    """
    Customizes the reporting level for aspects of your task report. For example, your report might generally only include errors, but you could specify that you want a list of successes and errors just for the files that Datasync attempted to delete in your destination location.
    """
    def __init__(__self__, *,
                 deleted: Optional['outputs.TaskReportConfigOverridesPropertiesDeletedProperties'] = None,
                 skipped: Optional['outputs.TaskReportConfigOverridesPropertiesSkippedProperties'] = None,
                 transferred: Optional['outputs.TaskReportConfigOverridesPropertiesTransferredProperties'] = None,
                 verified: Optional['outputs.TaskReportConfigOverridesPropertiesVerifiedProperties'] = None):
        """
        Customizes the reporting level for aspects of your task report. For example, your report might generally only include errors, but you could specify that you want a list of successes and errors just for the files that Datasync attempted to delete in your destination location.
        :param 'TaskReportConfigOverridesPropertiesDeletedProperties' deleted: Specifies the level of reporting for the files, objects, and directories that Datasync attempted to delete in your destination location. This only applies if you configure your task to delete data in the destination that isn't in the source.
        :param 'TaskReportConfigOverridesPropertiesSkippedProperties' skipped: Specifies the level of reporting for the files, objects, and directories that Datasync attempted to skip during your transfer.
        :param 'TaskReportConfigOverridesPropertiesTransferredProperties' transferred: Specifies the level of reporting for the files, objects, and directories that Datasync attempted to transfer.
        :param 'TaskReportConfigOverridesPropertiesVerifiedProperties' verified: Specifies the level of reporting for the files, objects, and directories that Datasync attempted to verify at the end of your transfer. This only applies if you configure your task to verify data during and after the transfer (which Datasync does by default)
        """
        if deleted is not None:
            pulumi.set(__self__, "deleted", deleted)
        if skipped is not None:
            pulumi.set(__self__, "skipped", skipped)
        if transferred is not None:
            pulumi.set(__self__, "transferred", transferred)
        if verified is not None:
            pulumi.set(__self__, "verified", verified)

    @property
    @pulumi.getter
    def deleted(self) -> Optional['outputs.TaskReportConfigOverridesPropertiesDeletedProperties']:
        """
        Specifies the level of reporting for the files, objects, and directories that Datasync attempted to delete in your destination location. This only applies if you configure your task to delete data in the destination that isn't in the source.
        """
        return pulumi.get(self, "deleted")

    @property
    @pulumi.getter
    def skipped(self) -> Optional['outputs.TaskReportConfigOverridesPropertiesSkippedProperties']:
        """
        Specifies the level of reporting for the files, objects, and directories that Datasync attempted to skip during your transfer.
        """
        return pulumi.get(self, "skipped")

    @property
    @pulumi.getter
    def transferred(self) -> Optional['outputs.TaskReportConfigOverridesPropertiesTransferredProperties']:
        """
        Specifies the level of reporting for the files, objects, and directories that Datasync attempted to transfer.
        """
        return pulumi.get(self, "transferred")

    @property
    @pulumi.getter
    def verified(self) -> Optional['outputs.TaskReportConfigOverridesPropertiesVerifiedProperties']:
        """
        Specifies the level of reporting for the files, objects, and directories that Datasync attempted to verify at the end of your transfer. This only applies if you configure your task to verify data during and after the transfer (which Datasync does by default)
        """
        return pulumi.get(self, "verified")


@pulumi.output_type
class TaskReportConfigOverridesPropertiesDeletedProperties(dict):
    """
    Specifies the level of reporting for the files, objects, and directories that Datasync attempted to delete in your destination location. This only applies if you configure your task to delete data in the destination that isn't in the source.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "reportLevel":
            suggest = "report_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskReportConfigOverridesPropertiesDeletedProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskReportConfigOverridesPropertiesDeletedProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskReportConfigOverridesPropertiesDeletedProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 report_level: Optional['TaskReportConfigOverridesPropertiesDeletedPropertiesReportLevel'] = None):
        """
        Specifies the level of reporting for the files, objects, and directories that Datasync attempted to delete in your destination location. This only applies if you configure your task to delete data in the destination that isn't in the source.
        :param 'TaskReportConfigOverridesPropertiesDeletedPropertiesReportLevel' report_level: Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
        """
        if report_level is not None:
            pulumi.set(__self__, "report_level", report_level)

    @property
    @pulumi.getter(name="reportLevel")
    def report_level(self) -> Optional['TaskReportConfigOverridesPropertiesDeletedPropertiesReportLevel']:
        """
        Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
        """
        return pulumi.get(self, "report_level")


@pulumi.output_type
class TaskReportConfigOverridesPropertiesSkippedProperties(dict):
    """
    Specifies the level of reporting for the files, objects, and directories that Datasync attempted to skip during your transfer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "reportLevel":
            suggest = "report_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskReportConfigOverridesPropertiesSkippedProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskReportConfigOverridesPropertiesSkippedProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskReportConfigOverridesPropertiesSkippedProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 report_level: Optional['TaskReportConfigOverridesPropertiesSkippedPropertiesReportLevel'] = None):
        """
        Specifies the level of reporting for the files, objects, and directories that Datasync attempted to skip during your transfer.
        :param 'TaskReportConfigOverridesPropertiesSkippedPropertiesReportLevel' report_level: Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
        """
        if report_level is not None:
            pulumi.set(__self__, "report_level", report_level)

    @property
    @pulumi.getter(name="reportLevel")
    def report_level(self) -> Optional['TaskReportConfigOverridesPropertiesSkippedPropertiesReportLevel']:
        """
        Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
        """
        return pulumi.get(self, "report_level")


@pulumi.output_type
class TaskReportConfigOverridesPropertiesTransferredProperties(dict):
    """
    Specifies the level of reporting for the files, objects, and directories that Datasync attempted to transfer.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "reportLevel":
            suggest = "report_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskReportConfigOverridesPropertiesTransferredProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskReportConfigOverridesPropertiesTransferredProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskReportConfigOverridesPropertiesTransferredProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 report_level: Optional['TaskReportConfigOverridesPropertiesTransferredPropertiesReportLevel'] = None):
        """
        Specifies the level of reporting for the files, objects, and directories that Datasync attempted to transfer.
        :param 'TaskReportConfigOverridesPropertiesTransferredPropertiesReportLevel' report_level: Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
        """
        if report_level is not None:
            pulumi.set(__self__, "report_level", report_level)

    @property
    @pulumi.getter(name="reportLevel")
    def report_level(self) -> Optional['TaskReportConfigOverridesPropertiesTransferredPropertiesReportLevel']:
        """
        Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
        """
        return pulumi.get(self, "report_level")


@pulumi.output_type
class TaskReportConfigOverridesPropertiesVerifiedProperties(dict):
    """
    Specifies the level of reporting for the files, objects, and directories that Datasync attempted to verify at the end of your transfer. This only applies if you configure your task to verify data during and after the transfer (which Datasync does by default)
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "reportLevel":
            suggest = "report_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskReportConfigOverridesPropertiesVerifiedProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskReportConfigOverridesPropertiesVerifiedProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskReportConfigOverridesPropertiesVerifiedProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 report_level: Optional['TaskReportConfigOverridesPropertiesVerifiedPropertiesReportLevel'] = None):
        """
        Specifies the level of reporting for the files, objects, and directories that Datasync attempted to verify at the end of your transfer. This only applies if you configure your task to verify data during and after the transfer (which Datasync does by default)
        :param 'TaskReportConfigOverridesPropertiesVerifiedPropertiesReportLevel' report_level: Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
        """
        if report_level is not None:
            pulumi.set(__self__, "report_level", report_level)

    @property
    @pulumi.getter(name="reportLevel")
    def report_level(self) -> Optional['TaskReportConfigOverridesPropertiesVerifiedPropertiesReportLevel']:
        """
        Specifies whether you want your task report to include only what went wrong with your transfer or a list of what succeeded and didn't.
        """
        return pulumi.get(self, "report_level")


@pulumi.output_type
class TaskSchedule(dict):
    """
    Specifies the schedule you want your task to use for repeated executions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scheduleExpression":
            suggest = "schedule_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule_expression: Optional[str] = None,
                 status: Optional['TaskScheduleStatus'] = None):
        """
        Specifies the schedule you want your task to use for repeated executions.
        :param str schedule_expression: A cron expression that specifies when AWS DataSync initiates a scheduled transfer from a source to a destination location
        :param 'TaskScheduleStatus' status: Specifies status of a schedule.
        """
        if schedule_expression is not None:
            pulumi.set(__self__, "schedule_expression", schedule_expression)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> Optional[str]:
        """
        A cron expression that specifies when AWS DataSync initiates a scheduled transfer from a source to a destination location
        """
        return pulumi.get(self, "schedule_expression")

    @property
    @pulumi.getter
    def status(self) -> Optional['TaskScheduleStatus']:
        """
        Specifies status of a schedule.
        """
        return pulumi.get(self, "status")


