# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['LocationEfsArgs', 'LocationEfs']

@pulumi.input_type
class LocationEfsArgs:
    def __init__(__self__, *,
                 ec2_config: pulumi.Input['LocationEfsEc2ConfigArgs'],
                 access_point_arn: Optional[pulumi.Input[str]] = None,
                 efs_filesystem_arn: Optional[pulumi.Input[str]] = None,
                 file_system_access_role_arn: Optional[pulumi.Input[str]] = None,
                 in_transit_encryption: Optional[pulumi.Input['LocationEfsInTransitEncryption']] = None,
                 subdirectory: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a LocationEfs resource.
        :param pulumi.Input['LocationEfsEc2ConfigArgs'] ec2_config: Specifies the subnet and security groups DataSync uses to connect to one of your Amazon EFS file system's [mount targets](https://docs.aws.amazon.com/efs/latest/ug/accessing-fs.html) .
        :param pulumi.Input[str] access_point_arn: The Amazon Resource Name (ARN) for the Amazon EFS Access point that DataSync uses when accessing the EFS file system.
        :param pulumi.Input[str] efs_filesystem_arn: The Amazon Resource Name (ARN) for the Amazon EFS file system.
        :param pulumi.Input[str] file_system_access_role_arn: The Amazon Resource Name (ARN) of the AWS IAM role that the DataSync will assume when mounting the EFS file system.
        :param pulumi.Input['LocationEfsInTransitEncryption'] in_transit_encryption: Protocol that is used for encrypting the traffic exchanged between the DataSync Agent and the EFS file system.
        :param pulumi.Input[str] subdirectory: A subdirectory in the location's path. This subdirectory in the EFS file system is used to read data from the EFS source location or write data to the EFS destination.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "ec2_config", ec2_config)
        if access_point_arn is not None:
            pulumi.set(__self__, "access_point_arn", access_point_arn)
        if efs_filesystem_arn is not None:
            pulumi.set(__self__, "efs_filesystem_arn", efs_filesystem_arn)
        if file_system_access_role_arn is not None:
            pulumi.set(__self__, "file_system_access_role_arn", file_system_access_role_arn)
        if in_transit_encryption is not None:
            pulumi.set(__self__, "in_transit_encryption", in_transit_encryption)
        if subdirectory is not None:
            pulumi.set(__self__, "subdirectory", subdirectory)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="ec2Config")
    def ec2_config(self) -> pulumi.Input['LocationEfsEc2ConfigArgs']:
        """
        Specifies the subnet and security groups DataSync uses to connect to one of your Amazon EFS file system's [mount targets](https://docs.aws.amazon.com/efs/latest/ug/accessing-fs.html) .
        """
        return pulumi.get(self, "ec2_config")

    @ec2_config.setter
    def ec2_config(self, value: pulumi.Input['LocationEfsEc2ConfigArgs']):
        pulumi.set(self, "ec2_config", value)

    @property
    @pulumi.getter(name="accessPointArn")
    def access_point_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) for the Amazon EFS Access point that DataSync uses when accessing the EFS file system.
        """
        return pulumi.get(self, "access_point_arn")

    @access_point_arn.setter
    def access_point_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_point_arn", value)

    @property
    @pulumi.getter(name="efsFilesystemArn")
    def efs_filesystem_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) for the Amazon EFS file system.
        """
        return pulumi.get(self, "efs_filesystem_arn")

    @efs_filesystem_arn.setter
    def efs_filesystem_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "efs_filesystem_arn", value)

    @property
    @pulumi.getter(name="fileSystemAccessRoleArn")
    def file_system_access_role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The Amazon Resource Name (ARN) of the AWS IAM role that the DataSync will assume when mounting the EFS file system.
        """
        return pulumi.get(self, "file_system_access_role_arn")

    @file_system_access_role_arn.setter
    def file_system_access_role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_system_access_role_arn", value)

    @property
    @pulumi.getter(name="inTransitEncryption")
    def in_transit_encryption(self) -> Optional[pulumi.Input['LocationEfsInTransitEncryption']]:
        """
        Protocol that is used for encrypting the traffic exchanged between the DataSync Agent and the EFS file system.
        """
        return pulumi.get(self, "in_transit_encryption")

    @in_transit_encryption.setter
    def in_transit_encryption(self, value: Optional[pulumi.Input['LocationEfsInTransitEncryption']]):
        pulumi.set(self, "in_transit_encryption", value)

    @property
    @pulumi.getter
    def subdirectory(self) -> Optional[pulumi.Input[str]]:
        """
        A subdirectory in the location's path. This subdirectory in the EFS file system is used to read data from the EFS source location or write data to the EFS destination.
        """
        return pulumi.get(self, "subdirectory")

    @subdirectory.setter
    def subdirectory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subdirectory", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class LocationEfs(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_point_arn: Optional[pulumi.Input[str]] = None,
                 ec2_config: Optional[pulumi.Input[Union['LocationEfsEc2ConfigArgs', 'LocationEfsEc2ConfigArgsDict']]] = None,
                 efs_filesystem_arn: Optional[pulumi.Input[str]] = None,
                 file_system_access_role_arn: Optional[pulumi.Input[str]] = None,
                 in_transit_encryption: Optional[pulumi.Input['LocationEfsInTransitEncryption']] = None,
                 subdirectory: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource schema for AWS::DataSync::LocationEFS.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_point_arn: The Amazon Resource Name (ARN) for the Amazon EFS Access point that DataSync uses when accessing the EFS file system.
        :param pulumi.Input[Union['LocationEfsEc2ConfigArgs', 'LocationEfsEc2ConfigArgsDict']] ec2_config: Specifies the subnet and security groups DataSync uses to connect to one of your Amazon EFS file system's [mount targets](https://docs.aws.amazon.com/efs/latest/ug/accessing-fs.html) .
        :param pulumi.Input[str] efs_filesystem_arn: The Amazon Resource Name (ARN) for the Amazon EFS file system.
        :param pulumi.Input[str] file_system_access_role_arn: The Amazon Resource Name (ARN) of the AWS IAM role that the DataSync will assume when mounting the EFS file system.
        :param pulumi.Input['LocationEfsInTransitEncryption'] in_transit_encryption: Protocol that is used for encrypting the traffic exchanged between the DataSync Agent and the EFS file system.
        :param pulumi.Input[str] subdirectory: A subdirectory in the location's path. This subdirectory in the EFS file system is used to read data from the EFS source location or write data to the EFS destination.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LocationEfsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::DataSync::LocationEFS.

        :param str resource_name: The name of the resource.
        :param LocationEfsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LocationEfsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_point_arn: Optional[pulumi.Input[str]] = None,
                 ec2_config: Optional[pulumi.Input[Union['LocationEfsEc2ConfigArgs', 'LocationEfsEc2ConfigArgsDict']]] = None,
                 efs_filesystem_arn: Optional[pulumi.Input[str]] = None,
                 file_system_access_role_arn: Optional[pulumi.Input[str]] = None,
                 in_transit_encryption: Optional[pulumi.Input['LocationEfsInTransitEncryption']] = None,
                 subdirectory: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LocationEfsArgs.__new__(LocationEfsArgs)

            __props__.__dict__["access_point_arn"] = access_point_arn
            if ec2_config is None and not opts.urn:
                raise TypeError("Missing required property 'ec2_config'")
            __props__.__dict__["ec2_config"] = ec2_config
            __props__.__dict__["efs_filesystem_arn"] = efs_filesystem_arn
            __props__.__dict__["file_system_access_role_arn"] = file_system_access_role_arn
            __props__.__dict__["in_transit_encryption"] = in_transit_encryption
            __props__.__dict__["subdirectory"] = subdirectory
            __props__.__dict__["tags"] = tags
            __props__.__dict__["location_arn"] = None
            __props__.__dict__["location_uri"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["accessPointArn", "ec2Config", "efsFilesystemArn", "fileSystemAccessRoleArn", "inTransitEncryption", "subdirectory"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(LocationEfs, __self__).__init__(
            'aws-native:datasync:LocationEfs',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'LocationEfs':
        """
        Get an existing LocationEfs resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = LocationEfsArgs.__new__(LocationEfsArgs)

        __props__.__dict__["access_point_arn"] = None
        __props__.__dict__["ec2_config"] = None
        __props__.__dict__["efs_filesystem_arn"] = None
        __props__.__dict__["file_system_access_role_arn"] = None
        __props__.__dict__["in_transit_encryption"] = None
        __props__.__dict__["location_arn"] = None
        __props__.__dict__["location_uri"] = None
        __props__.__dict__["subdirectory"] = None
        __props__.__dict__["tags"] = None
        return LocationEfs(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessPointArn")
    def access_point_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) for the Amazon EFS Access point that DataSync uses when accessing the EFS file system.
        """
        return pulumi.get(self, "access_point_arn")

    @property
    @pulumi.getter(name="ec2Config")
    def ec2_config(self) -> pulumi.Output['outputs.LocationEfsEc2Config']:
        """
        Specifies the subnet and security groups DataSync uses to connect to one of your Amazon EFS file system's [mount targets](https://docs.aws.amazon.com/efs/latest/ug/accessing-fs.html) .
        """
        return pulumi.get(self, "ec2_config")

    @property
    @pulumi.getter(name="efsFilesystemArn")
    def efs_filesystem_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) for the Amazon EFS file system.
        """
        return pulumi.get(self, "efs_filesystem_arn")

    @property
    @pulumi.getter(name="fileSystemAccessRoleArn")
    def file_system_access_role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The Amazon Resource Name (ARN) of the AWS IAM role that the DataSync will assume when mounting the EFS file system.
        """
        return pulumi.get(self, "file_system_access_role_arn")

    @property
    @pulumi.getter(name="inTransitEncryption")
    def in_transit_encryption(self) -> pulumi.Output[Optional['LocationEfsInTransitEncryption']]:
        """
        Protocol that is used for encrypting the traffic exchanged between the DataSync Agent and the EFS file system.
        """
        return pulumi.get(self, "in_transit_encryption")

    @property
    @pulumi.getter(name="locationArn")
    def location_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the Amazon EFS file system location that is created.
        """
        return pulumi.get(self, "location_arn")

    @property
    @pulumi.getter(name="locationUri")
    def location_uri(self) -> pulumi.Output[str]:
        """
        The URL of the EFS location that was described.
        """
        return pulumi.get(self, "location_uri")

    @property
    @pulumi.getter
    def subdirectory(self) -> pulumi.Output[Optional[str]]:
        """
        A subdirectory in the location's path. This subdirectory in the EFS file system is used to read data from the EFS source location or write data to the EFS destination.
        """
        return pulumi.get(self, "subdirectory")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

