# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetLocationHdfsResult',
    'AwaitableGetLocationHdfsResult',
    'get_location_hdfs',
    'get_location_hdfs_output',
]

@pulumi.output_type
class GetLocationHdfsResult:
    def __init__(__self__, agent_arns=None, authentication_type=None, block_size=None, kerberos_principal=None, kms_key_provider_uri=None, location_arn=None, location_uri=None, name_nodes=None, qop_configuration=None, replication_factor=None, simple_user=None, tags=None):
        if agent_arns and not isinstance(agent_arns, list):
            raise TypeError("Expected argument 'agent_arns' to be a list")
        pulumi.set(__self__, "agent_arns", agent_arns)
        if authentication_type and not isinstance(authentication_type, str):
            raise TypeError("Expected argument 'authentication_type' to be a str")
        pulumi.set(__self__, "authentication_type", authentication_type)
        if block_size and not isinstance(block_size, int):
            raise TypeError("Expected argument 'block_size' to be a int")
        pulumi.set(__self__, "block_size", block_size)
        if kerberos_principal and not isinstance(kerberos_principal, str):
            raise TypeError("Expected argument 'kerberos_principal' to be a str")
        pulumi.set(__self__, "kerberos_principal", kerberos_principal)
        if kms_key_provider_uri and not isinstance(kms_key_provider_uri, str):
            raise TypeError("Expected argument 'kms_key_provider_uri' to be a str")
        pulumi.set(__self__, "kms_key_provider_uri", kms_key_provider_uri)
        if location_arn and not isinstance(location_arn, str):
            raise TypeError("Expected argument 'location_arn' to be a str")
        pulumi.set(__self__, "location_arn", location_arn)
        if location_uri and not isinstance(location_uri, str):
            raise TypeError("Expected argument 'location_uri' to be a str")
        pulumi.set(__self__, "location_uri", location_uri)
        if name_nodes and not isinstance(name_nodes, list):
            raise TypeError("Expected argument 'name_nodes' to be a list")
        pulumi.set(__self__, "name_nodes", name_nodes)
        if qop_configuration and not isinstance(qop_configuration, dict):
            raise TypeError("Expected argument 'qop_configuration' to be a dict")
        pulumi.set(__self__, "qop_configuration", qop_configuration)
        if replication_factor and not isinstance(replication_factor, int):
            raise TypeError("Expected argument 'replication_factor' to be a int")
        pulumi.set(__self__, "replication_factor", replication_factor)
        if simple_user and not isinstance(simple_user, str):
            raise TypeError("Expected argument 'simple_user' to be a str")
        pulumi.set(__self__, "simple_user", simple_user)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="agentArns")
    def agent_arns(self) -> Optional[Sequence[str]]:
        """
        ARN(s) of the agent(s) to use for an HDFS location.
        """
        return pulumi.get(self, "agent_arns")

    @property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional['LocationHdfsAuthenticationType']:
        """
        The authentication mode used to determine identity of user.
        """
        return pulumi.get(self, "authentication_type")

    @property
    @pulumi.getter(name="blockSize")
    def block_size(self) -> Optional[int]:
        """
        Size of chunks (blocks) in bytes that the data is divided into when stored in the HDFS cluster.
        """
        return pulumi.get(self, "block_size")

    @property
    @pulumi.getter(name="kerberosPrincipal")
    def kerberos_principal(self) -> Optional[str]:
        """
        The unique identity, or principal, to which Kerberos can assign tickets.
        """
        return pulumi.get(self, "kerberos_principal")

    @property
    @pulumi.getter(name="kmsKeyProviderUri")
    def kms_key_provider_uri(self) -> Optional[str]:
        """
        The identifier for the Key Management Server where the encryption keys that encrypt data inside HDFS clusters are stored.
        """
        return pulumi.get(self, "kms_key_provider_uri")

    @property
    @pulumi.getter(name="locationArn")
    def location_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN) of the HDFS location.
        """
        return pulumi.get(self, "location_arn")

    @property
    @pulumi.getter(name="locationUri")
    def location_uri(self) -> Optional[str]:
        """
        The URL of the HDFS location that was described.
        """
        return pulumi.get(self, "location_uri")

    @property
    @pulumi.getter(name="nameNodes")
    def name_nodes(self) -> Optional[Sequence['outputs.LocationHdfsNameNode']]:
        """
        An array of Name Node(s) of the HDFS location.
        """
        return pulumi.get(self, "name_nodes")

    @property
    @pulumi.getter(name="qopConfiguration")
    def qop_configuration(self) -> Optional['outputs.LocationHdfsQopConfiguration']:
        """
        The Quality of Protection (QOP) configuration specifies the Remote Procedure Call (RPC) and data transfer protection settings configured on the Hadoop Distributed File System (HDFS) cluster. If `QopConfiguration` isn't specified, `RpcProtection` and `DataTransferProtection` default to `PRIVACY` . If you set `RpcProtection` or `DataTransferProtection` , the other parameter assumes the same value.
        """
        return pulumi.get(self, "qop_configuration")

    @property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> Optional[int]:
        """
        Number of copies of each block that exists inside the HDFS cluster.
        """
        return pulumi.get(self, "replication_factor")

    @property
    @pulumi.getter(name="simpleUser")
    def simple_user(self) -> Optional[str]:
        """
        The user name that has read and write permissions on the specified HDFS cluster.
        """
        return pulumi.get(self, "simple_user")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetLocationHdfsResult(GetLocationHdfsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLocationHdfsResult(
            agent_arns=self.agent_arns,
            authentication_type=self.authentication_type,
            block_size=self.block_size,
            kerberos_principal=self.kerberos_principal,
            kms_key_provider_uri=self.kms_key_provider_uri,
            location_arn=self.location_arn,
            location_uri=self.location_uri,
            name_nodes=self.name_nodes,
            qop_configuration=self.qop_configuration,
            replication_factor=self.replication_factor,
            simple_user=self.simple_user,
            tags=self.tags)


def get_location_hdfs(location_arn: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLocationHdfsResult:
    """
    Resource schema for AWS::DataSync::LocationHDFS.


    :param str location_arn: The Amazon Resource Name (ARN) of the HDFS location.
    """
    __args__ = dict()
    __args__['locationArn'] = location_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:datasync:getLocationHdfs', __args__, opts=opts, typ=GetLocationHdfsResult).value

    return AwaitableGetLocationHdfsResult(
        agent_arns=pulumi.get(__ret__, 'agent_arns'),
        authentication_type=pulumi.get(__ret__, 'authentication_type'),
        block_size=pulumi.get(__ret__, 'block_size'),
        kerberos_principal=pulumi.get(__ret__, 'kerberos_principal'),
        kms_key_provider_uri=pulumi.get(__ret__, 'kms_key_provider_uri'),
        location_arn=pulumi.get(__ret__, 'location_arn'),
        location_uri=pulumi.get(__ret__, 'location_uri'),
        name_nodes=pulumi.get(__ret__, 'name_nodes'),
        qop_configuration=pulumi.get(__ret__, 'qop_configuration'),
        replication_factor=pulumi.get(__ret__, 'replication_factor'),
        simple_user=pulumi.get(__ret__, 'simple_user'),
        tags=pulumi.get(__ret__, 'tags'))
def get_location_hdfs_output(location_arn: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLocationHdfsResult]:
    """
    Resource schema for AWS::DataSync::LocationHDFS.


    :param str location_arn: The Amazon Resource Name (ARN) of the HDFS location.
    """
    __args__ = dict()
    __args__['locationArn'] = location_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:datasync:getLocationHdfs', __args__, opts=opts, typ=GetLocationHdfsResult)
    return __ret__.apply(lambda __response__: GetLocationHdfsResult(
        agent_arns=pulumi.get(__response__, 'agent_arns'),
        authentication_type=pulumi.get(__response__, 'authentication_type'),
        block_size=pulumi.get(__response__, 'block_size'),
        kerberos_principal=pulumi.get(__response__, 'kerberos_principal'),
        kms_key_provider_uri=pulumi.get(__response__, 'kms_key_provider_uri'),
        location_arn=pulumi.get(__response__, 'location_arn'),
        location_uri=pulumi.get(__response__, 'location_uri'),
        name_nodes=pulumi.get(__response__, 'name_nodes'),
        qop_configuration=pulumi.get(__response__, 'qop_configuration'),
        replication_factor=pulumi.get(__response__, 'replication_factor'),
        simple_user=pulumi.get(__response__, 'simple_user'),
        tags=pulumi.get(__response__, 'tags')))
