# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = ['EventStreamArgs', 'EventStream']

@pulumi.input_type
class EventStreamArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[str],
                 uri: pulumi.Input[str],
                 event_stream_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a EventStream resource.
        :param pulumi.Input[str] domain_name: The unique name of the domain.
        :param pulumi.Input[str] uri: The StreamARN of the destination to deliver profile events to. For example, arn:aws:kinesis:region:account-id:stream/stream-name.
        :param pulumi.Input[str] event_stream_name: The name of the event stream.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags used to organize, track, or control access for this resource.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "uri", uri)
        if event_stream_name is not None:
            pulumi.set(__self__, "event_stream_name", event_stream_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        The unique name of the domain.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Input[str]:
        """
        The StreamARN of the destination to deliver profile events to. For example, arn:aws:kinesis:region:account-id:stream/stream-name.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter(name="eventStreamName")
    def event_stream_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the event stream.
        """
        return pulumi.get(self, "event_stream_name")

    @event_stream_name.setter
    def event_stream_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "event_stream_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags used to organize, track, or control access for this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class EventStream(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 event_stream_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 uri: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        An Event Stream resource of Amazon Connect Customer Profiles

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] domain_name: The unique name of the domain.
        :param pulumi.Input[str] event_stream_name: The name of the event stream.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags used to organize, track, or control access for this resource.
        :param pulumi.Input[str] uri: The StreamARN of the destination to deliver profile events to. For example, arn:aws:kinesis:region:account-id:stream/stream-name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EventStreamArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An Event Stream resource of Amazon Connect Customer Profiles

        :param str resource_name: The name of the resource.
        :param EventStreamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EventStreamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 event_stream_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 uri: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EventStreamArgs.__new__(EventStreamArgs)

            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["event_stream_name"] = event_stream_name
            __props__.__dict__["tags"] = tags
            if uri is None and not opts.urn:
                raise TypeError("Missing required property 'uri'")
            __props__.__dict__["uri"] = uri
            __props__.__dict__["created_at"] = None
            __props__.__dict__["destination_details"] = None
            __props__.__dict__["event_stream_arn"] = None
            __props__.__dict__["state"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["domainName", "eventStreamName", "uri"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(EventStream, __self__).__init__(
            'aws-native:customerprofiles:EventStream',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'EventStream':
        """
        Get an existing EventStream resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EventStreamArgs.__new__(EventStreamArgs)

        __props__.__dict__["created_at"] = None
        __props__.__dict__["destination_details"] = None
        __props__.__dict__["domain_name"] = None
        __props__.__dict__["event_stream_arn"] = None
        __props__.__dict__["event_stream_name"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["uri"] = None
        return EventStream(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The timestamp of when the export was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="destinationDetails")
    def destination_details(self) -> pulumi.Output['outputs.DestinationDetailsProperties']:
        """
        Details regarding the Kinesis stream.
        """
        return pulumi.get(self, "destination_details")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        The unique name of the domain.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="eventStreamArn")
    def event_stream_arn(self) -> pulumi.Output[str]:
        """
        A unique identifier for the event stream.
        """
        return pulumi.get(self, "event_stream_arn")

    @property
    @pulumi.getter(name="eventStreamName")
    def event_stream_name(self) -> pulumi.Output[str]:
        """
        The name of the event stream.
        """
        return pulumi.get(self, "event_stream_name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output['EventStreamState']:
        """
        The operational state of destination stream for export.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags used to organize, track, or control access for this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Output[str]:
        """
        The StreamARN of the destination to deliver profile events to. For example, arn:aws:kinesis:region:account-id:stream/stream-name.
        """
        return pulumi.get(self, "uri")

