# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['EnabledBaselineArgs', 'EnabledBaseline']

@pulumi.input_type
class EnabledBaselineArgs:
    def __init__(__self__, *,
                 baseline_identifier: pulumi.Input[str],
                 baseline_version: pulumi.Input[str],
                 target_identifier: pulumi.Input[str],
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['EnabledBaselineParameterArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a EnabledBaseline resource.
        :param pulumi.Input[str] baseline_identifier: The specific `Baseline` enabled as part of the `EnabledBaseline` resource.
        :param pulumi.Input[str] baseline_version: The enabled version of the `Baseline` .
        :param pulumi.Input[str] target_identifier: The target on which to enable the `Baseline` .
        :param pulumi.Input[Sequence[pulumi.Input['EnabledBaselineParameterArgs']]] parameters: Parameters that are applied when enabling this `Baseline` . These parameters configure the behavior of the baseline.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Tags associated with input to `EnableBaseline` .
        """
        pulumi.set(__self__, "baseline_identifier", baseline_identifier)
        pulumi.set(__self__, "baseline_version", baseline_version)
        pulumi.set(__self__, "target_identifier", target_identifier)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="baselineIdentifier")
    def baseline_identifier(self) -> pulumi.Input[str]:
        """
        The specific `Baseline` enabled as part of the `EnabledBaseline` resource.
        """
        return pulumi.get(self, "baseline_identifier")

    @baseline_identifier.setter
    def baseline_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "baseline_identifier", value)

    @property
    @pulumi.getter(name="baselineVersion")
    def baseline_version(self) -> pulumi.Input[str]:
        """
        The enabled version of the `Baseline` .
        """
        return pulumi.get(self, "baseline_version")

    @baseline_version.setter
    def baseline_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "baseline_version", value)

    @property
    @pulumi.getter(name="targetIdentifier")
    def target_identifier(self) -> pulumi.Input[str]:
        """
        The target on which to enable the `Baseline` .
        """
        return pulumi.get(self, "target_identifier")

    @target_identifier.setter
    def target_identifier(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_identifier", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnabledBaselineParameterArgs']]]]:
        """
        Parameters that are applied when enabling this `Baseline` . These parameters configure the behavior of the baseline.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnabledBaselineParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Tags associated with input to `EnableBaseline` .
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


class EnabledBaseline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 baseline_identifier: Optional[pulumi.Input[str]] = None,
                 baseline_version: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnabledBaselineParameterArgs', 'EnabledBaselineParameterArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 target_identifier: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Definition of AWS::ControlTower::EnabledBaseline Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] baseline_identifier: The specific `Baseline` enabled as part of the `EnabledBaseline` resource.
        :param pulumi.Input[str] baseline_version: The enabled version of the `Baseline` .
        :param pulumi.Input[Sequence[pulumi.Input[Union['EnabledBaselineParameterArgs', 'EnabledBaselineParameterArgsDict']]]] parameters: Parameters that are applied when enabling this `Baseline` . These parameters configure the behavior of the baseline.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: Tags associated with input to `EnableBaseline` .
        :param pulumi.Input[str] target_identifier: The target on which to enable the `Baseline` .
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnabledBaselineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::ControlTower::EnabledBaseline Resource Type

        :param str resource_name: The name of the resource.
        :param EnabledBaselineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnabledBaselineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 baseline_identifier: Optional[pulumi.Input[str]] = None,
                 baseline_version: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EnabledBaselineParameterArgs', 'EnabledBaselineParameterArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 target_identifier: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnabledBaselineArgs.__new__(EnabledBaselineArgs)

            if baseline_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'baseline_identifier'")
            __props__.__dict__["baseline_identifier"] = baseline_identifier
            if baseline_version is None and not opts.urn:
                raise TypeError("Missing required property 'baseline_version'")
            __props__.__dict__["baseline_version"] = baseline_version
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["tags"] = tags
            if target_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'target_identifier'")
            __props__.__dict__["target_identifier"] = target_identifier
            __props__.__dict__["enabled_baseline_identifier"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["baselineIdentifier", "targetIdentifier"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(EnabledBaseline, __self__).__init__(
            'aws-native:controltower:EnabledBaseline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'EnabledBaseline':
        """
        Get an existing EnabledBaseline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EnabledBaselineArgs.__new__(EnabledBaselineArgs)

        __props__.__dict__["baseline_identifier"] = None
        __props__.__dict__["baseline_version"] = None
        __props__.__dict__["enabled_baseline_identifier"] = None
        __props__.__dict__["parameters"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["target_identifier"] = None
        return EnabledBaseline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="baselineIdentifier")
    def baseline_identifier(self) -> pulumi.Output[str]:
        """
        The specific `Baseline` enabled as part of the `EnabledBaseline` resource.
        """
        return pulumi.get(self, "baseline_identifier")

    @property
    @pulumi.getter(name="baselineVersion")
    def baseline_version(self) -> pulumi.Output[str]:
        """
        The enabled version of the `Baseline` .
        """
        return pulumi.get(self, "baseline_version")

    @property
    @pulumi.getter(name="enabledBaselineIdentifier")
    def enabled_baseline_identifier(self) -> pulumi.Output[str]:
        """
        The ARN of the `EnabledBaseline` resource.
        """
        return pulumi.get(self, "enabled_baseline_identifier")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Sequence['outputs.EnabledBaselineParameter']]]:
        """
        Parameters that are applied when enabling this `Baseline` . These parameters configure the behavior of the baseline.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Tags associated with input to `EnableBaseline` .
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetIdentifier")
    def target_identifier(self) -> pulumi.Output[str]:
        """
        The target on which to enable the `Baseline` .
        """
        return pulumi.get(self, "target_identifier")

