# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['InstanceStorageConfigArgs', 'InstanceStorageConfig']

@pulumi.input_type
class InstanceStorageConfigArgs:
    def __init__(__self__, *,
                 instance_arn: pulumi.Input[str],
                 resource_type: pulumi.Input['InstanceStorageConfigInstanceStorageResourceType'],
                 storage_type: pulumi.Input['InstanceStorageConfigStorageType'],
                 kinesis_firehose_config: Optional[pulumi.Input['InstanceStorageConfigKinesisFirehoseConfigArgs']] = None,
                 kinesis_stream_config: Optional[pulumi.Input['InstanceStorageConfigKinesisStreamConfigArgs']] = None,
                 kinesis_video_stream_config: Optional[pulumi.Input['InstanceStorageConfigKinesisVideoStreamConfigArgs']] = None,
                 s3_config: Optional[pulumi.Input['InstanceStorageConfigS3ConfigArgs']] = None):
        """
        The set of arguments for constructing a InstanceStorageConfig resource.
        :param pulumi.Input[str] instance_arn: Connect Instance ID with which the storage config will be associated
        :param pulumi.Input['InstanceStorageConfigInstanceStorageResourceType'] resource_type: A valid resource type. Following are the valid resource types: `CHAT_TRANSCRIPTS` | `CALL_RECORDINGS` | `SCHEDULED_REPORTS` | `MEDIA_STREAMS` | `CONTACT_TRACE_RECORDS` | `AGENT_EVENTS`
        :param pulumi.Input['InstanceStorageConfigStorageType'] storage_type: A valid storage type.
        :param pulumi.Input['InstanceStorageConfigKinesisFirehoseConfigArgs'] kinesis_firehose_config: The configuration of the Kinesis Firehose delivery stream.
        :param pulumi.Input['InstanceStorageConfigKinesisStreamConfigArgs'] kinesis_stream_config: The configuration of the Kinesis data stream.
        :param pulumi.Input['InstanceStorageConfigKinesisVideoStreamConfigArgs'] kinesis_video_stream_config: The configuration of the Kinesis video stream.
        :param pulumi.Input['InstanceStorageConfigS3ConfigArgs'] s3_config: The S3 bucket configuration.
        """
        pulumi.set(__self__, "instance_arn", instance_arn)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "storage_type", storage_type)
        if kinesis_firehose_config is not None:
            pulumi.set(__self__, "kinesis_firehose_config", kinesis_firehose_config)
        if kinesis_stream_config is not None:
            pulumi.set(__self__, "kinesis_stream_config", kinesis_stream_config)
        if kinesis_video_stream_config is not None:
            pulumi.set(__self__, "kinesis_video_stream_config", kinesis_video_stream_config)
        if s3_config is not None:
            pulumi.set(__self__, "s3_config", s3_config)

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> pulumi.Input[str]:
        """
        Connect Instance ID with which the storage config will be associated
        """
        return pulumi.get(self, "instance_arn")

    @instance_arn.setter
    def instance_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_arn", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input['InstanceStorageConfigInstanceStorageResourceType']:
        """
        A valid resource type. Following are the valid resource types: `CHAT_TRANSCRIPTS` | `CALL_RECORDINGS` | `SCHEDULED_REPORTS` | `MEDIA_STREAMS` | `CONTACT_TRACE_RECORDS` | `AGENT_EVENTS`
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input['InstanceStorageConfigInstanceStorageResourceType']):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Input['InstanceStorageConfigStorageType']:
        """
        A valid storage type.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: pulumi.Input['InstanceStorageConfigStorageType']):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter(name="kinesisFirehoseConfig")
    def kinesis_firehose_config(self) -> Optional[pulumi.Input['InstanceStorageConfigKinesisFirehoseConfigArgs']]:
        """
        The configuration of the Kinesis Firehose delivery stream.
        """
        return pulumi.get(self, "kinesis_firehose_config")

    @kinesis_firehose_config.setter
    def kinesis_firehose_config(self, value: Optional[pulumi.Input['InstanceStorageConfigKinesisFirehoseConfigArgs']]):
        pulumi.set(self, "kinesis_firehose_config", value)

    @property
    @pulumi.getter(name="kinesisStreamConfig")
    def kinesis_stream_config(self) -> Optional[pulumi.Input['InstanceStorageConfigKinesisStreamConfigArgs']]:
        """
        The configuration of the Kinesis data stream.
        """
        return pulumi.get(self, "kinesis_stream_config")

    @kinesis_stream_config.setter
    def kinesis_stream_config(self, value: Optional[pulumi.Input['InstanceStorageConfigKinesisStreamConfigArgs']]):
        pulumi.set(self, "kinesis_stream_config", value)

    @property
    @pulumi.getter(name="kinesisVideoStreamConfig")
    def kinesis_video_stream_config(self) -> Optional[pulumi.Input['InstanceStorageConfigKinesisVideoStreamConfigArgs']]:
        """
        The configuration of the Kinesis video stream.
        """
        return pulumi.get(self, "kinesis_video_stream_config")

    @kinesis_video_stream_config.setter
    def kinesis_video_stream_config(self, value: Optional[pulumi.Input['InstanceStorageConfigKinesisVideoStreamConfigArgs']]):
        pulumi.set(self, "kinesis_video_stream_config", value)

    @property
    @pulumi.getter(name="s3Config")
    def s3_config(self) -> Optional[pulumi.Input['InstanceStorageConfigS3ConfigArgs']]:
        """
        The S3 bucket configuration.
        """
        return pulumi.get(self, "s3_config")

    @s3_config.setter
    def s3_config(self, value: Optional[pulumi.Input['InstanceStorageConfigS3ConfigArgs']]):
        pulumi.set(self, "s3_config", value)


class InstanceStorageConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_arn: Optional[pulumi.Input[str]] = None,
                 kinesis_firehose_config: Optional[pulumi.Input[Union['InstanceStorageConfigKinesisFirehoseConfigArgs', 'InstanceStorageConfigKinesisFirehoseConfigArgsDict']]] = None,
                 kinesis_stream_config: Optional[pulumi.Input[Union['InstanceStorageConfigKinesisStreamConfigArgs', 'InstanceStorageConfigKinesisStreamConfigArgsDict']]] = None,
                 kinesis_video_stream_config: Optional[pulumi.Input[Union['InstanceStorageConfigKinesisVideoStreamConfigArgs', 'InstanceStorageConfigKinesisVideoStreamConfigArgsDict']]] = None,
                 resource_type: Optional[pulumi.Input['InstanceStorageConfigInstanceStorageResourceType']] = None,
                 s3_config: Optional[pulumi.Input[Union['InstanceStorageConfigS3ConfigArgs', 'InstanceStorageConfigS3ConfigArgsDict']]] = None,
                 storage_type: Optional[pulumi.Input['InstanceStorageConfigStorageType']] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Connect::InstanceStorageConfig

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] instance_arn: Connect Instance ID with which the storage config will be associated
        :param pulumi.Input[Union['InstanceStorageConfigKinesisFirehoseConfigArgs', 'InstanceStorageConfigKinesisFirehoseConfigArgsDict']] kinesis_firehose_config: The configuration of the Kinesis Firehose delivery stream.
        :param pulumi.Input[Union['InstanceStorageConfigKinesisStreamConfigArgs', 'InstanceStorageConfigKinesisStreamConfigArgsDict']] kinesis_stream_config: The configuration of the Kinesis data stream.
        :param pulumi.Input[Union['InstanceStorageConfigKinesisVideoStreamConfigArgs', 'InstanceStorageConfigKinesisVideoStreamConfigArgsDict']] kinesis_video_stream_config: The configuration of the Kinesis video stream.
        :param pulumi.Input['InstanceStorageConfigInstanceStorageResourceType'] resource_type: A valid resource type. Following are the valid resource types: `CHAT_TRANSCRIPTS` | `CALL_RECORDINGS` | `SCHEDULED_REPORTS` | `MEDIA_STREAMS` | `CONTACT_TRACE_RECORDS` | `AGENT_EVENTS`
        :param pulumi.Input[Union['InstanceStorageConfigS3ConfigArgs', 'InstanceStorageConfigS3ConfigArgsDict']] s3_config: The S3 bucket configuration.
        :param pulumi.Input['InstanceStorageConfigStorageType'] storage_type: A valid storage type.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceStorageConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Connect::InstanceStorageConfig

        :param str resource_name: The name of the resource.
        :param InstanceStorageConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceStorageConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_arn: Optional[pulumi.Input[str]] = None,
                 kinesis_firehose_config: Optional[pulumi.Input[Union['InstanceStorageConfigKinesisFirehoseConfigArgs', 'InstanceStorageConfigKinesisFirehoseConfigArgsDict']]] = None,
                 kinesis_stream_config: Optional[pulumi.Input[Union['InstanceStorageConfigKinesisStreamConfigArgs', 'InstanceStorageConfigKinesisStreamConfigArgsDict']]] = None,
                 kinesis_video_stream_config: Optional[pulumi.Input[Union['InstanceStorageConfigKinesisVideoStreamConfigArgs', 'InstanceStorageConfigKinesisVideoStreamConfigArgsDict']]] = None,
                 resource_type: Optional[pulumi.Input['InstanceStorageConfigInstanceStorageResourceType']] = None,
                 s3_config: Optional[pulumi.Input[Union['InstanceStorageConfigS3ConfigArgs', 'InstanceStorageConfigS3ConfigArgsDict']]] = None,
                 storage_type: Optional[pulumi.Input['InstanceStorageConfigStorageType']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceStorageConfigArgs.__new__(InstanceStorageConfigArgs)

            if instance_arn is None and not opts.urn:
                raise TypeError("Missing required property 'instance_arn'")
            __props__.__dict__["instance_arn"] = instance_arn
            __props__.__dict__["kinesis_firehose_config"] = kinesis_firehose_config
            __props__.__dict__["kinesis_stream_config"] = kinesis_stream_config
            __props__.__dict__["kinesis_video_stream_config"] = kinesis_video_stream_config
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["s3_config"] = s3_config
            if storage_type is None and not opts.urn:
                raise TypeError("Missing required property 'storage_type'")
            __props__.__dict__["storage_type"] = storage_type
            __props__.__dict__["association_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["instanceArn", "resourceType"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(InstanceStorageConfig, __self__).__init__(
            'aws-native:connect:InstanceStorageConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'InstanceStorageConfig':
        """
        Get an existing InstanceStorageConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = InstanceStorageConfigArgs.__new__(InstanceStorageConfigArgs)

        __props__.__dict__["association_id"] = None
        __props__.__dict__["instance_arn"] = None
        __props__.__dict__["kinesis_firehose_config"] = None
        __props__.__dict__["kinesis_stream_config"] = None
        __props__.__dict__["kinesis_video_stream_config"] = None
        __props__.__dict__["resource_type"] = None
        __props__.__dict__["s3_config"] = None
        __props__.__dict__["storage_type"] = None
        return InstanceStorageConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="associationId")
    def association_id(self) -> pulumi.Output[str]:
        """
        The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.
        """
        return pulumi.get(self, "association_id")

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> pulumi.Output[str]:
        """
        Connect Instance ID with which the storage config will be associated
        """
        return pulumi.get(self, "instance_arn")

    @property
    @pulumi.getter(name="kinesisFirehoseConfig")
    def kinesis_firehose_config(self) -> pulumi.Output[Optional['outputs.InstanceStorageConfigKinesisFirehoseConfig']]:
        """
        The configuration of the Kinesis Firehose delivery stream.
        """
        return pulumi.get(self, "kinesis_firehose_config")

    @property
    @pulumi.getter(name="kinesisStreamConfig")
    def kinesis_stream_config(self) -> pulumi.Output[Optional['outputs.InstanceStorageConfigKinesisStreamConfig']]:
        """
        The configuration of the Kinesis data stream.
        """
        return pulumi.get(self, "kinesis_stream_config")

    @property
    @pulumi.getter(name="kinesisVideoStreamConfig")
    def kinesis_video_stream_config(self) -> pulumi.Output[Optional['outputs.InstanceStorageConfigKinesisVideoStreamConfig']]:
        """
        The configuration of the Kinesis video stream.
        """
        return pulumi.get(self, "kinesis_video_stream_config")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output['InstanceStorageConfigInstanceStorageResourceType']:
        """
        A valid resource type. Following are the valid resource types: `CHAT_TRANSCRIPTS` | `CALL_RECORDINGS` | `SCHEDULED_REPORTS` | `MEDIA_STREAMS` | `CONTACT_TRACE_RECORDS` | `AGENT_EVENTS`
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="s3Config")
    def s3_config(self) -> pulumi.Output[Optional['outputs.InstanceStorageConfigS3Config']]:
        """
        The S3 bucket configuration.
        """
        return pulumi.get(self, "s3_config")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output['InstanceStorageConfigStorageType']:
        """
        A valid storage type.
        """
        return pulumi.get(self, "storage_type")

