# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = ['AgentStatusArgs', 'AgentStatus']

@pulumi.input_type
class AgentStatusArgs:
    def __init__(__self__, *,
                 instance_arn: pulumi.Input[str],
                 state: pulumi.Input['AgentStatusState'],
                 description: Optional[pulumi.Input[str]] = None,
                 display_order: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 reset_order_number: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 type: Optional[pulumi.Input['AgentStatusType']] = None):
        """
        The set of arguments for constructing a AgentStatus resource.
        :param pulumi.Input[str] instance_arn: The identifier of the Amazon Connect instance.
        :param pulumi.Input['AgentStatusState'] state: The state of the status.
        :param pulumi.Input[str] description: The description of the status.
        :param pulumi.Input[int] display_order: The display order of the status.
        :param pulumi.Input[str] name: The name of the status.
        :param pulumi.Input[bool] reset_order_number: A number indicating the reset order of the agent status.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input['AgentStatusType'] type: The type of agent status.
        """
        pulumi.set(__self__, "instance_arn", instance_arn)
        pulumi.set(__self__, "state", state)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_order is not None:
            pulumi.set(__self__, "display_order", display_order)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if reset_order_number is not None:
            pulumi.set(__self__, "reset_order_number", reset_order_number)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> pulumi.Input[str]:
        """
        The identifier of the Amazon Connect instance.
        """
        return pulumi.get(self, "instance_arn")

    @instance_arn.setter
    def instance_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_arn", value)

    @property
    @pulumi.getter
    def state(self) -> pulumi.Input['AgentStatusState']:
        """
        The state of the status.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: pulumi.Input['AgentStatusState']):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the status.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayOrder")
    def display_order(self) -> Optional[pulumi.Input[int]]:
        """
        The display order of the status.
        """
        return pulumi.get(self, "display_order")

    @display_order.setter
    def display_order(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "display_order", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the status.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resetOrderNumber")
    def reset_order_number(self) -> Optional[pulumi.Input[bool]]:
        """
        A number indicating the reset order of the agent status.
        """
        return pulumi.get(self, "reset_order_number")

    @reset_order_number.setter
    def reset_order_number(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reset_order_number", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['AgentStatusType']]:
        """
        The type of agent status.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['AgentStatusType']]):
        pulumi.set(self, "type", value)


class AgentStatus(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_order: Optional[pulumi.Input[int]] = None,
                 instance_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 reset_order_number: Optional[pulumi.Input[bool]] = None,
                 state: Optional[pulumi.Input['AgentStatusState']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 type: Optional[pulumi.Input['AgentStatusType']] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Connect::AgentStatus

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the status.
        :param pulumi.Input[int] display_order: The display order of the status.
        :param pulumi.Input[str] instance_arn: The identifier of the Amazon Connect instance.
        :param pulumi.Input[str] name: The name of the status.
        :param pulumi.Input[bool] reset_order_number: A number indicating the reset order of the agent status.
        :param pulumi.Input['AgentStatusState'] state: The state of the status.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input['AgentStatusType'] type: The type of agent status.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AgentStatusArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Connect::AgentStatus

        :param str resource_name: The name of the resource.
        :param AgentStatusArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentStatusArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_order: Optional[pulumi.Input[int]] = None,
                 instance_arn: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 reset_order_number: Optional[pulumi.Input[bool]] = None,
                 state: Optional[pulumi.Input['AgentStatusState']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 type: Optional[pulumi.Input['AgentStatusType']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentStatusArgs.__new__(AgentStatusArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["display_order"] = display_order
            if instance_arn is None and not opts.urn:
                raise TypeError("Missing required property 'instance_arn'")
            __props__.__dict__["instance_arn"] = instance_arn
            __props__.__dict__["name"] = name
            __props__.__dict__["reset_order_number"] = reset_order_number
            if state is None and not opts.urn:
                raise TypeError("Missing required property 'state'")
            __props__.__dict__["state"] = state
            __props__.__dict__["tags"] = tags
            __props__.__dict__["type"] = type
            __props__.__dict__["agent_status_arn"] = None
            __props__.__dict__["last_modified_region"] = None
            __props__.__dict__["last_modified_time"] = None
        super(AgentStatus, __self__).__init__(
            'aws-native:connect:AgentStatus',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AgentStatus':
        """
        Get an existing AgentStatus resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AgentStatusArgs.__new__(AgentStatusArgs)

        __props__.__dict__["agent_status_arn"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_order"] = None
        __props__.__dict__["instance_arn"] = None
        __props__.__dict__["last_modified_region"] = None
        __props__.__dict__["last_modified_time"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["reset_order_number"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        return AgentStatus(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentStatusArn")
    def agent_status_arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the agent status.
        """
        return pulumi.get(self, "agent_status_arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the status.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayOrder")
    def display_order(self) -> pulumi.Output[Optional[int]]:
        """
        The display order of the status.
        """
        return pulumi.get(self, "display_order")

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> pulumi.Output[str]:
        """
        The identifier of the Amazon Connect instance.
        """
        return pulumi.get(self, "instance_arn")

    @property
    @pulumi.getter(name="lastModifiedRegion")
    def last_modified_region(self) -> pulumi.Output[str]:
        """
        Last modified region.
        """
        return pulumi.get(self, "last_modified_region")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[float]:
        """
        Last modified time.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the status.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resetOrderNumber")
    def reset_order_number(self) -> pulumi.Output[Optional[bool]]:
        """
        A number indicating the reset order of the agent status.
        """
        return pulumi.get(self, "reset_order_number")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output['AgentStatusState']:
        """
        The state of the status.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional['AgentStatusType']]:
        """
        The type of agent status.
        """
        return pulumi.get(self, "type")

