# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'CompliancePropertiesArgs',
    'CompliancePropertiesArgsDict',
    'ConfigRuleCustomPolicyDetailsArgs',
    'ConfigRuleCustomPolicyDetailsArgsDict',
    'ConfigRuleEvaluationModeConfigurationArgs',
    'ConfigRuleEvaluationModeConfigurationArgsDict',
    'ConfigRuleScopeArgs',
    'ConfigRuleScopeArgsDict',
    'ConfigRuleSourceDetailArgs',
    'ConfigRuleSourceDetailArgsDict',
    'ConfigRuleSourceArgs',
    'ConfigRuleSourceArgsDict',
    'ConfigurationAggregatorAccountAggregationSourceArgs',
    'ConfigurationAggregatorAccountAggregationSourceArgsDict',
    'ConfigurationAggregatorOrganizationAggregationSourceArgs',
    'ConfigurationAggregatorOrganizationAggregationSourceArgsDict',
    'ConformancePackInputParameterArgs',
    'ConformancePackInputParameterArgsDict',
    'OrganizationConformancePackConformancePackInputParameterArgs',
    'OrganizationConformancePackConformancePackInputParameterArgsDict',
    'TemplateSsmDocumentDetailsPropertiesArgs',
    'TemplateSsmDocumentDetailsPropertiesArgsDict',
]

MYPY = False

if not MYPY:
    class CompliancePropertiesArgsDict(TypedDict):
        """
        Indicates whether an AWS resource or CC rule is compliant and provides the number of contributors that affect the compliance.
        """
        type: NotRequired[pulumi.Input[str]]
        """
        Compliance type determined by the Config rule
        """
elif False:
    CompliancePropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CompliancePropertiesArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Indicates whether an AWS resource or CC rule is compliant and provides the number of contributors that affect the compliance.
        :param pulumi.Input[str] type: Compliance type determined by the Config rule
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Compliance type determined by the Config rule
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class ConfigRuleCustomPolicyDetailsArgsDict(TypedDict):
        """
        Provides the CustomPolicyDetails, the rule owner (```` for managed rules, ``CUSTOM_POLICY`` for Custom Policy rules, and ``CUSTOM_LAMBDA`` for Custom Lambda rules), the rule identifier, and the events that cause the evaluation of your AWS resources.
        """
        enable_debug_log_delivery: NotRequired[pulumi.Input[bool]]
        """
        The boolean expression for enabling debug logging for your CC Custom Policy rule. The default value is ``false``.
        """
        policy_runtime: NotRequired[pulumi.Input[str]]
        """
        The runtime system for your CC Custom Policy rule. Guard is a policy-as-code language that allows you to write policies that are enforced by CC Custom Policy rules. For more information about Guard, see the [Guard GitHub Repository](https://docs.aws.amazon.com/https://github.com/aws-cloudformation/cloudformation-guard).
        """
        policy_text: NotRequired[pulumi.Input[str]]
        """
        The policy definition containing the logic for your CC Custom Policy rule.
        """
elif False:
    ConfigRuleCustomPolicyDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigRuleCustomPolicyDetailsArgs:
    def __init__(__self__, *,
                 enable_debug_log_delivery: Optional[pulumi.Input[bool]] = None,
                 policy_runtime: Optional[pulumi.Input[str]] = None,
                 policy_text: Optional[pulumi.Input[str]] = None):
        """
        Provides the CustomPolicyDetails, the rule owner (```` for managed rules, ``CUSTOM_POLICY`` for Custom Policy rules, and ``CUSTOM_LAMBDA`` for Custom Lambda rules), the rule identifier, and the events that cause the evaluation of your AWS resources.
        :param pulumi.Input[bool] enable_debug_log_delivery: The boolean expression for enabling debug logging for your CC Custom Policy rule. The default value is ``false``.
        :param pulumi.Input[str] policy_runtime: The runtime system for your CC Custom Policy rule. Guard is a policy-as-code language that allows you to write policies that are enforced by CC Custom Policy rules. For more information about Guard, see the [Guard GitHub Repository](https://docs.aws.amazon.com/https://github.com/aws-cloudformation/cloudformation-guard).
        :param pulumi.Input[str] policy_text: The policy definition containing the logic for your CC Custom Policy rule.
        """
        if enable_debug_log_delivery is not None:
            pulumi.set(__self__, "enable_debug_log_delivery", enable_debug_log_delivery)
        if policy_runtime is not None:
            pulumi.set(__self__, "policy_runtime", policy_runtime)
        if policy_text is not None:
            pulumi.set(__self__, "policy_text", policy_text)

    @property
    @pulumi.getter(name="enableDebugLogDelivery")
    def enable_debug_log_delivery(self) -> Optional[pulumi.Input[bool]]:
        """
        The boolean expression for enabling debug logging for your CC Custom Policy rule. The default value is ``false``.
        """
        return pulumi.get(self, "enable_debug_log_delivery")

    @enable_debug_log_delivery.setter
    def enable_debug_log_delivery(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_debug_log_delivery", value)

    @property
    @pulumi.getter(name="policyRuntime")
    def policy_runtime(self) -> Optional[pulumi.Input[str]]:
        """
        The runtime system for your CC Custom Policy rule. Guard is a policy-as-code language that allows you to write policies that are enforced by CC Custom Policy rules. For more information about Guard, see the [Guard GitHub Repository](https://docs.aws.amazon.com/https://github.com/aws-cloudformation/cloudformation-guard).
        """
        return pulumi.get(self, "policy_runtime")

    @policy_runtime.setter
    def policy_runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_runtime", value)

    @property
    @pulumi.getter(name="policyText")
    def policy_text(self) -> Optional[pulumi.Input[str]]:
        """
        The policy definition containing the logic for your CC Custom Policy rule.
        """
        return pulumi.get(self, "policy_text")

    @policy_text.setter
    def policy_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_text", value)


if not MYPY:
    class ConfigRuleEvaluationModeConfigurationArgsDict(TypedDict):
        """
        The configuration object for CC rule evaluation mode. The supported valid values are Detective or Proactive.
        """
        mode: NotRequired[pulumi.Input[str]]
        """
        The mode of an evaluation. The valid values are Detective or Proactive.
        """
elif False:
    ConfigRuleEvaluationModeConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigRuleEvaluationModeConfigurationArgs:
    def __init__(__self__, *,
                 mode: Optional[pulumi.Input[str]] = None):
        """
        The configuration object for CC rule evaluation mode. The supported valid values are Detective or Proactive.
        :param pulumi.Input[str] mode: The mode of an evaluation. The valid values are Detective or Proactive.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        The mode of an evaluation. The valid values are Detective or Proactive.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)


if not MYPY:
    class ConfigRuleScopeArgsDict(TypedDict):
        """
        Defines which resources trigger an evaluation for an CC rule. The scope can include one or more resource types, a combination of a tag key and value, or a combination of one resource type and one resource ID. Specify a scope to constrain which resources trigger an evaluation for a rule. Otherwise, evaluations for the rule are triggered when any resource in your recording group changes in configuration.
        """
        compliance_resource_id: NotRequired[pulumi.Input[str]]
        """
        The ID of the only AWS resource that you want to trigger an evaluation for the rule. If you specify a resource ID, you must specify one resource type for ``ComplianceResourceTypes``.
        """
        compliance_resource_types: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The resource types of only those AWS resources that you want to trigger an evaluation for the rule. You can only specify one type if you also specify a resource ID for ``ComplianceResourceId``.
        """
        tag_key: NotRequired[pulumi.Input[str]]
        """
        The tag key that is applied to only those AWS resources that you want to trigger an evaluation for the rule.
        """
        tag_value: NotRequired[pulumi.Input[str]]
        """
        The tag value applied to only those AWS resources that you want to trigger an evaluation for the rule. If you specify a value for ``TagValue``, you must also specify a value for ``TagKey``.
        """
elif False:
    ConfigRuleScopeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigRuleScopeArgs:
    def __init__(__self__, *,
                 compliance_resource_id: Optional[pulumi.Input[str]] = None,
                 compliance_resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tag_key: Optional[pulumi.Input[str]] = None,
                 tag_value: Optional[pulumi.Input[str]] = None):
        """
        Defines which resources trigger an evaluation for an CC rule. The scope can include one or more resource types, a combination of a tag key and value, or a combination of one resource type and one resource ID. Specify a scope to constrain which resources trigger an evaluation for a rule. Otherwise, evaluations for the rule are triggered when any resource in your recording group changes in configuration.
        :param pulumi.Input[str] compliance_resource_id: The ID of the only AWS resource that you want to trigger an evaluation for the rule. If you specify a resource ID, you must specify one resource type for ``ComplianceResourceTypes``.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] compliance_resource_types: The resource types of only those AWS resources that you want to trigger an evaluation for the rule. You can only specify one type if you also specify a resource ID for ``ComplianceResourceId``.
        :param pulumi.Input[str] tag_key: The tag key that is applied to only those AWS resources that you want to trigger an evaluation for the rule.
        :param pulumi.Input[str] tag_value: The tag value applied to only those AWS resources that you want to trigger an evaluation for the rule. If you specify a value for ``TagValue``, you must also specify a value for ``TagKey``.
        """
        if compliance_resource_id is not None:
            pulumi.set(__self__, "compliance_resource_id", compliance_resource_id)
        if compliance_resource_types is not None:
            pulumi.set(__self__, "compliance_resource_types", compliance_resource_types)
        if tag_key is not None:
            pulumi.set(__self__, "tag_key", tag_key)
        if tag_value is not None:
            pulumi.set(__self__, "tag_value", tag_value)

    @property
    @pulumi.getter(name="complianceResourceId")
    def compliance_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the only AWS resource that you want to trigger an evaluation for the rule. If you specify a resource ID, you must specify one resource type for ``ComplianceResourceTypes``.
        """
        return pulumi.get(self, "compliance_resource_id")

    @compliance_resource_id.setter
    def compliance_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compliance_resource_id", value)

    @property
    @pulumi.getter(name="complianceResourceTypes")
    def compliance_resource_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The resource types of only those AWS resources that you want to trigger an evaluation for the rule. You can only specify one type if you also specify a resource ID for ``ComplianceResourceId``.
        """
        return pulumi.get(self, "compliance_resource_types")

    @compliance_resource_types.setter
    def compliance_resource_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "compliance_resource_types", value)

    @property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> Optional[pulumi.Input[str]]:
        """
        The tag key that is applied to only those AWS resources that you want to trigger an evaluation for the rule.
        """
        return pulumi.get(self, "tag_key")

    @tag_key.setter
    def tag_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_key", value)

    @property
    @pulumi.getter(name="tagValue")
    def tag_value(self) -> Optional[pulumi.Input[str]]:
        """
        The tag value applied to only those AWS resources that you want to trigger an evaluation for the rule. If you specify a value for ``TagValue``, you must also specify a value for ``TagKey``.
        """
        return pulumi.get(self, "tag_value")

    @tag_value.setter
    def tag_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_value", value)


if not MYPY:
    class ConfigRuleSourceDetailArgsDict(TypedDict):
        """
        Provides the source and the message types that trigger CC to evaluate your AWS resources against a rule. It also provides the frequency with which you want CC to run evaluations for the rule if the trigger type is periodic. You can specify the parameter values for ``SourceDetail`` only for custom rules.
        """
        event_source: pulumi.Input[str]
        """
        The source of the event, such as an AWS service, that triggers CC to evaluate your AWS resources.
        """
        message_type: pulumi.Input[str]
        """
        The type of notification that triggers CC to run an evaluation for a rule. You can specify the following notification types:
          +   ``ConfigurationItemChangeNotification`` - Triggers an evaluation when CC delivers a configuration item as a result of a resource change.
          +   ``OversizedConfigurationItemChangeNotification`` - Triggers an evaluation when CC delivers an oversized configuration item. CC may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.
          +   ``ScheduledNotification`` - Triggers a periodic evaluation at the frequency specified for ``MaximumExecutionFrequency``.
          +   ``ConfigurationSnapshotDeliveryCompleted`` - Triggers a periodic evaluation when CC delivers a configuration snapshot.
          
         If you want your custom rule to be triggered by configuration changes, specify two SourceDetail objects, one for ``ConfigurationItemChangeNotification`` and one for ``OversizedConfigurationItemChangeNotification``.
        """
        maximum_execution_frequency: NotRequired[pulumi.Input[str]]
        """
        The frequency at which you want CC to run evaluations for a custom rule with a periodic trigger. If you specify a value for ``MaximumExecutionFrequency``, then ``MessageType`` must use the ``ScheduledNotification`` value.
          By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the ``MaximumExecutionFrequency`` parameter.
         Based on the valid value you choose, CC runs evaluations once for each valid value. For example, if you choose ``Three_Hours``, CC runs evaluations once every three hours. In this case, ``Three_Hours`` is the frequency of this rule.
        """
elif False:
    ConfigRuleSourceDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigRuleSourceDetailArgs:
    def __init__(__self__, *,
                 event_source: pulumi.Input[str],
                 message_type: pulumi.Input[str],
                 maximum_execution_frequency: Optional[pulumi.Input[str]] = None):
        """
        Provides the source and the message types that trigger CC to evaluate your AWS resources against a rule. It also provides the frequency with which you want CC to run evaluations for the rule if the trigger type is periodic. You can specify the parameter values for ``SourceDetail`` only for custom rules.
        :param pulumi.Input[str] event_source: The source of the event, such as an AWS service, that triggers CC to evaluate your AWS resources.
        :param pulumi.Input[str] message_type: The type of notification that triggers CC to run an evaluation for a rule. You can specify the following notification types:
                 +   ``ConfigurationItemChangeNotification`` - Triggers an evaluation when CC delivers a configuration item as a result of a resource change.
                 +   ``OversizedConfigurationItemChangeNotification`` - Triggers an evaluation when CC delivers an oversized configuration item. CC may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.
                 +   ``ScheduledNotification`` - Triggers a periodic evaluation at the frequency specified for ``MaximumExecutionFrequency``.
                 +   ``ConfigurationSnapshotDeliveryCompleted`` - Triggers a periodic evaluation when CC delivers a configuration snapshot.
                 
                If you want your custom rule to be triggered by configuration changes, specify two SourceDetail objects, one for ``ConfigurationItemChangeNotification`` and one for ``OversizedConfigurationItemChangeNotification``.
        :param pulumi.Input[str] maximum_execution_frequency: The frequency at which you want CC to run evaluations for a custom rule with a periodic trigger. If you specify a value for ``MaximumExecutionFrequency``, then ``MessageType`` must use the ``ScheduledNotification`` value.
                 By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the ``MaximumExecutionFrequency`` parameter.
                Based on the valid value you choose, CC runs evaluations once for each valid value. For example, if you choose ``Three_Hours``, CC runs evaluations once every three hours. In this case, ``Three_Hours`` is the frequency of this rule.
        """
        pulumi.set(__self__, "event_source", event_source)
        pulumi.set(__self__, "message_type", message_type)
        if maximum_execution_frequency is not None:
            pulumi.set(__self__, "maximum_execution_frequency", maximum_execution_frequency)

    @property
    @pulumi.getter(name="eventSource")
    def event_source(self) -> pulumi.Input[str]:
        """
        The source of the event, such as an AWS service, that triggers CC to evaluate your AWS resources.
        """
        return pulumi.get(self, "event_source")

    @event_source.setter
    def event_source(self, value: pulumi.Input[str]):
        pulumi.set(self, "event_source", value)

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> pulumi.Input[str]:
        """
        The type of notification that triggers CC to run an evaluation for a rule. You can specify the following notification types:
          +   ``ConfigurationItemChangeNotification`` - Triggers an evaluation when CC delivers a configuration item as a result of a resource change.
          +   ``OversizedConfigurationItemChangeNotification`` - Triggers an evaluation when CC delivers an oversized configuration item. CC may generate this notification type when a resource changes and the notification exceeds the maximum size allowed by Amazon SNS.
          +   ``ScheduledNotification`` - Triggers a periodic evaluation at the frequency specified for ``MaximumExecutionFrequency``.
          +   ``ConfigurationSnapshotDeliveryCompleted`` - Triggers a periodic evaluation when CC delivers a configuration snapshot.
          
         If you want your custom rule to be triggered by configuration changes, specify two SourceDetail objects, one for ``ConfigurationItemChangeNotification`` and one for ``OversizedConfigurationItemChangeNotification``.
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "message_type", value)

    @property
    @pulumi.getter(name="maximumExecutionFrequency")
    def maximum_execution_frequency(self) -> Optional[pulumi.Input[str]]:
        """
        The frequency at which you want CC to run evaluations for a custom rule with a periodic trigger. If you specify a value for ``MaximumExecutionFrequency``, then ``MessageType`` must use the ``ScheduledNotification`` value.
          By default, rules with a periodic trigger are evaluated every 24 hours. To change the frequency, specify a valid value for the ``MaximumExecutionFrequency`` parameter.
         Based on the valid value you choose, CC runs evaluations once for each valid value. For example, if you choose ``Three_Hours``, CC runs evaluations once every three hours. In this case, ``Three_Hours`` is the frequency of this rule.
        """
        return pulumi.get(self, "maximum_execution_frequency")

    @maximum_execution_frequency.setter
    def maximum_execution_frequency(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maximum_execution_frequency", value)


if not MYPY:
    class ConfigRuleSourceArgsDict(TypedDict):
        """
        Provides the CustomPolicyDetails, the rule owner (```` for managed rules, ``CUSTOM_POLICY`` for Custom Policy rules, and ``CUSTOM_LAMBDA`` for Custom Lambda rules), the rule identifier, and the events that cause the evaluation of your AWS resources.
        """
        owner: pulumi.Input[str]
        """
        Indicates whether AWS or the customer owns and manages the CC rule.
          CC Managed Rules are predefined rules owned by AWS. For more information, see [Managed Rules](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html) in the *developer guide*.
          CC Custom Rules are rules that you can develop either with Guard (``CUSTOM_POLICY``) or LAMlong (``CUSTOM_LAMBDA``). For more information, see [Custom Rules](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html) in the *developer guide*.
        """
        custom_policy_details: NotRequired[pulumi.Input['ConfigRuleCustomPolicyDetailsArgsDict']]
        """
        Provides the runtime system, policy definition, and whether debug logging is enabled. Required when owner is set to ``CUSTOM_POLICY``.
        """
        source_details: NotRequired[pulumi.Input[Sequence[pulumi.Input['ConfigRuleSourceDetailArgsDict']]]]
        """
        Provides the source and the message types that cause CC to evaluate your AWS resources against a rule. It also provides the frequency with which you want CC to run evaluations for the rule if the trigger type is periodic.
         If the owner is set to ``CUSTOM_POLICY``, the only acceptable values for the CC rule trigger message type are ``ConfigurationItemChangeNotification`` and ``OversizedConfigurationItemChangeNotification``.
        """
        source_identifier: NotRequired[pulumi.Input[str]]
        """
        For CC Managed rules, a predefined identifier from a list. For example, ``IAM_PASSWORD_POLICY`` is a managed rule. To reference a managed rule, see [List of Managed Rules](https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html).
         For CC Custom Lambda rules, the identifier is the Amazon Resource Name (ARN) of the rule's LAMlong function, such as ``arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name``.
         For CC Custom Policy rules, this field will be ignored.
        """
elif False:
    ConfigRuleSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigRuleSourceArgs:
    def __init__(__self__, *,
                 owner: pulumi.Input[str],
                 custom_policy_details: Optional[pulumi.Input['ConfigRuleCustomPolicyDetailsArgs']] = None,
                 source_details: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigRuleSourceDetailArgs']]]] = None,
                 source_identifier: Optional[pulumi.Input[str]] = None):
        """
        Provides the CustomPolicyDetails, the rule owner (```` for managed rules, ``CUSTOM_POLICY`` for Custom Policy rules, and ``CUSTOM_LAMBDA`` for Custom Lambda rules), the rule identifier, and the events that cause the evaluation of your AWS resources.
        :param pulumi.Input[str] owner: Indicates whether AWS or the customer owns and manages the CC rule.
                 CC Managed Rules are predefined rules owned by AWS. For more information, see [Managed Rules](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html) in the *developer guide*.
                 CC Custom Rules are rules that you can develop either with Guard (``CUSTOM_POLICY``) or LAMlong (``CUSTOM_LAMBDA``). For more information, see [Custom Rules](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html) in the *developer guide*.
        :param pulumi.Input['ConfigRuleCustomPolicyDetailsArgs'] custom_policy_details: Provides the runtime system, policy definition, and whether debug logging is enabled. Required when owner is set to ``CUSTOM_POLICY``.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigRuleSourceDetailArgs']]] source_details: Provides the source and the message types that cause CC to evaluate your AWS resources against a rule. It also provides the frequency with which you want CC to run evaluations for the rule if the trigger type is periodic.
                If the owner is set to ``CUSTOM_POLICY``, the only acceptable values for the CC rule trigger message type are ``ConfigurationItemChangeNotification`` and ``OversizedConfigurationItemChangeNotification``.
        :param pulumi.Input[str] source_identifier: For CC Managed rules, a predefined identifier from a list. For example, ``IAM_PASSWORD_POLICY`` is a managed rule. To reference a managed rule, see [List of Managed Rules](https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html).
                For CC Custom Lambda rules, the identifier is the Amazon Resource Name (ARN) of the rule's LAMlong function, such as ``arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name``.
                For CC Custom Policy rules, this field will be ignored.
        """
        pulumi.set(__self__, "owner", owner)
        if custom_policy_details is not None:
            pulumi.set(__self__, "custom_policy_details", custom_policy_details)
        if source_details is not None:
            pulumi.set(__self__, "source_details", source_details)
        if source_identifier is not None:
            pulumi.set(__self__, "source_identifier", source_identifier)

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Input[str]:
        """
        Indicates whether AWS or the customer owns and manages the CC rule.
          CC Managed Rules are predefined rules owned by AWS. For more information, see [Managed Rules](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html) in the *developer guide*.
          CC Custom Rules are rules that you can develop either with Guard (``CUSTOM_POLICY``) or LAMlong (``CUSTOM_LAMBDA``). For more information, see [Custom Rules](https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_develop-rules.html) in the *developer guide*.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: pulumi.Input[str]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter(name="customPolicyDetails")
    def custom_policy_details(self) -> Optional[pulumi.Input['ConfigRuleCustomPolicyDetailsArgs']]:
        """
        Provides the runtime system, policy definition, and whether debug logging is enabled. Required when owner is set to ``CUSTOM_POLICY``.
        """
        return pulumi.get(self, "custom_policy_details")

    @custom_policy_details.setter
    def custom_policy_details(self, value: Optional[pulumi.Input['ConfigRuleCustomPolicyDetailsArgs']]):
        pulumi.set(self, "custom_policy_details", value)

    @property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigRuleSourceDetailArgs']]]]:
        """
        Provides the source and the message types that cause CC to evaluate your AWS resources against a rule. It also provides the frequency with which you want CC to run evaluations for the rule if the trigger type is periodic.
         If the owner is set to ``CUSTOM_POLICY``, the only acceptable values for the CC rule trigger message type are ``ConfigurationItemChangeNotification`` and ``OversizedConfigurationItemChangeNotification``.
        """
        return pulumi.get(self, "source_details")

    @source_details.setter
    def source_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigRuleSourceDetailArgs']]]]):
        pulumi.set(self, "source_details", value)

    @property
    @pulumi.getter(name="sourceIdentifier")
    def source_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        For CC Managed rules, a predefined identifier from a list. For example, ``IAM_PASSWORD_POLICY`` is a managed rule. To reference a managed rule, see [List of Managed Rules](https://docs.aws.amazon.com/config/latest/developerguide/managed-rules-by-aws-config.html).
         For CC Custom Lambda rules, the identifier is the Amazon Resource Name (ARN) of the rule's LAMlong function, such as ``arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name``.
         For CC Custom Policy rules, this field will be ignored.
        """
        return pulumi.get(self, "source_identifier")

    @source_identifier.setter
    def source_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_identifier", value)


if not MYPY:
    class ConfigurationAggregatorAccountAggregationSourceArgsDict(TypedDict):
        account_ids: pulumi.Input[Sequence[pulumi.Input[str]]]
        """
        The 12-digit account ID of the account being aggregated.
        """
        all_aws_regions: NotRequired[pulumi.Input[bool]]
        """
        If true, aggregate existing AWS Config regions and future regions.
        """
        aws_regions: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The source regions being aggregated.
        """
elif False:
    ConfigurationAggregatorAccountAggregationSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigurationAggregatorAccountAggregationSourceArgs:
    def __init__(__self__, *,
                 account_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 all_aws_regions: Optional[pulumi.Input[bool]] = None,
                 aws_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] account_ids: The 12-digit account ID of the account being aggregated.
        :param pulumi.Input[bool] all_aws_regions: If true, aggregate existing AWS Config regions and future regions.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] aws_regions: The source regions being aggregated.
        """
        pulumi.set(__self__, "account_ids", account_ids)
        if all_aws_regions is not None:
            pulumi.set(__self__, "all_aws_regions", all_aws_regions)
        if aws_regions is not None:
            pulumi.set(__self__, "aws_regions", aws_regions)

    @property
    @pulumi.getter(name="accountIds")
    def account_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The 12-digit account ID of the account being aggregated.
        """
        return pulumi.get(self, "account_ids")

    @account_ids.setter
    def account_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "account_ids", value)

    @property
    @pulumi.getter(name="allAwsRegions")
    def all_aws_regions(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, aggregate existing AWS Config regions and future regions.
        """
        return pulumi.get(self, "all_aws_regions")

    @all_aws_regions.setter
    def all_aws_regions(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "all_aws_regions", value)

    @property
    @pulumi.getter(name="awsRegions")
    def aws_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The source regions being aggregated.
        """
        return pulumi.get(self, "aws_regions")

    @aws_regions.setter
    def aws_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "aws_regions", value)


if not MYPY:
    class ConfigurationAggregatorOrganizationAggregationSourceArgsDict(TypedDict):
        role_arn: pulumi.Input[str]
        """
        ARN of the IAM role used to retrieve AWS Organizations details associated with the aggregator account.
        """
        all_aws_regions: NotRequired[pulumi.Input[bool]]
        """
        If true, aggregate existing AWS Config regions and future regions.
        """
        aws_regions: NotRequired[pulumi.Input[Sequence[pulumi.Input[str]]]]
        """
        The source regions being aggregated.
        """
elif False:
    ConfigurationAggregatorOrganizationAggregationSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConfigurationAggregatorOrganizationAggregationSourceArgs:
    def __init__(__self__, *,
                 role_arn: pulumi.Input[str],
                 all_aws_regions: Optional[pulumi.Input[bool]] = None,
                 aws_regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] role_arn: ARN of the IAM role used to retrieve AWS Organizations details associated with the aggregator account.
        :param pulumi.Input[bool] all_aws_regions: If true, aggregate existing AWS Config regions and future regions.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] aws_regions: The source regions being aggregated.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        if all_aws_regions is not None:
            pulumi.set(__self__, "all_aws_regions", all_aws_regions)
        if aws_regions is not None:
            pulumi.set(__self__, "aws_regions", aws_regions)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[str]:
        """
        ARN of the IAM role used to retrieve AWS Organizations details associated with the aggregator account.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="allAwsRegions")
    def all_aws_regions(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, aggregate existing AWS Config regions and future regions.
        """
        return pulumi.get(self, "all_aws_regions")

    @all_aws_regions.setter
    def all_aws_regions(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "all_aws_regions", value)

    @property
    @pulumi.getter(name="awsRegions")
    def aws_regions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The source regions being aggregated.
        """
        return pulumi.get(self, "aws_regions")

    @aws_regions.setter
    def aws_regions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "aws_regions", value)


if not MYPY:
    class ConformancePackInputParameterArgsDict(TypedDict):
        """
        Input parameters in the form of key-value pairs for the conformance pack.
        """
        parameter_name: pulumi.Input[str]
        """
        One part of a key-value pair.
        """
        parameter_value: pulumi.Input[str]
        """
        Another part of the key-value pair.
        """
elif False:
    ConformancePackInputParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConformancePackInputParameterArgs:
    def __init__(__self__, *,
                 parameter_name: pulumi.Input[str],
                 parameter_value: pulumi.Input[str]):
        """
        Input parameters in the form of key-value pairs for the conformance pack.
        :param pulumi.Input[str] parameter_name: One part of a key-value pair.
        :param pulumi.Input[str] parameter_value: Another part of the key-value pair.
        """
        pulumi.set(__self__, "parameter_name", parameter_name)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> pulumi.Input[str]:
        """
        One part of a key-value pair.
        """
        return pulumi.get(self, "parameter_name")

    @parameter_name.setter
    def parameter_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "parameter_name", value)

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> pulumi.Input[str]:
        """
        Another part of the key-value pair.
        """
        return pulumi.get(self, "parameter_value")

    @parameter_value.setter
    def parameter_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "parameter_value", value)


if not MYPY:
    class OrganizationConformancePackConformancePackInputParameterArgsDict(TypedDict):
        """
        Input parameters in the form of key-value pairs for the conformance pack.
        """
        parameter_name: pulumi.Input[str]
        """
        One part of a key-value pair.
        """
        parameter_value: pulumi.Input[str]
        """
        One part of a key-value pair.
        """
elif False:
    OrganizationConformancePackConformancePackInputParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class OrganizationConformancePackConformancePackInputParameterArgs:
    def __init__(__self__, *,
                 parameter_name: pulumi.Input[str],
                 parameter_value: pulumi.Input[str]):
        """
        Input parameters in the form of key-value pairs for the conformance pack.
        :param pulumi.Input[str] parameter_name: One part of a key-value pair.
        :param pulumi.Input[str] parameter_value: One part of a key-value pair.
        """
        pulumi.set(__self__, "parameter_name", parameter_name)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> pulumi.Input[str]:
        """
        One part of a key-value pair.
        """
        return pulumi.get(self, "parameter_name")

    @parameter_name.setter
    def parameter_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "parameter_name", value)

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> pulumi.Input[str]:
        """
        One part of a key-value pair.
        """
        return pulumi.get(self, "parameter_value")

    @parameter_value.setter
    def parameter_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "parameter_value", value)


if not MYPY:
    class TemplateSsmDocumentDetailsPropertiesArgsDict(TypedDict):
        """
        The TemplateSSMDocumentDetails object contains the name of the SSM document and the version of the SSM document.
        """
        document_name: NotRequired[pulumi.Input[str]]
        """
        The name or Amazon Resource Name (ARN) of the SSM document to use to create a conformance pack. If you use the document name, AWS Config checks only your account and AWS Region for the SSM document.
        """
        document_version: NotRequired[pulumi.Input[str]]
        """
        The version of the SSM document to use to create a conformance pack. By default, AWS Config uses the latest version.

        > This field is optional.
        """
elif False:
    TemplateSsmDocumentDetailsPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TemplateSsmDocumentDetailsPropertiesArgs:
    def __init__(__self__, *,
                 document_name: Optional[pulumi.Input[str]] = None,
                 document_version: Optional[pulumi.Input[str]] = None):
        """
        The TemplateSSMDocumentDetails object contains the name of the SSM document and the version of the SSM document.
        :param pulumi.Input[str] document_name: The name or Amazon Resource Name (ARN) of the SSM document to use to create a conformance pack. If you use the document name, AWS Config checks only your account and AWS Region for the SSM document.
        :param pulumi.Input[str] document_version: The version of the SSM document to use to create a conformance pack. By default, AWS Config uses the latest version.
               
               > This field is optional.
        """
        if document_name is not None:
            pulumi.set(__self__, "document_name", document_name)
        if document_version is not None:
            pulumi.set(__self__, "document_version", document_version)

    @property
    @pulumi.getter(name="documentName")
    def document_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name or Amazon Resource Name (ARN) of the SSM document to use to create a conformance pack. If you use the document name, AWS Config checks only your account and AWS Region for the SSM document.
        """
        return pulumi.get(self, "document_name")

    @document_name.setter
    def document_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "document_name", value)

    @property
    @pulumi.getter(name="documentVersion")
    def document_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the SSM document to use to create a conformance pack. By default, AWS Config uses the latest version.

        > This field is optional.
        """
        return pulumi.get(self, "document_version")

    @document_version.setter
    def document_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "document_version", value)


