# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'DocumentClassifierAugmentedManifestsListItem',
    'DocumentClassifierDocumentReaderConfig',
    'DocumentClassifierDocuments',
    'DocumentClassifierInputDataConfig',
    'DocumentClassifierOutputDataConfig',
    'DocumentClassifierVpcConfig',
    'FlywheelDataSecurityConfig',
    'FlywheelDocumentClassificationConfig',
    'FlywheelEntityRecognitionConfig',
    'FlywheelEntityTypesListItem',
    'FlywheelTaskConfig',
    'FlywheelVpcConfig',
]

@pulumi.output_type
class DocumentClassifierAugmentedManifestsListItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeNames":
            suggest = "attribute_names"
        elif key == "s3Uri":
            suggest = "s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DocumentClassifierAugmentedManifestsListItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DocumentClassifierAugmentedManifestsListItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DocumentClassifierAugmentedManifestsListItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute_names: Sequence[str],
                 s3_uri: str,
                 split: Optional['DocumentClassifierAugmentedManifestsListItemSplit'] = None):
        """
        :param Sequence[str] attribute_names: The JSON attribute that contains the annotations for your training documents. The number of attribute names that you specify depends on whether your augmented manifest file is the output of a single labeling job or a chained labeling job.
               
               If your file is the output of a single labeling job, specify the LabelAttributeName key that was used when the job was created in Ground Truth.
               
               If your file is the output of a chained labeling job, specify the LabelAttributeName key for one or more jobs in the chain. Each LabelAttributeName key provides the annotations from an individual job.
        :param str s3_uri: The Amazon S3 location of the augmented manifest file.
        :param 'DocumentClassifierAugmentedManifestsListItemSplit' split: The purpose of the data you've provided in the augmented manifest. You can either train or test this data. If you don't specify, the default is train.
               
               TRAIN - all of the documents in the manifest will be used for training. If no test documents are provided, Amazon Comprehend will automatically reserve a portion of the training documents for testing.
               
               TEST - all of the documents in the manifest will be used for testing.
        """
        pulumi.set(__self__, "attribute_names", attribute_names)
        pulumi.set(__self__, "s3_uri", s3_uri)
        if split is not None:
            pulumi.set(__self__, "split", split)

    @property
    @pulumi.getter(name="attributeNames")
    def attribute_names(self) -> Sequence[str]:
        """
        The JSON attribute that contains the annotations for your training documents. The number of attribute names that you specify depends on whether your augmented manifest file is the output of a single labeling job or a chained labeling job.

        If your file is the output of a single labeling job, specify the LabelAttributeName key that was used when the job was created in Ground Truth.

        If your file is the output of a chained labeling job, specify the LabelAttributeName key for one or more jobs in the chain. Each LabelAttributeName key provides the annotations from an individual job.
        """
        return pulumi.get(self, "attribute_names")

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> str:
        """
        The Amazon S3 location of the augmented manifest file.
        """
        return pulumi.get(self, "s3_uri")

    @property
    @pulumi.getter
    def split(self) -> Optional['DocumentClassifierAugmentedManifestsListItemSplit']:
        """
        The purpose of the data you've provided in the augmented manifest. You can either train or test this data. If you don't specify, the default is train.

        TRAIN - all of the documents in the manifest will be used for training. If no test documents are provided, Amazon Comprehend will automatically reserve a portion of the training documents for testing.

        TEST - all of the documents in the manifest will be used for testing.
        """
        return pulumi.get(self, "split")


@pulumi.output_type
class DocumentClassifierDocumentReaderConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "documentReadAction":
            suggest = "document_read_action"
        elif key == "documentReadMode":
            suggest = "document_read_mode"
        elif key == "featureTypes":
            suggest = "feature_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DocumentClassifierDocumentReaderConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DocumentClassifierDocumentReaderConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DocumentClassifierDocumentReaderConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 document_read_action: 'DocumentClassifierDocumentReaderConfigDocumentReadAction',
                 document_read_mode: Optional['DocumentClassifierDocumentReaderConfigDocumentReadMode'] = None,
                 feature_types: Optional[Sequence['DocumentClassifierDocumentReaderConfigFeatureTypesItem']] = None):
        """
        :param 'DocumentClassifierDocumentReaderConfigDocumentReadAction' document_read_action: This field defines the Amazon Textract API operation that Amazon Comprehend uses to extract text from PDF files and image files. Enter one of the following values:
               
               - `TEXTRACT_DETECT_DOCUMENT_TEXT` - The Amazon Comprehend service uses the `DetectDocumentText` API operation.
               - `TEXTRACT_ANALYZE_DOCUMENT` - The Amazon Comprehend service uses the `AnalyzeDocument` API operation.
        :param 'DocumentClassifierDocumentReaderConfigDocumentReadMode' document_read_mode: Determines the text extraction actions for PDF files. Enter one of the following values:
               
               - `SERVICE_DEFAULT` - use the Amazon Comprehend service defaults for PDF files.
               - `FORCE_DOCUMENT_READ_ACTION` - Amazon Comprehend uses the Textract API specified by DocumentReadAction for all PDF files, including digital PDF files.
        :param Sequence['DocumentClassifierDocumentReaderConfigFeatureTypesItem'] feature_types: Specifies the type of Amazon Textract features to apply. If you chose `TEXTRACT_ANALYZE_DOCUMENT` as the read action, you must specify one or both of the following values:
               
               - `TABLES` - Returns additional information about any tables that are detected in the input document.
               - `FORMS` - Returns additional information about any forms that are detected in the input document.
        """
        pulumi.set(__self__, "document_read_action", document_read_action)
        if document_read_mode is not None:
            pulumi.set(__self__, "document_read_mode", document_read_mode)
        if feature_types is not None:
            pulumi.set(__self__, "feature_types", feature_types)

    @property
    @pulumi.getter(name="documentReadAction")
    def document_read_action(self) -> 'DocumentClassifierDocumentReaderConfigDocumentReadAction':
        """
        This field defines the Amazon Textract API operation that Amazon Comprehend uses to extract text from PDF files and image files. Enter one of the following values:

        - `TEXTRACT_DETECT_DOCUMENT_TEXT` - The Amazon Comprehend service uses the `DetectDocumentText` API operation.
        - `TEXTRACT_ANALYZE_DOCUMENT` - The Amazon Comprehend service uses the `AnalyzeDocument` API operation.
        """
        return pulumi.get(self, "document_read_action")

    @property
    @pulumi.getter(name="documentReadMode")
    def document_read_mode(self) -> Optional['DocumentClassifierDocumentReaderConfigDocumentReadMode']:
        """
        Determines the text extraction actions for PDF files. Enter one of the following values:

        - `SERVICE_DEFAULT` - use the Amazon Comprehend service defaults for PDF files.
        - `FORCE_DOCUMENT_READ_ACTION` - Amazon Comprehend uses the Textract API specified by DocumentReadAction for all PDF files, including digital PDF files.
        """
        return pulumi.get(self, "document_read_mode")

    @property
    @pulumi.getter(name="featureTypes")
    def feature_types(self) -> Optional[Sequence['DocumentClassifierDocumentReaderConfigFeatureTypesItem']]:
        """
        Specifies the type of Amazon Textract features to apply. If you chose `TEXTRACT_ANALYZE_DOCUMENT` as the read action, you must specify one or both of the following values:

        - `TABLES` - Returns additional information about any tables that are detected in the input document.
        - `FORMS` - Returns additional information about any forms that are detected in the input document.
        """
        return pulumi.get(self, "feature_types")


@pulumi.output_type
class DocumentClassifierDocuments(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Uri":
            suggest = "s3_uri"
        elif key == "testS3Uri":
            suggest = "test_s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DocumentClassifierDocuments. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DocumentClassifierDocuments.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DocumentClassifierDocuments.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_uri: str,
                 test_s3_uri: Optional[str] = None):
        """
        :param str s3_uri: The S3 URI location of the training documents specified in the S3Uri CSV file.
        :param str test_s3_uri: The S3 URI location of the test documents included in the TestS3Uri CSV file. This field is not required if you do not specify a test CSV file.
        """
        pulumi.set(__self__, "s3_uri", s3_uri)
        if test_s3_uri is not None:
            pulumi.set(__self__, "test_s3_uri", test_s3_uri)

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> str:
        """
        The S3 URI location of the training documents specified in the S3Uri CSV file.
        """
        return pulumi.get(self, "s3_uri")

    @property
    @pulumi.getter(name="testS3Uri")
    def test_s3_uri(self) -> Optional[str]:
        """
        The S3 URI location of the test documents included in the TestS3Uri CSV file. This field is not required if you do not specify a test CSV file.
        """
        return pulumi.get(self, "test_s3_uri")


@pulumi.output_type
class DocumentClassifierInputDataConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "augmentedManifests":
            suggest = "augmented_manifests"
        elif key == "dataFormat":
            suggest = "data_format"
        elif key == "documentReaderConfig":
            suggest = "document_reader_config"
        elif key == "documentType":
            suggest = "document_type"
        elif key == "labelDelimiter":
            suggest = "label_delimiter"
        elif key == "s3Uri":
            suggest = "s3_uri"
        elif key == "testS3Uri":
            suggest = "test_s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DocumentClassifierInputDataConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DocumentClassifierInputDataConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DocumentClassifierInputDataConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 augmented_manifests: Optional[Sequence['outputs.DocumentClassifierAugmentedManifestsListItem']] = None,
                 data_format: Optional['DocumentClassifierInputDataConfigDataFormat'] = None,
                 document_reader_config: Optional['outputs.DocumentClassifierDocumentReaderConfig'] = None,
                 document_type: Optional['DocumentClassifierInputDataConfigDocumentType'] = None,
                 documents: Optional['outputs.DocumentClassifierDocuments'] = None,
                 label_delimiter: Optional[str] = None,
                 s3_uri: Optional[str] = None,
                 test_s3_uri: Optional[str] = None):
        """
        :param Sequence['DocumentClassifierAugmentedManifestsListItem'] augmented_manifests: A list of augmented manifest files that provide training data for your custom model. An augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.
               
               This parameter is required if you set `DataFormat` to `AUGMENTED_MANIFEST` .
        :param 'DocumentClassifierInputDataConfigDataFormat' data_format: The format of your training data:
               
               - `COMPREHEND_CSV` : A two-column CSV file, where labels are provided in the first column, and documents are provided in the second. If you use this value, you must provide the `S3Uri` parameter in your request.
               - `AUGMENTED_MANIFEST` : A labeled dataset that is produced by Amazon SageMaker Ground Truth. This file is in JSON lines format. Each line is a complete JSON object that contains a training document and its associated labels.
               
               If you use this value, you must provide the `AugmentedManifests` parameter in your request.
               
               If you don't specify a value, Amazon Comprehend uses `COMPREHEND_CSV` as the default.
        :param 'DocumentClassifierInputDataConfigDocumentType' document_type: The type of input documents for training the model. Provide plain-text documents to create a plain-text model, and provide semi-structured documents to create a native document model.
        :param 'DocumentClassifierDocuments' documents: The S3 location of the training documents. This parameter is required in a request to create a native document model.
        :param str label_delimiter: Indicates the delimiter used to separate each label for training a multi-label classifier. The default delimiter between labels is a pipe (|). You can use a different character as a delimiter (if it's an allowed character) by specifying it under Delimiter for labels. If the training documents use a delimiter other than the default or the delimiter you specify, the labels on that line will be combined to make a single unique label, such as LABELLABELLABEL.
        :param str s3_uri: The Amazon S3 URI for the input data. The S3 bucket must be in the same Region as the API endpoint that you are calling. The URI can point to a single input file or it can provide the prefix for a collection of input files.
               
               For example, if you use the URI `S3://bucketName/prefix` , if the prefix is a single file, Amazon Comprehend uses that file as input. If more than one file begins with the prefix, Amazon Comprehend uses all of them as input.
               
               This parameter is required if you set `DataFormat` to `COMPREHEND_CSV` .
        :param str test_s3_uri: This specifies the Amazon S3 location that contains the test annotations for the document classifier. The URI must be in the same AWS Region as the API endpoint that you are calling.
        """
        if augmented_manifests is not None:
            pulumi.set(__self__, "augmented_manifests", augmented_manifests)
        if data_format is not None:
            pulumi.set(__self__, "data_format", data_format)
        if document_reader_config is not None:
            pulumi.set(__self__, "document_reader_config", document_reader_config)
        if document_type is not None:
            pulumi.set(__self__, "document_type", document_type)
        if documents is not None:
            pulumi.set(__self__, "documents", documents)
        if label_delimiter is not None:
            pulumi.set(__self__, "label_delimiter", label_delimiter)
        if s3_uri is not None:
            pulumi.set(__self__, "s3_uri", s3_uri)
        if test_s3_uri is not None:
            pulumi.set(__self__, "test_s3_uri", test_s3_uri)

    @property
    @pulumi.getter(name="augmentedManifests")
    def augmented_manifests(self) -> Optional[Sequence['outputs.DocumentClassifierAugmentedManifestsListItem']]:
        """
        A list of augmented manifest files that provide training data for your custom model. An augmented manifest file is a labeled dataset that is produced by Amazon SageMaker Ground Truth.

        This parameter is required if you set `DataFormat` to `AUGMENTED_MANIFEST` .
        """
        return pulumi.get(self, "augmented_manifests")

    @property
    @pulumi.getter(name="dataFormat")
    def data_format(self) -> Optional['DocumentClassifierInputDataConfigDataFormat']:
        """
        The format of your training data:

        - `COMPREHEND_CSV` : A two-column CSV file, where labels are provided in the first column, and documents are provided in the second. If you use this value, you must provide the `S3Uri` parameter in your request.
        - `AUGMENTED_MANIFEST` : A labeled dataset that is produced by Amazon SageMaker Ground Truth. This file is in JSON lines format. Each line is a complete JSON object that contains a training document and its associated labels.

        If you use this value, you must provide the `AugmentedManifests` parameter in your request.

        If you don't specify a value, Amazon Comprehend uses `COMPREHEND_CSV` as the default.
        """
        return pulumi.get(self, "data_format")

    @property
    @pulumi.getter(name="documentReaderConfig")
    def document_reader_config(self) -> Optional['outputs.DocumentClassifierDocumentReaderConfig']:
        return pulumi.get(self, "document_reader_config")

    @property
    @pulumi.getter(name="documentType")
    def document_type(self) -> Optional['DocumentClassifierInputDataConfigDocumentType']:
        """
        The type of input documents for training the model. Provide plain-text documents to create a plain-text model, and provide semi-structured documents to create a native document model.
        """
        return pulumi.get(self, "document_type")

    @property
    @pulumi.getter
    def documents(self) -> Optional['outputs.DocumentClassifierDocuments']:
        """
        The S3 location of the training documents. This parameter is required in a request to create a native document model.
        """
        return pulumi.get(self, "documents")

    @property
    @pulumi.getter(name="labelDelimiter")
    def label_delimiter(self) -> Optional[str]:
        """
        Indicates the delimiter used to separate each label for training a multi-label classifier. The default delimiter between labels is a pipe (|). You can use a different character as a delimiter (if it's an allowed character) by specifying it under Delimiter for labels. If the training documents use a delimiter other than the default or the delimiter you specify, the labels on that line will be combined to make a single unique label, such as LABELLABELLABEL.
        """
        return pulumi.get(self, "label_delimiter")

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> Optional[str]:
        """
        The Amazon S3 URI for the input data. The S3 bucket must be in the same Region as the API endpoint that you are calling. The URI can point to a single input file or it can provide the prefix for a collection of input files.

        For example, if you use the URI `S3://bucketName/prefix` , if the prefix is a single file, Amazon Comprehend uses that file as input. If more than one file begins with the prefix, Amazon Comprehend uses all of them as input.

        This parameter is required if you set `DataFormat` to `COMPREHEND_CSV` .
        """
        return pulumi.get(self, "s3_uri")

    @property
    @pulumi.getter(name="testS3Uri")
    def test_s3_uri(self) -> Optional[str]:
        """
        This specifies the Amazon S3 location that contains the test annotations for the document classifier. The URI must be in the same AWS Region as the API endpoint that you are calling.
        """
        return pulumi.get(self, "test_s3_uri")


@pulumi.output_type
class DocumentClassifierOutputDataConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "s3Uri":
            suggest = "s3_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DocumentClassifierOutputDataConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DocumentClassifierOutputDataConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DocumentClassifierOutputDataConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: Optional[str] = None,
                 s3_uri: Optional[str] = None):
        """
        :param str kms_key_id: ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt the output results from an analysis job. The KmsKeyId can be one of the following formats:
               
               - KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
               - Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
               - KMS Key Alias: `"alias/ExampleAlias"`
               - ARN of a KMS Key Alias: `"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"`
        :param str s3_uri: When you use the `OutputDataConfig` object while creating a custom classifier, you specify the Amazon S3 location where you want to write the confusion matrix and other output files. The URI must be in the same Region as the API endpoint that you are calling. The location is used as the prefix for the actual location of this output file.
               
               When the custom classifier job is finished, the service creates the output file in a directory specific to the job. The `S3Uri` field contains the location of the output file, called `output.tar.gz` . It is a compressed archive that contains the confusion matrix.
        """
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if s3_uri is not None:
            pulumi.set(__self__, "s3_uri", s3_uri)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt the output results from an analysis job. The KmsKeyId can be one of the following formats:

        - KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
        - Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
        - KMS Key Alias: `"alias/ExampleAlias"`
        - ARN of a KMS Key Alias: `"arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"`
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="s3Uri")
    def s3_uri(self) -> Optional[str]:
        """
        When you use the `OutputDataConfig` object while creating a custom classifier, you specify the Amazon S3 location where you want to write the confusion matrix and other output files. The URI must be in the same Region as the API endpoint that you are calling. The location is used as the prefix for the actual location of this output file.

        When the custom classifier job is finished, the service creates the output file in a directory specific to the job. The `S3Uri` field contains the location of the output file, called `output.tar.gz` . It is a compressed archive that contains the confusion matrix.
        """
        return pulumi.get(self, "s3_uri")


@pulumi.output_type
class DocumentClassifierVpcConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DocumentClassifierVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DocumentClassifierVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DocumentClassifierVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Sequence[str],
                 subnets: Sequence[str]):
        """
        :param Sequence[str] security_group_ids: The ID number for a security group on an instance of your private VPC. Security groups on your VPC function serve as a virtual firewall to control inbound and outbound traffic and provides security for the resources that you’ll be accessing on the VPC. This ID number is preceded by "sg-", for instance: "sg-03b388029b0a285ea". For more information, see [Security Groups for your VPC](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html) .
        :param Sequence[str] subnets: The ID for each subnet being used in your private VPC. This subnet is a subset of the a range of IPv4 addresses used by the VPC and is specific to a given availability zone in the VPC’s Region. This ID number is preceded by "subnet-", for instance: "subnet-04ccf456919e69055". For more information, see [VPCs and Subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) .
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        The ID number for a security group on an instance of your private VPC. Security groups on your VPC function serve as a virtual firewall to control inbound and outbound traffic and provides security for the resources that you’ll be accessing on the VPC. This ID number is preceded by "sg-", for instance: "sg-03b388029b0a285ea". For more information, see [Security Groups for your VPC](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html) .
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        """
        The ID for each subnet being used in your private VPC. This subnet is a subset of the a range of IPv4 addresses used by the VPC and is specific to a given availability zone in the VPC’s Region. This ID number is preceded by "subnet-", for instance: "subnet-04ccf456919e69055". For more information, see [VPCs and Subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) .
        """
        return pulumi.get(self, "subnets")


@pulumi.output_type
class FlywheelDataSecurityConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataLakeKmsKeyId":
            suggest = "data_lake_kms_key_id"
        elif key == "modelKmsKeyId":
            suggest = "model_kms_key_id"
        elif key == "volumeKmsKeyId":
            suggest = "volume_kms_key_id"
        elif key == "vpcConfig":
            suggest = "vpc_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlywheelDataSecurityConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlywheelDataSecurityConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlywheelDataSecurityConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_lake_kms_key_id: Optional[str] = None,
                 model_kms_key_id: Optional[str] = None,
                 volume_kms_key_id: Optional[str] = None,
                 vpc_config: Optional['outputs.FlywheelVpcConfig'] = None):
        """
        :param str data_lake_kms_key_id: ID for the AWS KMS key that Amazon Comprehend uses to encrypt the data in the data lake.
        :param str model_kms_key_id: ID for the AWS KMS key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:
               
               - KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
               - Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
        :param str volume_kms_key_id: ID for the AWS KMS key that Amazon Comprehend uses to encrypt the volume.
        :param 'FlywheelVpcConfig' vpc_config: Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for the job. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html) .
        """
        if data_lake_kms_key_id is not None:
            pulumi.set(__self__, "data_lake_kms_key_id", data_lake_kms_key_id)
        if model_kms_key_id is not None:
            pulumi.set(__self__, "model_kms_key_id", model_kms_key_id)
        if volume_kms_key_id is not None:
            pulumi.set(__self__, "volume_kms_key_id", volume_kms_key_id)
        if vpc_config is not None:
            pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter(name="dataLakeKmsKeyId")
    def data_lake_kms_key_id(self) -> Optional[str]:
        """
        ID for the AWS KMS key that Amazon Comprehend uses to encrypt the data in the data lake.
        """
        return pulumi.get(self, "data_lake_kms_key_id")

    @property
    @pulumi.getter(name="modelKmsKeyId")
    def model_kms_key_id(self) -> Optional[str]:
        """
        ID for the AWS KMS key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:

        - KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
        - Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
        """
        return pulumi.get(self, "model_kms_key_id")

    @property
    @pulumi.getter(name="volumeKmsKeyId")
    def volume_kms_key_id(self) -> Optional[str]:
        """
        ID for the AWS KMS key that Amazon Comprehend uses to encrypt the volume.
        """
        return pulumi.get(self, "volume_kms_key_id")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> Optional['outputs.FlywheelVpcConfig']:
        """
        Configuration parameters for an optional private Virtual Private Cloud (VPC) containing the resources you are using for the job. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html) .
        """
        return pulumi.get(self, "vpc_config")


@pulumi.output_type
class FlywheelDocumentClassificationConfig(dict):
    def __init__(__self__, *,
                 mode: 'FlywheelDocumentClassificationConfigMode',
                 labels: Optional[Sequence[str]] = None):
        """
        :param 'FlywheelDocumentClassificationConfigMode' mode: Classification mode indicates whether the documents are `MULTI_CLASS` or `MULTI_LABEL` .
        :param Sequence[str] labels: One or more labels to associate with the custom classifier.
        """
        pulumi.set(__self__, "mode", mode)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter
    def mode(self) -> 'FlywheelDocumentClassificationConfigMode':
        """
        Classification mode indicates whether the documents are `MULTI_CLASS` or `MULTI_LABEL` .
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Sequence[str]]:
        """
        One or more labels to associate with the custom classifier.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class FlywheelEntityRecognitionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityTypes":
            suggest = "entity_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlywheelEntityRecognitionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlywheelEntityRecognitionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlywheelEntityRecognitionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entity_types: Optional[Sequence['outputs.FlywheelEntityTypesListItem']] = None):
        """
        :param Sequence['FlywheelEntityTypesListItem'] entity_types: Up to 25 entity types that the model is trained to recognize.
        """
        if entity_types is not None:
            pulumi.set(__self__, "entity_types", entity_types)

    @property
    @pulumi.getter(name="entityTypes")
    def entity_types(self) -> Optional[Sequence['outputs.FlywheelEntityTypesListItem']]:
        """
        Up to 25 entity types that the model is trained to recognize.
        """
        return pulumi.get(self, "entity_types")


@pulumi.output_type
class FlywheelEntityTypesListItem(dict):
    def __init__(__self__, *,
                 type: str):
        """
        :param str type: An entity type within a labeled training dataset that Amazon Comprehend uses to train a custom entity recognizer.
               
               Entity types must not contain the following invalid characters: \\n (line break), \\\\n (escaped line break, \\r (carriage return), \\\\r (escaped carriage return), \\t (tab), \\\\t (escaped tab), and , (comma).
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        An entity type within a labeled training dataset that Amazon Comprehend uses to train a custom entity recognizer.

        Entity types must not contain the following invalid characters: \\n (line break), \\\\n (escaped line break, \\r (carriage return), \\\\r (escaped carriage return), \\t (tab), \\\\t (escaped tab), and , (comma).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FlywheelTaskConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "languageCode":
            suggest = "language_code"
        elif key == "documentClassificationConfig":
            suggest = "document_classification_config"
        elif key == "entityRecognitionConfig":
            suggest = "entity_recognition_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlywheelTaskConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlywheelTaskConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlywheelTaskConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 language_code: 'FlywheelTaskConfigLanguageCode',
                 document_classification_config: Optional['outputs.FlywheelDocumentClassificationConfig'] = None,
                 entity_recognition_config: Optional['outputs.FlywheelEntityRecognitionConfig'] = None):
        """
        :param 'FlywheelTaskConfigLanguageCode' language_code: Language code for the language that the model supports.
        :param 'FlywheelDocumentClassificationConfig' document_classification_config: Configuration required for a document classification model.
        :param 'FlywheelEntityRecognitionConfig' entity_recognition_config: Configuration required for an entity recognition model.
        """
        pulumi.set(__self__, "language_code", language_code)
        if document_classification_config is not None:
            pulumi.set(__self__, "document_classification_config", document_classification_config)
        if entity_recognition_config is not None:
            pulumi.set(__self__, "entity_recognition_config", entity_recognition_config)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> 'FlywheelTaskConfigLanguageCode':
        """
        Language code for the language that the model supports.
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="documentClassificationConfig")
    def document_classification_config(self) -> Optional['outputs.FlywheelDocumentClassificationConfig']:
        """
        Configuration required for a document classification model.
        """
        return pulumi.get(self, "document_classification_config")

    @property
    @pulumi.getter(name="entityRecognitionConfig")
    def entity_recognition_config(self) -> Optional['outputs.FlywheelEntityRecognitionConfig']:
        """
        Configuration required for an entity recognition model.
        """
        return pulumi.get(self, "entity_recognition_config")


@pulumi.output_type
class FlywheelVpcConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlywheelVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlywheelVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlywheelVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Sequence[str],
                 subnets: Sequence[str]):
        """
        :param Sequence[str] security_group_ids: The ID number for a security group on an instance of your private VPC. Security groups on your VPC function serve as a virtual firewall to control inbound and outbound traffic and provides security for the resources that you’ll be accessing on the VPC. This ID number is preceded by "sg-", for instance: "sg-03b388029b0a285ea". For more information, see [Security Groups for your VPC](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html) .
        :param Sequence[str] subnets: The ID for each subnet being used in your private VPC. This subnet is a subset of the a range of IPv4 addresses used by the VPC and is specific to a given availability zone in the VPC’s Region. This ID number is preceded by "subnet-", for instance: "subnet-04ccf456919e69055". For more information, see [VPCs and Subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) .
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        The ID number for a security group on an instance of your private VPC. Security groups on your VPC function serve as a virtual firewall to control inbound and outbound traffic and provides security for the resources that you’ll be accessing on the VPC. This ID number is preceded by "sg-", for instance: "sg-03b388029b0a285ea". For more information, see [Security Groups for your VPC](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html) .
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        """
        The ID for each subnet being used in your private VPC. This subnet is a subset of the a range of IPv4 addresses used by the VPC and is specific to a given availability zone in the VPC’s Region. This ID number is preceded by "subnet-", for instance: "subnet-04ccf456919e69055". For more information, see [VPCs and Subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html) .
        """
        return pulumi.get(self, "subnets")


