# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserPoolClientArgs', 'UserPoolClient']

@pulumi.input_type
class UserPoolClientArgs:
    def __init__(__self__, *,
                 user_pool_id: pulumi.Input[str],
                 access_token_validity: Optional[pulumi.Input[int]] = None,
                 allowed_o_auth_flows: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_o_auth_flows_user_pool_client: Optional[pulumi.Input[bool]] = None,
                 allowed_o_auth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 analytics_configuration: Optional[pulumi.Input['UserPoolClientAnalyticsConfigurationArgs']] = None,
                 auth_session_validity: Optional[pulumi.Input[int]] = None,
                 callback_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_name: Optional[pulumi.Input[str]] = None,
                 default_redirect_uri: Optional[pulumi.Input[str]] = None,
                 enable_propagate_additional_user_context_data: Optional[pulumi.Input[bool]] = None,
                 enable_token_revocation: Optional[pulumi.Input[bool]] = None,
                 explicit_auth_flows: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 generate_secret: Optional[pulumi.Input[bool]] = None,
                 id_token_validity: Optional[pulumi.Input[int]] = None,
                 logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 prevent_user_existence_errors: Optional[pulumi.Input[str]] = None,
                 read_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 refresh_token_validity: Optional[pulumi.Input[int]] = None,
                 supported_identity_providers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_validity_units: Optional[pulumi.Input['UserPoolClientTokenValidityUnitsArgs']] = None,
                 write_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a UserPoolClient resource.
        :param pulumi.Input[str] user_pool_id: The user pool ID for the user pool where you want to create a user pool client.
        :param pulumi.Input[int] access_token_validity: The access token time limit. After this limit expires, your user can't use their access token. To specify the time unit for `AccessTokenValidity` as `seconds` , `minutes` , `hours` , or `days` , set a `TokenValidityUnits` value in your API request.
               
               For example, when you set `AccessTokenValidity` to `10` and `TokenValidityUnits` to `hours` , your user can authorize access with their access token for 10 hours.
               
               The default time unit for `AccessTokenValidity` in an API request is hours.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_o_auth_flows: The OAuth grant types that you want your app client to generate. To create an app client that generates client credentials grants, you must add `client_credentials` as the only allowed OAuth flow.
               
               - **code** - Use a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the `/oauth2/token` endpoint.
               - **implicit** - Issue the access token (and, optionally, ID token, based on scopes) directly to your user.
               - **client_credentials** - Issue the access token from the `/oauth2/token` endpoint directly to a non-person user using a combination of the client ID and client secret.
        :param pulumi.Input[bool] allowed_o_auth_flows_user_pool_client: Set to `true` to use OAuth 2.0 features in your user pool app client.
               
               `AllowedOAuthFlowsUserPoolClient` must be `true` before you can configure the following features in your app client.
               
               - `CallBackURLs` : Callback URLs.
               - `LogoutURLs` : Sign-out redirect URLs.
               - `AllowedOAuthScopes` : OAuth 2.0 scopes.
               - `AllowedOAuthFlows` : Support for authorization code, implicit, and client credentials OAuth 2.0 grants.
               
               To use OAuth 2.0 features, configure one of these features in the Amazon Cognito console or set `AllowedOAuthFlowsUserPoolClient` to `true` in a `CreateUserPoolClient` or `UpdateUserPoolClient` API request. If you don't set a value for `AllowedOAuthFlowsUserPoolClient` in a request with the AWS CLI or SDKs, it defaults to `false` .
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_o_auth_scopes: The allowed OAuth scopes. Possible values provided by OAuth are `phone` , `email` , `openid` , and `profile` . Possible values provided by AWS are `aws.cognito.signin.user.admin` . Custom scopes created in Resource Servers are also supported.
        :param pulumi.Input['UserPoolClientAnalyticsConfigurationArgs'] analytics_configuration: The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign.
               
               > In AWS Regions where Amazon Pinpoint isn't available, user pools only support sending events to Amazon Pinpoint projects in AWS Region us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.
        :param pulumi.Input[int] auth_session_validity: Amazon Cognito creates a session token for each API request in an authentication flow. `AuthSessionValidity` is the duration, in minutes, of that session token. Your user pool native user must respond to each authentication challenge before the session expires.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] callback_urls: A list of allowed redirect (callback) URLs for the IdPs.
               
               A redirect URI must:
               
               - Be an absolute URI.
               - Be registered with the authorization server.
               - Not include a fragment component.
               
               See [OAuth 2.0 - Redirection Endpoint](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6749#section-3.1.2) .
               
               Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
               
               App callback URLs such as myapp://example are also supported.
        :param pulumi.Input[str] client_name: The client name for the user pool client you would like to create.
        :param pulumi.Input[str] default_redirect_uri: The default redirect URI. In app clients with one assigned IdP, replaces `redirect_uri` in authentication requests. Must be in the `CallbackURLs` list.
               
               A redirect URI must:
               
               - Be an absolute URI.
               - Be registered with the authorization server.
               - Not include a fragment component.
               
               For more information, see [Default redirect URI](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-client-apps.html#cognito-user-pools-app-idp-settings-about) .
               
               Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
               
               App callback URLs such as myapp://example are also supported.
        :param pulumi.Input[bool] enable_propagate_additional_user_context_data: Activates the propagation of additional user context data. For more information about propagation of user context data, see [Adding advanced security to a user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html) . If you don’t include this parameter, you can't send device fingerprint information, including source IP address, to Amazon Cognito advanced security. You can only activate `EnablePropagateAdditionalUserContextData` in an app client that has a client secret.
        :param pulumi.Input[bool] enable_token_revocation: Activates or deactivates token revocation. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html) .
               
               If you don't include this parameter, token revocation is automatically activated for the new user pool client.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] explicit_auth_flows: The authentication flows that you want your user pool client to support. For each app client in your user pool, you can sign in your users with any combination of one or more flows, including with a user name and Secure Remote Password (SRP), a user name and password, or a custom authentication process that you define with Lambda functions.
               
               > If you don't specify a value for `ExplicitAuthFlows` , your user client supports `ALLOW_REFRESH_TOKEN_AUTH` , `ALLOW_USER_SRP_AUTH` , and `ALLOW_CUSTOM_AUTH` . 
               
               Valid values include:
               
               - `ALLOW_ADMIN_USER_PASSWORD_AUTH` : Enable admin based user password authentication flow `ADMIN_USER_PASSWORD_AUTH` . This setting replaces the `ADMIN_NO_SRP_AUTH` setting. With this authentication flow, your app passes a user name and password to Amazon Cognito in the request, instead of using the Secure Remote Password (SRP) protocol to securely transmit the password.
               - `ALLOW_CUSTOM_AUTH` : Enable Lambda trigger based authentication.
               - `ALLOW_USER_PASSWORD_AUTH` : Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
               - `ALLOW_USER_SRP_AUTH` : Enable SRP-based authentication.
               - `ALLOW_REFRESH_TOKEN_AUTH` : Enable authflow to refresh tokens.
               
               In some environments, you will see the values `ADMIN_NO_SRP_AUTH` , `CUSTOM_AUTH_FLOW_ONLY` , or `USER_PASSWORD_AUTH` . You can't assign these legacy `ExplicitAuthFlows` values to user pool clients at the same time as values that begin with `ALLOW_` ,
               like `ALLOW_USER_SRP_AUTH` .
        :param pulumi.Input[bool] generate_secret: Boolean to specify whether you want to generate a secret for the user pool client being created.
        :param pulumi.Input[int] id_token_validity: The ID token time limit. After this limit expires, your user can't use their ID token. To specify the time unit for `IdTokenValidity` as `seconds` , `minutes` , `hours` , or `days` , set a `TokenValidityUnits` value in your API request.
               
               For example, when you set `IdTokenValidity` as `10` and `TokenValidityUnits` as `hours` , your user can authenticate their session with their ID token for 10 hours.
               
               The default time unit for `IdTokenValidity` in an API request is hours.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] logout_urls: A list of allowed logout URLs for the IdPs.
        :param pulumi.Input[str] prevent_user_existence_errors: Use this setting to choose which errors and responses are returned by Cognito APIs during authentication, account confirmation, and password recovery when the user does not exist in the user pool. When set to `ENABLED` and the user does not exist, authentication returns an error indicating either the username or password was incorrect, and account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to `LEGACY` , those APIs will return a `UserNotFoundException` exception if the user does not exist in the user pool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] read_attributes: The list of user attributes that you want your app client to have read access to. After your user authenticates in your app, their access token authorizes them to read their own attribute value for any attribute in this list. An example of this kind of activity is when your user selects a link to view their profile information. Your app makes a [GetUser](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetUser.html) API request to retrieve and display your user's profile data.
               
               When you don't specify the `ReadAttributes` for your app client, your app can read the values of `email_verified` , `phone_number_verified` , and the Standard attributes of your user pool. When your user pool app client has read access to these default attributes, `ReadAttributes` doesn't return any information. Amazon Cognito only populates `ReadAttributes` in the API response if you have specified your own custom set of read attributes.
        :param pulumi.Input[int] refresh_token_validity: The refresh token time limit. After this limit expires, your user can't use their refresh token. To specify the time unit for `RefreshTokenValidity` as `seconds` , `minutes` , `hours` , or `days` , set a `TokenValidityUnits` value in your API request.
               
               For example, when you set `RefreshTokenValidity` as `10` and `TokenValidityUnits` as `days` , your user can refresh their session and retrieve new access and ID tokens for 10 days.
               
               The default time unit for `RefreshTokenValidity` in an API request is days. You can't set `RefreshTokenValidity` to 0. If you do, Amazon Cognito overrides the value with the default value of 30 days.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] supported_identity_providers: A list of provider names for the identity providers (IdPs) that are supported on this client. The following are supported: `COGNITO` , `Facebook` , `Google` , `SignInWithApple` , and `LoginWithAmazon` . You can also specify the names that you configured for the SAML and OIDC IdPs in your user pool, for example `MySAMLIdP` or `MyOIDCIdP` .
        :param pulumi.Input['UserPoolClientTokenValidityUnitsArgs'] token_validity_units: The units in which the validity times are represented. The default unit for RefreshToken is days, and default for ID and access tokens are hours.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] write_attributes: The list of user attributes that you want your app client to have write access to. After your user authenticates in your app, their access token authorizes them to set or modify their own attribute value for any attribute in this list. An example of this kind of activity is when you present your user with a form to update their profile information and they change their last name. Your app then makes an [UpdateUserAttributes](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserAttributes.html) API request and sets `family_name` to the new value.
               
               When you don't specify the `WriteAttributes` for your app client, your app can write the values of the Standard attributes of your user pool. When your user pool has write access to these default attributes, `WriteAttributes` doesn't return any information. Amazon Cognito only populates `WriteAttributes` in the API response if you have specified your own custom set of write attributes.
               
               If your app client allows users to sign in through an IdP, this array must include all attributes that you have mapped to IdP attributes. Amazon Cognito updates mapped attributes when users sign in to your application through an IdP. If your app client does not have write access to a mapped attribute, Amazon Cognito throws an error when it tries to update the attribute. For more information, see [Specifying IdP Attribute Mappings for Your user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html) .
        """
        pulumi.set(__self__, "user_pool_id", user_pool_id)
        if access_token_validity is not None:
            pulumi.set(__self__, "access_token_validity", access_token_validity)
        if allowed_o_auth_flows is not None:
            pulumi.set(__self__, "allowed_o_auth_flows", allowed_o_auth_flows)
        if allowed_o_auth_flows_user_pool_client is not None:
            pulumi.set(__self__, "allowed_o_auth_flows_user_pool_client", allowed_o_auth_flows_user_pool_client)
        if allowed_o_auth_scopes is not None:
            pulumi.set(__self__, "allowed_o_auth_scopes", allowed_o_auth_scopes)
        if analytics_configuration is not None:
            pulumi.set(__self__, "analytics_configuration", analytics_configuration)
        if auth_session_validity is not None:
            pulumi.set(__self__, "auth_session_validity", auth_session_validity)
        if callback_urls is not None:
            pulumi.set(__self__, "callback_urls", callback_urls)
        if client_name is not None:
            pulumi.set(__self__, "client_name", client_name)
        if default_redirect_uri is not None:
            pulumi.set(__self__, "default_redirect_uri", default_redirect_uri)
        if enable_propagate_additional_user_context_data is not None:
            pulumi.set(__self__, "enable_propagate_additional_user_context_data", enable_propagate_additional_user_context_data)
        if enable_token_revocation is not None:
            pulumi.set(__self__, "enable_token_revocation", enable_token_revocation)
        if explicit_auth_flows is not None:
            pulumi.set(__self__, "explicit_auth_flows", explicit_auth_flows)
        if generate_secret is not None:
            pulumi.set(__self__, "generate_secret", generate_secret)
        if id_token_validity is not None:
            pulumi.set(__self__, "id_token_validity", id_token_validity)
        if logout_urls is not None:
            pulumi.set(__self__, "logout_urls", logout_urls)
        if prevent_user_existence_errors is not None:
            pulumi.set(__self__, "prevent_user_existence_errors", prevent_user_existence_errors)
        if read_attributes is not None:
            pulumi.set(__self__, "read_attributes", read_attributes)
        if refresh_token_validity is not None:
            pulumi.set(__self__, "refresh_token_validity", refresh_token_validity)
        if supported_identity_providers is not None:
            pulumi.set(__self__, "supported_identity_providers", supported_identity_providers)
        if token_validity_units is not None:
            pulumi.set(__self__, "token_validity_units", token_validity_units)
        if write_attributes is not None:
            pulumi.set(__self__, "write_attributes", write_attributes)

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Input[str]:
        """
        The user pool ID for the user pool where you want to create a user pool client.
        """
        return pulumi.get(self, "user_pool_id")

    @user_pool_id.setter
    def user_pool_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_pool_id", value)

    @property
    @pulumi.getter(name="accessTokenValidity")
    def access_token_validity(self) -> Optional[pulumi.Input[int]]:
        """
        The access token time limit. After this limit expires, your user can't use their access token. To specify the time unit for `AccessTokenValidity` as `seconds` , `minutes` , `hours` , or `days` , set a `TokenValidityUnits` value in your API request.

        For example, when you set `AccessTokenValidity` to `10` and `TokenValidityUnits` to `hours` , your user can authorize access with their access token for 10 hours.

        The default time unit for `AccessTokenValidity` in an API request is hours.
        """
        return pulumi.get(self, "access_token_validity")

    @access_token_validity.setter
    def access_token_validity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "access_token_validity", value)

    @property
    @pulumi.getter(name="allowedOAuthFlows")
    def allowed_o_auth_flows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The OAuth grant types that you want your app client to generate. To create an app client that generates client credentials grants, you must add `client_credentials` as the only allowed OAuth flow.

        - **code** - Use a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the `/oauth2/token` endpoint.
        - **implicit** - Issue the access token (and, optionally, ID token, based on scopes) directly to your user.
        - **client_credentials** - Issue the access token from the `/oauth2/token` endpoint directly to a non-person user using a combination of the client ID and client secret.
        """
        return pulumi.get(self, "allowed_o_auth_flows")

    @allowed_o_auth_flows.setter
    def allowed_o_auth_flows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_o_auth_flows", value)

    @property
    @pulumi.getter(name="allowedOAuthFlowsUserPoolClient")
    def allowed_o_auth_flows_user_pool_client(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to `true` to use OAuth 2.0 features in your user pool app client.

        `AllowedOAuthFlowsUserPoolClient` must be `true` before you can configure the following features in your app client.

        - `CallBackURLs` : Callback URLs.
        - `LogoutURLs` : Sign-out redirect URLs.
        - `AllowedOAuthScopes` : OAuth 2.0 scopes.
        - `AllowedOAuthFlows` : Support for authorization code, implicit, and client credentials OAuth 2.0 grants.

        To use OAuth 2.0 features, configure one of these features in the Amazon Cognito console or set `AllowedOAuthFlowsUserPoolClient` to `true` in a `CreateUserPoolClient` or `UpdateUserPoolClient` API request. If you don't set a value for `AllowedOAuthFlowsUserPoolClient` in a request with the AWS CLI or SDKs, it defaults to `false` .
        """
        return pulumi.get(self, "allowed_o_auth_flows_user_pool_client")

    @allowed_o_auth_flows_user_pool_client.setter
    def allowed_o_auth_flows_user_pool_client(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allowed_o_auth_flows_user_pool_client", value)

    @property
    @pulumi.getter(name="allowedOAuthScopes")
    def allowed_o_auth_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The allowed OAuth scopes. Possible values provided by OAuth are `phone` , `email` , `openid` , and `profile` . Possible values provided by AWS are `aws.cognito.signin.user.admin` . Custom scopes created in Resource Servers are also supported.
        """
        return pulumi.get(self, "allowed_o_auth_scopes")

    @allowed_o_auth_scopes.setter
    def allowed_o_auth_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_o_auth_scopes", value)

    @property
    @pulumi.getter(name="analyticsConfiguration")
    def analytics_configuration(self) -> Optional[pulumi.Input['UserPoolClientAnalyticsConfigurationArgs']]:
        """
        The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign.

        > In AWS Regions where Amazon Pinpoint isn't available, user pools only support sending events to Amazon Pinpoint projects in AWS Region us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.
        """
        return pulumi.get(self, "analytics_configuration")

    @analytics_configuration.setter
    def analytics_configuration(self, value: Optional[pulumi.Input['UserPoolClientAnalyticsConfigurationArgs']]):
        pulumi.set(self, "analytics_configuration", value)

    @property
    @pulumi.getter(name="authSessionValidity")
    def auth_session_validity(self) -> Optional[pulumi.Input[int]]:
        """
        Amazon Cognito creates a session token for each API request in an authentication flow. `AuthSessionValidity` is the duration, in minutes, of that session token. Your user pool native user must respond to each authentication challenge before the session expires.
        """
        return pulumi.get(self, "auth_session_validity")

    @auth_session_validity.setter
    def auth_session_validity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auth_session_validity", value)

    @property
    @pulumi.getter(name="callbackUrls")
    def callback_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of allowed redirect (callback) URLs for the IdPs.

        A redirect URI must:

        - Be an absolute URI.
        - Be registered with the authorization server.
        - Not include a fragment component.

        See [OAuth 2.0 - Redirection Endpoint](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6749#section-3.1.2) .

        Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.

        App callback URLs such as myapp://example are also supported.
        """
        return pulumi.get(self, "callback_urls")

    @callback_urls.setter
    def callback_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "callback_urls", value)

    @property
    @pulumi.getter(name="clientName")
    def client_name(self) -> Optional[pulumi.Input[str]]:
        """
        The client name for the user pool client you would like to create.
        """
        return pulumi.get(self, "client_name")

    @client_name.setter
    def client_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_name", value)

    @property
    @pulumi.getter(name="defaultRedirectUri")
    def default_redirect_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The default redirect URI. In app clients with one assigned IdP, replaces `redirect_uri` in authentication requests. Must be in the `CallbackURLs` list.

        A redirect URI must:

        - Be an absolute URI.
        - Be registered with the authorization server.
        - Not include a fragment component.

        For more information, see [Default redirect URI](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-client-apps.html#cognito-user-pools-app-idp-settings-about) .

        Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.

        App callback URLs such as myapp://example are also supported.
        """
        return pulumi.get(self, "default_redirect_uri")

    @default_redirect_uri.setter
    def default_redirect_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_redirect_uri", value)

    @property
    @pulumi.getter(name="enablePropagateAdditionalUserContextData")
    def enable_propagate_additional_user_context_data(self) -> Optional[pulumi.Input[bool]]:
        """
        Activates the propagation of additional user context data. For more information about propagation of user context data, see [Adding advanced security to a user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html) . If you don’t include this parameter, you can't send device fingerprint information, including source IP address, to Amazon Cognito advanced security. You can only activate `EnablePropagateAdditionalUserContextData` in an app client that has a client secret.
        """
        return pulumi.get(self, "enable_propagate_additional_user_context_data")

    @enable_propagate_additional_user_context_data.setter
    def enable_propagate_additional_user_context_data(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_propagate_additional_user_context_data", value)

    @property
    @pulumi.getter(name="enableTokenRevocation")
    def enable_token_revocation(self) -> Optional[pulumi.Input[bool]]:
        """
        Activates or deactivates token revocation. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html) .

        If you don't include this parameter, token revocation is automatically activated for the new user pool client.
        """
        return pulumi.get(self, "enable_token_revocation")

    @enable_token_revocation.setter
    def enable_token_revocation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_token_revocation", value)

    @property
    @pulumi.getter(name="explicitAuthFlows")
    def explicit_auth_flows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The authentication flows that you want your user pool client to support. For each app client in your user pool, you can sign in your users with any combination of one or more flows, including with a user name and Secure Remote Password (SRP), a user name and password, or a custom authentication process that you define with Lambda functions.

        > If you don't specify a value for `ExplicitAuthFlows` , your user client supports `ALLOW_REFRESH_TOKEN_AUTH` , `ALLOW_USER_SRP_AUTH` , and `ALLOW_CUSTOM_AUTH` . 

        Valid values include:

        - `ALLOW_ADMIN_USER_PASSWORD_AUTH` : Enable admin based user password authentication flow `ADMIN_USER_PASSWORD_AUTH` . This setting replaces the `ADMIN_NO_SRP_AUTH` setting. With this authentication flow, your app passes a user name and password to Amazon Cognito in the request, instead of using the Secure Remote Password (SRP) protocol to securely transmit the password.
        - `ALLOW_CUSTOM_AUTH` : Enable Lambda trigger based authentication.
        - `ALLOW_USER_PASSWORD_AUTH` : Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
        - `ALLOW_USER_SRP_AUTH` : Enable SRP-based authentication.
        - `ALLOW_REFRESH_TOKEN_AUTH` : Enable authflow to refresh tokens.

        In some environments, you will see the values `ADMIN_NO_SRP_AUTH` , `CUSTOM_AUTH_FLOW_ONLY` , or `USER_PASSWORD_AUTH` . You can't assign these legacy `ExplicitAuthFlows` values to user pool clients at the same time as values that begin with `ALLOW_` ,
        like `ALLOW_USER_SRP_AUTH` .
        """
        return pulumi.get(self, "explicit_auth_flows")

    @explicit_auth_flows.setter
    def explicit_auth_flows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "explicit_auth_flows", value)

    @property
    @pulumi.getter(name="generateSecret")
    def generate_secret(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean to specify whether you want to generate a secret for the user pool client being created.
        """
        return pulumi.get(self, "generate_secret")

    @generate_secret.setter
    def generate_secret(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "generate_secret", value)

    @property
    @pulumi.getter(name="idTokenValidity")
    def id_token_validity(self) -> Optional[pulumi.Input[int]]:
        """
        The ID token time limit. After this limit expires, your user can't use their ID token. To specify the time unit for `IdTokenValidity` as `seconds` , `minutes` , `hours` , or `days` , set a `TokenValidityUnits` value in your API request.

        For example, when you set `IdTokenValidity` as `10` and `TokenValidityUnits` as `hours` , your user can authenticate their session with their ID token for 10 hours.

        The default time unit for `IdTokenValidity` in an API request is hours.
        """
        return pulumi.get(self, "id_token_validity")

    @id_token_validity.setter
    def id_token_validity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "id_token_validity", value)

    @property
    @pulumi.getter(name="logoutUrls")
    def logout_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of allowed logout URLs for the IdPs.
        """
        return pulumi.get(self, "logout_urls")

    @logout_urls.setter
    def logout_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "logout_urls", value)

    @property
    @pulumi.getter(name="preventUserExistenceErrors")
    def prevent_user_existence_errors(self) -> Optional[pulumi.Input[str]]:
        """
        Use this setting to choose which errors and responses are returned by Cognito APIs during authentication, account confirmation, and password recovery when the user does not exist in the user pool. When set to `ENABLED` and the user does not exist, authentication returns an error indicating either the username or password was incorrect, and account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to `LEGACY` , those APIs will return a `UserNotFoundException` exception if the user does not exist in the user pool.
        """
        return pulumi.get(self, "prevent_user_existence_errors")

    @prevent_user_existence_errors.setter
    def prevent_user_existence_errors(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prevent_user_existence_errors", value)

    @property
    @pulumi.getter(name="readAttributes")
    def read_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of user attributes that you want your app client to have read access to. After your user authenticates in your app, their access token authorizes them to read their own attribute value for any attribute in this list. An example of this kind of activity is when your user selects a link to view their profile information. Your app makes a [GetUser](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetUser.html) API request to retrieve and display your user's profile data.

        When you don't specify the `ReadAttributes` for your app client, your app can read the values of `email_verified` , `phone_number_verified` , and the Standard attributes of your user pool. When your user pool app client has read access to these default attributes, `ReadAttributes` doesn't return any information. Amazon Cognito only populates `ReadAttributes` in the API response if you have specified your own custom set of read attributes.
        """
        return pulumi.get(self, "read_attributes")

    @read_attributes.setter
    def read_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "read_attributes", value)

    @property
    @pulumi.getter(name="refreshTokenValidity")
    def refresh_token_validity(self) -> Optional[pulumi.Input[int]]:
        """
        The refresh token time limit. After this limit expires, your user can't use their refresh token. To specify the time unit for `RefreshTokenValidity` as `seconds` , `minutes` , `hours` , or `days` , set a `TokenValidityUnits` value in your API request.

        For example, when you set `RefreshTokenValidity` as `10` and `TokenValidityUnits` as `days` , your user can refresh their session and retrieve new access and ID tokens for 10 days.

        The default time unit for `RefreshTokenValidity` in an API request is days. You can't set `RefreshTokenValidity` to 0. If you do, Amazon Cognito overrides the value with the default value of 30 days.
        """
        return pulumi.get(self, "refresh_token_validity")

    @refresh_token_validity.setter
    def refresh_token_validity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "refresh_token_validity", value)

    @property
    @pulumi.getter(name="supportedIdentityProviders")
    def supported_identity_providers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of provider names for the identity providers (IdPs) that are supported on this client. The following are supported: `COGNITO` , `Facebook` , `Google` , `SignInWithApple` , and `LoginWithAmazon` . You can also specify the names that you configured for the SAML and OIDC IdPs in your user pool, for example `MySAMLIdP` or `MyOIDCIdP` .
        """
        return pulumi.get(self, "supported_identity_providers")

    @supported_identity_providers.setter
    def supported_identity_providers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "supported_identity_providers", value)

    @property
    @pulumi.getter(name="tokenValidityUnits")
    def token_validity_units(self) -> Optional[pulumi.Input['UserPoolClientTokenValidityUnitsArgs']]:
        """
        The units in which the validity times are represented. The default unit for RefreshToken is days, and default for ID and access tokens are hours.
        """
        return pulumi.get(self, "token_validity_units")

    @token_validity_units.setter
    def token_validity_units(self, value: Optional[pulumi.Input['UserPoolClientTokenValidityUnitsArgs']]):
        pulumi.set(self, "token_validity_units", value)

    @property
    @pulumi.getter(name="writeAttributes")
    def write_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of user attributes that you want your app client to have write access to. After your user authenticates in your app, their access token authorizes them to set or modify their own attribute value for any attribute in this list. An example of this kind of activity is when you present your user with a form to update their profile information and they change their last name. Your app then makes an [UpdateUserAttributes](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserAttributes.html) API request and sets `family_name` to the new value.

        When you don't specify the `WriteAttributes` for your app client, your app can write the values of the Standard attributes of your user pool. When your user pool has write access to these default attributes, `WriteAttributes` doesn't return any information. Amazon Cognito only populates `WriteAttributes` in the API response if you have specified your own custom set of write attributes.

        If your app client allows users to sign in through an IdP, this array must include all attributes that you have mapped to IdP attributes. Amazon Cognito updates mapped attributes when users sign in to your application through an IdP. If your app client does not have write access to a mapped attribute, Amazon Cognito throws an error when it tries to update the attribute. For more information, see [Specifying IdP Attribute Mappings for Your user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html) .
        """
        return pulumi.get(self, "write_attributes")

    @write_attributes.setter
    def write_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "write_attributes", value)


class UserPoolClient(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token_validity: Optional[pulumi.Input[int]] = None,
                 allowed_o_auth_flows: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_o_auth_flows_user_pool_client: Optional[pulumi.Input[bool]] = None,
                 allowed_o_auth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 analytics_configuration: Optional[pulumi.Input[Union['UserPoolClientAnalyticsConfigurationArgs', 'UserPoolClientAnalyticsConfigurationArgsDict']]] = None,
                 auth_session_validity: Optional[pulumi.Input[int]] = None,
                 callback_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_name: Optional[pulumi.Input[str]] = None,
                 default_redirect_uri: Optional[pulumi.Input[str]] = None,
                 enable_propagate_additional_user_context_data: Optional[pulumi.Input[bool]] = None,
                 enable_token_revocation: Optional[pulumi.Input[bool]] = None,
                 explicit_auth_flows: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 generate_secret: Optional[pulumi.Input[bool]] = None,
                 id_token_validity: Optional[pulumi.Input[int]] = None,
                 logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 prevent_user_existence_errors: Optional[pulumi.Input[str]] = None,
                 read_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 refresh_token_validity: Optional[pulumi.Input[int]] = None,
                 supported_identity_providers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_validity_units: Optional[pulumi.Input[Union['UserPoolClientTokenValidityUnitsArgs', 'UserPoolClientTokenValidityUnitsArgsDict']]] = None,
                 user_pool_id: Optional[pulumi.Input[str]] = None,
                 write_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Cognito::UserPoolClient

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] access_token_validity: The access token time limit. After this limit expires, your user can't use their access token. To specify the time unit for `AccessTokenValidity` as `seconds` , `minutes` , `hours` , or `days` , set a `TokenValidityUnits` value in your API request.
               
               For example, when you set `AccessTokenValidity` to `10` and `TokenValidityUnits` to `hours` , your user can authorize access with their access token for 10 hours.
               
               The default time unit for `AccessTokenValidity` in an API request is hours.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_o_auth_flows: The OAuth grant types that you want your app client to generate. To create an app client that generates client credentials grants, you must add `client_credentials` as the only allowed OAuth flow.
               
               - **code** - Use a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the `/oauth2/token` endpoint.
               - **implicit** - Issue the access token (and, optionally, ID token, based on scopes) directly to your user.
               - **client_credentials** - Issue the access token from the `/oauth2/token` endpoint directly to a non-person user using a combination of the client ID and client secret.
        :param pulumi.Input[bool] allowed_o_auth_flows_user_pool_client: Set to `true` to use OAuth 2.0 features in your user pool app client.
               
               `AllowedOAuthFlowsUserPoolClient` must be `true` before you can configure the following features in your app client.
               
               - `CallBackURLs` : Callback URLs.
               - `LogoutURLs` : Sign-out redirect URLs.
               - `AllowedOAuthScopes` : OAuth 2.0 scopes.
               - `AllowedOAuthFlows` : Support for authorization code, implicit, and client credentials OAuth 2.0 grants.
               
               To use OAuth 2.0 features, configure one of these features in the Amazon Cognito console or set `AllowedOAuthFlowsUserPoolClient` to `true` in a `CreateUserPoolClient` or `UpdateUserPoolClient` API request. If you don't set a value for `AllowedOAuthFlowsUserPoolClient` in a request with the AWS CLI or SDKs, it defaults to `false` .
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_o_auth_scopes: The allowed OAuth scopes. Possible values provided by OAuth are `phone` , `email` , `openid` , and `profile` . Possible values provided by AWS are `aws.cognito.signin.user.admin` . Custom scopes created in Resource Servers are also supported.
        :param pulumi.Input[Union['UserPoolClientAnalyticsConfigurationArgs', 'UserPoolClientAnalyticsConfigurationArgsDict']] analytics_configuration: The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign.
               
               > In AWS Regions where Amazon Pinpoint isn't available, user pools only support sending events to Amazon Pinpoint projects in AWS Region us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.
        :param pulumi.Input[int] auth_session_validity: Amazon Cognito creates a session token for each API request in an authentication flow. `AuthSessionValidity` is the duration, in minutes, of that session token. Your user pool native user must respond to each authentication challenge before the session expires.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] callback_urls: A list of allowed redirect (callback) URLs for the IdPs.
               
               A redirect URI must:
               
               - Be an absolute URI.
               - Be registered with the authorization server.
               - Not include a fragment component.
               
               See [OAuth 2.0 - Redirection Endpoint](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6749#section-3.1.2) .
               
               Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
               
               App callback URLs such as myapp://example are also supported.
        :param pulumi.Input[str] client_name: The client name for the user pool client you would like to create.
        :param pulumi.Input[str] default_redirect_uri: The default redirect URI. In app clients with one assigned IdP, replaces `redirect_uri` in authentication requests. Must be in the `CallbackURLs` list.
               
               A redirect URI must:
               
               - Be an absolute URI.
               - Be registered with the authorization server.
               - Not include a fragment component.
               
               For more information, see [Default redirect URI](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-client-apps.html#cognito-user-pools-app-idp-settings-about) .
               
               Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
               
               App callback URLs such as myapp://example are also supported.
        :param pulumi.Input[bool] enable_propagate_additional_user_context_data: Activates the propagation of additional user context data. For more information about propagation of user context data, see [Adding advanced security to a user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html) . If you don’t include this parameter, you can't send device fingerprint information, including source IP address, to Amazon Cognito advanced security. You can only activate `EnablePropagateAdditionalUserContextData` in an app client that has a client secret.
        :param pulumi.Input[bool] enable_token_revocation: Activates or deactivates token revocation. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html) .
               
               If you don't include this parameter, token revocation is automatically activated for the new user pool client.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] explicit_auth_flows: The authentication flows that you want your user pool client to support. For each app client in your user pool, you can sign in your users with any combination of one or more flows, including with a user name and Secure Remote Password (SRP), a user name and password, or a custom authentication process that you define with Lambda functions.
               
               > If you don't specify a value for `ExplicitAuthFlows` , your user client supports `ALLOW_REFRESH_TOKEN_AUTH` , `ALLOW_USER_SRP_AUTH` , and `ALLOW_CUSTOM_AUTH` . 
               
               Valid values include:
               
               - `ALLOW_ADMIN_USER_PASSWORD_AUTH` : Enable admin based user password authentication flow `ADMIN_USER_PASSWORD_AUTH` . This setting replaces the `ADMIN_NO_SRP_AUTH` setting. With this authentication flow, your app passes a user name and password to Amazon Cognito in the request, instead of using the Secure Remote Password (SRP) protocol to securely transmit the password.
               - `ALLOW_CUSTOM_AUTH` : Enable Lambda trigger based authentication.
               - `ALLOW_USER_PASSWORD_AUTH` : Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
               - `ALLOW_USER_SRP_AUTH` : Enable SRP-based authentication.
               - `ALLOW_REFRESH_TOKEN_AUTH` : Enable authflow to refresh tokens.
               
               In some environments, you will see the values `ADMIN_NO_SRP_AUTH` , `CUSTOM_AUTH_FLOW_ONLY` , or `USER_PASSWORD_AUTH` . You can't assign these legacy `ExplicitAuthFlows` values to user pool clients at the same time as values that begin with `ALLOW_` ,
               like `ALLOW_USER_SRP_AUTH` .
        :param pulumi.Input[bool] generate_secret: Boolean to specify whether you want to generate a secret for the user pool client being created.
        :param pulumi.Input[int] id_token_validity: The ID token time limit. After this limit expires, your user can't use their ID token. To specify the time unit for `IdTokenValidity` as `seconds` , `minutes` , `hours` , or `days` , set a `TokenValidityUnits` value in your API request.
               
               For example, when you set `IdTokenValidity` as `10` and `TokenValidityUnits` as `hours` , your user can authenticate their session with their ID token for 10 hours.
               
               The default time unit for `IdTokenValidity` in an API request is hours.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] logout_urls: A list of allowed logout URLs for the IdPs.
        :param pulumi.Input[str] prevent_user_existence_errors: Use this setting to choose which errors and responses are returned by Cognito APIs during authentication, account confirmation, and password recovery when the user does not exist in the user pool. When set to `ENABLED` and the user does not exist, authentication returns an error indicating either the username or password was incorrect, and account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to `LEGACY` , those APIs will return a `UserNotFoundException` exception if the user does not exist in the user pool.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] read_attributes: The list of user attributes that you want your app client to have read access to. After your user authenticates in your app, their access token authorizes them to read their own attribute value for any attribute in this list. An example of this kind of activity is when your user selects a link to view their profile information. Your app makes a [GetUser](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetUser.html) API request to retrieve and display your user's profile data.
               
               When you don't specify the `ReadAttributes` for your app client, your app can read the values of `email_verified` , `phone_number_verified` , and the Standard attributes of your user pool. When your user pool app client has read access to these default attributes, `ReadAttributes` doesn't return any information. Amazon Cognito only populates `ReadAttributes` in the API response if you have specified your own custom set of read attributes.
        :param pulumi.Input[int] refresh_token_validity: The refresh token time limit. After this limit expires, your user can't use their refresh token. To specify the time unit for `RefreshTokenValidity` as `seconds` , `minutes` , `hours` , or `days` , set a `TokenValidityUnits` value in your API request.
               
               For example, when you set `RefreshTokenValidity` as `10` and `TokenValidityUnits` as `days` , your user can refresh their session and retrieve new access and ID tokens for 10 days.
               
               The default time unit for `RefreshTokenValidity` in an API request is days. You can't set `RefreshTokenValidity` to 0. If you do, Amazon Cognito overrides the value with the default value of 30 days.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] supported_identity_providers: A list of provider names for the identity providers (IdPs) that are supported on this client. The following are supported: `COGNITO` , `Facebook` , `Google` , `SignInWithApple` , and `LoginWithAmazon` . You can also specify the names that you configured for the SAML and OIDC IdPs in your user pool, for example `MySAMLIdP` or `MyOIDCIdP` .
        :param pulumi.Input[Union['UserPoolClientTokenValidityUnitsArgs', 'UserPoolClientTokenValidityUnitsArgsDict']] token_validity_units: The units in which the validity times are represented. The default unit for RefreshToken is days, and default for ID and access tokens are hours.
        :param pulumi.Input[str] user_pool_id: The user pool ID for the user pool where you want to create a user pool client.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] write_attributes: The list of user attributes that you want your app client to have write access to. After your user authenticates in your app, their access token authorizes them to set or modify their own attribute value for any attribute in this list. An example of this kind of activity is when you present your user with a form to update their profile information and they change their last name. Your app then makes an [UpdateUserAttributes](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserAttributes.html) API request and sets `family_name` to the new value.
               
               When you don't specify the `WriteAttributes` for your app client, your app can write the values of the Standard attributes of your user pool. When your user pool has write access to these default attributes, `WriteAttributes` doesn't return any information. Amazon Cognito only populates `WriteAttributes` in the API response if you have specified your own custom set of write attributes.
               
               If your app client allows users to sign in through an IdP, this array must include all attributes that you have mapped to IdP attributes. Amazon Cognito updates mapped attributes when users sign in to your application through an IdP. If your app client does not have write access to a mapped attribute, Amazon Cognito throws an error when it tries to update the attribute. For more information, see [Specifying IdP Attribute Mappings for Your user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html) .
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserPoolClientArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Cognito::UserPoolClient

        :param str resource_name: The name of the resource.
        :param UserPoolClientArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserPoolClientArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_token_validity: Optional[pulumi.Input[int]] = None,
                 allowed_o_auth_flows: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_o_auth_flows_user_pool_client: Optional[pulumi.Input[bool]] = None,
                 allowed_o_auth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 analytics_configuration: Optional[pulumi.Input[Union['UserPoolClientAnalyticsConfigurationArgs', 'UserPoolClientAnalyticsConfigurationArgsDict']]] = None,
                 auth_session_validity: Optional[pulumi.Input[int]] = None,
                 callback_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_name: Optional[pulumi.Input[str]] = None,
                 default_redirect_uri: Optional[pulumi.Input[str]] = None,
                 enable_propagate_additional_user_context_data: Optional[pulumi.Input[bool]] = None,
                 enable_token_revocation: Optional[pulumi.Input[bool]] = None,
                 explicit_auth_flows: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 generate_secret: Optional[pulumi.Input[bool]] = None,
                 id_token_validity: Optional[pulumi.Input[int]] = None,
                 logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 prevent_user_existence_errors: Optional[pulumi.Input[str]] = None,
                 read_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 refresh_token_validity: Optional[pulumi.Input[int]] = None,
                 supported_identity_providers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_validity_units: Optional[pulumi.Input[Union['UserPoolClientTokenValidityUnitsArgs', 'UserPoolClientTokenValidityUnitsArgsDict']]] = None,
                 user_pool_id: Optional[pulumi.Input[str]] = None,
                 write_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserPoolClientArgs.__new__(UserPoolClientArgs)

            __props__.__dict__["access_token_validity"] = access_token_validity
            __props__.__dict__["allowed_o_auth_flows"] = allowed_o_auth_flows
            __props__.__dict__["allowed_o_auth_flows_user_pool_client"] = allowed_o_auth_flows_user_pool_client
            __props__.__dict__["allowed_o_auth_scopes"] = allowed_o_auth_scopes
            __props__.__dict__["analytics_configuration"] = analytics_configuration
            __props__.__dict__["auth_session_validity"] = auth_session_validity
            __props__.__dict__["callback_urls"] = callback_urls
            __props__.__dict__["client_name"] = client_name
            __props__.__dict__["default_redirect_uri"] = default_redirect_uri
            __props__.__dict__["enable_propagate_additional_user_context_data"] = enable_propagate_additional_user_context_data
            __props__.__dict__["enable_token_revocation"] = enable_token_revocation
            __props__.__dict__["explicit_auth_flows"] = explicit_auth_flows
            __props__.__dict__["generate_secret"] = generate_secret
            __props__.__dict__["id_token_validity"] = id_token_validity
            __props__.__dict__["logout_urls"] = logout_urls
            __props__.__dict__["prevent_user_existence_errors"] = prevent_user_existence_errors
            __props__.__dict__["read_attributes"] = read_attributes
            __props__.__dict__["refresh_token_validity"] = refresh_token_validity
            __props__.__dict__["supported_identity_providers"] = supported_identity_providers
            __props__.__dict__["token_validity_units"] = token_validity_units
            if user_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_pool_id'")
            __props__.__dict__["user_pool_id"] = user_pool_id
            __props__.__dict__["write_attributes"] = write_attributes
            __props__.__dict__["client_id"] = None
            __props__.__dict__["client_secret"] = None
            __props__.__dict__["name"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["generateSecret", "userPoolId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(UserPoolClient, __self__).__init__(
            'aws-native:cognito:UserPoolClient',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'UserPoolClient':
        """
        Get an existing UserPoolClient resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = UserPoolClientArgs.__new__(UserPoolClientArgs)

        __props__.__dict__["access_token_validity"] = None
        __props__.__dict__["allowed_o_auth_flows"] = None
        __props__.__dict__["allowed_o_auth_flows_user_pool_client"] = None
        __props__.__dict__["allowed_o_auth_scopes"] = None
        __props__.__dict__["analytics_configuration"] = None
        __props__.__dict__["auth_session_validity"] = None
        __props__.__dict__["callback_urls"] = None
        __props__.__dict__["client_id"] = None
        __props__.__dict__["client_name"] = None
        __props__.__dict__["client_secret"] = None
        __props__.__dict__["default_redirect_uri"] = None
        __props__.__dict__["enable_propagate_additional_user_context_data"] = None
        __props__.__dict__["enable_token_revocation"] = None
        __props__.__dict__["explicit_auth_flows"] = None
        __props__.__dict__["generate_secret"] = None
        __props__.__dict__["id_token_validity"] = None
        __props__.__dict__["logout_urls"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["prevent_user_existence_errors"] = None
        __props__.__dict__["read_attributes"] = None
        __props__.__dict__["refresh_token_validity"] = None
        __props__.__dict__["supported_identity_providers"] = None
        __props__.__dict__["token_validity_units"] = None
        __props__.__dict__["user_pool_id"] = None
        __props__.__dict__["write_attributes"] = None
        return UserPoolClient(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessTokenValidity")
    def access_token_validity(self) -> pulumi.Output[Optional[int]]:
        """
        The access token time limit. After this limit expires, your user can't use their access token. To specify the time unit for `AccessTokenValidity` as `seconds` , `minutes` , `hours` , or `days` , set a `TokenValidityUnits` value in your API request.

        For example, when you set `AccessTokenValidity` to `10` and `TokenValidityUnits` to `hours` , your user can authorize access with their access token for 10 hours.

        The default time unit for `AccessTokenValidity` in an API request is hours.
        """
        return pulumi.get(self, "access_token_validity")

    @property
    @pulumi.getter(name="allowedOAuthFlows")
    def allowed_o_auth_flows(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The OAuth grant types that you want your app client to generate. To create an app client that generates client credentials grants, you must add `client_credentials` as the only allowed OAuth flow.

        - **code** - Use a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the `/oauth2/token` endpoint.
        - **implicit** - Issue the access token (and, optionally, ID token, based on scopes) directly to your user.
        - **client_credentials** - Issue the access token from the `/oauth2/token` endpoint directly to a non-person user using a combination of the client ID and client secret.
        """
        return pulumi.get(self, "allowed_o_auth_flows")

    @property
    @pulumi.getter(name="allowedOAuthFlowsUserPoolClient")
    def allowed_o_auth_flows_user_pool_client(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to `true` to use OAuth 2.0 features in your user pool app client.

        `AllowedOAuthFlowsUserPoolClient` must be `true` before you can configure the following features in your app client.

        - `CallBackURLs` : Callback URLs.
        - `LogoutURLs` : Sign-out redirect URLs.
        - `AllowedOAuthScopes` : OAuth 2.0 scopes.
        - `AllowedOAuthFlows` : Support for authorization code, implicit, and client credentials OAuth 2.0 grants.

        To use OAuth 2.0 features, configure one of these features in the Amazon Cognito console or set `AllowedOAuthFlowsUserPoolClient` to `true` in a `CreateUserPoolClient` or `UpdateUserPoolClient` API request. If you don't set a value for `AllowedOAuthFlowsUserPoolClient` in a request with the AWS CLI or SDKs, it defaults to `false` .
        """
        return pulumi.get(self, "allowed_o_auth_flows_user_pool_client")

    @property
    @pulumi.getter(name="allowedOAuthScopes")
    def allowed_o_auth_scopes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The allowed OAuth scopes. Possible values provided by OAuth are `phone` , `email` , `openid` , and `profile` . Possible values provided by AWS are `aws.cognito.signin.user.admin` . Custom scopes created in Resource Servers are also supported.
        """
        return pulumi.get(self, "allowed_o_auth_scopes")

    @property
    @pulumi.getter(name="analyticsConfiguration")
    def analytics_configuration(self) -> pulumi.Output[Optional['outputs.UserPoolClientAnalyticsConfiguration']]:
        """
        The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign.

        > In AWS Regions where Amazon Pinpoint isn't available, user pools only support sending events to Amazon Pinpoint projects in AWS Region us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.
        """
        return pulumi.get(self, "analytics_configuration")

    @property
    @pulumi.getter(name="authSessionValidity")
    def auth_session_validity(self) -> pulumi.Output[Optional[int]]:
        """
        Amazon Cognito creates a session token for each API request in an authentication flow. `AuthSessionValidity` is the duration, in minutes, of that session token. Your user pool native user must respond to each authentication challenge before the session expires.
        """
        return pulumi.get(self, "auth_session_validity")

    @property
    @pulumi.getter(name="callbackUrls")
    def callback_urls(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of allowed redirect (callback) URLs for the IdPs.

        A redirect URI must:

        - Be an absolute URI.
        - Be registered with the authorization server.
        - Not include a fragment component.

        See [OAuth 2.0 - Redirection Endpoint](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6749#section-3.1.2) .

        Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.

        App callback URLs such as myapp://example are also supported.
        """
        return pulumi.get(self, "callback_urls")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[str]:
        """
        The ID of the app client, for example `1example23456789` .
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientName")
    def client_name(self) -> pulumi.Output[Optional[str]]:
        """
        The client name for the user pool client you would like to create.
        """
        return pulumi.get(self, "client_name")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[str]:
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter(name="defaultRedirectUri")
    def default_redirect_uri(self) -> pulumi.Output[Optional[str]]:
        """
        The default redirect URI. In app clients with one assigned IdP, replaces `redirect_uri` in authentication requests. Must be in the `CallbackURLs` list.

        A redirect URI must:

        - Be an absolute URI.
        - Be registered with the authorization server.
        - Not include a fragment component.

        For more information, see [Default redirect URI](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-client-apps.html#cognito-user-pools-app-idp-settings-about) .

        Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.

        App callback URLs such as myapp://example are also supported.
        """
        return pulumi.get(self, "default_redirect_uri")

    @property
    @pulumi.getter(name="enablePropagateAdditionalUserContextData")
    def enable_propagate_additional_user_context_data(self) -> pulumi.Output[Optional[bool]]:
        """
        Activates the propagation of additional user context data. For more information about propagation of user context data, see [Adding advanced security to a user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html) . If you don’t include this parameter, you can't send device fingerprint information, including source IP address, to Amazon Cognito advanced security. You can only activate `EnablePropagateAdditionalUserContextData` in an app client that has a client secret.
        """
        return pulumi.get(self, "enable_propagate_additional_user_context_data")

    @property
    @pulumi.getter(name="enableTokenRevocation")
    def enable_token_revocation(self) -> pulumi.Output[Optional[bool]]:
        """
        Activates or deactivates token revocation. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html) .

        If you don't include this parameter, token revocation is automatically activated for the new user pool client.
        """
        return pulumi.get(self, "enable_token_revocation")

    @property
    @pulumi.getter(name="explicitAuthFlows")
    def explicit_auth_flows(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The authentication flows that you want your user pool client to support. For each app client in your user pool, you can sign in your users with any combination of one or more flows, including with a user name and Secure Remote Password (SRP), a user name and password, or a custom authentication process that you define with Lambda functions.

        > If you don't specify a value for `ExplicitAuthFlows` , your user client supports `ALLOW_REFRESH_TOKEN_AUTH` , `ALLOW_USER_SRP_AUTH` , and `ALLOW_CUSTOM_AUTH` . 

        Valid values include:

        - `ALLOW_ADMIN_USER_PASSWORD_AUTH` : Enable admin based user password authentication flow `ADMIN_USER_PASSWORD_AUTH` . This setting replaces the `ADMIN_NO_SRP_AUTH` setting. With this authentication flow, your app passes a user name and password to Amazon Cognito in the request, instead of using the Secure Remote Password (SRP) protocol to securely transmit the password.
        - `ALLOW_CUSTOM_AUTH` : Enable Lambda trigger based authentication.
        - `ALLOW_USER_PASSWORD_AUTH` : Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
        - `ALLOW_USER_SRP_AUTH` : Enable SRP-based authentication.
        - `ALLOW_REFRESH_TOKEN_AUTH` : Enable authflow to refresh tokens.

        In some environments, you will see the values `ADMIN_NO_SRP_AUTH` , `CUSTOM_AUTH_FLOW_ONLY` , or `USER_PASSWORD_AUTH` . You can't assign these legacy `ExplicitAuthFlows` values to user pool clients at the same time as values that begin with `ALLOW_` ,
        like `ALLOW_USER_SRP_AUTH` .
        """
        return pulumi.get(self, "explicit_auth_flows")

    @property
    @pulumi.getter(name="generateSecret")
    def generate_secret(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean to specify whether you want to generate a secret for the user pool client being created.
        """
        return pulumi.get(self, "generate_secret")

    @property
    @pulumi.getter(name="idTokenValidity")
    def id_token_validity(self) -> pulumi.Output[Optional[int]]:
        """
        The ID token time limit. After this limit expires, your user can't use their ID token. To specify the time unit for `IdTokenValidity` as `seconds` , `minutes` , `hours` , or `days` , set a `TokenValidityUnits` value in your API request.

        For example, when you set `IdTokenValidity` as `10` and `TokenValidityUnits` as `hours` , your user can authenticate their session with their ID token for 10 hours.

        The default time unit for `IdTokenValidity` in an API request is hours.
        """
        return pulumi.get(self, "id_token_validity")

    @property
    @pulumi.getter(name="logoutUrls")
    def logout_urls(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of allowed logout URLs for the IdPs.
        """
        return pulumi.get(self, "logout_urls")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="preventUserExistenceErrors")
    def prevent_user_existence_errors(self) -> pulumi.Output[Optional[str]]:
        """
        Use this setting to choose which errors and responses are returned by Cognito APIs during authentication, account confirmation, and password recovery when the user does not exist in the user pool. When set to `ENABLED` and the user does not exist, authentication returns an error indicating either the username or password was incorrect, and account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to `LEGACY` , those APIs will return a `UserNotFoundException` exception if the user does not exist in the user pool.
        """
        return pulumi.get(self, "prevent_user_existence_errors")

    @property
    @pulumi.getter(name="readAttributes")
    def read_attributes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of user attributes that you want your app client to have read access to. After your user authenticates in your app, their access token authorizes them to read their own attribute value for any attribute in this list. An example of this kind of activity is when your user selects a link to view their profile information. Your app makes a [GetUser](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetUser.html) API request to retrieve and display your user's profile data.

        When you don't specify the `ReadAttributes` for your app client, your app can read the values of `email_verified` , `phone_number_verified` , and the Standard attributes of your user pool. When your user pool app client has read access to these default attributes, `ReadAttributes` doesn't return any information. Amazon Cognito only populates `ReadAttributes` in the API response if you have specified your own custom set of read attributes.
        """
        return pulumi.get(self, "read_attributes")

    @property
    @pulumi.getter(name="refreshTokenValidity")
    def refresh_token_validity(self) -> pulumi.Output[Optional[int]]:
        """
        The refresh token time limit. After this limit expires, your user can't use their refresh token. To specify the time unit for `RefreshTokenValidity` as `seconds` , `minutes` , `hours` , or `days` , set a `TokenValidityUnits` value in your API request.

        For example, when you set `RefreshTokenValidity` as `10` and `TokenValidityUnits` as `days` , your user can refresh their session and retrieve new access and ID tokens for 10 days.

        The default time unit for `RefreshTokenValidity` in an API request is days. You can't set `RefreshTokenValidity` to 0. If you do, Amazon Cognito overrides the value with the default value of 30 days.
        """
        return pulumi.get(self, "refresh_token_validity")

    @property
    @pulumi.getter(name="supportedIdentityProviders")
    def supported_identity_providers(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of provider names for the identity providers (IdPs) that are supported on this client. The following are supported: `COGNITO` , `Facebook` , `Google` , `SignInWithApple` , and `LoginWithAmazon` . You can also specify the names that you configured for the SAML and OIDC IdPs in your user pool, for example `MySAMLIdP` or `MyOIDCIdP` .
        """
        return pulumi.get(self, "supported_identity_providers")

    @property
    @pulumi.getter(name="tokenValidityUnits")
    def token_validity_units(self) -> pulumi.Output[Optional['outputs.UserPoolClientTokenValidityUnits']]:
        """
        The units in which the validity times are represented. The default unit for RefreshToken is days, and default for ID and access tokens are hours.
        """
        return pulumi.get(self, "token_validity_units")

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Output[str]:
        """
        The user pool ID for the user pool where you want to create a user pool client.
        """
        return pulumi.get(self, "user_pool_id")

    @property
    @pulumi.getter(name="writeAttributes")
    def write_attributes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of user attributes that you want your app client to have write access to. After your user authenticates in your app, their access token authorizes them to set or modify their own attribute value for any attribute in this list. An example of this kind of activity is when you present your user with a form to update their profile information and they change their last name. Your app then makes an [UpdateUserAttributes](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserAttributes.html) API request and sets `family_name` to the new value.

        When you don't specify the `WriteAttributes` for your app client, your app can write the values of the Standard attributes of your user pool. When your user pool has write access to these default attributes, `WriteAttributes` doesn't return any information. Amazon Cognito only populates `WriteAttributes` in the API response if you have specified your own custom set of write attributes.

        If your app client allows users to sign in through an IdP, this array must include all attributes that you have mapped to IdP attributes. Amazon Cognito updates mapped attributes when users sign in to your application through an IdP. If your app client does not have write access to a mapped attribute, Amazon Cognito throws an error when it tries to update the attribute. For more information, see [Specifying IdP Attribute Mappings for Your user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html) .
        """
        return pulumi.get(self, "write_attributes")

