# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserPoolArgs', 'UserPool']

@pulumi.input_type
class UserPoolArgs:
    def __init__(__self__, *,
                 account_recovery_setting: Optional[pulumi.Input['UserPoolAccountRecoverySettingArgs']] = None,
                 admin_create_user_config: Optional[pulumi.Input['UserPoolAdminCreateUserConfigArgs']] = None,
                 alias_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 auto_verified_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 deletion_protection: Optional[pulumi.Input[str]] = None,
                 device_configuration: Optional[pulumi.Input['UserPoolDeviceConfigurationArgs']] = None,
                 email_authentication_message: Optional[pulumi.Input[str]] = None,
                 email_authentication_subject: Optional[pulumi.Input[str]] = None,
                 email_configuration: Optional[pulumi.Input['UserPoolEmailConfigurationArgs']] = None,
                 email_verification_message: Optional[pulumi.Input[str]] = None,
                 email_verification_subject: Optional[pulumi.Input[str]] = None,
                 enabled_mfas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 lambda_config: Optional[pulumi.Input['UserPoolLambdaConfigArgs']] = None,
                 mfa_configuration: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input['UserPoolPoliciesArgs']] = None,
                 schema: Optional[pulumi.Input[Sequence[pulumi.Input['UserPoolSchemaAttributeArgs']]]] = None,
                 sms_authentication_message: Optional[pulumi.Input[str]] = None,
                 sms_configuration: Optional[pulumi.Input['UserPoolSmsConfigurationArgs']] = None,
                 sms_verification_message: Optional[pulumi.Input[str]] = None,
                 user_attribute_update_settings: Optional[pulumi.Input['UserPoolUserAttributeUpdateSettingsArgs']] = None,
                 user_pool_add_ons: Optional[pulumi.Input['UserPoolAddOnsArgs']] = None,
                 user_pool_name: Optional[pulumi.Input[str]] = None,
                 user_pool_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 username_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username_configuration: Optional[pulumi.Input['UserPoolUsernameConfigurationArgs']] = None,
                 verification_message_template: Optional[pulumi.Input['UserPoolVerificationMessageTemplateArgs']] = None):
        """
        The set of arguments for constructing a UserPool resource.
        :param pulumi.Input['UserPoolAccountRecoverySettingArgs'] account_recovery_setting: Use this setting to define which verified available method a user can use to recover their password when they call `ForgotPassword` . It allows you to define a preferred method when a user has more than one method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the recovery method where SMS is preferred over email.
        :param pulumi.Input['UserPoolAdminCreateUserConfigArgs'] admin_create_user_config: The settings for administrator creation of users in a user pool. Contains settings for allowing user sign-up, customizing invitation messages to new users, and the amount of time before temporary passwords expire.
               
               This data type is a request and response parameter of [CreateUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPool.html) and [UpdateUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserPool.html) , and a response parameter of [DescribeUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html) .
        :param pulumi.Input[Sequence[pulumi.Input[str]]] alias_attributes: Attributes supported as an alias for this user pool. Possible values: *phone_number* , *email* , or *preferred_username* .
               
               > This user pool property cannot be updated.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] auto_verified_attributes: The attributes to be auto-verified. Possible values: *email* , *phone_number* .
        :param pulumi.Input[str] deletion_protection: When active, `DeletionProtection` prevents accidental deletion of your user
               pool. Before you can delete a user pool that you have protected against deletion, you
               must deactivate this feature.
               
               When you try to delete a protected user pool in a `DeleteUserPool` API request, Amazon Cognito returns an `InvalidParameterException` error. To delete a protected user pool, send a new `DeleteUserPool` request after you deactivate deletion protection in an `UpdateUserPool` API request.
        :param pulumi.Input['UserPoolDeviceConfigurationArgs'] device_configuration: The device-remembering configuration for a user pool. A null value indicates that you have deactivated device remembering in your user pool.
               
               > When you provide a value for any `DeviceConfiguration` field, you activate the Amazon Cognito device-remembering feature.
        :param pulumi.Input['UserPoolEmailConfigurationArgs'] email_configuration: The email configuration of your user pool. The email configuration type sets your preferred sending method, AWS Region, and sender for messages from your user pool.
        :param pulumi.Input[str] email_verification_message: This parameter is no longer used. See [VerificationMessageTemplateType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html) .
        :param pulumi.Input[str] email_verification_subject: This parameter is no longer used. See [VerificationMessageTemplateType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html) .
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_mfas: Enables MFA on a specified user pool. To disable all MFAs after it has been enabled, set MfaConfiguration to "OFF" and remove EnabledMfas. MFAs can only be all disabled if MfaConfiguration is OFF. Once SMS_MFA is enabled, SMS_MFA can only be disabled by setting MfaConfiguration to "OFF". Can be one of the following values:
               
               - `SMS_MFA` - Enables SMS MFA for the user pool. SMS_MFA can only be enabled if SMS configuration is provided.
               - `SOFTWARE_TOKEN_MFA` - Enables software token MFA for the user pool.
               
               Allowed values: `SMS_MFA` | `SOFTWARE_TOKEN_MFA`
        :param pulumi.Input['UserPoolLambdaConfigArgs'] lambda_config: A collection of user pool Lambda triggers. Amazon Cognito invokes triggers at several possible stages of authentication operations. Triggers can modify the outcome of the operations that invoked them.
        :param pulumi.Input[str] mfa_configuration: The multi-factor authentication (MFA) configuration. Valid values include:
               
               - `OFF` MFA won't be used for any users.
               - `ON` MFA is required for all users to sign in.
               - `OPTIONAL` MFA will be required only for individual users who have an MFA factor activated.
        :param pulumi.Input['UserPoolPoliciesArgs'] policies: A list of user pool policies. Contains the policy that sets password-complexity requirements.
               
               This data type is a request and response parameter of [CreateUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPool.html) and [UpdateUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserPool.html) , and a response parameter of [DescribeUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html) .
        :param pulumi.Input[Sequence[pulumi.Input['UserPoolSchemaAttributeArgs']]] schema: The schema attributes for the new user pool. These attributes can be standard or custom attributes.
               
               > During a user pool update, you can add new schema attributes but you cannot modify or delete an existing schema attribute.
        :param pulumi.Input[str] sms_authentication_message: A string representing the SMS authentication message.
        :param pulumi.Input['UserPoolSmsConfigurationArgs'] sms_configuration: The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your AWS account through Amazon Simple Notification Service. To send SMS messages with Amazon SNS in the AWS Region that you want, the Amazon Cognito user pool uses an AWS Identity and Access Management (IAM) role in your AWS account .
        :param pulumi.Input[str] sms_verification_message: This parameter is no longer used. See [VerificationMessageTemplateType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html) .
        :param pulumi.Input['UserPoolUserAttributeUpdateSettingsArgs'] user_attribute_update_settings: The settings for updates to user attributes. These settings include the property `AttributesRequireVerificationBeforeUpdate` ,
               a user-pool setting that tells Amazon Cognito how to handle changes to the value of your users' email address and phone number attributes. For
               more information, see [Verifying updates to email addresses and phone numbers](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates) .
        :param pulumi.Input['UserPoolAddOnsArgs'] user_pool_add_ons: User pool add-ons. Contains settings for activation of advanced security features. To log user security information but take no action, set to `AUDIT` . To configure automatic security responses to risky traffic to your user pool, set to `ENFORCED` .
               
               For more information, see [Adding advanced security to a user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html) .
        :param pulumi.Input[str] user_pool_name: A string used to name the user pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_pool_tags: The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] username_attributes: Determines whether email addresses or phone numbers can be specified as user names when a user signs up. Possible values: `phone_number` or `email` .
               
               This user pool property cannot be updated.
        :param pulumi.Input['UserPoolUsernameConfigurationArgs'] username_configuration: You can choose to set case sensitivity on the username input for the selected sign-in option. For example, when this is set to `False` , users will be able to sign in using either "username" or "Username". This configuration is immutable once it has been set.
        :param pulumi.Input['UserPoolVerificationMessageTemplateArgs'] verification_message_template: The template for the verification message that your user pool delivers to users who set an email address or phone number attribute.
               
               Set the email message type that corresponds to your `DefaultEmailOption` selection. For `CONFIRM_WITH_LINK` , specify an `EmailMessageByLink` and leave `EmailMessage` blank. For `CONFIRM_WITH_CODE` , specify an `EmailMessage` and leave `EmailMessageByLink` blank. When you supply both parameters with either choice, Amazon Cognito returns an error.
        """
        if account_recovery_setting is not None:
            pulumi.set(__self__, "account_recovery_setting", account_recovery_setting)
        if admin_create_user_config is not None:
            pulumi.set(__self__, "admin_create_user_config", admin_create_user_config)
        if alias_attributes is not None:
            pulumi.set(__self__, "alias_attributes", alias_attributes)
        if auto_verified_attributes is not None:
            pulumi.set(__self__, "auto_verified_attributes", auto_verified_attributes)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if device_configuration is not None:
            pulumi.set(__self__, "device_configuration", device_configuration)
        if email_authentication_message is not None:
            pulumi.set(__self__, "email_authentication_message", email_authentication_message)
        if email_authentication_subject is not None:
            pulumi.set(__self__, "email_authentication_subject", email_authentication_subject)
        if email_configuration is not None:
            pulumi.set(__self__, "email_configuration", email_configuration)
        if email_verification_message is not None:
            pulumi.set(__self__, "email_verification_message", email_verification_message)
        if email_verification_subject is not None:
            pulumi.set(__self__, "email_verification_subject", email_verification_subject)
        if enabled_mfas is not None:
            pulumi.set(__self__, "enabled_mfas", enabled_mfas)
        if lambda_config is not None:
            pulumi.set(__self__, "lambda_config", lambda_config)
        if mfa_configuration is not None:
            pulumi.set(__self__, "mfa_configuration", mfa_configuration)
        if policies is not None:
            pulumi.set(__self__, "policies", policies)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if sms_authentication_message is not None:
            pulumi.set(__self__, "sms_authentication_message", sms_authentication_message)
        if sms_configuration is not None:
            pulumi.set(__self__, "sms_configuration", sms_configuration)
        if sms_verification_message is not None:
            pulumi.set(__self__, "sms_verification_message", sms_verification_message)
        if user_attribute_update_settings is not None:
            pulumi.set(__self__, "user_attribute_update_settings", user_attribute_update_settings)
        if user_pool_add_ons is not None:
            pulumi.set(__self__, "user_pool_add_ons", user_pool_add_ons)
        if user_pool_name is not None:
            pulumi.set(__self__, "user_pool_name", user_pool_name)
        if user_pool_tags is not None:
            pulumi.set(__self__, "user_pool_tags", user_pool_tags)
        if username_attributes is not None:
            pulumi.set(__self__, "username_attributes", username_attributes)
        if username_configuration is not None:
            pulumi.set(__self__, "username_configuration", username_configuration)
        if verification_message_template is not None:
            pulumi.set(__self__, "verification_message_template", verification_message_template)

    @property
    @pulumi.getter(name="accountRecoverySetting")
    def account_recovery_setting(self) -> Optional[pulumi.Input['UserPoolAccountRecoverySettingArgs']]:
        """
        Use this setting to define which verified available method a user can use to recover their password when they call `ForgotPassword` . It allows you to define a preferred method when a user has more than one method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the recovery method where SMS is preferred over email.
        """
        return pulumi.get(self, "account_recovery_setting")

    @account_recovery_setting.setter
    def account_recovery_setting(self, value: Optional[pulumi.Input['UserPoolAccountRecoverySettingArgs']]):
        pulumi.set(self, "account_recovery_setting", value)

    @property
    @pulumi.getter(name="adminCreateUserConfig")
    def admin_create_user_config(self) -> Optional[pulumi.Input['UserPoolAdminCreateUserConfigArgs']]:
        """
        The settings for administrator creation of users in a user pool. Contains settings for allowing user sign-up, customizing invitation messages to new users, and the amount of time before temporary passwords expire.

        This data type is a request and response parameter of [CreateUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPool.html) and [UpdateUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserPool.html) , and a response parameter of [DescribeUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html) .
        """
        return pulumi.get(self, "admin_create_user_config")

    @admin_create_user_config.setter
    def admin_create_user_config(self, value: Optional[pulumi.Input['UserPoolAdminCreateUserConfigArgs']]):
        pulumi.set(self, "admin_create_user_config", value)

    @property
    @pulumi.getter(name="aliasAttributes")
    def alias_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Attributes supported as an alias for this user pool. Possible values: *phone_number* , *email* , or *preferred_username* .

        > This user pool property cannot be updated.
        """
        return pulumi.get(self, "alias_attributes")

    @alias_attributes.setter
    def alias_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "alias_attributes", value)

    @property
    @pulumi.getter(name="autoVerifiedAttributes")
    def auto_verified_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The attributes to be auto-verified. Possible values: *email* , *phone_number* .
        """
        return pulumi.get(self, "auto_verified_attributes")

    @auto_verified_attributes.setter
    def auto_verified_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "auto_verified_attributes", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[str]]:
        """
        When active, `DeletionProtection` prevents accidental deletion of your user
        pool. Before you can delete a user pool that you have protected against deletion, you
        must deactivate this feature.

        When you try to delete a protected user pool in a `DeleteUserPool` API request, Amazon Cognito returns an `InvalidParameterException` error. To delete a protected user pool, send a new `DeleteUserPool` request after you deactivate deletion protection in an `UpdateUserPool` API request.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="deviceConfiguration")
    def device_configuration(self) -> Optional[pulumi.Input['UserPoolDeviceConfigurationArgs']]:
        """
        The device-remembering configuration for a user pool. A null value indicates that you have deactivated device remembering in your user pool.

        > When you provide a value for any `DeviceConfiguration` field, you activate the Amazon Cognito device-remembering feature.
        """
        return pulumi.get(self, "device_configuration")

    @device_configuration.setter
    def device_configuration(self, value: Optional[pulumi.Input['UserPoolDeviceConfigurationArgs']]):
        pulumi.set(self, "device_configuration", value)

    @property
    @pulumi.getter(name="emailAuthenticationMessage")
    def email_authentication_message(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "email_authentication_message")

    @email_authentication_message.setter
    def email_authentication_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_authentication_message", value)

    @property
    @pulumi.getter(name="emailAuthenticationSubject")
    def email_authentication_subject(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "email_authentication_subject")

    @email_authentication_subject.setter
    def email_authentication_subject(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_authentication_subject", value)

    @property
    @pulumi.getter(name="emailConfiguration")
    def email_configuration(self) -> Optional[pulumi.Input['UserPoolEmailConfigurationArgs']]:
        """
        The email configuration of your user pool. The email configuration type sets your preferred sending method, AWS Region, and sender for messages from your user pool.
        """
        return pulumi.get(self, "email_configuration")

    @email_configuration.setter
    def email_configuration(self, value: Optional[pulumi.Input['UserPoolEmailConfigurationArgs']]):
        pulumi.set(self, "email_configuration", value)

    @property
    @pulumi.getter(name="emailVerificationMessage")
    def email_verification_message(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter is no longer used. See [VerificationMessageTemplateType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html) .
        """
        return pulumi.get(self, "email_verification_message")

    @email_verification_message.setter
    def email_verification_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_verification_message", value)

    @property
    @pulumi.getter(name="emailVerificationSubject")
    def email_verification_subject(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter is no longer used. See [VerificationMessageTemplateType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html) .
        """
        return pulumi.get(self, "email_verification_subject")

    @email_verification_subject.setter
    def email_verification_subject(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_verification_subject", value)

    @property
    @pulumi.getter(name="enabledMfas")
    def enabled_mfas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Enables MFA on a specified user pool. To disable all MFAs after it has been enabled, set MfaConfiguration to "OFF" and remove EnabledMfas. MFAs can only be all disabled if MfaConfiguration is OFF. Once SMS_MFA is enabled, SMS_MFA can only be disabled by setting MfaConfiguration to "OFF". Can be one of the following values:

        - `SMS_MFA` - Enables SMS MFA for the user pool. SMS_MFA can only be enabled if SMS configuration is provided.
        - `SOFTWARE_TOKEN_MFA` - Enables software token MFA for the user pool.

        Allowed values: `SMS_MFA` | `SOFTWARE_TOKEN_MFA`
        """
        return pulumi.get(self, "enabled_mfas")

    @enabled_mfas.setter
    def enabled_mfas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enabled_mfas", value)

    @property
    @pulumi.getter(name="lambdaConfig")
    def lambda_config(self) -> Optional[pulumi.Input['UserPoolLambdaConfigArgs']]:
        """
        A collection of user pool Lambda triggers. Amazon Cognito invokes triggers at several possible stages of authentication operations. Triggers can modify the outcome of the operations that invoked them.
        """
        return pulumi.get(self, "lambda_config")

    @lambda_config.setter
    def lambda_config(self, value: Optional[pulumi.Input['UserPoolLambdaConfigArgs']]):
        pulumi.set(self, "lambda_config", value)

    @property
    @pulumi.getter(name="mfaConfiguration")
    def mfa_configuration(self) -> Optional[pulumi.Input[str]]:
        """
        The multi-factor authentication (MFA) configuration. Valid values include:

        - `OFF` MFA won't be used for any users.
        - `ON` MFA is required for all users to sign in.
        - `OPTIONAL` MFA will be required only for individual users who have an MFA factor activated.
        """
        return pulumi.get(self, "mfa_configuration")

    @mfa_configuration.setter
    def mfa_configuration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mfa_configuration", value)

    @property
    @pulumi.getter
    def policies(self) -> Optional[pulumi.Input['UserPoolPoliciesArgs']]:
        """
        A list of user pool policies. Contains the policy that sets password-complexity requirements.

        This data type is a request and response parameter of [CreateUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPool.html) and [UpdateUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserPool.html) , and a response parameter of [DescribeUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html) .
        """
        return pulumi.get(self, "policies")

    @policies.setter
    def policies(self, value: Optional[pulumi.Input['UserPoolPoliciesArgs']]):
        pulumi.set(self, "policies", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserPoolSchemaAttributeArgs']]]]:
        """
        The schema attributes for the new user pool. These attributes can be standard or custom attributes.

        > During a user pool update, you can add new schema attributes but you cannot modify or delete an existing schema attribute.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserPoolSchemaAttributeArgs']]]]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter(name="smsAuthenticationMessage")
    def sms_authentication_message(self) -> Optional[pulumi.Input[str]]:
        """
        A string representing the SMS authentication message.
        """
        return pulumi.get(self, "sms_authentication_message")

    @sms_authentication_message.setter
    def sms_authentication_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sms_authentication_message", value)

    @property
    @pulumi.getter(name="smsConfiguration")
    def sms_configuration(self) -> Optional[pulumi.Input['UserPoolSmsConfigurationArgs']]:
        """
        The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your AWS account through Amazon Simple Notification Service. To send SMS messages with Amazon SNS in the AWS Region that you want, the Amazon Cognito user pool uses an AWS Identity and Access Management (IAM) role in your AWS account .
        """
        return pulumi.get(self, "sms_configuration")

    @sms_configuration.setter
    def sms_configuration(self, value: Optional[pulumi.Input['UserPoolSmsConfigurationArgs']]):
        pulumi.set(self, "sms_configuration", value)

    @property
    @pulumi.getter(name="smsVerificationMessage")
    def sms_verification_message(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter is no longer used. See [VerificationMessageTemplateType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html) .
        """
        return pulumi.get(self, "sms_verification_message")

    @sms_verification_message.setter
    def sms_verification_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sms_verification_message", value)

    @property
    @pulumi.getter(name="userAttributeUpdateSettings")
    def user_attribute_update_settings(self) -> Optional[pulumi.Input['UserPoolUserAttributeUpdateSettingsArgs']]:
        """
        The settings for updates to user attributes. These settings include the property `AttributesRequireVerificationBeforeUpdate` ,
        a user-pool setting that tells Amazon Cognito how to handle changes to the value of your users' email address and phone number attributes. For
        more information, see [Verifying updates to email addresses and phone numbers](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates) .
        """
        return pulumi.get(self, "user_attribute_update_settings")

    @user_attribute_update_settings.setter
    def user_attribute_update_settings(self, value: Optional[pulumi.Input['UserPoolUserAttributeUpdateSettingsArgs']]):
        pulumi.set(self, "user_attribute_update_settings", value)

    @property
    @pulumi.getter(name="userPoolAddOns")
    def user_pool_add_ons(self) -> Optional[pulumi.Input['UserPoolAddOnsArgs']]:
        """
        User pool add-ons. Contains settings for activation of advanced security features. To log user security information but take no action, set to `AUDIT` . To configure automatic security responses to risky traffic to your user pool, set to `ENFORCED` .

        For more information, see [Adding advanced security to a user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html) .
        """
        return pulumi.get(self, "user_pool_add_ons")

    @user_pool_add_ons.setter
    def user_pool_add_ons(self, value: Optional[pulumi.Input['UserPoolAddOnsArgs']]):
        pulumi.set(self, "user_pool_add_ons", value)

    @property
    @pulumi.getter(name="userPoolName")
    def user_pool_name(self) -> Optional[pulumi.Input[str]]:
        """
        A string used to name the user pool.
        """
        return pulumi.get(self, "user_pool_name")

    @user_pool_name.setter
    def user_pool_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_pool_name", value)

    @property
    @pulumi.getter(name="userPoolTags")
    def user_pool_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
        """
        return pulumi.get(self, "user_pool_tags")

    @user_pool_tags.setter
    def user_pool_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "user_pool_tags", value)

    @property
    @pulumi.getter(name="usernameAttributes")
    def username_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Determines whether email addresses or phone numbers can be specified as user names when a user signs up. Possible values: `phone_number` or `email` .

        This user pool property cannot be updated.
        """
        return pulumi.get(self, "username_attributes")

    @username_attributes.setter
    def username_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "username_attributes", value)

    @property
    @pulumi.getter(name="usernameConfiguration")
    def username_configuration(self) -> Optional[pulumi.Input['UserPoolUsernameConfigurationArgs']]:
        """
        You can choose to set case sensitivity on the username input for the selected sign-in option. For example, when this is set to `False` , users will be able to sign in using either "username" or "Username". This configuration is immutable once it has been set.
        """
        return pulumi.get(self, "username_configuration")

    @username_configuration.setter
    def username_configuration(self, value: Optional[pulumi.Input['UserPoolUsernameConfigurationArgs']]):
        pulumi.set(self, "username_configuration", value)

    @property
    @pulumi.getter(name="verificationMessageTemplate")
    def verification_message_template(self) -> Optional[pulumi.Input['UserPoolVerificationMessageTemplateArgs']]:
        """
        The template for the verification message that your user pool delivers to users who set an email address or phone number attribute.

        Set the email message type that corresponds to your `DefaultEmailOption` selection. For `CONFIRM_WITH_LINK` , specify an `EmailMessageByLink` and leave `EmailMessage` blank. For `CONFIRM_WITH_CODE` , specify an `EmailMessage` and leave `EmailMessageByLink` blank. When you supply both parameters with either choice, Amazon Cognito returns an error.
        """
        return pulumi.get(self, "verification_message_template")

    @verification_message_template.setter
    def verification_message_template(self, value: Optional[pulumi.Input['UserPoolVerificationMessageTemplateArgs']]):
        pulumi.set(self, "verification_message_template", value)


class UserPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_recovery_setting: Optional[pulumi.Input[Union['UserPoolAccountRecoverySettingArgs', 'UserPoolAccountRecoverySettingArgsDict']]] = None,
                 admin_create_user_config: Optional[pulumi.Input[Union['UserPoolAdminCreateUserConfigArgs', 'UserPoolAdminCreateUserConfigArgsDict']]] = None,
                 alias_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 auto_verified_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 deletion_protection: Optional[pulumi.Input[str]] = None,
                 device_configuration: Optional[pulumi.Input[Union['UserPoolDeviceConfigurationArgs', 'UserPoolDeviceConfigurationArgsDict']]] = None,
                 email_authentication_message: Optional[pulumi.Input[str]] = None,
                 email_authentication_subject: Optional[pulumi.Input[str]] = None,
                 email_configuration: Optional[pulumi.Input[Union['UserPoolEmailConfigurationArgs', 'UserPoolEmailConfigurationArgsDict']]] = None,
                 email_verification_message: Optional[pulumi.Input[str]] = None,
                 email_verification_subject: Optional[pulumi.Input[str]] = None,
                 enabled_mfas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 lambda_config: Optional[pulumi.Input[Union['UserPoolLambdaConfigArgs', 'UserPoolLambdaConfigArgsDict']]] = None,
                 mfa_configuration: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Union['UserPoolPoliciesArgs', 'UserPoolPoliciesArgsDict']]] = None,
                 schema: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserPoolSchemaAttributeArgs', 'UserPoolSchemaAttributeArgsDict']]]]] = None,
                 sms_authentication_message: Optional[pulumi.Input[str]] = None,
                 sms_configuration: Optional[pulumi.Input[Union['UserPoolSmsConfigurationArgs', 'UserPoolSmsConfigurationArgsDict']]] = None,
                 sms_verification_message: Optional[pulumi.Input[str]] = None,
                 user_attribute_update_settings: Optional[pulumi.Input[Union['UserPoolUserAttributeUpdateSettingsArgs', 'UserPoolUserAttributeUpdateSettingsArgsDict']]] = None,
                 user_pool_add_ons: Optional[pulumi.Input[Union['UserPoolAddOnsArgs', 'UserPoolAddOnsArgsDict']]] = None,
                 user_pool_name: Optional[pulumi.Input[str]] = None,
                 user_pool_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 username_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username_configuration: Optional[pulumi.Input[Union['UserPoolUsernameConfigurationArgs', 'UserPoolUsernameConfigurationArgsDict']]] = None,
                 verification_message_template: Optional[pulumi.Input[Union['UserPoolVerificationMessageTemplateArgs', 'UserPoolVerificationMessageTemplateArgsDict']]] = None,
                 __props__=None):
        """
        Definition of AWS::Cognito::UserPool Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['UserPoolAccountRecoverySettingArgs', 'UserPoolAccountRecoverySettingArgsDict']] account_recovery_setting: Use this setting to define which verified available method a user can use to recover their password when they call `ForgotPassword` . It allows you to define a preferred method when a user has more than one method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the recovery method where SMS is preferred over email.
        :param pulumi.Input[Union['UserPoolAdminCreateUserConfigArgs', 'UserPoolAdminCreateUserConfigArgsDict']] admin_create_user_config: The settings for administrator creation of users in a user pool. Contains settings for allowing user sign-up, customizing invitation messages to new users, and the amount of time before temporary passwords expire.
               
               This data type is a request and response parameter of [CreateUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPool.html) and [UpdateUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserPool.html) , and a response parameter of [DescribeUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html) .
        :param pulumi.Input[Sequence[pulumi.Input[str]]] alias_attributes: Attributes supported as an alias for this user pool. Possible values: *phone_number* , *email* , or *preferred_username* .
               
               > This user pool property cannot be updated.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] auto_verified_attributes: The attributes to be auto-verified. Possible values: *email* , *phone_number* .
        :param pulumi.Input[str] deletion_protection: When active, `DeletionProtection` prevents accidental deletion of your user
               pool. Before you can delete a user pool that you have protected against deletion, you
               must deactivate this feature.
               
               When you try to delete a protected user pool in a `DeleteUserPool` API request, Amazon Cognito returns an `InvalidParameterException` error. To delete a protected user pool, send a new `DeleteUserPool` request after you deactivate deletion protection in an `UpdateUserPool` API request.
        :param pulumi.Input[Union['UserPoolDeviceConfigurationArgs', 'UserPoolDeviceConfigurationArgsDict']] device_configuration: The device-remembering configuration for a user pool. A null value indicates that you have deactivated device remembering in your user pool.
               
               > When you provide a value for any `DeviceConfiguration` field, you activate the Amazon Cognito device-remembering feature.
        :param pulumi.Input[Union['UserPoolEmailConfigurationArgs', 'UserPoolEmailConfigurationArgsDict']] email_configuration: The email configuration of your user pool. The email configuration type sets your preferred sending method, AWS Region, and sender for messages from your user pool.
        :param pulumi.Input[str] email_verification_message: This parameter is no longer used. See [VerificationMessageTemplateType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html) .
        :param pulumi.Input[str] email_verification_subject: This parameter is no longer used. See [VerificationMessageTemplateType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html) .
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_mfas: Enables MFA on a specified user pool. To disable all MFAs after it has been enabled, set MfaConfiguration to "OFF" and remove EnabledMfas. MFAs can only be all disabled if MfaConfiguration is OFF. Once SMS_MFA is enabled, SMS_MFA can only be disabled by setting MfaConfiguration to "OFF". Can be one of the following values:
               
               - `SMS_MFA` - Enables SMS MFA for the user pool. SMS_MFA can only be enabled if SMS configuration is provided.
               - `SOFTWARE_TOKEN_MFA` - Enables software token MFA for the user pool.
               
               Allowed values: `SMS_MFA` | `SOFTWARE_TOKEN_MFA`
        :param pulumi.Input[Union['UserPoolLambdaConfigArgs', 'UserPoolLambdaConfigArgsDict']] lambda_config: A collection of user pool Lambda triggers. Amazon Cognito invokes triggers at several possible stages of authentication operations. Triggers can modify the outcome of the operations that invoked them.
        :param pulumi.Input[str] mfa_configuration: The multi-factor authentication (MFA) configuration. Valid values include:
               
               - `OFF` MFA won't be used for any users.
               - `ON` MFA is required for all users to sign in.
               - `OPTIONAL` MFA will be required only for individual users who have an MFA factor activated.
        :param pulumi.Input[Union['UserPoolPoliciesArgs', 'UserPoolPoliciesArgsDict']] policies: A list of user pool policies. Contains the policy that sets password-complexity requirements.
               
               This data type is a request and response parameter of [CreateUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPool.html) and [UpdateUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserPool.html) , and a response parameter of [DescribeUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html) .
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserPoolSchemaAttributeArgs', 'UserPoolSchemaAttributeArgsDict']]]] schema: The schema attributes for the new user pool. These attributes can be standard or custom attributes.
               
               > During a user pool update, you can add new schema attributes but you cannot modify or delete an existing schema attribute.
        :param pulumi.Input[str] sms_authentication_message: A string representing the SMS authentication message.
        :param pulumi.Input[Union['UserPoolSmsConfigurationArgs', 'UserPoolSmsConfigurationArgsDict']] sms_configuration: The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your AWS account through Amazon Simple Notification Service. To send SMS messages with Amazon SNS in the AWS Region that you want, the Amazon Cognito user pool uses an AWS Identity and Access Management (IAM) role in your AWS account .
        :param pulumi.Input[str] sms_verification_message: This parameter is no longer used. See [VerificationMessageTemplateType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html) .
        :param pulumi.Input[Union['UserPoolUserAttributeUpdateSettingsArgs', 'UserPoolUserAttributeUpdateSettingsArgsDict']] user_attribute_update_settings: The settings for updates to user attributes. These settings include the property `AttributesRequireVerificationBeforeUpdate` ,
               a user-pool setting that tells Amazon Cognito how to handle changes to the value of your users' email address and phone number attributes. For
               more information, see [Verifying updates to email addresses and phone numbers](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates) .
        :param pulumi.Input[Union['UserPoolAddOnsArgs', 'UserPoolAddOnsArgsDict']] user_pool_add_ons: User pool add-ons. Contains settings for activation of advanced security features. To log user security information but take no action, set to `AUDIT` . To configure automatic security responses to risky traffic to your user pool, set to `ENFORCED` .
               
               For more information, see [Adding advanced security to a user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html) .
        :param pulumi.Input[str] user_pool_name: A string used to name the user pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_pool_tags: The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] username_attributes: Determines whether email addresses or phone numbers can be specified as user names when a user signs up. Possible values: `phone_number` or `email` .
               
               This user pool property cannot be updated.
        :param pulumi.Input[Union['UserPoolUsernameConfigurationArgs', 'UserPoolUsernameConfigurationArgsDict']] username_configuration: You can choose to set case sensitivity on the username input for the selected sign-in option. For example, when this is set to `False` , users will be able to sign in using either "username" or "Username". This configuration is immutable once it has been set.
        :param pulumi.Input[Union['UserPoolVerificationMessageTemplateArgs', 'UserPoolVerificationMessageTemplateArgsDict']] verification_message_template: The template for the verification message that your user pool delivers to users who set an email address or phone number attribute.
               
               Set the email message type that corresponds to your `DefaultEmailOption` selection. For `CONFIRM_WITH_LINK` , specify an `EmailMessageByLink` and leave `EmailMessage` blank. For `CONFIRM_WITH_CODE` , specify an `EmailMessage` and leave `EmailMessageByLink` blank. When you supply both parameters with either choice, Amazon Cognito returns an error.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[UserPoolArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Cognito::UserPool Resource Type

        :param str resource_name: The name of the resource.
        :param UserPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_recovery_setting: Optional[pulumi.Input[Union['UserPoolAccountRecoverySettingArgs', 'UserPoolAccountRecoverySettingArgsDict']]] = None,
                 admin_create_user_config: Optional[pulumi.Input[Union['UserPoolAdminCreateUserConfigArgs', 'UserPoolAdminCreateUserConfigArgsDict']]] = None,
                 alias_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 auto_verified_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 deletion_protection: Optional[pulumi.Input[str]] = None,
                 device_configuration: Optional[pulumi.Input[Union['UserPoolDeviceConfigurationArgs', 'UserPoolDeviceConfigurationArgsDict']]] = None,
                 email_authentication_message: Optional[pulumi.Input[str]] = None,
                 email_authentication_subject: Optional[pulumi.Input[str]] = None,
                 email_configuration: Optional[pulumi.Input[Union['UserPoolEmailConfigurationArgs', 'UserPoolEmailConfigurationArgsDict']]] = None,
                 email_verification_message: Optional[pulumi.Input[str]] = None,
                 email_verification_subject: Optional[pulumi.Input[str]] = None,
                 enabled_mfas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 lambda_config: Optional[pulumi.Input[Union['UserPoolLambdaConfigArgs', 'UserPoolLambdaConfigArgsDict']]] = None,
                 mfa_configuration: Optional[pulumi.Input[str]] = None,
                 policies: Optional[pulumi.Input[Union['UserPoolPoliciesArgs', 'UserPoolPoliciesArgsDict']]] = None,
                 schema: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserPoolSchemaAttributeArgs', 'UserPoolSchemaAttributeArgsDict']]]]] = None,
                 sms_authentication_message: Optional[pulumi.Input[str]] = None,
                 sms_configuration: Optional[pulumi.Input[Union['UserPoolSmsConfigurationArgs', 'UserPoolSmsConfigurationArgsDict']]] = None,
                 sms_verification_message: Optional[pulumi.Input[str]] = None,
                 user_attribute_update_settings: Optional[pulumi.Input[Union['UserPoolUserAttributeUpdateSettingsArgs', 'UserPoolUserAttributeUpdateSettingsArgsDict']]] = None,
                 user_pool_add_ons: Optional[pulumi.Input[Union['UserPoolAddOnsArgs', 'UserPoolAddOnsArgsDict']]] = None,
                 user_pool_name: Optional[pulumi.Input[str]] = None,
                 user_pool_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 username_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username_configuration: Optional[pulumi.Input[Union['UserPoolUsernameConfigurationArgs', 'UserPoolUsernameConfigurationArgsDict']]] = None,
                 verification_message_template: Optional[pulumi.Input[Union['UserPoolVerificationMessageTemplateArgs', 'UserPoolVerificationMessageTemplateArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserPoolArgs.__new__(UserPoolArgs)

            __props__.__dict__["account_recovery_setting"] = account_recovery_setting
            __props__.__dict__["admin_create_user_config"] = admin_create_user_config
            __props__.__dict__["alias_attributes"] = alias_attributes
            __props__.__dict__["auto_verified_attributes"] = auto_verified_attributes
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["device_configuration"] = device_configuration
            __props__.__dict__["email_authentication_message"] = email_authentication_message
            __props__.__dict__["email_authentication_subject"] = email_authentication_subject
            __props__.__dict__["email_configuration"] = email_configuration
            __props__.__dict__["email_verification_message"] = email_verification_message
            __props__.__dict__["email_verification_subject"] = email_verification_subject
            __props__.__dict__["enabled_mfas"] = enabled_mfas
            __props__.__dict__["lambda_config"] = lambda_config
            __props__.__dict__["mfa_configuration"] = mfa_configuration
            __props__.__dict__["policies"] = policies
            __props__.__dict__["schema"] = schema
            __props__.__dict__["sms_authentication_message"] = sms_authentication_message
            __props__.__dict__["sms_configuration"] = sms_configuration
            __props__.__dict__["sms_verification_message"] = sms_verification_message
            __props__.__dict__["user_attribute_update_settings"] = user_attribute_update_settings
            __props__.__dict__["user_pool_add_ons"] = user_pool_add_ons
            __props__.__dict__["user_pool_name"] = user_pool_name
            __props__.__dict__["user_pool_tags"] = user_pool_tags
            __props__.__dict__["username_attributes"] = username_attributes
            __props__.__dict__["username_configuration"] = username_configuration
            __props__.__dict__["verification_message_template"] = verification_message_template
            __props__.__dict__["arn"] = None
            __props__.__dict__["provider_name"] = None
            __props__.__dict__["provider_url"] = None
            __props__.__dict__["user_pool_id"] = None
        super(UserPool, __self__).__init__(
            'aws-native:cognito:UserPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'UserPool':
        """
        Get an existing UserPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = UserPoolArgs.__new__(UserPoolArgs)

        __props__.__dict__["account_recovery_setting"] = None
        __props__.__dict__["admin_create_user_config"] = None
        __props__.__dict__["alias_attributes"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["auto_verified_attributes"] = None
        __props__.__dict__["deletion_protection"] = None
        __props__.__dict__["device_configuration"] = None
        __props__.__dict__["email_authentication_message"] = None
        __props__.__dict__["email_authentication_subject"] = None
        __props__.__dict__["email_configuration"] = None
        __props__.__dict__["email_verification_message"] = None
        __props__.__dict__["email_verification_subject"] = None
        __props__.__dict__["enabled_mfas"] = None
        __props__.__dict__["lambda_config"] = None
        __props__.__dict__["mfa_configuration"] = None
        __props__.__dict__["policies"] = None
        __props__.__dict__["provider_name"] = None
        __props__.__dict__["provider_url"] = None
        __props__.__dict__["schema"] = None
        __props__.__dict__["sms_authentication_message"] = None
        __props__.__dict__["sms_configuration"] = None
        __props__.__dict__["sms_verification_message"] = None
        __props__.__dict__["user_attribute_update_settings"] = None
        __props__.__dict__["user_pool_add_ons"] = None
        __props__.__dict__["user_pool_id"] = None
        __props__.__dict__["user_pool_name"] = None
        __props__.__dict__["user_pool_tags"] = None
        __props__.__dict__["username_attributes"] = None
        __props__.__dict__["username_configuration"] = None
        __props__.__dict__["verification_message_template"] = None
        return UserPool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountRecoverySetting")
    def account_recovery_setting(self) -> pulumi.Output[Optional['outputs.UserPoolAccountRecoverySetting']]:
        """
        Use this setting to define which verified available method a user can use to recover their password when they call `ForgotPassword` . It allows you to define a preferred method when a user has more than one method available. With this setting, SMS does not qualify for a valid password recovery mechanism if the user also has SMS MFA enabled. In the absence of this setting, Cognito uses the legacy behavior to determine the recovery method where SMS is preferred over email.
        """
        return pulumi.get(self, "account_recovery_setting")

    @property
    @pulumi.getter(name="adminCreateUserConfig")
    def admin_create_user_config(self) -> pulumi.Output[Optional['outputs.UserPoolAdminCreateUserConfig']]:
        """
        The settings for administrator creation of users in a user pool. Contains settings for allowing user sign-up, customizing invitation messages to new users, and the amount of time before temporary passwords expire.

        This data type is a request and response parameter of [CreateUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPool.html) and [UpdateUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserPool.html) , and a response parameter of [DescribeUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html) .
        """
        return pulumi.get(self, "admin_create_user_config")

    @property
    @pulumi.getter(name="aliasAttributes")
    def alias_attributes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Attributes supported as an alias for this user pool. Possible values: *phone_number* , *email* , or *preferred_username* .

        > This user pool property cannot be updated.
        """
        return pulumi.get(self, "alias_attributes")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the user pool, such as `arn:aws:cognito-idp:us-east-1:123412341234:userpool/us-east-1_123412341` .
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="autoVerifiedAttributes")
    def auto_verified_attributes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The attributes to be auto-verified. Possible values: *email* , *phone_number* .
        """
        return pulumi.get(self, "auto_verified_attributes")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[str]]:
        """
        When active, `DeletionProtection` prevents accidental deletion of your user
        pool. Before you can delete a user pool that you have protected against deletion, you
        must deactivate this feature.

        When you try to delete a protected user pool in a `DeleteUserPool` API request, Amazon Cognito returns an `InvalidParameterException` error. To delete a protected user pool, send a new `DeleteUserPool` request after you deactivate deletion protection in an `UpdateUserPool` API request.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="deviceConfiguration")
    def device_configuration(self) -> pulumi.Output[Optional['outputs.UserPoolDeviceConfiguration']]:
        """
        The device-remembering configuration for a user pool. A null value indicates that you have deactivated device remembering in your user pool.

        > When you provide a value for any `DeviceConfiguration` field, you activate the Amazon Cognito device-remembering feature.
        """
        return pulumi.get(self, "device_configuration")

    @property
    @pulumi.getter(name="emailAuthenticationMessage")
    def email_authentication_message(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "email_authentication_message")

    @property
    @pulumi.getter(name="emailAuthenticationSubject")
    def email_authentication_subject(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "email_authentication_subject")

    @property
    @pulumi.getter(name="emailConfiguration")
    def email_configuration(self) -> pulumi.Output[Optional['outputs.UserPoolEmailConfiguration']]:
        """
        The email configuration of your user pool. The email configuration type sets your preferred sending method, AWS Region, and sender for messages from your user pool.
        """
        return pulumi.get(self, "email_configuration")

    @property
    @pulumi.getter(name="emailVerificationMessage")
    def email_verification_message(self) -> pulumi.Output[Optional[str]]:
        """
        This parameter is no longer used. See [VerificationMessageTemplateType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html) .
        """
        return pulumi.get(self, "email_verification_message")

    @property
    @pulumi.getter(name="emailVerificationSubject")
    def email_verification_subject(self) -> pulumi.Output[Optional[str]]:
        """
        This parameter is no longer used. See [VerificationMessageTemplateType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html) .
        """
        return pulumi.get(self, "email_verification_subject")

    @property
    @pulumi.getter(name="enabledMfas")
    def enabled_mfas(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Enables MFA on a specified user pool. To disable all MFAs after it has been enabled, set MfaConfiguration to "OFF" and remove EnabledMfas. MFAs can only be all disabled if MfaConfiguration is OFF. Once SMS_MFA is enabled, SMS_MFA can only be disabled by setting MfaConfiguration to "OFF". Can be one of the following values:

        - `SMS_MFA` - Enables SMS MFA for the user pool. SMS_MFA can only be enabled if SMS configuration is provided.
        - `SOFTWARE_TOKEN_MFA` - Enables software token MFA for the user pool.

        Allowed values: `SMS_MFA` | `SOFTWARE_TOKEN_MFA`
        """
        return pulumi.get(self, "enabled_mfas")

    @property
    @pulumi.getter(name="lambdaConfig")
    def lambda_config(self) -> pulumi.Output[Optional['outputs.UserPoolLambdaConfig']]:
        """
        A collection of user pool Lambda triggers. Amazon Cognito invokes triggers at several possible stages of authentication operations. Triggers can modify the outcome of the operations that invoked them.
        """
        return pulumi.get(self, "lambda_config")

    @property
    @pulumi.getter(name="mfaConfiguration")
    def mfa_configuration(self) -> pulumi.Output[Optional[str]]:
        """
        The multi-factor authentication (MFA) configuration. Valid values include:

        - `OFF` MFA won't be used for any users.
        - `ON` MFA is required for all users to sign in.
        - `OPTIONAL` MFA will be required only for individual users who have an MFA factor activated.
        """
        return pulumi.get(self, "mfa_configuration")

    @property
    @pulumi.getter
    def policies(self) -> pulumi.Output[Optional['outputs.UserPoolPolicies']]:
        """
        A list of user pool policies. Contains the policy that sets password-complexity requirements.

        This data type is a request and response parameter of [CreateUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_CreateUserPool.html) and [UpdateUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserPool.html) , and a response parameter of [DescribeUserPool](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html) .
        """
        return pulumi.get(self, "policies")

    @property
    @pulumi.getter(name="providerName")
    def provider_name(self) -> pulumi.Output[str]:
        """
        The provider name of the Amazon Cognito user pool, specified as a `String` .
        """
        return pulumi.get(self, "provider_name")

    @property
    @pulumi.getter(name="providerUrl")
    def provider_url(self) -> pulumi.Output[str]:
        """
        The URL of the provider of the Amazon Cognito user pool, specified as a `String` .
        """
        return pulumi.get(self, "provider_url")

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Output[Optional[Sequence['outputs.UserPoolSchemaAttribute']]]:
        """
        The schema attributes for the new user pool. These attributes can be standard or custom attributes.

        > During a user pool update, you can add new schema attributes but you cannot modify or delete an existing schema attribute.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="smsAuthenticationMessage")
    def sms_authentication_message(self) -> pulumi.Output[Optional[str]]:
        """
        A string representing the SMS authentication message.
        """
        return pulumi.get(self, "sms_authentication_message")

    @property
    @pulumi.getter(name="smsConfiguration")
    def sms_configuration(self) -> pulumi.Output[Optional['outputs.UserPoolSmsConfiguration']]:
        """
        The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your AWS account through Amazon Simple Notification Service. To send SMS messages with Amazon SNS in the AWS Region that you want, the Amazon Cognito user pool uses an AWS Identity and Access Management (IAM) role in your AWS account .
        """
        return pulumi.get(self, "sms_configuration")

    @property
    @pulumi.getter(name="smsVerificationMessage")
    def sms_verification_message(self) -> pulumi.Output[Optional[str]]:
        """
        This parameter is no longer used. See [VerificationMessageTemplateType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html) .
        """
        return pulumi.get(self, "sms_verification_message")

    @property
    @pulumi.getter(name="userAttributeUpdateSettings")
    def user_attribute_update_settings(self) -> pulumi.Output[Optional['outputs.UserPoolUserAttributeUpdateSettings']]:
        """
        The settings for updates to user attributes. These settings include the property `AttributesRequireVerificationBeforeUpdate` ,
        a user-pool setting that tells Amazon Cognito how to handle changes to the value of your users' email address and phone number attributes. For
        more information, see [Verifying updates to email addresses and phone numbers](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates) .
        """
        return pulumi.get(self, "user_attribute_update_settings")

    @property
    @pulumi.getter(name="userPoolAddOns")
    def user_pool_add_ons(self) -> pulumi.Output[Optional['outputs.UserPoolAddOns']]:
        """
        User pool add-ons. Contains settings for activation of advanced security features. To log user security information but take no action, set to `AUDIT` . To configure automatic security responses to risky traffic to your user pool, set to `ENFORCED` .

        For more information, see [Adding advanced security to a user pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html) .
        """
        return pulumi.get(self, "user_pool_add_ons")

    @property
    @pulumi.getter(name="userPoolId")
    def user_pool_id(self) -> pulumi.Output[str]:
        """
        The ID of the user pool.
        """
        return pulumi.get(self, "user_pool_id")

    @property
    @pulumi.getter(name="userPoolName")
    def user_pool_name(self) -> pulumi.Output[Optional[str]]:
        """
        A string used to name the user pool.
        """
        return pulumi.get(self, "user_pool_name")

    @property
    @pulumi.getter(name="userPoolTags")
    def user_pool_tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
        """
        return pulumi.get(self, "user_pool_tags")

    @property
    @pulumi.getter(name="usernameAttributes")
    def username_attributes(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Determines whether email addresses or phone numbers can be specified as user names when a user signs up. Possible values: `phone_number` or `email` .

        This user pool property cannot be updated.
        """
        return pulumi.get(self, "username_attributes")

    @property
    @pulumi.getter(name="usernameConfiguration")
    def username_configuration(self) -> pulumi.Output[Optional['outputs.UserPoolUsernameConfiguration']]:
        """
        You can choose to set case sensitivity on the username input for the selected sign-in option. For example, when this is set to `False` , users will be able to sign in using either "username" or "Username". This configuration is immutable once it has been set.
        """
        return pulumi.get(self, "username_configuration")

    @property
    @pulumi.getter(name="verificationMessageTemplate")
    def verification_message_template(self) -> pulumi.Output[Optional['outputs.UserPoolVerificationMessageTemplate']]:
        """
        The template for the verification message that your user pool delivers to users who set an email address or phone number attribute.

        Set the email message type that corresponds to your `DefaultEmailOption` selection. For `CONFIRM_WITH_LINK` , specify an `EmailMessageByLink` and leave `EmailMessage` blank. For `CONFIRM_WITH_CODE` , specify an `EmailMessage` and leave `EmailMessageByLink` blank. When you supply both parameters with either choice, Amazon Cognito returns an error.
        """
        return pulumi.get(self, "verification_message_template")

