# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetUserPoolIdentityProviderResult',
    'AwaitableGetUserPoolIdentityProviderResult',
    'get_user_pool_identity_provider',
    'get_user_pool_identity_provider_output',
]

@pulumi.output_type
class GetUserPoolIdentityProviderResult:
    def __init__(__self__, attribute_mapping=None, id=None, idp_identifiers=None, provider_details=None):
        if attribute_mapping and not isinstance(attribute_mapping, dict):
            raise TypeError("Expected argument 'attribute_mapping' to be a dict")
        pulumi.set(__self__, "attribute_mapping", attribute_mapping)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if idp_identifiers and not isinstance(idp_identifiers, list):
            raise TypeError("Expected argument 'idp_identifiers' to be a list")
        pulumi.set(__self__, "idp_identifiers", idp_identifiers)
        if provider_details and not isinstance(provider_details, dict):
            raise TypeError("Expected argument 'provider_details' to be a dict")
        pulumi.set(__self__, "provider_details", provider_details)

    @property
    @pulumi.getter(name="attributeMapping")
    def attribute_mapping(self) -> Optional[Any]:
        """
        A mapping of IdP attributes to standard and custom user pool attributes.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Cognito::UserPoolIdentityProvider` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "attribute_mapping")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idpIdentifiers")
    def idp_identifiers(self) -> Optional[Sequence[str]]:
        """
        A list of IdP identifiers.
        """
        return pulumi.get(self, "idp_identifiers")

    @property
    @pulumi.getter(name="providerDetails")
    def provider_details(self) -> Optional[Any]:
        """
        The scopes, URLs, and identifiers for your external identity provider. The following
        examples describe the provider detail keys for each IdP type. These values and their
        schema are subject to change. Social IdP `authorize_scopes` values must match
        the values listed here.

        - **OpenID Connect (OIDC)** - Amazon Cognito accepts the following elements when it can't discover endpoint URLs from `oidc_issuer` : `attributes_url` , `authorize_url` , `jwks_uri` , `token_url` .

        Create or update request: `"ProviderDetails": { "attributes_request_method": "GET", "attributes_url": "https://auth.example.com/userInfo", "authorize_scopes": "openid profile email", "authorize_url": "https://auth.example.com/authorize", "client_id": "1example23456789", "client_secret": "provider-app-client-secret", "jwks_uri": "https://auth.example.com/.well-known/jwks.json", "oidc_issuer": "https://auth.example.com", "token_url": "https://example.com/token" }`

        Describe response: `"ProviderDetails": { "attributes_request_method": "GET", "attributes_url": "https://auth.example.com/userInfo", "attributes_url_add_attributes": "false", "authorize_scopes": "openid profile email", "authorize_url": "https://auth.example.com/authorize", "client_id": "1example23456789", "client_secret": "provider-app-client-secret", "jwks_uri": "https://auth.example.com/.well-known/jwks.json", "oidc_issuer": "https://auth.example.com", "token_url": "https://example.com/token" }`
        - **SAML** - Create or update request with Metadata URL: `"ProviderDetails": { "IDPInit": "true", "IDPSignout": "true", "EncryptedResponses" : "true", "MetadataURL": "https://auth.example.com/sso/saml/metadata", "RequestSigningAlgorithm": "rsa-sha256" }`

        Create or update request with Metadata file: `"ProviderDetails": { "IDPInit": "true", "IDPSignout": "true", "EncryptedResponses" : "true", "MetadataFile": "[metadata XML]", "RequestSigningAlgorithm": "rsa-sha256" }`

        The value of `MetadataFile` must be the plaintext metadata document with all quote (") characters escaped by backslashes.

        Describe response: `"ProviderDetails": { "IDPInit": "true", "IDPSignout": "true", "EncryptedResponses" : "true", "ActiveEncryptionCertificate": "[certificate]", "MetadataURL": "https://auth.example.com/sso/saml/metadata", "RequestSigningAlgorithm": "rsa-sha256", "SLORedirectBindingURI": "https://auth.example.com/slo/saml", "SSORedirectBindingURI": "https://auth.example.com/sso/saml" }`
        - **LoginWithAmazon** - Create or update request: `"ProviderDetails": { "authorize_scopes": "profile postal_code", "client_id": "amzn1.application-oa2-client.1example23456789", "client_secret": "provider-app-client-secret"`

        Describe response: `"ProviderDetails": { "attributes_url": "https://api.amazon.com/user/profile", "attributes_url_add_attributes": "false", "authorize_scopes": "profile postal_code", "authorize_url": "https://www.amazon.com/ap/oa", "client_id": "amzn1.application-oa2-client.1example23456789", "client_secret": "provider-app-client-secret", "token_request_method": "POST", "token_url": "https://api.amazon.com/auth/o2/token" }`
        - **Google** - Create or update request: `"ProviderDetails": { "authorize_scopes": "email profile openid", "client_id": "1example23456789.apps.googleusercontent.com", "client_secret": "provider-app-client-secret" }`

        Describe response: `"ProviderDetails": { "attributes_url": "https://people.googleapis.com/v1/people/me?personFields=", "attributes_url_add_attributes": "true", "authorize_scopes": "email profile openid", "authorize_url": "https://accounts.google.com/o/oauth2/v2/auth", "client_id": "1example23456789.apps.googleusercontent.com", "client_secret": "provider-app-client-secret", "oidc_issuer": "https://accounts.google.com", "token_request_method": "POST", "token_url": "https://www.googleapis.com/oauth2/v4/token" }`
        - **SignInWithApple** - Create or update request: `"ProviderDetails": { "authorize_scopes": "email name", "client_id": "com.example.cognito", "private_key": "1EXAMPLE", "key_id": "2EXAMPLE", "team_id": "3EXAMPLE" }`

        Describe response: `"ProviderDetails": { "attributes_url_add_attributes": "false", "authorize_scopes": "email name", "authorize_url": "https://appleid.apple.com/auth/authorize", "client_id": "com.example.cognito", "key_id": "1EXAMPLE", "oidc_issuer": "https://appleid.apple.com", "team_id": "2EXAMPLE", "token_request_method": "POST", "token_url": "https://appleid.apple.com/auth/token" }`
        - **Facebook** - Create or update request: `"ProviderDetails": { "api_version": "v17.0", "authorize_scopes": "public_profile, email", "client_id": "1example23456789", "client_secret": "provider-app-client-secret" }`

        Describe response: `"ProviderDetails": { "api_version": "v17.0", "attributes_url": "https://graph.facebook.com/v17.0/me?fields=", "attributes_url_add_attributes": "true", "authorize_scopes": "public_profile, email", "authorize_url": "https://www.facebook.com/v17.0/dialog/oauth", "client_id": "1example23456789", "client_secret": "provider-app-client-secret", "token_request_method": "GET", "token_url": "https://graph.facebook.com/v17.0/oauth/access_token" }`

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::Cognito::UserPoolIdentityProvider` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "provider_details")


class AwaitableGetUserPoolIdentityProviderResult(GetUserPoolIdentityProviderResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserPoolIdentityProviderResult(
            attribute_mapping=self.attribute_mapping,
            id=self.id,
            idp_identifiers=self.idp_identifiers,
            provider_details=self.provider_details)


def get_user_pool_identity_provider(id: Optional[str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserPoolIdentityProviderResult:
    """
    Resource Type definition for AWS::Cognito::UserPoolIdentityProvider


    :param str id: The resource ID.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cognito:getUserPoolIdentityProvider', __args__, opts=opts, typ=GetUserPoolIdentityProviderResult).value

    return AwaitableGetUserPoolIdentityProviderResult(
        attribute_mapping=pulumi.get(__ret__, 'attribute_mapping'),
        id=pulumi.get(__ret__, 'id'),
        idp_identifiers=pulumi.get(__ret__, 'idp_identifiers'),
        provider_details=pulumi.get(__ret__, 'provider_details'))
def get_user_pool_identity_provider_output(id: Optional[pulumi.Input[str]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUserPoolIdentityProviderResult]:
    """
    Resource Type definition for AWS::Cognito::UserPoolIdentityProvider


    :param str id: The resource ID.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:cognito:getUserPoolIdentityProvider', __args__, opts=opts, typ=GetUserPoolIdentityProviderResult)
    return __ret__.apply(lambda __response__: GetUserPoolIdentityProviderResult(
        attribute_mapping=pulumi.get(__response__, 'attribute_mapping'),
        id=pulumi.get(__response__, 'id'),
        idp_identifiers=pulumi.get(__response__, 'idp_identifiers'),
        provider_details=pulumi.get(__response__, 'provider_details')))
