# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetUserPoolDomainResult',
    'AwaitableGetUserPoolDomainResult',
    'get_user_pool_domain',
    'get_user_pool_domain_output',
]

@pulumi.output_type
class GetUserPoolDomainResult:
    def __init__(__self__, cloud_front_distribution=None, custom_domain_config=None, id=None):
        if cloud_front_distribution and not isinstance(cloud_front_distribution, str):
            raise TypeError("Expected argument 'cloud_front_distribution' to be a str")
        pulumi.set(__self__, "cloud_front_distribution", cloud_front_distribution)
        if custom_domain_config and not isinstance(custom_domain_config, dict):
            raise TypeError("Expected argument 'custom_domain_config' to be a dict")
        pulumi.set(__self__, "custom_domain_config", custom_domain_config)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="cloudFrontDistribution")
    def cloud_front_distribution(self) -> Optional[str]:
        """
        The Amazon CloudFront endpoint that you use as the target of the alias that you set up with your Domain Name Service (DNS) provider.
        """
        return pulumi.get(self, "cloud_front_distribution")

    @property
    @pulumi.getter(name="customDomainConfig")
    def custom_domain_config(self) -> Optional['outputs.UserPoolDomainCustomDomainConfigType']:
        """
        The configuration for a custom domain that hosts the sign-up and sign-in pages for your application. Use this object to specify an SSL certificate that is managed by ACM.
        """
        return pulumi.get(self, "custom_domain_config")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource ID.
        """
        return pulumi.get(self, "id")


class AwaitableGetUserPoolDomainResult(GetUserPoolDomainResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserPoolDomainResult(
            cloud_front_distribution=self.cloud_front_distribution,
            custom_domain_config=self.custom_domain_config,
            id=self.id)


def get_user_pool_domain(id: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserPoolDomainResult:
    """
    Resource Type definition for AWS::Cognito::UserPoolDomain


    :param str id: The resource ID.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cognito:getUserPoolDomain', __args__, opts=opts, typ=GetUserPoolDomainResult).value

    return AwaitableGetUserPoolDomainResult(
        cloud_front_distribution=pulumi.get(__ret__, 'cloud_front_distribution'),
        custom_domain_config=pulumi.get(__ret__, 'custom_domain_config'),
        id=pulumi.get(__ret__, 'id'))
def get_user_pool_domain_output(id: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUserPoolDomainResult]:
    """
    Resource Type definition for AWS::Cognito::UserPoolDomain


    :param str id: The resource ID.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:cognito:getUserPoolDomain', __args__, opts=opts, typ=GetUserPoolDomainResult)
    return __ret__.apply(lambda __response__: GetUserPoolDomainResult(
        cloud_front_distribution=pulumi.get(__response__, 'cloud_front_distribution'),
        custom_domain_config=pulumi.get(__response__, 'custom_domain_config'),
        id=pulumi.get(__response__, 'id')))
