# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetIdentityPoolRoleAttachmentResult',
    'AwaitableGetIdentityPoolRoleAttachmentResult',
    'get_identity_pool_role_attachment',
    'get_identity_pool_role_attachment_output',
]

@pulumi.output_type
class GetIdentityPoolRoleAttachmentResult:
    def __init__(__self__, id=None, role_mappings=None, roles=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if role_mappings and not isinstance(role_mappings, dict):
            raise TypeError("Expected argument 'role_mappings' to be a dict")
        pulumi.set(__self__, "role_mappings", role_mappings)
        if roles and not isinstance(roles, dict):
            raise TypeError("Expected argument 'roles' to be a dict")
        pulumi.set(__self__, "roles", roles)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The resource ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="roleMappings")
    def role_mappings(self) -> Optional[Mapping[str, 'outputs.IdentityPoolRoleAttachmentRoleMapping']]:
        """
        How users for a specific identity provider are mapped to roles. This is a string to the `RoleMapping` object map. The string identifies the identity provider. For example: `graph.facebook.com` or `cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id` .

        If the `IdentityProvider` field isn't provided in this object, the string is used as the identity provider name.

        For more information, see the [RoleMapping property](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cognito-identitypoolroleattachment-rolemapping.html) .
        """
        return pulumi.get(self, "role_mappings")

    @property
    @pulumi.getter
    def roles(self) -> Optional[Mapping[str, str]]:
        """
        The map of the roles associated with this pool. For a given role, the key is either "authenticated" or "unauthenticated". The value is the role ARN.
        """
        return pulumi.get(self, "roles")


class AwaitableGetIdentityPoolRoleAttachmentResult(GetIdentityPoolRoleAttachmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIdentityPoolRoleAttachmentResult(
            id=self.id,
            role_mappings=self.role_mappings,
            roles=self.roles)


def get_identity_pool_role_attachment(id: Optional[str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIdentityPoolRoleAttachmentResult:
    """
    Resource Type definition for AWS::Cognito::IdentityPoolRoleAttachment


    :param str id: The resource ID.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:cognito:getIdentityPoolRoleAttachment', __args__, opts=opts, typ=GetIdentityPoolRoleAttachmentResult).value

    return AwaitableGetIdentityPoolRoleAttachmentResult(
        id=pulumi.get(__ret__, 'id'),
        role_mappings=pulumi.get(__ret__, 'role_mappings'),
        roles=pulumi.get(__ret__, 'roles'))
def get_identity_pool_role_attachment_output(id: Optional[pulumi.Input[str]] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIdentityPoolRoleAttachmentResult]:
    """
    Resource Type definition for AWS::Cognito::IdentityPoolRoleAttachment


    :param str id: The resource ID.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:cognito:getIdentityPoolRoleAttachment', __args__, opts=opts, typ=GetIdentityPoolRoleAttachmentResult)
    return __ret__.apply(lambda __response__: GetIdentityPoolRoleAttachmentResult(
        id=pulumi.get(__response__, 'id'),
        role_mappings=pulumi.get(__response__, 'role_mappings'),
        roles=pulumi.get(__response__, 'roles')))
